/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.acroform;

import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jpedal.PdfDecoder;
import org.jpedal.objects.PdfFormData;
import org.jpedal.utils.LogWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ExtractFormData {
    private String outputDir = System.getProperty("user.dir");
    private int fileCount = 0;
    static boolean outputMessages = false;
    String separator = System.getProperty("file.separator");
    PdfDecoder decodePdf = null;
    private boolean saveToFile = true;
    private Document doc;
    private static String test_file = "/PDFdata/files-jpedal/Testdokument PDF.pdf";

    public int getFileCount() {
        return this.fileCount;
    }

    public ExtractFormData() {
    }

    public ExtractFormData(String string) {
        File file;
        if (!this.outputDir.endsWith(this.separator)) {
            this.outputDir = this.outputDir + this.separator + "forms" + this.separator;
        }
        if (!(file = new File(this.outputDir)).exists()) {
            file.mkdirs();
        }
        if (string.toLowerCase().endsWith(".pdf")) {
            this.decodePage("", string);
        } else {
            String[] stringArray = null;
            File file2 = null;
            if (!string.endsWith(this.separator)) {
                string = string + this.separator;
            }
            try {
                file2 = new File(string);
                if (!file2.isDirectory()) {
                    System.err.println(string + " is not a directory. Exiting program");
                }
                stringArray = file2.list();
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception trying to access file " + exception.getMessage());
            }
            long l = stringArray.length;
            int n = 0;
            while ((long)n < l) {
                if (stringArray[n].toLowerCase().endsWith(".pdf")) {
                    if (outputMessages) {
                        System.out.println(">>_" + string + stringArray[n]);
                    }
                    this.decodePage(string, stringArray[n]);
                }
                ++n;
            }
        }
    }

    private void decodePage(String string, String string2) {
        String string3 = string + string2;
        try {
            this.decodePdf = new PdfDecoder(false);
            if (outputMessages) {
                System.out.println("Opening file :" + string3);
            }
            this.decodePdf.openPdfFile(string3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("Exception " + exception + " in pdf code with " + string3);
        }
        if (this.decodePdf.isEncrypted() && !this.decodePdf.isExtractionAllowed()) {
            if (outputMessages) {
                System.out.println("Encrypted settings");
                System.out.println("Please look at SimpleViewer for code sample to handle such files");
            }
        } else {
            ++this.fileCount;
            PdfFormData pdfFormData = this.decodePdf.getPdfFormData();
            if (outputMessages) {
                System.out.println(pdfFormData);
            }
            if (pdfFormData != null) {
                Object object;
                Object object2;
                Object object3;
                List list = pdfFormData.getFormData();
                String string4 = string2;
                int n = string4.lastIndexOf(46);
                if (n > 0) {
                    string4 = string4.substring(0, n);
                }
                if ((n = string4.lastIndexOf(47)) > 0) {
                    string4 = string4.substring(n + 1);
                }
                if ((n = string4.lastIndexOf(92)) > 0) {
                    string4 = string4.substring(n + 1);
                }
                String string5 = this.outputDir + string4 + ".xml";
                int n2 = list.size();
                DocumentBuilder documentBuilder = null;
                try {
                    object3 = DocumentBuilderFactory.newInstance();
                    documentBuilder = ((DocumentBuilderFactory)object3).newDocumentBuilder();
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    parserConfigurationException.printStackTrace();
                }
                this.doc = documentBuilder.newDocument();
                object3 = this.doc.createElement("Root");
                for (int i = 0; i < n2; ++i) {
                    object2 = (Map)list.get(i);
                    object = this.doc.createElement("Object" + i);
                    this.extractKeyValues((Map)object2, (Node)object);
                    object3.appendChild((Node)object);
                }
                this.doc.appendChild((Node)object3);
                InputStream inputStream = this.getClass().getResourceAsStream("/org/jpedal/examples/simpleviewer/res/xmlstyle.xslt");
                object2 = TransformerFactory.newInstance();
                try {
                    object = ((TransformerFactory)object2).newTransformer(new StreamSource(inputStream));
                    if (outputMessages) {
                        ((Transformer)object).transform(new DOMSource(this.doc), new StreamResult(System.out));
                    }
                    if (this.saveToFile) {
                        StreamResult streamResult = new StreamResult(string5);
                        ((Transformer)object).transform(new DOMSource(this.doc), streamResult);
                        if (outputMessages) {
                            System.out.println("Saved to " + string5);
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        this.decodePdf.closePdfFile();
    }

    private void extractKeyValues(Map map, Node node) {
        Object object;
        if (map.containsKey("startStreamOnDisk")) {
            int n = (Integer)map.get("startStreamOnDisk");
            int n2 = (Integer)map.get("endStreamOnDisk");
            object = this.decodePdf.getIO().readStreamFromPDF(n, n2);
            map.put("Stream", object);
            map.remove("startStreamOnDisk");
            map.remove("endStreamOnDisk");
        }
        Iterator iterator = map.keySet().iterator();
        object = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("P", "x");
        hashMap.put("Parent", "x");
        hashMap.put("obj", "x");
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            if (hashMap.containsKey(object)) continue;
            Object object2 = map.get(object);
            try {
                Object object3;
                Element element = this.doc.createElement((String)object);
                if (object2.toString().endsWith(" R")) {
                    object2 = this.decodePdf.resolveFormReference((String)object2);
                }
                if (object2 instanceof byte[]) {
                    object2 = this.decodePdf.getIO().getTextString((byte[])object2);
                    element.setAttribute("value", (String)object2);
                } else if (object2 instanceof Map) {
                    Map map2 = (Map)object2;
                    if (((String)object).equals("Kids")) {
                        object3 = map2.keySet().iterator();
                        while (object3.hasNext()) {
                            HashMap hashMap2 = new HashMap();
                            Object e = object3.next();
                            Object v = map2.get(e);
                            hashMap2.put("Kid", v);
                            this.extractKeyValues(hashMap2, element);
                        }
                    } else {
                        this.extractKeyValues(map2, element);
                    }
                } else {
                    object3 = (String)object2;
                    element.setAttribute("value", (String)object3);
                }
                node.appendChild(element);
            }
            catch (Exception exception) {
                System.out.println((String)object + " not valid as XML value");
            }
        }
    }

    public static void main(String[] stringArray) {
        File file;
        if (outputMessages) {
            System.out.println("Simple demo to extract form data");
        }
        String string = test_file;
        if (stringArray.length != 1) {
            if (outputMessages) {
                System.out.println("Default test file used");
            }
        } else {
            string = stringArray[0];
            if (outputMessages) {
                System.out.println("File :" + string);
            }
        }
        if (!(file = new File(string)).exists() && outputMessages) {
            System.out.println("File " + string + " not found");
        }
        ExtractFormData extractFormData = new ExtractFormData(string);
    }

    public String getOutputDir() {
        return this.outputDir;
    }
}

