/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer.utils;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jpedal.utils.LogWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PropertiesFile {
    private String separator = System.getProperty("file.separator");
    private String userDir = System.getProperty("user.dir");
    private String configFile = this.userDir + this.separator + ".properties.xml";
    private Document doc;
    private int noOfRecentDocs = 6;

    public PropertiesFile() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            if (new File(this.configFile).exists()) {
                try {
                    this.doc = documentBuilder.parse(this.configFile);
                }
                catch (Exception exception) {
                    this.doc = documentBuilder.newDocument();
                }
            } else {
                this.doc = documentBuilder.newDocument();
            }
            this.checkAllElementsPresent();
            this.writeDoc();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " generating properties file");
        }
    }

    public String[] getRecentDocuments() {
        String[] stringArray = new String[this.noOfRecentDocs];
        try {
            NodeList nodeList = this.doc.getElementsByTagName("recentfiles");
            ArrayList<String> arrayList = new ArrayList<String>();
            if (nodeList != null && nodeList.getLength() > 0) {
                NodeList nodeList2 = ((Element)nodeList.item(0)).getElementsByTagName("*");
                for (int i = 0; i < nodeList2.getLength(); ++i) {
                    Node node = nodeList2.item(i);
                    NamedNodeMap namedNodeMap = node.getAttributes();
                    arrayList.add(namedNodeMap.getNamedItem("name").getNodeValue());
                }
            }
            while (arrayList.size() > this.noOfRecentDocs) {
                arrayList.remove(0);
            }
            Collections.reverse(arrayList);
            stringArray = arrayList.toArray(new String[this.noOfRecentDocs]);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " getting recent documents");
            return null;
        }
        return stringArray;
    }

    public void addRecentDocument(String string) {
        try {
            Element element = (Element)this.doc.getElementsByTagName("recentfiles").item(0);
            this.checkExists(string, element);
            Element element2 = this.doc.createElement("file");
            element2.setAttribute("name", string);
            element.appendChild(element2);
            this.removeOldFiles(element);
            this.writeDoc();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " adding recent document to properties file");
        }
    }

    public void setValue(String string, String string2) {
        try {
            NodeList nodeList = this.doc.getElementsByTagName(string);
            Element element = (Element)nodeList.item(0);
            element.setAttribute("value", string2);
            this.writeDoc();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " setting value in properties file");
        }
    }

    public String getValue(String string) {
        NamedNodeMap namedNodeMap = null;
        try {
            NodeList nodeList = this.doc.getElementsByTagName(string);
            Element element = (Element)nodeList.item(0);
            if (element == null) {
                return "";
            }
            namedNodeMap = element.getAttributes();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " generating properties file");
            return "";
        }
        return namedNodeMap.getNamedItem("value").getNodeValue();
    }

    private void removeOldFiles(Element element) throws Exception {
        NodeList nodeList = element.getElementsByTagName("*");
        while (nodeList.getLength() > this.noOfRecentDocs) {
            element.removeChild(nodeList.item(0));
        }
    }

    private void checkExists(String string, Element element) throws Exception {
        NodeList nodeList = element.getElementsByTagName("*");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            NamedNodeMap namedNodeMap = node.getAttributes();
            String string2 = namedNodeMap.getNamedItem("name").getNodeValue();
            if (!string2.equals(string)) continue;
            element.removeChild(node);
        }
    }

    private void writeDoc() throws Exception {
        InputStream inputStream = this.getClass().getResourceAsStream("/org/jpedal/examples/simpleviewer/res/xmlstyle.xslt");
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer(new StreamSource(inputStream));
        transformer.transform(new DOMSource(this.doc), new StreamResult(this.configFile));
    }

    private void checkAllElementsPresent() throws Exception {
        Object object;
        NodeList nodeList = this.doc.getElementsByTagName("*");
        ArrayList<String> arrayList = new ArrayList<String>(nodeList.getLength());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            arrayList.add(nodeList.item(i).getNodeName());
        }
        Element element = null;
        if (arrayList.contains("properties")) {
            element = (Element)this.doc.getElementsByTagName("properties").item(0);
        } else {
            object = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = ((DocumentBuilderFactory)object).newDocumentBuilder();
            this.doc = documentBuilder.newDocument();
            element = this.doc.createElement("properties");
            this.doc.appendChild(element);
            nodeList = this.doc.getElementsByTagName("*");
            arrayList = new ArrayList(nodeList.getLength());
            for (int i = 0; i < nodeList.getLength(); ++i) {
                arrayList.add(nodeList.item(i).getNodeName());
            }
        }
        if (!arrayList.contains("recentfiles")) {
            object = this.doc.createElement("recentfiles");
            element.appendChild((Node)object);
        }
        if (!arrayList.contains("showfirsttimepopup")) {
            object = this.doc.createElement("showfirsttimepopup");
            object.setAttribute("value", "true");
            element.appendChild((Node)object);
        }
        if (!arrayList.contains("showsaveformsmessage")) {
            object = this.doc.createElement("showsaveformsmessage");
            object.setAttribute("value", "true");
            element.appendChild((Node)object);
        }
        if (!arrayList.contains("showitextmessage")) {
            object = this.doc.createElement("showitextmessage");
            object.setAttribute("value", "true");
            element.appendChild((Node)object);
        }
        if (!arrayList.contains("showddmessage")) {
            object = this.doc.createElement("showddmessage");
            object.setAttribute("value", "true");
            element.appendChild((Node)object);
        }
        if (!arrayList.contains("searchWindowType")) {
            object = this.doc.createElement("searchWindowType");
            object.setAttribute("value", "0");
            element.appendChild((Node)object);
        }
        if (!arrayList.contains("borderType")) {
            object = this.doc.createElement("borderType");
            object.setAttribute("value", "1");
            element.appendChild((Node)object);
        }
        if (!arrayList.contains("DPI")) {
            object = this.doc.createElement("DPI");
            object.setAttribute("value", "96");
            element.appendChild((Node)object);
        }
        if (!arrayList.contains("autoScroll")) {
            object = this.doc.createElement("autoScroll");
            object.setAttribute("value", "true");
            element.appendChild((Node)object);
        }
        if (!arrayList.contains("pageMode")) {
            object = this.doc.createElement("pageMode");
            object.setAttribute("value", String.valueOf(57));
            element.appendChild((Node)object);
        }
    }

    public int getNoRecentDocumentsToDisplay() {
        return this.noOfRecentDocs;
    }
}

