/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.jpedal.exception.PdfException;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.glyph.T3Glyph;
import org.jpedal.fonts.glyph.T3Glyphs;
import org.jpedal.fonts.glyph.T3Size;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.PdfPageData;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.LogWriter;

public class Type3
extends PdfFont {
    private GraphicsState currentGraphicsState;

    public Type3(PdfObjectReader pdfObjectReader, GraphicsState graphicsState) {
        this.glyphs = new T3Glyphs();
        this.init(pdfObjectReader);
        this.currentGraphicsState = graphicsState;
    }

    public final Map createFont(Map map, String string, boolean bl, Map map2, ObjectStore objectStore) throws Exception {
        LogWriter.writeMethod("{readType3Font}" + map, 0);
        this.fontTypes = 3;
        Map map3 = super.createFont(map, string, bl, map2, objectStore);
        this.readWidths(map);
        this.readEmbeddedFont(map, objectStore);
        if (bl) {
            this.setFont(this.getBaseFontName(), 1);
        }
        return map3;
    }

    private void readEmbeddedFont(Map map, ObjectStore objectStore) {
        boolean bl = false;
        Object v = map.get("CharProcs");
        if (v != null) {
            Map map2 = v instanceof String ? this.currentPdfFile.readObject((String)v, false, null) : (Map)v;
            Iterator iterator = map2.keySet().iterator();
            while (iterator.hasNext()) {
                Object object;
                String string = (String)iterator.next();
                String string2 = (String)map2.get(string);
                string = StandardFonts.convertNumberToGlyph(string);
                if (string2 == null || !this.renderPage) continue;
                PdfStreamDecoder pdfStreamDecoder = new PdfStreamDecoder(this.currentPdfFile, bl, true);
                pdfStreamDecoder.setStore(objectStore);
                Object v2 = map.get("Resources");
                if (v2 != null && (object = v2 instanceof Map ? (Map)v2 : this.currentPdfFile.getSubDictionary(v2)) != null) {
                    try {
                        pdfStreamDecoder.readResources(false, (Map)object, false);
                    }
                    catch (PdfException pdfException) {
                        pdfException.printStackTrace();
                    }
                }
                object = new DynamicVectorRenderer(0, false, 20, objectStore);
                ((DynamicVectorRenderer)object).setHiResImageForDisplayMode(bl);
                ((DynamicVectorRenderer)object).setType3Glyph(string);
                try {
                    pdfStreamDecoder.init(false, true, 7, 0, new PdfPageData(), 0, (DynamicVectorRenderer)object, this.currentPdfFile, new Hashtable(), new Hashtable());
                    pdfStreamDecoder.setDefaultColors(this.currentGraphicsState.getNonstrokeColor(), this.currentGraphicsState.getNonstrokeColor());
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Font exception " + exception);
                }
                int n = 0;
                int n2 = 0;
                try {
                    T3Size t3Size = pdfStreamDecoder.decodePageContent(string2, 0, 0, null);
                    n = t3Size.x;
                    n2 = t3Size.y;
                }
                catch (PdfException pdfException) {
                    pdfException.printStackTrace();
                }
                boolean bl2 = pdfStreamDecoder.ignoreColors;
                T3Glyph t3Glyph = new T3Glyph((DynamicVectorRenderer)object, n, n2, bl2, string);
                this.glyphs.setT3Glyph(string, t3Glyph);
            }
            this.isFontEmbedded = true;
        }
    }
}

