/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.rendering;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jpedal.PdfDecoder;
import org.jpedal.exception.PdfException;
import org.jpedal.external.LinkHandler;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.Javascript;
import org.jpedal.objects.PdfAnnots;
import org.jpedal.objects.PdfFormData;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.acroforms.actions.ActionHandler;
import org.jpedal.objects.acroforms.actions.DefaultActionHandler;
import org.jpedal.objects.acroforms.creation.DefaultFormFactory;
import org.jpedal.objects.acroforms.creation.FormFactory;
import org.jpedal.objects.acroforms.decoding.AnnotStream;
import org.jpedal.objects.acroforms.decoding.FormDecoder;
import org.jpedal.objects.acroforms.decoding.FormStream;
import org.jpedal.objects.acroforms.formData.FormObject;
import org.jpedal.objects.acroforms.formData.GUIData;
import org.jpedal.objects.acroforms.formData.SwingData;
import org.jpedal.objects.acroforms.rendering.AcroRenderer;

public class DefaultAcroRenderer
implements AcroRenderer {
    private static final boolean showFormsDecoded = false;
    private Map rawFormData = new HashMap();
    private List acroFormDataList;
    private static final boolean showMethods = false;
    private static final boolean identifyType = false;
    private static final boolean debug = false;
    private FormFactory formFactory;
    private GUIData compData = new SwingData();
    private Set sigObject = null;
    public static final int ANNOTATION = 1;
    public static final int FORM = 2;
    public static final int XFAFORM = 3;
    protected int formType = 0;
    private PdfPageData pageData;
    private int formCount = 0;
    private int fieldCount = 0;
    protected int pageCount = 0;
    private PdfObjectReader currentPdfFile;
    private FormDecoder formDecoder;
    private ActionHandler formsActionHandler;
    private LinkHandler linkHandler;
    private Javascript javascript;
    private int insetH;
    private Map formKids;

    public void resetHandler(Object object, PdfDecoder pdfDecoder, int n) {
        if (n == 5) {
            this.formsActionHandler = object != null ? (ActionHandler)object : new DefaultActionHandler();
            this.formsActionHandler.init(pdfDecoder, this.currentPdfFile, this.javascript, this);
            if (this.formFactory != null) {
                this.formFactory.reset(this, this.formsActionHandler);
                this.compData.resetDuplicates();
            }
        } else if (n == 7) {
            this.linkHandler = object != null ? (LinkHandler)object : null;
        }
    }

    public void removeDisplayComponentsFromScreen() {
        if (this.compData != null) {
            this.compData.removeAllComponentsFromScreen();
        }
    }

    public void init(Object object, int n, int n2, PdfPageData pdfPageData, PdfObjectReader pdfObjectReader, Map map) {
        this.insetH = n2;
        this.currentPdfFile = pdfObjectReader;
        this.pageData = pdfPageData;
        this.formKids = map;
        this.sigObject = null;
        boolean bl = true;
        this.compData.setPageData(pdfPageData, n, n2);
        if (object == null) {
            this.acroFormDataList = null;
            this.formCount = 0;
            this.fieldCount = 0;
        } else if (this.formType == 2) {
            PdfFormData pdfFormData = (PdfFormData)object;
            if (!pdfFormData.hasXFAFormData()) {
                this.formDecoder = new FormStream(pdfObjectReader);
            }
            this.acroFormDataList = pdfFormData.getFormData();
            this.formCount = pdfFormData.getTotalCount();
            this.fieldCount = this.acroFormDataList.size();
        } else if (this.formType == 1) {
            PdfAnnots pdfAnnots = (PdfAnnots)object;
            this.formDecoder = new AnnotStream(pdfObjectReader);
            this.acroFormDataList = pdfAnnots.getAnnotRawDataList();
            int n3 = this.acroFormDataList.size();
            this.formCount += n3;
            this.fieldCount = n3;
            bl = false;
        }
        this.resetContainers(bl);
    }

    protected void resetContainers(boolean bl) {
        if (bl) {
            if (this.formDecoder != null) {
                this.formDecoder.resetItems();
            }
            this.compData.resetComponents(this.formCount, this.pageCount, false);
        } else {
            this.compData.resetComponents(this.formCount, this.pageCount, true);
        }
        if (this.formFactory == null) {
            this.formFactory = new DefaultFormFactory(this, this.formsActionHandler);
        } else {
            this.formFactory.reset(this, this.formsActionHandler);
            this.compData.resetDuplicates();
        }
    }

    public void createDisplayComponentsForPage(int n) {
        if (this.compData.getStartComponentCountForPage(n) == -1) {
            int n2;
            this.compData.initParametersForPage(this.pageData, n);
            if (this.formsActionHandler != null) {
                this.formsActionHandler.setPageAccess(this.pageData.getMediaBoxHeight(n), this.insetH);
            }
            if (this.formType == 2) {
                this.formDecoder.resetItems();
            }
            boolean bl = this.formType == 3;
            Object var3_3 = null;
            FormObject[] formObjectArray = new FormObject[this.fieldCount];
            Object object = null;
            Map map = null;
            int n3 = 0;
            int n4 = this.fieldCount;
            for (n2 = this.fieldCount - 1; n2 > -1; --n2) {
                map = (Map)this.acroFormDataList.get(n2);
                if (n != this.getPageForComponent(n, map) || (object = this.formDecoder.createAppearanceString(map, this.currentPdfFile, n)) == null) continue;
                object.setPageNumber(n);
                formObjectArray[n3++] = object;
                this.rawFormData.put(object.getFieldName(), object);
            }
            if (var3_3 != null || !bl) {
                for (n2 = 0; n2 < n4; ++n2) {
                    object = bl ? var3_3[n2] : formObjectArray[n2];
                    if (object == null || n != object.getPageNumber()) continue;
                    this.createField((FormObject)object, this.compData.getNextFreeField(), false);
                }
            }
            this.compData.completeFields(n);
        }
    }

    public Object getFormDataAsObject(String string) {
        return this.rawFormData.get(string);
    }

    private int getPageForComponent(int n, Map map) {
        Object object;
        int n2 = -1;
        Object object2 = this.currentPdfFile.resolveToMapOrString("PageNumber", map.get("PageNumber"));
        if (object2 != null) {
            n2 = Integer.parseInt((String)object2);
        }
        if (n2 == -1 && this.formType == 1) {
            return n;
        }
        if (n2 == -1 && map.containsKey("Kids") && (object = this.currentPdfFile.resolveToMapOrString("Kids", map.get("Kids"))) instanceof Map) {
            Map map2 = (Map)object;
            Iterator iterator = map2.keySet().iterator();
            int n3 = 0;
            int n4 = -1;
            while (iterator.hasNext()) {
                Object object3;
                String string = (String)iterator.next();
                Object object4 = this.currentPdfFile.resolveToMapOrString(string, map2.get(string));
                if (object4 instanceof Map && (object3 = this.currentPdfFile.resolveToMapOrString("PageNumber", ((Map)object4).get("PageNumber"))) != null) {
                    n4 = Integer.parseInt((String)object3);
                }
                if (n4 == n) {
                    n2 = n4;
                }
                ++n3;
            }
        }
        return n2;
    }

    public void displayComponentsOnscreen(int n, int n2) {
        this.compData.displayComponents(n, ++n2);
    }

    private void createField(FormObject formObject, int n, boolean bl) {
        if (!bl) {
            this.compData.resetButtonGroup();
        }
        Integer n2 = FormFactory.UNKNOWN;
        Object object = null;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n3 = formObject.getType();
        if (n3 != -1) {
            bl2 = n3 == 0;
            bl3 = n3 == 2;
            bl4 = n3 == 1;
            boolean bl6 = bl5 = n3 == 3;
        }
        if (bl5) {
            if (this.sigObject == null) {
                this.sigObject = new HashSet();
            }
            this.sigObject.add(formObject);
        }
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean[] blArray = formObject.getFieldFlags();
        if (blArray != null) {
            bl7 = blArray[1];
            bl8 = blArray[2];
            bl9 = blArray[3];
        }
        if (bl2) {
            boolean bl10 = false;
            boolean bl11 = false;
            boolean bl12 = false;
            boolean bl13 = false;
            if (blArray != null) {
                bl10 = blArray[16];
                bl11 = blArray[15];
                bl12 = blArray[14];
                bl13 = blArray[25];
            }
            if (bl10) {
                n2 = FormFactory.PUSHBUTTON;
                object = this.formFactory.pushBut(formObject);
            } else {
                Object object2;
                Object object3;
                n2 = bl11 ? FormFactory.RADIOBUTTON : FormFactory.CHECKBOXBUTTON;
                if (formObject.getKidData() != null) {
                    object3 = formObject.getKidData();
                    object2 = object3.keySet().iterator();
                    while (object2.hasNext()) {
                        this.createField((FormObject)object3.get(object2.next()), ++n, true);
                    }
                }
                if ((object3 = formObject.getPDFRef()) != null && (object2 = (String)this.formKids.get(formObject.getPDFRef())) != null) {
                    formObject.setAnnotParent((String)object2);
                }
                object = bl11 ? this.formFactory.radioBut(formObject) : this.formFactory.checkBoxBut(formObject);
            }
        } else if (bl3) {
            boolean bl14 = false;
            boolean bl15 = false;
            boolean bl16 = false;
            boolean bl17 = false;
            boolean bl18 = false;
            boolean bl19 = false;
            if (blArray != null) {
                bl14 = blArray[12];
                bl15 = blArray[13];
                bl16 = blArray[23];
                bl17 = blArray[25];
                bl18 = blArray[20];
                bl19 = blArray[22];
            }
            if (bl14) {
                if (bl15) {
                    n2 = FormFactory.MULTILINEPASSWORD;
                    object = this.formFactory.multiLinePassword(formObject);
                } else {
                    n2 = FormFactory.MULTILINETEXT;
                    object = this.formFactory.multiLineText(formObject);
                }
            } else if (bl15) {
                n2 = FormFactory.SINGLELINEPASSWORD;
                object = this.formFactory.singleLinePassword(formObject);
            } else {
                n2 = FormFactory.SINGLELINETEXT;
                object = this.formFactory.singleLineText(formObject);
            }
        } else if (bl4) {
            boolean bl20 = false;
            boolean bl21 = false;
            boolean bl22 = false;
            boolean bl23 = false;
            boolean bl24 = false;
            boolean bl25 = false;
            if (blArray != null) {
                bl20 = blArray[17];
                bl21 = blArray[21];
                bl22 = blArray[19];
                bl23 = blArray[18];
                bl24 = blArray[22];
                bl25 = blArray[26];
            }
            if (bl20) {
                n2 = FormFactory.COMBOBOX;
                object = this.formFactory.comboBox(formObject);
            } else {
                n2 = FormFactory.LIST;
                object = this.formFactory.listField(formObject);
            }
        } else if (bl5) {
            n2 = FormFactory.SIGNATURE;
            object = this.formFactory.signature(formObject);
        } else if (this.formType == 1) {
            n2 = FormFactory.ANNOTATION;
            object = this.formFactory.annotationButton(formObject);
        }
        this.compData.completeField(formObject, n, bl, n2, object);
    }

    public void setJavaScriptObject(Javascript javascript, Object object) {
        this.javascript = javascript;
        if (this.compData != null) {
            this.compData.setJavascript(javascript);
        }
    }

    public Object[] getComponentsByName(String string) {
        for (int i = 1; i < this.pageCount + 1; ++i) {
            this.createDisplayComponentsForPage(i);
        }
        return this.compData.getComponentsByName(string);
    }

    public List getComponentNameList() throws PdfException {
        if (this.fieldCount == 0) {
            return null;
        }
        for (int i = 1; i < this.pageCount + 1; ++i) {
            this.createDisplayComponentsForPage(i);
        }
        return this.getComponentNameList(-1);
    }

    public List getComponentNameList(int n) throws PdfException {
        if (this.fieldCount == 0) {
            return null;
        }
        return this.compData.getComponentNameList(n);
    }

    public void setFormFactory(FormFactory formFactory) {
        System.out.println("setFormFactory " + formFactory);
        this.formFactory = formFactory;
        this.compData = this.formFactory.getCustomCompData();
        this.compData.setJavascript(this.javascript);
    }

    public void openFile(int n) {
        this.pageCount = n;
        this.formType = 2;
        this.compData.reset();
        this.rawFormData.clear();
    }

    public Map getSignatureObject(String string) {
        Map map = this.currentPdfFile.readObject(string, false, null);
        Object v = map.get("V");
        if (v == null) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Name", "x");
        hashMap.put("Reason", "x");
        hashMap.put("Location", "x");
        hashMap.put("M", "x");
        hashMap.put("Cert", "x");
        map = v instanceof String ? this.currentPdfFile.readObject((String)v, false, hashMap) : (Map)v;
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            byte[] byArray = (byte[])map.get(k);
            if (byArray == null || k.equals("Cert")) continue;
            map.put(k, this.currentPdfFile.getTextString(byArray));
        }
        return map;
    }

    public GUIData getCompData() {
        return this.compData;
    }

    public Iterator getSignatureObjects() {
        if (this.sigObject == null) {
            return null;
        }
        return this.sigObject.iterator();
    }

    public ActionHandler getActionHandler() {
        return this.formsActionHandler;
    }
}

