/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects;

import java.io.Serializable;
import java.util.StringTokenizer;
import org.jpedal.utils.Strip;
import org.jpedal.utils.repositories.Vector_Float;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_String;

public class PdfPageData
implements Serializable {
    private static final String SEPARATOR = "|";
    private static final String ROTATION_SEPARATOR = "/";
    private static final boolean debug = false;
    private boolean valuesSet = false;
    private boolean useCustomRounding = true;
    private Vector_Int rotationXX;
    private Vector_String mediaString;
    private Vector_String cropString;
    private Vector_Float mediaBoxWidths;
    private Vector_Float mediaBoxHeights;
    private Vector_Float mediaBoxXs;
    private Vector_Float mediaBoxYs;
    private Vector_Float cropBoxWidths;
    private Vector_Float cropBoxHeights;
    private Vector_Float cropBoxXs;
    private Vector_Float cropBoxYs;
    private int lastPage = -1;
    private int raw_rotation = 0;
    private int pagesRead = -1;
    private String defaultMediaValue = null;
    private int rotation = 0;
    private Vector_String rawValues = new Vector_String(500);
    private float cropBoxX = -99999.0f;
    private float cropBoxY = -1.0f;
    private float cropBoxW = -1.0f;
    private float cropBoxH = -1.0f;
    private float mediaBoxX = -1.0f;
    private float mediaBoxY;
    private float mediaBoxW;
    private float mediaBoxH;
    private String cropValue = "";
    private float scalingValue = 1.0f;
    private String mediaValue = "";
    private int defaultrotation;
    private float defaultcropBoxX;
    private float defaultcropBoxY;
    private float defaultcropBoxW;
    private float defaultcropBoxH;
    private float defaultmediaBoxX;
    private float defaultmediaBoxY;
    private float defaultmediaBoxW;
    private float defaultmediaBoxH;

    public PdfPageData(float f) {
        this.scalingValue = f;
    }

    public PdfPageData() {
    }

    public void checkSizeSet(int n) {
        StringBuffer stringBuffer;
        if (this.mediaValue == null) {
            this.mediaValue = this.defaultMediaValue;
        }
        if (this.raw_rotation != 0) {
            stringBuffer = new StringBuffer(String.valueOf(this.raw_rotation));
            stringBuffer.append(ROTATION_SEPARATOR);
            int n2 = this.mediaValue.lastIndexOf(ROTATION_SEPARATOR);
            if (n2 == -1) {
                stringBuffer.append(this.mediaValue);
            } else {
                stringBuffer.append(this.mediaValue.substring(n2 + 1));
            }
            this.mediaValue = stringBuffer.toString();
        }
        if (this.cropValue != null && !this.mediaValue.equals(this.cropValue)) {
            stringBuffer = new StringBuffer(this.mediaValue);
            stringBuffer.append(SEPARATOR);
            stringBuffer.append(this.cropValue);
            this.rawValues.setElementAt(stringBuffer.toString(), n);
        } else if (this.mediaValue != null && this.mediaValue.equals(this.defaultMediaValue)) {
            this.rawValues.setElementAt(null, n);
        } else {
            this.rawValues.setElementAt(this.mediaValue, n);
        }
        if (this.pagesRead < n) {
            this.pagesRead = n;
        }
        this.mediaValue = null;
        this.cropValue = null;
    }

    public final int getMediaBoxHeight(int n) {
        this.setSizeForPage(n);
        return (int)this.mediaBoxH;
    }

    public final int getMediaBoxY(int n) {
        this.setSizeForPage(n);
        return (int)this.mediaBoxY;
    }

    public final int getMediaBoxX(int n) {
        this.setSizeForPage(n);
        return (int)this.mediaBoxX;
    }

    public void setMediaBox(String string) {
        this.mediaValue = Strip.removeArrayDeleminators(string);
        this.cropValue = null;
        if (this.defaultMediaValue == null) {
            this.defaultMediaValue = this.mediaValue;
        }
    }

    public void setCropBox(String string) {
        this.cropValue = Strip.removeArrayDeleminators(string);
    }

    public int setPageRotation(String string, int n) {
        this.raw_rotation = Integer.parseInt(string);
        if (this.raw_rotation < 0) {
            this.raw_rotation = 360 + this.raw_rotation;
        }
        return this.raw_rotation;
    }

    public final int getMediaBoxWidth(int n) {
        this.setSizeForPage(n);
        return (int)this.mediaBoxW;
    }

    public String getMediaValue(int n) {
        int n2;
        int n3;
        String string = this.rawValues.elementAt(n);
        if (string.length() == 0) {
            string = this.defaultMediaValue;
        }
        if ((n3 = string.indexOf(ROTATION_SEPARATOR)) != -1) {
            string = string.substring(n3 + 1);
        }
        if ((n2 = string.indexOf(SEPARATOR)) == -1) {
            return string;
        }
        return string.substring(0, n2);
    }

    public String getCropValue(int n) {
        int n2;
        int n3;
        String string = this.rawValues.elementAt(n);
        if (string.length() == 0) {
            string = this.defaultMediaValue;
        }
        if ((n3 = string.indexOf(ROTATION_SEPARATOR)) != -1) {
            string = string.substring(n3 + 1);
        }
        if ((n2 = string.indexOf(SEPARATOR)) == -1) {
            return string;
        }
        return string.substring(n2 + 1);
    }

    public int getScaledCropBoxX(int n) {
        this.setSizeForPage(n);
        return this.roundFloat(this.cropBoxX * this.scalingValue);
    }

    public int getScaledCropBoxWidth(int n) {
        this.setSizeForPage(n);
        return this.roundFloat(this.cropBoxW * this.scalingValue);
    }

    public int getScaledCropBoxY(int n) {
        this.setSizeForPage(n);
        return this.roundFloat(this.cropBoxY * this.scalingValue);
    }

    public int getScaledCropBoxHeight(int n) {
        this.setSizeForPage(n);
        return this.roundFloat(this.cropBoxH * this.scalingValue);
    }

    public int getCropBoxX(int n) {
        this.setSizeForPage(n);
        return (int)this.cropBoxX;
    }

    public int getCropBoxWidth(int n) {
        this.setSizeForPage(n);
        return (int)this.cropBoxW;
    }

    public int getCropBoxY(int n) {
        this.setSizeForPage(n);
        return (int)this.cropBoxY;
    }

    public int getCropBoxHeight(int n) {
        this.setSizeForPage(n);
        return (int)this.cropBoxH;
    }

    private void setSizeForPage(int n) {
        if (n > this.pagesRead) {
            this.mediaBoxX = 0.0f;
            this.mediaBoxY = 0.0f;
            this.mediaBoxW = 0.0f;
            this.mediaBoxH = 0.0f;
            this.cropBoxX = 0.0f;
            this.cropBoxY = 0.0f;
            this.cropBoxW = 0.0f;
            this.cropBoxH = 0.0f;
        } else if (n > 0 && this.lastPage != n) {
            this.lastPage = n;
            this.rotation = 0;
            boolean bl = false;
            String string = this.rawValues.elementAt(n);
            if (string.length() == 0 && this.defaultMediaValue != null) {
                string = this.defaultMediaValue;
                bl = true;
            }
            if (this.valuesSet && bl) {
                this.rotation = this.defaultrotation;
                this.cropBoxX = this.defaultcropBoxX;
                this.mediaBoxX = this.defaultmediaBoxX;
                this.cropBoxY = this.defaultcropBoxY;
                this.mediaBoxY = this.defaultmediaBoxY;
                this.cropBoxW = this.defaultcropBoxW;
                this.mediaBoxW = this.defaultmediaBoxW;
                this.cropBoxH = this.defaultcropBoxH;
                this.mediaBoxH = this.defaultmediaBoxH;
            } else {
                int n2;
                int n3 = string.indexOf(ROTATION_SEPARATOR);
                if (n3 != -1) {
                    String string2 = string.substring(0, n3);
                    this.rotation = Integer.parseInt(string2);
                    string = string.substring(n3 + 1);
                }
                StringTokenizer stringTokenizer = (n2 = string.indexOf(SEPARATOR)) == -1 ? new StringTokenizer(string, " ") : new StringTokenizer(string.substring(0, n2), " ");
                this.mediaBoxX = 0.0f;
                this.mediaBoxY = 0.0f;
                this.mediaBoxW = 800.0f;
                this.mediaBoxH = 800.0f;
                if (stringTokenizer.countTokens() == 4) {
                    this.mediaBoxX = Float.parseFloat(stringTokenizer.nextToken());
                    this.mediaBoxY = Float.parseFloat(stringTokenizer.nextToken());
                    this.mediaBoxW = Float.parseFloat(stringTokenizer.nextToken()) - this.mediaBoxX;
                    this.mediaBoxH = Float.parseFloat(stringTokenizer.nextToken()) - this.mediaBoxY;
                }
                if (n2 != -1) {
                    float f;
                    stringTokenizer = new StringTokenizer(string.substring(n2 + 1), " ");
                    this.cropBoxX = Float.parseFloat(stringTokenizer.nextToken());
                    this.cropBoxY = Float.parseFloat(stringTokenizer.nextToken());
                    this.cropBoxW = Float.parseFloat(stringTokenizer.nextToken());
                    this.cropBoxH = Float.parseFloat(stringTokenizer.nextToken());
                    if (this.cropBoxX > this.cropBoxW) {
                        f = this.cropBoxX;
                        this.cropBoxX = this.cropBoxW;
                        this.cropBoxW = f;
                    }
                    if (this.cropBoxY > this.cropBoxH) {
                        f = this.cropBoxY;
                        this.cropBoxY = this.cropBoxH;
                        this.cropBoxH = f;
                    }
                    this.cropBoxW -= this.cropBoxX;
                    this.cropBoxH -= this.cropBoxY;
                } else {
                    this.cropBoxX = this.mediaBoxX;
                    this.cropBoxY = this.mediaBoxY;
                    this.cropBoxW = this.mediaBoxW;
                    this.cropBoxH = this.mediaBoxH;
                }
            }
            if (bl && !this.valuesSet) {
                this.defaultrotation = this.rotation;
                this.defaultcropBoxX = this.cropBoxX;
                this.defaultmediaBoxX = this.mediaBoxX;
                this.defaultcropBoxY = this.cropBoxY;
                this.defaultmediaBoxY = this.mediaBoxY;
                this.defaultcropBoxW = this.cropBoxW;
                this.defaultmediaBoxW = this.mediaBoxW;
                this.defaultcropBoxH = this.cropBoxH;
                this.defaultmediaBoxH = this.mediaBoxH;
                this.valuesSet = true;
            }
        }
    }

    public float getScalingValue() {
        return this.scalingValue;
    }

    public void setScalingValue(float f) {
        this.scalingValue = f;
    }

    private int roundFloat(float f) {
        float f2;
        int n = (int)f;
        if (this.useCustomRounding && (double)(f2 = f - (float)n) > 0.3) {
            ++n;
        }
        return n;
    }

    public final int getRotation(int n) {
        this.setSizeForPage(n);
        return this.rotation;
    }

    public final int getScaledMediaBoxHeight(int n) {
        this.setSizeForPage(n);
        return this.roundFloat(this.mediaBoxH * this.scalingValue);
    }

    public final int getScaledMediaBoxWidth(int n) {
        this.setSizeForPage(n);
        return this.roundFloat(this.mediaBoxW * this.scalingValue);
    }

    public final int getScaledMediaBoxX(int n) {
        this.setSizeForPage(n);
        return this.roundFloat(this.mediaBoxX * this.scalingValue);
    }

    public final int getScaledMediaBoxY(int n) {
        this.setSizeForPage(n);
        return this.roundFloat(this.mediaBoxY * this.scalingValue);
    }
}

