/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.database;

import com.pixelmed.database.DatabaseInformationModel;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomInputStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Constructor;

public class RebuildDatabaseFromInstanceFiles {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/database/RebuildDatabaseFromInstanceFiles.java,v 1.4 2007/08/01 11:41:23 dclunie Exp $";

    private static void processFileOrDirectory(DatabaseInformationModel databaseInformationModel, File file) {
        if (file.isDirectory() && !file.getName().toUpperCase().equals("CVS")) {
            System.err.println("Recursing into directory " + file);
            try {
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    RebuildDatabaseFromInstanceFiles.processFileOrDirectory(databaseInformationModel, fileArray[i]);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        } else if (file.isFile()) {
            if (!file.isHidden()) {
                System.err.println("Doing file " + file);
                try {
                    DicomInputStream dicomInputStream = new DicomInputStream(new BufferedInputStream(new FileInputStream(file)));
                    AttributeList attributeList = new AttributeList();
                    attributeList.read(dicomInputStream);
                    dicomInputStream.close();
                    databaseInformationModel.insertObject(attributeList, file.getAbsolutePath());
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                }
            } else {
                System.err.println("Skipping hidden " + file);
            }
        } else {
            System.err.println("Not a directory or file " + file);
        }
    }

    public static void main(String[] stringArray) {
        RebuildDatabaseFromInstanceFiles rebuildDatabaseFromInstanceFiles = new RebuildDatabaseFromInstanceFiles();
        if (stringArray.length >= 3) {
            Object object;
            Object object2;
            String string = stringArray[0];
            String string2 = stringArray[1];
            if (string.indexOf(46) == -1) {
                string = "com.pixelmed.database." + string;
            }
            DatabaseInformationModel databaseInformationModel = null;
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(string);
                object2 = new Class[]{string2.getClass()};
                object = clazz.getConstructor((Class<?>)object2);
                Object[] objectArray = new Object[]{string2};
                databaseInformationModel = (DatabaseInformationModel)((Constructor)object).newInstance(objectArray);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
                System.exit(0);
            }
            int n = 2;
            while (n < stringArray.length) {
                object2 = stringArray[n++];
                object = new File((String)object2);
                RebuildDatabaseFromInstanceFiles.processFileOrDirectory(databaseInformationModel, (File)object);
            }
        } else {
            System.err.println("Usage: java com.pixelmed.database.RebuildDatabaseFromInstanceFiles databaseModelClassName databaseFilePathPrefix databaseFileName path(s)");
        }
    }
}

