/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.BinaryOutputStream;
import com.pixelmed.dicom.TransferSyntax;
import java.io.IOException;
import java.io.OutputStream;

public class DicomOutputStream
extends BinaryOutputStream {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/DicomOutputStream.java,v 1.8 2003/10/19 17:39:59 dclunie Exp $";
    private static final byte[] preamble = new byte[128];
    private static final byte[] DICM = "DICM".getBytes();
    private TransferSyntax transferSyntaxToWriteDataSet;
    private TransferSyntax transferSyntaxToWriteMetaHeader;
    private TransferSyntax transferSyntaxInUse;
    private boolean writingDataSet;
    private long byteOffsetOfStartOfData;

    private void initializeTransferSyntax(String string, String string2) throws IOException {
        this.transferSyntaxToWriteMetaHeader = string == null ? null : new TransferSyntax(string);
        TransferSyntax transferSyntax = this.transferSyntaxToWriteDataSet = string2 == null ? null : new TransferSyntax(string2);
        if (this.transferSyntaxToWriteMetaHeader != null) {
            this.write(preamble, 0, 128);
            this.write(DICM, 0, 4);
            this.setWritingMetaHeader();
            this.byteOffsetOfStartOfData = 132L;
        } else {
            this.setWritingDataSet();
            this.byteOffsetOfStartOfData = 0L;
        }
    }

    public DicomOutputStream(OutputStream outputStream, String string, String string2) throws IOException {
        super(outputStream, false);
        this.initializeTransferSyntax(string, string2);
    }

    public void setTransferSyntaxToWriteDataSet(TransferSyntax transferSyntax) {
        this.transferSyntaxToWriteDataSet = transferSyntax;
    }

    public void setWritingDataSet() {
        this.transferSyntaxInUse = this.transferSyntaxToWriteDataSet;
        this.setEndian(this.transferSyntaxInUse.isBigEndian());
        this.writingDataSet = true;
    }

    public boolean areWritingDataSet() {
        return this.writingDataSet;
    }

    public void setWritingMetaHeader() {
        this.transferSyntaxInUse = this.transferSyntaxToWriteMetaHeader;
        this.setEndian(this.transferSyntaxInUse.isBigEndian());
        this.writingDataSet = false;
    }

    public boolean areWritingMetaHeader() {
        return !this.writingDataSet;
    }

    public boolean haveMetaHeader() {
        return this.transferSyntaxToWriteMetaHeader != null;
    }

    public TransferSyntax getTransferSyntaxInUse() {
        return this.transferSyntaxInUse;
    }

    public TransferSyntax getTransferSyntaxToWriteDataSet() {
        return this.transferSyntaxToWriteDataSet;
    }

    public TransferSyntax getTransferSyntaxToWriteMetaHeader() {
        return this.transferSyntaxToWriteMetaHeader;
    }

    public long getByteOffsetOfStartOfData() {
        return this.byteOffsetOfStartOfData;
    }

    public boolean isExplicitVR() {
        return this.transferSyntaxInUse.isExplicitVR();
    }

    public boolean isImplicitVR() {
        return this.transferSyntaxInUse.isImplicitVR();
    }
}

