/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.ArrayCopyUtilities;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.DicomOutputStream;
import com.pixelmed.dicom.ValueRepresentation;
import com.pixelmed.utils.FloatFormatter;
import java.io.IOException;
import java.text.NumberFormat;

public class FloatDoubleAttribute
extends Attribute {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/FloatDoubleAttribute.java,v 1.18 2008/02/21 04:45:04 dclunie Exp $";
    double[] values;
    static int bytesPerValue = 8;

    private void flushCachedCopies() {
    }

    public FloatDoubleAttribute(AttributeTag attributeTag) {
        super(attributeTag);
        this.flushCachedCopies();
        this.values = null;
    }

    public FloatDoubleAttribute(AttributeTag attributeTag, long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        super(attributeTag);
        this.doCommonConstructorStuff(l, dicomInputStream);
    }

    public FloatDoubleAttribute(AttributeTag attributeTag, Long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        super(attributeTag);
        this.doCommonConstructorStuff(l, dicomInputStream);
    }

    private void doCommonConstructorStuff(long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        this.flushCachedCopies();
        if (l % (long)bytesPerValue != 0L) {
            throw new DicomException("incorrect value length for VR " + this.getVR());
        }
        int n = (int)(l / (long)bytesPerValue);
        this.values = null;
        for (int i = 0; i < n; ++i) {
            this.addValue(dicomInputStream.readDouble());
        }
    }

    public void write(DicomOutputStream dicomOutputStream) throws DicomException, IOException {
        this.writeBase(dicomOutputStream);
        double[] dArray = this.getDoubleValues();
        if (dArray != null) {
            for (int i = 0; i < dArray.length; ++i) {
                dicomOutputStream.writeDouble(dArray[i]);
            }
        }
    }

    public String toString(DicomDictionary dicomDictionary) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString(dicomDictionary));
        stringBuffer.append(" [");
        try {
            double[] dArray = this.getDoubleValues();
            if (dArray != null) {
                for (int i = 0; i < dArray.length; ++i) {
                    if (i > 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(dArray[i]);
                }
            }
        }
        catch (DicomException dicomException) {
            stringBuffer.append("XXXX");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public String[] getStringValues(NumberFormat numberFormat) throws DicomException {
        String[] stringArray = null;
        double[] dArray = this.getDoubleValues();
        if (dArray != null) {
            stringArray = new String[dArray.length];
            for (int i = 0; i < dArray.length; ++i) {
                stringArray[i] = numberFormat == null ? FloatFormatter.toString(dArray[i]) : numberFormat.format(dArray[i]);
            }
        }
        return stringArray;
    }

    public double[] getDoubleValues() throws DicomException {
        return this.values;
    }

    public void addValue(double d) throws DicomException {
        this.flushCachedCopies();
        this.values = ArrayCopyUtilities.expandArray(this.values);
        this.values[this.valueMultiplicity++] = d;
        this.valueLength += 8L;
    }

    public void addValue(float f) throws DicomException {
        this.addValue((double)f);
    }

    public void addValue(short s) throws DicomException {
        this.addValue((double)s);
    }

    public void addValue(int n) throws DicomException {
        this.addValue((double)n);
    }

    public void addValue(long l) throws DicomException {
        this.addValue((double)l);
    }

    public void addValue(String string) throws DicomException {
        this.flushCachedCopies();
        double d = 0.0;
        try {
            d = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new DicomException(numberFormatException.toString());
        }
        this.addValue(d);
    }

    public void removeValues() {
        this.flushCachedCopies();
        this.values = null;
        this.valueMultiplicity = 0;
        this.valueLength = 0L;
    }

    public byte[] getVR() {
        return ValueRepresentation.FD;
    }
}

