/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.DicomOutputStream;
import com.pixelmed.dicom.ValueRepresentation;
import com.pixelmed.utils.CopyStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class OtherWordAttributeOnDisk
extends Attribute {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/OtherWordAttributeOnDisk.java,v 1.4 2008/02/21 04:45:04 dclunie Exp $";
    protected long byteOffset;
    protected File file;
    protected boolean bigEndian;

    public OtherWordAttributeOnDisk(AttributeTag attributeTag) {
        super(attributeTag);
        this.byteOffset = 0L;
        this.file = null;
        this.bigEndian = false;
    }

    public OtherWordAttributeOnDisk(AttributeTag attributeTag, long l, DicomInputStream dicomInputStream, long l2) throws IOException, DicomException {
        super(attributeTag);
        this.doCommonConstructorStuff(l, dicomInputStream, l2);
    }

    public OtherWordAttributeOnDisk(AttributeTag attributeTag, Long l, DicomInputStream dicomInputStream, Long l2) throws IOException, DicomException {
        super(attributeTag);
        this.doCommonConstructorStuff(l, dicomInputStream, l2);
    }

    private void doCommonConstructorStuff(long l, DicomInputStream dicomInputStream, long l2) throws IOException, DicomException {
        this.valueLength = l;
        this.byteOffset = l2;
        this.file = dicomInputStream.getFile();
        this.bigEndian = dicomInputStream.isBigEndian();
        if (this.file == null) {
            throw new DicomException("Cannot have an OtherWordAttributeOnDisk without a file available in the DicomInputStream");
        }
        if (l > 0L) {
            try {
                dicomInputStream.skipInsistently(l);
            }
            catch (IOException iOException) {
                throw new DicomException("Failed to skip value (length " + l + " dec) in " + ValueRepresentation.getAsString(this.getVR()) + " attribute " + this.getTag());
            }
        }
    }

    public void write(DicomOutputStream dicomOutputStream) throws DicomException, IOException {
        this.writeBase(dicomOutputStream);
        if (this.valueLength > 0L) {
            System.err.println("OtherWordAttributeOnDisk.write(): start file = " + this.file);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(this.file));
            CopyStream.skipInsistently(bufferedInputStream, this.byteOffset);
            if (this.bigEndian == dicomOutputStream.isBigEndian()) {
                CopyStream.copy(bufferedInputStream, dicomOutputStream, this.valueLength);
            } else {
                CopyStream.copyByteSwapped(bufferedInputStream, dicomOutputStream, this.valueLength);
            }
            bufferedInputStream.close();
        }
    }

    public String toString(DicomDictionary dicomDictionary) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString(dicomDictionary));
        stringBuffer.append(" []");
        return stringBuffer.toString();
    }

    public long getByteOffset() {
        return this.byteOffset;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public boolean isBigEndian() {
        return this.bigEndian;
    }

    public void removeValues() {
        this.file = null;
        this.byteOffset = 0L;
        this.valueMultiplicity = 0;
        this.valueLength = 0L;
    }

    public byte[] getVR() {
        return ValueRepresentation.OW;
    }
}

