/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomOutputStream;
import java.io.IOException;

public class SequenceItem {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/SequenceItem.java,v 1.8 2008/02/21 04:56:41 dclunie Exp $";
    private AttributeList list;
    protected long byteOffset;

    public SequenceItem(AttributeList attributeList) {
        this.list = attributeList;
        this.byteOffset = 0L;
    }

    public SequenceItem(AttributeList attributeList, long l) {
        this.list = attributeList;
        this.byteOffset = l;
    }

    public AttributeList getAttributeList() {
        return this.list;
    }

    public long getByteOffset() {
        return this.byteOffset;
    }

    public void write(DicomOutputStream dicomOutputStream) throws DicomException, IOException {
        this.byteOffset = dicomOutputStream.getByteOffset();
        dicomOutputStream.writeUnsigned16(65534);
        dicomOutputStream.writeUnsigned16(57344);
        dicomOutputStream.writeUnsigned32(0xFFFFFFFFL);
        this.getAttributeList().write(dicomOutputStream, true);
        dicomOutputStream.writeUnsigned16(65534);
        dicomOutputStream.writeUnsigned16(57357);
        dicomOutputStream.writeUnsigned32(0L);
    }

    public String toString(DicomDictionary dicomDictionary) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("%item");
        if (this.byteOffset != 0L) {
            stringBuffer.append(" [starts at 0x");
            stringBuffer.append(Long.toHexString(this.byteOffset));
            stringBuffer.append("]");
        }
        stringBuffer.append("\n");
        stringBuffer.append(this.list.toString(dicomDictionary));
        stringBuffer.append("%enditem");
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(null);
    }
}

