/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.display;

import com.pixelmed.utils.FileUtilities;
import com.sun.image.codec.jpeg.JPEGCodec;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import javax.swing.JFrame;
import javax.swing.UIManager;

public class ApplicationFrame
extends JFrame {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/display/ApplicationFrame.java,v 1.22 2007/12/19 22:44:14 dclunie Exp $";
    private Properties applicationProperties;
    private String applicationPropertyFileName;

    protected static String makePathToFileInUsersHomeDirectory(String string) {
        return FileUtilities.makePathToFileInUsersHomeDirectory(string);
    }

    protected void loadProperties() {
        this.applicationProperties = new Properties();
        if (this.applicationPropertyFileName != null) {
            String string = ApplicationFrame.makePathToFileInUsersHomeDirectory(this.applicationPropertyFileName);
            try {
                FileInputStream fileInputStream = new FileInputStream(string);
                this.applicationProperties.load(fileInputStream);
                fileInputStream.close();
            }
            catch (IOException iOException) {
                System.err.println(iOException);
            }
        }
    }

    protected void storeProperties(String string) throws IOException {
        if (this.applicationPropertyFileName == null) {
            throw new IOException("asked to store properties but no applicationPropertyFileName was ever set");
        }
        String string2 = ApplicationFrame.makePathToFileInUsersHomeDirectory(this.applicationPropertyFileName);
        FileOutputStream fileOutputStream = new FileOutputStream(string2);
        this.applicationProperties.store(fileOutputStream, string);
        fileOutputStream.close();
    }

    protected Properties getProperties() {
        return this.applicationProperties;
    }

    protected String getApplicationPropertyFileName() {
        return this.applicationPropertyFileName;
    }

    protected void setApplicationPropertyFileName(String string) {
        this.applicationPropertyFileName = string;
    }

    public static String getPropertyInsistently(Properties properties, String string) throws Exception {
        String string2 = properties.getProperty(string);
        if (string2 == null || string2.length() == 0) {
            throw new Exception("Properties do not contain value for " + string);
        }
        return string2;
    }

    public String getPropertyInsistently(String string) throws Exception {
        return ApplicationFrame.getPropertyInsistently(this.applicationProperties, string);
    }

    protected File takeSnapShot(Rectangle rectangle) {
        File file = null;
        try {
            file = File.createTempFile("snap", ".jpg", new File(System.getProperty("user.home")));
            BufferedImage bufferedImage = new Robot().createScreenCapture(rectangle);
            JPEGCodec.createJPEGEncoder((OutputStream)new FileOutputStream(file)).encode(bufferedImage);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return file;
    }

    public ApplicationFrame() {
        this("Application Frame", (String)null);
    }

    public ApplicationFrame(String string) {
        this(string, (String)null);
    }

    public ApplicationFrame(String string, String string2) {
        this.setApplicationPropertyFileName(string2);
        this.loadProperties();
        if (string != null) {
            this.setTitle(string);
        }
        this.createGUI();
    }

    public ApplicationFrame(String string, String string2, int n, int n2) {
        this.setApplicationPropertyFileName(string2);
        this.loadProperties();
        if (string != null) {
            this.setTitle(string);
        }
        this.createGUI();
        this.setSize(n, n2);
    }

    protected void setInternationalizedFontsForGUI() {
        Font font = new Font("Arial Unicode MS", 0, 12);
        if (!(font != null && font.getFamily().equals("Arial Unicode MS") || (font = new Font("Bitstream Cyberbit", 0, 13)) != null && font.getFamily().equals("Bitstream Cyberbit"))) {
            font = null;
        }
        if (font == null) {
            System.err.println("Warning: couldn't set internationalized font: non-Latin values may not display properly");
        } else {
            System.err.println("Using internationalized font " + font);
            UIManager.put("Tree.font", font);
            UIManager.put("Table.font", font);
        }
    }

    protected void createGUI() {
        this.setBackground(Color.lightGray);
        this.setInternationalizedFontsForGUI();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ApplicationFrame.this.dispose();
            }
        });
    }

    public static void main(String[] stringArray) {
        ApplicationFrame applicationFrame = new ApplicationFrame();
        applicationFrame.setVisible(true);
    }
}

