/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.display;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BandCombineOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.PrintStream;

class BufferedImageUtilities {
    protected static final String[] imageTypeNames = new String[]{"TYPE_CUSTOM", "TYPE_INT_RGB", "TYPE_INT_ARGB", "TYPE_INT_ARGB_PRE", "TYPE_INT_BGR", "TYPE_3BYTE_BGR", "TYPE_4BYTE_ABGR", "TYPE_4BYTE_ABGR_PRE", "TYPE_USHORT_565_RGB", "TYPE_USHORT_555_RGB", "TYPE_BYTE_GRAY", "TYPE_USHORT_GRAY", "TYPE_BYTE_BINARY", "TYPE_BYTE_INDEXED"};
    protected static final String[] bufferTypeNames = new String[]{"UBYTE", "USHORT", "short", "int", "float", "double"};
    protected static final String[] spaceTypeNames = new String[]{"XYZ", "Lab", "Luv", "YCbCr", "Yxy", "RGB", "Grayscale", "HSV", "HLS", "CMYK", "type-10", "CMY"};
    private static GraphicsConfiguration defaultGraphicsConfiguration = BufferedImageUtilities.initializeGraphicsConfiguration();
    private static ColorModel mostFavorableColorModel = BufferedImageUtilities.initializeMostFavorableColorModel();

    BufferedImageUtilities() {
    }

    public static String typeName(int n) {
        return imageTypeNames[n];
    }

    public static String typeName(int n, BufferedImage bufferedImage) {
        String string = BufferedImageUtilities.typeName(n);
        if (bufferedImage == null) {
            return string;
        }
        int n2 = bufferedImage.getType();
        if (n2 == n) {
            return string;
        }
        return string + " (" + BufferedImageUtilities.typeName(n2) + ")";
    }

    public static String transferTypeName(int n) {
        if (n < 0 || n >= bufferTypeNames.length) {
            return "UNKNOWN";
        }
        return bufferTypeNames[n];
    }

    public static String typeName(ColorSpace colorSpace) {
        if (colorSpace == null) {
            return "NULL";
        }
        int n = colorSpace.getType();
        if (n < 0 || n >= spaceTypeNames.length) {
            return "UNKNOWN";
        }
        if (n >= spaceTypeNames.length) {
            return String.valueOf(n - 10) + "-color space";
        }
        return spaceTypeNames[n];
    }

    public static void describeImage(BufferedImage bufferedImage, PrintStream printStream) {
        if (bufferedImage == null) {
            printStream.println("Image: null");
        } else {
            printStream.println("Image: " + bufferedImage);
            printStream.println("Image: width " + bufferedImage.getWidth());
            printStream.println("Image: height " + bufferedImage.getHeight());
            BufferedImageUtilities.describeRaster(bufferedImage.getRaster(), printStream);
            BufferedImageUtilities.describeColorModel(bufferedImage.getColorModel(), printStream);
        }
    }

    public static void describeRaster(Raster raster, PrintStream printStream) {
        if (raster == null) {
            printStream.println("    **** Raster: null");
        } else {
            printStream.println("    **** Raster: " + raster);
            printStream.println("    **** Raster: " + raster.getClass().getName());
            SampleModel sampleModel = raster.getSampleModel();
            if (sampleModel == null) {
                printStream.println("    SampleModel: null");
            } else {
                printStream.println("    SampleModel: " + sampleModel);
                printStream.println("    SampleModel: " + sampleModel.getClass().getName() + " -- " + sampleModel.getNumDataElements() + " " + BufferedImageUtilities.transferTypeName(sampleModel.getTransferType()) + "s/pixel, " + sampleModel.getNumBands() + " bands");
            }
            DataBuffer dataBuffer = raster.getDataBuffer();
            if (dataBuffer == null) {
                printStream.println("     DataBuffer: null");
            } else {
                printStream.println("     DataBuffer: " + dataBuffer);
                printStream.println("     DataBuffer: " + dataBuffer.getClass().getName() + " -- " + dataBuffer.getNumBanks() + " " + BufferedImageUtilities.transferTypeName(dataBuffer.getDataType()) + " banks");
            }
        }
    }

    public static void describeColorModel(ColorModel colorModel, PrintStream printStream) {
        if (colorModel == null) {
            printStream.println("     ColorModel: null");
        } else {
            printStream.println("     ColorModel: =" + colorModel);
            ColorSpace colorSpace = colorModel.getColorSpace();
            String string = "no alpha";
            if (colorModel.hasAlpha()) {
                string = colorModel.isAlphaPremultiplied() ? "premult-alpha" : "alpha";
            }
            int n = colorModel.getNumComponents();
            int n2 = colorModel.getNumColorComponents();
            String string2 = String.valueOf(n2);
            if (n != n2) {
                string2 = String.valueOf(n2) + ":" + n;
            }
            printStream.println("     ColorModel: " + colorModel.getClass().getName() + " -- " + colorModel.getPixelSize() + " bits/" + string2 + "-part " + BufferedImageUtilities.transferTypeName(colorModel.getTransferType()) + " pixel, " + string);
            printStream.println("     ColorSpace: " + colorSpace.getClass().getName() + " -- " + BufferedImageUtilities.typeName(colorSpace) + " space");
        }
    }

    public static GraphicsConfiguration getDefaultGraphicsConfiguration() {
        return defaultGraphicsConfiguration;
    }

    private static GraphicsConfiguration initializeGraphicsConfiguration() {
        GraphicsConfiguration graphicsConfiguration = null;
        if (System.getProperty("java.awt.headless", "false").equals("false")) {
            try {
                graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            }
            catch (HeadlessException headlessException) {
                headlessException.printStackTrace(System.err);
            }
        }
        return graphicsConfiguration;
    }

    public static ColorModel getMostFavorableColorModel() {
        return mostFavorableColorModel;
    }

    private static ColorModel initializeMostFavorableColorModel() {
        ColorModel colorModel = null;
        GraphicsConfiguration graphicsConfiguration = BufferedImageUtilities.getDefaultGraphicsConfiguration();
        if (graphicsConfiguration != null) {
            colorModel = graphicsConfiguration.getColorModel();
        }
        if (colorModel == null) {
            colorModel = System.getProperty("os.name", "").equals("Mac OS X") ? new DirectColorModel(ColorSpace.getInstance(1000), 32, 0xFF0000, 65280, 255, -16777216, true, 3) : new DirectColorModel(ColorSpace.getInstance(1000), 24, 0xFF0000, 65280, 255, 0, false, 3);
        }
        return colorModel;
    }

    public static final BufferedImage convertToMostFavorableImageTypeWithPixelCopy(BufferedImage bufferedImage) {
        ColorModel colorModel = BufferedImageUtilities.getMostFavorableColorModel();
        if (colorModel == null) {
            return null;
        }
        ColorModel colorModel2 = bufferedImage.getColorModel();
        if (colorModel.equals(colorModel2)) {
            return null;
        }
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        SampleModel sampleModel = bufferedImage.getSampleModel();
        WritableRaster writableRaster = bufferedImage.getRaster();
        DataBuffer dataBuffer = writableRaster.getDataBuffer();
        int n3 = writableRaster.getNumBands();
        WritableRaster writableRaster2 = colorModel.createCompatibleWritableRaster(n, n2);
        DataBuffer dataBuffer2 = writableRaster2.getDataBuffer();
        BufferedImage bufferedImage2 = new BufferedImage(colorModel, writableRaster2, colorModel.isAlphaPremultiplied(), null);
        SampleModel sampleModel2 = bufferedImage2.getSampleModel();
        int n4 = writableRaster2.getNumBands();
        int[] nArray = null;
        nArray = sampleModel.getPixels(0, 0, n, n2, nArray, dataBuffer);
        int n5 = nArray.length;
        int[] nArray2 = null;
        nArray2 = sampleModel2.getPixels(0, 0, n, n2, nArray2, dataBuffer2);
        int n6 = nArray2.length;
        if (n3 == 1 && n4 == 4 && n5 * 4 == n6) {
            int n7 = 0;
            for (int i = 0; i < n5; ++i) {
                nArray2[n7++] = nArray[i];
                nArray2[n7++] = nArray[i];
                nArray2[n7++] = nArray[i];
                nArray2[n7++] = -1;
            }
            sampleModel2.setPixels(0, 0, n, n2, nArray2, dataBuffer2);
        } else if (n3 == 1 && n4 == 3 && n5 * 3 == n6) {
            int n8 = 0;
            for (int i = 0; i < n5; ++i) {
                nArray2[n8++] = nArray[i];
                nArray2[n8++] = nArray[i];
                nArray2[n8++] = nArray[i];
            }
            sampleModel2.setPixels(0, 0, n, n2, nArray2, dataBuffer2);
        } else if (n3 == 3 && n4 == 4 && n5 * 4 == n6 * 3) {
            int n9 = 0;
            int n10 = 0;
            while (n10 < n5) {
                nArray2[n9++] = nArray[n10++];
                nArray2[n9++] = nArray[n10++];
                nArray2[n9++] = nArray[n10++];
                nArray2[n9++] = -1;
            }
            sampleModel2.setPixels(0, 0, n, n2, nArray2, dataBuffer2);
        } else if (n3 == 3 && n4 == 3 && n5 == n6) {
            int n11 = 0;
            int n12 = 0;
            while (n12 < n5) {
                nArray2[n11++] = nArray[n12++];
                nArray2[n11++] = nArray[n12++];
                nArray2[n11++] = nArray[n12++];
            }
            sampleModel2.setPixels(0, 0, n, n2, nArray2, dataBuffer2);
        } else {
            bufferedImage2 = null;
        }
        return bufferedImage2;
    }

    public static final BufferedImage convertToMostFavorableImageTypeWithDataBufferCopy(BufferedImage bufferedImage) {
        int n;
        int n2;
        int n3;
        ColorModel colorModel = BufferedImageUtilities.getMostFavorableColorModel();
        if (colorModel == null) {
            return bufferedImage;
        }
        ColorModel colorModel2 = bufferedImage.getColorModel();
        if (colorModel.equals(colorModel2)) {
            return bufferedImage;
        }
        int n4 = colorModel2.getNumComponents();
        if (n4 != (n3 = colorModel.getNumComponents())) {
            return null;
        }
        int n5 = bufferedImage.getWidth();
        int n6 = bufferedImage.getHeight();
        SampleModel sampleModel = bufferedImage.getSampleModel();
        int n7 = sampleModel.getDataType();
        WritableRaster writableRaster = bufferedImage.getRaster();
        DataBuffer dataBuffer = writableRaster.getDataBuffer();
        int n8 = dataBuffer.getDataType();
        int n9 = n2 = writableRaster.getNumBands();
        int n10 = n5 * n2;
        if (sampleModel instanceof ComponentSampleModel) {
            ComponentSampleModel componentSampleModel = (ComponentSampleModel)sampleModel;
            n9 = componentSampleModel.getPixelStride();
            n10 = componentSampleModel.getScanlineStride();
        }
        int n11 = dataBuffer.getOffset();
        int n12 = n6 * n5 * n2;
        int n13 = dataBuffer.getNumBanks();
        WritableRaster writableRaster2 = colorModel.createCompatibleWritableRaster(n5, n6);
        BufferedImage bufferedImage2 = new BufferedImage(colorModel, writableRaster2, colorModel.isAlphaPremultiplied(), null);
        SampleModel sampleModel2 = bufferedImage2.getSampleModel();
        int n14 = sampleModel2.getDataType();
        DataBuffer dataBuffer2 = writableRaster2.getDataBuffer();
        int n15 = dataBuffer2.getDataType();
        int n16 = n = writableRaster2.getNumBands();
        int n17 = n5 * n;
        if (sampleModel2 instanceof ComponentSampleModel) {
            ComponentSampleModel componentSampleModel = (ComponentSampleModel)sampleModel2;
            n16 = componentSampleModel.getPixelStride();
            n17 = componentSampleModel.getScanlineStride();
        }
        int n18 = dataBuffer2.getOffset();
        int n19 = n6 * n5 * n;
        int n20 = dataBuffer2.getNumBanks();
        if (n13 == 1 && n20 == 1 && sampleModel instanceof ComponentSampleModel && sampleModel2 instanceof SinglePixelPackedSampleModel && n8 == 0 && n15 == 3 && dataBuffer instanceof DataBufferByte && dataBuffer2 instanceof DataBufferInt && n9 == n2 && n2 == n) {
            byte[][] byArray = ((DataBufferByte)dataBuffer).getBankData();
            byte[] byArray2 = byArray[0];
            int n21 = byArray2.length;
            int[][] nArray = ((DataBufferInt)dataBuffer2).getBankData();
            int[] nArray2 = nArray[0];
            int n22 = nArray2.length;
            int[] nArray3 = ((SinglePixelPackedSampleModel)sampleModel2).getBitMasks();
            int[] nArray4 = ((SinglePixelPackedSampleModel)sampleModel2).getBitOffsets();
            int n23 = n11;
            int n24 = n18;
            for (int i = 0; i < n6; ++i) {
                for (int j = 0; j < n5; ++j) {
                    for (int k = 0; k < n2; ++k) {
                        nArray2[n24] = nArray2[n24] | byArray2[n23++] << nArray4[k] & nArray3[k];
                    }
                    ++n24;
                }
            }
        } else {
            bufferedImage2 = null;
        }
        return bufferedImage2;
    }

    public static final BufferedImage convertToMostFavorableImageTypeWithBandCombineOp(BufferedImage bufferedImage) {
        Object object;
        ColorModel colorModel = BufferedImageUtilities.getMostFavorableColorModel();
        if (colorModel == null) {
            return bufferedImage;
        }
        int n = colorModel.getNumComponents();
        int n2 = bufferedImage.getRaster().getNumBands();
        Object object2 = null;
        if (colorModel.getNumComponents() == 4) {
            if (n2 == 1) {
                object = new float[][]{{1.0f, 0.0f}, {1.0f, 0.0f}, {1.0f, 0.0f}, {0.0f, 65535.0f}};
                object2 = object;
            } else if (n2 == 3) {
                object = new float[][]{{1.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 65535.0f}};
                object2 = object;
            }
        } else if (colorModel.getNumComponents() == 3) {
            if (n2 == 1) {
                object = new float[][]{{1.0f, 0.0f}, {1.0f, 0.0f}, {1.0f, 0.0f}};
                object2 = object;
            } else if (n2 == 3) {
                object = new float[][]{{1.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 1.0f, 0.0f}};
                object2 = object;
            }
        } else {
            return null;
        }
        object = new BandCombineOp((float[][])object2, null);
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(bufferedImage.getWidth(), bufferedImage.getHeight());
        BufferedImage bufferedImage2 = new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
        ((BandCombineOp)object).filter(bufferedImage.getRaster(), writableRaster);
        return bufferedImage2;
    }

    public static final BufferedImage convertToMostFavorableImageTypeWithGraphicsDraw(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = null;
        GraphicsConfiguration graphicsConfiguration = BufferedImageUtilities.getDefaultGraphicsConfiguration();
        if (graphicsConfiguration != null && (bufferedImage2 = graphicsConfiguration.createCompatibleImage(bufferedImage.getWidth(), bufferedImage.getHeight())) != null) {
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.setComposite(AlphaComposite.Src);
            graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
            graphics2D.dispose();
        }
        return bufferedImage2;
    }

    public static final BufferedImage convertToMostFavorableImageType(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = null;
        if (bufferedImage.getColorModel().equals(BufferedImageUtilities.getMostFavorableColorModel())) {
            bufferedImage2 = bufferedImage;
        } else {
            bufferedImage2 = BufferedImageUtilities.convertToMostFavorableImageTypeWithDataBufferCopy(bufferedImage);
            if (bufferedImage2 == null) {
                bufferedImage2 = BufferedImageUtilities.convertToMostFavorableImageTypeWithPixelCopy(bufferedImage);
            }
            if (bufferedImage2 == null) {
                bufferedImage2 = BufferedImageUtilities.convertToMostFavorableImageTypeWithGraphicsDraw(bufferedImage);
            }
            if (bufferedImage2 == null) {
                bufferedImage2 = bufferedImage;
            }
        }
        return bufferedImage2;
    }

    public static final BufferedImage convertToThreeChannelImageType(BufferedImage bufferedImage) {
        int n = bufferedImage.getRaster().getNumBands();
        if (n != 4) {
            return bufferedImage;
        }
        ComponentColorModel componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8}, false, false, 1, 0);
        float[][] fArrayArray = new float[][]{{1.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 1.0f, 0.0f}};
        BandCombineOp bandCombineOp = new BandCombineOp(fArrayArray, null);
        WritableRaster writableRaster = ((ColorModel)componentColorModel).createCompatibleWritableRaster(bufferedImage.getWidth(), bufferedImage.getHeight());
        BufferedImage bufferedImage2 = new BufferedImage(componentColorModel, writableRaster, componentColorModel.isAlphaPremultiplied(), null);
        bandCombineOp.filter(bufferedImage.getRaster(), writableRaster);
        return bufferedImage2;
    }

    public final BufferedImage resample(BufferedImage bufferedImage, int n, int n2, boolean bl, int n3) {
        return this.resample(bufferedImage, bufferedImage.getWidth(), bufferedImage.getHeight(), 0, 0, n, n2, bl, n3);
    }

    public final BufferedImage resample(BufferedImage bufferedImage, int n, int n2, int n3, int n4, int n5, int n6, boolean bl, int n7) {
        int n8 = bufferedImage.getWidth();
        int n9 = bufferedImage.getHeight();
        if (n8 == n5 && n9 == n6 && n == n8 && n2 == n6 && n3 == 0 && n4 == 0) {
            return bufferedImage;
        }
        ColorModel colorModel = bufferedImage.getColorModel();
        SampleModel sampleModel = bufferedImage.getSampleModel();
        WritableRaster writableRaster = bufferedImage.getRaster();
        DataBuffer dataBuffer = writableRaster.getDataBuffer();
        int n10 = dataBuffer.getOffset();
        int n11 = writableRaster.getNumBands();
        if (n11 != 1 || !(dataBuffer instanceof DataBufferUShort) && !(dataBuffer instanceof DataBufferByte)) {
            BufferedImage bufferedImage2 = null;
            try {
                bufferedImage2 = this.resampleWithGraphicsDraw(BufferedImageUtilities.convertToMostFavorableImageType(bufferedImage), n, n2, n3, n4, n5, n6);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
                bufferedImage2 = null;
            }
            return bufferedImage2;
        }
        BufferedImage bufferedImage3 = null;
        ResamplingVector resamplingVector = new ResamplingVector(n, n5);
        ResamplingVector resamplingVector2 = new ResamplingVector(n2, n6);
        int n12 = 0;
        int n13 = n8 - 1;
        int n14 = n4 < 0 ? -n4 : 0;
        int n15 = n14 + n9 - 1;
        if (dataBuffer instanceof DataBufferUShort) {
            int n16;
            int n17;
            int n18;
            int n19;
            int n20;
            int n21;
            int n22;
            int[] nArray;
            ComponentColorModel componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{16}, false, false, 1, 1);
            ComponentSampleModel componentSampleModel = new ComponentSampleModel(1, n5, n6, 1, n5, new int[]{0});
            int n23 = bl ? -1 : 65535;
            short[] sArray = ((DataBufferUShort)dataBuffer).getData();
            int n24 = sArray.length;
            int n25 = n5 * n6;
            short[] sArray2 = new short[n25];
            int[] nArray2 = new int[n2 * n5];
            int[] nArray3 = new int[n2];
            int n26 = n10;
            int n27 = 0;
            int n28 = 0;
            n26 += n4 * n8;
            int n29 = 0;
            while (n29 < n2) {
                nArray3[n29] = n28;
                n28 += n5;
                for (int i = 0; i < n5; ++i) {
                    nArray = resamplingVector.arrayOfSrcIndices[i];
                    int[] nArray4 = resamplingVector.arrayOfWeights[i];
                    n22 = resamplingVector.sumOfWeights[i];
                    n21 = resamplingVector.numberOfEntries[i];
                    n20 = 0;
                    for (n19 = 0; n19 < n21; ++n19) {
                        n18 = nArray[n19] + n3;
                        n17 = nArray4[n19];
                        if (n18 >= n12 && n18 <= n13) {
                            n16 = n26 + n18;
                            if (n16 <= 0 || n16 >= n24) continue;
                            n20 += (sArray[n16] & n23) * n17;
                            continue;
                        }
                        n20 += n7 * n17;
                    }
                    nArray2[n27++] = n20 / n22;
                }
                ++n29;
                n26 += n8;
            }
            for (n29 = 0; n29 < n6; ++n29) {
                int[] nArray5 = resamplingVector2.arrayOfSrcIndices[n29];
                nArray = resamplingVector2.arrayOfWeights[n29];
                int n30 = resamplingVector2.sumOfWeights[n29];
                n22 = resamplingVector2.numberOfEntries[n29];
                n21 = n29 * n5;
                for (n20 = 0; n20 < n5; ++n20) {
                    n19 = 0;
                    for (n18 = 0; n18 < n22; ++n18) {
                        n17 = nArray5[n18];
                        n16 = nArray[n18];
                        if (n17 >= n14 && n17 <= n15) {
                            n19 += nArray2[nArray3[n17] + n20] * n16;
                            continue;
                        }
                        n19 += n7 * n16;
                    }
                    sArray2[n21 + n20] = (short)(n19 / n30);
                }
            }
            DataBufferUShort dataBufferUShort = new DataBufferUShort(sArray2, n5, 0);
            WritableRaster writableRaster2 = Raster.createWritableRaster(componentSampleModel, dataBufferUShort, new Point(0, 0));
            bufferedImage3 = new BufferedImage(componentColorModel, writableRaster2, true, null);
        } else if (dataBuffer instanceof DataBufferByte) {
            int n31;
            int n32;
            int n33;
            int n34;
            int n35;
            int n36;
            int n37;
            int[] nArray;
            ComponentColorModel componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{8}, false, false, 1, 0);
            ComponentSampleModel componentSampleModel = new ComponentSampleModel(0, n5, n6, 1, n5, new int[]{0});
            int n38 = bl ? -1 : 255;
            byte[] byArray = ((DataBufferByte)dataBuffer).getData();
            int n39 = byArray.length;
            int n40 = n5 * n6;
            byte[] byArray2 = new byte[n40];
            int[] nArray6 = new int[n2 * n5];
            int[] nArray7 = new int[n2];
            int n41 = n10;
            int n42 = 0;
            int n43 = 0;
            n41 += n4 * n8;
            int n44 = 0;
            while (n44 < n2) {
                nArray7[n44] = n43;
                n43 += n5;
                for (int i = 0; i < n5; ++i) {
                    nArray = resamplingVector.arrayOfSrcIndices[i];
                    int[] nArray8 = resamplingVector.arrayOfWeights[i];
                    n37 = resamplingVector.sumOfWeights[i];
                    n36 = resamplingVector.numberOfEntries[i];
                    n35 = 0;
                    for (n34 = 0; n34 < n36; ++n34) {
                        n33 = nArray[n34] + n3;
                        n32 = nArray8[n34];
                        if (n33 >= n12 && n33 <= n13) {
                            n31 = n41 + n33;
                            if (n31 <= 0 || n31 >= n39) continue;
                            n35 += (byArray[n31] & n38) * n32;
                            continue;
                        }
                        n35 += n7 * n32;
                    }
                    nArray6[n42++] = n35 / n37;
                }
                ++n44;
                n41 += n8;
            }
            for (n44 = 0; n44 < n6; ++n44) {
                int[] nArray9 = resamplingVector2.arrayOfSrcIndices[n44];
                nArray = resamplingVector2.arrayOfWeights[n44];
                int n45 = resamplingVector2.sumOfWeights[n44];
                n37 = resamplingVector2.numberOfEntries[n44];
                n36 = n44 * n5;
                for (n35 = 0; n35 < n5; ++n35) {
                    n34 = 0;
                    for (n33 = 0; n33 < n37; ++n33) {
                        n32 = nArray9[n33];
                        n31 = nArray[n33];
                        if (n32 >= n14 && n32 <= n15) {
                            n34 += nArray6[nArray7[n32] + n35] * n31;
                            continue;
                        }
                        n34 += n7 * n31;
                    }
                    byArray2[n36 + n35] = (byte)(n34 / n45);
                }
            }
            DataBufferByte dataBufferByte = new DataBufferByte(byArray2, n5, 0);
            WritableRaster writableRaster3 = Raster.createWritableRaster(componentSampleModel, dataBufferByte, new Point(0, 0));
            bufferedImage3 = new BufferedImage(componentColorModel, writableRaster3, true, null);
        }
        return bufferedImage3;
    }

    public final BufferedImage resampleWithGraphicsDraw(BufferedImage bufferedImage, int n, int n2, int n3, int n4, int n5, int n6) {
        BufferedImage bufferedImage2 = null;
        ColorModel colorModel = bufferedImage.getColorModel();
        bufferedImage2 = BufferedImageUtilities.resampleWithGraphicsDraw(bufferedImage, colorModel, n, n2, n3, n4, n5, n6);
        if (bufferedImage2 == null) {
            colorModel = BufferedImageUtilities.getMostFavorableColorModel();
            bufferedImage2 = BufferedImageUtilities.resampleWithGraphicsDraw(bufferedImage, colorModel, n, n2, n3, n4, n5, n6);
        }
        return bufferedImage2;
    }

    private static final BufferedImage resampleWithGraphicsDraw(BufferedImage bufferedImage, ColorModel colorModel, int n, int n2, int n3, int n4, int n5, int n6) {
        WritableRaster writableRaster;
        BufferedImage bufferedImage2 = null;
        if (colorModel != null && (bufferedImage2 = new BufferedImage(colorModel, writableRaster = colorModel.createCompatibleWritableRaster(n5, n6), colorModel.isAlphaPremultiplied(), null)) != null) {
            try {
                BufferedImageUtilities.resampleWithGraphicsDraw(bufferedImage, bufferedImage2, n, n2, n3, n4, n5, n6);
            }
            catch (Exception exception) {
                bufferedImage2 = null;
            }
        }
        return bufferedImage2;
    }

    private static final void resampleWithGraphicsDraw(BufferedImage bufferedImage, BufferedImage bufferedImage2, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        int n8 = n3;
        int n9 = n4;
        int n10 = n3 + n - 1;
        int n11 = n4 + n2 - 1;
        int n12 = 0;
        int n13 = 0;
        int n14 = n5 - 1;
        int n15 = n6 - 1;
        int n16 = bufferedImage.getWidth();
        int n17 = bufferedImage.getHeight();
        if (n8 < 0) {
            n7 = (int)((double)(-n8) * (double)n5 / (double)n + 0.5);
            n12 += n7;
            n8 = 0;
        }
        if (n8 >= n16) {
            n7 = (int)((double)(n8 - n16 + 1) * (double)n5 / (double)n + 0.5);
            n12 -= n7;
            n8 = n16 - 1;
        }
        if (n10 < 0) {
            n7 = (int)((double)(-n10) * (double)n5 / (double)n + 0.5);
            n14 += n7;
            n10 = 0;
        }
        if (n10 >= n16) {
            n7 = (int)((double)(n10 - n16 + 1) * (double)n5 / (double)n + 0.5);
            n14 -= n7;
            n10 = n16 - 1;
        }
        if (n9 < 0) {
            n7 = (int)((double)(-n9) * (double)n6 / (double)n2 + 0.5);
            n13 += n7;
            n9 = 0;
        }
        if (n9 >= n17) {
            n7 = (int)((double)(n9 - n17 + 1) * (double)n6 / (double)n2 + 0.5);
            n13 -= n7;
            n9 = n17 - 1;
        }
        if (n11 < 0) {
            n7 = (int)((double)(-n11) * (double)n6 / (double)n2 + 0.5);
            n15 += n7;
            n11 = 0;
        }
        if (n11 >= n17) {
            n7 = (int)((double)(n11 - n17 + 1) * (double)n6 / (double)n2 + 0.5);
            n15 -= n7;
            n11 = n17 - 1;
        }
        graphics2D.drawImage(bufferedImage, n12, n13, n14, n15, n8, n9, n10, n11, Color.black, null);
    }

    public static final BufferedImage resampleWithAffineTransformOp(BufferedImage bufferedImage, double d, double d2) {
        AffineTransform affineTransform = AffineTransform.getScaleInstance(d, d2);
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 2);
        BufferedImage bufferedImage2 = affineTransformOp.createCompatibleDestImage(bufferedImage, bufferedImage.getColorModel());
        bufferedImage2 = affineTransformOp.filter(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }

    public static final BufferedImage resampleWithAffineTransformOp(BufferedImage bufferedImage, int n, int n2) {
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        double d = (double)n / (double)n3;
        double d2 = (double)n2 / (double)n4;
        return BufferedImageUtilities.resampleWithAffineTransformOp(bufferedImage, d, d2);
    }

    public static void flipHorizontally(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        WritableRaster writableRaster = bufferedImage.getRaster();
        DataBuffer dataBuffer = writableRaster.getDataBuffer();
        int n3 = dataBuffer.getOffset();
        int n4 = writableRaster.getNumBands();
        if (n4 == 1) {
            if (dataBuffer instanceof DataBufferUShort) {
                short[] sArray = ((DataBufferUShort)dataBuffer).getData();
                short[] sArray2 = new short[n];
                for (int i = 0; i < n2; ++i) {
                    int n5;
                    int n6 = n3 + i * n;
                    for (n5 = n - 1; n5 >= 0; --n5) {
                        sArray2[n5] = sArray[n6++];
                    }
                    n6 = n3 + i * n;
                    for (n5 = 0; n5 < n; ++n5) {
                        sArray[n6++] = sArray2[n5];
                    }
                }
            } else if (dataBuffer instanceof DataBufferByte) {
                byte[] byArray = ((DataBufferByte)dataBuffer).getData();
                byte[] byArray2 = new byte[n];
                for (int i = 0; i < n2; ++i) {
                    int n7;
                    int n8 = n3 + i * n;
                    for (n7 = n - 1; n7 >= 0; --n7) {
                        byArray2[n7] = byArray[n8++];
                    }
                    n8 = n3 + i * n;
                    for (n7 = 0; n7 < n; ++n7) {
                        byArray[n8++] = byArray2[n7];
                    }
                }
            } else {
                System.err.println("BufferedImageUtilities.flipHorizontally(): cannot flip unsupported DataBuffer type of " + dataBuffer.getClass().getName());
            }
        } else {
            System.err.println("BufferedImageUtilities.flipHorizontally(): cannot flip more than one band; number of bands is" + n4);
        }
    }

    public static void flipVertically(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        WritableRaster writableRaster = bufferedImage.getRaster();
        DataBuffer dataBuffer = writableRaster.getDataBuffer();
        int n3 = dataBuffer.getOffset();
        int n4 = writableRaster.getNumBands();
        if (n4 == 1) {
            if (dataBuffer instanceof DataBufferUShort) {
                short[] sArray = ((DataBufferUShort)dataBuffer).getData();
                short[] sArray2 = new short[n2];
                for (int i = 0; i < n; ++i) {
                    int n5 = n3 + i;
                    int n6 = 0;
                    for (int j = n2 - 1; j >= 0; --j) {
                        sArray2[j] = sArray[n5 + n6 * n];
                        ++n6;
                    }
                    n5 = n3 + i;
                    for (n6 = 0; n6 < n2; ++n6) {
                        sArray[n5 + n6 * n] = sArray2[n6];
                    }
                }
            } else if (dataBuffer instanceof DataBufferByte) {
                byte[] byArray = ((DataBufferByte)dataBuffer).getData();
                byte[] byArray2 = new byte[n2];
                for (int i = 0; i < n; ++i) {
                    int n7 = n3 + i;
                    int n8 = 0;
                    for (int j = n2 - 1; j >= 0; --j) {
                        byArray2[j] = byArray[n7 + n8 * n];
                        ++n8;
                    }
                    n7 = n3 + i;
                    for (n8 = 0; n8 < n2; ++n8) {
                        byArray[n7 + n8 * n] = byArray2[n8];
                    }
                }
            } else {
                System.err.println("BufferedImageUtilities.flipVertically(): cannot flip unsupported DataBuffer type of " + dataBuffer.getClass().getName());
            }
        } else {
            System.err.println("BufferedImageUtilities.flipVertically(): cannot flip more than one band; number of bands is" + n4);
        }
    }

    public static BufferedImage rotateAndFlipSwappingRowsAndColumns(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        ColorModel colorModel = bufferedImage.getColorModel();
        SampleModel sampleModel = bufferedImage.getSampleModel();
        WritableRaster writableRaster = bufferedImage.getRaster();
        DataBuffer dataBuffer = writableRaster.getDataBuffer();
        int n3 = dataBuffer.getOffset();
        int n4 = writableRaster.getNumBands();
        if (n4 != 1 || !(dataBuffer instanceof DataBufferUShort) && !(dataBuffer instanceof DataBufferByte)) {
            System.err.println("BufferedImageUtilities.rotateAndFlipSwappingRowsAndColumns(): cannot do our own rotating");
            return bufferedImage;
        }
        int n5 = n2;
        int n6 = n;
        BufferedImage bufferedImage2 = null;
        if (dataBuffer instanceof DataBufferUShort) {
            ComponentColorModel componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{16}, false, false, 1, 1);
            ComponentSampleModel componentSampleModel = new ComponentSampleModel(1, n5, n6, 1, n5, new int[]{0});
            short[] sArray = ((DataBufferUShort)dataBuffer).getData();
            int n7 = sArray.length;
            int n8 = n5 * n6;
            short[] sArray2 = new short[n8];
            for (int i = 0; i < n2; ++i) {
                int n9 = n3 + i * n;
                int n10 = 0;
                int n11 = i;
                while (n10 < n) {
                    sArray2[n11] = sArray[n9 + n10];
                    ++n10;
                    n11 += n5;
                }
            }
            DataBufferUShort dataBufferUShort = new DataBufferUShort(sArray2, n5, 0);
            WritableRaster writableRaster2 = Raster.createWritableRaster(componentSampleModel, dataBufferUShort, new Point(0, 0));
            bufferedImage2 = new BufferedImage(componentColorModel, writableRaster2, true, null);
        } else if (dataBuffer instanceof DataBufferByte) {
            ComponentColorModel componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{8}, false, false, 1, 0);
            ComponentSampleModel componentSampleModel = new ComponentSampleModel(0, n5, n6, 1, n5, new int[]{0});
            byte[] byArray = ((DataBufferByte)dataBuffer).getData();
            int n12 = byArray.length;
            int n13 = n5 * n6;
            byte[] byArray2 = new byte[n13];
            for (int i = 0; i < n2; ++i) {
                int n14 = n3 + i * n;
                int n15 = 0;
                int n16 = i;
                while (n15 < n) {
                    byArray2[n16] = byArray[n14 + n15];
                    ++n15;
                    n16 += n5;
                }
            }
            DataBufferByte dataBufferByte = new DataBufferByte(byArray2, n5, 0);
            WritableRaster writableRaster3 = Raster.createWritableRaster(componentSampleModel, dataBufferByte, new Point(0, 0));
            bufferedImage2 = new BufferedImage(componentColorModel, writableRaster3, true, null);
        }
        return bufferedImage2;
    }

    private static BufferedImage flipBothVerticallyAndHorizontallyWithAffineTransformOp(BufferedImage bufferedImage) {
        AffineTransform affineTransform = AffineTransform.getScaleInstance(-1.0, -1.0);
        affineTransform.translate(-bufferedImage.getWidth(null), -bufferedImage.getHeight(null));
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 1);
        return affineTransformOp.filter(bufferedImage, null);
    }

    private class ResamplingVector {
        int[][] arrayOfWeights;
        int[][] arrayOfSrcIndices;
        int[] numberOfEntries;
        int[] sumOfWeights;
        int maxNumberOfSrcSamplesPerDst;
        int divisor = 1000;

        ResamplingVector(int n, int n2) {
            double d = (double)n / (double)n2;
            this.maxNumberOfSrcSamplesPerDst = (int)Math.ceil(d) + 1;
            double d2 = 0.0;
            int n3 = 0;
            this.arrayOfWeights = new int[n2][];
            this.arrayOfSrcIndices = new int[n2][];
            this.numberOfEntries = new int[n2];
            this.sumOfWeights = new int[n2];
            for (int i = 0; i < n2; ++i) {
                this.arrayOfWeights[i] = new int[this.maxNumberOfSrcSamplesPerDst];
                this.arrayOfSrcIndices[i] = new int[this.maxNumberOfSrcSamplesPerDst];
                double d3 = d;
                int n4 = 0;
                while (d3 > 1.0E-4) {
                    double d4 = Math.min(1.0 - d2, d3);
                    d3 -= d4;
                    d2 += d4;
                    this.arrayOfWeights[i][n4] = (int)(d4 * (double)this.divisor);
                    int n5 = i;
                    this.sumOfWeights[n5] = this.sumOfWeights[n5] + (int)(d4 * (double)this.divisor);
                    this.arrayOfSrcIndices[i][n4] = n3++;
                    this.numberOfEntries[i] = n4 + 1;
                    if (d2 >= 1.0) {
                        d2 = 0.0;
                    }
                    ++n4;
                }
            }
        }

        void dump() {
            for (int i = 0; i < this.arrayOfSrcIndices.length; ++i) {
                for (int j = 0; j < this.numberOfEntries[i]; ++j) {
                }
            }
        }
    }
}

