/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.display;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.IntegerStringAttribute;
import com.pixelmed.dicom.OtherByteAttribute;
import com.pixelmed.dicom.OtherWordAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.TransferSyntax;
import com.pixelmed.dicom.UnsignedShortAttribute;
import com.pixelmed.display.SourceImage;
import java.awt.Shape;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Vector;

public class ImageEditUtilities {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/display/ImageEditUtilities.java,v 1.6 2008/01/20 17:44:38 dclunie Exp $";

    private ImageEditUtilities() {
    }

    public static void sanitizePhotometricInterpretation(AttributeList attributeList) throws DicomException {
        int n = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.SamplesPerPixel, 1);
        String string = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.TransferSyntaxUID);
        String string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PhotometricInterpretation);
        if (n > 1 && TransferSyntax.mayBeTransformedColorSpace(string) && !string2.equals("RGB")) {
            attributeList.remove(TagFromName.PhotometricInterpretation);
            CodeStringAttribute codeStringAttribute = new CodeStringAttribute(TagFromName.PhotometricInterpretation);
            ((Attribute)codeStringAttribute).addValue("RGB");
            attributeList.put(codeStringAttribute);
        }
    }

    public static void blackout(SourceImage sourceImage, AttributeList attributeList, Vector vector) throws DicomException {
        int n = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.BitsAllocated, 0);
        int n2 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.BitsStored, 0);
        int n3 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.HighBit, n2 - 1);
        int n4 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.SamplesPerPixel, 1);
        int n5 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.PixelRepresentation, 0);
        String string = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.PhotometricInterpretation);
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        byte[] byArray = null;
        Object[] objectArray = null;
        Attribute attribute = null;
        int n9 = 0;
        int n10 = sourceImage.getNumberOfBufferedImages();
        boolean bl = true;
        for (int i = 0; i < n10; ++i) {
            int n11;
            int n12;
            int n13;
            int n14;
            int n15;
            int n16;
            int n17;
            int n18;
            RectangularShape rectangularShape;
            int n19;
            Object object;
            int n20;
            int n21;
            BufferedImage bufferedImage = sourceImage.getBufferedImage(i);
            n8 = bufferedImage.getWidth();
            n7 = bufferedImage.getHeight();
            SampleModel sampleModel = bufferedImage.getSampleModel();
            int n22 = sampleModel.getDataType();
            WritableRaster writableRaster = bufferedImage.getRaster();
            DataBuffer dataBuffer = writableRaster.getDataBuffer();
            int n23 = dataBuffer.getDataType();
            int n24 = n21 = writableRaster.getNumBands();
            int n25 = n8 * n21;
            if (n21 > 1 && sampleModel instanceof ComponentSampleModel) {
                ComponentSampleModel componentSampleModel = (ComponentSampleModel)sampleModel;
                n24 = componentSampleModel.getPixelStride();
                n25 = componentSampleModel.getScanlineStride();
                n6 = n24 == n21 ? 0 : 1;
            }
            int n26 = dataBuffer.getOffset();
            int n27 = n7 * n8 * n21;
            int n28 = dataBuffer.getNumBanks();
            if (n28 > 1) {
                throw new DicomException("Unsupported type of image - DataBuffer number of banks is > 1, is " + n28);
            }
            int n29 = n6 == 0 ? n21 : 1;
            int n30 = n20 = n6 == 0 ? 1 : n7 * n8;
            if (n23 == 0) {
                object = null;
                if (!(dataBuffer instanceof DataBufferByte)) {
                    throw new DicomException("Unsupported type of image - DataBuffer is TYPE_BYTE but not instance of DataBufferByte, is " + dataBuffer.getClass().getName());
                }
                object = ((DataBufferByte)dataBuffer).getBankData();
                n19 = object[0].length;
                if (byArray == null) {
                    if (n > 8) {
                        n = 8;
                    }
                    if (n2 > 8) {
                        n2 = 8;
                    }
                    if (n3 > 7) {
                        n3 = 7;
                    }
                    n4 = n21;
                    int n31 = n27 * n10;
                    if (n31 == n19) {
                        byArray = object[0];
                        bl = false;
                    } else {
                        byArray = new byte[n31];
                    }
                    attribute = new OtherByteAttribute(TagFromName.PixelData);
                    attribute.setValues(byArray);
                }
                if (bl) {
                    System.arraycopy(object[0], n26, byArray, n9, n27);
                    n9 += n27;
                }
                for (Shape shape : vector) {
                    if (!(shape instanceof RectangularShape)) continue;
                    rectangularShape = (RectangularShape)shape;
                    n18 = (int)rectangularShape.getX();
                    n17 = (int)rectangularShape.getY();
                    n16 = (int)((double)n18 + rectangularShape.getWidth());
                    n15 = (int)((double)n17 + rectangularShape.getHeight());
                    for (n14 = n17; n14 < n15; ++n14) {
                        n13 = (n7 * i + n14) * n8 + n18;
                        for (n12 = n18; n12 < n16; ++n12) {
                            for (n11 = 0; n11 < n21; ++n11) {
                                byArray[n13 * n29 + n11 * n20] = 0;
                            }
                            ++n13;
                        }
                    }
                }
                continue;
            }
            if (n23 == 1 || n23 == 2) {
                object = null;
                if (dataBuffer instanceof DataBufferShort) {
                    object = ((DataBufferShort)dataBuffer).getBankData();
                } else if (dataBuffer instanceof DataBufferUShort) {
                    object = ((DataBufferUShort)dataBuffer).getBankData();
                } else {
                    throw new DicomException("Unsupported type of image - DataBuffer is TYPE_USHORT or TYPE_SHORT but not instance of DataBufferShort, is " + dataBuffer.getClass().getName());
                }
                n19 = object[0].length;
                if (objectArray == null) {
                    if (n > 16) {
                        n = 16;
                    }
                    if (n2 > 16) {
                        n2 = 16;
                    }
                    if (n3 > 15) {
                        n3 = 15;
                    }
                    n4 = n21;
                    int n32 = n27 * n10;
                    if (n32 == n19) {
                        objectArray = object[0];
                        bl = false;
                    } else {
                        objectArray = new short[n32];
                    }
                    attribute = new OtherWordAttribute(TagFromName.PixelData);
                    attribute.setValues((short[])objectArray);
                }
                if (bl) {
                    System.arraycopy(object[0], n26, objectArray, n9, n27);
                    n9 += n27;
                }
                for (Shape shape : vector) {
                    if (!(shape instanceof RectangularShape)) continue;
                    rectangularShape = (RectangularShape)shape;
                    n18 = (int)rectangularShape.getX();
                    n17 = (int)rectangularShape.getY();
                    n16 = (int)((double)n18 + rectangularShape.getWidth());
                    n15 = (int)((double)n17 + rectangularShape.getHeight());
                    for (n14 = n17; n14 < n15; ++n14) {
                        n13 = (n7 * i + n14) * n8 + n18;
                        for (n12 = n18; n12 < n16; ++n12) {
                            for (n11 = 0; n11 < n21; ++n11) {
                                objectArray[n13 * n29 + n11 * n20] = 0;
                            }
                            ++n13;
                        }
                    }
                }
                continue;
            }
            throw new DicomException("Unsupported pixel data form - DataBufferType = " + n23);
        }
        attributeList.remove(TagFromName.PixelData);
        attributeList.remove(TagFromName.BitsAllocated);
        attributeList.remove(TagFromName.BitsStored);
        attributeList.remove(TagFromName.HighBit);
        attributeList.remove(TagFromName.SamplesPerPixel);
        attributeList.remove(TagFromName.PixelRepresentation);
        attributeList.remove(TagFromName.PhotometricInterpretation);
        attributeList.remove(TagFromName.PlanarConfiguration);
        attributeList.put(attribute);
        Attribute attribute2 = new UnsignedShortAttribute(TagFromName.BitsAllocated);
        attribute2.addValue(n);
        attributeList.put(attribute2);
        attribute2 = new UnsignedShortAttribute(TagFromName.BitsStored);
        attribute2.addValue(n2);
        attributeList.put(attribute2);
        attribute2 = new UnsignedShortAttribute(TagFromName.HighBit);
        attribute2.addValue(n3);
        attributeList.put(attribute2);
        attribute2 = new UnsignedShortAttribute(TagFromName.Rows);
        attribute2.addValue(n7);
        attributeList.put(attribute2);
        attribute2 = new UnsignedShortAttribute(TagFromName.Columns);
        attribute2.addValue(n8);
        attributeList.put(attribute2);
        attribute2 = new IntegerStringAttribute(TagFromName.NumberOfFrames);
        attribute2.addValue(n10);
        attributeList.put(attribute2);
        attribute2 = new UnsignedShortAttribute(TagFromName.SamplesPerPixel);
        attribute2.addValue(n4);
        attributeList.put(attribute2);
        attribute2 = new UnsignedShortAttribute(TagFromName.PixelRepresentation);
        attribute2.addValue(n5);
        attributeList.put(attribute2);
        attribute2 = new CodeStringAttribute(TagFromName.PhotometricInterpretation);
        attribute2.addValue(string);
        attributeList.put(attribute2);
        if (n4 > 1) {
            attribute2 = new UnsignedShortAttribute(TagFromName.PlanarConfiguration);
            attribute2.addValue(n6);
            attributeList.put(attribute2);
        }
        sourceImage.constructSourceImage(attributeList);
    }
}

