/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.network;

import com.pixelmed.network.ApplicationEntity;
import com.pixelmed.network.NetworkDefaultValues;
import com.pixelmed.network.PresentationAddress;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class ApplicationEntityConfigurationDialog
extends ApplicationEntity {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/network/ApplicationEntityConfigurationDialog.java,v 1.2 2007/12/19 22:44:15 dclunie Exp $";
    protected JTextField dicomAETitleField;
    protected JTextField hostnameField;
    protected JTextField portField;

    public static boolean isValidAETitle(String string) {
        boolean bl = true;
        if (string == null) {
            bl = false;
        } else if (string.length() == 0) {
            bl = false;
        } else if (string.length() > 16) {
            bl = false;
        } else if (string.trim().length() == 0) {
            bl = false;
        } else if (string.contains("\\")) {
            bl = false;
        } else {
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                int n2 = string.codePointAt(i);
                try {
                    Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(n2);
                    if (unicodeBlock != Character.UnicodeBlock.BASIC_LATIN) {
                        bl = false;
                        continue;
                    }
                    if (!Character.isISOControl(n2)) continue;
                    bl = false;
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    bl = false;
                }
            }
        }
        return bl;
    }

    public ApplicationEntityConfigurationDialog() {
        super(NetworkDefaultValues.getDefaultApplicationEntityTitle(11112));
        this.presentationAddress = new PresentationAddress(NetworkDefaultValues.getUnqualifiedLocalHostName(), 11112);
        this.primaryDeviceType = NetworkDefaultValues.getDefaultPrimaryDeviceType();
        final JDialog jDialog = new JDialog();
        jDialog.setModal(true);
        this.dicomAETitleField = new JTextField();
        this.hostnameField = new JTextField();
        this.portField = new JTextField();
        this.dicomAETitleField.setText(this.dicomAETitle);
        this.hostnameField.setText(this.presentationAddress.getHostname());
        this.portField.setText(Integer.toString(this.presentationAddress.getPort()));
        this.dicomAETitleField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                JTextComponent jTextComponent = (JTextComponent)focusEvent.getSource();
                jTextComponent.selectAll();
            }
        });
        this.hostnameField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                JTextComponent jTextComponent = (JTextComponent)focusEvent.getSource();
                jTextComponent.selectAll();
            }
        });
        this.portField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                JTextComponent jTextComponent = (JTextComponent)focusEvent.getSource();
                jTextComponent.selectAll();
            }
        });
        JPanel jPanel = new JPanel(new GridLayout(3, 2));
        jPanel.add(new JLabel("AE Title:"));
        jPanel.add(this.dicomAETitleField);
        jPanel.add(new JLabel("Hostname or IP address:"));
        jPanel.add(this.hostnameField);
        jPanel.add(new JLabel("Port:"));
        jPanel.add(this.portField);
        JPanel jPanel2 = new JPanel(new FlowLayout(1));
        JButton jButton = new JButton("OK");
        jButton.setToolTipText("Accept AE configuration");
        jPanel2.add(jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = true;
                ApplicationEntityConfigurationDialog.this.dicomAETitle = ApplicationEntityConfigurationDialog.this.dicomAETitleField.getText();
                if (!ApplicationEntityConfigurationDialog.isValidAETitle(ApplicationEntityConfigurationDialog.this.dicomAETitle)) {
                    bl = false;
                    ApplicationEntityConfigurationDialog.this.dicomAETitleField.setText("\\\\\\BAD\\\\\\");
                }
                String string = ApplicationEntityConfigurationDialog.this.hostnameField.getText();
                int n = 0;
                try {
                    n = Integer.parseInt(ApplicationEntityConfigurationDialog.this.portField.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    bl = false;
                    ApplicationEntityConfigurationDialog.this.portField.setText("\\\\\\BAD\\\\\\");
                }
                ApplicationEntityConfigurationDialog.this.presentationAddress = new PresentationAddress(string, n);
                if (bl) {
                    jDialog.dispose();
                }
            }
        });
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jPanel, "North");
        jPanel3.add((Component)jPanel2, "South");
        jDialog.getContentPane().add(jPanel3);
        jDialog.getRootPane().setDefaultButton(jButton);
        jDialog.pack();
        jDialog.setVisible(true);
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length != 0) {
                throw new Exception("Argument list must be empty");
            }
            ApplicationEntityConfigurationDialog applicationEntityConfigurationDialog = new ApplicationEntityConfigurationDialog();
            System.err.println("ApplicationEntityConfigurationDialog.main(): result of dialog " + applicationEntityConfigurationDialog);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            System.exit(0);
        }
    }
}

