/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.network;

import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.PresentationDataValue;
import com.pixelmed.utils.ByteArray;
import com.pixelmed.utils.HexDump;
import java.io.ByteArrayOutputStream;
import java.util.LinkedList;
import java.util.ListIterator;

public class PDataPDU {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/network/PDataPDU.java,v 1.13 2005/06/01 23:21:52 dclunie Exp $";
    private byte[] b;
    private int pduType;
    private int pduLength;
    private LinkedList pdvList;

    public PDataPDU(LinkedList linkedList) throws DicomNetworkException {
        this.pduType = 4;
        this.pdvList = linkedList;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(16384);
        byteArrayOutputStream.write((byte)this.pduType);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(0);
        ListIterator listIterator = linkedList.listIterator();
        while (listIterator.hasNext()) {
            PresentationDataValue presentationDataValue = (PresentationDataValue)listIterator.next();
            byte[] byArray = presentationDataValue.getBytes();
            byteArrayOutputStream.write(byArray, 0, byArray.length);
        }
        this.pduLength = byteArrayOutputStream.size() - 6;
        this.b = byteArrayOutputStream.toByteArray();
        this.b[2] = (byte)(this.pduLength >> 24);
        this.b[3] = (byte)(this.pduLength >> 16);
        this.b[4] = (byte)(this.pduLength >> 8);
        this.b[5] = (byte)this.pduLength;
    }

    public PDataPDU(byte[] byArray) throws DicomNetworkException {
        int n;
        this.b = byArray;
        this.pduType = this.b[0] & 0xFF;
        this.pduLength = ByteArray.bigEndianToUnsignedInt(this.b, 2, 4);
        this.pdvList = new LinkedList();
        for (int i = 6; i < this.b.length; i += n + 4) {
            n = ByteArray.bigEndianToUnsignedInt(this.b, i, 4);
            if (n < 2) {
                throw new DicomNetworkException("Illegal length in PDV = " + n + ", must be >= 2");
            }
            if (n <= 0) continue;
            this.pdvList.add(new PresentationDataValue(this.b, i, n));
        }
    }

    public byte[] getBytes() {
        return this.b;
    }

    public LinkedList getPDVList() {
        return this.pdvList;
    }

    public boolean containsLastCommandFragment() {
        boolean bl = false;
        if (this.pdvList != null && this.pdvList.size() > 0) {
            ListIterator listIterator = this.pdvList.listIterator();
            while (listIterator.hasNext()) {
                PresentationDataValue presentationDataValue = (PresentationDataValue)listIterator.next();
                if (!presentationDataValue.isLastFragment() || !presentationDataValue.isCommand()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public boolean containsLastDataFragment() {
        PresentationDataValue presentationDataValue;
        boolean bl = false;
        if (this.pdvList != null && this.pdvList.size() > 0 && (presentationDataValue = (PresentationDataValue)this.pdvList.getLast()).isLastFragment() && !presentationDataValue.isCommand()) {
            bl = true;
        }
        return bl;
    }

    public String toString() {
        return HexDump.dump(this.b);
    }
}

