/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.query;

import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeListTableBrowser;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.query.QueryInformationModel;
import com.pixelmed.query.QueryTreeModel;
import com.pixelmed.query.QueryTreeRecord;
import com.pixelmed.utils.JTreeWithAdditionalKeyStrokeActions;
import java.awt.Container;
import java.util.HashSet;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class QueryTreeBrowser {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/query/QueryTreeBrowser.java,v 1.10 2005/07/28 13:56:57 dclunie Exp $";
    private JTree tree;
    private QueryTreeModel treeModel;
    private QueryInformationModel queryInformationModel;

    public QueryTreeBrowser(QueryInformationModel queryInformationModel, QueryTreeModel queryTreeModel, JScrollPane jScrollPane, JScrollPane jScrollPane2) throws DicomException {
        this.queryInformationModel = queryInformationModel;
        this.treeModel = queryTreeModel;
        this.tree = new JTreeWithAdditionalKeyStrokeActions(this.treeModel);
        jScrollPane.setViewportView(this.tree);
        this.tree.addTreeSelectionListener(this.buildTreeSelectionListenerToDisplayAttributesOfSelectedRecord(jScrollPane2));
        this.tree.addTreeSelectionListener(this.buildTreeSelectionListenerToDoSomethingWithSelectedLevel());
    }

    public QueryTreeBrowser(QueryInformationModel queryInformationModel, QueryTreeModel queryTreeModel, JFrame jFrame) throws DicomException {
        this.queryInformationModel = queryInformationModel;
        this.treeModel = queryTreeModel;
        this.tree = new JTreeWithAdditionalKeyStrokeActions(this.treeModel);
        Container container = jFrame.getContentPane();
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        JScrollPane jScrollPane2 = new JScrollPane();
        JSplitPane jSplitPane = new JSplitPane(0, jScrollPane, jScrollPane2);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setResizeWeight(0.7);
        container.add(jSplitPane);
        this.tree.addTreeSelectionListener(this.buildTreeSelectionListenerToDisplayAttributesOfSelectedRecord(jScrollPane2));
        this.tree.addTreeSelectionListener(this.buildTreeSelectionListenerToDoSomethingWithSelectedLevel());
    }

    protected TreeSelectionListener buildTreeSelectionListenerToDoSomethingWithSelectedLevel() {
        return new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                Object object;
                TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
                if (treePath != null && (object = treePath.getLastPathComponent()) instanceof QueryTreeRecord) {
                    QueryTreeRecord queryTreeRecord = (QueryTreeRecord)object;
                    System.err.println("TreeSelectionListener.valueChanged: " + queryTreeRecord.getUniqueKeys());
                }
            }
        };
    }

    protected TreeSelectionListener buildTreeSelectionListenerToDisplayAttributesOfSelectedRecord(final JScrollPane jScrollPane) {
        return new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                QueryTreeRecord queryTreeRecord;
                AttributeList attributeList;
                Object object;
                TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
                if (treePath != null && (object = treePath.getLastPathComponent()) instanceof QueryTreeRecord && (attributeList = (queryTreeRecord = (QueryTreeRecord)object).getAllAttributesReturnedInIdentifier()) != null) {
                    HashSet hashSet = null;
                    HashSet hashSet2 = null;
                    AttributeListTableBrowser attributeListTableBrowser = new AttributeListTableBrowser(attributeList, hashSet, hashSet2);
                    attributeListTableBrowser.setAutoResizeMode(0);
                    attributeListTableBrowser.setColumnWidths();
                    jScrollPane.setViewportView(attributeListTableBrowser);
                }
            }
        };
    }
}

