/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.utils;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.StringTokenizer;

public class MACAddress {
    private long macAddressValue = MACAddress.getMacAddressFromNetworkInterfaceAPI();
    private static final String regexForMACComponent = "[0-9A-Fa-f][0-9A-Fa-f]?";
    private static final String regexForMACSeparator = "[:-]";
    private static final String regexForMAC = "[0-9A-Fa-f][0-9A-Fa-f]?[:-][0-9A-Fa-f][0-9A-Fa-f]?[:-][0-9A-Fa-f][0-9A-Fa-f]?[:-][0-9A-Fa-f][0-9A-Fa-f]?[:-][0-9A-Fa-f][0-9A-Fa-f]?[:-][0-9A-Fa-f][0-9A-Fa-f]?";

    public long getMACAddress() {
        return this.macAddressValue;
    }

    private final String executeCommandLookingForFirstLineContainingAndGetMatchingString(String string, String string2) {
        String string3 = null;
        try {
            Process process = Runtime.getRuntime().exec(string);
            ConsumeStreamLookingForRexEx consumeStreamLookingForRexEx = new ConsumeStreamLookingForRexEx(process.getInputStream(), string2);
            ConsumeStreamLookingForRexEx consumeStreamLookingForRexEx2 = new ConsumeStreamLookingForRexEx(process.getErrorStream(), string2);
            consumeStreamLookingForRexEx.start();
            consumeStreamLookingForRexEx2.start();
            int n = process.waitFor();
            consumeStreamLookingForRexEx.join();
            consumeStreamLookingForRexEx2.join();
            string3 = consumeStreamLookingForRexEx.getValue();
            if (string3 == null) {
                string3 = consumeStreamLookingForRexEx2.getValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string3;
    }

    private static final long extractMACAddressFromHexComponents(String string) {
        long l = 0L;
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, regexForMACSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                l = (l << 8) + (Long.parseLong(string2, 16) & 0xFFL);
            }
        }
        return l;
    }

    private static final long extractMACAddressFromByteArray(byte[] byArray) {
        long l = 0L;
        if (byArray != null) {
            int n = byArray.length;
            for (int i = 0; i < n; ++i) {
                l = (l << 8) + (long)(byArray[i] & 0xFF);
            }
        }
        return l;
    }

    private static final String getUnqualifiedHostname() {
        String string = null;
        try {
            int n;
            string = InetAddress.getLocalHost().getHostName();
            if (string != null && string.length() > 0 && (n = string.indexOf(".")) != -1) {
                string = string.substring(0, n);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        return string;
    }

    public MACAddress() {
        if (this.macAddressValue == 0L) {
            this.macAddressValue = this.getMacAddressFromSystemCommandCall();
        }
    }

    protected static long getMacAddressFromNetworkInterfaceAPI() {
        long l = 0L;
        boolean bl = false;
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            if (enumeration != null) {
                while (!bl && enumeration.hasMoreElements()) {
                    NetworkInterface networkInterface = enumeration.nextElement();
                    if (networkInterface == null) continue;
                    Class[] classArray = new Class[]{};
                    Object[] objectArray = new Object[]{};
                    Method method = networkInterface.getClass().getDeclaredMethod("getHardwareAddress", classArray);
                    byte[] byArray = (byte[])method.invoke((Object)networkInterface, objectArray);
                    if (byArray == null) continue;
                    l = MACAddress.extractMACAddressFromByteArray(byArray);
                    bl = true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return l;
    }

    protected long getMacAddressFromSystemCommandCall() {
        String string;
        long l = 0L;
        String string2 = null;
        if (string2 == null) {
            string = "ipconfig /all";
            string2 = this.executeCommandLookingForFirstLineContainingAndGetMatchingString(string, regexForMAC);
        }
        if (string2 == null) {
            string = "cmd.exe /c ipconfig /all";
            string2 = this.executeCommandLookingForFirstLineContainingAndGetMatchingString(string, regexForMAC);
        }
        if (string2 == null) {
            string = "ifconfig";
            string2 = this.executeCommandLookingForFirstLineContainingAndGetMatchingString(string, regexForMAC);
        }
        if (string2 == null) {
            string = MACAddress.getUnqualifiedHostname();
            String string3 = "arp " + string;
            string2 = this.executeCommandLookingForFirstLineContainingAndGetMatchingString(string3, regexForMAC);
        }
        l = MACAddress.extractMACAddressFromHexComponents(string2);
        return l;
    }

    public static void main(String[] stringArray) {
        System.out.println("MAC address = 0x" + Long.toHexString(new MACAddress().getMACAddress()));
    }

    private class ConsumeStreamLookingForRexEx
    extends Thread {
        BufferedReader r;
        String regex;
        String value;

        ConsumeStreamLookingForRexEx(InputStream inputStream, String string) {
            this.r = new BufferedReader(new InputStreamReader(inputStream), 10000);
            this.regex = string;
            this.value = null;
        }

        public void run() {
            try {
                String string;
                block2: while ((string = this.r.readLine()) != null && (this.value == null || this.value.length() == 0)) {
                    if (string.length() <= 0 || !string.matches(".*" + this.regex + ".*")) continue;
                    StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string2 = stringTokenizer.nextToken();
                        if (!string2.matches(this.regex)) continue;
                        this.value = string2;
                        if (this.value == null || this.value.length() <= 0) continue;
                        continue block2;
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }

        String getValue() {
            return this.value;
        }
    }
}

