/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.utils;

import com.pixelmed.utils.PdfException;
import java.awt.Color;
import java.awt.Component;
import java.awt.image.BufferedImage;

public class PdfDecoder {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/utils/PdfDecoder.java,v 1.2 2007/08/01 11:41:25 dclunie Exp $";
    protected Class pdfDecoderClass = null;
    protected Object pdfDecoder = null;

    public PdfDecoder() throws PdfException {
        try {
            this.pdfDecoderClass = Thread.currentThread().getContextClassLoader().loadClass("org.jpedal.PdfDecoder");
            Class[] classArray = new Class[]{};
            Object[] objectArray = new Object[]{};
            this.pdfDecoder = this.pdfDecoderClass.getConstructor(classArray).newInstance(objectArray);
        }
        catch (Exception exception) {
            throw new PdfException("Could not instantiate org.jpedal.PdfDecoder - " + exception);
        }
    }

    public void useHiResScreenDisplay(boolean bl) throws PdfException {
        try {
            Class[] classArray = new Class[]{Boolean.TYPE};
            Object[] objectArray = new Object[]{bl};
            this.pdfDecoderClass.getMethod("useHiResScreenDisplay", classArray).invoke(this.pdfDecoder, objectArray);
        }
        catch (Exception exception) {
            throw new PdfException("Could not invoke org.jpedal.PdfDecoder.useHiResScreenDisplay() - " + exception);
        }
    }

    public void openPdfFile(String string) throws PdfException {
        try {
            Class[] classArray = new Class[]{String.class};
            Object[] objectArray = new Object[]{string};
            this.pdfDecoderClass.getMethod("openPdfFile", classArray).invoke(this.pdfDecoder, objectArray);
        }
        catch (Exception exception) {
            throw new PdfException("Could not invoke org.jpedal.PdfDecoder.openPdfFile() - " + exception);
        }
    }

    public void closePdfFile() throws PdfException {
        try {
            Class[] classArray = new Class[]{};
            Object[] objectArray = new Object[]{};
            this.pdfDecoderClass.getMethod("closePdfFile", classArray).invoke(this.pdfDecoder, objectArray);
        }
        catch (Exception exception) {
            throw new PdfException("Could not invoke org.jpedal.PdfDecoder.closePdfFile() - " + exception);
        }
    }

    public int getPageCount() throws PdfException {
        int n = 0;
        try {
            Class[] classArray = new Class[]{};
            Object[] objectArray = new Object[]{};
            n = (Integer)this.pdfDecoderClass.getMethod("getPageCount", classArray).invoke(this.pdfDecoder, objectArray);
        }
        catch (Exception exception) {
            throw new PdfException("Could not invoke org.jpedal.PdfDecoder.getPageCount() - " + exception);
        }
        return n;
    }

    public int getDPI() throws PdfException {
        int n = 0;
        try {
            n = this.pdfDecoderClass.getField("dpi").getInt(this.pdfDecoder);
        }
        catch (Exception exception) {
            throw new PdfException("Could not invoke org.jpedal.PdfDecoder.getPageCount() - " + exception);
        }
        return n;
    }

    public void setPageParameters(float f, int n) throws PdfException {
        try {
            Class[] classArray = new Class[]{Float.TYPE, Integer.TYPE};
            Object[] objectArray = new Object[]{Float.valueOf(f), n};
            this.pdfDecoderClass.getMethod("setPageParameters", classArray).invoke(this.pdfDecoder, objectArray);
        }
        catch (Exception exception) {
            throw new PdfException("Could not invoke org.jpedal.PdfDecoder.setPageParameters() - " + exception);
        }
    }

    public void decodePage(int n) throws PdfException {
        try {
            Class[] classArray = new Class[]{Integer.TYPE};
            Object[] objectArray = new Object[]{n};
            this.pdfDecoderClass.getMethod("decodePage", classArray).invoke(this.pdfDecoder, objectArray);
        }
        catch (Exception exception) {
            throw new PdfException("Could not invoke org.jpedal.PdfDecoder.decodePage() - " + exception);
        }
    }

    public void setBackground(Color color) throws PdfException {
        try {
            Class[] classArray = new Class[]{Color.class};
            Object[] objectArray = new Object[]{color};
            this.pdfDecoderClass.getMethod("setBackground", classArray).invoke(this.pdfDecoder, objectArray);
        }
        catch (Exception exception) {
            throw new PdfException("Could not invoke org.jpedal.PdfDecoder.setBackground() - " + exception);
        }
    }

    public BufferedImage getPageAsImage(int n) throws PdfException {
        BufferedImage bufferedImage = null;
        try {
            Class[] classArray = new Class[]{Integer.TYPE};
            Object[] objectArray = new Object[]{n};
            bufferedImage = (BufferedImage)this.pdfDecoderClass.getMethod("getPageAsImage", classArray).invoke(this.pdfDecoder, objectArray);
        }
        catch (Exception exception) {
            throw new PdfException("Could not invoke org.jpedal.PdfDecoder.getPageAsImage() - " + exception);
        }
        return bufferedImage;
    }

    public Component getComponent() {
        return (Component)this.pdfDecoder;
    }
}

