/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.database;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.InformationEntity;
import com.pixelmed.dicom.ValueRepresentation;
import com.pixelmed.query.QueryResponseGeneratorFactory;
import com.pixelmed.query.RetrieveResponseGeneratorFactory;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import org.hsqldb.Server;

public abstract class DatabaseInformationModel {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/database/DatabaseInformationModel.java,v 1.56 2008/01/24 19:00:11 dclunie Exp $";
    protected static final String localPrimaryKeyColumnName = "LocalPrimaryKey";
    protected static final String localParentReferenceColumnName = "LocalParentReference";
    protected static final String localRecordInsertionTimeColumnName = "RecordInsertionTime";
    protected static final String localFileName = "LocalFileName";
    protected static final String personNameCanonicalColumnNamePrefix = "PM_";
    protected static final String personNameCanonicalColumnNameSuffix = "_CANONICAL";
    protected static final String personNamePhoneticCanonicalColumnNamePrefix = "PM_";
    protected static final String personNamePhoneticCanonicalColumnNameSuffix = "_PHONETICCANONICAL";
    protected static final String userColumnName1 = "PM_USER1";
    protected static final String userColumnName2 = "PM_USER2";
    protected static final String userColumnName3 = "PM_USER3";
    protected static final String userColumnName4 = "PM_USER4";
    protected InformationEntity rootInformationEntity;
    protected HashMap listsOfAttributesByInformationEntity;
    protected HashMap additionalIndexMapOfColumnsToTables;
    protected Connection databaseConnection;
    protected Server externalServerInstance;
    protected DicomDictionary dictionary;
    private Map descriptiveNameMap;
    private HashSet localColumnExcludeList;
    private HashMap mapOfInformationEntitiesToColumnNames;

    DicomDictionary getDicomDictionary() {
        return this.dictionary;
    }

    HashSet getLocalColumnExcludeList() {
        return this.localColumnExcludeList;
    }

    void makeLocalColumnExcludeList() {
        this.localColumnExcludeList = new HashSet();
        this.localColumnExcludeList.add(localPrimaryKeyColumnName.toUpperCase());
        this.localColumnExcludeList.add(localParentReferenceColumnName.toUpperCase());
        this.localColumnExcludeList.add(localRecordInsertionTimeColumnName.toUpperCase());
        this.localColumnExcludeList.add(localFileName.toUpperCase());
    }

    protected void setDatabaseProperties() {
        if (this.databaseConnection != null) {
            try {
                Statement statement = this.databaseConnection.createStatement();
                statement.execute("SET PROPERTY \"hsqldb.cache_file_scale\" 8;");
                statement.close();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace(System.err);
            }
        }
    }

    public DatabaseInformationModel(String string, InformationEntity informationEntity, DicomDictionary dicomDictionary) throws DicomException {
        this.doCommonConstructorStuff(string, null, informationEntity, dicomDictionary);
    }

    public DatabaseInformationModel(String string, String string2, InformationEntity informationEntity, DicomDictionary dicomDictionary) throws DicomException {
        this.doCommonConstructorStuff(string, string2, informationEntity, dicomDictionary);
    }

    protected void doCommonConstructorStuff(String string, String string2, InformationEntity informationEntity, DicomDictionary dicomDictionary) throws DicomException {
        this.rootInformationEntity = informationEntity;
        this.dictionary = dicomDictionary;
        if (this.dictionary == null) {
            this.dictionary = new DicomDictionary();
        }
        this.listsOfAttributesByInformationEntity = new HashMap(6);
        this.additionalIndexMapOfColumnsToTables = new HashMap();
        this.makeLocalColumnExcludeList();
        try {
            Class.forName("org.hsqldb.jdbcDriver").newInstance();
            this.databaseConnection = DriverManager.getConnection("jdbc:hsqldb:" + string, "sa", "");
            this.primeListsOfAttributesByInformationEntityFromExistingMetaData();
            if (this.listsOfAttributesByInformationEntity.size() == 0) {
                this.setDatabaseProperties();
                this.createTables();
                this.primeListsOfAttributesByInformationEntityFromExistingMetaData();
            }
            this.createDescriptiveNameMap();
        }
        catch (Exception exception) {
            throw new DicomException("Cannot connect to database: " + exception);
        }
        if (string2 != null && string2.trim().length() > 0) {
            try {
                String string3 = "database.0=" + string + ";dbname.0=" + string2;
                this.externalServerInstance = new Server();
                this.externalServerInstance.setLogWriter(null);
                this.externalServerInstance.setErrWriter(null);
                this.externalServerInstance.putPropertiesFromString(string3);
                this.externalServerInstance.start();
            }
            catch (Exception exception) {
                throw new DicomException("Cannot create additional server instance of database for external access: " + exception);
            }
        } else {
            this.externalServerInstance = null;
        }
    }

    public void close() {
        if (this.externalServerInstance != null) {
            this.externalServerInstance.shutdown();
            this.externalServerInstance = null;
        }
        if (this.databaseConnection != null) {
            try {
                Statement statement = this.databaseConnection.createStatement();
                statement.execute("SHUTDOWN COMPACT;");
                statement.close();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace(System.err);
            }
            try {
                this.databaseConnection.close();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace(System.err);
            }
            this.databaseConnection = null;
        }
    }

    protected void finalize() {
        this.close();
    }

    Statement createStatement() throws SQLException {
        return this.databaseConnection.createStatement();
    }

    InformationEntity getRootInformationEntity() {
        return this.rootInformationEntity;
    }

    protected abstract boolean isInformationEntityInModel(InformationEntity var1);

    protected boolean isInformationEntityInModel(String string) {
        InformationEntity informationEntity = InformationEntity.fromString(string);
        return informationEntity == null ? false : this.isInformationEntityInModel(informationEntity);
    }

    Map getDescriptiveNameMap() {
        return this.descriptiveNameMap;
    }

    private void createDescriptiveNameMap() throws DicomException {
        this.descriptiveNameMap = new HashMap();
        Iterator iterator = this.dictionary.getTagIterator();
        while (iterator.hasNext()) {
            AttributeTag attributeTag = (AttributeTag)iterator.next();
            String string = this.dictionary.getNameFromTag(attributeTag);
            String string2 = this.getDatabaseColumnNameFromDicomName(string);
            if (string == null || string2 == null) continue;
            this.descriptiveNameMap.put(string2, string);
        }
    }

    String getDatabaseColumnNameFromDicomTag(AttributeTag attributeTag) {
        String string = null;
        if (this.dictionary != null) {
            string = this.getDatabaseColumnNameFromDicomName(this.dictionary.getNameFromTag(attributeTag));
        }
        return string;
    }

    String getDatabaseColumnNameFromDicomName(String string) {
        String string2 = null;
        if (string != null) {
            string2 = string.toUpperCase();
        }
        return string2;
    }

    String getDicomNameFromDatabaseColumnName(String string) {
        String string2 = null;
        if (string != null) {
            string2 = (String)this.descriptiveNameMap.get(string);
        }
        return string2;
    }

    AttributeTag getAttributeTagFromDatabaseColumnName(String string) {
        AttributeTag attributeTag = null;
        String string2 = this.getDicomNameFromDatabaseColumnName(string);
        if (string2 != null) {
            attributeTag = this.dictionary.getTagFromName(string2);
        }
        return attributeTag;
    }

    private void createTables() throws DicomException {
        InformationEntity informationEntity = this.rootInformationEntity;
        while (informationEntity != null) {
            this.createTable(informationEntity, informationEntity != this.rootInformationEntity);
            informationEntity = this.getChildTypeForParent(informationEntity);
        }
        this.createAdditionalIndexes();
    }

    private void createTable(InformationEntity informationEntity, boolean bl) throws DicomException {
        Statement statement;
        StringBuffer stringBuffer;
        String string = DatabaseInformationModel.getTableNameForInformationEntity(informationEntity);
        if (string == null) {
            throw new DicomException("Internal error: Cannot get name for table from " + informationEntity);
        }
        try {
            stringBuffer = new StringBuffer();
            stringBuffer.append("CREATE CACHED TABLE ");
            stringBuffer.append(string);
            stringBuffer.append(" (");
            this.extendCreateStatementStringWithMandatoryColumns(stringBuffer, bl, informationEntity);
            this.extendCreateStatementStringWithAttributesInDicomDictionary(stringBuffer, informationEntity);
            this.extendCreateStatementStringWithAnyExtraAttributes(stringBuffer, informationEntity);
            this.extendCreateStatementStringWithDerivedAttributes(stringBuffer, informationEntity);
            this.extendCreateStatementStringWithUserColumns(stringBuffer, informationEntity);
            stringBuffer.append(")");
            statement = this.databaseConnection.createStatement();
            statement.execute(stringBuffer.toString());
            statement.close();
        }
        catch (Exception exception) {
            throw new DicomException("Cannot create table " + string + " in database: " + exception);
        }
        if (bl) {
            try {
                stringBuffer = new StringBuffer();
                stringBuffer.append("CREATE INDEX ");
                stringBuffer.append(string);
                stringBuffer.append("_PREFIDX ON ");
                stringBuffer.append(string);
                stringBuffer.append(" (");
                stringBuffer.append(localParentReferenceColumnName);
                stringBuffer.append(")");
                statement = this.databaseConnection.createStatement();
                statement.execute(stringBuffer.toString());
                statement.close();
            }
            catch (Exception exception) {
                throw new DicomException("Cannot create index of parents for " + string + " in database: " + exception);
            }
        }
    }

    protected void createAdditionalIndexes() throws DicomException {
        if (this.additionalIndexMapOfColumnsToTables != null) {
            for (String string : this.additionalIndexMapOfColumnsToTables.keySet()) {
                String string2 = (String)this.additionalIndexMapOfColumnsToTables.get(string);
                try {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("CREATE INDEX ");
                    stringBuffer.append(string2);
                    stringBuffer.append("_");
                    stringBuffer.append(string);
                    stringBuffer.append("_IDX ON ");
                    stringBuffer.append(string2);
                    stringBuffer.append(" (");
                    stringBuffer.append(string);
                    stringBuffer.append(")");
                    Statement statement = this.databaseConnection.createStatement();
                    statement.execute(stringBuffer.toString());
                    statement.close();
                }
                catch (Exception exception) {
                    throw new DicomException("Cannot create index of " + string + " for " + string2 + " in database: " + exception);
                }
            }
        }
    }

    private void extendCreateStatementStringWithMandatoryColumns(StringBuffer stringBuffer, boolean bl, InformationEntity informationEntity) {
        stringBuffer.append(localPrimaryKeyColumnName);
        stringBuffer.append(" CHAR(64)");
        stringBuffer.append(" PRIMARY KEY");
        if (bl) {
            stringBuffer.append(", ");
            stringBuffer.append(localParentReferenceColumnName);
            stringBuffer.append(" CHAR(64)");
        }
        stringBuffer.append(",");
        stringBuffer.append(localRecordInsertionTimeColumnName);
        stringBuffer.append(" BIGINT");
        if (informationEntity == InformationEntity.INSTANCE) {
            stringBuffer.append(",");
            stringBuffer.append(localFileName);
            stringBuffer.append(" VARCHAR(255)");
        }
    }

    private void extendCreateStatementStringWithAttributesInDicomDictionary(StringBuffer stringBuffer, InformationEntity informationEntity) {
        Iterator iterator = this.dictionary.getTagIterator();
        while (iterator.hasNext()) {
            AttributeTag attributeTag = (AttributeTag)iterator.next();
            if (informationEntity != this.dictionary.getInformationEntityFromTag(attributeTag)) continue;
            String string = DatabaseInformationModel.getTableNameForInformationEntity(informationEntity);
            String string2 = this.getDatabaseColumnNameFromDicomTag(attributeTag);
            byte[] byArray = this.dictionary.getValueRepresentationFromTag(attributeTag);
            String string3 = DatabaseInformationModel.getSQLTypeFromDicomValueRepresentation(byArray);
            if (string2 == null || string3 == null) continue;
            stringBuffer.append(", ");
            stringBuffer.append(string2);
            stringBuffer.append(" ");
            stringBuffer.append(string3);
            if (!ValueRepresentation.isPersonNameVR(byArray)) continue;
            this.extendCreateStatementStringWithPersonNameSearchColumns(stringBuffer, string2, string);
        }
    }

    private void extendCreateStatementStringWithPersonNameSearchColumns(StringBuffer stringBuffer, String string, String string2) {
        String string3 = "PM_" + string + personNameCanonicalColumnNameSuffix;
        stringBuffer.append(", ");
        stringBuffer.append(string3);
        stringBuffer.append(" ");
        stringBuffer.append("VARCHAR(255)");
        this.additionalIndexMapOfColumnsToTables.put(string3, string2);
        string3 = "PM_" + string + personNamePhoneticCanonicalColumnNameSuffix;
        stringBuffer.append(", ");
        stringBuffer.append(string3);
        stringBuffer.append(" ");
        stringBuffer.append("VARCHAR(255)");
        this.additionalIndexMapOfColumnsToTables.put(string3, string2);
    }

    protected void extendCreateStatementStringWithAnyExtraAttributes(StringBuffer stringBuffer, InformationEntity informationEntity) {
    }

    protected void extendCreateStatementStringWithDerivedAttributes(StringBuffer stringBuffer, InformationEntity informationEntity) {
    }

    protected void extendCreateStatementStringWithUserColumns(StringBuffer stringBuffer, InformationEntity informationEntity) {
        stringBuffer.append(", ");
        stringBuffer.append(userColumnName1);
        stringBuffer.append(" ");
        stringBuffer.append("VARCHAR(255)");
        stringBuffer.append(", ");
        stringBuffer.append(userColumnName2);
        stringBuffer.append(" ");
        stringBuffer.append("VARCHAR(255)");
        stringBuffer.append(", ");
        stringBuffer.append(userColumnName3);
        stringBuffer.append(" ");
        stringBuffer.append("VARCHAR(255)");
        stringBuffer.append(", ");
        stringBuffer.append(userColumnName4);
        stringBuffer.append(" ");
        stringBuffer.append("VARCHAR(255)");
    }

    private void extendTablesAsNecessary(AttributeList attributeList) throws DicomException {
        DicomDictionary dicomDictionary = attributeList.getDictionary();
        for (Attribute attribute : attributeList.values()) {
            AttributeTag attributeTag = attribute.getTag();
            InformationEntity informationEntity = dicomDictionary.getInformationEntityFromTag(attributeTag);
            if (informationEntity == null) continue;
            String string = DatabaseInformationModel.getTableNameForInformationEntity(informationEntity);
            String string2 = this.getDatabaseColumnNameFromDicomTag(attributeTag);
            String string3 = DatabaseInformationModel.getSQLTypeFromDicomValueRepresentation(attribute.getVR());
            if (string2 == null || string3 == null || this.isAttributeUsedInTable(string, string2)) continue;
            try {
                Statement statement = this.databaseConnection.createStatement();
                statement.execute("ALTER TABLE " + string + " ADD COLUMN " + string2 + " " + string3);
                statement.close();
            }
            catch (Exception exception) {
                throw new DicomException("Cannot add column " + string2 + " to table " + string + " in database: " + exception);
            }
        }
    }

    public void insertObject(AttributeList attributeList, String string) throws DicomException {
        try {
            InformationEntity informationEntity = this.rootInformationEntity;
            String string2 = null;
            while (informationEntity != null) {
                String string3 = DatabaseInformationModel.getTableNameForInformationEntity(informationEntity);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("SELECT ");
                stringBuffer.append(localPrimaryKeyColumnName);
                stringBuffer.append(" FROM ");
                stringBuffer.append(string3);
                stringBuffer.append(" WHERE ");
                if (informationEntity != this.rootInformationEntity) {
                    stringBuffer.append(string3);
                    stringBuffer.append(".");
                    stringBuffer.append(localParentReferenceColumnName);
                    stringBuffer.append(" = '");
                    stringBuffer.append(string2);
                    stringBuffer.append("'");
                }
                this.extendStatementStringWithMatchingAttributesForSelectedInformationEntity(stringBuffer, attributeList, informationEntity);
                Statement statement = this.databaseConnection.createStatement();
                ResultSet resultSet = statement.executeQuery(stringBuffer.toString());
                String string4 = null;
                int n = 0;
                while (resultSet.next()) {
                    string4 = resultSet.getString(localPrimaryKeyColumnName);
                    ++n;
                }
                if (n != 1 || string4 == null) {
                    stringBuffer = new StringBuffer();
                    stringBuffer.append("INSERT INTO ");
                    stringBuffer.append(string3);
                    stringBuffer.append(" (");
                    stringBuffer.append(localPrimaryKeyColumnName);
                    if (informationEntity != this.rootInformationEntity) {
                        stringBuffer.append(",");
                        stringBuffer.append(localParentReferenceColumnName);
                    }
                    stringBuffer.append(",");
                    stringBuffer.append(localRecordInsertionTimeColumnName);
                    this.extendInsertStatementStringWithAttributeNamesForSelectedInformationEntity(stringBuffer, attributeList, informationEntity);
                    this.extendInsertStatementStringWithDerivedAttributeNamesForSelectedInformationEntity(stringBuffer, attributeList, informationEntity);
                    this.extendInsertStatementStringWithPersonNameSearchColumnsForSelectedInformationEntity(stringBuffer, attributeList, informationEntity);
                    stringBuffer.append(") VALUES ('");
                    string4 = this.createPrimaryKeyForSelectedInformationEntity(informationEntity);
                    stringBuffer.append(string4);
                    stringBuffer.append("'");
                    if (informationEntity != this.rootInformationEntity) {
                        stringBuffer.append(",'");
                        stringBuffer.append(string2);
                        stringBuffer.append("'");
                    }
                    stringBuffer.append(",");
                    stringBuffer.append(Long.toString(System.currentTimeMillis()));
                    this.extendInsertStatementStringWithAttributeValuesForSelectedInformationEntity(stringBuffer, attributeList, informationEntity, string);
                    this.extendInsertStatementStringWithDerivedAttributeValuesForSelectedInformationEntity(stringBuffer, attributeList, informationEntity);
                    this.extendInsertStatementStringWithPersonNameSearchValuesForSelectedInformationEntity(stringBuffer, attributeList, informationEntity);
                    stringBuffer.append(")");
                    String string5 = stringBuffer.toString();
                    statement.execute(string5);
                }
                statement.close();
                string2 = string4;
                informationEntity = this.getChildTypeForParent(informationEntity, attributeList);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            throw new DicomException("Cannot perform selection: " + exception);
        }
    }

    private void extendStatementStringWithListOfAllTables(StringBuffer stringBuffer) {
        InformationEntity informationEntity = this.rootInformationEntity;
        while (informationEntity != null) {
            if (informationEntity != this.rootInformationEntity) {
                stringBuffer.append(",");
            }
            String string = DatabaseInformationModel.getTableNameForInformationEntity(informationEntity);
            stringBuffer.append(string);
            informationEntity = this.getChildTypeForParent(informationEntity);
        }
    }

    protected abstract void extendInsertStatementStringWithPersonNameSearchColumnsForSelectedInformationEntity(StringBuffer var1, AttributeList var2, InformationEntity var3) throws DicomException;

    protected abstract void extendInsertStatementStringWithPersonNameSearchValuesForSelectedInformationEntity(StringBuffer var1, AttributeList var2, InformationEntity var3) throws DicomException;

    protected abstract void extendStatementStringWithMatchingAttributesForSelectedInformationEntity(StringBuffer var1, AttributeList var2, InformationEntity var3) throws DicomException;

    protected abstract void extendInsertStatementStringWithAttributeNamesForSelectedInformationEntity(StringBuffer var1, AttributeList var2, InformationEntity var3) throws DicomException;

    protected abstract void extendInsertStatementStringWithAttributeValuesForSelectedInformationEntity(StringBuffer var1, AttributeList var2, InformationEntity var3, String var4) throws DicomException;

    protected abstract void extendInsertStatementStringWithDerivedAttributeNamesForSelectedInformationEntity(StringBuffer var1, AttributeList var2, InformationEntity var3) throws DicomException;

    protected abstract void extendInsertStatementStringWithDerivedAttributeValuesForSelectedInformationEntity(StringBuffer var1, AttributeList var2, InformationEntity var3) throws DicomException;

    protected abstract String createPrimaryKeyForSelectedInformationEntity(InformationEntity var1);

    private void primeListsOfAttributesByInformationEntityFromExistingMetaData() throws SQLException {
        DatabaseMetaData databaseMetaData = this.databaseConnection.getMetaData();
        ResultSet resultSet = databaseMetaData.getColumns(null, null, null, null);
        while (resultSet.next()) {
            String string = resultSet.getString(3);
            String string2 = resultSet.getString(4);
            if (string == null || string2 == null || !this.isInformationEntityInModel(string)) continue;
            LinkedList<String> linkedList = (LinkedList<String>)this.listsOfAttributesByInformationEntity.get(string);
            if (linkedList == null) {
                linkedList = new LinkedList<String>();
                this.listsOfAttributesByInformationEntity.put(string, linkedList);
            }
            linkedList.add(string2);
        }
        resultSet.close();
    }

    boolean isAttributeUsedInTable(InformationEntity informationEntity, String string) {
        return informationEntity == null ? false : this.isAttributeUsedInTable(informationEntity.toString().toUpperCase(), string);
    }

    boolean isAttributeUsedInTable(String string, String string2) {
        LinkedList linkedList;
        return this.listsOfAttributesByInformationEntity != null && (linkedList = (LinkedList)this.listsOfAttributesByInformationEntity.get(string)) != null && linkedList.contains(string2.toUpperCase());
    }

    public void updateSelectedRecord(InformationEntity informationEntity, String string, String string2, String string3) throws DicomException {
        try {
            if (informationEntity != null) {
                String string4 = DatabaseInformationModel.getTableNameForInformationEntity(informationEntity);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("UPDATE ");
                stringBuffer.append(string4);
                if (string2 != null) {
                    stringBuffer.append(" SET ");
                    stringBuffer.append(string2);
                    stringBuffer.append(" = '");
                    stringBuffer.append(string3);
                    stringBuffer.append("'");
                }
                if (string != null) {
                    stringBuffer.append(" WHERE ");
                    stringBuffer.append(localPrimaryKeyColumnName);
                    stringBuffer.append(" = '");
                    stringBuffer.append(string);
                    stringBuffer.append("'");
                }
                stringBuffer.append(";");
                Statement statement = this.databaseConnection.createStatement();
                ResultSet resultSet = statement.executeQuery(stringBuffer.toString());
                statement.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            throw new DicomException("Cannot perform update: " + exception);
        }
    }

    public void deleteSelectedRecord(InformationEntity informationEntity, String string) throws DicomException {
        try {
            if (informationEntity != null) {
                String string2 = DatabaseInformationModel.getTableNameForInformationEntity(informationEntity);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("DELETE FROM ");
                stringBuffer.append(string2);
                if (string != null) {
                    stringBuffer.append(" WHERE ");
                    stringBuffer.append(localPrimaryKeyColumnName);
                    stringBuffer.append(" = '");
                    stringBuffer.append(string);
                    stringBuffer.append("'");
                }
                stringBuffer.append(";");
                Statement statement = this.databaseConnection.createStatement();
                ResultSet resultSet = statement.executeQuery(stringBuffer.toString());
                statement.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            throw new DicomException("Cannot perform deletion: " + exception);
        }
    }

    public Map findAllAttributeValuesForSelectedRecord(InformationEntity informationEntity, String string) throws DicomException {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        try {
            if (informationEntity != null) {
                String string2 = DatabaseInformationModel.getTableNameForInformationEntity(informationEntity);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("SELECT * FROM ");
                stringBuffer.append(string2);
                if (string != null) {
                    stringBuffer.append(" WHERE ");
                    stringBuffer.append(localPrimaryKeyColumnName);
                    stringBuffer.append(" = '");
                    stringBuffer.append(string);
                    stringBuffer.append("'");
                }
                stringBuffer.append(";");
                Statement statement = this.databaseConnection.createStatement();
                ResultSet resultSet = statement.executeQuery(stringBuffer.toString());
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int n = resultSetMetaData.getColumnCount();
                if (resultSet.next()) {
                    for (int i = 1; i <= n; ++i) {
                        String string3 = resultSetMetaData.getColumnName(i);
                        String string4 = resultSet.getString(i);
                        treeMap.put(string3, string4);
                    }
                }
                statement.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            throw new DicomException("Cannot perform selection: " + exception);
        }
        return treeMap;
    }

    public ArrayList findAllAttributeValuesForAllRecordsForThisInformationEntity(InformationEntity informationEntity) throws DicomException {
        ArrayList arrayList = new ArrayList();
        try {
            if (informationEntity != null) {
                String string = DatabaseInformationModel.getTableNameForInformationEntity(informationEntity);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("SELECT * FROM ");
                stringBuffer.append(string);
                stringBuffer.append(";");
                Statement statement = this.databaseConnection.createStatement();
                ResultSet resultSet = statement.executeQuery(stringBuffer.toString());
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int n = resultSetMetaData.getColumnCount();
                while (resultSet.next()) {
                    TreeMap<String, String> treeMap = new TreeMap<String, String>();
                    for (int i = 1; i <= n; ++i) {
                        String string2 = resultSetMetaData.getColumnName(i);
                        String string3 = resultSet.getString(i);
                        treeMap.put(string2, string3);
                    }
                    arrayList.add(treeMap);
                }
                statement.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            throw new DicomException("Cannot perform selection: " + exception);
        }
        return arrayList;
    }

    public ArrayList findAllAttributeValuesForAllRecordsForThisInformationEntityWithSpecifiedUID(InformationEntity informationEntity, String string) throws DicomException {
        ArrayList arrayList = new ArrayList();
        try {
            if (informationEntity != null && string != null) {
                String string2 = this.getUIDColumnNameForInformationEntity(informationEntity).toUpperCase();
                String string3 = DatabaseInformationModel.getTableNameForInformationEntity(informationEntity);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("SELECT * FROM ");
                stringBuffer.append(string3);
                stringBuffer.append(" WHERE ");
                stringBuffer.append(string2);
                stringBuffer.append(" = ");
                stringBuffer.append("'");
                stringBuffer.append(string);
                stringBuffer.append("'");
                stringBuffer.append(";");
                Statement statement = this.databaseConnection.createStatement();
                ResultSet resultSet = statement.executeQuery(stringBuffer.toString());
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int n = resultSetMetaData.getColumnCount();
                while (resultSet.next()) {
                    TreeMap<String, String> treeMap = new TreeMap<String, String>();
                    for (int i = 1; i <= n; ++i) {
                        String string4 = resultSetMetaData.getColumnName(i);
                        String string5 = resultSet.getString(i);
                        treeMap.put(string4, string5);
                    }
                    arrayList.add(treeMap);
                }
                statement.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            throw new DicomException("Cannot perform selection: " + exception);
        }
        return arrayList;
    }

    private final String[] getArrayOfColumnNamesForSpecifiedInformationEntity(InformationEntity informationEntity, ResultSet resultSet) throws SQLException {
        String[] stringArray;
        if (this.mapOfInformationEntitiesToColumnNames == null) {
            this.mapOfInformationEntitiesToColumnNames = new HashMap();
        }
        if ((stringArray = (String[])this.mapOfInformationEntitiesToColumnNames.get(informationEntity)) == null) {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 1; i <= n; ++i) {
                String string = resultSetMetaData.getColumnName(i);
                arrayList.add(string);
            }
            stringArray = new String[n];
            stringArray = arrayList.toArray(stringArray);
            this.mapOfInformationEntitiesToColumnNames.put(informationEntity, stringArray);
        }
        return stringArray;
    }

    public ArrayList findAllAttributeValuesForAllRecordsForThisInformationEntityWithSpecifiedParent(InformationEntity informationEntity, String string) throws DicomException {
        ArrayList arrayList = new ArrayList();
        try {
            if (informationEntity != null) {
                String string2 = DatabaseInformationModel.getTableNameForInformationEntity(informationEntity);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("SELECT * FROM ");
                stringBuffer.append(string2);
                if (informationEntity != this.rootInformationEntity && string != null) {
                    stringBuffer.append(" WHERE ");
                    stringBuffer.append(localParentReferenceColumnName);
                    stringBuffer.append(" = '");
                    stringBuffer.append(string);
                    stringBuffer.append("'");
                }
                stringBuffer.append(";");
                Statement statement = this.databaseConnection.createStatement();
                ResultSet resultSet = statement.executeQuery(stringBuffer.toString());
                String[] stringArray = this.getArrayOfColumnNamesForSpecifiedInformationEntity(informationEntity, resultSet);
                int n = stringArray.length;
                while (resultSet.next()) {
                    TreeMap<String, String> treeMap = new TreeMap<String, String>();
                    for (int i = 1; i <= n; ++i) {
                        String string3 = stringArray[i - 1];
                        String string4 = resultSet.getString(i);
                        treeMap.put(string3, string4);
                    }
                    arrayList.add(treeMap);
                }
                statement.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            throw new DicomException("Cannot perform selection: " + exception);
        }
        return arrayList;
    }

    public ArrayList findAllAttributeValuesForAllRecordsForThisInformationEntityWithMatchingParent(InformationEntity informationEntity, InformationEntity informationEntity2, String string, String string2) throws DicomException {
        ArrayList arrayList = new ArrayList();
        try {
            if (informationEntity != null && informationEntity2 != null) {
                String string3 = DatabaseInformationModel.getTableNameForInformationEntity(informationEntity);
                String string4 = DatabaseInformationModel.getTableNameForInformationEntity(informationEntity2);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("SELECT * FROM ");
                stringBuffer.append(string3);
                stringBuffer.append(",");
                stringBuffer.append(string4);
                stringBuffer.append(" WHERE ");
                stringBuffer.append(string3);
                stringBuffer.append(".");
                stringBuffer.append(localParentReferenceColumnName.toUpperCase());
                stringBuffer.append(" = ");
                stringBuffer.append(string4);
                stringBuffer.append(".");
                stringBuffer.append(localPrimaryKeyColumnName.toUpperCase());
                stringBuffer.append(" AND ");
                stringBuffer.append(string4);
                stringBuffer.append(".");
                stringBuffer.append(string.toUpperCase());
                stringBuffer.append(" = '");
                stringBuffer.append(string2);
                stringBuffer.append("'");
                stringBuffer.append(";");
                String string5 = stringBuffer.toString();
                Statement statement = this.databaseConnection.createStatement();
                ResultSet resultSet = statement.executeQuery(string5);
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int n = resultSetMetaData.getColumnCount();
                while (resultSet.next()) {
                    TreeMap<String, String> treeMap = new TreeMap<String, String>();
                    for (int i = 1; i <= n; ++i) {
                        String string6 = resultSetMetaData.getColumnName(i);
                        String string7 = resultSet.getString(i);
                        treeMap.put(string6, string7);
                    }
                    arrayList.add(treeMap);
                }
                statement.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            throw new DicomException("Cannot perform selection: " + exception);
        }
        return arrayList;
    }

    static String getTableNameForInformationEntity(InformationEntity informationEntity) {
        return informationEntity.toString().toUpperCase();
    }

    public abstract InformationEntity getChildTypeForParent(InformationEntity var1);

    public abstract InformationEntity getChildTypeForParent(InformationEntity var1, boolean var2);

    public abstract InformationEntity getChildTypeForParent(InformationEntity var1, AttributeList var2);

    public abstract String getNametoDescribeThisInstanceOfInformationEntity(InformationEntity var1, Map var2);

    public abstract String getDescriptiveColumnName(InformationEntity var1);

    public abstract String getOtherDescriptiveColumnName(InformationEntity var1);

    public abstract String getOtherOtherDescriptiveColumnName(InformationEntity var1);

    public abstract String getUIDColumnNameForInformationEntity(InformationEntity var1);

    public String getLocalPrimaryKeyColumnName(InformationEntity informationEntity) {
        return localPrimaryKeyColumnName;
    }

    public String localFileNameColumnName(InformationEntity informationEntity) {
        return localFileName;
    }

    public String getLocalParentReferenceColumnName(InformationEntity informationEntity) {
        return localParentReferenceColumnName;
    }

    public static String getSQLTypeFromDicomValueRepresentation(byte[] byArray) {
        Object object = ValueRepresentation.isApplicationEntityVR(byArray) ? "CHAR(16)" : (ValueRepresentation.isAgeStringVR(byArray) ? "CHAR(4)" : (ValueRepresentation.isCodeStringVR(byArray) ? "CHAR(16)" : (ValueRepresentation.isDateVR(byArray) ? "CHAR(10)" : (ValueRepresentation.isDateTimeVR(byArray) ? "CHAR(14)" : (ValueRepresentation.isDecimalStringVR(byArray) ? "VARCHAR(255)" : (ValueRepresentation.isFloatDoubleVR(byArray) ? "REAL" : (ValueRepresentation.isFloatSingleVR(byArray) ? "REAL" : (ValueRepresentation.isIntegerStringVR(byArray) ? "INTEGER" : (ValueRepresentation.isLongStringVR(byArray) ? "VARCHAR(255)" : (ValueRepresentation.isLongTextVR(byArray) ? "VARCHAR(255)" : (ValueRepresentation.isOtherByteVR(byArray) ? null : (ValueRepresentation.isOtherWordVR(byArray) ? null : (ValueRepresentation.isOtherUnspecifiedVR(byArray) ? null : (ValueRepresentation.isPersonNameVR(byArray) ? "VARCHAR(255)" : (ValueRepresentation.isSequenceVR(byArray) ? null : (ValueRepresentation.isShortStringVR(byArray) ? "VARCHAR(255)" : (ValueRepresentation.isSignedLongVR(byArray) ? "INTEGER" : (ValueRepresentation.isSignedShortVR(byArray) ? "INTEGER" : (ValueRepresentation.isShortTextVR(byArray) ? "VARCHAR(255)" : (ValueRepresentation.isTimeVR(byArray) ? "CHAR(8)" : (ValueRepresentation.isUniqueIdentifierVR(byArray) ? "CHAR(64)" : (ValueRepresentation.isUnsignedLongVR(byArray) ? "INTEGER" : (ValueRepresentation.isUnknownVR(byArray) ? null : (ValueRepresentation.isUnsignedShortVR(byArray) ? "INTEGER" : (ValueRepresentation.isUnlimitedTextVR(byArray) ? "VARCHAR(255)" : null)))))))))))))))))))))))));
        return object;
    }

    protected static void appendExactOrIsNullMatch(StringBuffer stringBuffer, String string) {
        if (string == null || string.length() == 0 || string.equals("NULL")) {
            stringBuffer.append(" IS NULL");
        } else {
            stringBuffer.append(" =");
            stringBuffer.append(string);
        }
    }

    public QueryResponseGeneratorFactory getQueryResponseGeneratorFactory(int n) {
        return null;
    }

    public RetrieveResponseGeneratorFactory getRetrieveResponseGeneratorFactory(int n) {
        return null;
    }

    public InformationEntity getInformationEntityFromTag(AttributeTag attributeTag) {
        return this.dictionary.getInformationEntityFromTag(attributeTag);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.listsOfAttributesByInformationEntity);
        stringBuffer.append("\n");
        try {
            DatabaseMetaData databaseMetaData = this.databaseConnection.getMetaData();
            ResultSet resultSet = databaseMetaData.getColumns(null, null, null, null);
            while (resultSet.next()) {
                stringBuffer.append("catalog = ");
                stringBuffer.append(resultSet.getString(1));
                stringBuffer.append("; ");
                stringBuffer.append("schema  = ");
                stringBuffer.append(resultSet.getString(2));
                stringBuffer.append("; ");
                stringBuffer.append("table   = ");
                stringBuffer.append(resultSet.getString(3));
                stringBuffer.append("; ");
                stringBuffer.append("column  = ");
                stringBuffer.append(resultSet.getString(4));
                stringBuffer.append("; ");
                stringBuffer.append("type    = ");
                stringBuffer.append(resultSet.getString(6));
                stringBuffer.append("; ");
                stringBuffer.append("size    = ");
                stringBuffer.append(resultSet.getInt(7));
                stringBuffer.append("; ");
                stringBuffer.append("\n");
            }
            resultSet.close();
        }
        catch (Exception exception) {
            stringBuffer.append(exception);
        }
        return stringBuffer.toString();
    }
}

