/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.display;

import com.pixelmed.display.event.StatusChangeEvent;
import com.pixelmed.display.event.WindowCenterAndWidthChangeEvent;
import com.pixelmed.event.ApplicationEventDispatcher;
import com.pixelmed.event.Event;
import com.pixelmed.event.SelfRegisteringListener;
import javax.swing.JLabel;

class StatusBarManager {
    private OurStatusChangeListener ourStatusChangeListener;
    private OurWindowCenterAndWidthChangeListener ourWindowCenterAndWidthChangeListener;
    private JLabel statusBar = new JLabel("                                                                                                                      ");

    public StatusBarManager(String string) {
        this.statusBar.setText(string);
        this.ourStatusChangeListener = new OurStatusChangeListener(this.statusBar);
        this.ourWindowCenterAndWidthChangeListener = new OurWindowCenterAndWidthChangeListener();
    }

    public JLabel getStatusBar() {
        return this.statusBar;
    }

    class OurWindowCenterAndWidthChangeListener
    extends SelfRegisteringListener {
        public OurWindowCenterAndWidthChangeListener() {
            super("com.pixelmed.display.event.WindowCenterAndWidthChangeEvent", null);
        }

        public void changed(Event event) {
            WindowCenterAndWidthChangeEvent windowCenterAndWidthChangeEvent = (WindowCenterAndWidthChangeEvent)event;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("C ");
            stringBuffer.append(windowCenterAndWidthChangeEvent.getWindowCenter());
            stringBuffer.append(" W ");
            stringBuffer.append(windowCenterAndWidthChangeEvent.getWindowWidth());
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent(stringBuffer.toString()));
        }
    }

    class OurStatusChangeListener
    extends SelfRegisteringListener {
        private JLabel statusBar;

        public OurStatusChangeListener(JLabel jLabel) {
            super("com.pixelmed.display.event.StatusChangeEvent", null);
            this.statusBar = jLabel;
        }

        public void changed(Event event) {
            StatusChangeEvent statusChangeEvent = (StatusChangeEvent)event;
            this.statusBar.setText(statusChangeEvent.getStatusMessage());
            this.statusBar.revalidate();
            this.statusBar.paintImmediately(this.statusBar.getVisibleRect());
        }
    }
}

