/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.display;

import com.pixelmed.display.BufferedImageUtilities;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ByteLookupTable;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.LookupOp;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;

public class WindowCenterAndWidth {
    protected static void applyPaddingValueRangeToLUT(byte[] byArray, int n, int n2, int n3) {
        int n4 = n & n3;
        int n5 = n2 & n3;
        int n6 = n4 <= n5 ? 1 : -1;
        for (int i = n4; i != n5; i += n6) {
            byArray[i] = 0;
        }
        byArray[n5] = 0;
    }

    public static final BufferedImage applyWindowCenterAndWidthLogistic(BufferedImage bufferedImage, double d, double d2, boolean bl, boolean bl2, double d3, double d4, boolean bl3, int n) {
        return WindowCenterAndWidth.applyWindowCenterAndWidthLogistic(bufferedImage, d, d2, bl, bl2, d3, d4, bl3, n, n);
    }

    public static final BufferedImage applyWindowCenterAndWidthLogistic(BufferedImage bufferedImage, double d, double d2, boolean bl, boolean bl2, double d3, double d4, boolean bl3, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6 = 0;
        int n7 = 255;
        byte[] byArray = null;
        int n8 = bufferedImage.getSampleModel().getDataType();
        if (n8 == 2 || n8 == 1) {
            n5 = bl ? Short.MIN_VALUE : 0;
            n4 = bl ? 32768 : 65536;
            byArray = new byte[65536];
            n3 = 65535;
        } else if (n8 == 0) {
            n5 = bl ? -128 : 0;
            n4 = bl ? 128 : 256;
            byArray = new byte[256];
            n3 = 255;
        } else {
            throw new IllegalArgumentException();
        }
        int n9 = n7 - n6;
        for (int i = n5; i < n4; ++i) {
            double d5 = (double)i * d3 + d4;
            double d6 = (double)n9 / (1.0 + Math.exp(-4.0 * (d5 - d) / d2)) + (double)n6 + 0.5;
            if (d6 < (double)n6) {
                d6 = n6;
            } else if (d6 > (double)n7) {
                d6 = n7;
            }
            if (bl2) {
                d6 = (byte)((double)n7 - d6);
            }
            byArray[i & n3] = (byte)d6;
        }
        if (bl3) {
            WindowCenterAndWidth.applyPaddingValueRangeToLUT(byArray, n, n2, n3);
        }
        LookupOp lookupOp = new LookupOp(new ByteLookupTable(0, byArray), null);
        ComponentColorModel componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{8}, false, false, 1, 0);
        BufferedImage bufferedImage2 = lookupOp.filter(bufferedImage, lookupOp.createCompatibleDestImage(bufferedImage, componentColorModel));
        return bufferedImage2;
    }

    public static final BufferedImage applyWindowCenterAndWidthLinear(BufferedImage bufferedImage, double d, double d2, boolean bl, boolean bl2, double d3, double d4, boolean bl3, int n) {
        return WindowCenterAndWidth.applyWindowCenterAndWidthLinear(bufferedImage, d, d2, bl, bl2, d3, d4, bl3, n, n);
    }

    public static final BufferedImage applyWindowCenterAndWidthLinear(BufferedImage bufferedImage, double d, double d2, boolean bl, boolean bl2, double d3, double d4, boolean bl3, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6 = 0;
        int n7 = 255;
        byte by = (byte)n6;
        byte by2 = (byte)n7;
        double d5 = n7 - n6;
        double d6 = d - 0.5;
        double d7 = d2 - 1.0;
        double d8 = d7 / 2.0;
        double d9 = d6 - d8;
        double d10 = d6 + d8;
        byte[] byArray = null;
        int n8 = bufferedImage.getSampleModel().getDataType();
        if (n8 == 2 || n8 == 1) {
            n5 = bl ? Short.MIN_VALUE : 0;
            n4 = bl ? 32768 : 65536;
            byArray = new byte[65536];
            n3 = 65535;
        } else if (n8 == 0) {
            n5 = bl ? -128 : 0;
            n4 = bl ? 128 : 256;
            byArray = new byte[256];
            n3 = 255;
        } else {
            throw new IllegalArgumentException();
        }
        for (int i = n5; i < n4; ++i) {
            double d11 = (double)i * d3 + d4;
            byte by3 = d11 <= d9 ? by : (d11 > d10 ? by2 : (byte)(((d11 - d6) / d7 + 0.5) * d5 + (double)n6));
            if (bl2) {
                by3 = (byte)(n7 - by3);
            }
            byArray[i & n3] = by3;
        }
        if (bl3) {
            WindowCenterAndWidth.applyPaddingValueRangeToLUT(byArray, n, n2, n3);
        }
        LookupOp lookupOp = new LookupOp(new ByteLookupTable(0, byArray), null);
        ComponentColorModel componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{8}, false, false, 1, 0);
        BufferedImage bufferedImage2 = lookupOp.filter(bufferedImage, lookupOp.createCompatibleDestImage(bufferedImage, componentColorModel));
        return bufferedImage2;
    }

    public static final BufferedImage applyWindowCenterAndWidthWithPaletteColor(BufferedImage bufferedImage, double d, double d2, boolean bl, boolean bl2, double d3, double d4, boolean bl3, int n, int n2, int n3, int n4, short[] sArray, short[] sArray2, short[] sArray3) {
        return WindowCenterAndWidth.applyWindowCenterAndWidthWithPaletteColor(bufferedImage, d, d2, bl, bl2, d3, d4, bl3, n, n, n2, n3, n4, sArray, sArray2, sArray3);
    }

    public static final BufferedImage applyWindowCenterAndWidthWithPaletteColor(BufferedImage bufferedImage, double d, double d2, boolean bl, boolean bl2, double d3, double d4, boolean bl3, int n, int n2, int n3, int n4, int n5, short[] sArray, short[] sArray2, short[] sArray3) {
        int n6;
        int n7;
        int n8 = 0;
        int n9 = 255;
        int n10 = n8;
        int n11 = n9;
        double d5 = n9 - n8;
        double d6 = d - 0.5;
        double d7 = d2 - 1.0;
        double d8 = d7 / 2.0;
        double d9 = d6 - d8;
        double d10 = d6 + d8;
        int n12 = bl ? Short.MIN_VALUE : 0;
        int n13 = bl ? 32768 : 65536;
        byte[] byArray = new byte[65536];
        byte[] byArray2 = new byte[65536];
        byte[] byArray3 = new byte[65536];
        for (n7 = n12; n7 < n13; ++n7) {
            double d11 = (double)n7 * d3 + d4;
            n6 = d11 <= d9 ? n10 : (d11 > d10 ? n11 : (int)((byte)(((d11 - d6) / d7 + 0.5) * d5 + (double)n8)));
            if (bl2) {
                n6 = (byte)(n9 - n6);
            }
            byArray[n7 & 0xFFFF] = n6;
            byArray2[n7 & 0xFFFF] = n6;
            byArray3[n7 & 0xFFFF] = n6;
        }
        n7 = n4 - 8;
        int n14 = n3 + 1;
        for (int i = 0; i < n5; ++i) {
            byArray[n14 & 0xFFFF] = (byte)(sArray[i] >> n7);
            byArray2[n14 & 0xFFFF] = (byte)(sArray2[i] >> n7);
            byArray3[n14 & 0xFFFF] = (byte)(sArray3[i] >> n7);
            ++n14;
        }
        if (bl3) {
            WindowCenterAndWidth.applyPaddingValueRangeToLUT(byArray, n, n2, 65535);
            WindowCenterAndWidth.applyPaddingValueRangeToLUT(byArray2, n, n2, 65535);
            WindowCenterAndWidth.applyPaddingValueRangeToLUT(byArray3, n, n2, 65535);
        }
        n6 = bufferedImage.getWidth();
        int n15 = bufferedImage.getHeight();
        SampleModel sampleModel = bufferedImage.getSampleModel();
        WritableRaster writableRaster = bufferedImage.getRaster();
        DataBuffer dataBuffer = writableRaster.getDataBuffer();
        int n16 = writableRaster.getNumBands();
        ColorModel colorModel = BufferedImageUtilities.getMostFavorableColorModel();
        if (colorModel == null) {
            colorModel = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8}, false, false, 1, 0);
        }
        WritableRaster writableRaster2 = colorModel.createCompatibleWritableRaster(n6, n15);
        DataBuffer dataBuffer2 = writableRaster2.getDataBuffer();
        BufferedImage bufferedImage2 = new BufferedImage(colorModel, writableRaster2, colorModel.isAlphaPremultiplied(), null);
        SampleModel sampleModel2 = bufferedImage2.getSampleModel();
        int n17 = writableRaster2.getNumBands();
        int[] nArray = null;
        nArray = sampleModel.getPixels(0, 0, n6, n15, nArray, dataBuffer);
        int n18 = nArray.length;
        int[] nArray2 = null;
        nArray2 = sampleModel2.getPixels(0, 0, n6, n15, nArray2, dataBuffer2);
        int n19 = nArray2.length;
        if (n16 == 1 && n17 == 4 && n18 * 4 == n19) {
            int n20 = 0;
            for (int i = 0; i < n18; ++i) {
                nArray2[n20++] = byArray[nArray[i]];
                nArray2[n20++] = byArray2[nArray[i]];
                nArray2[n20++] = byArray3[nArray[i]];
                nArray2[n20++] = -1;
            }
            sampleModel2.setPixels(0, 0, n6, n15, nArray2, dataBuffer2);
        } else if (n16 == 1 && n17 == 3 && n18 * 3 == n19) {
            int n21 = 0;
            for (int i = 0; i < n18; ++i) {
                nArray2[n21++] = byArray[nArray[i]];
                nArray2[n21++] = byArray2[nArray[i]];
                nArray2[n21++] = byArray3[nArray[i]];
            }
            sampleModel2.setPixels(0, 0, n6, n15, nArray2, dataBuffer2);
        }
        return bufferedImage2;
    }

    public static final BufferedImage applyVOILUT(BufferedImage bufferedImage, double d, double d2, double d3, double d4, boolean bl, boolean bl2, double d5, double d6, boolean bl3, int n, int n2, int n3, int n4, int n5, short[] sArray, int n6, int n7, int n8) {
        int n9;
        int n10;
        int n11;
        int n12 = 0;
        int n13 = 255;
        double d7 = n13 - n12;
        int n14 = 0;
        double d8 = n8 - n14;
        int n15 = sArray[0] & 0xFFFF;
        int n16 = sArray[n3 - 1] & 0xFFFF;
        byte by = (byte)((double)(n15 - n14) / d8 * d7 + (double)n12);
        byte by2 = (byte)((double)(n16 - n14) / d8 * d7 + (double)n12);
        byte[] byArray = null;
        int n17 = bufferedImage.getSampleModel().getDataType();
        if (n17 == 2 || n17 == 1) {
            n11 = bl ? Short.MIN_VALUE : 0;
            n10 = bl ? 32768 : 65536;
            byArray = new byte[65536];
            n9 = 65535;
        } else if (n17 == 0) {
            n11 = bl ? -128 : 0;
            n10 = bl ? 128 : 256;
            byArray = new byte[256];
            n9 = 255;
        } else {
            throw new IllegalArgumentException();
        }
        for (int i = n11; i < n10; ++i) {
            double d9 = (double)i * d5 + d6;
            int n18 = (int)((d9 - d) / d2 * d4 + d3 - (double)n4);
            byte by3 = n18 < 0 ? by : (n18 > n3 - 1 ? by2 : (byte)((double)(sArray[n18] & 0xFFFF) / d8 * d7 + (double)n12));
            if (bl2) {
                by3 = (byte)(n13 - by3);
            }
            byArray[i & n9] = by3;
        }
        if (bl3) {
            WindowCenterAndWidth.applyPaddingValueRangeToLUT(byArray, n, n2, n9);
        }
        LookupOp lookupOp = new LookupOp(new ByteLookupTable(0, byArray), null);
        ComponentColorModel componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{8}, false, false, 1, 0);
        BufferedImage bufferedImage2 = lookupOp.filter(bufferedImage, lookupOp.createCompatibleDestImage(bufferedImage, componentColorModel));
        return bufferedImage2;
    }
}

