/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.geometry;

import com.pixelmed.geometry.GeometryOfSlice;

public abstract class GeometryOfVolume {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/geometry/GeometryOfVolume.java,v 1.10 2004/12/27 20:32:31 dclunie Exp $";
    protected GeometryOfSlice[] frames;
    protected boolean isVolume;

    public final GeometryOfSlice[] getGeometryOfSlices() {
        return this.frames;
    }

    public final double[] lookupImageCoordinate(int n, int n2, int n3) {
        double[] dArray = null;
        if (this.frames != null && n3 < this.frames.length && this.frames[n3] != null) {
            dArray = this.frames[n3].lookupImageCoordinate(n, n2);
        }
        return dArray;
    }

    public final void lookupImageCoordinate(double[] dArray, int n, int n2, int n3) {
        if (this.frames != null && n3 < this.frames.length && this.frames[n3] != null) {
            this.frames[n3].lookupImageCoordinate(dArray, n, n2);
        } else {
            dArray[0] = 0.0;
            dArray[1] = 0.0;
            dArray[2] = 0.0;
        }
    }

    public final double[] lookupImageCoordinate(double[] dArray) {
        double[] dArray2 = new double[3];
        this.lookupImageCoordinate(dArray2, dArray);
        return dArray2;
    }

    public final void lookupImageCoordinate(double[] dArray, double[] dArray2) {
        double[] dArray3 = this.frames[0].getRowArray();
        double[] dArray4 = this.frames[0].getColumnArray();
        double[] dArray5 = this.frames[0].getNormalArray();
        double[] dArray6 = this.frames[0].getTLHCArray();
        double[] dArray7 = this.frames[0].getVoxelSpacingArray();
        double d = (((dArray2[0] - dArray6[0]) * dArray4[1] * dArray7[0] - (dArray2[1] - dArray6[1]) * dArray4[0] * dArray7[0]) * (dArray3[2] * dArray7[1] * dArray4[1] * dArray7[0] - dArray3[1] * dArray7[1] * dArray4[2] * dArray7[0]) - ((dArray2[2] - dArray6[2]) * dArray4[1] * dArray7[0] - (dArray2[1] - dArray6[1]) * dArray4[2] * dArray7[0]) * (dArray3[0] * dArray7[1] * dArray4[1] * dArray7[0] - dArray3[1] * dArray7[1] * dArray4[0] * dArray7[0])) / ((dArray5[0] * dArray7[2] * dArray4[1] * dArray7[0] + dArray5[1] * dArray7[2] * dArray4[0] * dArray7[0]) * (dArray3[2] * dArray7[1] * dArray4[1] * dArray7[0] - dArray3[1] * dArray7[1] * dArray4[2] * dArray7[0]) - (dArray5[2] * dArray7[2] * dArray4[1] * dArray7[0] + dArray5[1] * dArray7[2] * dArray4[2] * dArray7[0]) * (dArray3[0] * dArray7[1] * dArray4[1] * dArray7[0] - dArray3[1] * dArray7[1] * dArray4[0] * dArray7[0]));
        double d2 = ((dArray2[0] - dArray6[0] - d * dArray5[0] * dArray7[2]) * dArray4[1] * dArray7[0] - (dArray2[1] - dArray6[1] - d * dArray5[1] * dArray7[2]) * dArray4[0] * dArray7[0]) / (dArray3[0] * dArray7[1] * dArray4[1] * dArray7[0] - dArray3[1] * dArray7[1] * dArray4[0] * dArray7[0]);
        double d3 = (dArray2[1] - dArray6[1] - d2 * dArray3[1] * dArray7[1] - d * dArray5[1] * dArray7[2]) / (dArray4[1] * dArray7[0]);
        dArray[0] = d2;
        dArray[1] = d3;
        dArray[2] = d;
    }

    public final int findClosestSliceInSamePlane(GeometryOfSlice geometryOfSlice) {
        double d = geometryOfSlice.getDistanceAlongNormalFromOrigin();
        int n = -1;
        double d2 = 9.99999999E8;
        for (int i = 0; i < this.frames.length; ++i) {
            double d3 = Math.abs(this.frames[i].getDistanceAlongNormalFromOrigin() - d);
            if (!(d3 < d2)) continue;
            d2 = d3;
            n = i;
        }
        return n;
    }

    public final double[] getDistanceAlongNormalFromOrigin() {
        double[] dArray = new double[this.frames.length];
        for (int i = 0; i < this.frames.length; ++i) {
            dArray[i] = this.frames[i].getDistanceAlongNormalFromOrigin();
        }
        return dArray;
    }

    public final boolean isVolumeSampledRegularlyAlongFrameDimension() {
        return this.isVolume;
    }

    public final void checkAndSetVolumeSampledRegularlyAlongFrameDimension() {
        if (this.frames != null && this.frames.length > 1) {
            GeometryOfSlice geometryOfSlice = this.frames[0];
            GeometryOfSlice geometryOfSlice2 = this.frames[1];
            double d = geometryOfSlice.getDistanceAlongNormalFromOrigin();
            if (GeometryOfSlice.areSlicesParallel(geometryOfSlice, geometryOfSlice2)) {
                int n;
                double d2 = geometryOfSlice2.getDistanceAlongNormalFromOrigin();
                double d3 = d2 - d;
                d = d2;
                boolean bl = true;
                for (n = 2; n < this.frames.length && bl; ++n) {
                    geometryOfSlice2 = this.frames[n];
                    if (GeometryOfSlice.areSlicesParallel(geometryOfSlice, geometryOfSlice2)) {
                        d2 = geometryOfSlice2.getDistanceAlongNormalFromOrigin();
                        double d4 = d2 - d;
                        if (Math.abs(d4 - d3) >= 0.001) {
                            bl = false;
                        }
                        d = d2;
                        continue;
                    }
                    bl = false;
                }
                if (bl) {
                    this.isVolume = true;
                    d3 = Math.abs(d3);
                    for (n = 0; n < this.frames.length; ++n) {
                        this.frames[n].setVoxelSpacingBetweenSlices(d3);
                    }
                }
            }
        }
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.frames.length; ++i) {
            stringBuffer.append("[");
            stringBuffer.append(i);
            stringBuffer.append("] ");
            stringBuffer.append(this.frames[i].toString());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public final String getRowOrientation(int n) {
        return this.frames != null && n < this.frames.length ? this.frames[n].getRowOrientation() : "";
    }

    public final String getColumnOrientation(int n) {
        return this.frames != null && n < this.frames.length ? this.frames[n].getColumnOrientation() : "";
    }
}

