/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.network;

import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.NetworkApplicationInformation;
import com.pixelmed.network.NetworkConfigurationSource;
import com.pixelmed.network.NetworkDefaultValues;
import java.io.FileInputStream;
import java.util.Properties;
import java.util.StringTokenizer;

public class NetworkApplicationProperties {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/network/NetworkApplicationProperties.java,v 1.15 2007/08/09 15:17:40 dclunie Exp $";
    public static final String propertyName_DicomListeningPort = "Dicom.ListeningPort";
    public static final String propertyName_DicomCalledAETitle = "Dicom.CalledAETitle";
    public static final String propertyName_DicomCallingAETitle = "Dicom.CallingAETitle";
    public static final String propertyName_PrimaryDeviceType = "Dicom.PrimaryDeviceType";
    public static final String propertyName_DicomRemoteAEs = "Dicom.RemoteAEs";
    private static final String propertyNameSuffix_CalledAETitle = "CalledAETitle";
    private static final String propertyNameSuffix_HostNameOrIPAddress = "HostNameOrIPAddress";
    private static final String propertyNameSuffix_Port = "Port";
    private static final String propertyNameSuffix_QueryModel = "QueryModel";
    private static final String propertyNameSuffix_PrimaryDeviceType = "PrimaryDeviceType";
    public static final String StudyRootQueryModel = "STUDYROOT";
    public static final String PatientRootQueryModel = "PATIENTROOT";
    public static final String PatientStudyOnlyQueryModel = "PATIENTSTUDYONLY";
    private static final String propertyDelimitersForTokenizer_DicomRemoteAEs = ", ";
    public static final String propertyName_QueryDebugLevel = "Dicom.QueryDebugLevel";
    public static final String propertyName_StorageSCUDebugLevel = "Dicom.StorageSCUDebugLevel";
    public static final String propertyName_StorageSCUCompressionLevel = "Dicom.StorageSCUCompressionLevel";
    public static final String propertyName_StorageSCPDebugLevel = "Dicom.StorageSCPDebugLevel";
    public static final String propertyName_NetworkDynamicConfigurationDebugLevel = "Network.DynamicConfigurationDebugLevel";
    private int port;
    private String calledAETitle;
    private String callingAETitle;
    private String primaryDeviceType;
    private int storageSCUCompressionLevel;
    private int storageSCUDebugLevel;
    private int storageSCPDebugLevel;
    private int queryDebugLevel;
    private int networkDynamicConfigurationDebugLevel;
    private NetworkApplicationInformation networkApplicationInformation;
    protected NetworkConfigurationSource networkConfigurationSource = null;

    public static final boolean isStudyRootQueryModel(String string) {
        return string != null && string.equals(StudyRootQueryModel);
    }

    public static final boolean isPatientRootQueryModel(String string) {
        return string != null && string.equals(PatientRootQueryModel);
    }

    public static final boolean isPatientStudyOnlyQueryModel(String string) {
        return string != null && string.equals(PatientStudyOnlyQueryModel);
    }

    public NetworkApplicationProperties() throws DicomNetworkException {
        this.port = 11112;
        this.callingAETitle = this.calledAETitle = NetworkDefaultValues.getDefaultApplicationEntityTitle(this.port);
        this.primaryDeviceType = NetworkDefaultValues.getDefaultPrimaryDeviceType();
        this.storageSCUCompressionLevel = 0;
        this.storageSCUDebugLevel = 0;
        this.storageSCPDebugLevel = 0;
        this.queryDebugLevel = 0;
        this.networkDynamicConfigurationDebugLevel = 0;
        this.networkApplicationInformation = new NetworkApplicationInformation();
    }

    public NetworkApplicationProperties(Properties properties) throws DicomNetworkException {
        String string = properties.getProperty(propertyName_DicomListeningPort);
        this.port = string == null || string.length() == 0 ? 11112 : Integer.parseInt(string);
        this.calledAETitle = properties.getProperty(propertyName_DicomCalledAETitle);
        if (this.calledAETitle == null || this.calledAETitle.length() == 0) {
            this.calledAETitle = NetworkDefaultValues.getDefaultApplicationEntityTitle(this.port);
        }
        this.callingAETitle = properties.getProperty(propertyName_DicomCallingAETitle);
        if (this.callingAETitle == null || this.callingAETitle.length() == 0) {
            this.callingAETitle = this.calledAETitle;
        }
        this.primaryDeviceType = properties.getProperty(propertyName_PrimaryDeviceType);
        this.storageSCUCompressionLevel = Integer.valueOf(properties.getProperty(propertyName_StorageSCUCompressionLevel, "0"));
        this.storageSCUDebugLevel = Integer.valueOf(properties.getProperty(propertyName_StorageSCUDebugLevel, "0"));
        this.storageSCPDebugLevel = Integer.valueOf(properties.getProperty(propertyName_StorageSCPDebugLevel, "0"));
        this.queryDebugLevel = Integer.valueOf(properties.getProperty(propertyName_QueryDebugLevel, "0"));
        this.networkDynamicConfigurationDebugLevel = Integer.valueOf(properties.getProperty(propertyName_NetworkDynamicConfigurationDebugLevel, "0"));
        this.networkApplicationInformation = new NetworkApplicationInformation();
        String string2 = properties.getProperty(propertyName_DicomRemoteAEs);
        if (string2 != null && string2.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, propertyDelimitersForTokenizer_DicomRemoteAEs);
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                String string4 = properties.getProperty("Dicom.RemoteAEs." + string3 + "." + propertyNameSuffix_CalledAETitle);
                String string5 = properties.getProperty("Dicom.RemoteAEs." + string3 + "." + propertyNameSuffix_HostNameOrIPAddress);
                String string6 = properties.getProperty("Dicom.RemoteAEs." + string3 + "." + propertyNameSuffix_Port);
                int n = string6 == null ? -1 : Integer.parseInt(string6);
                String string7 = properties.getProperty("Dicom.RemoteAEs." + string3 + "." + propertyNameSuffix_QueryModel);
                String string8 = properties.getProperty("Dicom.RemoteAEs." + string3 + "." + propertyNameSuffix_PrimaryDeviceType);
                this.networkApplicationInformation.add(string3, string4, string5, n, string7, string8);
            }
        }
    }

    public int getListeningPort() {
        return this.port;
    }

    public String getCalledAETitle() {
        return this.calledAETitle;
    }

    public String getCallingAETitle() {
        return this.callingAETitle;
    }

    public String getPrimaryDeviceType() {
        return this.primaryDeviceType;
    }

    public int getStorageSCUCompressionLevel() {
        return this.storageSCUCompressionLevel;
    }

    public int getStorageSCUDebugLevel() {
        return this.storageSCUDebugLevel;
    }

    public int getStorageSCPDebugLevel() {
        return this.storageSCPDebugLevel;
    }

    public int getQueryDebugLevel() {
        return this.queryDebugLevel;
    }

    public int getNetworkDynamicConfigurationDebugLevel() {
        return this.networkDynamicConfigurationDebugLevel;
    }

    public NetworkApplicationInformation getNetworkApplicationInformation() {
        return this.networkApplicationInformation;
    }

    public NetworkConfigurationSource getNetworkConfigurationSource() {
        if (this.networkConfigurationSource == null) {
            this.networkConfigurationSource = new OurNetworkConfigurationSource(this.networkApplicationInformation);
        }
        return this.networkConfigurationSource;
    }

    public static void main(String[] stringArray) {
        String string = stringArray[0];
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            Properties properties = new Properties();
            properties.load(fileInputStream);
            fileInputStream.close();
            System.out.print(new NetworkApplicationProperties(properties).getNetworkApplicationInformation().getLDIFRepresentation(stringArray[1]));
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    protected class OurNetworkConfigurationSource
    extends NetworkConfigurationSource {
        private NetworkApplicationInformation ourNetworkApplicationInformation;

        OurNetworkConfigurationSource(NetworkApplicationInformation networkApplicationInformation) {
            super(NetworkApplicationProperties.this.networkDynamicConfigurationDebugLevel);
            this.ourNetworkApplicationInformation = networkApplicationInformation;
        }

        public synchronized NetworkApplicationInformation getNetworkApplicationInformation() {
            return this.ourNetworkApplicationInformation;
        }

        public void activateDiscovery(int n) {
        }

        public void deActivateDiscovery() {
        }
    }
}

