/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.network;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.DicomOutputStream;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.SetOfDicomFiles;
import com.pixelmed.dicom.StoredFilePathStrategy;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.network.AReleaseException;
import com.pixelmed.network.ApplicationEntityMap;
import com.pixelmed.network.Association;
import com.pixelmed.network.AssociationAcceptor;
import com.pixelmed.network.AssociationFactory;
import com.pixelmed.network.CEchoRequestCommandMessage;
import com.pixelmed.network.CEchoResponseCommandMessage;
import com.pixelmed.network.CFindRequestCommandMessage;
import com.pixelmed.network.CFindResponseCommandMessage;
import com.pixelmed.network.CGetRequestCommandMessage;
import com.pixelmed.network.CGetResponseCommandMessage;
import com.pixelmed.network.CMoveRequestCommandMessage;
import com.pixelmed.network.CMoveResponseCommandMessage;
import com.pixelmed.network.CStoreRequestCommandMessage;
import com.pixelmed.network.CStoreResponseCommandMessage;
import com.pixelmed.network.CompositeResponseHandler;
import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.IdentifierMessage;
import com.pixelmed.network.MessageServiceElementCommand;
import com.pixelmed.network.MultipleInstanceTransferStatusHandler;
import com.pixelmed.network.PDataPDU;
import com.pixelmed.network.PresentationAddress;
import com.pixelmed.network.PresentationDataValue;
import com.pixelmed.network.ReceivedDataHandler;
import com.pixelmed.network.ReceivedObjectHandler;
import com.pixelmed.network.ResponseStatus;
import com.pixelmed.network.StorageSOPClassSCU;
import com.pixelmed.query.QueryResponseGeneratorFactory;
import com.pixelmed.query.RetrieveResponseGeneratorFactory;
import com.pixelmed.utils.ByteArray;
import com.pixelmed.utils.CopyStream;
import com.pixelmed.utils.FileUtilities;
import com.pixelmed.utils.HexDump;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.ListIterator;

public class StorageSOPClassSCP
extends SOPClass
implements Runnable {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/network/StorageSOPClassSCP.java,v 1.61 2007/12/19 22:34:31 dclunie Exp $";
    private Socket socket;
    private String calledAETitle;
    private int ourMaximumLengthReceived;
    private int socketReceiveBufferSize;
    private int socketSendBufferSize;
    private File savedImagesFolder;
    protected StoredFilePathStrategy storedFilePathStrategy;
    private ReceivedObjectHandler receivedObjectHandler;
    private QueryResponseGeneratorFactory queryResponseGeneratorFactory;
    private RetrieveResponseGeneratorFactory retrieveResponseGeneratorFactory;
    private ApplicationEntityMap applicationEntityMap;
    private int debugLevel;

    /*
     * WARNING - void declaration
     */
    private boolean receiveAndProcessOneRequestMessage(Association association) throws AReleaseException, DicomNetworkException, DicomException, IOException {
        void var4_7;
        Object object;
        if (this.debugLevel > 0) {
            System.err.println("StorageSOPClassSCP.receiveAndProcessOneRequestMessage(): start");
        }
        CompositeCommandReceivedPDUHandler compositeCommandReceivedPDUHandler = new CompositeCommandReceivedPDUHandler(this.savedImagesFolder, this.queryResponseGeneratorFactory, this.retrieveResponseGeneratorFactory, this.debugLevel);
        association.setReceivedDataHandler(compositeCommandReceivedPDUHandler);
        if (this.debugLevel > 0) {
            System.err.println("StorageSOPClassSCP.receiveAndProcessOneRequestMessage(): waitForPDataPDUsUntilHandlerReportsDone");
        }
        association.waitForPDataPDUsUntilHandlerReportsDone();
        if (this.debugLevel > 0) {
            System.err.println("StorageSOPClassSCP.receiveAndProcessOneRequestMessage(): back from waitForPDataPDUsUntilHandlerReportsDone");
        }
        if ((object = compositeCommandReceivedPDUHandler.getReceivedFileName()) != null) {
            byte bl = compositeCommandReceivedPDUHandler.getPresentationContextIDUsed();
            String string = association.getTransferSyntaxForPresentationContextID(bl);
            String string2 = association.getCallingAETitle();
            this.receivedObjectHandler.sendReceivedObjectIndication((String)object, string, string2);
        }
        if (this.debugLevel > 0) {
            System.err.println("StorageSOPClassSCP.receiveAndProcessOneRequestMessage(): sending (final) response");
        }
        object = compositeCommandReceivedPDUHandler.getResponse();
        if (this.debugLevel > 1) {
            System.err.println("StorageSOPClassSCP.receiveAndProcessOneRequestMessage(): response = " + CompositeResponseHandler.dumpAttributeListFromCommandOrData((byte[])object, "1.2.840.10008.1.2"));
        }
        association.send(compositeCommandReceivedPDUHandler.getPresentationContextIDUsed(), (byte[])object, null);
        if (this.debugLevel > 0) {
            System.err.println("StorageSOPClassSCP.receiveAndProcessOneRequestMessage(): end");
        }
        if (compositeCommandReceivedPDUHandler.isToBeReleased()) {
            if (this.debugLevel > 0) {
                System.err.println("StorageSOPClassSCP.receiveAndProcessOneRequestMessage(): explicitly releasing association");
            }
            association.release();
            boolean bl = false;
        } else {
            boolean bl = true;
        }
        return (boolean)var4_7;
    }

    public StorageSOPClassSCP(Socket socket, String string, int n, int n2, int n3, File file, StoredFilePathStrategy storedFilePathStrategy, ReceivedObjectHandler receivedObjectHandler, QueryResponseGeneratorFactory queryResponseGeneratorFactory, RetrieveResponseGeneratorFactory retrieveResponseGeneratorFactory, ApplicationEntityMap applicationEntityMap, int n4) throws DicomNetworkException, DicomException, IOException {
        this.socket = socket;
        this.calledAETitle = string;
        this.ourMaximumLengthReceived = n;
        this.socketReceiveBufferSize = n2;
        this.socketSendBufferSize = n3;
        this.savedImagesFolder = file;
        this.storedFilePathStrategy = storedFilePathStrategy;
        this.receivedObjectHandler = receivedObjectHandler;
        this.queryResponseGeneratorFactory = queryResponseGeneratorFactory;
        this.retrieveResponseGeneratorFactory = retrieveResponseGeneratorFactory;
        this.applicationEntityMap = applicationEntityMap;
        this.debugLevel = n4;
        storedFilePathStrategy.setDebugLevel(n4);
    }

    public StorageSOPClassSCP(Socket socket, String string, int n, int n2, int n3, File file, StoredFilePathStrategy storedFilePathStrategy, ReceivedObjectHandler receivedObjectHandler, int n4) throws DicomNetworkException, DicomException, IOException {
        this.socket = socket;
        this.calledAETitle = string;
        this.ourMaximumLengthReceived = n;
        this.socketReceiveBufferSize = n2;
        this.socketSendBufferSize = n3;
        this.savedImagesFolder = file;
        this.storedFilePathStrategy = storedFilePathStrategy;
        this.receivedObjectHandler = receivedObjectHandler;
        this.queryResponseGeneratorFactory = null;
        this.retrieveResponseGeneratorFactory = null;
        this.applicationEntityMap = null;
        this.debugLevel = n4;
        storedFilePathStrategy.setDebugLevel(n4);
    }

    public StorageSOPClassSCP(Socket socket, String string, File file, StoredFilePathStrategy storedFilePathStrategy, ReceivedObjectHandler receivedObjectHandler, int n) throws DicomNetworkException, DicomException, IOException {
        this.socket = socket;
        this.calledAETitle = string;
        this.ourMaximumLengthReceived = AssociationFactory.getDefaultMaximumLengthReceived();
        this.socketReceiveBufferSize = AssociationFactory.getDefaultReceiveBufferSize();
        this.socketSendBufferSize = AssociationFactory.getDefaultSendBufferSize();
        this.savedImagesFolder = file;
        this.storedFilePathStrategy = storedFilePathStrategy;
        this.receivedObjectHandler = receivedObjectHandler;
        this.queryResponseGeneratorFactory = null;
        this.retrieveResponseGeneratorFactory = null;
        this.applicationEntityMap = null;
        this.debugLevel = n;
        storedFilePathStrategy.setDebugLevel(n);
    }

    public void run() {
        try {
            AssociationAcceptor associationAcceptor = AssociationFactory.createNewAssociation(this.socket, this.calledAETitle, this.ourMaximumLengthReceived, this.socketReceiveBufferSize, this.socketSendBufferSize, this.debugLevel);
            if (this.debugLevel > 1) {
                System.err.println(associationAcceptor);
            }
            try {
                while (this.receiveAndProcessOneRequestMessage(associationAcceptor)) {
                }
            }
            catch (AReleaseException aReleaseException) {
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    private class CompositeCommandReceivedPDUHandler
    extends ReceivedDataHandler {
        private int command;
        private byte[] commandReceived;
        private AttributeList commandList;
        private byte[] dataReceived;
        private AttributeList dataList;
        private OutputStream out;
        private CStoreRequestCommandMessage csrq;
        private CEchoRequestCommandMessage cerq;
        private CFindRequestCommandMessage cfrq;
        private CMoveRequestCommandMessage cmrq;
        private CGetRequestCommandMessage cgrq;
        private byte[] response;
        private byte presentationContextIDUsed;
        private File receivedFile;
        private File temporaryReceivedFile;
        private File savedImagesFolder;
        private QueryResponseGeneratorFactory queryResponseGeneratorFactory;
        private RetrieveResponseGeneratorFactory retrieveResponseGeneratorFactory;

        private void buildCEchoResponse() throws DicomException, IOException {
            this.response = new CEchoResponseCommandMessage(this.cerq.getAffectedSOPClassUID(), this.cerq.getMessageID(), ResponseStatus.Success).getBytes();
        }

        private void buildCStoreResponse() throws DicomException, IOException {
            this.response = new CStoreResponseCommandMessage(this.csrq.getAffectedSOPClassUID(), this.csrq.getAffectedSOPInstanceUID(), this.csrq.getMessageID(), ResponseStatus.Success).getBytes();
        }

        public CompositeCommandReceivedPDUHandler(File file, QueryResponseGeneratorFactory queryResponseGeneratorFactory, RetrieveResponseGeneratorFactory retrieveResponseGeneratorFactory, int n) {
            super(n);
            this.command = 0;
            this.commandReceived = null;
            this.commandList = null;
            this.dataReceived = null;
            this.dataList = null;
            this.out = null;
            this.csrq = null;
            this.receivedFile = null;
            this.savedImagesFolder = file;
            this.queryResponseGeneratorFactory = queryResponseGeneratorFactory;
            this.retrieveResponseGeneratorFactory = retrieveResponseGeneratorFactory;
        }

        public void sendPDataIndication(PDataPDU pDataPDU, Association association) throws DicomNetworkException, DicomException, IOException {
            if (this.debugLevel > 0) {
                System.err.println("StorageSOPClassSCP.CompositeCommandReceivedPDUHandler.sendPDataIndication(): sendPDataIndication()");
            }
            if (this.debugLevel > 2) {
                super.dumpPDVList(pDataPDU.getPDVList());
            }
            if (this.debugLevel > 2) {
                System.err.println("StorageSOPClassSCP.CompositeCommandReceivedPDUHandler.sendPDataIndication(): finished dumping PDV list from PDU");
            }
            LinkedList linkedList = pDataPDU.getPDVList();
            ListIterator listIterator = linkedList.listIterator();
            while (listIterator.hasNext()) {
                MultipleInstanceTransferStatusHandler multipleInstanceTransferStatusHandler;
                Object object;
                Object object2;
                Object object3;
                Object object4;
                if (this.debugLevel > 0) {
                    System.err.println("StorageSOPClassSCP.CompositeCommandReceivedPDUHandler.sendPDataIndication(): have another fragment");
                }
                PresentationDataValue presentationDataValue = (PresentationDataValue)listIterator.next();
                this.presentationContextIDUsed = presentationDataValue.getPresentationContextID();
                if (presentationDataValue.isCommand()) {
                    this.receivedFile = null;
                    this.commandReceived = ByteArray.concatenate(this.commandReceived, presentationDataValue.getValue());
                    if (!presentationDataValue.isLastFragment()) continue;
                    if (this.debugLevel > 0) {
                        System.err.println("StorageSOPClassSCP.CompositeCommandReceivedPDUHandler.sendPDataIndication(): last fragment of data seen");
                    }
                    if (this.debugLevel > 0) {
                        System.err.println(HexDump.dump(this.commandReceived));
                    }
                    this.commandList = new AttributeList();
                    this.commandList.read(new DicomInputStream(new ByteArrayInputStream(this.commandReceived), "1.2.840.10008.1.2", false));
                    if (this.debugLevel > 0) {
                        System.err.print(this.commandList);
                    }
                    this.command = Attribute.getSingleIntegerValueOrDefault(this.commandList, TagFromName.CommandField, 65535);
                    if (this.command == 48) {
                        if (this.debugLevel > 0) {
                            System.err.println("StorageSOPClassSCP.CompositeCommandReceivedPDUHandler.sendPDataIndication(): C-ECHO-RQ");
                        }
                        this.cerq = new CEchoRequestCommandMessage(this.commandList);
                        this.buildCEchoResponse();
                        this.setDone(true);
                        this.setRelease(false);
                    } else if (this.command == 1) {
                        if (this.debugLevel > 0) {
                            System.err.println("StorageSOPClassSCP.CompositeCommandReceivedPDUHandler.sendPDataIndication(): C-STORE-RQ");
                        }
                        this.csrq = new CStoreRequestCommandMessage(this.commandList);
                    } else if (this.command == 32 && this.queryResponseGeneratorFactory != null) {
                        if (this.debugLevel > 0) {
                            System.err.println("StorageSOPClassSCP.CompositeCommandReceivedPDUHandler.sendPDataIndication(): C-FIND-RQ");
                        }
                        this.cfrq = new CFindRequestCommandMessage(this.commandList);
                    } else if (this.command == 33 && this.retrieveResponseGeneratorFactory != null) {
                        if (this.debugLevel > 0) {
                            System.err.println("StorageSOPClassSCP.CompositeCommandReceivedPDUHandler.sendPDataIndication(): C-MOVE-RQ");
                        }
                        this.cmrq = new CMoveRequestCommandMessage(this.commandList);
                    } else if (this.command == 16 && this.retrieveResponseGeneratorFactory != null) {
                        if (this.debugLevel > 0) {
                            System.err.println("StorageSOPClassSCP.CompositeCommandReceivedPDUHandler.sendPDataIndication(): C-GET-RQ");
                        }
                        this.cgrq = new CGetRequestCommandMessage(this.commandList);
                    } else {
                        throw new DicomNetworkException("Unexpected command 0x" + Integer.toHexString(this.command) + " " + MessageServiceElementCommand.toString(this.command));
                    }
                    if (this.debugLevel <= 0 || !listIterator.hasNext()) continue;
                    System.err.println("StorageSOPClassSCP.CompositeCommandReceivedPDUHandler: Data after command in same PDU");
                    continue;
                }
                if (this.command == 1) {
                    if (this.debugLevel > 0) {
                        System.err.println("StorageSOPClassSCP.CompositeCommandReceivedPDUHandler.sendPDataIndication(): Storing data fragment");
                    }
                    if (this.out == null && this.savedImagesFolder != null) {
                        object4 = new FileMetaInformation(this.csrq.getAffectedSOPClassUID(), this.csrq.getAffectedSOPInstanceUID(), association.getTransferSyntaxForPresentationContextID(this.presentationContextIDUsed), association.getCallingAETitle());
                        this.temporaryReceivedFile = new File(this.savedImagesFolder, FileUtilities.makeTemporaryFileName());
                        if (this.debugLevel > 0) {
                            System.err.println("StorageSOPClassSCP.CompositeCommandReceivedPDUHandler.sendPDataIndication(): Receiving and storing " + this.receivedFile);
                        }
                        if (this.debugLevel > 0) {
                            System.err.println("StorageSOPClassSCP.CompositeCommandReceivedPDUHandler.sendPDataIndication(): Receiving and storing into temporary " + this.temporaryReceivedFile);
                        }
                        this.out = new BufferedOutputStream(new FileOutputStream(this.temporaryReceivedFile));
                        object3 = new DicomOutputStream(this.out, "1.2.840.10008.1.2.1", null);
                        ((FileMetaInformation)object4).getAttributeList().write((DicomOutputStream)object3);
                        ((FilterOutputStream)object3).flush();
                    }
                    if (this.out != null) {
                        this.out.write(presentationDataValue.getValue());
                    }
                    if (!presentationDataValue.isLastFragment()) continue;
                    if (this.debugLevel > 0) {
                        System.err.println("StorageSOPClassSCP.CompositeCommandReceivedPDUHandler.sendPDataIndication(): Finished storing data");
                    }
                    if (this.out != null) {
                        this.out.close();
                        this.receivedFile = StorageSOPClassSCP.this.storedFilePathStrategy.makeReliableStoredFilePathWithFoldersCreated(this.savedImagesFolder, this.csrq.getAffectedSOPInstanceUID());
                        if (!this.temporaryReceivedFile.renameTo(this.receivedFile)) {
                            if (this.debugLevel > 0) {
                                System.err.println("StorageSOPClassSCP.CompositeCommandReceivedPDUHandler.sendPDataIndication(): Could not move temporary file into place ... copying instead");
                            }
                            CopyStream.copy(this.temporaryReceivedFile, this.receivedFile);
                            this.temporaryReceivedFile.delete();
                        }
                        this.out = null;
                    }
                    this.buildCStoreResponse();
                    this.setDone(true);
                    this.setRelease(false);
                    continue;
                }
                if (this.command == 32 && this.queryResponseGeneratorFactory != null) {
                    object4 = this.queryResponseGeneratorFactory.newInstance();
                    this.dataReceived = ByteArray.concatenate(this.dataReceived, presentationDataValue.getValue());
                    if (!presentationDataValue.isLastFragment()) continue;
                    if (this.debugLevel > 0) {
                        System.err.println("StorageSOPClassSCP.CompositeCommandReceivedPDUHandler.sendPDataIndication(): last fragment of data seen");
                    }
                    if (this.debugLevel > 0) {
                        System.err.println(HexDump.dump(this.dataReceived));
                    }
                    this.dataList = new AttributeList();
                    this.dataList.read(new DicomInputStream(new ByteArrayInputStream(this.dataReceived), association.getTransferSyntaxForPresentationContextID(this.presentationContextIDUsed), false));
                    if (this.debugLevel > 0) {
                        System.err.print(this.dataList);
                    }
                    object4.performQuery(this.cfrq.getAffectedSOPClassUID(), this.dataList, false);
                    int n = object4.getStatus();
                    if (n != ResponseStatus.Success) {
                        if (this.debugLevel > 0) {
                            System.err.println("StorageSOPClassSCP.CompositeCommandReceivedPDUHandler.sendPDataIndication(): Query failed, status = 0x" + Integer.toHexString(n));
                        }
                        this.response = new CFindResponseCommandMessage(this.cfrq.getAffectedSOPClassUID(), this.cfrq.getMessageID(), n, false, object4.getOffendingElement(), null).getBytes();
                        object4.close();
                    } else {
                        AttributeList attributeList;
                        while ((attributeList = object4.next()) != null) {
                            if (this.debugLevel > 0) {
                                System.err.println("StorageSOPClassSCP.CompositeCommandReceivedPDUHandler.sendPDataIndication(): Building and sending pending response " + attributeList.toString());
                            }
                            byte by = association.getSuitablePresentationContextID(this.cfrq.getAffectedSOPClassUID());
                            if (this.debugLevel > 0) {
                                System.err.println("StorageSOPClassSCP.CompositeCommandReceivedPDUHandler.sendPDataIndication(): Using context ID for response " + by);
                            }
                            object2 = new CFindResponseCommandMessage(this.cfrq.getAffectedSOPClassUID(), this.cfrq.getMessageID(), object4.allOptionalKeysSuppliedWereSupported() ? ResponseStatus.MatchesAreContinuingOptionalKeysSupported : ResponseStatus.MatchesAreContinuingOptionalKeysNotSupported, true).getBytes();
                            object = new IdentifierMessage(attributeList, association.getTransferSyntaxForPresentationContextID(by)).getBytes();
                            association.send(by, (byte[])object2, null);
                            association.send(by, null, (byte[])object);
                        }
                        object4.close();
                        if (this.debugLevel > 0) {
                            System.err.println("StorageSOPClassSCP.CompositeCommandReceivedPDUHandler.sendPDataIndication(): Bulding final C-FIND success response");
                        }
                        this.response = new CFindResponseCommandMessage(this.cfrq.getAffectedSOPClassUID(), this.cfrq.getMessageID(), ResponseStatus.Success, false).getBytes();
                    }
                    this.setDone(true);
                    this.setRelease(false);
                    continue;
                }
                if (this.command == 33 && this.retrieveResponseGeneratorFactory != null && StorageSOPClassSCP.this.applicationEntityMap != null) {
                    object4 = this.retrieveResponseGeneratorFactory.newInstance();
                    this.dataReceived = ByteArray.concatenate(this.dataReceived, presentationDataValue.getValue());
                    if (!presentationDataValue.isLastFragment()) continue;
                    if (this.debugLevel > 0) {
                        System.err.println("StorageSOPClassSCP.CompositeCommandReceivedPDUHandler.sendPDataIndication(): last fragment of data seen");
                    }
                    if (this.debugLevel > 0) {
                        System.err.println(HexDump.dump(this.dataReceived));
                    }
                    this.dataList = new AttributeList();
                    this.dataList.read(new DicomInputStream(new ByteArrayInputStream(this.dataReceived), association.getTransferSyntaxForPresentationContextID(this.presentationContextIDUsed), false));
                    if (this.debugLevel > 0) {
                        System.err.print(this.dataList);
                    }
                    object4.performRetrieve(this.cmrq.getAffectedSOPClassUID(), this.dataList, false);
                    object3 = object4.getDicomFiles();
                    int n = object4.getStatus();
                    object4.close();
                    if (n != ResponseStatus.Success || object3 == null) {
                        if (this.debugLevel > 0) {
                            System.err.println("StorageSOPClassSCP.CompositeCommandReceivedPDUHandler.sendPDataIndication(): retrieve failed or contains nothing, status = 0x" + Integer.toHexString(n));
                        }
                        this.response = new CMoveResponseCommandMessage(this.cmrq.getAffectedSOPClassUID(), this.cmrq.getMessageID(), n, false, object4.getOffendingElement(), null).getBytes();
                    } else {
                        multipleInstanceTransferStatusHandler = new CMovePendingResponseSender(association, this.cmrq);
                        multipleInstanceTransferStatusHandler.nRemaining = ((HashSet)object3).size();
                        object2 = this.cmrq.getMoveDestination();
                        object = StorageSOPClassSCP.this.applicationEntityMap.getPresentationAddress((String)object2);
                        if (object != null) {
                            String string = ((PresentationAddress)object).getHostname();
                            int n2 = ((PresentationAddress)object).getPort();
                            if (this.debugLevel > 0) {
                                System.err.println("StorageSOPClassSCP.CompositeCommandReceivedPDUHandler.sendPDataIndication(): moveDestinationAETitle=" + (String)object2);
                            }
                            if (this.debugLevel > 0) {
                                System.err.println("StorageSOPClassSCP.CompositeCommandReceivedPDUHandler.sendPDataIndication(): moveDestinationHostname=" + string);
                            }
                            if (this.debugLevel > 0) {
                                System.err.println("StorageSOPClassSCP.CompositeCommandReceivedPDUHandler.sendPDataIndication(): moveDestinationPort=" + n2);
                            }
                            new StorageSOPClassSCU(string, n2, (String)object2, StorageSOPClassSCP.this.calledAETitle, (SetOfDicomFiles)object3, 0, multipleInstanceTransferStatusHandler, StorageSOPClassSCP.this.calledAETitle, this.cmrq.getMessageID(), this.debugLevel);
                            if (this.debugLevel > 0) {
                                System.err.println("StorageSOPClassSCP.CompositeCommandReceivedPDUHandler.sendPDataIndication(): after all stored: nRemaining=" + multipleInstanceTransferStatusHandler.nRemaining + " nCompleted=" + multipleInstanceTransferStatusHandler.nCompleted + " nFailed=" + multipleInstanceTransferStatusHandler.nFailed + " nWarning=" + multipleInstanceTransferStatusHandler.nWarning);
                            }
                            if (multipleInstanceTransferStatusHandler.nRemaining > 0) {
                                multipleInstanceTransferStatusHandler.nFailed += multipleInstanceTransferStatusHandler.nRemaining;
                                multipleInstanceTransferStatusHandler.nRemaining = 0;
                            }
                            if (this.debugLevel > 0) {
                                System.err.println("StorageSOPClassSCP.CompositeCommandReceivedPDUHandler.sendPDataIndication(): after setting remaining to zero: nRemaining=" + multipleInstanceTransferStatusHandler.nRemaining + " nCompleted=" + multipleInstanceTransferStatusHandler.nCompleted + " nFailed=" + multipleInstanceTransferStatusHandler.nFailed + " nWarning=" + multipleInstanceTransferStatusHandler.nWarning);
                            }
                            if (this.debugLevel > 0) {
                                System.err.println("StorageSOPClassSCP.CompositeCommandReceivedPDUHandler.sendPDataIndication(): Bulding final C-MOVE success response");
                            }
                            this.response = new CMoveResponseCommandMessage(this.cmrq.getAffectedSOPClassUID(), this.cmrq.getMessageID(), multipleInstanceTransferStatusHandler.nFailed > 0 ? ResponseStatus.SubOperationsCompleteOneOrMoreFailures : ResponseStatus.SubOperationsCompleteNoFailures, false, multipleInstanceTransferStatusHandler.nRemaining, multipleInstanceTransferStatusHandler.nCompleted, multipleInstanceTransferStatusHandler.nFailed, multipleInstanceTransferStatusHandler.nWarning).getBytes();
                        } else {
                            n = ResponseStatus.RefusedMoveDestinationUnknown;
                            if (this.debugLevel > 0) {
                                System.err.println("StorageSOPClassSCP.CompositeCommandReceivedPDUHandler.sendPDataIndication(): Unrecognized move destination " + (String)object2 + ", status = 0x" + Integer.toHexString(n));
                            }
                            this.response = new CMoveResponseCommandMessage(this.cmrq.getAffectedSOPClassUID(), this.cmrq.getMessageID(), n, false, null, (String)object2).getBytes();
                        }
                    }
                    this.setDone(true);
                    this.setRelease(false);
                    continue;
                }
                if (this.command == 16 && this.retrieveResponseGeneratorFactory != null) {
                    object4 = this.retrieveResponseGeneratorFactory.newInstance();
                    this.dataReceived = ByteArray.concatenate(this.dataReceived, presentationDataValue.getValue());
                    if (!presentationDataValue.isLastFragment()) continue;
                    if (this.debugLevel > 0) {
                        System.err.println("StorageSOPClassSCP.CompositeCommandReceivedPDUHandler.sendPDataIndication(): last fragment of data seen");
                    }
                    if (this.debugLevel > 0) {
                        System.err.println(HexDump.dump(this.dataReceived));
                    }
                    this.dataList = new AttributeList();
                    this.dataList.read(new DicomInputStream(new ByteArrayInputStream(this.dataReceived), association.getTransferSyntaxForPresentationContextID(this.presentationContextIDUsed), false));
                    if (this.debugLevel > 0) {
                        System.err.print(this.dataList);
                    }
                    object4.performRetrieve(this.cgrq.getAffectedSOPClassUID(), this.dataList, false);
                    object3 = object4.getDicomFiles();
                    int n = object4.getStatus();
                    object4.close();
                    if (n != ResponseStatus.Success || object3 == null) {
                        if (this.debugLevel > 0) {
                            System.err.println("StorageSOPClassSCP.CompositeCommandReceivedPDUHandler.sendPDataIndication(): retrieve failed or contains nothing, status = 0x" + Integer.toHexString(n));
                        }
                        this.response = new CGetResponseCommandMessage(this.cgrq.getAffectedSOPClassUID(), this.cgrq.getMessageID(), n, false, object4.getOffendingElement(), null).getBytes();
                    } else {
                        multipleInstanceTransferStatusHandler = new CGetPendingResponseSender(association, this.cgrq);
                        ((CGetPendingResponseSender)multipleInstanceTransferStatusHandler).nRemaining = ((HashSet)object3).size();
                        new StorageSOPClassSCU(association, (SetOfDicomFiles)object3, multipleInstanceTransferStatusHandler, this.debugLevel);
                        association.setReceivedDataHandler(this);
                        if (this.debugLevel > 0) {
                            System.err.println("StorageSOPClassSCP.CompositeCommandReceivedPDUHandler.sendPDataIndication(): after all stored: nRemaining=" + ((CGetPendingResponseSender)multipleInstanceTransferStatusHandler).nRemaining + " nCompleted=" + ((CGetPendingResponseSender)multipleInstanceTransferStatusHandler).nCompleted + " nFailed=" + ((CGetPendingResponseSender)multipleInstanceTransferStatusHandler).nFailed + " nWarning=" + ((CGetPendingResponseSender)multipleInstanceTransferStatusHandler).nWarning);
                        }
                        if (((CGetPendingResponseSender)multipleInstanceTransferStatusHandler).nRemaining > 0) {
                            ((CGetPendingResponseSender)multipleInstanceTransferStatusHandler).nFailed += ((CGetPendingResponseSender)multipleInstanceTransferStatusHandler).nRemaining;
                            ((CGetPendingResponseSender)multipleInstanceTransferStatusHandler).nRemaining = 0;
                        }
                        if (this.debugLevel > 0) {
                            System.err.println("StorageSOPClassSCP.CompositeCommandReceivedPDUHandler.sendPDataIndication(): after setting remaining to zero: nRemaining=" + ((CGetPendingResponseSender)multipleInstanceTransferStatusHandler).nRemaining + " nCompleted=" + ((CGetPendingResponseSender)multipleInstanceTransferStatusHandler).nCompleted + " nFailed=" + ((CGetPendingResponseSender)multipleInstanceTransferStatusHandler).nFailed + " nWarning=" + ((CGetPendingResponseSender)multipleInstanceTransferStatusHandler).nWarning);
                        }
                        if (this.debugLevel > 0) {
                            System.err.println("StorageSOPClassSCP.CompositeCommandReceivedPDUHandler.sendPDataIndication(): Bulding final C-GET success response");
                        }
                        this.response = new CGetResponseCommandMessage(this.cgrq.getAffectedSOPClassUID(), this.cgrq.getMessageID(), ((CGetPendingResponseSender)multipleInstanceTransferStatusHandler).nFailed > 0 ? ResponseStatus.SubOperationsCompleteOneOrMoreFailures : ResponseStatus.SubOperationsCompleteNoFailures, false, ((CGetPendingResponseSender)multipleInstanceTransferStatusHandler).nRemaining, ((CGetPendingResponseSender)multipleInstanceTransferStatusHandler).nCompleted, ((CGetPendingResponseSender)multipleInstanceTransferStatusHandler).nFailed, ((CGetPendingResponseSender)multipleInstanceTransferStatusHandler).nWarning).getBytes();
                    }
                    if (this.debugLevel > 0) {
                        System.err.println("StorageSOPClassSCP.CompositeCommandReceivedPDUHandler.sendPDataIndication(): Setting done flag for C-GET response");
                    }
                    this.setDone(true);
                    this.setRelease(false);
                    continue;
                }
                if (this.debugLevel <= 0) continue;
                System.err.println("StorageSOPClassSCP.CompositeCommandReceivedPDUHandler.sendPDataIndication(): Unexpected data fragment for command 0x" + Integer.toHexString(this.command) + " " + MessageServiceElementCommand.toString(this.command) + " - ignoring");
            }
            if (this.debugLevel > 0) {
                System.err.println("StorageSOPClassSCP.CompositeCommandReceivedPDUHandler.sendPDataIndication(): finished; isDone()=" + this.isDone());
            }
        }

        public AttributeList getCommandList() {
            return this.commandList;
        }

        public byte[] getResponse() {
            return this.response;
        }

        public byte getPresentationContextIDUsed() {
            return this.presentationContextIDUsed;
        }

        public File getReceivedFile() {
            return this.receivedFile;
        }

        public String getReceivedFileName() {
            return this.receivedFile == null ? null : this.receivedFile.getPath();
        }

        private class CGetPendingResponseSender
        extends MultipleInstanceTransferStatusHandler {
            private Association association;
            private CGetRequestCommandMessage cgrq;
            int nRemaining;
            int nCompleted;
            int nFailed;
            int nWarning;

            CGetPendingResponseSender(Association association, CGetRequestCommandMessage cGetRequestCommandMessage) {
                this.association = association;
                this.cgrq = cGetRequestCommandMessage;
                this.nRemaining = 0;
                this.nCompleted = 0;
                this.nFailed = 0;
                this.nWarning = 0;
            }

            public void updateStatus(int n, int n2, int n3, int n4, String string) {
                this.nRemaining = n;
                this.nCompleted = n2;
                this.nFailed = n3;
                this.nWarning = n4;
                if (CompositeCommandReceivedPDUHandler.this.debugLevel > 0) {
                    System.err.println("StorageSOPClassSCP.CompositeCommandReceivedPDUHandler.CGetPendingResponseSender.updateStatus(): Bulding C-GET pending response");
                }
                if (n > 0) {
                    try {
                        byte[] byArray = new CGetResponseCommandMessage(this.cgrq.getAffectedSOPClassUID(), this.cgrq.getMessageID(), ResponseStatus.SubOperationsAreContinuing, false, n, n2, n3, n4).getBytes();
                        if (CompositeCommandReceivedPDUHandler.this.debugLevel > 1) {
                            System.err.println("StorageSOPClassSCP.CompositeCommandReceivedPDUHandler.CGetPendingResponseSender.updateStatus(): C-GET pending response = " + CompositeResponseHandler.dumpAttributeListFromCommandOrData(byArray, "1.2.840.10008.1.2"));
                        }
                        byte by = this.association.getSuitablePresentationContextID(this.cgrq.getAffectedSOPClassUID());
                        this.association.send(by, byArray, null);
                    }
                    catch (DicomNetworkException dicomNetworkException) {
                        dicomNetworkException.printStackTrace(System.err);
                    }
                    catch (DicomException dicomException) {
                        dicomException.printStackTrace(System.err);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace(System.err);
                    }
                }
            }
        }

        private class CMovePendingResponseSender
        extends MultipleInstanceTransferStatusHandler {
            private Association association;
            private CMoveRequestCommandMessage cmrq;
            int nRemaining;
            int nCompleted;
            int nFailed;
            int nWarning;

            CMovePendingResponseSender(Association association, CMoveRequestCommandMessage cMoveRequestCommandMessage) {
                this.association = association;
                this.cmrq = cMoveRequestCommandMessage;
                this.nRemaining = 0;
                this.nCompleted = 0;
                this.nFailed = 0;
                this.nWarning = 0;
            }

            public void updateStatus(int n, int n2, int n3, int n4, String string) {
                this.nRemaining = n;
                this.nCompleted = n2;
                this.nFailed = n3;
                this.nWarning = n4;
                if (CompositeCommandReceivedPDUHandler.this.debugLevel > 0) {
                    System.err.println("StorageSOPClassSCP.CompositeCommandReceivedPDUHandler.CMovePendingResponseSender.updateStatus(): Bulding C-MOVE pending response");
                }
                if (n > 0) {
                    try {
                        byte[] byArray = new CMoveResponseCommandMessage(this.cmrq.getAffectedSOPClassUID(), this.cmrq.getMessageID(), ResponseStatus.SubOperationsAreContinuing, false, n, n2, n3, n4).getBytes();
                        if (CompositeCommandReceivedPDUHandler.this.debugLevel > 1) {
                            System.err.println("StorageSOPClassSCP.CompositeCommandReceivedPDUHandler.CMovePendingResponseSender.updateStatus(): C-MOVE pending response = " + CompositeResponseHandler.dumpAttributeListFromCommandOrData(byArray, "1.2.840.10008.1.2"));
                        }
                        byte by = this.association.getSuitablePresentationContextID(this.cmrq.getAffectedSOPClassUID());
                        this.association.send(by, byArray, null);
                    }
                    catch (DicomNetworkException dicomNetworkException) {
                        dicomNetworkException.printStackTrace(System.err);
                    }
                    catch (DicomException dicomException) {
                        dicomException.printStackTrace(System.err);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace(System.err);
                    }
                }
            }
        }
    }
}

