/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.database;

import com.pixelmed.database.DatabaseInformationModel;
import com.pixelmed.database.DicomDatabaseInformationModel;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.AttributeTagAttribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.InformationEntity;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.SetOfDicomFiles;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.network.ResponseStatus;
import com.pixelmed.query.RetrieveResponseGenerator;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

class DicomDatabaseRetrieveResponseGenerator
implements RetrieveResponseGenerator {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/database/DicomDatabaseRetrieveResponseGenerator.java,v 1.4 2007/09/27 18:48:08 dclunie Exp $";
    private int debugLevel;
    private DatabaseInformationModel databaseInformationModel;
    private AttributeList requestIdentifier;
    private SetOfDicomFiles dicomFiles = null;
    private int status = ResponseStatus.Success;
    private AttributeTagAttribute offendingElement = null;
    private String errorComment = null;
    private String patientTableName;
    private String studyTableName;
    private String seriesTableName;
    private String instanceTableName;
    private String patientPrimaryKeyColumnName;
    private String studyPrimaryKeyColumnName;
    private String seriesPrimaryKeyColumnName;
    private String studyParentReferenceColumnName;
    private String seriesParentReferenceColumnName;
    private String instanceParentReferenceColumnName;
    private String sopClassUIDColumnName;
    private String studyInstanceUIDColumnName;
    private String seriesInstanceUIDColumnName;
    private String sopInstanceUIDColumnName;
    private String transferSyntaxUIDColumnName;

    protected void setErrorStatus(int n, AttributeTag attributeTag, String string) {
        this.status = n;
        if (this.offendingElement == null) {
            this.offendingElement = new AttributeTagAttribute(TagFromName.OffendingElement);
        }
        if (attributeTag != null) {
            try {
                this.offendingElement.addValue(attributeTag);
            }
            catch (DicomException dicomException) {
                dicomException.printStackTrace(System.err);
            }
        }
        this.errorComment = string;
    }

    DicomDatabaseRetrieveResponseGenerator(DatabaseInformationModel databaseInformationModel, int n) {
        this.debugLevel = n;
        this.databaseInformationModel = databaseInformationModel;
        this.dicomFiles = null;
        this.patientTableName = DatabaseInformationModel.getTableNameForInformationEntity(InformationEntity.PATIENT);
        this.studyTableName = DatabaseInformationModel.getTableNameForInformationEntity(InformationEntity.STUDY);
        this.seriesTableName = DatabaseInformationModel.getTableNameForInformationEntity(InformationEntity.SERIES);
        this.instanceTableName = DatabaseInformationModel.getTableNameForInformationEntity(InformationEntity.INSTANCE);
        this.patientPrimaryKeyColumnName = databaseInformationModel.getLocalPrimaryKeyColumnName(InformationEntity.PATIENT);
        this.studyPrimaryKeyColumnName = databaseInformationModel.getLocalPrimaryKeyColumnName(InformationEntity.STUDY);
        this.seriesPrimaryKeyColumnName = databaseInformationModel.getLocalPrimaryKeyColumnName(InformationEntity.SERIES);
        this.studyParentReferenceColumnName = databaseInformationModel.getLocalParentReferenceColumnName(InformationEntity.STUDY);
        this.seriesParentReferenceColumnName = databaseInformationModel.getLocalParentReferenceColumnName(InformationEntity.SERIES);
        this.instanceParentReferenceColumnName = databaseInformationModel.getLocalParentReferenceColumnName(InformationEntity.INSTANCE);
        this.sopClassUIDColumnName = databaseInformationModel.getDatabaseColumnNameFromDicomTag(TagFromName.SOPClassUID);
        this.studyInstanceUIDColumnName = databaseInformationModel.getDatabaseColumnNameFromDicomTag(TagFromName.StudyInstanceUID);
        this.seriesInstanceUIDColumnName = databaseInformationModel.getDatabaseColumnNameFromDicomTag(TagFromName.SeriesInstanceUID);
        this.sopInstanceUIDColumnName = databaseInformationModel.getDatabaseColumnNameFromDicomTag(TagFromName.SOPInstanceUID);
        this.transferSyntaxUIDColumnName = databaseInformationModel.getDatabaseColumnNameFromDicomTag(TagFromName.TransferSyntaxUID);
    }

    private static void addToJoinClause(StringBuffer stringBuffer, String string, String string2, String string3, String string4) {
        if (stringBuffer.length() != 0) {
            stringBuffer.append(" AND ");
        }
        stringBuffer.append(string2);
        stringBuffer.append(".");
        stringBuffer.append(string3);
        stringBuffer.append(" = ");
        stringBuffer.append(string);
        stringBuffer.append(".");
        stringBuffer.append(string4);
    }

    private boolean addToSelectClause(StringBuffer stringBuffer, AttributeList attributeList, AttributeTag attributeTag, String string, AttributeTagAttribute attributeTagAttribute) {
        Attribute attribute;
        String string2 = this.databaseInformationModel.getDatabaseColumnNameFromDicomTag(attributeTag);
        boolean bl = true;
        if (stringBuffer.length() != 0) {
            stringBuffer.append(" AND ");
        }
        if ((attribute = attributeList.get(attributeTag)) == null || attribute.getVL() == 0L) {
            bl = false;
        } else {
            stringBuffer.append(string);
            stringBuffer.append(".");
            stringBuffer.append(string2);
            stringBuffer.append(" = ");
            try {
                stringBuffer.append(DicomDatabaseInformationModel.getQuotedEscapedSingleStringValueOrNull(attribute));
            }
            catch (DicomException dicomException) {
                dicomException.printStackTrace(System.err);
                bl = false;
            }
        }
        if (!bl) {
            this.setErrorStatus(ResponseStatus.IdentifierDoesNotMatchSOPClass, attributeTag, "Could not extract element for query");
        }
        return bl;
    }

    private String buildSelectStatementForLevelAndModelFromUniqueKeysInRequestIdentifier(String string, String string2, AttributeList attributeList, AttributeTagAttribute attributeTagAttribute) {
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        if (string2 == null) {
            if (this.debugLevel > 0) {
                System.err.println("DicomDatabaseRetrieveResponseGenerator.buildSelectStatementForLevelAndModelFromUniqueKeysInRequestIdentifier(): missing required QueryRetrieveLevel in C-MOVE request identifier");
            }
            bl = false;
            this.setErrorStatus(ResponseStatus.IdentifierDoesNotMatchSOPClass, TagFromName.QueryRetrieveLevel, "Missing retrieve level");
        } else {
            stringBuffer.append("SELECT ");
            stringBuffer.append("LocalFileName");
            stringBuffer.append(",");
            stringBuffer.append(this.sopInstanceUIDColumnName);
            stringBuffer.append(",");
            stringBuffer.append(this.sopClassUIDColumnName);
            stringBuffer.append(",");
            stringBuffer.append(this.transferSyntaxUIDColumnName);
            stringBuffer.append(" ");
            StringBuffer stringBuffer2 = new StringBuffer();
            if (SOPClass.isStudyRootCompositeInstanceRetrieve(string)) {
                stringBuffer.append("FROM ");
                stringBuffer.append(this.studyTableName);
                stringBuffer.append(",");
                stringBuffer.append(this.seriesTableName);
                stringBuffer.append(",");
                stringBuffer.append(this.instanceTableName);
                stringBuffer.append(" WHERE ");
                if (string2.equals("STUDY")) {
                    bl = bl && this.addToSelectClause(stringBuffer2, attributeList, TagFromName.StudyInstanceUID, this.studyTableName, attributeTagAttribute);
                    DicomDatabaseRetrieveResponseGenerator.addToJoinClause(stringBuffer2, this.seriesTableName, this.studyTableName, this.studyPrimaryKeyColumnName, this.seriesParentReferenceColumnName);
                    DicomDatabaseRetrieveResponseGenerator.addToJoinClause(stringBuffer2, this.instanceTableName, this.seriesTableName, this.seriesPrimaryKeyColumnName, this.instanceParentReferenceColumnName);
                } else if (string2.equals(this.seriesTableName)) {
                    bl = bl && this.addToSelectClause(stringBuffer2, attributeList, TagFromName.StudyInstanceUID, this.studyTableName, attributeTagAttribute);
                    bl = bl && this.addToSelectClause(stringBuffer2, attributeList, TagFromName.SeriesInstanceUID, this.seriesTableName, attributeTagAttribute);
                    DicomDatabaseRetrieveResponseGenerator.addToJoinClause(stringBuffer2, this.seriesTableName, this.studyTableName, this.studyPrimaryKeyColumnName, this.seriesParentReferenceColumnName);
                    DicomDatabaseRetrieveResponseGenerator.addToJoinClause(stringBuffer2, this.instanceTableName, this.seriesTableName, this.seriesPrimaryKeyColumnName, this.instanceParentReferenceColumnName);
                } else if (string2.equals("IMAGE")) {
                    bl = bl && this.addToSelectClause(stringBuffer2, attributeList, TagFromName.StudyInstanceUID, this.studyTableName, attributeTagAttribute);
                    bl = bl && this.addToSelectClause(stringBuffer2, attributeList, TagFromName.SeriesInstanceUID, this.seriesTableName, attributeTagAttribute);
                    bl = bl && this.addToSelectClause(stringBuffer2, attributeList, TagFromName.SOPInstanceUID, this.instanceTableName, attributeTagAttribute);
                    DicomDatabaseRetrieveResponseGenerator.addToJoinClause(stringBuffer2, this.seriesTableName, this.studyTableName, this.studyPrimaryKeyColumnName, this.seriesParentReferenceColumnName);
                    DicomDatabaseRetrieveResponseGenerator.addToJoinClause(stringBuffer2, this.instanceTableName, this.seriesTableName, this.seriesPrimaryKeyColumnName, this.instanceParentReferenceColumnName);
                }
            } else if (SOPClass.isPatientRootCompositeInstanceRetrieve(string)) {
                stringBuffer.append("FROM ");
                stringBuffer.append(this.patientTableName);
                stringBuffer.append(",");
                stringBuffer.append(this.studyTableName);
                stringBuffer.append(",");
                stringBuffer.append(this.seriesTableName);
                stringBuffer.append(",");
                stringBuffer.append(this.instanceTableName);
                stringBuffer.append(" WHERE ");
                if (string2.equals("PATIENT")) {
                    bl = bl && this.addToSelectClause(stringBuffer2, attributeList, TagFromName.PatientID, this.patientTableName, attributeTagAttribute);
                    DicomDatabaseRetrieveResponseGenerator.addToJoinClause(stringBuffer2, this.studyTableName, this.patientTableName, this.patientPrimaryKeyColumnName, this.studyParentReferenceColumnName);
                    DicomDatabaseRetrieveResponseGenerator.addToJoinClause(stringBuffer2, this.seriesTableName, this.studyTableName, this.studyPrimaryKeyColumnName, this.seriesParentReferenceColumnName);
                    DicomDatabaseRetrieveResponseGenerator.addToJoinClause(stringBuffer2, this.instanceTableName, this.seriesTableName, this.seriesPrimaryKeyColumnName, this.instanceParentReferenceColumnName);
                } else if (string2.equals("STUDY")) {
                    bl = bl && this.addToSelectClause(stringBuffer2, attributeList, TagFromName.PatientID, this.patientTableName, attributeTagAttribute);
                    bl = bl && this.addToSelectClause(stringBuffer2, attributeList, TagFromName.StudyInstanceUID, this.studyTableName, attributeTagAttribute);
                    DicomDatabaseRetrieveResponseGenerator.addToJoinClause(stringBuffer2, this.studyTableName, this.patientTableName, this.patientPrimaryKeyColumnName, this.studyParentReferenceColumnName);
                    DicomDatabaseRetrieveResponseGenerator.addToJoinClause(stringBuffer2, this.seriesTableName, this.studyTableName, this.studyPrimaryKeyColumnName, this.seriesParentReferenceColumnName);
                    DicomDatabaseRetrieveResponseGenerator.addToJoinClause(stringBuffer2, this.instanceTableName, this.seriesTableName, this.seriesPrimaryKeyColumnName, this.instanceParentReferenceColumnName);
                } else if (string2.equals(this.seriesTableName)) {
                    bl = bl && this.addToSelectClause(stringBuffer2, attributeList, TagFromName.PatientID, this.patientTableName, attributeTagAttribute);
                    bl = bl && this.addToSelectClause(stringBuffer2, attributeList, TagFromName.StudyInstanceUID, this.studyTableName, attributeTagAttribute);
                    bl = bl && this.addToSelectClause(stringBuffer2, attributeList, TagFromName.SeriesInstanceUID, this.seriesTableName, attributeTagAttribute);
                    DicomDatabaseRetrieveResponseGenerator.addToJoinClause(stringBuffer2, this.studyTableName, this.patientTableName, this.patientPrimaryKeyColumnName, this.studyParentReferenceColumnName);
                    DicomDatabaseRetrieveResponseGenerator.addToJoinClause(stringBuffer2, this.seriesTableName, this.studyTableName, this.studyPrimaryKeyColumnName, this.seriesParentReferenceColumnName);
                    DicomDatabaseRetrieveResponseGenerator.addToJoinClause(stringBuffer2, this.instanceTableName, this.seriesTableName, this.seriesPrimaryKeyColumnName, this.instanceParentReferenceColumnName);
                } else if (string2.equals("IMAGE")) {
                    bl = bl && this.addToSelectClause(stringBuffer2, attributeList, TagFromName.PatientID, this.patientTableName, attributeTagAttribute);
                    bl = bl && this.addToSelectClause(stringBuffer2, attributeList, TagFromName.StudyInstanceUID, this.studyTableName, attributeTagAttribute);
                    bl = bl && this.addToSelectClause(stringBuffer2, attributeList, TagFromName.SeriesInstanceUID, this.seriesTableName, attributeTagAttribute);
                    bl = bl && this.addToSelectClause(stringBuffer2, attributeList, TagFromName.SOPInstanceUID, this.instanceTableName, attributeTagAttribute);
                    DicomDatabaseRetrieveResponseGenerator.addToJoinClause(stringBuffer2, this.studyTableName, this.patientTableName, this.patientPrimaryKeyColumnName, this.studyParentReferenceColumnName);
                    DicomDatabaseRetrieveResponseGenerator.addToJoinClause(stringBuffer2, this.seriesTableName, this.studyTableName, this.studyPrimaryKeyColumnName, this.seriesParentReferenceColumnName);
                    DicomDatabaseRetrieveResponseGenerator.addToJoinClause(stringBuffer2, this.instanceTableName, this.seriesTableName, this.seriesPrimaryKeyColumnName, this.instanceParentReferenceColumnName);
                }
            }
            stringBuffer.append(stringBuffer2);
        }
        return bl ? stringBuffer.toString() : null;
    }

    public void performRetrieve(String string, AttributeList attributeList, boolean bl) {
        if (this.debugLevel > 0) {
            System.err.println("DicomDatabaseRetrieveResponseGenerator.performRetrieve(): request:\n" + attributeList.toString());
        }
        this.requestIdentifier = attributeList;
        String string2 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.QueryRetrieveLevel);
        String string3 = this.buildSelectStatementForLevelAndModelFromUniqueKeysInRequestIdentifier(string, string2, attributeList, this.offendingElement);
        if (this.debugLevel > 0) {
            System.err.println("DicomDatabaseRetrieveResponseGenerator.performRetrieve(): query: " + string3);
        }
        if (string3 != null) {
            try {
                Statement statement = this.databaseInformationModel.createStatement();
                ResultSet resultSet = statement.executeQuery(string3);
                this.dicomFiles = new SetOfDicomFiles();
                if (resultSet != null) {
                    while (resultSet.next()) {
                        this.dicomFiles.add(resultSet.getString("LocalFileName"), resultSet.getString(this.sopClassUIDColumnName), resultSet.getString(this.sopInstanceUIDColumnName), resultSet.getString(this.transferSyntaxUIDColumnName));
                    }
                }
                statement.close();
                this.status = ResponseStatus.Success;
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace(System.err);
                this.dicomFiles = null;
                this.setErrorStatus(ResponseStatus.UnableToProcess, null, sQLException.getMessage());
            }
        } else {
            this.dicomFiles = null;
            if (this.status == ResponseStatus.Success) {
                this.status = ResponseStatus.IdentifierDoesNotMatchSOPClass;
            }
        }
        if (this.debugLevel > 0) {
            System.err.println("DicomDatabaseRetrieveResponseGenerator.performRetrieve(): query performed - status 0x" + Integer.toHexString(this.status));
        }
    }

    public SetOfDicomFiles getDicomFiles() {
        return this.dicomFiles;
    }

    public int getStatus() {
        return this.status;
    }

    public AttributeTagAttribute getOffendingElement() {
        return this.offendingElement;
    }

    public String getErrorComment() {
        return this.errorComment;
    }

    public void close() {
    }
}

