/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.tree.TreeNode;

public abstract class DicomDirectoryRecord
implements Comparable,
TreeNode {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/DicomDirectoryRecord.java,v 1.17 2008/02/21 04:56:40 dclunie Exp $";
    DicomDirectoryRecord parent;
    Collection children;
    TreeNode[] array;
    AttributeList list;
    protected String uid;
    protected String stringValue;
    protected int integerValue;

    public int compareTo(Object object) {
        return 0;
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    protected abstract void makeStringValue();

    protected abstract void makeIntegerValue();

    protected String getStringValue() {
        return this.stringValue;
    }

    protected int getIntegerValue() {
        return this.integerValue;
    }

    protected final String getUIDForComparison() {
        return this.uid;
    }

    protected final int compareToByStringValue(DicomDirectoryRecord dicomDirectoryRecord) {
        if (this.getClass().equals(dicomDirectoryRecord.getClass())) {
            int n = this.getUIDForComparison().compareTo(dicomDirectoryRecord.getUIDForComparison());
            int n2 = this.toString().compareTo(dicomDirectoryRecord.toString());
            if (n2 == 0) {
                return n;
            }
            return n2;
        }
        return this.toString().compareTo(dicomDirectoryRecord.toString());
    }

    protected final int compareToByIntegerValue(DicomDirectoryRecord dicomDirectoryRecord) {
        if (this.getClass().equals(dicomDirectoryRecord.getClass())) {
            int n = this.getUIDForComparison().compareTo(dicomDirectoryRecord.getUIDForComparison());
            if (n == 0) {
                return 0;
            }
            int n2 = this.getIntegerValue() - dicomDirectoryRecord.getIntegerValue();
            if (n2 == 0) {
                int n3 = this.toString().compareTo(dicomDirectoryRecord.toString());
                if (n3 == 0) {
                    return n;
                }
                return n3;
            }
            return n2;
        }
        return this.toString().compareTo(dicomDirectoryRecord.toString());
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public TreeNode getChildAt(int n) {
        int n2 = this.children.size();
        if (this.array == null) {
            this.array = this.children.toArray(new TreeNode[n2]);
        }
        return n < n2 ? this.array[n] : null;
    }

    public int getIndex(TreeNode treeNode) {
        if (this.children != null) {
            int n = this.children.size();
            if (this.array == null) {
                this.array = this.children.toArray(new TreeNode[n]);
            }
            for (int i = 0; i < n; ++i) {
                if (!this.getChildAt(i).equals(treeNode)) continue;
                return i;
            }
        }
        return -1;
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public int getChildCount() {
        return this.children == null ? 0 : this.children.size();
    }

    public Enumeration children() {
        return this.children == null ? null : new Vector(this.children).elements();
    }

    public DicomDirectoryRecord(DicomDirectoryRecord dicomDirectoryRecord, AttributeList attributeList) {
        this.parent = dicomDirectoryRecord;
        this.list = attributeList;
        this.makeIntegerValue();
        this.makeStringValue();
    }

    public void addChild(DicomDirectoryRecord dicomDirectoryRecord) {
        if (this.children == null) {
            this.children = new TreeSet();
        }
        this.children.add(dicomDirectoryRecord);
        this.array = null;
    }

    public void removeChild(DicomDirectoryRecord dicomDirectoryRecord) {
        this.children.remove(dicomDirectoryRecord);
        this.array = null;
    }

    public void addSibling(DicomDirectoryRecord dicomDirectoryRecord) throws DicomException {
        if (this.parent == null) {
            throw new DicomException("Internal error - root node with sibling");
        }
        this.parent.addChild(dicomDirectoryRecord);
    }

    public void setParent(DicomDirectoryRecord dicomDirectoryRecord) {
        this.parent = dicomDirectoryRecord;
    }

    public AttributeList getAttributeList() {
        return this.list;
    }
}

