/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DescriptionFactory;
import com.pixelmed.dicom.DicomDirectoryRecord;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.TagFromName;

public class DicomDirectoryRecordFactory {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/DicomDirectoryRecordFactory.java,v 1.22 2008/02/22 16:19:22 dclunie Exp $";

    public DicomDirectoryRecord getNewDicomDirectoryRecord(DicomDirectoryRecord dicomDirectoryRecord, AttributeList attributeList) {
        DicomDirectoryRecord dicomDirectoryRecord2 = null;
        try {
            String string;
            dicomDirectoryRecord2 = attributeList == null ? new UnrecognizedDirectoryRecord(dicomDirectoryRecord) : ((string = attributeList.get(TagFromName.DirectoryRecordType).getStringValues()[0]) == null ? new UnrecognizedDirectoryRecord(dicomDirectoryRecord, attributeList) : (string.equals("PATIENT") ? new PatientDirectoryRecord(dicomDirectoryRecord, attributeList) : (string.equals("STUDY") ? new StudyDirectoryRecord(dicomDirectoryRecord, attributeList) : (string.equals("SERIES") ? new SeriesDirectoryRecord(dicomDirectoryRecord, attributeList) : (string.equals("CONCATENATION") ? new ConcatenationDirectoryRecord(dicomDirectoryRecord, attributeList) : (string.equals("IMAGE") ? new ImageDirectoryRecord(dicomDirectoryRecord, attributeList) : (string.equals("SR DOCUMENT") ? new SRDocumentDirectoryRecord(dicomDirectoryRecord, attributeList) : (string.equals("KEY OBJECT DOC") ? new KODocumentDirectoryRecord(dicomDirectoryRecord, attributeList) : (string.equals("WAVEFORM") ? new WaveformDirectoryRecord(dicomDirectoryRecord, attributeList) : (string.equals("SPECTROSCOPY") ? new SpectroscopyDirectoryRecord(dicomDirectoryRecord, attributeList) : (string.equals("RAW DATA") ? new RawDataDirectoryRecord(dicomDirectoryRecord, attributeList) : (string.equals("RT DOSE") ? new RTDoseDirectoryRecord(dicomDirectoryRecord, attributeList) : (string.equals("RT STRUCTURE SET") ? new RTStructureSetDirectoryRecord(dicomDirectoryRecord, attributeList) : (string.equals("RT PLAN") ? new RTPlanDirectoryRecord(dicomDirectoryRecord, attributeList) : (string.equals("RT TREAT RECORD") ? new RTTreatmentRecordDirectoryRecord(dicomDirectoryRecord, attributeList) : (string.equals("PRESENTATION") ? new PresentationStateDirectoryRecord(dicomDirectoryRecord, attributeList) : (string.equals("REGISTRATION") ? new RegistrationDirectoryRecord(dicomDirectoryRecord, attributeList) : (string.equals("FIDUCIAL") ? new FiducialDirectoryRecord(dicomDirectoryRecord, attributeList) : (string.equals("VALUE MAP") ? new RealWorldValueMappingDirectoryRecord(dicomDirectoryRecord, attributeList) : (string.equals("STEREOMETRIC") ? new StereometricRelationshipDirectoryRecord(dicomDirectoryRecord, attributeList) : (string.equals("ENCAP DOC") ? new EncapsulatedDocumentDirectoryRecord(dicomDirectoryRecord, attributeList) : (string.equals("HL7 STRUC DOC") ? new HL7StructuredDocumentDirectoryRecord(dicomDirectoryRecord, attributeList) : new UnrecognizedDirectoryRecord(dicomDirectoryRecord, attributeList, string)))))))))))))))))))))));
        }
        catch (DicomException dicomException) {
            dicomDirectoryRecord2 = new UnrecognizedDirectoryRecord(dicomDirectoryRecord, attributeList);
        }
        return dicomDirectoryRecord2;
    }

    public TopDirectoryRecord getNewTopDirectoryRecord() {
        return new TopDirectoryRecord();
    }

    public PatientDirectoryRecord getNewPatientDirectoryRecord(DicomDirectoryRecord dicomDirectoryRecord, AttributeList attributeList) {
        return new PatientDirectoryRecord(dicomDirectoryRecord, attributeList);
    }

    public StudyDirectoryRecord getNewStudyDirectoryRecord(DicomDirectoryRecord dicomDirectoryRecord, AttributeList attributeList) {
        return new StudyDirectoryRecord(dicomDirectoryRecord, attributeList);
    }

    public SeriesDirectoryRecord getNewSeriesDirectoryRecord(DicomDirectoryRecord dicomDirectoryRecord, AttributeList attributeList) {
        return new SeriesDirectoryRecord(dicomDirectoryRecord, attributeList);
    }

    public ImageDirectoryRecord getNewImageDirectoryRecord(DicomDirectoryRecord dicomDirectoryRecord, AttributeList attributeList) {
        return new ImageDirectoryRecord(dicomDirectoryRecord, attributeList);
    }

    public SRDocumentDirectoryRecord getNewSRDocumentDirectoryRecord(DicomDirectoryRecord dicomDirectoryRecord, AttributeList attributeList) {
        return new SRDocumentDirectoryRecord(dicomDirectoryRecord, attributeList);
    }

    public KODocumentDirectoryRecord getNewKODocumentDirectoryRecord(DicomDirectoryRecord dicomDirectoryRecord, AttributeList attributeList) {
        return new KODocumentDirectoryRecord(dicomDirectoryRecord, attributeList);
    }

    public RTDoseDirectoryRecord getNewRTDoseDirectoryRecord(DicomDirectoryRecord dicomDirectoryRecord, AttributeList attributeList) {
        return new RTDoseDirectoryRecord(dicomDirectoryRecord, attributeList);
    }

    public RTStructureSetDirectoryRecord getNewRTStructureSetDirectoryRecord(DicomDirectoryRecord dicomDirectoryRecord, AttributeList attributeList) {
        return new RTStructureSetDirectoryRecord(dicomDirectoryRecord, attributeList);
    }

    public RTPlanDirectoryRecord getNewRTPlanDirectoryRecord(DicomDirectoryRecord dicomDirectoryRecord, AttributeList attributeList) {
        return new RTPlanDirectoryRecord(dicomDirectoryRecord, attributeList);
    }

    public RTTreatmentRecordDirectoryRecord getNewRTTreatmentRecordDirectoryRecord(DicomDirectoryRecord dicomDirectoryRecord, AttributeList attributeList) {
        return new RTTreatmentRecordDirectoryRecord(dicomDirectoryRecord, attributeList);
    }

    public PresentationStateDirectoryRecord getNewPresentationStateDirectoryRecord(DicomDirectoryRecord dicomDirectoryRecord, AttributeList attributeList) {
        return new PresentationStateDirectoryRecord(dicomDirectoryRecord, attributeList);
    }

    public SpectroscopyDirectoryRecord getNewSpectroscopyDirectoryRecord(DicomDirectoryRecord dicomDirectoryRecord, AttributeList attributeList) {
        return new SpectroscopyDirectoryRecord(dicomDirectoryRecord, attributeList);
    }

    public RawDataDirectoryRecord getNewRawDataDirectoryRecord(DicomDirectoryRecord dicomDirectoryRecord, AttributeList attributeList) {
        return new RawDataDirectoryRecord(dicomDirectoryRecord, attributeList);
    }

    public WaveformDirectoryRecord getNewWaveformDirectoryRecord(DicomDirectoryRecord dicomDirectoryRecord, AttributeList attributeList) {
        return new WaveformDirectoryRecord(dicomDirectoryRecord, attributeList);
    }

    public RegistrationDirectoryRecord getNewRegistrationDirectoryRecord(DicomDirectoryRecord dicomDirectoryRecord, AttributeList attributeList) {
        return new RegistrationDirectoryRecord(dicomDirectoryRecord, attributeList);
    }

    public FiducialDirectoryRecord getNewFiducialDirectoryRecord(DicomDirectoryRecord dicomDirectoryRecord, AttributeList attributeList) {
        return new FiducialDirectoryRecord(dicomDirectoryRecord, attributeList);
    }

    public RealWorldValueMappingDirectoryRecord getNewRealWorldValueMappingDirectoryRecord(DicomDirectoryRecord dicomDirectoryRecord, AttributeList attributeList) {
        return new RealWorldValueMappingDirectoryRecord(dicomDirectoryRecord, attributeList);
    }

    public StereometricRelationshipDirectoryRecord getNewStereometricRelationshipDirectoryRecord(DicomDirectoryRecord dicomDirectoryRecord, AttributeList attributeList) {
        return new StereometricRelationshipDirectoryRecord(dicomDirectoryRecord, attributeList);
    }

    public EncapsulatedDocumentDirectoryRecord getNewEncapsulatedDocumentDirectoryRecord(DicomDirectoryRecord dicomDirectoryRecord, AttributeList attributeList) {
        return new EncapsulatedDocumentDirectoryRecord(dicomDirectoryRecord, attributeList);
    }

    public HL7StructuredDocumentDirectoryRecord getNewHL7StructuredDocumentDirectoryRecord(DicomDirectoryRecord dicomDirectoryRecord, AttributeList attributeList) {
        return new HL7StructuredDocumentDirectoryRecord(dicomDirectoryRecord, attributeList);
    }

    class HL7StructuredDocumentDirectoryRecord
    extends DicomDirectoryRecord {
        HL7StructuredDocumentDirectoryRecord(DicomDirectoryRecord dicomDirectoryRecord, AttributeList attributeList) {
            super(dicomDirectoryRecord, attributeList);
            this.uid = Attribute.getSingleStringValueOrEmptyString(this.getAttributeList(), TagFromName.ReferencedSOPInstanceUIDInFile);
        }

        public String toString() {
            return "CDA " + this.getStringValue();
        }

        public int compareTo(Object object) {
            return this.compareToByStringValue((DicomDirectoryRecord)object);
        }

        protected void makeStringValue() {
            StringBuffer stringBuffer = new StringBuffer();
            String string = Attribute.getSingleStringValueOrNull(this.getAttributeList(), TagFromName.DocumentTitle);
            if (string == null) {
                string = SequenceAttribute.getMeaningOfCodedSequenceAttributeOrDefault(this.list, TagFromName.HL7DocumentTypeCodeSequence, "");
            }
            stringBuffer.append(string);
            this.stringValue = stringBuffer.toString();
        }

        protected void makeIntegerValue() {
            this.integerValue = Attribute.getSingleIntegerValueOrDefault(this.getAttributeList(), TagFromName.InstanceNumber, -1);
        }
    }

    class EncapsulatedDocumentDirectoryRecord
    extends SimpleInstanceDirectoryRecord {
        EncapsulatedDocumentDirectoryRecord(DicomDirectoryRecord dicomDirectoryRecord, AttributeList attributeList) {
            super(dicomDirectoryRecord, attributeList);
        }

        public String toString() {
            return "Encap " + this.getStringValue();
        }
    }

    class StereometricRelationshipDirectoryRecord
    extends SimpleInstanceDirectoryRecord {
        StereometricRelationshipDirectoryRecord(DicomDirectoryRecord dicomDirectoryRecord, AttributeList attributeList) {
            super(dicomDirectoryRecord, attributeList);
        }

        public String toString() {
            return "Stereo " + this.getStringValue();
        }
    }

    class RealWorldValueMappingDirectoryRecord
    extends SimpleInstanceDirectoryRecord {
        RealWorldValueMappingDirectoryRecord(DicomDirectoryRecord dicomDirectoryRecord, AttributeList attributeList) {
            super(dicomDirectoryRecord, attributeList);
        }

        public String toString() {
            return "RWV " + this.getStringValue();
        }
    }

    class FiducialDirectoryRecord
    extends SimpleInstanceDirectoryRecord {
        FiducialDirectoryRecord(DicomDirectoryRecord dicomDirectoryRecord, AttributeList attributeList) {
            super(dicomDirectoryRecord, attributeList);
        }

        public String toString() {
            return "Fiducial " + this.getStringValue();
        }
    }

    class RegistrationDirectoryRecord
    extends SimpleInstanceDirectoryRecord {
        RegistrationDirectoryRecord(DicomDirectoryRecord dicomDirectoryRecord, AttributeList attributeList) {
            super(dicomDirectoryRecord, attributeList);
        }

        public String toString() {
            return "Reg " + this.getStringValue();
        }
    }

    class PresentationStateDirectoryRecord
    extends SimpleInstanceDirectoryRecord {
        PresentationStateDirectoryRecord(DicomDirectoryRecord dicomDirectoryRecord, AttributeList attributeList) {
            super(dicomDirectoryRecord, attributeList);
        }

        public String toString() {
            return "PR " + this.getStringValue();
        }
    }

    class RTTreatmentRecordDirectoryRecord
    extends SimpleInstanceDirectoryRecord {
        RTTreatmentRecordDirectoryRecord(DicomDirectoryRecord dicomDirectoryRecord, AttributeList attributeList) {
            super(dicomDirectoryRecord, attributeList);
        }

        public String toString() {
            return "RT Treatment Record " + this.getStringValue();
        }
    }

    class RTPlanDirectoryRecord
    extends SimpleInstanceDirectoryRecord {
        RTPlanDirectoryRecord(DicomDirectoryRecord dicomDirectoryRecord, AttributeList attributeList) {
            super(dicomDirectoryRecord, attributeList);
        }

        public String toString() {
            return "RT Plan " + this.getStringValue();
        }
    }

    class RTStructureSetDirectoryRecord
    extends SimpleInstanceDirectoryRecord {
        RTStructureSetDirectoryRecord(DicomDirectoryRecord dicomDirectoryRecord, AttributeList attributeList) {
            super(dicomDirectoryRecord, attributeList);
        }

        public String toString() {
            return "RT Structure Set " + this.getStringValue();
        }
    }

    class RTDoseDirectoryRecord
    extends SimpleInstanceDirectoryRecord {
        RTDoseDirectoryRecord(DicomDirectoryRecord dicomDirectoryRecord, AttributeList attributeList) {
            super(dicomDirectoryRecord, attributeList);
        }

        public String toString() {
            return "RT Dose " + this.getStringValue();
        }
    }

    class WaveformDirectoryRecord
    extends SimpleInstanceDirectoryRecord {
        WaveformDirectoryRecord(DicomDirectoryRecord dicomDirectoryRecord, AttributeList attributeList) {
            super(dicomDirectoryRecord, attributeList);
        }

        public String toString() {
            return "Waveform " + this.getStringValue();
        }
    }

    class KODocumentDirectoryRecord
    extends SimpleInstanceDirectoryRecord {
        KODocumentDirectoryRecord(DicomDirectoryRecord dicomDirectoryRecord, AttributeList attributeList) {
            super(dicomDirectoryRecord, attributeList);
        }

        public String toString() {
            return "KO Document " + this.getStringValue();
        }
    }

    class SRDocumentDirectoryRecord
    extends SimpleInstanceDirectoryRecord {
        SRDocumentDirectoryRecord(DicomDirectoryRecord dicomDirectoryRecord, AttributeList attributeList) {
            super(dicomDirectoryRecord, attributeList);
        }

        public String toString() {
            return "SR Document " + this.getStringValue();
        }
    }

    class RawDataDirectoryRecord
    extends SimpleInstanceDirectoryRecord {
        RawDataDirectoryRecord(DicomDirectoryRecord dicomDirectoryRecord, AttributeList attributeList) {
            super(dicomDirectoryRecord, attributeList);
        }

        public String toString() {
            return "Raw Data " + this.getStringValue();
        }
    }

    abstract class SimpleInstanceDirectoryRecord
    extends DicomDirectoryRecord {
        SimpleInstanceDirectoryRecord(DicomDirectoryRecord dicomDirectoryRecord, AttributeList attributeList) {
            super(dicomDirectoryRecord, attributeList);
            this.uid = Attribute.getSingleStringValueOrEmptyString(this.getAttributeList(), TagFromName.ReferencedSOPInstanceUIDInFile);
        }

        public abstract String toString();

        public int compareTo(Object object) {
            return this.compareToByIntegerValue((DicomDirectoryRecord)object);
        }

        protected void makeStringValue() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(Attribute.getSingleStringValueOrEmptyString(this.getAttributeList(), TagFromName.InstanceNumber));
            this.stringValue = stringBuffer.toString();
        }

        protected void makeIntegerValue() {
            this.integerValue = Attribute.getSingleIntegerValueOrDefault(this.getAttributeList(), TagFromName.InstanceNumber, -1);
        }
    }

    class SpectroscopyDirectoryRecord
    extends DicomDirectoryRecord {
        SpectroscopyDirectoryRecord(DicomDirectoryRecord dicomDirectoryRecord, AttributeList attributeList) {
            super(dicomDirectoryRecord, attributeList);
            this.uid = Attribute.getSingleStringValueOrEmptyString(this.getAttributeList(), TagFromName.ReferencedSOPInstanceUIDInFile);
        }

        public String toString() {
            return "Spectra " + this.getStringValue();
        }

        public int compareTo(Object object) {
            return this.compareToByIntegerValue((DicomDirectoryRecord)object);
        }

        protected void makeStringValue() {
            StringBuffer stringBuffer = new StringBuffer();
            String string = Attribute.getSingleStringValueOrNull(this.getAttributeList(), TagFromName.InConcatenationNumber);
            if (string == null) {
                string = Attribute.getSingleStringValueOrEmptyString(this.getAttributeList(), TagFromName.InstanceNumber);
            }
            stringBuffer.append(string);
            stringBuffer.append(" ");
            stringBuffer.append(Attribute.getSingleStringValueOrEmptyString(this.getAttributeList(), TagFromName.ImageComments));
            this.stringValue = stringBuffer.toString();
        }

        protected void makeIntegerValue() {
            this.integerValue = Attribute.getSingleIntegerValueOrDefault(this.getAttributeList(), TagFromName.InConcatenationNumber, -1);
            if (this.integerValue == -1) {
                this.integerValue = Attribute.getSingleIntegerValueOrDefault(this.getAttributeList(), TagFromName.InstanceNumber, -1);
            }
        }
    }

    class ImageDirectoryRecord
    extends DicomDirectoryRecord {
        String recordNameFromSOPClass;

        ImageDirectoryRecord(DicomDirectoryRecord dicomDirectoryRecord, AttributeList attributeList) {
            super(dicomDirectoryRecord, attributeList);
            this.uid = Attribute.getSingleStringValueOrEmptyString(this.getAttributeList(), TagFromName.ReferencedSOPInstanceUIDInFile);
            String string = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.ReferencedSOPClassUIDInFile);
            this.recordNameFromSOPClass = "Image";
            if (string != null) {
                if (SOPClass.isSpectroscopy(string)) {
                    this.recordNameFromSOPClass = "Spectra";
                } else if (SOPClass.isRawData(string)) {
                    this.recordNameFromSOPClass = "Raw Data";
                }
            }
        }

        public String toString() {
            return this.recordNameFromSOPClass + " " + this.getStringValue();
        }

        public int compareTo(Object object) {
            return this.compareToByIntegerValue((DicomDirectoryRecord)object);
        }

        protected void makeStringValue() {
            this.stringValue = DescriptionFactory.makeImageDescription(this.getAttributeList());
        }

        protected void makeIntegerValue() {
            this.integerValue = Attribute.getSingleIntegerValueOrDefault(this.getAttributeList(), TagFromName.InConcatenationNumber, -1);
            if (this.integerValue == -1) {
                this.integerValue = Attribute.getSingleIntegerValueOrDefault(this.getAttributeList(), TagFromName.InstanceNumber, -1);
            }
        }
    }

    class ConcatenationDirectoryRecord
    extends DicomDirectoryRecord {
        ConcatenationDirectoryRecord(DicomDirectoryRecord dicomDirectoryRecord, AttributeList attributeList) {
            super(dicomDirectoryRecord, attributeList);
            this.uid = Attribute.getSingleStringValueOrEmptyString(this.getAttributeList(), TagFromName.ConcatenationUID);
        }

        public String toString() {
            return "Concatenation " + this.getStringValue();
        }

        public int compareTo(Object object) {
            return this.compareToByIntegerValue((DicomDirectoryRecord)object);
        }

        protected void makeStringValue() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(Attribute.getSingleStringValueOrEmptyString(this.getAttributeList(), TagFromName.InstanceNumber));
            this.stringValue = stringBuffer.toString();
        }

        protected void makeIntegerValue() {
            this.integerValue = Attribute.getSingleIntegerValueOrDefault(this.getAttributeList(), TagFromName.InstanceNumber, -1);
        }
    }

    class SeriesDirectoryRecord
    extends DicomDirectoryRecord {
        SeriesDirectoryRecord(DicomDirectoryRecord dicomDirectoryRecord, AttributeList attributeList) {
            super(dicomDirectoryRecord, attributeList);
            this.uid = Attribute.getSingleStringValueOrEmptyString(this.getAttributeList(), TagFromName.SeriesInstanceUID);
        }

        public String toString() {
            return "Series " + this.getStringValue();
        }

        public int compareTo(Object object) {
            return this.compareToByIntegerValue((DicomDirectoryRecord)object);
        }

        protected void makeStringValue() {
            this.stringValue = DescriptionFactory.makeSeriesDescription(this.getAttributeList());
        }

        protected void makeIntegerValue() {
            this.integerValue = Attribute.getSingleIntegerValueOrDefault(this.getAttributeList(), TagFromName.SeriesNumber, -1);
        }
    }

    class StudyDirectoryRecord
    extends DicomDirectoryRecord {
        StudyDirectoryRecord(DicomDirectoryRecord dicomDirectoryRecord, AttributeList attributeList) {
            super(dicomDirectoryRecord, attributeList);
            this.uid = Attribute.getSingleStringValueOrEmptyString(this.getAttributeList(), TagFromName.StudyInstanceUID);
        }

        public int compareTo(Object object) {
            return this.compareToByStringValue((DicomDirectoryRecord)object);
        }

        public String toString() {
            return "Study " + this.getStringValue();
        }

        protected void makeStringValue() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(Attribute.getSingleStringValueOrEmptyString(this.getAttributeList(), TagFromName.StudyDate));
            stringBuffer.append(" ");
            stringBuffer.append(Attribute.getSingleStringValueOrEmptyString(this.getAttributeList(), TagFromName.StudyID));
            stringBuffer.append(" ");
            stringBuffer.append(Attribute.getSingleStringValueOrEmptyString(this.getAttributeList(), TagFromName.StudyDescription));
            this.stringValue = stringBuffer.toString();
        }

        protected void makeIntegerValue() {
            this.integerValue = -1;
        }
    }

    class PatientDirectoryRecord
    extends DicomDirectoryRecord {
        PatientDirectoryRecord(DicomDirectoryRecord dicomDirectoryRecord, AttributeList attributeList) {
            super(dicomDirectoryRecord, attributeList);
            this.uid = "";
        }

        public String toString() {
            return "Patient " + this.getStringValue();
        }

        public int compareTo(Object object) {
            return this.toString().compareTo(((DicomDirectoryRecord)object).toString());
        }

        protected void makeStringValue() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(Attribute.getSingleStringValueOrEmptyString(this.getAttributeList(), TagFromName.PatientName));
            stringBuffer.append(" ");
            stringBuffer.append(Attribute.getSingleStringValueOrEmptyString(this.getAttributeList(), TagFromName.PatientID));
            this.stringValue = stringBuffer.toString();
        }

        protected void makeIntegerValue() {
            this.integerValue = -1;
        }
    }

    class UnrecognizedDirectoryRecord
    extends DicomDirectoryRecord {
        private String directoryRecordType;

        UnrecognizedDirectoryRecord() {
            super(null, null);
            this.directoryRecordType = "Unrecognized";
        }

        UnrecognizedDirectoryRecord(DicomDirectoryRecord dicomDirectoryRecord) {
            super(dicomDirectoryRecord, null);
            this.directoryRecordType = "Unrecognized";
        }

        UnrecognizedDirectoryRecord(DicomDirectoryRecord dicomDirectoryRecord, AttributeList attributeList) {
            super(dicomDirectoryRecord, attributeList);
            this.directoryRecordType = "Unrecognized";
        }

        UnrecognizedDirectoryRecord(DicomDirectoryRecord dicomDirectoryRecord, AttributeList attributeList, String string) {
            super(dicomDirectoryRecord, attributeList);
            this.uid = "";
            this.directoryRecordType = string;
        }

        public String toString() {
            return this.directoryRecordType;
        }

        protected void makeStringValue() {
            this.stringValue = "BAD";
        }

        protected void makeIntegerValue() {
            this.integerValue = -1;
        }
    }

    class TopDirectoryRecord
    extends DicomDirectoryRecord {
        TopDirectoryRecord() {
            super(null, null);
            this.uid = "";
        }

        public String toString() {
            return "Top";
        }

        protected void makeStringValue() {
            this.stringValue = "BAD";
        }

        protected void makeIntegerValue() {
            this.integerValue = -1;
        }
    }
}

