/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.DicomOutputStream;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.TransferSyntax;
import com.pixelmed.dicom.ValueRepresentation;
import com.pixelmed.utils.ByteArray;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class DicomStreamCopier {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/DicomStreamCopier.java,v 1.16 2007/08/01 11:41:24 dclunie Exp $";
    private static DicomDictionary dictionary;
    private DicomInputStream i;
    private DicomOutputStream o;
    private static final int bufferSize = 32768;

    private void createDictionaryifNecessary() {
        if (dictionary == null) {
            dictionary = new DicomDictionary();
        }
    }

    private AttributeTag readAttributeTag() throws IOException {
        int n = this.i.readUnsigned16();
        int n2 = this.i.readUnsigned16();
        return new AttributeTag(n, n2);
    }

    private void writeAttributeTag(AttributeTag attributeTag) throws IOException {
        this.o.writeUnsigned16(attributeTag.getGroup());
        this.o.writeUnsigned16(attributeTag.getElement());
    }

    private long copySequenceAttribute(long l, long l2, boolean bl) throws IOException, DicomException {
        boolean bl2;
        block10: {
            bl2 = l2 == 0xFFFFFFFFL;
            long l3 = bl2 ? 0xFFFFFFFFL : l + l2 - 1L;
            try {
                while (bl2 || l < l3) {
                    long l4 = l;
                    AttributeTag attributeTag = this.readAttributeTag();
                    l += 4L;
                    if (bl) {
                        this.writeAttributeTag(attributeTag);
                    }
                    long l5 = this.i.readUnsigned32();
                    l += 4L;
                    if (attributeTag.equals(TagFromName.SequenceDelimitationItem)) {
                        if (!bl) break;
                        this.o.writeUnsigned32(l5);
                        break;
                    }
                    if (attributeTag.equals(TagFromName.Item)) {
                        if (bl) {
                            this.o.writeUnsigned32(0xFFFFFFFFL);
                        }
                        l = this.copy(l, l5, false, false, bl, false);
                        if (!bl || l5 == 0xFFFFFFFFL) continue;
                        this.writeAttributeTag(TagFromName.ItemDelimitationItem);
                        this.o.writeUnsigned32(0L);
                        continue;
                    }
                    throw new DicomException("Bad tag " + attributeTag + "(not Item or Sequence Delimiter) in Sequence at byte offset " + l);
                }
            }
            catch (EOFException eOFException) {
                if (!bl2) {
                    throw new EOFException();
                }
            }
            catch (IOException iOException) {
                if (bl2) break block10;
                throw new IOException();
            }
        }
        if (bl && !bl2) {
            this.writeAttributeTag(TagFromName.SequenceDelimitationItem);
            this.o.writeUnsigned32(0L);
        }
        return l;
    }

    private long copy(long l, long l2, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws IOException, DicomException {
        block81: {
            Closeable closeable;
            Object[] objectArray;
            Class[] classArray;
            Object object;
            if (this.i.areReadingDataSet()) {
                if (this.i.getTransferSyntaxToReadDataSet().isDeflated()) {
                    this.i = new DicomInputStream(new InflaterInputStream(this.i, new Inflater(true)), "1.2.840.10008.1.2.1", false);
                    l = 0L;
                } else if (this.i.getTransferSyntaxToReadDataSet().isBzip2ed()) {
                    try {
                        object = Thread.currentThread().getContextClassLoader().loadClass("org.apache.excalibur.bzip2.CBZip2InputStream");
                        classArray = new Class[]{InputStream.class};
                        objectArray = new Object[]{this.i};
                        closeable = (InputStream)((Class)object).getConstructor(classArray).newInstance(objectArray);
                        this.i = new DicomInputStream((InputStream)closeable, "1.2.840.10008.1.2.1", false);
                        l = 0L;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw new DicomException("Not a correctly encoded bzip2 bitstream - " + invocationTargetException);
                    }
                    catch (Exception exception) {
                        throw new DicomException("Could not instantiate bzip2 codec - " + exception);
                    }
                }
            }
            if (this.o.areWritingDataSet()) {
                if (this.o.getTransferSyntaxToWriteDataSet().isDeflated()) {
                    object = new DeflaterOutputStream((OutputStream)this.o, new Deflater(9, true));
                    this.o = new DicomOutputStream((OutputStream)object, null, "1.2.840.10008.1.2.1");
                    l = 0L;
                } else if (this.o.getTransferSyntaxToWriteDataSet().isBzip2ed()) {
                    try {
                        object = Thread.currentThread().getContextClassLoader().loadClass("org.apache.excalibur.bzip2.CBZip2OutputStream");
                        classArray = new Class[]{OutputStream.class};
                        objectArray = new Object[]{this.o};
                        closeable = (OutputStream)((Class)object).getConstructor(classArray).newInstance(objectArray);
                        this.o = new DicomOutputStream((OutputStream)closeable, null, "1.2.840.10008.1.2.1");
                        l = 0L;
                    }
                    catch (Exception exception) {
                        throw new DicomException("Could not instantiate bzip2 codec - " + exception);
                    }
                }
            }
            object = new byte[32768];
            this.createDictionaryifNecessary();
            boolean bl5 = l2 == 0xFFFFFFFFL;
            long l3 = bl5 ? 0xFFFFFFFFL : l + l2 - 1L;
            byte[] byArray = new byte[2];
            String string = null;
            long l4 = 0L;
            int n = 0;
            int n2 = 0;
            boolean bl6 = this.i.getTransferSyntaxInUse().isExplicitVR();
            boolean bl7 = this.o.getTransferSyntaxInUse().isExplicitVR();
            boolean bl8 = this.i.getTransferSyntaxInUse().isLittleEndian() != this.o.getTransferSyntaxInUse().isLittleEndian();
            try {
                while (bl5 || l < l3) {
                    long l5;
                    byte[] byArray2;
                    AttributeTag attributeTag = this.readAttributeTag();
                    l += 4L;
                    boolean bl9 = bl3;
                    if (attributeTag.equals(TagFromName.DataSetTrailingPadding)) {
                        bl3 = false;
                        bl9 = false;
                    } else if (attributeTag.getGroup() == 2 && !bl2) {
                        bl3 = false;
                    } else if (attributeTag.getGroup() != 0 && attributeTag.getGroup() != 2 && attributeTag.getElement() == 0) {
                        bl3 = false;
                    } else if (attributeTag.equals(TagFromName.LengthToEnd)) {
                        bl3 = false;
                    } else {
                        this.writeAttributeTag(attributeTag);
                    }
                    if (attributeTag.equals(TagFromName.ItemDelimitationItem)) {
                        long l6 = this.i.readUnsigned32();
                        l += 4L;
                        if (bl3) {
                            this.o.writeUnsigned32(l6);
                        }
                        return l;
                    }
                    if (attributeTag.equals(TagFromName.Item)) {
                        long l7 = this.i.readUnsigned32();
                        l += 4L;
                        if (bl3) {
                            this.o.writeUnsigned32(l7);
                        }
                        System.err.println("Ignoring bad Item at " + l + " " + attributeTag + " VL=<0x" + Long.toHexString(l7) + ">");
                        continue;
                    }
                    if (bl6) {
                        byArray2 = byArray;
                        this.i.readInsistently(byArray2, 0, 2);
                        l += 2L;
                        if (ValueRepresentation.isOtherUnspecifiedVR(byArray2) || ValueRepresentation.isUnspecifiedShortVR(byArray2) || ValueRepresentation.isUnspecifiedShortOrOtherWordVR(byArray2)) {
                            throw new DicomException("Illegal explicit value representation in input - " + ValueRepresentation.getAsString(byArray2));
                        }
                    } else {
                        byArray2 = dictionary.getValueRepresentationFromTag(attributeTag);
                        if (byArray2 == null) {
                            byArray2 = ValueRepresentation.UN;
                        }
                    }
                    if (bl6) {
                        if (ValueRepresentation.isShortValueLengthVR(byArray2)) {
                            l5 = this.i.readUnsigned16();
                            l += 2L;
                        } else {
                            this.i.readUnsigned16();
                            l5 = this.i.readUnsigned32();
                            l += 6L;
                        }
                    } else {
                        l5 = this.i.readUnsigned32();
                        l += 4L;
                    }
                    if (bl3) {
                        if (bl7) {
                            if (ValueRepresentation.isOtherUnspecifiedVR(byArray2)) {
                                byArray2 = attributeTag.equals(TagFromName.PixelData) && l5 != 0xFFFFFFFFL && n2 > 8 || (attributeTag.getGroup() & 0xFF00) == 24576 && attributeTag.getElement() == 12288 || (attributeTag.getGroup() & 0xFF00) == 20480 && attributeTag.getElement() == 8204 || attributeTag.equals(TagFromName.WaveformData) ? ValueRepresentation.OW : ValueRepresentation.OB;
                            } else if (ValueRepresentation.isUnspecifiedShortOrOtherWordVR(byArray2)) {
                                byArray2 = ValueRepresentation.OW;
                            } else if (ValueRepresentation.isUnspecifiedShortVR(byArray2)) {
                                byArray2 = n == 0 ? ValueRepresentation.US : ValueRepresentation.SS;
                            }
                            this.o.write(byArray2, 0, 2);
                            if (ValueRepresentation.isShortValueLengthVR(byArray2)) {
                                this.o.writeUnsigned16((int)l5);
                            } else {
                                this.o.writeUnsigned16(0);
                                if (ValueRepresentation.isSequenceVR(byArray2)) {
                                    this.o.writeUnsigned32(0xFFFFFFFFL);
                                } else {
                                    this.o.writeUnsigned32(l5);
                                }
                            }
                        } else if (ValueRepresentation.isSequenceVR(byArray2)) {
                            this.o.writeUnsigned32(0xFFFFFFFFL);
                        } else {
                            this.o.writeUnsigned32(l5);
                        }
                    }
                    if (ValueRepresentation.isSequenceVR(byArray2) || l5 == 0xFFFFFFFFL) {
                        l = this.copySequenceAttribute(l, l5, bl3);
                    } else if (attributeTag.equals(TagFromName.FileMetaInformationGroupLength)) {
                        if (l5 != 4L) {
                            throw new DicomException("Error copying FileMetaInformationGroupLength from meta information header - value wrong length " + l5);
                        }
                        l4 = this.i.readUnsigned32();
                        if (bl3) {
                            this.o.writeUnsigned32(l4);
                        }
                        l += 4L;
                    } else if (attributeTag.equals(TagFromName.TransferSyntaxUID)) {
                        if (l5 > 32768L) {
                            throw new DicomException("Error copying TransferSyntaxUID from meta information header - value too long " + l5);
                        }
                        this.i.readInsistently((byte[])object, 0, (int)l5);
                        if (bl3) {
                            this.o.write((byte[])object, 0, (int)l5);
                        }
                        string = new String((byte[])object, 0, (int)l5);
                        l += l5;
                    } else if (attributeTag.equals(TagFromName.PixelRepresentation)) {
                        if (l5 != 2L) {
                            throw new DicomException("Error copying PixelRepresentation - value wrong length " + l5);
                        }
                        n = this.i.readUnsigned16();
                        if (bl3) {
                            this.o.writeUnsigned16(n);
                        }
                        l += 2L;
                    } else if (attributeTag.equals(TagFromName.BitsAllocated)) {
                        if (l5 != 2L) {
                            throw new DicomException("Error copying BitsAllocated - value wrong length " + l5);
                        }
                        n2 = this.i.readUnsigned16();
                        if (bl3) {
                            this.o.writeUnsigned16(n2);
                        }
                        l += 2L;
                    } else {
                        int n3 = ValueRepresentation.getWordLengthOfValueAffectedByEndianness(byArray2);
                        if (bl8 && n3 > 1 && l5 % (long)n3 != 0L) {
                            throw new DicomException("VL " + l5 + " not a multiple of the expected VR value length " + n3);
                        }
                        while (l5 > 32768L) {
                            this.i.readInsistently((byte[])object, 0, 32768);
                            if (bl3) {
                                if (bl8 && n3 > 1) {
                                    ByteArray.swapEndianness((byte[])object, 32768, n3);
                                }
                                this.o.write((byte[])object, 0, 32768);
                            }
                            l += 32768L;
                            l5 -= 32768L;
                        }
                        if (l5 > 0L) {
                            this.i.readInsistently((byte[])object, 0, (int)l5);
                            l += l5;
                            if (bl3) {
                                if (bl8 && n3 > 1) {
                                    ByteArray.swapEndianness((byte[])object, (int)l5, n3);
                                }
                                this.o.write((byte[])object, 0, (int)l5);
                            }
                        }
                    }
                    if (bl9) {
                        bl3 = true;
                    }
                    if (attributeTag.equals(TagFromName.FileMetaInformationGroupLength)) {
                        if (!this.i.areReadingMetaHeader()) continue;
                        long l8 = l4;
                        l = this.copy(l, l8, true, bl2, bl3, false);
                        this.i.setReadingDataSet();
                        this.o.setWritingDataSet();
                        if (!bl) {
                            l = this.copy(l, 0xFFFFFFFFL, false, bl2, bl3, true);
                            continue;
                        }
                        break;
                    }
                    if (!attributeTag.equals(TagFromName.TransferSyntaxUID) || !this.i.areReadingMetaHeader()) continue;
                    this.i.setTransferSyntaxToReadDataSet(new TransferSyntax(string));
                }
            }
            catch (EOFException eOFException) {
                if (!bl5) {
                    throw new EOFException();
                }
            }
            catch (IOException iOException) {
                if (bl5) break block81;
                throw new IOException();
            }
        }
        if (bl4) {
            this.o.close();
        }
        return l;
    }

    public DicomStreamCopier(DicomInputStream dicomInputStream, DicomOutputStream dicomOutputStream) throws DicomException, IOException {
        this.i = dicomInputStream;
        this.o = dicomOutputStream;
        this.copy(0L, 0xFFFFFFFFL, false, false, true, true);
    }

    public static void main(String[] stringArray) {
        try {
            DicomInputStream dicomInputStream = new DicomInputStream(new BufferedInputStream(new FileInputStream(stringArray[1])), stringArray[0], stringArray[0].length() == 0);
            DicomOutputStream dicomOutputStream = new DicomOutputStream(new BufferedOutputStream(new FileOutputStream(stringArray[3])), null, stringArray[2]);
            new DicomStreamCopier(dicomInputStream, dicomOutputStream);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            System.exit(0);
        }
    }
}

