/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.FrameSet;
import com.pixelmed.dicom.TagFromName;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.util.HashSet;
import java.util.Iterator;

class SetOfFrameSets
extends HashSet {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/SetOfFrameSets.java,v 1.3 2005/11/12 14:03:51 dclunie Exp $";

    SetOfFrameSets() {
    }

    void insertIntoFrameSets(AttributeList attributeList) {
        boolean bl = false;
        for (FrameSet frameSet : this) {
            if (!frameSet.eligible(attributeList)) continue;
            frameSet.insert(attributeList);
            bl = true;
            break;
        }
        if (!bl) {
            this.add(new FrameSet(attributeList));
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("Frame set [");
            stringBuffer.append(Integer.toString(n));
            stringBuffer.append("]:\n");
            stringBuffer.append(((FrameSet)iterator.next()).toString());
            stringBuffer.append("\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        SetOfFrameSets setOfFrameSets = new SetOfFrameSets();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            try {
                DicomInputStream dicomInputStream = new DicomInputStream(new BufferedInputStream(new FileInputStream(string)));
                AttributeList attributeList = new AttributeList();
                attributeList.read(dicomInputStream, TagFromName.PixelData);
                dicomInputStream.close();
                setOfFrameSets.insertIntoFrameSets(attributeList);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
                System.exit(0);
            }
        }
        System.out.println(setOfFrameSets.toString());
    }
}

