/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

public class TransferSyntax {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/TransferSyntax.java,v 1.19 2006/08/08 13:12:01 dclunie Exp $";
    public static final String ImplicitVRLittleEndian = "1.2.840.10008.1.2";
    public static final String ExplicitVRLittleEndian = "1.2.840.10008.1.2.1";
    public static final String ExplicitVRBigEndian = "1.2.840.10008.1.2.2";
    public static final String Default = "1.2.840.10008.1.2";
    public static final String DeflatedExplicitVRLittleEndian = "1.2.840.10008.1.2.1.99";
    public static final String JPEGBaseline = "1.2.840.10008.1.2.4.50";
    public static final String JPEGExtended = "1.2.840.10008.1.2.4.51";
    public static final String JPEGLossless = "1.2.840.10008.1.2.4.57";
    public static final String JPEGLosslessSV1 = "1.2.840.10008.1.2.4.70";
    public static final String JPEGLS = "1.2.840.10008.1.2.4.80";
    public static final String JPEGNLS = "1.2.840.10008.1.2.4.81";
    public static final String JPEG2000Lossless = "1.2.840.10008.1.2.4.90";
    public static final String JPEG2000 = "1.2.840.10008.1.2.4.91";
    public static final String MPEG2MPML = "1.2.840.10008.1.2.4.100";
    public static final String PixelMedBzip2ExplicitVRLittleEndian = "1.3.6.1.4.1.5962.300.1";
    public static final String PixelMedEncapsulatedRawLittleEndian = "1.3.6.1.4.1.5962.300.2";
    protected String transferSyntaxUID;
    protected String description;
    protected boolean bigEndian;
    protected boolean explicitVR;
    protected boolean encapsulatedPixelData;
    protected boolean lossy;
    protected boolean transformedColorSpace;

    public TransferSyntax(String string) {
        this.transferSyntaxUID = string;
        this.description = "Unrecognized";
        this.bigEndian = false;
        this.explicitVR = true;
        this.encapsulatedPixelData = false;
        this.lossy = false;
        this.transformedColorSpace = false;
        if (this.transferSyntaxUID.equals("1.2.840.10008.1.2")) {
            this.description = "Implicit VR Little Endian";
            this.bigEndian = false;
            this.explicitVR = false;
            this.encapsulatedPixelData = false;
            this.lossy = false;
            this.transformedColorSpace = false;
        } else if (this.transferSyntaxUID.equals(ExplicitVRLittleEndian)) {
            this.description = "Explicit VR Little Endian";
            this.bigEndian = false;
            this.explicitVR = true;
            this.encapsulatedPixelData = false;
            this.lossy = false;
            this.transformedColorSpace = false;
        } else if (this.transferSyntaxUID.equals(ExplicitVRBigEndian)) {
            this.description = "Explicit VR Big Endian";
            this.bigEndian = true;
            this.explicitVR = true;
            this.encapsulatedPixelData = false;
            this.lossy = false;
            this.transformedColorSpace = false;
        } else if (this.transferSyntaxUID.equals(PixelMedEncapsulatedRawLittleEndian)) {
            this.description = "PixelMed Encapsulated Raw Little Endian";
            this.bigEndian = false;
            this.explicitVR = true;
            this.encapsulatedPixelData = true;
            this.lossy = false;
            this.transformedColorSpace = false;
        } else if (this.transferSyntaxUID.equals(JPEGBaseline)) {
            this.description = "JPEG Baseline";
            this.bigEndian = false;
            this.explicitVR = true;
            this.encapsulatedPixelData = true;
            this.lossy = true;
            this.transformedColorSpace = true;
        } else if (this.transferSyntaxUID.equals(JPEGExtended)) {
            this.description = "JPEG Extended";
            this.bigEndian = false;
            this.explicitVR = true;
            this.encapsulatedPixelData = true;
            this.lossy = true;
            this.transformedColorSpace = true;
        } else if (this.transferSyntaxUID.equals(JPEG2000Lossless)) {
            this.description = "JPEG 2000 Lossless Only";
            this.bigEndian = false;
            this.explicitVR = true;
            this.encapsulatedPixelData = true;
            this.lossy = false;
            this.transformedColorSpace = true;
        } else if (this.transferSyntaxUID.equals(JPEG2000)) {
            this.description = "JPEG 2000";
            this.bigEndian = false;
            this.explicitVR = true;
            this.encapsulatedPixelData = true;
            this.lossy = true;
        } else if (this.transferSyntaxUID.equals(JPEGLossless)) {
            this.description = "JPEG Lossless";
            this.bigEndian = false;
            this.explicitVR = true;
            this.encapsulatedPixelData = true;
            this.lossy = false;
            this.transformedColorSpace = true;
        } else if (this.transferSyntaxUID.equals(JPEGLosslessSV1)) {
            this.description = "JPEG Lossless SV1";
            this.bigEndian = false;
            this.explicitVR = true;
            this.encapsulatedPixelData = true;
            this.lossy = false;
            this.transformedColorSpace = true;
        } else if (this.transferSyntaxUID.equals(JPEGLS)) {
            this.description = "JPEG-LS";
            this.bigEndian = false;
            this.explicitVR = true;
            this.encapsulatedPixelData = true;
            this.lossy = false;
            this.transformedColorSpace = true;
        } else if (this.transferSyntaxUID.equals(JPEGNLS)) {
            this.description = "JPEG-LS Near-lossless";
            this.bigEndian = false;
            this.explicitVR = true;
            this.encapsulatedPixelData = true;
            this.lossy = true;
            this.transformedColorSpace = true;
        } else if (this.transferSyntaxUID.equals(MPEG2MPML)) {
            this.description = "MPEG2 MPML";
            this.bigEndian = false;
            this.explicitVR = true;
            this.encapsulatedPixelData = true;
            this.lossy = true;
            this.transformedColorSpace = true;
        }
    }

    public TransferSyntax(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.transferSyntaxUID = string;
        this.description = string2;
        this.explicitVR = bl;
        this.bigEndian = bl2;
        this.encapsulatedPixelData = bl3;
        this.lossy = bl4;
        this.transformedColorSpace = bl5;
    }

    public String getUID() {
        return this.transferSyntaxUID;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isBigEndian() {
        return this.bigEndian;
    }

    public boolean isLittleEndian() {
        return !this.bigEndian;
    }

    public boolean isExplicitVR() {
        return this.explicitVR;
    }

    public boolean isImplicitVR() {
        return !this.explicitVR;
    }

    public boolean isEncapsulated() {
        return this.encapsulatedPixelData;
    }

    public boolean isNotEncapsulated() {
        return !this.encapsulatedPixelData;
    }

    public boolean isLossy() {
        return this.lossy;
    }

    public boolean isDeflated() {
        return this.transferSyntaxUID.equals(DeflatedExplicitVRLittleEndian);
    }

    public boolean isBzip2ed() {
        return this.transferSyntaxUID.equals(PixelMedBzip2ExplicitVRLittleEndian);
    }

    public boolean mayBeTransformedColorSpace() {
        return this.transformedColorSpace;
    }

    public String toString() {
        return this.transferSyntaxUID;
    }

    public static boolean isExplicitVR(String string) {
        return !TransferSyntax.isImplicitVR(string);
    }

    public static boolean isImplicitVR(String string) {
        return string.equals("1.2.840.10008.1.2");
    }

    public static boolean isBigEndian(String string) {
        return string.equals(ExplicitVRBigEndian);
    }

    public static boolean isLittleEndian(String string) {
        return !TransferSyntax.isBigEndian(string);
    }

    public static boolean mayBeTransformedColorSpace(String string) {
        return new TransferSyntax(string).mayBeTransformedColorSpace();
    }
}

