/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.ArrayCopyUtilities;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.DicomOutputStream;
import com.pixelmed.dicom.ValueRepresentation;
import java.io.IOException;
import java.text.NumberFormat;

public class UnsignedShortAttribute
extends Attribute {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/UnsignedShortAttribute.java,v 1.15 2008/02/21 04:45:05 dclunie Exp $";
    short[] values;
    int[] cachedIntegerCopy;
    long[] cachedLongCopy;
    static int bytesPerValue = 2;

    private void flushCachedCopies() {
        this.cachedIntegerCopy = null;
        this.cachedLongCopy = null;
    }

    public UnsignedShortAttribute(AttributeTag attributeTag) {
        super(attributeTag);
        this.flushCachedCopies();
        this.values = null;
    }

    public UnsignedShortAttribute(AttributeTag attributeTag, long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        super(attributeTag);
        this.doCommonConstructorStuff(l, dicomInputStream);
    }

    public UnsignedShortAttribute(AttributeTag attributeTag, Long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        super(attributeTag);
        this.doCommonConstructorStuff(l, dicomInputStream);
    }

    private void doCommonConstructorStuff(long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        this.flushCachedCopies();
        if (l % (long)bytesPerValue != 0L) {
            throw new DicomException("incorrect value length for VR " + this.getVR());
        }
        int n = (int)(l / (long)bytesPerValue);
        this.values = null;
        for (int i = 0; i < n; ++i) {
            this.addValue((short)dicomInputStream.readUnsigned16());
        }
    }

    public void write(DicomOutputStream dicomOutputStream) throws DicomException, IOException {
        this.writeBase(dicomOutputStream);
        short[] sArray = this.getShortValues();
        if (sArray != null) {
            for (int i = 0; i < sArray.length; ++i) {
                dicomOutputStream.writeUnsigned16(sArray[i]);
            }
        }
    }

    public String toString(DicomDictionary dicomDictionary) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString(dicomDictionary));
        stringBuffer.append(" [");
        try {
            int[] nArray = this.getIntegerValues();
            if (nArray != null) {
                for (int i = 0; i < nArray.length; ++i) {
                    if (i > 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append("0x");
                    stringBuffer.append(Integer.toHexString(nArray[i]));
                }
            }
        }
        catch (DicomException dicomException) {
            stringBuffer.append("XXXX");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public String[] getStringValues(NumberFormat numberFormat) throws DicomException {
        String[] stringArray = null;
        int[] nArray = this.getIntegerValues();
        if (nArray != null) {
            stringArray = new String[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                stringArray[i] = numberFormat == null ? Integer.toString(nArray[i]) : numberFormat.format(nArray[i]);
            }
        }
        return stringArray;
    }

    public short[] getShortValues() throws DicomException {
        return this.values;
    }

    public int[] getIntegerValues() throws DicomException {
        if (this.cachedIntegerCopy == null) {
            this.cachedIntegerCopy = ArrayCopyUtilities.copyUnsignedShortToIntArray(this.values);
        }
        return this.cachedIntegerCopy;
    }

    public long[] getLongValues() throws DicomException {
        if (this.cachedLongCopy == null) {
            this.cachedLongCopy = ArrayCopyUtilities.copyUnsignedShortToLongArray(this.values);
        }
        return this.cachedLongCopy;
    }

    public void addValue(short s) throws DicomException {
        this.flushCachedCopies();
        this.values = ArrayCopyUtilities.expandArray(this.values);
        this.values[this.valueMultiplicity++] = s;
        this.valueLength += 2L;
    }

    public void addValue(int n) throws DicomException {
        this.addValue((short)n);
    }

    public void addValue(long l) throws DicomException {
        this.addValue((short)l);
    }

    public void addValue(float f) throws DicomException {
        this.addValue((short)f);
    }

    public void addValue(double d) throws DicomException {
        this.addValue((short)d);
    }

    public void addValue(String string) throws DicomException {
        short s = 0;
        try {
            s = (short)Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new DicomException(numberFormatException.toString());
        }
        this.addValue(s);
    }

    public void removeValues() {
        this.flushCachedCopies();
        this.values = null;
        this.valueMultiplicity = 0;
        this.valueLength = 0L;
    }

    public byte[] getVR() {
        return ValueRepresentation.US;
    }
}

