/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.display;

import com.pixelmed.dicom.ModalityTransform;
import com.pixelmed.dicom.SpectroscopyVolumeLocalization;
import com.pixelmed.dicom.VOITransform;
import com.pixelmed.display.PlotGraph;
import com.pixelmed.display.SingleImagePanel;
import com.pixelmed.display.SourceImage;
import com.pixelmed.display.event.FrameSelectionChangeEvent;
import com.pixelmed.display.event.FrameSortOrderChangeEvent;
import com.pixelmed.display.event.SourceImageSelectionChangeEvent;
import com.pixelmed.display.event.StatusChangeEvent;
import com.pixelmed.event.ApplicationEventDispatcher;
import com.pixelmed.event.Event;
import com.pixelmed.event.EventContext;
import com.pixelmed.event.SelfRegisteringListener;
import com.pixelmed.geometry.GeometryOfSlice;
import com.pixelmed.geometry.GeometryOfVolume;
import com.pixelmed.geometry.LocalizerPoster;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.SwingUtilities;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

public class SpectraPanel
extends PlotGraph
implements MouseListener,
MouseMotionListener {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/display/SpectraPanel.java,v 1.25 2007/04/03 13:11:08 dclunie Exp $";
    private float[][] srcSpectra;
    private int nSrcSpectra;
    private int currentSrcSpectrumIndex;
    private int[] currentSrcSpectraSortOrder;
    private GeometryOfVolume spectroscopyGeometry;
    private SpectroscopyVolumeLocalization spectroscopyVolumeLocalization;
    int lastmiddley;
    EventContext typeOfPanelEventContext;
    EventContext backgroundImageEventContext;
    private OurFrameSelectionChangeListener ourFrameSelectionChangeListener;
    private OurFrameSortOrderChangeListener ourFrameSortOrderChangeListener;
    SourceImage backgroundSImg;
    int currentBackgroundSrcImageIndex;
    int[] currentBackgroundSrcImageSortOrder;
    private GeometryOfVolume backgroundSrcImageGeometry;
    BufferedImage cachedBackgroundImage;
    private HashMap cacheOfImagesForSpectra;
    private Rectangle cacheForBounds;
    private OurBackgroundSourceImageSelectionChangeListener ourBackgroundSourceImageSelectionChangeListener;

    public GeometryOfVolume getSpectroscopyGeometry() {
        return this.spectroscopyGeometry;
    }

    public SpectroscopyVolumeLocalization getSpectroscopyVolumeLocalization() {
        return this.spectroscopyVolumeLocalization;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (SwingUtilities.isMiddleMouseButton(mouseEvent)) {
            int n = mouseEvent.getY() - this.lastmiddley;
            int n2 = this.currentSrcSpectrumIndex + n;
            if (n2 >= this.nSrcSpectra) {
                n2 = this.nSrcSpectra - 1;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if (n2 != this.currentSrcSpectrumIndex) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new FrameSelectionChangeEvent(this.typeOfPanelEventContext, n2));
            }
            this.lastmiddley = mouseEvent.getY();
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        double d = mouseEvent.getX();
        double d2 = mouseEvent.getY();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        stringBuffer.append((int)(d / (double)this.widthOfTile));
        stringBuffer.append(":");
        stringBuffer.append((int)(d % (double)this.widthOfTile / (double)this.widthOfTile * (double)this.samplesPerTile));
        stringBuffer.append(",");
        stringBuffer.append((int)(d2 / (double)this.heightOfTile));
        stringBuffer.append(")");
        ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent(stringBuffer.toString()));
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isMiddleMouseButton(mouseEvent)) {
            this.lastmiddley = mouseEvent.getY();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public SpectraPanel(float[][] fArray, int n, int n2, float f, float f2, GeometryOfVolume geometryOfVolume, SpectroscopyVolumeLocalization spectroscopyVolumeLocalization, EventContext eventContext, EventContext eventContext2) {
        super(n, n2, f, f2);
        this.srcSpectra = fArray;
        this.nSrcSpectra = fArray.length;
        this.currentSrcSpectrumIndex = 0;
        this.samples = fArray[this.currentSrcSpectrumIndex];
        this.samplesPerRow = this.samples.length / n;
        this.samplesPerTile = this.samplesPerRow / n2;
        this.currentSrcSpectraSortOrder = null;
        this.spectroscopyGeometry = geometryOfVolume;
        this.spectroscopyVolumeLocalization = spectroscopyVolumeLocalization;
        this.backgroundSImg = null;
        this.currentBackgroundSrcImageSortOrder = null;
        this.currentBackgroundSrcImageIndex = 0;
        this.backgroundSrcImageGeometry = null;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.typeOfPanelEventContext = eventContext;
        this.ourFrameSelectionChangeListener = new OurFrameSelectionChangeListener(eventContext);
        this.ourFrameSortOrderChangeListener = new OurFrameSortOrderChangeListener(eventContext);
        this.backgroundImageEventContext = eventContext2;
        this.ourBackgroundSourceImageSelectionChangeListener = new OurBackgroundSourceImageSelectionChangeListener(eventContext2);
        this.cachedBackgroundImage = null;
        this.cacheOfImagesForSpectra = null;
        this.cacheForBounds = null;
    }

    public void paintComponent(Graphics graphics) {
        Object object;
        int n = this.currentSrcSpectraSortOrder == null ? this.currentSrcSpectrumIndex : this.currentSrcSpectraSortOrder[this.currentSrcSpectrumIndex];
        this.samples = this.srcSpectra[this.currentSrcSpectrumIndex];
        Cursor cursor = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        Rectangle rectangle = this.getBounds();
        if (this.cacheForBounds != null && rectangle.width == this.cacheForBounds.width && rectangle.height == this.cacheForBounds.height && this.cacheOfImagesForSpectra != null) {
            object = (BufferedImage)this.cacheOfImagesForSpectra.get(this.samples);
            if (object != null) {
                graphics.drawImage((Image)object, 0, 0, this);
                this.setCursor(cursor);
                return;
            }
        } else {
            this.cacheOfImagesForSpectra = null;
        }
        if (this.cacheOfImagesForSpectra == null) {
            this.cacheOfImagesForSpectra = new HashMap();
            this.cacheForBounds = rectangle;
        }
        object = null;
        Rectangle rectangle2 = null;
        if (this.cachedBackgroundImage == null && this.spectroscopyGeometry != null && this.backgroundSrcImageGeometry != null) {
            int n2 = this.backgroundSrcImageGeometry.findClosestSliceInSamePlane(this.spectroscopyGeometry.getGeometryOfSlices()[n]);
            this.cachedBackgroundImage = this.backgroundSImg.getBufferedImage(n2);
            if (this.cachedBackgroundImage.getColorModel().getNumComponents() == 1) {
                double d;
                double d2;
                double d3;
                double d4;
                boolean bl = this.backgroundSImg.isSigned();
                boolean bl2 = this.backgroundSImg.isInverted();
                boolean bl3 = this.backgroundSImg.isPadded();
                int n3 = bl3 ? this.backgroundSImg.getPadValue() : 0;
                int n4 = bl3 ? this.backgroundSImg.getPadRangeLimit() : 0;
                ModalityTransform modalityTransform = this.backgroundSImg.getModalityTransform();
                if (modalityTransform != null) {
                    d4 = modalityTransform.getRescaleSlope(n2);
                    d3 = modalityTransform.getRescaleIntercept(n2);
                } else {
                    d4 = 1.0;
                    d3 = 0.0;
                }
                VOITransform vOITransform = this.backgroundSImg.getVOITransform();
                if (vOITransform != null && vOITransform.getNumberOfTransforms(n2) > 0) {
                    d2 = vOITransform.getWidth(n2, 0);
                    d = vOITransform.getCenter(n2, 0);
                } else {
                    double d5 = (double)this.backgroundSImg.getMinimum() * d4 + d3;
                    double d6 = (double)this.backgroundSImg.getMaximum() * d4 + d3;
                    d2 = d6 - d5;
                    d = (d6 + d5) / 2.0;
                }
                this.cachedBackgroundImage = SingleImagePanel.applyWindowCenterAndWidthLinear(this.cachedBackgroundImage, d, d2, bl, bl2, d4, d3, bl3, n3, n4);
            }
            GeometryOfSlice geometryOfSlice = this.spectroscopyGeometry.getGeometryOfSlices()[n];
            Point3d point3d = geometryOfSlice.getTLHC();
            Vector3d vector3d = geometryOfSlice.getRow();
            Vector3d vector3d2 = geometryOfSlice.getColumn();
            Point3d[] point3dArray = LocalizerPoster.getCornersOfSourceRectangleInSourceSpace(this.backgroundSrcImageGeometry.getGeometryOfSlices()[n2]);
            point3dArray = LocalizerPoster.transformPointsFromSourceSpaceIntoSpecifiedSpace(point3dArray, point3d, vector3d, vector3d2);
            Point3d[] point3dArray2 = LocalizerPoster.getCornersOfSourceRectangleInSourceSpace(geometryOfSlice);
            point3dArray2 = LocalizerPoster.transformPointsFromSourceSpaceIntoSpecifiedSpace(point3dArray2, point3d, vector3d, vector3d2);
            Point3d[] point3dArray3 = LocalizerPoster.getIntersectionOfRectanglesInXYPlane(point3dArray, point3dArray2);
            object = LocalizerPoster.getBoundsOfContainedRectangle(point3dArray3, point3dArray2, this.getBounds());
            rectangle2 = LocalizerPoster.getBoundsOfContainedRectangle(point3dArray3, point3dArray, new Rectangle(this.cachedBackgroundImage.getWidth(), this.cachedBackgroundImage.getHeight()));
        }
        this.actuallyPaintComponent(graphics, this.cachedBackgroundImage, (Rectangle)object, rectangle2);
        this.cacheOfImagesForSpectra.put(this.samples, this.imageOfRenderedPlot);
        this.setCursor(cursor);
    }

    public void deconstruct() {
        if (this.ourFrameSelectionChangeListener != null) {
            ApplicationEventDispatcher.getApplicationEventDispatcher().removeListener(this.ourFrameSelectionChangeListener);
            this.ourFrameSelectionChangeListener = null;
        }
        if (this.ourFrameSortOrderChangeListener != null) {
            ApplicationEventDispatcher.getApplicationEventDispatcher().removeListener(this.ourFrameSortOrderChangeListener);
            this.ourFrameSortOrderChangeListener = null;
        }
        if (this.ourBackgroundSourceImageSelectionChangeListener != null) {
            ApplicationEventDispatcher.getApplicationEventDispatcher().removeListener(this.ourBackgroundSourceImageSelectionChangeListener);
            this.ourBackgroundSourceImageSelectionChangeListener = null;
        }
    }

    public static void deconstructAllSpectraPanelsInContainer(Container container) {
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            if (!(component instanceof SpectraPanel)) continue;
            ((SpectraPanel)component).deconstruct();
        }
    }

    protected void finalize() throws Throwable {
        this.deconstruct();
        super.finalize();
    }

    static /* synthetic */ int[] access$102(SpectraPanel spectraPanel, int[] nArray) {
        spectraPanel.currentSrcSpectraSortOrder = nArray;
        return nArray;
    }

    class OurBackgroundSourceImageSelectionChangeListener
    extends SelfRegisteringListener {
        public OurBackgroundSourceImageSelectionChangeListener(EventContext eventContext) {
            super("com.pixelmed.display.event.SourceImageSelectionChangeEvent", eventContext);
        }

        public void changed(Event event) {
            SourceImageSelectionChangeEvent sourceImageSelectionChangeEvent = (SourceImageSelectionChangeEvent)event;
            SpectraPanel.this.backgroundSImg = sourceImageSelectionChangeEvent.getSourceImage();
            SpectraPanel.this.currentBackgroundSrcImageSortOrder = sourceImageSelectionChangeEvent.getSortOrder();
            SpectraPanel.this.currentBackgroundSrcImageIndex = sourceImageSelectionChangeEvent.getIndex();
            SpectraPanel.this.backgroundSrcImageGeometry = sourceImageSelectionChangeEvent.getGeometryOfVolume();
            SpectraPanel.this.cachedBackgroundImage = null;
            SpectraPanel.this.cacheOfImagesForSpectra = null;
            SpectraPanel.this.cacheForBounds = null;
            SpectraPanel.this.repaint();
        }
    }

    class OurFrameSortOrderChangeListener
    extends SelfRegisteringListener {
        public OurFrameSortOrderChangeListener(EventContext eventContext) {
            super("com.pixelmed.display.event.FrameSortOrderChangeEvent", eventContext);
        }

        public void changed(Event event) {
            FrameSortOrderChangeEvent frameSortOrderChangeEvent = (FrameSortOrderChangeEvent)event;
            int[] nArray = frameSortOrderChangeEvent.getSortOrder();
            int n = frameSortOrderChangeEvent.getIndex();
            if (SpectraPanel.this.currentSrcSpectrumIndex != n || SpectraPanel.this.currentSrcSpectraSortOrder != nArray || !Arrays.equals(SpectraPanel.this.currentSrcSpectraSortOrder, nArray)) {
                System.err.println("SpectraPanel.OurFrameSortOrderChangeListener.changed(): new values");
                SpectraPanel.this.currentSrcSpectrumIndex = n;
                SpectraPanel.access$102(SpectraPanel.this, nArray);
                SpectraPanel.this.cachedBackgroundImage = null;
                SpectraPanel.this.repaint();
            } else {
                System.err.println("SpectraPanel.OurFrameSortOrderChangeListener.changed(): same values");
            }
        }
    }

    class OurFrameSelectionChangeListener
    extends SelfRegisteringListener {
        public OurFrameSelectionChangeListener(EventContext eventContext) {
            super("com.pixelmed.display.event.FrameSelectionChangeEvent", eventContext);
        }

        public void changed(Event event) {
            FrameSelectionChangeEvent frameSelectionChangeEvent = (FrameSelectionChangeEvent)event;
            int n = frameSelectionChangeEvent.getIndex();
            if (SpectraPanel.this.currentSrcSpectrumIndex != n) {
                SpectraPanel.this.currentSrcSpectrumIndex = n;
                SpectraPanel.this.cachedBackgroundImage = null;
                SpectraPanel.this.repaint();
            }
        }
    }
}

