/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.network;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.DicomOutputStream;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.StringAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.network.AReleaseException;
import com.pixelmed.network.Association;
import com.pixelmed.network.AssociationFactory;
import com.pixelmed.network.AssociationInitiator;
import com.pixelmed.network.CGetRequestCommandMessage;
import com.pixelmed.network.CGetResponseCommandMessage;
import com.pixelmed.network.CStoreRequestCommandMessage;
import com.pixelmed.network.CStoreResponseCommandMessage;
import com.pixelmed.network.CompositeResponseHandler;
import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.IdentifierHandler;
import com.pixelmed.network.IdentifierMessage;
import com.pixelmed.network.MessageServiceElementCommand;
import com.pixelmed.network.PDataPDU;
import com.pixelmed.network.PresentationContextListFactory;
import com.pixelmed.network.PresentationDataValue;
import com.pixelmed.network.ReceivedDataHandler;
import com.pixelmed.network.ReceivedObjectHandler;
import com.pixelmed.network.SCUSCPRoleSelection;
import com.pixelmed.utils.ByteArray;
import com.pixelmed.utils.CopyStream;
import com.pixelmed.utils.FileUtilities;
import com.pixelmed.utils.HexDump;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Set;

public class GetSOPClassSCU
extends SOPClass {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/network/GetSOPClassSCU.java,v 1.7 2006/05/17 16:51:57 dclunie Exp $";
    private int debugLevel;

    public GetSOPClassSCU(String string, int n, String string2, String string3, String string4, AttributeList attributeList, IdentifierHandler identifierHandler, File file, ReceivedObjectHandler receivedObjectHandler, Set set, boolean bl, boolean bl2, boolean bl3, int n2) throws DicomNetworkException, DicomException, IOException {
        this.debugLevel = n2;
        if (n2 > 0) {
            System.err.println("GetSOPClassSCU(): request identifier");
        }
        if (n2 > 0) {
            System.err.print(attributeList);
        }
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string4);
        hashSet.addAll(set);
        LinkedList linkedList = PresentationContextListFactory.createNewPresentationContextList(hashSet, 0, bl, bl2, bl3);
        LinkedList<SCUSCPRoleSelection> linkedList2 = new LinkedList<SCUSCPRoleSelection>();
        for (String string5 : set) {
            linkedList2.add(new SCUSCPRoleSelection(string5, false, true));
        }
        AssociationInitiator associationInitiator = AssociationFactory.createNewAssociation(string, n, string2, string3, linkedList, linkedList2, false, n2);
        if (n2 > 0) {
            System.err.println(associationInitiator);
        }
        byte by = associationInitiator.getSuitablePresentationContextID(string4);
        if (n2 > 0) {
            System.err.println("Using context ID " + by);
        }
        byte[] byArray = new CGetRequestCommandMessage(string4).getBytes();
        byte[] byArray2 = new IdentifierMessage(attributeList, associationInitiator.getTransferSyntaxForPresentationContextID(by)).getBytes();
        associationInitiator.setReceivedDataHandler(new CGetResponseOrCStoreRequestHandler(identifierHandler, file, receivedObjectHandler, n2));
        associationInitiator.send(by, byArray, null);
        associationInitiator.send(by, null, byArray2);
        if (n2 > 0) {
            System.err.println("GetSOPClassSCU: waiting for PDUs");
        }
        try {
            associationInitiator.waitForPDataPDUsUntilHandlerReportsDone();
            if (n2 > 0) {
                System.err.println("GetSOPClassSCU: got PDU, now releasing association");
            }
            associationInitiator.release();
        }
        catch (AReleaseException aReleaseException) {
            // empty catch block
        }
    }

    private GetSOPClassSCU() {
    }

    private final void doGet(String[] stringArray) {
        try {
            String string = stringArray[4];
            File file = null;
            if (string != null && string.length() > 0) {
                file = new File(string);
            }
            AttributeList attributeList = new AttributeList();
            AttributeTag attributeTag = TagFromName.QueryRetrieveLevel;
            StringAttribute stringAttribute = new CodeStringAttribute(attributeTag);
            ((Attribute)stringAttribute).addValue(stringArray[5]);
            attributeList.put(attributeTag, stringAttribute);
            attributeTag = TagFromName.StudyInstanceUID;
            stringAttribute = new UniqueIdentifierAttribute(attributeTag);
            ((Attribute)stringAttribute).addValue(stringArray[6]);
            attributeList.put(attributeTag, stringAttribute);
            if (stringArray.length > 7) {
                attributeTag = TagFromName.SeriesInstanceUID;
                stringAttribute = new UniqueIdentifierAttribute(attributeTag);
                ((Attribute)stringAttribute).addValue(stringArray[7]);
                attributeList.put(attributeTag, stringAttribute);
            }
            if (stringArray.length > 8) {
                attributeTag = TagFromName.SOPInstanceUID;
                stringAttribute = new UniqueIdentifierAttribute(attributeTag);
                ((Attribute)stringAttribute).addValue(stringArray[8]);
                attributeList.put(attributeTag, stringAttribute);
            }
            new GetSOPClassSCU(stringArray[0], Integer.parseInt(stringArray[1]), stringArray[2], stringArray[3], "1.2.840.10008.5.1.4.1.2.2.3", attributeList, new IdentifierHandler(), file, new OurReceivedObjectHandler(), SOPClass.getSetOfStorageSOPClasses(), true, false, false, 0);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            System.exit(0);
        }
    }

    public static void main(String[] stringArray) {
        new GetSOPClassSCU().doGet(stringArray);
    }

    private class OurReceivedObjectHandler
    extends ReceivedObjectHandler {
        private OurReceivedObjectHandler() {
        }

        public void sendReceivedObjectIndication(String string, String string2, String string3) throws DicomNetworkException, DicomException, IOException {
            System.err.println("GetSOPClassSCU.OurReceivedObjectHandler.sendReceivedObjectIndication() fileName: " + string + " from " + string3 + " in " + string2);
        }
    }

    private class CGetResponseOrCStoreRequestHandler
    extends ReceivedDataHandler {
        private int command;
        private byte[] commandReceived;
        private byte[] dataReceived;
        protected boolean success;
        private AttributeList commandList;
        private AttributeList dataList;
        private OutputStream out;
        private CStoreRequestCommandMessage csrq;
        private CGetResponseCommandMessage cgrsp;
        private byte presentationContextIDUsed;
        private ReceivedObjectHandler receivedObjectHandler;
        private IdentifierHandler identifierHandler;
        private File receivedFile;
        private File temporaryReceivedFile;
        private File savedImagesFolder;

        CGetResponseOrCStoreRequestHandler(IdentifierHandler identifierHandler, File file, ReceivedObjectHandler receivedObjectHandler, int n) {
            super(n);
            this.savedImagesFolder = file;
            this.identifierHandler = identifierHandler;
            this.receivedObjectHandler = receivedObjectHandler;
        }

        public void sendPDataIndication(PDataPDU pDataPDU, Association association) throws DicomNetworkException, DicomException, IOException {
            if (this.debugLevel > 0) {
                System.err.println("GetSOPClassSCU.CGetResponseOrCStoreRequestHandler.sendPDataIndication(): sendPDataIndication()");
            }
            if (this.debugLevel > 2) {
                super.dumpPDVList(pDataPDU.getPDVList());
            }
            if (this.debugLevel > 2) {
                System.err.println("GetSOPClassSCU.CGetResponseOrCStoreRequestHandler.sendPDataIndication(): finished dumping PDV list from PDU");
            }
            LinkedList linkedList = pDataPDU.getPDVList();
            ListIterator listIterator = linkedList.listIterator();
            while (listIterator.hasNext()) {
                Object object;
                PresentationDataValue presentationDataValue = (PresentationDataValue)listIterator.next();
                this.presentationContextIDUsed = presentationDataValue.getPresentationContextID();
                if (presentationDataValue.isCommand()) {
                    this.receivedFile = null;
                    this.commandReceived = ByteArray.concatenate(this.commandReceived, presentationDataValue.getValue());
                    if (!presentationDataValue.isLastFragment()) continue;
                    if (this.debugLevel > 0) {
                        System.err.println("GetSOPClassSCU.CGetResponseOrCStoreRequestHandler.sendPDataIndication(): last fragment of data seen");
                    }
                    if (this.debugLevel > 0) {
                        System.err.println(HexDump.dump(this.commandReceived));
                    }
                    this.commandList = new AttributeList();
                    this.commandList.read(new DicomInputStream(new ByteArrayInputStream(this.commandReceived), "1.2.840.10008.1.2", false));
                    this.commandReceived = null;
                    if (this.debugLevel > 0) {
                        System.err.print(this.commandList);
                    }
                    this.command = Attribute.getSingleIntegerValueOrDefault(this.commandList, TagFromName.CommandField, 65535);
                    if (this.command == 1) {
                        if (this.debugLevel > 0) {
                            System.err.println("GetSOPClassSCU.CGetResponseOrCStoreRequestHandler.sendPDataIndication(): C-STORE-RQ");
                        }
                        this.csrq = new CStoreRequestCommandMessage(this.commandList);
                    } else if (this.command == 32784) {
                        if (this.debugLevel > 0) {
                            System.err.println("GetSOPClassSCU.CGetResponseOrCStoreRequestHandler.sendPDataIndication(): C-STORE-RQ");
                        }
                        this.cgrsp = new CGetResponseCommandMessage(this.commandList);
                        this.evaluateStatusAndSetSuccess(this.commandList);
                    } else {
                        throw new DicomNetworkException("Unexpected command 0x" + Integer.toHexString(this.command) + " " + MessageServiceElementCommand.toString(this.command));
                    }
                    if (this.debugLevel <= 0 || !listIterator.hasNext()) continue;
                    System.err.println("GetSOPClassSCU.CGetResponseOrCStoreRequestHandler.sendPDataIndication: Data after command in same PDU");
                    continue;
                }
                if (this.command == 1) {
                    if (this.debugLevel > 0) {
                        System.err.println("GetSOPClassSCU.CGetResponseOrCStoreRequestHandler.sendPDataIndication(): Storing data fragment");
                    }
                    if (this.out == null && this.savedImagesFolder != null) {
                        object = new FileMetaInformation(this.csrq.getAffectedSOPClassUID(), this.csrq.getAffectedSOPInstanceUID(), association.getTransferSyntaxForPresentationContextID(this.presentationContextIDUsed), association.getCallingAETitle());
                        this.receivedFile = new File(this.savedImagesFolder, this.csrq.getAffectedSOPInstanceUID());
                        this.temporaryReceivedFile = new File(this.savedImagesFolder, FileUtilities.makeTemporaryFileName());
                        if (this.debugLevel > 0) {
                            System.err.println("GetSOPClassSCU.CGetResponseOrCStoreRequestHandler.sendPDataIndication(): Receiving and storing " + this.receivedFile);
                        }
                        if (this.debugLevel > 0) {
                            System.err.println("GetSOPClassSCU.CGetResponseOrCStoreRequestHandler.sendPDataIndication(): Receiving and storing into temporary " + this.temporaryReceivedFile);
                        }
                        this.out = new BufferedOutputStream(new FileOutputStream(this.temporaryReceivedFile));
                        DicomOutputStream dicomOutputStream = new DicomOutputStream(this.out, "1.2.840.10008.1.2.1", null);
                        ((FileMetaInformation)object).getAttributeList().write(dicomOutputStream);
                        dicomOutputStream.flush();
                    }
                    if (this.out != null) {
                        this.out.write(presentationDataValue.getValue());
                    }
                    if (!presentationDataValue.isLastFragment()) continue;
                    if (this.debugLevel > 0) {
                        System.err.println("GetSOPClassSCU.CGetResponseOrCStoreRequestHandler.sendPDataIndication(): Finished storing data in C_STORE_RQ");
                    }
                    if (this.out != null) {
                        this.out.close();
                        if (this.receivedFile.exists()) {
                            if (this.debugLevel > 0) {
                                System.err.println("GetSOPClassSCU.CGetResponseOrCStoreRequestHandler.sendPDataIndication(): Deleting pre-existing file for same SOPInstanceUID");
                            }
                            this.receivedFile.delete();
                        }
                        if (!this.temporaryReceivedFile.renameTo(this.receivedFile)) {
                            if (this.debugLevel > 0) {
                                System.err.println("GetSOPClassSCU.CGetResponseOrCStoreRequestHandler.sendPDataIndication(): Could not move temporary file into place ... copying instead");
                            }
                            CopyStream.copy(this.temporaryReceivedFile, this.receivedFile);
                            this.temporaryReceivedFile.delete();
                        }
                        this.out = null;
                    }
                    if (this.debugLevel > 0) {
                        System.err.println("GetSOPClassSCU.CGetResponseOrCStoreRequestHandler.sendPDataIndication(): Send successful C-STORE-RSP");
                    }
                    object = new CStoreResponseCommandMessage(this.csrq.getAffectedSOPClassUID(), this.csrq.getAffectedSOPInstanceUID(), this.csrq.getMessageID(), 0);
                    byte by = association.getSuitablePresentationContextID(((CStoreResponseCommandMessage)object).getAffectedSOPClassUID());
                    association.send(by, ((CStoreResponseCommandMessage)object).getBytes(), null);
                    if (this.debugLevel > 0) {
                        System.err.println("GetSOPClassSCU.CGetResponseOrCStoreRequestHandler.sendPDataIndication(): Notify receivedObjectHandler");
                    }
                    if (this.receivedFile == null || !this.receivedFile.exists() || this.receivedObjectHandler == null || (object = this.receivedFile.getName()) == null) continue;
                    String string = association.getTransferSyntaxForPresentationContextID(this.presentationContextIDUsed);
                    String string2 = association.getCalledAETitle();
                    this.receivedObjectHandler.sendReceivedObjectIndication((String)object, string, string2);
                    continue;
                }
                if (this.command == 32784) {
                    this.dataReceived = ByteArray.concatenate(this.dataReceived, presentationDataValue.getValue());
                    if (!presentationDataValue.isLastFragment()) continue;
                    if (this.debugLevel > 0) {
                        System.err.println("GetSOPClassSCU.CGetResponseOrCStoreRequestHandler.sendPDataIndication(): last fragment of data in C_GET_RSP seen");
                    }
                    object = CompositeResponseHandler.getAttributeListFromCommandOrData(this.dataReceived, association.getTransferSyntaxForPresentationContextID(presentationDataValue.getPresentationContextID()), this.debugLevel);
                    this.makeUseOfDataSet((AttributeList)object);
                    this.dataReceived = null;
                    continue;
                }
                throw new DicomNetworkException("Unexpected command 0x" + Integer.toHexString(this.command) + " " + MessageServiceElementCommand.toString(this.command));
            }
        }

        protected void evaluateStatusAndSetSuccess(AttributeList attributeList) {
            if (this.debugLevel > 0) {
                System.err.println("GetSOPClassSCU.CGetResponseHandler.evaluateStatusAndSetSuccess:");
            }
            if (this.debugLevel > 0) {
                System.err.println(attributeList);
            }
            int n = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.Status, 65535);
            if (this.debugLevel > 0) {
                System.err.println("GetSOPClassSCU.CGetResponseHandler.evaluateStatusAndSetSuccess: status = 0x" + Integer.toHexString(n));
            }
            boolean bl = this.success = n == 0;
            if (n != 65280 && n != 65281) {
                if (this.debugLevel > 0) {
                    System.err.println("GetSOPClassSCU.CGetResponseHandler.evaluateStatusAndSetSuccess: status no longer pending, so stop");
                }
                this.setDone(true);
            }
        }

        protected void makeUseOfDataSet(AttributeList attributeList) {
            if (this.debugLevel > 0) {
                System.err.println("GetSOPClassSCU.CGetResponseOrCStoreRequestHandler.makeUseOfDataSet:");
            }
            if (this.debugLevel > 0) {
                System.err.print(attributeList);
            }
            try {
                if (this.identifierHandler != null) {
                    this.identifierHandler.doSomethingWithIdentifier(attributeList);
                }
            }
            catch (DicomException dicomException) {
                dicomException.printStackTrace(System.err);
            }
        }
    }
}

