/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.query;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.InformationEntity;
import com.pixelmed.dicom.StringAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.TextAttribute;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class FilterPanel
extends JPanel {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/query/FilterPanel.java,v 1.9 2007/01/17 23:13:10 dclunie Exp $";
    private GridBagLayout layout = new GridBagLayout();
    private AttributeList filterList;
    private static InformationEntity[] iterateByInformationEntity = new InformationEntity[]{InformationEntity.PATIENT, InformationEntity.STUDY, InformationEntity.PROCEDURESTEP, InformationEntity.SERIES, InformationEntity.CONCATENATION, InformationEntity.INSTANCE, InformationEntity.FRAME};

    private void addInformationEntityLabelToPanel(int n, InformationEntity informationEntity, GridBagConstraints gridBagConstraints) {
        JLabel jLabel = new JLabel(informationEntity.toString(), new ImageIcon(new BufferedImage(1, 50, 10)), 2);
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridx = 1;
        this.layout.setConstraints(jLabel, gridBagConstraints);
        this.add(jLabel);
    }

    private void addAttributeToPanel(int n, String string, GridBagConstraints gridBagConstraints) {
        FilterPanel filterPanel = this;
        DicomDictionary dicomDictionary = filterPanel.filterList.getDictionary();
        AttributeTag attributeTag = dicomDictionary.getTagFromName(string);
        Attribute attribute = this.filterList.get(attributeTag);
        String string2 = attribute.getSingleStringValueOrEmptyString();
        JLabel jLabel = new JLabel(string);
        TextFieldForAttribute textFieldForAttribute = new TextFieldForAttribute(attribute);
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridx = 1;
        this.layout.setConstraints(jLabel, gridBagConstraints);
        this.add(jLabel);
        gridBagConstraints.gridx = 2;
        this.layout.setConstraints(textFieldForAttribute, gridBagConstraints);
        this.add(textFieldForAttribute);
    }

    private void addAttributesToPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        FilterPanel filterPanel = this;
        DicomDictionary dicomDictionary = filterPanel.filterList.getDictionary();
        int n = 0;
        for (int i = 0; i < iterateByInformationEntity.length; ++i) {
            InformationEntity informationEntity = iterateByInformationEntity[i];
            TreeSet<String> treeSet = new TreeSet<String>();
            for (Attribute attribute : this.filterList.values()) {
                AttributeTag attributeTag;
                if (attribute == null || !(attribute instanceof StringAttribute) && !(attribute instanceof TextAttribute) || (attributeTag = attribute.getTag()).equals(TagFromName.SpecificCharacterSet) || dicomDictionary.getInformationEntityFromTag(attributeTag) != informationEntity) continue;
                treeSet.add(dicomDictionary.getNameFromTag(attributeTag));
            }
            Iterator<Object> iterator = treeSet.iterator();
            if (iterator.hasNext()) {
                this.addInformationEntityLabelToPanel(n++, informationEntity, gridBagConstraints);
            }
            while (iterator.hasNext()) {
                this.addAttributeToPanel(n++, (String)iterator.next(), gridBagConstraints);
            }
        }
    }

    public FilterPanel(AttributeList attributeList) {
        this.setLayout(this.layout);
        this.filterList = attributeList;
        this.addAttributesToPanel();
    }

    public AttributeList getFilterList() {
        return this.filterList;
    }

    private final class TextFieldForAttribute
    extends JTextField {
        private final Attribute attribute;

        private final void replaceAttributeValue(String string) {
            try {
                this.attribute.removeValues();
                if (string != null && string.length() > 0) {
                    this.attribute.addValue(string);
                }
            }
            catch (DicomException dicomException) {
                // empty catch block
            }
        }

        public TextFieldForAttribute(Attribute attribute) {
            super(10);
            this.attribute = attribute;
            this.setText(attribute.getSingleStringValueOrEmptyString());
            this.getDocument().addDocumentListener(new DocumentListener(){

                private String getText(DocumentEvent documentEvent) {
                    Document document;
                    String string = null;
                    if (documentEvent != null && (document = documentEvent.getDocument()) != null) {
                        try {
                            string = document.getText(0, document.getLength());
                        }
                        catch (BadLocationException badLocationException) {
                            badLocationException.printStackTrace(System.err);
                        }
                    }
                    return string;
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    TextFieldForAttribute.this.replaceAttributeValue(this.getText(documentEvent));
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    TextFieldForAttribute.this.replaceAttributeValue(this.getText(documentEvent));
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    TextFieldForAttribute.this.replaceAttributeValue(this.getText(documentEvent));
                }
            });
        }
    }
}

