/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.database;

import com.pixelmed.database.DatabaseInformationModel;
import com.pixelmed.database.DicomDatabaseQueryResponseGeneratorFactory;
import com.pixelmed.database.DicomDatabaseRetrieveResponseGeneratorFactory;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.InformationEntity;
import com.pixelmed.dicom.LossyImageCompression;
import com.pixelmed.dicom.PersonNameAttribute;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.ValueRepresentation;
import com.pixelmed.query.QueryResponseGeneratorFactory;
import com.pixelmed.query.RetrieveResponseGeneratorFactory;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TreeSet;

public abstract class DicomDatabaseInformationModel
extends DatabaseInformationModel {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/database/DicomDatabaseInformationModel.java,v 1.16 2007/07/04 18:13:58 dclunie Exp $";
    private static final long SQL_INTEGER_MINIMUM = Integer.MIN_VALUE;
    private static final long SQL_INTEGER_MAXIMUM = Integer.MAX_VALUE;
    static final String derivedStudyDateTimeColumnName = "PM_StudyDateTime";
    static final String derivedSeriesDateTimeColumnName = "PM_SeriesDateTime";
    static final String derivedContentDateTimeColumnName = "PM_ContentDateTime";
    static final String derivedAcquisitionDateTimeColumnName = "PM_AcquisitionDateTime";
    static final String derivedLossyImageCompressionColumnName = "PM_LossyImageCompression";

    public DicomDatabaseInformationModel(String string, InformationEntity informationEntity, DicomDictionary dicomDictionary) throws DicomException {
        super(string, informationEntity, dicomDictionary);
    }

    public DicomDatabaseInformationModel(String string, String string2, InformationEntity informationEntity, DicomDictionary dicomDictionary) throws DicomException {
        super(string, string2, informationEntity, dicomDictionary);
    }

    public String getNametoDescribeThisInstanceOfInformationEntity(InformationEntity informationEntity, Map map) {
        String string;
        String string2 = informationEntity.toString();
        if (informationEntity == InformationEntity.INSTANCE && (string = (String)map.get("SOPCLASSUID")) != null) {
            if (SOPClass.isImageStorage(string)) {
                string2 = "Image";
            } else if (SOPClass.isStructuredReport(string)) {
                string2 = "SR Document";
            } else if (SOPClass.isWaveform(string)) {
                string2 = "Waveform";
            } else if (SOPClass.isSpectroscopy(string)) {
                string2 = "Spectra";
            } else if (SOPClass.isRawData(string)) {
                string2 = "Raw Data";
            }
        }
        return string2;
    }

    protected void extendInsertStatementStringWithPersonNameSearchColumnsForSelectedInformationEntity(StringBuffer stringBuffer, AttributeList attributeList, InformationEntity informationEntity) throws DicomException {
        TreeSet<String> treeSet = new TreeSet<String>();
        String string = informationEntity.toString().toUpperCase();
        for (Attribute attribute : attributeList.values()) {
            AttributeTag attributeTag = attribute.getTag();
            if (informationEntity != this.dictionary.getInformationEntityFromTag(attributeTag)) continue;
            String string2 = this.getDatabaseColumnNameFromDicomTag(attributeTag);
            byte[] byArray = attribute.getVR();
            if (string2 == null || byArray == null || !ValueRepresentation.isPersonNameVR(byArray)) continue;
            String string3 = "PM_" + string2 + "_CANONICAL";
            if (this.isAttributeUsedInTable(string, string3) && !treeSet.contains(string3)) {
                stringBuffer.append(",");
                stringBuffer.append(string3);
                treeSet.add(string3);
            }
            if (!this.isAttributeUsedInTable(string, string3 = "PM_" + string2 + "_PHONETICCANONICAL") || treeSet.contains(string3)) continue;
            stringBuffer.append(",");
            stringBuffer.append(string3);
            treeSet.add(string3);
        }
    }

    protected void extendInsertStatementStringWithPersonNameSearchValuesForSelectedInformationEntity(StringBuffer stringBuffer, AttributeList attributeList, InformationEntity informationEntity) throws DicomException {
        TreeSet<String> treeSet = new TreeSet<String>();
        String string = informationEntity.toString().toUpperCase();
        for (Attribute attribute : attributeList.values()) {
            AttributeTag attributeTag = attribute.getTag();
            if (informationEntity != this.dictionary.getInformationEntityFromTag(attributeTag)) continue;
            String string2 = this.getDatabaseColumnNameFromDicomTag(attributeTag);
            byte[] byArray = attribute.getVR();
            if (string2 == null || byArray == null || !ValueRepresentation.isPersonNameVR(byArray)) continue;
            String string3 = attribute.getSingleStringValueOrNull();
            String string4 = string3 == null ? null : PersonNameAttribute.getCanonicalForm(string3);
            String string5 = string4 == null ? null : PersonNameAttribute.getPhoneticName(string4);
            String string6 = "PM_" + string2 + "_CANONICAL";
            if (this.isAttributeUsedInTable(string, string6) && !treeSet.contains(string6)) {
                stringBuffer.append(",");
                stringBuffer.append(DicomDatabaseInformationModel.getQuotedValueOrNULL(string4));
                treeSet.add(string6);
            }
            if (!this.isAttributeUsedInTable(string, string6 = "PM_" + string2 + "_PHONETICCANONICAL") || treeSet.contains(string6)) continue;
            stringBuffer.append(",");
            stringBuffer.append(DicomDatabaseInformationModel.getQuotedValueOrNULL(string5));
            treeSet.add(string6);
        }
    }

    protected void extendInsertStatementStringWithAttributeNamesForSelectedInformationEntity(StringBuffer stringBuffer, AttributeList attributeList, InformationEntity informationEntity) throws DicomException {
        String string;
        Object object;
        Object object2;
        Object object32;
        TreeSet<Object> treeSet = new TreeSet<Object>();
        if (informationEntity == InformationEntity.INSTANCE) {
            stringBuffer.append(",");
            stringBuffer.append("LocalFileName");
            treeSet.add("LocalFileName");
        }
        String string2 = informationEntity.toString().toUpperCase();
        for (Object object32 : attributeList.values()) {
            object2 = ((Attribute)object32).getTag();
            if (informationEntity != this.dictionary.getInformationEntityFromTag((AttributeTag)object2)) continue;
            object = this.getDatabaseColumnNameFromDicomTag((AttributeTag)object2);
            string = DicomDatabaseInformationModel.getSQLTypeFromDicomValueRepresentation(((Attribute)object32).getVR());
            if (object == null || string == null || !this.isAttributeUsedInTable(string2, (String)object) || treeSet.contains(object)) continue;
            stringBuffer.append(",");
            stringBuffer.append((String)object);
            treeSet.add(object);
        }
        if (informationEntity == InformationEntity.INSTANCE && (object2 = attributeList.get((AttributeTag)(object32 = TagFromName.InstanceNumber))) != null) {
            object = this.getDatabaseColumnNameFromDicomTag((AttributeTag)object32);
            string = DicomDatabaseInformationModel.getSQLTypeFromDicomValueRepresentation(((Attribute)object2).getVR());
            if (object != null && string != null && this.isAttributeUsedInTable(string2, (String)object) && !treeSet.contains(object)) {
                stringBuffer.append(",");
                stringBuffer.append((String)object);
                treeSet.add(object);
            }
        }
        if (informationEntity == InformationEntity.INSTANCE && (object32 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.SOPClassUID)) != null && SOPClass.isImageStorage((String)object32) && (object = SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem((SequenceAttribute)(object2 = (SequenceAttribute)SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(attributeList, TagFromName.SharedFunctionalGroupsSequence, TagFromName.PlaneOrientationSequence)), TagFromName.ImageOrientationPatient)) != null && ((Attribute)object).getVM() == 6) {
            string = this.getDatabaseColumnNameFromDicomTag(TagFromName.ImageOrientationPatient);
            String string3 = DicomDatabaseInformationModel.getSQLTypeFromDicomValueRepresentation(((Attribute)object).getVR());
            if (string != null && string3 != null && this.isAttributeUsedInTable(string2, string) && !treeSet.contains(string)) {
                stringBuffer.append(",");
                stringBuffer.append(string);
                treeSet.add(string);
            }
        }
    }

    protected void extendInsertStatementStringWithAttributeValuesForSelectedInformationEntity(StringBuffer stringBuffer, AttributeList attributeList, InformationEntity informationEntity, String string) throws DicomException {
        String string2;
        Object object;
        Object object2;
        Object object32;
        TreeSet<Object> treeSet = new TreeSet<Object>();
        if (informationEntity == InformationEntity.INSTANCE) {
            stringBuffer.append(",'");
            stringBuffer.append(string);
            stringBuffer.append("'");
            treeSet.add("LocalFileName");
        }
        String string3 = informationEntity.toString().toUpperCase();
        for (Object object32 : attributeList.values()) {
            object2 = ((Attribute)object32).getTag();
            if (informationEntity != this.dictionary.getInformationEntityFromTag((AttributeTag)object2)) continue;
            object = this.getDatabaseColumnNameFromDicomTag((AttributeTag)object2);
            string2 = DicomDatabaseInformationModel.getSQLTypeFromDicomValueRepresentation(((Attribute)object32).getVR());
            if (object == null || string2 == null || !this.isAttributeUsedInTable(string3, (String)object) || treeSet.contains(object)) continue;
            stringBuffer.append(",");
            stringBuffer.append(DicomDatabaseInformationModel.getQuotedEscapedSingleStringValueOrNull((Attribute)object32));
            treeSet.add(object);
        }
        if (informationEntity == InformationEntity.INSTANCE && (object2 = attributeList.get((AttributeTag)(object32 = TagFromName.InstanceNumber))) != null) {
            object = this.getDatabaseColumnNameFromDicomTag((AttributeTag)object32);
            string2 = DicomDatabaseInformationModel.getSQLTypeFromDicomValueRepresentation(((Attribute)object2).getVR());
            if (object != null && string2 != null && this.isAttributeUsedInTable(string3, (String)object) && !treeSet.contains(object)) {
                stringBuffer.append(",");
                stringBuffer.append(DicomDatabaseInformationModel.getQuotedEscapedSingleStringValueOrNull((Attribute)object2));
                treeSet.add(object);
            }
        }
        if (informationEntity == InformationEntity.INSTANCE && (object32 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.SOPClassUID)) != null && SOPClass.isImageStorage((String)object32) && (object = SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem((SequenceAttribute)(object2 = (SequenceAttribute)SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(attributeList, TagFromName.SharedFunctionalGroupsSequence, TagFromName.PlaneOrientationSequence)), TagFromName.ImageOrientationPatient)) != null && ((Attribute)object).getVM() == 6) {
            string2 = this.getDatabaseColumnNameFromDicomTag(TagFromName.ImageOrientationPatient);
            String string4 = DicomDatabaseInformationModel.getSQLTypeFromDicomValueRepresentation(((Attribute)object).getVR());
            if (string2 != null && string4 != null && this.isAttributeUsedInTable(string3, string2) && !treeSet.contains(string2)) {
                stringBuffer.append(",");
                stringBuffer.append(DicomDatabaseInformationModel.getQuotedEscapedSingleStringValueOrNull((Attribute)object));
                treeSet.add(string2);
            }
        }
    }

    protected void extendInsertStatementStringWithDerivedAttributeNamesForSelectedInformationEntity(StringBuffer stringBuffer, AttributeList attributeList, InformationEntity informationEntity) throws DicomException {
        if (informationEntity == InformationEntity.STUDY) {
            stringBuffer.append(",");
            stringBuffer.append(derivedStudyDateTimeColumnName);
        } else if (informationEntity == InformationEntity.SERIES) {
            stringBuffer.append(",");
            stringBuffer.append(derivedSeriesDateTimeColumnName);
        } else if (informationEntity == InformationEntity.INSTANCE) {
            stringBuffer.append(",");
            stringBuffer.append(derivedContentDateTimeColumnName);
            stringBuffer.append(",");
            stringBuffer.append(derivedAcquisitionDateTimeColumnName);
            stringBuffer.append(",");
            stringBuffer.append(derivedLossyImageCompressionColumnName);
        }
    }

    public Timestamp getTimestampFromDate(Date date) {
        return new Timestamp(date.getTime());
    }

    public Date getDateFromDicomDateAndTime(String string, String string2, String string3) {
        int n;
        Date date = null;
        String string4 = null;
        String string5 = string;
        if (string != null) {
            if (string.length() == 8) {
                string4 = "yyyyMMdd";
            } else if (string.length() == 10 && string.indexOf(46) != -1) {
                string4 = "yyyy.MM.dd";
            }
        }
        String string6 = "";
        String string7 = "";
        if (string2 != null && (n = string2.length()) > 0) {
            int n2;
            if (string2.indexOf(58) == -1) {
                if (n >= 2) {
                    string6 = "HH";
                }
                if (n >= 4) {
                    string6 = string6 + "mm";
                }
                if (n >= 6) {
                    string6 = string6 + "ss";
                }
                if (n > 7 && string2.indexOf(46) == 6) {
                    n2 = n - 7;
                    if (n2 < 3) {
                        while (n2++ < 3) {
                            string2 = string2 + "0";
                        }
                    } else if (n2 > 3) {
                        string2 = string2.substring(0, 10);
                    }
                    string6 = string6 + ".SSS";
                }
            } else {
                if (n >= 2) {
                    string6 = "HH";
                }
                if (n >= 5) {
                    string6 = string6 + ":mm";
                }
                if (n >= 7) {
                    string6 = string6 + ":ss";
                }
                if (n > 9 && string2.indexOf(46) == 8) {
                    n2 = n - 9;
                    if (n2 < 3) {
                        while (n2++ < 3) {
                            string2 = string2 + "0";
                        }
                    } else if (n2 > 3) {
                        string2 = string2.substring(0, 12);
                    }
                    string6 = string6 + ".SSS";
                }
            }
            string5 = string5 + string2;
            if (string3 != null && string3.length() > 0) {
                string5 = string5 + string3;
                string7 = "Z";
            }
        }
        if (string4 != null) {
            String string8 = string4 + string6 + string7;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string8);
            date = ((DateFormat)simpleDateFormat).parse(string5, new ParsePosition(0));
        }
        return date;
    }

    public Date getDateFromDicomDateAndTime(String string) {
        int n;
        Date date = null;
        String string2 = null;
        if (string != null && (n = string.length()) > 0) {
            Object object;
            if (n >= 4) {
                string2 = "yyyy";
            }
            if (n >= 6) {
                string2 = string2 + "MM";
            }
            if (n >= 8) {
                string2 = string2 + "dd";
            }
            if (n >= 10) {
                string2 = string2 + "HH";
            }
            if (n >= 12) {
                string2 = string2 + "mm";
            }
            if (n >= 14) {
                string2 = string2 + "ss";
            }
            if (n > 15) {
                object = string.substring(0, 15);
                int n2 = string.indexOf(46);
                int n3 = string.indexOf(43);
                if (n3 == -1) {
                    n3 = string.indexOf(45);
                }
                String string3 = "";
                if (n2 == 14) {
                    int n4 = n3 > 15 ? n3 : n;
                    string3 = string.substring(15, n4);
                    int n5 = string3.length();
                    if (n5 < 3) {
                        while (n5++ < 3) {
                            string3 = string3 + "0";
                        }
                    } else {
                        string3 = string3.substring(0, 3);
                    }
                    string2 = string2 + ".SSS";
                }
                String string4 = "";
                if (n3 != -1) {
                    string4 = string.substring(n3);
                    string2 = string2 + "Z";
                }
                string = (String)object + string3 + string4;
            }
            object = new SimpleDateFormat(string2);
            date = ((DateFormat)object).parse(string, new ParsePosition(0));
        }
        return date;
    }

    public Timestamp getTimestampFromDicomDateAndTime(String string, String string2, String string3) {
        Date date = this.getDateFromDicomDateAndTime(string, string2, string3);
        Timestamp timestamp = date == null ? null : this.getTimestampFromDate(date);
        return timestamp;
    }

    public Timestamp getTimestampFromDicomDateAndTime(String string) {
        Date date = this.getDateFromDicomDateAndTime(string);
        Timestamp timestamp = date == null ? null : this.getTimestampFromDate(date);
        return timestamp;
    }

    protected void extendInsertStatementStringWithDerivedAttributeValuesForSelectedInformationEntity(StringBuffer stringBuffer, AttributeList attributeList, InformationEntity informationEntity) throws DicomException {
        String string = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.TimezoneOffsetFromUTC);
        if (informationEntity == InformationEntity.STUDY) {
            String string2;
            String string3 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.StudyDate);
            Timestamp timestamp = this.getTimestampFromDicomDateAndTime(string3, string2 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.StudyTime), string);
            if (timestamp == null) {
                stringBuffer.append(",NULL");
            } else {
                stringBuffer.append(",'");
                stringBuffer.append(timestamp);
                stringBuffer.append("'");
            }
        } else if (informationEntity == InformationEntity.SERIES) {
            String string4;
            String string5 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.SeriesDate);
            Timestamp timestamp = this.getTimestampFromDicomDateAndTime(string5, string4 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.SeriesTime), string);
            if (timestamp == null) {
                stringBuffer.append(",NULL");
            } else {
                stringBuffer.append(",'");
                stringBuffer.append(timestamp);
                stringBuffer.append("'");
            }
        } else if (informationEntity == InformationEntity.INSTANCE) {
            Timestamp timestamp;
            String string6;
            String string7 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.ContentDate);
            Timestamp timestamp2 = this.getTimestampFromDicomDateAndTime(string7, string6 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.ContentTime), string);
            if (timestamp2 == null) {
                stringBuffer.append(",NULL");
            } else {
                stringBuffer.append(",'");
                stringBuffer.append(timestamp2);
                stringBuffer.append("'");
            }
            String string8 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.AcquisitionDateTime);
            String string9 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.AcquisitionDate);
            String string10 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.AcquisitionTime);
            Timestamp timestamp3 = timestamp = string8 == null ? this.getTimestampFromDicomDateAndTime(string9, string10, string) : this.getTimestampFromDicomDateAndTime(string8);
            if (timestamp == null) {
                stringBuffer.append(",NULL");
            } else {
                stringBuffer.append(",'");
                stringBuffer.append(timestamp);
                stringBuffer.append("'");
            }
            stringBuffer.append(",'");
            stringBuffer.append(LossyImageCompression.hasEverBeenLossyCompressed(attributeList) ? 1 : 0);
            stringBuffer.append("'");
        }
    }

    protected void extendCreateStatementStringWithDerivedAttributes(StringBuffer stringBuffer, InformationEntity informationEntity) {
        if (informationEntity == InformationEntity.STUDY) {
            stringBuffer.append(",");
            stringBuffer.append(derivedStudyDateTimeColumnName);
            stringBuffer.append(" TIMESTAMP(6)");
        } else if (informationEntity == InformationEntity.SERIES) {
            stringBuffer.append(",");
            stringBuffer.append(derivedSeriesDateTimeColumnName);
            stringBuffer.append(" TIMESTAMP(6)");
        } else if (informationEntity == InformationEntity.INSTANCE) {
            stringBuffer.append(",");
            stringBuffer.append(derivedContentDateTimeColumnName);
            stringBuffer.append(" TIMESTAMP(6)");
            stringBuffer.append(",");
            stringBuffer.append(derivedAcquisitionDateTimeColumnName);
            stringBuffer.append(" TIMESTAMP(6)");
            stringBuffer.append(",");
            stringBuffer.append(derivedLossyImageCompressionColumnName);
            stringBuffer.append(" INTEGER");
        }
    }

    protected String createPrimaryKeyForSelectedInformationEntity(InformationEntity informationEntity) {
        return Long.toString(new Date().getTime()) + Long.toString((long)(Math.random() * 1.0E8));
    }

    public static String getQuotedValueOrNULL(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string == null || string.length() == 0) {
            stringBuffer.append("NULL");
        } else {
            stringBuffer.append("'");
            stringBuffer.append(string);
            stringBuffer.append("'");
        }
        return stringBuffer.toString();
    }

    public static String getQuotedEscapedSingleStringValueOrNull(Attribute attribute) throws DicomException {
        StringBuffer stringBuffer = new StringBuffer();
        if (attribute == null) {
            stringBuffer.append("NULL");
        } else {
            String string = DicomDatabaseInformationModel.getSQLTypeFromDicomValueRepresentation(attribute.getVR());
            String[] stringArray = attribute.getStringValues();
            if (stringArray == null || stringArray.length == 0) {
                stringBuffer.append("NULL");
            } else if (string.equals("INTEGER")) {
                long[] lArray = attribute.getLongValues();
                if (lArray.length > 0 && (lArray[0] < Integer.MIN_VALUE || lArray[0] > Integer.MAX_VALUE)) {
                    stringBuffer.append("NULL");
                } else {
                    String string2 = attribute.getSingleStringValueOrNull();
                    stringBuffer.append(string2 == null ? "NULL" : string2);
                }
            } else if (string.equals("REAL")) {
                String string3 = attribute.getSingleStringValueOrNull();
                stringBuffer.append(string3 == null ? "NULL" : string3);
            } else {
                stringBuffer.append("'");
                for (int i = 0; i < stringArray.length; ++i) {
                    String string4;
                    if (i > 0) {
                        stringBuffer.append("\\");
                    }
                    if ((string4 = new String(stringArray[i])) == null) continue;
                    string4 = string4.replace('\'', '-');
                    string4 = string4.replace('%', '-');
                    string4 = string4.replace('_', '-');
                    stringBuffer.append(string4);
                }
                stringBuffer.append("'");
            }
        }
        return stringBuffer.toString();
    }

    public QueryResponseGeneratorFactory getQueryResponseGeneratorFactory(int n) {
        return new DicomDatabaseQueryResponseGeneratorFactory(this, n);
    }

    public RetrieveResponseGeneratorFactory getRetrieveResponseGeneratorFactory(int n) {
        return new DicomDatabaseRetrieveResponseGeneratorFactory(this, n);
    }
}

