/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

public class AttributeTag
implements Comparable {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/AttributeTag.java,v 1.10 2008/01/13 00:40:24 dclunie Exp $";
    private int group;
    private int element;

    public AttributeTag(int n, int n2) {
        this.group = n;
        this.element = n2;
    }

    public int getGroup() {
        return this.group;
    }

    public int getElement() {
        return this.element;
    }

    public boolean isPrivate() {
        return this.group % 2 != 0;
    }

    public boolean isGroupLength() {
        return this.element == 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(0x");
        String string = Integer.toHexString(this.group);
        for (int i = string.length(); i < 4; ++i) {
            stringBuffer.append("0");
        }
        stringBuffer.append(string);
        stringBuffer.append(",0x");
        String string2 = Integer.toHexString(this.element);
        for (int i = string2.length(); i < 4; ++i) {
            stringBuffer.append("0");
        }
        stringBuffer.append(string2);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private Long getLong() {
        return new Long(((long)this.group << 16) + ((long)this.element & 0xFFFFL));
    }

    public int compareTo(Object object) {
        return this.getLong().compareTo(((AttributeTag)object).getLong());
    }

    public boolean equals(Object object) {
        return this.group == ((AttributeTag)object).getGroup() && this.element == ((AttributeTag)object).getElement();
    }

    public int hashCode() {
        return (this.group << 16) + (this.element & 0xFFFF);
    }
}

