/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.SequenceItem;
import com.pixelmed.dicom.TagFromName;
import java.util.Iterator;

public class CodedSequenceItem {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/CodedSequenceItem.java,v 1.7 2005/01/02 21:16:43 dclunie Exp $";
    private AttributeList list;

    public CodedSequenceItem(AttributeList attributeList) {
        this.list = attributeList;
    }

    public AttributeList getAttributeList() {
        return this.list;
    }

    public String getCodeValue() {
        return Attribute.getSingleStringValueOrEmptyString(this.list, TagFromName.CodeValue);
    }

    public String getCodingSchemeDesignator() {
        return Attribute.getSingleStringValueOrEmptyString(this.list, TagFromName.CodingSchemeDesignator);
    }

    public String getCodeMeaning() {
        return Attribute.getSingleStringValueOrEmptyString(this.list, TagFromName.CodeMeaning);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        stringBuffer.append(this.getCodeValue());
        stringBuffer.append(",");
        stringBuffer.append(this.getCodingSchemeDesignator());
        stringBuffer.append(",\"");
        stringBuffer.append(this.getCodeMeaning());
        stringBuffer.append("\")");
        return stringBuffer.toString();
    }

    public static CodedSequenceItem getSingleCodedSequenceItemOrNull(AttributeList attributeList, AttributeTag attributeTag) {
        CodedSequenceItem codedSequenceItem = null;
        if (attributeList != null) {
            codedSequenceItem = CodedSequenceItem.getSingleCodedSequenceItemOrNull(attributeList.get(attributeTag));
        }
        return codedSequenceItem;
    }

    public static CodedSequenceItem getSingleCodedSequenceItemOrNull(Attribute attribute) {
        SequenceItem sequenceItem;
        SequenceAttribute sequenceAttribute;
        Iterator iterator;
        CodedSequenceItem codedSequenceItem = null;
        if (attribute != null && attribute instanceof SequenceAttribute && (iterator = (sequenceAttribute = (SequenceAttribute)attribute).iterator()).hasNext() && (sequenceItem = (SequenceItem)iterator.next()) != null) {
            codedSequenceItem = new CodedSequenceItem(sequenceItem.getAttributeList());
        }
        return codedSequenceItem;
    }
}

