/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.DicomOutputStream;
import com.pixelmed.dicom.ValueRepresentation;
import java.io.IOException;

public class OtherWordAttribute
extends Attribute {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/OtherWordAttribute.java,v 1.14 2008/02/21 04:45:04 dclunie Exp $";
    private short[] values;

    public OtherWordAttribute(AttributeTag attributeTag) {
        super(attributeTag);
    }

    public OtherWordAttribute(AttributeTag attributeTag, long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        super(attributeTag);
        this.doCommonConstructorStuff(l, dicomInputStream);
    }

    public OtherWordAttribute(AttributeTag attributeTag, Long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        super(attributeTag);
        this.doCommonConstructorStuff(l, dicomInputStream);
    }

    private void doCommonConstructorStuff(long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        this.values = null;
        this.valueLength = l;
        if (l > 0L) {
            int n = (int)(l / 2L);
            short[] sArray = new short[n];
            dicomInputStream.readUnsigned16(sArray, n);
            this.setValues(sArray);
        }
    }

    public void write(DicomOutputStream dicomOutputStream) throws DicomException, IOException {
        this.writeBase(dicomOutputStream);
        if (this.values != null && this.values.length > 0) {
            dicomOutputStream.writeUnsigned16(this.values, this.values.length);
            if (this.getVL() != (long)(this.values.length * 2)) {
                throw new DicomException("Internal error - short array length (" + this.values.length * 2 + ") not equal to expected VL(" + this.getVL() + ")");
            }
        }
    }

    public String toString(DicomDictionary dicomDictionary) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString(dicomDictionary));
        stringBuffer.append(" []");
        return stringBuffer.toString();
    }

    public void setValues(short[] sArray) throws DicomException {
        this.values = sArray;
        this.valueMultiplicity = 1;
        this.valueLength = sArray.length * 2;
    }

    public void removeValues() {
        this.values = null;
        this.valueMultiplicity = 0;
        this.valueLength = 0L;
    }

    public short[] getShortValues() throws DicomException {
        return this.values;
    }

    public byte[] getVR() {
        return ValueRepresentation.OW;
    }
}

