/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.DateAttribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.IntegerStringAttribute;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.OtherByteAttribute;
import com.pixelmed.dicom.PersonNameAttribute;
import com.pixelmed.dicom.ShortStringAttribute;
import com.pixelmed.dicom.StringAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.TimeAttribute;
import com.pixelmed.dicom.UIDGenerator;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.dicom.UnsignedShortAttribute;
import com.pixelmed.utils.PdfDecoder;
import com.pixelmed.utils.PdfException;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;

public class PDFToDicomImage {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/PDFToDicomImage.java,v 1.3 2007/07/22 16:01:49 dclunie Exp $";

    public PDFToDicomImage(String string, String string2, String string3, String string4, String string5, String string6, String string7, int n) throws IOException, DicomException, PdfException, Exception {
        PdfDecoder pdfDecoder = new PdfDecoder();
        pdfDecoder.useHiResScreenDisplay(true);
        pdfDecoder.openPdfFile(string);
        int n2 = pdfDecoder.getPageCount();
        float f = (float)n / (float)pdfDecoder.getDPI();
        int n3 = 0;
        int n4 = 0;
        AttributeList attributeList = null;
        int n5 = 0;
        byte[] byArray = null;
        for (int i = 0; i < n2; ++i) {
            short s;
            short s2;
            short s3;
            pdfDecoder.setPageParameters(f, i + 1);
            BufferedImage bufferedImage = pdfDecoder.getPageAsImage(i + 1);
            if (bufferedImage == null) {
                throw new DicomException("Could not get image of page " + (i + 1));
            }
            int n6 = bufferedImage.getWidth();
            int n7 = bufferedImage.getHeight();
            SampleModel sampleModel = bufferedImage.getSampleModel();
            int n8 = sampleModel.getDataType();
            WritableRaster writableRaster = bufferedImage.getRaster();
            int n9 = writableRaster.getNumBands();
            if (attributeList == null) {
                attributeList = new AttributeList();
                n3 = n6;
                n4 = n7;
                short s4 = (short)n7;
                short s5 = (short)n6;
                s3 = 0;
                s2 = 0;
                s = 0;
                short s6 = 0;
                short s7 = 0;
                String string8 = null;
                short s8 = 0;
                String string9 = null;
                if (n9 != 3) {
                    throw new DicomException("Unsupported pixel data form (" + n9 + " bands)");
                }
                s3 = 8;
                s2 = 8;
                s = 7;
                s6 = 3;
                s7 = 0;
                string8 = "RGB";
                s8 = 0;
                string9 = n2 > 1 ? "1.2.840.10008.5.1.4.1.1.7.4" : "1.2.840.10008.5.1.4.1.1.7";
                n5 = n3 * n4 * n9;
                byArray = new byte[n2 * n5];
                Object object = new UnsignedShortAttribute(TagFromName.BitsAllocated);
                ((Attribute)object).addValue(s3);
                attributeList.put((Attribute)object);
                object = new UnsignedShortAttribute(TagFromName.BitsStored);
                ((Attribute)object).addValue(s2);
                attributeList.put((Attribute)object);
                object = new UnsignedShortAttribute(TagFromName.HighBit);
                ((Attribute)object).addValue(s);
                attributeList.put((Attribute)object);
                object = new UnsignedShortAttribute(TagFromName.Rows);
                ((Attribute)object).addValue(s4);
                attributeList.put((Attribute)object);
                object = new UnsignedShortAttribute(TagFromName.Columns);
                ((Attribute)object).addValue(s5);
                attributeList.put((Attribute)object);
                object = new IntegerStringAttribute(TagFromName.NumberOfFrames);
                ((Attribute)object).addValue(n2);
                attributeList.put((Attribute)object);
                object = new UnsignedShortAttribute(TagFromName.SamplesPerPixel);
                ((Attribute)object).addValue(s6);
                attributeList.put((Attribute)object);
                object = new UnsignedShortAttribute(TagFromName.PixelRepresentation);
                ((Attribute)object).addValue(s7);
                attributeList.put((Attribute)object);
                object = new CodeStringAttribute(TagFromName.PhotometricInterpretation);
                ((Attribute)object).addValue(string8);
                attributeList.put((Attribute)object);
                if (s6 > 1) {
                    object = new UnsignedShortAttribute(TagFromName.PlanarConfiguration);
                    ((Attribute)object).addValue(s8);
                    attributeList.put((Attribute)object);
                }
                object = new UIDGenerator();
                StringAttribute stringAttribute = new UniqueIdentifierAttribute(TagFromName.SOPClassUID);
                ((Attribute)stringAttribute).addValue(string9);
                attributeList.put(stringAttribute);
                stringAttribute = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
                ((Attribute)stringAttribute).addValue(((UIDGenerator)object).getNewSOPInstanceUID(string5, string6, string7));
                attributeList.put(stringAttribute);
                stringAttribute = new UniqueIdentifierAttribute(TagFromName.SeriesInstanceUID);
                ((Attribute)stringAttribute).addValue(((UIDGenerator)object).getNewSeriesInstanceUID(string5, string6));
                attributeList.put(stringAttribute);
                stringAttribute = new UniqueIdentifierAttribute(TagFromName.StudyInstanceUID);
                ((Attribute)stringAttribute).addValue(((UIDGenerator)object).getNewStudyInstanceUID(string5));
                attributeList.put(stringAttribute);
                stringAttribute = new PersonNameAttribute(TagFromName.PatientName);
                ((Attribute)stringAttribute).addValue(string3);
                attributeList.put(stringAttribute);
                stringAttribute = new LongStringAttribute(TagFromName.PatientID);
                ((Attribute)stringAttribute).addValue(string4);
                attributeList.put(stringAttribute);
                stringAttribute = new DateAttribute(TagFromName.PatientBirthDate);
                attributeList.put(stringAttribute);
                stringAttribute = new CodeStringAttribute(TagFromName.PatientSex);
                attributeList.put(stringAttribute);
                stringAttribute = new ShortStringAttribute(TagFromName.StudyID);
                ((Attribute)stringAttribute).addValue(string5);
                attributeList.put(stringAttribute);
                stringAttribute = new DateAttribute(TagFromName.StudyDate);
                attributeList.put(stringAttribute);
                stringAttribute = new TimeAttribute(TagFromName.StudyTime);
                attributeList.put(stringAttribute);
                stringAttribute = new PersonNameAttribute(TagFromName.ReferringPhysicianName);
                ((Attribute)stringAttribute).addValue("^^^^");
                attributeList.put(stringAttribute);
                stringAttribute = new ShortStringAttribute(TagFromName.AccessionNumber);
                attributeList.put(stringAttribute);
                stringAttribute = new IntegerStringAttribute(TagFromName.SeriesNumber);
                ((Attribute)stringAttribute).addValue(string6);
                attributeList.put(stringAttribute);
                stringAttribute = new IntegerStringAttribute(TagFromName.InstanceNumber);
                ((Attribute)stringAttribute).addValue(string7);
                attributeList.put(stringAttribute);
                stringAttribute = new CodeStringAttribute(TagFromName.Modality);
                ((Attribute)stringAttribute).addValue("OT");
                attributeList.put(stringAttribute);
                stringAttribute = new CodeStringAttribute(TagFromName.ConversionType);
                ((Attribute)stringAttribute).addValue("WSD");
                attributeList.put(stringAttribute);
                stringAttribute = new LongStringAttribute(TagFromName.Manufacturer);
                attributeList.put(stringAttribute);
                stringAttribute = new CodeStringAttribute(TagFromName.PatientOrientation);
                attributeList.put(stringAttribute);
            } else if (n3 != n6 || n4 != n7) {
                throw new DicomException("Pages of different sizes not supported");
            }
            DataBuffer dataBuffer = writableRaster.getDataBuffer();
            int[] nArray = null;
            nArray = sampleModel.getPixels(0, 0, n6, n7, nArray, dataBuffer);
            s3 = nArray.length;
            s2 = i * n5;
            s = 0;
            while (s < s3) {
                byArray[s2++] = (byte)nArray[s++];
                byArray[s2++] = (byte)nArray[s++];
                byArray[s2++] = (byte)nArray[s++];
            }
        }
        pdfDecoder.closePdfFile();
        OtherByteAttribute otherByteAttribute = new OtherByteAttribute(TagFromName.PixelData);
        ((Attribute)otherByteAttribute).setValues(byArray);
        attributeList.put(otherByteAttribute);
        FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2.1", "OURAETITLE");
        attributeList.write(string2, "1.2.840.10008.1.2.1", true, true);
    }

    public static void main(String[] stringArray) {
        try {
            new PDFToDicomImage(stringArray[0], stringArray[1], stringArray[2], stringArray[3], stringArray[4], stringArray[5], stringArray[6], Integer.parseInt(stringArray[7]));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

