/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.display;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.display.ImageEditUtilities;
import com.pixelmed.display.SingleImagePanel;
import com.pixelmed.display.SingleImagePanelWithRegionDrawing;
import com.pixelmed.display.SourceImage;
import com.pixelmed.display.event.FrameSelectionChangeEvent;
import com.pixelmed.event.ApplicationEventDispatcher;
import com.pixelmed.event.Event;
import com.pixelmed.event.EventContext;
import com.pixelmed.event.SelfRegisteringListener;
import com.pixelmed.utils.FileUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DicomImageBlackout
extends JFrame {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/display/DicomImageBlackout.java,v 1.23 2007/12/19 22:44:14 dclunie Exp $";
    private static final String helpText = "Buttons: left windows; right drag draws box; right click selects box; delete key deletes selection";
    private static final Dimension maximumMultiPanelDimension = new Dimension(800, 600);
    private static final double splitPaneResizeWeight = 0.9;
    protected String[] dicomFileNames;
    protected String currentFileName;
    protected int currentFileNumber;
    protected Box mainPanel;
    protected JPanel multiPanel;
    protected SingleImagePanel imagePanel;
    protected AttributeList list;
    protected SourceImage sImg;
    protected boolean changesWereMade;
    protected int previousRows;
    protected int previousColumns;
    protected Vector previousPersistentDrawingShapes;
    protected JPanel cineSliderControlsPanel;
    protected CineSliderChangeListener cineSliderChangeListener;
    protected JSlider cineSlider;
    protected JLabel imagesRemainingLabel;
    protected EventContext ourEventContext;
    protected OurFrameSelectionChangeListener ourFrameSelectionChangeListener;
    protected int burnedinflag;
    protected final StatusNotificationHandler statusNotificationHandler;

    protected void recordStateOfDrawingShapesForNextFile() {
        this.previousRows = this.sImg.getHeight();
        this.previousColumns = this.sImg.getWidth();
        this.previousPersistentDrawingShapes = this.imagePanel.getPersistentDrawingShapes();
    }

    protected void createCineSliderIfNecessary(int n, int n2, int n3) {
        if (this.cineSlider == null || n != this.cineSlider.getMinimum() || n2 != this.cineSlider.getMaximum()) {
            this.cineSliderControlsPanel.removeAll();
            if (n2 > n) {
                this.cineSlider = new JSlider(n, n2, n3);
                this.cineSlider.setLabelTable(this.cineSlider.createStandardLabels(n2 - 1, n));
                this.cineSlider.setPaintLabels(true);
                this.cineSliderControlsPanel.add(this.cineSlider);
                this.cineSlider.addChangeListener(this.cineSliderChangeListener);
            } else {
                this.cineSlider = null;
            }
        }
        if (this.cineSlider != null) {
            this.cineSlider.setValue(n3);
        }
    }

    protected void updateDisplayedFileNumber(int n, int n2) {
        if (this.imagesRemainingLabel != null) {
            this.imagesRemainingLabel.setText(Integer.toString(n + 1) + " of " + Integer.toString(n2));
        }
    }

    protected void loadDicomFileOrDirectory(String string) {
        try {
            File file = FileUtilities.getFileFromNameInsensitiveToCaseIfNecessary(string);
            this.loadDicomFileOrDirectory(file);
        }
        catch (Exception exception) {
            if (this.statusNotificationHandler != null) {
                this.statusNotificationHandler.notify(7, "Read failed", exception);
            }
            this.dispose();
        }
    }

    protected void loadDicomFileOrDirectory(File file) {
        block7: {
            this.changesWereMade = false;
            SingleImagePanel.deconstructAllSingleImagePanelsInContainer(this.multiPanel);
            this.multiPanel.removeAll();
            this.multiPanel.revalidate();
            Cursor cursor = this.getCursor();
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                System.err.println("DicomImageBlackout.loadDicomFileOrDirectory(): Open " + file);
                this.currentFileName = file.getAbsolutePath();
                DicomInputStream dicomInputStream = new DicomInputStream(file);
                this.list = new AttributeList();
                this.list.read(dicomInputStream);
                dicomInputStream.close();
                String string = Attribute.getSingleStringValueOrEmptyString(this.list, TagFromName.SOPClassUID);
                if (SOPClass.isImageStorage(string)) {
                    this.sImg = new SourceImage(this.list);
                    this.imagePanel = new SingleImagePanelWithRegionDrawing(this.sImg, this.ourEventContext);
                    this.addSingleImagePanelToMultiPanelAndEstablishLayout();
                    this.createCineSliderIfNecessary(1, Attribute.getSingleIntegerValueOrDefault(this.list, TagFromName.NumberOfFrames, 1), 1);
                    this.setCursor(cursor);
                    this.showUIComponents();
                    if (this.previousPersistentDrawingShapes != null) {
                        if (this.previousRows == this.sImg.getHeight() && this.previousColumns == this.sImg.getWidth()) {
                            this.imagePanel.setPersistentDrawingShapes(this.previousPersistentDrawingShapes);
                        } else {
                            this.previousRows = 0;
                            this.previousColumns = 0;
                            this.previousPersistentDrawingShapes = null;
                        }
                    }
                    break block7;
                }
                throw new DicomException("unsupported SOP Class " + string);
            }
            catch (Exception exception) {
                if (this.statusNotificationHandler != null) {
                    this.statusNotificationHandler.notify(7, "Read failed", exception);
                }
                this.dispose();
            }
        }
    }

    protected double getScaleFactorToFitInMaximumAvailable(double d, double d2, double d3, double d4) {
        double d5 = d3 / d;
        double d6 = d4 / d2;
        double d7 = d5 < d6 ? d5 : d6;
        return d7;
    }

    protected Dimension changeDimensionToFitInMaximumAvailable(Dimension dimension, Dimension dimension2, boolean bl) {
        double d;
        double d2;
        double d3;
        double d4 = dimension.getWidth();
        double d5 = this.getScaleFactorToFitInMaximumAvailable(d4, d3 = dimension.getHeight(), d2 = dimension2.getWidth(), d = dimension2.getHeight());
        if (d5 < 1.0 || !bl) {
            d4 *= d5;
            d3 *= d5;
        }
        dimension = new Dimension((int)d4, (int)d3);
        return dimension;
    }

    protected Dimension reduceDimensionToFitInMaximumAvailable(Dimension dimension) {
        return this.changeDimensionToFitInMaximumAvailable(dimension, maximumMultiPanelDimension, true);
    }

    protected void addSingleImagePanelToMultiPanelAndEstablishLayout() {
        this.addSingleImagePanelToMultiPanelAndEstablishLayoutWithCenterMaximumAfterInitialSizeLayout();
    }

    protected void addSingleImagePanelToMultiPanelAndEstablishLayoutWithCenterMaximumAfterInitialSizeLayout() {
        Dimension dimension = this.reduceDimensionToFitInMaximumAvailable(this.sImg.getDimension());
        this.imagePanel.setPreferredSize(dimension);
        this.imagePanel.setMinimumSize(dimension);
        this.multiPanel.setPreferredSize(dimension);
        this.multiPanel.setMinimumSize(dimension);
        CenterMaximumAfterInitialSizeLayout centerMaximumAfterInitialSizeLayout = new CenterMaximumAfterInitialSizeLayout();
        this.multiPanel.setLayout(centerMaximumAfterInitialSizeLayout);
        this.multiPanel.setBackground(Color.black);
        this.multiPanel.add(this.imagePanel);
    }

    protected void showUIComponents() {
        this.remove(this.mainPanel);
        this.add(this.mainPanel);
        this.pack();
        this.validate();
        this.setVisible(true);
        this.imagePanel.setMinimumSize(null);
        this.multiPanel.setMinimumSize(null);
    }

    protected void buildUIComponents() {
        this.ourEventContext = new EventContext("Blackout Panel");
        this.multiPanel = new JPanel();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        JButton jButton = new JButton("Apply");
        jButton.setToolTipText("Blackout the regions");
        jPanel.add(jButton);
        jButton.addActionListener(new ApplyActionListener(this));
        JButton jButton2 = new JButton("Save");
        jButton2.setToolTipText("Save the blacked-out image");
        jPanel.add(jButton2);
        jButton2.addActionListener(new SaveActionListener(this));
        JButton jButton3 = new JButton("Next");
        jButton3.setToolTipText("Move to the next, skipping this image, if not already saved");
        jPanel.add(jButton3);
        jButton3.addActionListener(new NextActionListener(this));
        this.imagesRemainingLabel = new JLabel("0 of 0");
        jPanel.add(this.imagesRemainingLabel);
        JButton jButton4 = new JButton("Cancel");
        jButton4.setToolTipText("Cancel work on this image, if not already saved, and skip all remaining images");
        jPanel.add(jButton4);
        jButton4.addActionListener(new CancelActionListener(this));
        this.cineSliderControlsPanel = new JPanel();
        jPanel.add(this.cineSliderControlsPanel);
        this.cineSliderChangeListener = new CineSliderChangeListener();
        this.ourFrameSelectionChangeListener = new OurFrameSelectionChangeListener(this.ourEventContext);
        JSplitPane jSplitPane = new JSplitPane(0, this.multiPanel, jPanel);
        jSplitPane.setOneTouchExpandable(false);
        jSplitPane.setResizeWeight(0.9);
        JLabel jLabel = new JLabel(helpText);
        this.mainPanel = new Box(1);
        this.mainPanel.add(jSplitPane);
        this.mainPanel.add(jLabel);
    }

    public DicomImageBlackout(String string, String[] stringArray, StatusNotificationHandler statusNotificationHandler, int n) {
        super(string);
        JFileChooser jFileChooser;
        this.statusNotificationHandler = statusNotificationHandler == null ? new DefaultStatusNotificationHandler() : statusNotificationHandler;
        this.burnedinflag = n;
        this.setBackground(Color.lightGray);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (DicomImageBlackout.this.statusNotificationHandler != null) {
                    DicomImageBlackout.this.statusNotificationHandler.notify(1, "Window closed", null);
                }
                DicomImageBlackout.this.dispose();
            }
        });
        this.buildUIComponents();
        if ((stringArray == null || stringArray.length == 0) && (jFileChooser = new JFileChooser()).showOpenDialog(null) == 0) {
            String[] stringArray2 = new String[]{jFileChooser.getSelectedFile().getAbsolutePath()};
            stringArray = stringArray2;
        }
        if (stringArray != null && stringArray.length > 0) {
            this.dicomFileNames = stringArray;
            this.currentFileNumber = 0;
            this.updateDisplayedFileNumber(this.currentFileNumber, stringArray.length);
            this.loadDicomFileOrDirectory(stringArray[this.currentFileNumber]);
        }
    }

    public void deconstruct() {
        if (this.ourFrameSelectionChangeListener != null) {
            ApplicationEventDispatcher.getApplicationEventDispatcher().removeListener(this.ourFrameSelectionChangeListener);
            this.ourFrameSelectionChangeListener = null;
        }
        if (this.multiPanel != null) {
            SingleImagePanel.deconstructAllSingleImagePanelsInContainer(this.multiPanel);
        }
    }

    public void dispose() {
        this.deconstruct();
        super.dispose();
    }

    protected void finalize() throws Throwable {
        this.deconstruct();
        super.finalize();
    }

    public static void main(String[] stringArray) {
        new DicomImageBlackout("Dicom Image Blackout", stringArray, null, 4);
    }

    protected class CenterMaximumAfterInitialSizeLayout
    implements LayoutManager {
        public void addLayoutComponent(String string, Component component) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void layoutContainer(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                int n;
                Insets insets = container.getInsets();
                int n2 = container.getComponentCount();
                Dimension dimension = container.getSize();
                int n3 = 0;
                int n4 = 0;
                for (n = 0; n < n2; ++n) {
                    Component component = container.getComponent(n);
                    Dimension dimension2 = component.getPreferredSize();
                    n3 = (int)((double)n3 + dimension2.getWidth());
                    n4 = (int)((double)n4 + dimension2.getHeight());
                }
                n = dimension.width - (insets.left + insets.right);
                int n5 = dimension.height - (insets.top + insets.bottom);
                int n6 = 0;
                int n7 = 0;
                boolean bl = false;
                double d = 1.0;
                if (n3 == n && n4 <= n5 || n3 <= n && n4 == n5) {
                    n6 = (n - n3) / 2;
                    n7 = (n5 - n4) / 2;
                } else {
                    bl = true;
                    d = DicomImageBlackout.this.getScaleFactorToFitInMaximumAvailable(n3, n4, n, n5);
                    n6 = (int)(((double)n - (double)n3 * d) / 2.0);
                    n7 = (int)(((double)n5 - (double)n4 * d) / 2.0);
                }
                for (int i = 0; i < n2; ++i) {
                    Component component = container.getComponent(i);
                    Dimension dimension3 = component.getPreferredSize();
                    int n8 = dimension3.width;
                    int n9 = dimension3.height;
                    if (bl) {
                        n8 = (int)((double)n8 * d);
                        n9 = (int)((double)n9 * d);
                    }
                    component.setBounds(n6, n7, n8, n9);
                    n6 += n8;
                    n7 += n9;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Dimension minimumLayoutSize(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                Insets insets = container.getInsets();
                int n = container.getComponentCount();
                int n2 = insets.left + insets.right;
                int n3 = insets.top + insets.bottom;
                for (int i = 0; i < n; ++i) {
                    Component component = container.getComponent(i);
                    Dimension dimension = component.getMinimumSize();
                    n2 = (int)((double)n2 + dimension.getWidth());
                    n3 = (int)((double)n3 + dimension.getHeight());
                }
                return new Dimension(n2, n3);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Dimension preferredLayoutSize(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                Insets insets = container.getInsets();
                int n = container.getComponentCount();
                int n2 = insets.left + insets.right;
                int n3 = insets.top + insets.bottom;
                for (int i = 0; i < n; ++i) {
                    Component component = container.getComponent(i);
                    Dimension dimension = component.getPreferredSize();
                    n2 = (int)((double)n2 + dimension.getWidth());
                    n3 = (int)((double)n3 + dimension.getHeight());
                }
                return new Dimension(n2, n3);
            }
        }

        public void removeLayoutComponent(Component component) {
        }
    }

    protected class CancelActionListener
    implements ActionListener {
        DicomImageBlackout application;

        public CancelActionListener(DicomImageBlackout dicomImageBlackout2) {
            this.application = dicomImageBlackout2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.application.statusNotificationHandler != null) {
                this.application.statusNotificationHandler.notify(2, "Cancelled", null);
            }
            this.application.dispose();
        }
    }

    protected class NextActionListener
    implements ActionListener {
        DicomImageBlackout application;

        public NextActionListener(DicomImageBlackout dicomImageBlackout2) {
            this.application = dicomImageBlackout2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DicomImageBlackout.this.recordStateOfDrawingShapesForNextFile();
            if (DicomImageBlackout.this.changesWereMade && this.application.statusNotificationHandler != null) {
                this.application.statusNotificationHandler.notify(5, "Changes were applied to " + DicomImageBlackout.this.dicomFileNames[DicomImageBlackout.this.currentFileNumber] + " but were discarded and not saved", null);
            }
            ++DicomImageBlackout.this.currentFileNumber;
            if (DicomImageBlackout.this.dicomFileNames != null && DicomImageBlackout.this.currentFileNumber < DicomImageBlackout.this.dicomFileNames.length) {
                DicomImageBlackout.this.updateDisplayedFileNumber(DicomImageBlackout.this.currentFileNumber, DicomImageBlackout.this.dicomFileNames.length);
                DicomImageBlackout.this.loadDicomFileOrDirectory(DicomImageBlackout.this.dicomFileNames[DicomImageBlackout.this.currentFileNumber]);
            } else {
                if (this.application.statusNotificationHandler != null) {
                    this.application.statusNotificationHandler.notify(3, "Normal completion", null);
                }
                this.application.dispose();
            }
        }
    }

    protected class SaveActionListener
    implements ActionListener {
        DicomImageBlackout application;

        public SaveActionListener(DicomImageBlackout dicomImageBlackout2) {
            this.application = dicomImageBlackout2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DicomImageBlackout.this.recordStateOfDrawingShapesForNextFile();
            Cursor cursor = this.application.getCursor();
            this.application.setCursor(Cursor.getPredefinedCursor(3));
            boolean bl = true;
            try {
                this.application.sImg.close();
                this.application.sImg = null;
            }
            catch (Throwable throwable) {
                if (this.application.statusNotificationHandler != null) {
                    this.application.statusNotificationHandler.notify(4, "Save failed - unable to close image - not saving modifications", throwable);
                }
                bl = false;
            }
            File file = new File(DicomImageBlackout.this.currentFileName);
            File file2 = new File(DicomImageBlackout.this.currentFileName + ".bak");
            if (bl) {
                try {
                    FileUtilities.renameElseCopyTo(file, file2);
                    DicomImageBlackout.this.list.setFileUsedByOnDiskAttributes(file2);
                }
                catch (IOException iOException) {
                    if (this.application.statusNotificationHandler != null) {
                        this.application.statusNotificationHandler.notify(4, "Save failed - unable to rename or copy " + DicomImageBlackout.this.currentFileName + " to " + file2 + " - not saving modifications", iOException);
                    }
                    bl = false;
                }
            }
            if (bl) {
                try {
                    Object object;
                    ImageEditUtilities.sanitizePhotometricInterpretation(DicomImageBlackout.this.list);
                    if (DicomImageBlackout.this.burnedinflag != 1) {
                        DicomImageBlackout.this.list.remove(TagFromName.BurnedInAnnotation);
                        if (DicomImageBlackout.this.burnedinflag == 4 || DicomImageBlackout.this.burnedinflag == 3 && DicomImageBlackout.this.changesWereMade) {
                            object = new CodeStringAttribute(TagFromName.BurnedInAnnotation);
                            ((Attribute)object).addValue("NO");
                            DicomImageBlackout.this.list.put((Attribute)object);
                        }
                    }
                    if (DicomImageBlackout.this.changesWereMade) {
                        object = Attribute.getSingleStringValueOrNull(DicomImageBlackout.this.list, TagFromName.DeidentificationMethod);
                        DicomImageBlackout.this.list.remove(TagFromName.DeidentificationMethod);
                        LongStringAttribute longStringAttribute = new LongStringAttribute(TagFromName.DeidentificationMethod);
                        ((Attribute)longStringAttribute).addValue((object == null ? "" : (String)object + "; ") + "Burned in text blacked out");
                        DicomImageBlackout.this.list.put(longStringAttribute);
                    }
                    DicomImageBlackout.this.list.removeGroupLengthAttributes();
                    DicomImageBlackout.this.list.removeMetaInformationHeaderAttributes();
                    DicomImageBlackout.this.list.remove(TagFromName.DataSetTrailingPadding);
                    FileMetaInformation.addFileMetaInformation(DicomImageBlackout.this.list, "1.2.840.10008.1.2.1", "OURAETITLE");
                    DicomImageBlackout.this.list.write(file, "1.2.840.10008.1.2.1", true, true);
                    file2.delete();
                    DicomImageBlackout.this.changesWereMade = false;
                    if (this.application.statusNotificationHandler != null) {
                        this.application.statusNotificationHandler.notify(6, "Save of " + DicomImageBlackout.this.currentFileName + " succeeded", null);
                    }
                }
                catch (DicomException dicomException) {
                    if (this.application.statusNotificationHandler != null) {
                        this.application.statusNotificationHandler.notify(4, "Save failed", dicomException);
                    }
                    file2.renameTo(file);
                }
                catch (IOException iOException) {
                    if (this.application.statusNotificationHandler != null) {
                        this.application.statusNotificationHandler.notify(4, "Save failed", iOException);
                    }
                    file2.renameTo(file);
                }
            }
            DicomImageBlackout.this.loadDicomFileOrDirectory(file);
            this.application.setCursor(cursor);
        }
    }

    protected class ApplyActionListener
    implements ActionListener {
        DicomImageBlackout application;

        public ApplyActionListener(DicomImageBlackout dicomImageBlackout2) {
            this.application = dicomImageBlackout2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DicomImageBlackout.this.recordStateOfDrawingShapesForNextFile();
            Cursor cursor = this.application.getCursor();
            this.application.setCursor(Cursor.getPredefinedCursor(3));
            if (this.application.imagePanel != null && this.application.sImg != null && this.application.list != null) {
                if (this.application.imagePanel != null) {
                    Vector vector = this.application.imagePanel.getPersistentDrawingShapes();
                    if (vector != null) {
                        DicomImageBlackout.this.changesWereMade = true;
                        try {
                            ImageEditUtilities.blackout(this.application.sImg, this.application.list, vector);
                            this.application.imagePanel.dirty();
                            this.application.imagePanel.repaint();
                        }
                        catch (DicomException dicomException) {
                            if (this.application.statusNotificationHandler != null) {
                                this.application.statusNotificationHandler.notify(8, "Blackout failed", dicomException);
                            }
                            this.application.dispose();
                        }
                    } else {
                        System.err.println("DicomImageBlackout.ApplyActionListener.actionPerformed(): no shapes to do");
                    }
                }
            } else {
                System.err.println("DicomImageBlackout.ApplyActionListener.actionPerformed(): no panel or image or list to do");
            }
            this.application.setCursor(cursor);
        }
    }

    public class DefaultStatusNotificationHandler
    extends StatusNotificationHandler {
        public void notify(int n, String string, Throwable throwable) {
            System.err.println("DicomImageBlackout.DefaultStatusNotificationHandler.notify(): status = " + n);
            System.err.println("DicomImageBlackout.DefaultStatusNotificationHandler.notify(): message = " + string);
            if (throwable != null) {
                throwable.printStackTrace(System.err);
            }
        }
    }

    public abstract class StatusNotificationHandler {
        public static final int WINDOW_CLOSED = 1;
        public static final int CANCELLED = 2;
        public static final int COMPLETED = 3;
        public static final int SAVE_FAILED = 4;
        public static final int UNSAVED_CHANGES = 5;
        public static final int SAVE_SUCCEEDED = 6;
        public static final int READ_FAILED = 7;
        public static final int BLACKOUT_FAILED = 8;

        protected StatusNotificationHandler() {
        }

        public abstract void notify(int var1, String var2, Throwable var3);
    }

    public abstract class BurnedInAnnotationFlagAction {
        public static final int LEAVE_ALONE = 1;
        public static final int ALWAYS_REMOVE = 2;
        public static final int ADD_AS_NO_IF_CHANGED = 3;
        public static final int ADD_AS_NO_IF_SAVED = 4;

        private BurnedInAnnotationFlagAction() {
        }
    }

    protected class CineSliderChangeListener
    implements ChangeListener {
        protected CineSliderChangeListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new FrameSelectionChangeEvent(DicomImageBlackout.this.ourEventContext, DicomImageBlackout.this.cineSlider.getValue() - 1));
        }
    }

    class OurFrameSelectionChangeListener
    extends SelfRegisteringListener {
        public OurFrameSelectionChangeListener(EventContext eventContext) {
            super("com.pixelmed.display.event.FrameSelectionChangeEvent", eventContext);
        }

        public void changed(Event event) {
            FrameSelectionChangeEvent frameSelectionChangeEvent = (FrameSelectionChangeEvent)event;
            DicomImageBlackout.this.cineSlider.setValue(frameSelectionChangeEvent.getIndex() + 1);
        }
    }
}

