/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.display;

import com.pixelmed.database.DatabaseApplicationProperties;
import com.pixelmed.database.DatabaseInformationModel;
import com.pixelmed.database.DatabaseMediaImporter;
import com.pixelmed.database.DatabaseTreeBrowser;
import com.pixelmed.database.PatientStudySeriesConcatenationInstanceModel;
import com.pixelmed.dicom.AgeStringAttribute;
import com.pixelmed.dicom.ArrayCopyUtilities;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeListFunctionalGroupsTableModelAllFrames;
import com.pixelmed.dicom.AttributeListFunctionalGroupsTableModelOneFrame;
import com.pixelmed.dicom.AttributeListTableBrowser;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.AttributeTreeBrowser;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.DateAttribute;
import com.pixelmed.dicom.DateTimeAttribute;
import com.pixelmed.dicom.DecimalStringAttribute;
import com.pixelmed.dicom.DescriptionFactory;
import com.pixelmed.dicom.DicomDirectory;
import com.pixelmed.dicom.DicomDirectoryBrowser;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.GeometryOfVolumeFromAttributeList;
import com.pixelmed.dicom.InformationEntity;
import com.pixelmed.dicom.IntegerStringAttribute;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.LongTextAttribute;
import com.pixelmed.dicom.PersonNameAttribute;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.ShortStringAttribute;
import com.pixelmed.dicom.ShortTextAttribute;
import com.pixelmed.dicom.SpecificCharacterSet;
import com.pixelmed.dicom.SpectroscopyVolumeLocalization;
import com.pixelmed.dicom.StoredFilePathStrategy;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.TimeAttribute;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.dicom.UnsignedShortAttribute;
import com.pixelmed.dicom.XMLRepresentationOfDicomObjectFactory;
import com.pixelmed.display.ApplicationFrame;
import com.pixelmed.display.DemographicAndTechniqueAnnotations;
import com.pixelmed.display.ImageLocalizerManager;
import com.pixelmed.display.OrientationAnnotations;
import com.pixelmed.display.SingleImagePanel;
import com.pixelmed.display.SourceImage;
import com.pixelmed.display.SourceImageSortOrderPanel;
import com.pixelmed.display.SourceImageVOILUTSelectorPanel;
import com.pixelmed.display.SourceSpectra;
import com.pixelmed.display.SourceSpectrumSortOrderPanel;
import com.pixelmed.display.SpectraPanel;
import com.pixelmed.display.SpectroscopyLocalizerManager;
import com.pixelmed.display.StatusBarManager;
import com.pixelmed.display.event.BrowserPaneChangeEvent;
import com.pixelmed.display.event.FrameSelectionChangeEvent;
import com.pixelmed.display.event.FrameSortOrderChangeEvent;
import com.pixelmed.display.event.SourceImageSelectionChangeEvent;
import com.pixelmed.display.event.SourceSpectrumSelectionChangeEvent;
import com.pixelmed.display.event.StatusChangeEvent;
import com.pixelmed.display.event.WellKnownContext;
import com.pixelmed.event.ApplicationEventDispatcher;
import com.pixelmed.event.Event;
import com.pixelmed.event.EventContext;
import com.pixelmed.event.SelfRegisteringListener;
import com.pixelmed.geometry.GeometryOfVolume;
import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.NetworkApplicationInformation;
import com.pixelmed.network.NetworkApplicationInformationFederated;
import com.pixelmed.network.NetworkApplicationProperties;
import com.pixelmed.network.PresentationAddress;
import com.pixelmed.network.ReceivedObjectHandler;
import com.pixelmed.network.StorageSOPClassSCPDispatcher;
import com.pixelmed.network.StorageSOPClassSCU;
import com.pixelmed.query.FilterPanel;
import com.pixelmed.query.QueryInformationModel;
import com.pixelmed.query.QueryTreeBrowser;
import com.pixelmed.query.QueryTreeModel;
import com.pixelmed.query.QueryTreeRecord;
import com.pixelmed.query.StudyRootQueryInformationModel;
import com.pixelmed.utils.CopyStream;
import com.pixelmed.utils.FileUtilities;
import com.pixelmed.utils.FloatFormatter;
import com.pixelmed.utils.MessageLogger;
import com.pixelmed.validate.DicomInstanceValidator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class DicomImageViewer
extends ApplicationFrame
implements KeyListener,
MouseListener {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/display/DicomImageViewer.java,v 1.203 2008/01/20 15:32:38 dclunie Exp $";
    private static final String releaseString = "General Release";
    static final char screenSnapShotKeyChar = 'K';
    static final String propertiesFileName = ".com.pixelmed.display.DicomImageViewer.properties";
    private static final String propertyName_DicomCurrentlySelectedStorageTargetAE = "Dicom.CurrentlySelectedStorageTargetAE";
    private static final String propertyName_DicomCurrentlySelectedQueryTargetAE = "Dicom.CurrentlySelectedQueryTargetAE";
    static final String propertyName_FullScreen = "Display.FullScreen";
    StatusBarManager statusBarManager;
    private JLabel statusBar;
    private DatabaseApplicationProperties databaseApplicationProperties = null;
    private NetworkApplicationProperties networkApplicationProperties = null;
    private NetworkApplicationInformation networkApplicationInformation = null;
    protected StoredFilePathStrategy storedFilePathStrategy = StoredFilePathStrategy.BYSOPINSTANCEUIDHASHSUBFOLDERS;
    private DatabaseInformationModel databaseInformationModel;
    private static final int widthWantedForBrowser = 400;
    private static final int heightWantedForAttributeTable = 76;
    private static final double browserAndMultiPaneAndCurrentAttributesResizeWeight = 0.9;
    private static final Dimension defaultMultiPanelDimension = new Dimension(512, 512);
    private int applicationWidth;
    private int applicationHeight;
    private int imagesPerRow;
    private int imagesPerCol;
    private ImageLocalizerManager imageLocalizerManager;
    private SpectroscopyLocalizerManager spectroscopyLocalizerManager;
    private AttributeListFunctionalGroupsTableModelOneFrame modelOfCurrentAttributesForCurrentFrameBrowser;
    private AttributeListTableBrowser tableOfCurrentAttributesForCurrentFrameBrowser;
    private AttributeListFunctionalGroupsTableModelAllFrames modelOfCurrentAttributesForAllFramesBrowser;
    private AttributeListTableBrowser tableOfCurrentAttributesForAllFramesBrowser;
    private DicomDirectory currentDicomDirectory;
    private OurFrameSelectionChangeListener mainPanelFrameSelectionChangeListener;
    private OurFrameSortOrderChangeListener mainPanelFrameSortOrderChangeListener;
    private int currentSourceIndex;
    private int[] currentSourceSortOrder;
    private JTabbedPane browserPane;
    private JPanel displayControlsPanel;
    private JPanel dicomdirControlsPanel;
    private JPanel databaseControlsPanel;
    private JPanel queryControlsPanel;
    private JPanel spectroscopyControlsPanel;
    private SourceImageVOILUTSelectorPanel sourceImageVOILUTSelectorPanel;
    private OurBrowserPaneChangeListener ourBrowserPaneChangeListener;
    private QueryInformationModel currentRemoteQueryInformationModel;
    private AttributeList currentRemoteQueryFilter;
    private QueryTreeRecord currentRemoteQuerySelectionQueryTreeRecord;
    private AttributeList currentRemoteQuerySelectionUniqueKeys;
    private Attribute currentRemoteQuerySelectionUniqueKey;
    private String currentRemoteQuerySelectionRetrieveAE;
    private String currentRemoteQuerySelectionLevel;
    private Vector currentFilePathSelections;
    private String currentlyDisplayedInstanceFilePath;
    private AttributeList currentAttributeListForDatabaseImport;
    private TreeMap backgroundImageListMappedToFilenames = null;
    private TreeMap referenceImageListMappedToFilenames = null;
    private JPanel referenceImagePanelForImages = null;
    private JPanel referenceImagePanelForSpectra = null;
    private ButtonGroup attributeTreeSortOrderButtons = new ButtonGroup();

    protected void createGUI() {
        this.setBackground(Color.lightGray);
        this.setInternationalizedFontsForGUI();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (DicomImageViewer.this.databaseInformationModel != null) {
                    DicomImageViewer.this.databaseInformationModel.close();
                }
                DicomImageViewer.this.dispose();
                System.exit(0);
            }
        });
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == 'K') {
            Rectangle rectangle = this.getBounds();
            File file = this.takeSnapShot(rectangle);
            System.err.println("Snapshot to file " + file);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.requestFocus();
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    private void createTableOfCurrentAttributesForCurrentFrameBrowser() {
        HashSet<AttributeTag> hashSet = new HashSet<AttributeTag>();
        hashSet.add(TagFromName.FileMetaInformationGroupLength);
        hashSet.add(TagFromName.ImplementationVersionName);
        hashSet.add(TagFromName.SourceApplicationEntityTitle);
        this.modelOfCurrentAttributesForCurrentFrameBrowser = new AttributeListFunctionalGroupsTableModelOneFrame(null, null, hashSet);
        this.tableOfCurrentAttributesForCurrentFrameBrowser = new AttributeListTableBrowser(this.modelOfCurrentAttributesForCurrentFrameBrowser);
        this.tableOfCurrentAttributesForCurrentFrameBrowser.setAutoResizeMode(0);
    }

    private AttributeListTableBrowser getTableOfCurrentAttributesForCurrentFrameBrowser() {
        return this.tableOfCurrentAttributesForCurrentFrameBrowser;
    }

    private AttributeListFunctionalGroupsTableModelOneFrame getModelOfCurrentAttributesForCurrentFrameBrowser() {
        return this.modelOfCurrentAttributesForCurrentFrameBrowser;
    }

    private void createTableOfCurrentAttributesForAllFramesBrowser() {
        HashSet hashSet = null;
        this.modelOfCurrentAttributesForAllFramesBrowser = new AttributeListFunctionalGroupsTableModelAllFrames(null, null, hashSet);
        this.tableOfCurrentAttributesForAllFramesBrowser = new AttributeListTableBrowser(this.modelOfCurrentAttributesForAllFramesBrowser);
        this.tableOfCurrentAttributesForAllFramesBrowser.setAutoResizeMode(0);
    }

    private AttributeListTableBrowser getTableOfCurrentAttributesForAllFramesBrowser() {
        return this.tableOfCurrentAttributesForAllFramesBrowser;
    }

    private AttributeListFunctionalGroupsTableModelAllFrames getModelOfCurrentAttributesForAllFramesBrowser() {
        return this.modelOfCurrentAttributesForAllFramesBrowser;
    }

    private GeometryOfVolume getNewGeometryOfVolume(AttributeList attributeList) {
        GeometryOfVolumeFromAttributeList geometryOfVolumeFromAttributeList = null;
        try {
            geometryOfVolumeFromAttributeList = new GeometryOfVolumeFromAttributeList(attributeList);
        }
        catch (Throwable throwable) {
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent(throwable.toString()));
            throwable.printStackTrace(System.err);
        }
        return geometryOfVolumeFromAttributeList;
    }

    private SpectroscopyVolumeLocalization getNewSpectroscopyVolumeLocalization(AttributeList attributeList) {
        SpectroscopyVolumeLocalization spectroscopyVolumeLocalization = null;
        try {
            spectroscopyVolumeLocalization = new SpectroscopyVolumeLocalization(attributeList);
        }
        catch (DicomException dicomException) {
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent(dicomException.toString()));
            dicomException.printStackTrace(System.err);
        }
        return spectroscopyVolumeLocalization;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadBackgroundImageForSpectra(String string) {
        AttributeList attributeList = new AttributeList();
        SourceImage sourceImage = null;
        try {
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Loading background image ..."));
            File file = FileUtilities.getFileFromNameInsensitiveToCaseIfNecessary(string);
            DicomInputStream dicomInputStream = new DicomInputStream(file);
            attributeList.read(dicomInputStream);
            dicomInputStream.close();
            String string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPClassUID);
            if (SOPClass.isImageStorage(string2)) {
                sourceImage = new SourceImage(attributeList);
            }
        }
        catch (Exception exception) {
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent(exception.toString()));
            exception.printStackTrace(System.err);
        }
        finally {
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Done.                                                   "));
        }
        if (sourceImage != null) {
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new SourceImageSelectionChangeEvent(WellKnownContext.SPECTROSCOPYBACKGROUNDIMAGE, sourceImage, null, 0, attributeList, this.getNewGeometryOfVolume(attributeList)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadReferenceImagePanel(String string, JPanel jPanel, boolean bl) {
        Object object;
        Object object2;
        AttributeList attributeList = new AttributeList();
        SourceImage sourceImage = null;
        try {
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Loading referenced image ..."));
            object2 = FileUtilities.getFileFromNameInsensitiveToCaseIfNecessary(string);
            object = new DicomInputStream((File)object2);
            attributeList.read((DicomInputStream)object);
            ((FilterInputStream)object).close();
            String string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPClassUID);
            if (SOPClass.isImageStorage(string2)) {
                sourceImage = new SourceImage(attributeList);
            }
        }
        catch (Exception exception) {
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent(exception.toString()));
            exception.printStackTrace(System.err);
        }
        finally {
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Done.                                                   "));
        }
        if (sourceImage != null && sourceImage.getNumberOfBufferedImages() > 0) {
            object2 = this.getNewGeometryOfVolume(attributeList);
            object = new SingleImagePanel(sourceImage, WellKnownContext.REFERENCEPANEL, (GeometryOfVolume)object2);
            ((SingleImagePanel)object).setOrientationAnnotations(new OrientationAnnotations(attributeList, (GeometryOfVolume)object2), "SansSerif", 0, 8, Color.pink);
            SingleImagePanel.deconstructAllSingleImagePanelsInContainer(jPanel);
            jPanel.removeAll();
            jPanel.add((Component)object);
            if (bl) {
                this.spectroscopyLocalizerManager.setReferenceImagePanel((SingleImagePanel)object);
            } else {
                this.imageLocalizerManager.setReferenceImagePanel((SingleImagePanel)object);
            }
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new SourceImageSelectionChangeEvent(WellKnownContext.REFERENCEPANEL, sourceImage, null, 0, attributeList, (GeometryOfVolume)object2));
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new FrameSelectionChangeEvent(WellKnownContext.MAINPANEL, this.currentSourceIndex));
        }
    }

    private void loadMultiPanelWithImage(JPanel jPanel, SourceImage sourceImage, AttributeList attributeList) {
        if (sourceImage != null && sourceImage.getNumberOfBufferedImages() > 0) {
            GeometryOfVolume geometryOfVolume = this.getNewGeometryOfVolume(attributeList);
            SingleImagePanel singleImagePanel = new SingleImagePanel(sourceImage, WellKnownContext.MAINPANEL, geometryOfVolume);
            singleImagePanel.setDemographicAndTechniqueAnnotations(new DemographicAndTechniqueAnnotations(attributeList, geometryOfVolume), "SansSerif", 0, 10, Color.pink);
            singleImagePanel.setOrientationAnnotations(new OrientationAnnotations(attributeList, geometryOfVolume), "SansSerif", 0, 20, Color.pink);
            this.sourceImageVOILUTSelectorPanel.sendEventCorrespondingToCurrentButtonState();
            SingleImagePanel.deconstructAllSingleImagePanelsInContainer(jPanel);
            SpectraPanel.deconstructAllSpectraPanelsInContainer(jPanel);
            jPanel.removeAll();
            jPanel.add(singleImagePanel);
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new SourceImageSelectionChangeEvent(WellKnownContext.MAINPANEL, sourceImage, null, 0, attributeList, geometryOfVolume));
        }
    }

    private Dimension loadMultiPanelWithSpectra(JPanel jPanel, SourceSpectra sourceSpectra, AttributeList attributeList) {
        Dimension dimension = null;
        if (sourceSpectra != null) {
            float[][] fArray = sourceSpectra.getSpectra();
            GeometryOfVolume geometryOfVolume = this.getNewGeometryOfVolume(attributeList);
            SpectroscopyVolumeLocalization spectroscopyVolumeLocalization = this.getNewSpectroscopyVolumeLocalization(attributeList);
            SpectraPanel spectraPanel = new SpectraPanel(fArray, sourceSpectra.getRows(), sourceSpectra.getColumns(), sourceSpectra.getMinimum(), sourceSpectra.getMaximum(), geometryOfVolume, spectroscopyVolumeLocalization, WellKnownContext.MAINPANEL, WellKnownContext.SPECTROSCOPYBACKGROUNDIMAGE);
            SingleImagePanel.deconstructAllSingleImagePanelsInContainer(jPanel);
            SpectraPanel.deconstructAllSpectraPanelsInContainer(jPanel);
            jPanel.removeAll();
            jPanel.add(spectraPanel);
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new SourceSpectrumSelectionChangeEvent(WellKnownContext.MAINPANEL, fArray, fArray.length, null, 0, attributeList, geometryOfVolume, spectroscopyVolumeLocalization));
        }
        return dimension;
    }

    private void setCurrentRemoteQueryInformationModel(String string, JTabbedPane jTabbedPane, int n) {
        this.currentRemoteQueryInformationModel = null;
        String string2 = "";
        if (string != null && string.length() > 0 && this.networkApplicationProperties != null && this.networkApplicationInformation != null) {
            try {
                String string3 = this.networkApplicationProperties.getCallingAETitle();
                String string4 = this.networkApplicationInformation.getApplicationEntityTitleFromLocalName(string);
                PresentationAddress presentationAddress = this.networkApplicationInformation.getApplicationEntityMap().getPresentationAddress(string4);
                if (presentationAddress == null) {
                    throw new Exception("For remote query AE <" + string + ">, presentationAddress cannot be determined");
                }
                String string5 = presentationAddress.getHostname();
                int n2 = presentationAddress.getPort();
                String string6 = this.networkApplicationInformation.getApplicationEntityMap().getQueryModel(string4);
                int n3 = this.networkApplicationProperties.getQueryDebugLevel();
                if (!NetworkApplicationProperties.isStudyRootQueryModel(string6) && string6 != null) {
                    throw new Exception("For remote query AE <" + string + ">, query model " + string6 + " not supported");
                }
                this.currentRemoteQueryInformationModel = new StudyRootQueryInformationModel(string5, n2, string4, string3, n3);
                string2 = ":" + string;
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
        if (jTabbedPane != null) {
            jTabbedPane.setTitleAt(n, "Remote" + string2);
        }
    }

    private QueryInformationModel getCurrentRemoteQueryInformationModel() {
        return this.currentRemoteQueryInformationModel;
    }

    private void setCurrentRemoteQueryFilter(AttributeList attributeList) {
        this.currentRemoteQueryFilter = attributeList;
    }

    private AttributeList getCurrentRemoteQueryFilter() {
        return this.currentRemoteQueryFilter;
    }

    private void initializeCurrentRemoteQueryFilter() {
        AttributeList attributeList = new AttributeList();
        this.setCurrentRemoteQueryFilter(attributeList);
        String[] stringArray = new String[]{"ISO_IR 100"};
        SpecificCharacterSet specificCharacterSet = new SpecificCharacterSet(stringArray);
        AttributeTag attributeTag = TagFromName.PatientName;
        Attribute attribute = new PersonNameAttribute(attributeTag, specificCharacterSet);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.PatientID;
        attribute = new ShortStringAttribute(attributeTag, specificCharacterSet);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.PatientBirthDate;
        attribute = new DateAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.PatientSex;
        attribute = new CodeStringAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.PatientBirthTime;
        attribute = new TimeAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.PatientComments;
        attribute = new LongTextAttribute(attributeTag, specificCharacterSet);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.StudyID;
        attribute = new ShortStringAttribute(attributeTag, specificCharacterSet);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.StudyDescription;
        attribute = new LongStringAttribute(attributeTag, specificCharacterSet);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.OtherStudyNumbers;
        attribute = new IntegerStringAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.PerformedProcedureStepID;
        attribute = new ShortStringAttribute(attributeTag, specificCharacterSet);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.PerformedProcedureStepStartDate;
        attribute = new DateAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.PerformedProcedureStepStartTime;
        attribute = new TimeAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.SOPClassesInStudy;
        attribute = new UniqueIdentifierAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.ModalitiesInStudy;
        attribute = new CodeStringAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.StudyDate;
        attribute = new DateAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.StudyTime;
        attribute = new TimeAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.ReferringPhysicianName;
        attribute = new PersonNameAttribute(attributeTag, specificCharacterSet);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.AccessionNumber;
        attribute = new ShortStringAttribute(attributeTag, specificCharacterSet);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.PhysicianOfRecord;
        attribute = new PersonNameAttribute(attributeTag, specificCharacterSet);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.PhysicianReadingStudy;
        attribute = new PersonNameAttribute(attributeTag, specificCharacterSet);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.AdmittingDiagnosesDescription;
        attribute = new LongStringAttribute(attributeTag, specificCharacterSet);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.PatientAge;
        attribute = new AgeStringAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.PatientSize;
        attribute = new DecimalStringAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.PatientWeight;
        attribute = new DecimalStringAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.Occupation;
        attribute = new ShortStringAttribute(attributeTag, specificCharacterSet);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.AdditionalPatientHistory;
        attribute = new LongTextAttribute(attributeTag, specificCharacterSet);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.SeriesDescription;
        attribute = new LongStringAttribute(attributeTag, specificCharacterSet);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.SeriesNumber;
        attribute = new IntegerStringAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.Modality;
        attribute = new CodeStringAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.SeriesDate;
        attribute = new DateAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.SeriesTime;
        attribute = new TimeAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.PerformingPhysicianName;
        attribute = new PersonNameAttribute(attributeTag, specificCharacterSet);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.ProtocolName;
        attribute = new LongStringAttribute(attributeTag, specificCharacterSet);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.OperatorName;
        attribute = new PersonNameAttribute(attributeTag, specificCharacterSet);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.Laterality;
        attribute = new CodeStringAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.BodyPartExamined;
        attribute = new CodeStringAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.Manufacturer;
        attribute = new LongStringAttribute(attributeTag, specificCharacterSet);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.ManufacturerModelName;
        attribute = new LongStringAttribute(attributeTag, specificCharacterSet);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.StationName;
        attribute = new ShortStringAttribute(attributeTag, specificCharacterSet);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.InstitutionName;
        attribute = new LongStringAttribute(attributeTag, specificCharacterSet);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.InstitutionalDepartmentName;
        attribute = new LongStringAttribute(attributeTag, specificCharacterSet);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.InstanceNumber;
        attribute = new IntegerStringAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.ImageComments;
        attribute = new LongTextAttribute(attributeTag, specificCharacterSet);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.ContentDate;
        attribute = new DateAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.ContentTime;
        attribute = new TimeAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.ImageType;
        attribute = new CodeStringAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.AcquisitionNumber;
        attribute = new IntegerStringAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.AcquisitionDate;
        attribute = new DateAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.AcquisitionTime;
        attribute = new TimeAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.AcquisitionDateTime;
        attribute = new DateTimeAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.DerivationDescription;
        attribute = new ShortTextAttribute(attributeTag, specificCharacterSet);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.QualityControlImage;
        attribute = new CodeStringAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.BurnedInAnnotation;
        attribute = new CodeStringAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.LossyImageCompression;
        attribute = new CodeStringAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.LossyImageCompressionRatio;
        attribute = new DecimalStringAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.LossyImageCompressionMethod;
        attribute = new CodeStringAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.ContrastBolusAgent;
        attribute = new LongStringAttribute(attributeTag, specificCharacterSet);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.NumberOfFrames;
        attribute = new IntegerStringAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.Rows;
        attribute = new UnsignedShortAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.Columns;
        attribute = new UnsignedShortAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.StudyInstanceUID;
        attribute = new UniqueIdentifierAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.SeriesInstanceUID;
        attribute = new UniqueIdentifierAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.SOPInstanceUID;
        attribute = new UniqueIdentifierAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.SOPClassUID;
        attribute = new UniqueIdentifierAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        try {
            attributeTag = TagFromName.SpecificCharacterSet;
            attribute = new CodeStringAttribute(attributeTag);
            attributeList.put(attributeTag, attribute);
            attribute.addValue(stringArray[0]);
        }
        catch (DicomException dicomException) {
            dicomException.printStackTrace(System.err);
        }
        attributeTag = TagFromName.NumberOfStudyRelatedInstances;
        attribute = new IntegerStringAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.NumberOfStudyRelatedSeries;
        attribute = new IntegerStringAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.NumberOfSeriesRelatedInstances;
        attribute = new IntegerStringAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
    }

    private void setCurrentRemoteQuerySelection(AttributeList attributeList, Attribute attribute, AttributeList attributeList2) {
        Object object;
        this.currentRemoteQuerySelectionUniqueKeys = attributeList;
        this.currentRemoteQuerySelectionUniqueKey = attribute;
        this.currentRemoteQuerySelectionRetrieveAE = null;
        if (attributeList2 != null && (object = attributeList2.get(TagFromName.RetrieveAETitle)) != null) {
            this.currentRemoteQuerySelectionRetrieveAE = ((Attribute)object).getSingleStringValueOrNull();
        }
        if (this.currentRemoteQuerySelectionRetrieveAE == null && (object = this.getCurrentRemoteQueryInformationModel()) != null) {
            this.currentRemoteQuerySelectionRetrieveAE = ((QueryInformationModel)object).getCalledAETitle();
        }
        this.currentRemoteQuerySelectionLevel = null;
        if (attributeList2 != null && (object = attributeList2.get(TagFromName.QueryRetrieveLevel)) != null) {
            this.currentRemoteQuerySelectionLevel = ((Attribute)object).getSingleStringValueOrNull();
        }
        if (this.currentRemoteQuerySelectionLevel == null) {
            if (attribute != null && (object = attribute.getTag()) != null) {
                if (((AttributeTag)object).equals(TagFromName.PatientID)) {
                    this.currentRemoteQuerySelectionLevel = "PATIENT";
                } else if (((AttributeTag)object).equals(TagFromName.StudyInstanceUID)) {
                    this.currentRemoteQuerySelectionLevel = "STUDY";
                } else if (((AttributeTag)object).equals(TagFromName.SeriesInstanceUID)) {
                    this.currentRemoteQuerySelectionLevel = "SERIES";
                } else if (((AttributeTag)object).equals(TagFromName.SOPInstanceUID)) {
                    this.currentRemoteQuerySelectionLevel = "IMAGE";
                }
            }
            System.err.println("DicomImageViewer.setCurrentRemoteQuerySelection(): Guessed missing currentRemoteQuerySelectionLevel to be " + this.currentRemoteQuerySelectionLevel);
        }
    }

    private QueryTreeRecord getCurrentRemoteQuerySelectionQueryTreeRecord() {
        return this.currentRemoteQuerySelectionQueryTreeRecord;
    }

    private void setCurrentRemoteQuerySelectionQueryTreeRecord(QueryTreeRecord queryTreeRecord) {
        this.currentRemoteQuerySelectionQueryTreeRecord = queryTreeRecord;
    }

    private AttributeList getCurrentRemoteQuerySelectionUniqueKeys() {
        return this.currentRemoteQuerySelectionUniqueKeys;
    }

    private Attribute getCurrentRemoteQuerySelectionUniqueKey() {
        return this.currentRemoteQuerySelectionUniqueKey;
    }

    private String getCurrentRemoteQuerySelectionRetrieveAE() {
        return this.currentRemoteQuerySelectionRetrieveAE;
    }

    private String getCurrentRemoteQuerySelectionLevel() {
        return this.currentRemoteQuerySelectionLevel;
    }

    private void setCurrentFilePathSelection(Vector vector) {
        this.currentFilePathSelections = vector;
    }

    private String getCurrentFilePathSelection() {
        return this.currentFilePathSelections != null && this.currentFilePathSelections.size() > 0 ? (String)this.currentFilePathSelections.get(0) : null;
    }

    private Vector getCurrentFilePathSelections() {
        return this.currentFilePathSelections;
    }

    private void setCurrentlyDisplayedInstanceFilePath(String string) {
        this.currentlyDisplayedInstanceFilePath = string;
    }

    private String getCurrentlyDisplayedInstanceFilePath() {
        return this.currentlyDisplayedInstanceFilePath;
    }

    private void setAttributeListForDatabaseImport(AttributeList attributeList) {
        this.currentAttributeListForDatabaseImport = attributeList;
    }

    private AttributeList getAttributeListForDatabaseImport() {
        return this.currentAttributeListForDatabaseImport;
    }

    private String loadDicomFileOrDirectory(String string, DicomImageViewer dicomImageViewer, JPanel jPanel, JPanel jPanel2, JList jList, JPanel jPanel3, JList jList2, JList jList3, JScrollPane jScrollPane, JScrollPane jScrollPane2, JScrollPane jScrollPane3, JScrollPane jScrollPane4, String string2) {
        SingleImagePanel.deconstructAllSingleImagePanelsInContainer(jPanel);
        SpectraPanel.deconstructAllSpectraPanelsInContainer(jPanel);
        jPanel.removeAll();
        jPanel.repaint();
        SingleImagePanel.deconstructAllSingleImagePanelsInContainer(jPanel2);
        jPanel2.removeAll();
        jPanel2.repaint();
        SingleImagePanel.deconstructAllSingleImagePanelsInContainer(jPanel3);
        jPanel3.removeAll();
        jPanel3.repaint();
        this.imageLocalizerManager.reset();
        this.spectroscopyLocalizerManager.reset();
        jScrollPane2.setViewportView(null);
        jScrollPane2.repaint();
        jScrollPane3.setViewportView(null);
        jScrollPane3.repaint();
        jScrollPane4.setViewportView(null);
        jScrollPane4.repaint();
        this.setAttributeListForDatabaseImport(null);
        this.setCurrentlyDisplayedInstanceFilePath(null);
        if (string != null) {
            Cursor cursor = dicomImageViewer.getCursor();
            dicomImageViewer.setCursor(Cursor.getPredefinedCursor(3));
            try {
                String string3;
                System.err.println("Open: " + string);
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Reading and parsing DICOM file ..."));
                File file = FileUtilities.getFileFromNameInsensitiveToCaseIfNecessary(string);
                string = file.getAbsolutePath();
                DicomInputStream dicomInputStream = new DicomInputStream(file);
                AttributeList attributeList = new AttributeList();
                attributeList.read(dicomInputStream);
                dicomInputStream.close();
                new AttributeTreeBrowser(attributeList, jScrollPane3);
                Attribute attribute = attributeList.get(TagFromName.MediaStorageSOPClassUID);
                String string4 = string3 = attribute != null && attribute.getVM() == 1 ? attribute.getStringValues()[0] : null;
                if (string3 == null) {
                    attribute = attributeList.get(TagFromName.SOPClassUID);
                    String string5 = string3 = attribute != null && attribute.getVM() == 1 ? attribute.getStringValues()[0] : null;
                }
                if (SOPClass.isDirectory(string3)) {
                    ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Building tree from DICOMDIR ..."));
                    OurDicomDirectoryBrowser ourDicomDirectoryBrowser = new OurDicomDirectoryBrowser(attributeList, string2, dicomImageViewer, jPanel, jPanel2, jList, jPanel3, jList2, jList3, jScrollPane, jScrollPane2, jScrollPane3, jScrollPane4);
                    this.currentDicomDirectory = ourDicomDirectoryBrowser.getDicomDirectory();
                    ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new BrowserPaneChangeEvent(WellKnownContext.MAINPANEL, 2));
                } else if (SOPClass.isImageStorage(string3)) {
                    ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Building images ..."));
                    SourceImage sourceImage = new SourceImage(attributeList);
                    ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Loading images and attributes ..."));
                    this.currentSourceIndex = 0;
                    this.currentSourceSortOrder = null;
                    this.getModelOfCurrentAttributesForCurrentFrameBrowser().initializeModelFromAttributeList(attributeList);
                    this.getModelOfCurrentAttributesForCurrentFrameBrowser().selectValuesForDifferentFrame(this.currentSourceIndex);
                    this.getTableOfCurrentAttributesForCurrentFrameBrowser().setColumnWidths();
                    jScrollPane2.setViewportView(this.getTableOfCurrentAttributesForCurrentFrameBrowser());
                    this.getModelOfCurrentAttributesForAllFramesBrowser().initializeModelFromAttributeList(attributeList);
                    this.getTableOfCurrentAttributesForAllFramesBrowser().setColumnWidths();
                    jScrollPane4.setViewportView(this.getTableOfCurrentAttributesForAllFramesBrowser());
                    this.loadMultiPanelWithImage(jPanel, sourceImage, attributeList);
                    this.referenceImageListMappedToFilenames = this.getImageListMappedToFilenamesForReferenceOrBackground(attributeList, false);
                    jList.setListData(this.referenceImageListMappedToFilenames.keySet().toArray());
                    ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new BrowserPaneChangeEvent(WellKnownContext.MAINPANEL, 1));
                    this.setAttributeListForDatabaseImport(attributeList);
                    this.setCurrentlyDisplayedInstanceFilePath(string);
                    Vector<String> vector = new Vector<String>();
                    vector.add(string);
                    this.setCurrentFilePathSelection(vector);
                } else if (SOPClass.isSpectroscopy(string3)) {
                    ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Building spectra ..."));
                    SourceSpectra sourceSpectra = new SourceSpectra(attributeList);
                    ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Loading spectra and attributes ..."));
                    this.currentSourceIndex = 0;
                    this.currentSourceSortOrder = null;
                    this.getModelOfCurrentAttributesForCurrentFrameBrowser().initializeModelFromAttributeList(attributeList);
                    this.getModelOfCurrentAttributesForCurrentFrameBrowser().selectValuesForDifferentFrame(this.currentSourceIndex);
                    this.getTableOfCurrentAttributesForCurrentFrameBrowser().setColumnWidths();
                    jScrollPane2.setViewportView(this.getTableOfCurrentAttributesForCurrentFrameBrowser());
                    this.getModelOfCurrentAttributesForAllFramesBrowser().initializeModelFromAttributeList(attributeList);
                    this.getTableOfCurrentAttributesForAllFramesBrowser().setColumnWidths();
                    jScrollPane4.setViewportView(this.getTableOfCurrentAttributesForAllFramesBrowser());
                    this.loadMultiPanelWithSpectra(jPanel, sourceSpectra, attributeList);
                    this.referenceImageListMappedToFilenames = this.getImageListMappedToFilenamesForReferenceOrBackground(attributeList, false);
                    jList2.setListData(this.referenceImageListMappedToFilenames.keySet().toArray());
                    this.backgroundImageListMappedToFilenames = this.getImageListMappedToFilenamesForReferenceOrBackground(attributeList, true);
                    jList3.setListData(this.backgroundImageListMappedToFilenames.keySet().toArray());
                    ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new BrowserPaneChangeEvent(WellKnownContext.MAINPANEL, 4));
                    this.setAttributeListForDatabaseImport(attributeList);
                    this.setCurrentlyDisplayedInstanceFilePath(string);
                    Vector<String> vector = new Vector<String>();
                    vector.add(string);
                    this.setCurrentFilePathSelection(vector);
                } else {
                    if (SOPClass.isNonImageStorage(string3)) {
                        throw new DicomException("unsupported storage SOP Class " + string3);
                    }
                    throw new DicomException("unsupported SOP Class " + string3);
                }
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Done.                                                   "));
            }
            catch (Exception exception) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent(exception.toString()));
                exception.printStackTrace(System.err);
            }
            dicomImageViewer.setCursor(cursor);
        }
        return string2;
    }

    private String loadDicomFileOrDirectoryCallingChooserIfRequired(String string, DicomImageViewer dicomImageViewer, JPanel jPanel, JPanel jPanel2, JList jList, JPanel jPanel3, JList jList2, JList jList3, JScrollPane jScrollPane, JScrollPane jScrollPane2, JScrollPane jScrollPane3, JScrollPane jScrollPane4, String string2) {
        JFileChooser jFileChooser;
        if (string == null && (jFileChooser = new JFileChooser(string2)).showOpenDialog(null) == 0) {
            string = jFileChooser.getSelectedFile().getAbsolutePath();
            string2 = jFileChooser.getCurrentDirectory().getAbsolutePath();
        }
        return this.loadDicomFileOrDirectory(string, dicomImageViewer, jPanel, jPanel2, jList, jPanel3, jList2, jList3, jScrollPane, jScrollPane2, jScrollPane3, jScrollPane4, string2);
    }

    private void sendDicomFileOverDicomNetwork(String string, String string2, String string3, int n, String string4, String string5, String string6, String string7, DicomImageViewer dicomImageViewer) {
        if (string != null) {
            Cursor cursor = dicomImageViewer.getCursor();
            dicomImageViewer.setCursor(Cursor.getPredefinedCursor(3));
            try {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Sending image " + string + " to " + string2 + " ..."));
                int n2 = this.networkApplicationProperties.getStorageSCUDebugLevel();
                int n3 = this.networkApplicationProperties.getStorageSCUCompressionLevel();
                new StorageSOPClassSCU(string3, n, string4, string5, string, string6, string7, n3, n2);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Done.                                                   "));
            dicomImageViewer.setCursor(cursor);
        }
    }

    private final TreeMap getImageListMappedToFilenamesForReferenceOrBackground(AttributeList attributeList, boolean bl) {
        TreeMap<Object, String> treeMap = new TreeMap<Object, String>();
        String string = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.FrameOfReferenceUID);
        double[] dArray = GeometryOfVolumeFromAttributeList.getImageOrientationPatientFromAttributeList(attributeList);
        if (string != null) {
            String string2;
            Object object;
            String string3;
            Object object2;
            AttributeList attributeList2;
            int n;
            AbstractList abstractList;
            if (this.databaseInformationModel != null) {
                try {
                    abstractList = this.databaseInformationModel.findAllAttributeValuesForAllRecordsForThisInformationEntityWithMatchingParent(InformationEntity.INSTANCE, InformationEntity.SERIES, "FrameOfReferenceUID", string);
                    if (abstractList != null && ((ArrayList)abstractList).size() > 0) {
                        for (n = 0; n < ((ArrayList)abstractList).size(); ++n) {
                            attributeList2 = null;
                            object2 = (Map)((ArrayList)abstractList).get(n);
                            if (object2 == null) continue;
                            string3 = DescriptionFactory.makeImageDescription((Map)object2);
                            object = (String)object2.get("SOPINSTANCEUID");
                            string2 = (String)object2.get("SOPCLASSUID");
                            double[] dArray2 = null;
                            String string4 = (String)object2.get("IMAGEORIENTATIONPATIENT");
                            if (string4 != null) {
                                dArray2 = FloatFormatter.fromString(string4, 6, '\\');
                            }
                            if (bl && (dArray == null || dArray.length != 6 || dArray2 == null || dArray2.length != 6 || !ArrayCopyUtilities.arraysAreEqual(dArray, dArray2)) || (string4 = (String)object2.get(this.databaseInformationModel.localFileNameColumnName(InformationEntity.INSTANCE).toUpperCase())) == null || string2 == null || !SOPClass.isImageStorage(string2) || treeMap.containsKey(string3)) continue;
                            treeMap.put(string3, string4);
                        }
                    }
                }
                catch (DicomException dicomException) {
                    dicomException.printStackTrace(System.err);
                }
            }
            if (this.currentDicomDirectory != null && (abstractList = this.currentDicomDirectory.findAllImagesForFrameOfReference(string)) != null) {
                for (n = 0; n < ((Vector)abstractList).size(); ++n) {
                    attributeList2 = (AttributeList)((Vector)abstractList).get(n);
                    if (attributeList2 == null) continue;
                    object2 = DescriptionFactory.makeImageDescription(attributeList2);
                    string3 = Attribute.getSingleStringValueOrNull(attributeList2, TagFromName.ReferencedSOPInstanceUIDInFile);
                    object = Attribute.getDoubleValues(attributeList2, TagFromName.ImageOrientationPatient);
                    if (string3 == null) continue;
                    string2 = null;
                    try {
                        string2 = this.currentDicomDirectory.getReferencedFileNameForSOPInstanceUID(string3);
                    }
                    catch (DicomException dicomException) {
                        // empty catch block
                    }
                    if (bl && (dArray == null || dArray.length != 6 || object == null || ((double[])object).length != 6 || !ArrayCopyUtilities.arraysAreEqual(dArray, object)) || string2 == null || treeMap.containsKey(object2)) continue;
                    treeMap.put(object2, string2);
                }
            }
        }
        return treeMap;
    }

    private String showInputDialogToSelectNetworkTargetByLocalApplicationEntityName(String string, String string2, String string3) {
        Set set;
        String string4 = string3;
        if (this.networkApplicationProperties != null && (set = this.networkApplicationInformation.getListOfLocalNamesOfApplicationEntities()) != null) {
            Object[] objectArray = new String[set.size()];
            int n = 0;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                objectArray[n++] = (String)iterator.next();
            }
            string4 = (String)JOptionPane.showInputDialog(null, string, string2, 3, null, objectArray, string4);
        }
        return string4;
    }

    private void performRetrieve(AttributeList attributeList, String string, String string2) {
        try {
            AttributeList attributeList2 = new AttributeList();
            if (attributeList != null) {
                attributeList2.putAll(attributeList);
                Object object = TagFromName.QueryRetrieveLevel;
                CodeStringAttribute codeStringAttribute = new CodeStringAttribute((AttributeTag)object);
                ((Attribute)codeStringAttribute).addValue(string);
                attributeList2.put((AttributeTag)object, codeStringAttribute);
                object = this.getCurrentRemoteQueryInformationModel();
                ((QueryInformationModel)object).performHierarchicalMoveFrom(attributeList2, string2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    private void copyFileAndImportToDatabase(DatabaseInformationModel databaseInformationModel, AttributeList attributeList, String string, File file) throws DicomException, IOException {
        String string2 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.SOPInstanceUID);
        if (string2 == null) {
            throw new DicomException("Cannot get SOP Instance UID to make file name for local copy when inserting into database");
        }
        String string3 = this.storedFilePathStrategy.makeReliableStoredFilePathWithFoldersCreated(file, string2).getPath();
        if (string.equals(string3)) {
            System.err.println("DicomImageViewer.copyFileAndImportToDatabase(): input and output filenames identical - presumably copying from our own database back into our own database, so doing nothing");
        } else {
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Copying object ..."));
            CopyStream.copy(new BufferedInputStream(new FileInputStream(string)), new BufferedOutputStream(new FileOutputStream(string3)));
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Inserting into database ..."));
            databaseInformationModel.insertObject(attributeList, string3);
        }
    }

    private void doCommonConstructorStuff(String string, String string2) {
        int n;
        Object object;
        this.mainPanelFrameSortOrderChangeListener = new OurFrameSortOrderChangeListener(WellKnownContext.MAINPANEL);
        this.mainPanelFrameSelectionChangeListener = new OurFrameSelectionChangeListener(WellKnownContext.MAINPANEL);
        this.ourBrowserPaneChangeListener = new OurBrowserPaneChangeListener(WellKnownContext.MAINPANEL);
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.spectroscopyLocalizerManager = new SpectroscopyLocalizerManager();
        this.spectroscopyLocalizerManager.setReferenceSourceImageSelectionContext(WellKnownContext.REFERENCEPANEL);
        this.spectroscopyLocalizerManager.setReferenceImageFrameSelectionContext(WellKnownContext.REFERENCEPANEL);
        this.spectroscopyLocalizerManager.setReferenceImageFrameSortOrderContext(WellKnownContext.REFERENCEPANEL);
        this.spectroscopyLocalizerManager.setSourceSpectrumSelectionContext(WellKnownContext.MAINPANEL);
        this.spectroscopyLocalizerManager.setSpectrumFrameSelectionContext(WellKnownContext.MAINPANEL);
        this.spectroscopyLocalizerManager.setSpectrumFrameSortOrderContext(WellKnownContext.MAINPANEL);
        this.imageLocalizerManager = new ImageLocalizerManager();
        this.imageLocalizerManager.setReferenceSourceImageSelectionContext(WellKnownContext.REFERENCEPANEL);
        this.imageLocalizerManager.setReferenceImageFrameSelectionContext(WellKnownContext.REFERENCEPANEL);
        this.imageLocalizerManager.setReferenceImageFrameSortOrderContext(WellKnownContext.REFERENCEPANEL);
        this.imageLocalizerManager.setMainSourceImageSelectionContext(WellKnownContext.MAINPANEL);
        this.imageLocalizerManager.setMainImageFrameSelectionContext(WellKnownContext.MAINPANEL);
        this.imageLocalizerManager.setMainImageFrameSortOrderContext(WellKnownContext.MAINPANEL);
        Properties properties = this.getProperties();
        this.databaseApplicationProperties = new DatabaseApplicationProperties(properties);
        File file = null;
        if (this.databaseApplicationProperties != null) {
            try {
                file = this.databaseApplicationProperties.getSavedImagesFolderCreatingItIfNecessary();
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
            this.databaseInformationModel = null;
            try {
                this.databaseInformationModel = new PatientStudySeriesConcatenationInstanceModel(DicomImageViewer.makePathToFileInUsersHomeDirectory(this.databaseApplicationProperties.getDatabaseFileName()), this.databaseApplicationProperties.getDatabaseServerName());
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
        try {
            this.networkApplicationProperties = new NetworkApplicationProperties(properties);
        }
        catch (Exception exception) {
            this.networkApplicationProperties = null;
        }
        NetworkApplicationInformationFederated networkApplicationInformationFederated = new NetworkApplicationInformationFederated();
        networkApplicationInformationFederated.startupAllKnownSourcesAndRegister(this.networkApplicationProperties);
        this.networkApplicationInformation = networkApplicationInformationFederated;
        if (this.networkApplicationProperties != null) {
            try {
                int n2 = this.networkApplicationProperties.getListeningPort();
                object = this.networkApplicationProperties.getCalledAETitle();
                int n22 = this.networkApplicationProperties.getStorageSCPDebugLevel();
                int n3 = this.networkApplicationProperties.getQueryDebugLevel();
                new Thread(new StorageSOPClassSCPDispatcher(n2, (String)object, file, this.storedFilePathStrategy, new OurReceivedObjectHandler(), this.databaseInformationModel == null ? null : this.databaseInformationModel.getQueryResponseGeneratorFactory(n3), this.databaseInformationModel == null ? null : this.databaseInformationModel.getRetrieveResponseGeneratorFactory(n3), this.networkApplicationInformation, false, n22)).start();
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
            }
        }
        this.setCurrentFilePathSelection(null);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.applicationWidth = (int)dimension.getWidth() - 20;
        this.applicationHeight = (int)dimension.getHeight() - 70;
        this.imagesPerRow = 1;
        this.imagesPerCol = 1;
        object = this.getContentPane();
        EmptyBorder emptyBorder = (EmptyBorder)BorderFactory.createEmptyBorder();
        final JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(this.imagesPerCol, this.imagesPerRow));
        jPanel.setBackground(Color.black);
        this.referenceImagePanelForImages = new JPanel();
        this.referenceImagePanelForImages.setLayout(new GridLayout(1, 1));
        this.referenceImagePanelForImages.setBackground(Color.black);
        this.referenceImagePanelForImages.setPreferredSize(new Dimension(128, 128));
        this.referenceImagePanelForSpectra = new JPanel();
        this.referenceImagePanelForSpectra.setLayout(new GridLayout(1, 1));
        this.referenceImagePanelForSpectra.setBackground(Color.black);
        this.referenceImagePanelForSpectra.setPreferredSize(new Dimension(128, 128));
        JScrollPane jScrollPane = new JScrollPane();
        this.createTableOfCurrentAttributesForCurrentFrameBrowser();
        jScrollPane.setViewportView(this.getTableOfCurrentAttributesForCurrentFrameBrowser());
        JScrollPane jScrollPane2 = new JScrollPane();
        this.createTableOfCurrentAttributesForAllFramesBrowser();
        jScrollPane2.setViewportView(this.getTableOfCurrentAttributesForAllFramesBrowser());
        this.displayControlsPanel = new JPanel();
        this.displayControlsPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        this.displayControlsPanel.add((Component)jPanel2, "North");
        jPanel2.setLayout(new FlowLayout(1));
        JButton jButton = new JButton("File...");
        jButton.setToolTipText("Choose a DICOM image or spectroscopy file to display or DICOMDIR file to browse");
        jPanel2.add(jButton);
        JButton jButton2 = new JButton("Import");
        jButton2.setToolTipText("Import a copy of displayed image into the local database");
        jPanel2.add(jButton2);
        JButton jButton3 = new JButton("Send...");
        jButton3.setToolTipText("Send displayed image via DICOM network");
        jPanel2.add(jButton3);
        JButton jButton4 = new JButton("XML...");
        jButton4.setToolTipText("Save displayed image attributes to XML file");
        jPanel2.add(jButton4);
        JButton jButton5 = new JButton("Validate...");
        jButton5.setToolTipText("Validate displayed image against standard IOD");
        jPanel2.add(jButton5);
        JComponent jComponent = new JPanel();
        this.displayControlsPanel.add((Component)jComponent, "Center");
        jComponent.setLayout(new BorderLayout());
        JPanel jPanel3 = new SourceImageSortOrderPanel(WellKnownContext.MAINPANEL);
        jComponent.add((Component)jPanel3, "North");
        this.sourceImageVOILUTSelectorPanel = new SourceImageVOILUTSelectorPanel(null);
        jComponent.add((Component)this.sourceImageVOILUTSelectorPanel, "South");
        jPanel3 = new JPanel(new BorderLayout());
        this.displayControlsPanel.add((Component)jPanel3, "South");
        JComponent jComponent2 = new JPanel(new FlowLayout(1));
        jPanel3.add((Component)jComponent2, "Center");
        jComponent2.add(this.referenceImagePanelForImages);
        jComponent = new JList();
        ((JList)jComponent).setVisibleRowCount(4);
        JComponent jComponent3 = new JScrollPane(jComponent);
        jPanel3.add((Component)jComponent3, "North");
        ((JList)jComponent).setSelectionMode(0);
        ((JList)jComponent).addListSelectionListener(new OurReferenceListSelectionListener(this.referenceImagePanelForImages, false));
        this.spectroscopyControlsPanel = new JPanel();
        this.spectroscopyControlsPanel.setLayout(new BorderLayout());
        jPanel3 = new JPanel();
        this.spectroscopyControlsPanel.add((Component)jPanel3, "North");
        jPanel3.setLayout(new FlowLayout(1));
        jComponent2 = new JButton("File...");
        jComponent2.setToolTipText("Choose a DICOM image or spectroscopy file to display or DICOMDIR file to browse");
        jPanel3.add(jComponent2);
        jComponent3 = new JButton("Import");
        jComponent3.setToolTipText("Import a copy of displayed specra into the local database");
        jPanel3.add(jComponent3);
        JButton jButton6 = new JButton("Send...");
        jButton6.setToolTipText("Send display spectra via DICOM network");
        jPanel3.add(jButton6);
        JButton jButton7 = new JButton("XML...");
        jButton7.setToolTipText("Save displayed spectra attributes to XML file");
        jPanel3.add(jButton7);
        JButton jButton8 = new JButton("Validate...");
        jButton8.setToolTipText("Validate displayed spectra against standard IOD");
        jPanel3.add(jButton8);
        SourceSpectrumSortOrderPanel sourceSpectrumSortOrderPanel = new SourceSpectrumSortOrderPanel(WellKnownContext.MAINPANEL);
        this.spectroscopyControlsPanel.add((Component)sourceSpectrumSortOrderPanel, "Center");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        this.spectroscopyControlsPanel.add((Component)jPanel4, "South");
        JComponent jComponent4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)jComponent4, "North");
        JList jList = new JList();
        jList.setVisibleRowCount(4);
        JComponent jComponent5 = new JScrollPane(jList);
        jComponent4.add((Component)jComponent5, "North");
        jList.setSelectionMode(0);
        jList.addListSelectionListener(new OurBackgroundListSelectionListener());
        jComponent4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)jComponent4, "South");
        jComponent5 = new JPanel(new FlowLayout(1));
        jComponent4.add((Component)jComponent5, "Center");
        jComponent5.add(this.referenceImagePanelForSpectra);
        JList jList2 = new JList();
        jList2.setVisibleRowCount(4);
        JComponent jComponent6 = new JScrollPane(jList2);
        jComponent4.add((Component)jComponent6, "North");
        jList2.setSelectionMode(0);
        jList2.addListSelectionListener(new OurReferenceListSelectionListener(this.referenceImagePanelForSpectra, true));
        this.dicomdirControlsPanel = new JPanel();
        this.dicomdirControlsPanel.setLayout(new BorderLayout());
        jPanel4 = new JPanel();
        this.dicomdirControlsPanel.add((Component)jPanel4, "North");
        jPanel4.setLayout(new FlowLayout(1));
        jComponent4 = new JButton("File...");
        jComponent4.setToolTipText("Choose a DICOM image file to display or DICOMDIR file to browse");
        jPanel4.add(jComponent4);
        jComponent5 = new JButton("Import");
        jComponent5.setToolTipText("Import all the images selected into the local database");
        jPanel4.add(jComponent5);
        jComponent6 = new JButton("View");
        jComponent6.setToolTipText("Display the image selected (or first image of the selection)");
        jPanel4.add(jComponent6);
        JButton jButton9 = new JButton("Send...");
        jButton9.setToolTipText("Send all the images selected via DICOM network");
        jPanel4.add(jButton9);
        JScrollPane jScrollPane3 = new JScrollPane();
        this.dicomdirControlsPanel.add((Component)jScrollPane3, "Center");
        this.databaseControlsPanel = new JPanel();
        this.databaseControlsPanel.setLayout(new BorderLayout());
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(1));
        this.databaseControlsPanel.add((Component)jPanel5, "North");
        JButton jButton10 = new JButton("Refresh");
        jButton10.setToolTipText("Query the database to update the browser");
        jPanel5.add(jButton10);
        JButton jButton11 = new JButton("File...");
        jButton11.setToolTipText("Import DICOM files from a DICOMDIR or recursive directory search");
        jPanel5.add(jButton11);
        JButton jButton12 = new JButton("View");
        jButton12.setToolTipText("Display the image selected");
        jPanel5.add(jButton12);
        JButton jButton13 = new JButton("Send...");
        jButton13.setToolTipText("Send all the images selected via DICOM network");
        jPanel5.add(jButton13);
        JScrollPane jScrollPane4 = new JScrollPane();
        this.databaseControlsPanel.add((Component)jScrollPane4, "Center");
        this.queryControlsPanel = new JPanel();
        this.queryControlsPanel.setLayout(new BorderLayout());
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new FlowLayout(1));
        this.queryControlsPanel.add((Component)jPanel6, "North");
        JButton jButton14 = new JButton("Select");
        jButton14.setToolTipText("Select the remote system to use for subsequent queries");
        jPanel6.add(jButton14);
        JButton jButton15 = new JButton("Filter");
        jButton15.setToolTipText("Configure the filter to use for subsequent queries");
        jPanel6.add(jButton15);
        JButton jButton16 = new JButton("Query");
        jButton16.setToolTipText("Query the currently selected remote system to update the browser");
        jPanel6.add(jButton16);
        JButton jButton17 = new JButton("Retrieve");
        jButton17.setToolTipText("Retrieve the selection to the local database");
        jPanel6.add(jButton17);
        JScrollPane jScrollPane5 = new JScrollPane();
        this.queryControlsPanel.add((Component)jScrollPane5, "Center");
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BorderLayout());
        JPanel jPanel8 = new JPanel();
        jPanel7.add((Component)jPanel8, "North");
        jPanel8.setLayout(new FlowLayout(1));
        JScrollPane jScrollPane6 = new JScrollPane();
        jPanel8.add(new JLabel("Sort attributes:"));
        this.attributeTreeSortOrderButtons = new ButtonGroup();
        SortAttributesActionListener sortAttributesActionListener = new SortAttributesActionListener(jScrollPane6);
        JRadioButton jRadioButton = new JRadioButton("by name", true);
        jRadioButton.setActionCommand("NAME");
        jRadioButton.setToolTipText("Sort attributes in tree alphabetically by name");
        jRadioButton.addActionListener(sortAttributesActionListener);
        this.attributeTreeSortOrderButtons.add(jRadioButton);
        jPanel8.add(jRadioButton);
        JRadioButton jRadioButton2 = new JRadioButton("by number", false);
        jRadioButton2.setActionCommand("NUMBER");
        jRadioButton2.setToolTipText("Sort attributes in tree numerically by group and element number");
        jRadioButton2.addActionListener(sortAttributesActionListener);
        this.attributeTreeSortOrderButtons.add(jRadioButton2);
        jPanel8.add(jRadioButton2);
        jPanel7.add((Component)jScrollPane6, "Center");
        this.browserPane = new JTabbedPane();
        this.browserPane.addTab("Local", this.databaseControlsPanel);
        this.browserPane.setToolTipTextAt(0, "Browse the contents of the local database");
        this.browserPane.addTab("Remote", this.queryControlsPanel);
        this.browserPane.setToolTipTextAt(1, "Browse the contents of the local database");
        int n3 = 1;
        this.browserPane.addTab("DICOMDIR", this.dicomdirControlsPanel);
        this.browserPane.setToolTipTextAt(2, "Browse the contents of the currently loaded DICOMDIR");
        this.browserPane.addTab("Image", this.displayControlsPanel);
        this.browserPane.setToolTipTextAt(3, "Controls for the currently displayed image");
        this.browserPane.addTab("Spectra", this.spectroscopyControlsPanel);
        this.browserPane.setToolTipTextAt(4, "Controls for the currently displayed spectra");
        this.browserPane.addTab("Attributes", jPanel7);
        this.browserPane.setToolTipTextAt(5, "Tree of attributes and values for currently displayed image");
        this.browserPane.addTab("Frames", jScrollPane2);
        this.browserPane.setToolTipTextAt(6, "Table of all per-frame varying attributes for this object");
        this.browserPane.setEnabledAt(this.browserPane.indexOfComponent(this.displayControlsPanel), false);
        this.browserPane.setEnabledAt(this.browserPane.indexOfComponent(this.spectroscopyControlsPanel), false);
        final DicomImageViewer dicomImageViewer = this;
        this.browserPane.addChangeListener(new ChangeListener((JList)jComponent, jList2, jList, jScrollPane4, jScrollPane, jScrollPane6, jScrollPane2){
            final /* synthetic */ JList val$displayListOfPossibleReferenceImagesForImages;
            final /* synthetic */ JList val$displayListOfPossibleReferenceImagesForSpectra;
            final /* synthetic */ JList val$displayListOfPossibleBackgroundImagesForSpectra;
            final /* synthetic */ JScrollPane val$databaseTreeScrollPane;
            final /* synthetic */ JScrollPane val$scrollPaneOfCurrentAttributes;
            final /* synthetic */ JScrollPane val$attributeTreeScrollPane;
            final /* synthetic */ JScrollPane val$attributeFrameTableScrollPane;
            {
                this.val$displayListOfPossibleReferenceImagesForImages = jList;
                this.val$displayListOfPossibleReferenceImagesForSpectra = jList2;
                this.val$displayListOfPossibleBackgroundImagesForSpectra = jList3;
                this.val$databaseTreeScrollPane = jScrollPane;
                this.val$scrollPaneOfCurrentAttributes = jScrollPane2;
                this.val$attributeTreeScrollPane = jScrollPane3;
                this.val$attributeFrameTableScrollPane = jScrollPane4;
            }

            public void stateChanged(ChangeEvent changeEvent) {
                JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
                int n = jTabbedPane.getSelectedIndex();
                if (n == DicomImageViewer.this.browserPane.indexOfComponent(DicomImageViewer.this.databaseControlsPanel)) {
                    try {
                        new OurDatabaseTreeBrowser(DicomImageViewer.this.databaseInformationModel, dicomImageViewer, jPanel, DicomImageViewer.this.referenceImagePanelForImages, this.val$displayListOfPossibleReferenceImagesForImages, DicomImageViewer.this.referenceImagePanelForSpectra, this.val$displayListOfPossibleReferenceImagesForSpectra, this.val$displayListOfPossibleBackgroundImagesForSpectra, this.val$databaseTreeScrollPane, this.val$scrollPaneOfCurrentAttributes, this.val$attributeTreeScrollPane, this.val$attributeFrameTableScrollPane);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(System.err);
                    }
                }
            }
        });
        this.setCurrentRemoteQueryInformationModel(properties.getProperty(propertyName_DicomCurrentlySelectedQueryTargetAE), this.browserPane, n3);
        this.initializeCurrentRemoteQueryFilter();
        String string3 = "";
        try {
            string3 = new BufferedReader(new InputStreamReader(DicomImageViewer.class.getResourceAsStream("/BUILDDATE"))).readLine();
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
        }
        this.statusBarManager = new StatusBarManager(string3 + " " + releaseString);
        this.statusBar = this.statusBarManager.getStatusBar();
        String string4 = string2 == null ? null : new File(string2).getParent();
        string4 = this.loadDicomFileOrDirectoryCallingChooserIfRequired(string2, this, jPanel, this.referenceImagePanelForImages, (JList)jComponent, this.referenceImagePanelForSpectra, jList2, jList, jScrollPane3, jScrollPane, jScrollPane6, jScrollPane2, string4);
        if (string4 == null) {
            this.browserPane.setSelectedIndex(-1);
            this.browserPane.setSelectedIndex(this.browserPane.indexOfComponent(this.databaseControlsPanel));
        }
        DicomFileOrDirectoryLoadActionListener dicomFileOrDirectoryLoadActionListener = new DicomFileOrDirectoryLoadActionListener(this, jPanel, this.referenceImagePanelForImages, (JList)jComponent, this.referenceImagePanelForSpectra, jList2, jList, jScrollPane3, jScrollPane, jScrollPane6, jScrollPane2, string4);
        ((AbstractButton)jComponent4).addActionListener(dicomFileOrDirectoryLoadActionListener);
        jButton.addActionListener(dicomFileOrDirectoryLoadActionListener);
        ((AbstractButton)jComponent2).addActionListener(dicomFileOrDirectoryLoadActionListener);
        ImportCurrentlyDisplayedInstanceToDatabaseActionListener importCurrentlyDisplayedInstanceToDatabaseActionListener = new ImportCurrentlyDisplayedInstanceToDatabaseActionListener(this, this.databaseInformationModel, file);
        jButton2.addActionListener(importCurrentlyDisplayedInstanceToDatabaseActionListener);
        ((AbstractButton)jComponent3).addActionListener(importCurrentlyDisplayedInstanceToDatabaseActionListener);
        ((AbstractButton)jComponent5).addActionListener(new ImportFromSelectionToDatabaseActionListener(this, this.databaseInformationModel, file));
        ((AbstractButton)jComponent6).addActionListener(new DicomFileLoadFromSelectionActionListener(this, jPanel, this.referenceImagePanelForImages, (JList)jComponent, this.referenceImagePanelForSpectra, jList2, jList, jScrollPane3, jScrollPane, jScrollPane6, jScrollPane2));
        jButton12.addActionListener(new DicomFileLoadFromSelectionActionListener(this, jPanel, this.referenceImagePanelForImages, (JList)jComponent, this.referenceImagePanelForSpectra, jList2, jList, jScrollPane3, jScrollPane, jScrollPane6, jScrollPane2));
        jButton10.addActionListener(new DatabaseRefreshActionListener(this, this.databaseInformationModel, jPanel, this.referenceImagePanelForImages, (JList)jComponent, this.referenceImagePanelForSpectra, jList2, jList, jScrollPane4, jScrollPane, jScrollPane6, jScrollPane2));
        jButton11.addActionListener(new DatabaseImportFromFilesActionListener(this, file, this.databaseInformationModel, jPanel, this.referenceImagePanelForImages, (JList)jComponent, this.referenceImagePanelForSpectra, jList2, jList, jScrollPane4, jScrollPane, jScrollPane6, jScrollPane2));
        jButton14.addActionListener(new QuerySelectActionListener(this, jScrollPane5, jScrollPane, this.browserPane, n3));
        jButton15.addActionListener(new QueryFilterActionListener(this, jScrollPane5, jScrollPane, this.browserPane, n3));
        jButton16.addActionListener(new QueryRefreshActionListener(this, jScrollPane5, jScrollPane));
        jButton17.addActionListener(new QueryRetrieveActionListener(this));
        NetworkSendCurrentSelectionActionListener networkSendCurrentSelectionActionListener = new NetworkSendCurrentSelectionActionListener(this);
        jButton9.addActionListener(networkSendCurrentSelectionActionListener);
        jButton3.addActionListener(networkSendCurrentSelectionActionListener);
        jButton6.addActionListener(networkSendCurrentSelectionActionListener);
        jButton13.addActionListener(networkSendCurrentSelectionActionListener);
        SaveCurrentlyDisplayedImageToXMLActionListener saveCurrentlyDisplayedImageToXMLActionListener = new SaveCurrentlyDisplayedImageToXMLActionListener(this);
        jButton4.addActionListener(saveCurrentlyDisplayedImageToXMLActionListener);
        jButton7.addActionListener(saveCurrentlyDisplayedImageToXMLActionListener);
        ValidateCurrentlyDisplayedImageActionListener validateCurrentlyDisplayedImageActionListener = new ValidateCurrentlyDisplayedImageActionListener(this);
        jButton5.addActionListener(validateCurrentlyDisplayedImageActionListener);
        jButton8.addActionListener(validateCurrentlyDisplayedImageActionListener);
        JSplitPane jSplitPane = new JSplitPane(1, this.browserPane, jPanel);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setBorder(emptyBorder);
        JSplitPane jSplitPane2 = new JSplitPane(0, jSplitPane, jScrollPane);
        jSplitPane2.setOneTouchExpandable(true);
        jSplitPane2.setResizeWeight(0.9);
        Box box = new Box(1);
        box.add(jSplitPane2);
        box.add(this.statusBar);
        ((Container)object).add(box);
        Dimension dimension2 = defaultMultiPanelDimension;
        jPanel.setSize(dimension2);
        jPanel.setPreferredSize(dimension2);
        this.browserPane.setPreferredSize(new Dimension(400, (int)jPanel.getPreferredSize().getHeight()));
        Dimension dimension3 = this.getTableOfCurrentAttributesForCurrentFrameBrowser().getPreferredSize();
        int n4 = (int)dimension3.getWidth();
        int bl = (int)dimension3.getHeight();
        int exception = 400 + (int)jPanel.getPreferredSize().getWidth();
        if (n4 > exception) {
            n4 = exception;
        }
        if (bl < 76) {
            n = 76;
        }
        jScrollPane.setPreferredSize(new Dimension(n4, n));
        boolean bl2 = false;
        GraphicsDevice[] graphicsDeviceArray = properties.getProperty(propertyName_FullScreen);
        if (graphicsDeviceArray != null && graphicsDeviceArray.equals("true")) {
            bl2 = true;
        }
        graphicsDeviceArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        boolean bl3 = bl2 && graphicsDeviceArray.length == 1 && graphicsDeviceArray[0].isFullScreenSupported();
        this.setUndecorated(bl3);
        this.setResizable(!bl3);
        if (bl3) {
            try {
                Class<?> clazz = new URLClassLoader(new URL[]{new File("/System/Library/Java").toURL()}).loadClass("com.apple.cocoa.application.NSMenu");
                Class[] classArray = new Class[]{Boolean.TYPE};
                Method method = clazz.getDeclaredMethod("setMenuBarVisible", classArray);
                Object[] objectArray = new Object[]{Boolean.FALSE};
                method.invoke(null, objectArray);
            }
            catch (Exception exception2) {
                exception2.printStackTrace(System.err);
            }
            graphicsDeviceArray[0].setFullScreenWindow(this);
            this.validate();
        } else {
            this.pack();
            this.setVisible(true);
        }
    }

    private DicomImageViewer(String string, int n, int n2) {
    }

    private DicomImageViewer(String string) {
    }

    private DicomImageViewer(String string, String string2) {
    }

    private DicomImageViewer(String string, String string2, String string3) {
        super(string, string2);
        this.doCommonConstructorStuff(string, string3);
    }

    public static void main(String[] stringArray) {
        String string = null;
        if (stringArray.length == 1) {
            string = stringArray[0];
        }
        if (System.getProperty("mrj.version") != null) {
            System.setProperty("apple.awt.fakefullscreen", "true");
        }
        DicomImageViewer dicomImageViewer = new DicomImageViewer("Dicom Image Viewer", propertiesFileName, string);
    }

    static /* synthetic */ int[] access$202(DicomImageViewer dicomImageViewer, int[] nArray) {
        dicomImageViewer.currentSourceSortOrder = nArray;
        return nArray;
    }

    private class SortAttributesActionListener
    implements ActionListener {
        static final String ByName = "NAME";
        static final String ByNumber = "NUMBER";
        JScrollPane attributeTreeScrollPane;

        public SortAttributesActionListener(JScrollPane jScrollPane) {
            this.attributeTreeScrollPane = jScrollPane;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = DicomImageViewer.this.attributeTreeSortOrderButtons.getSelection().getActionCommand();
            AttributeTreeBrowser.setSortByName(this.attributeTreeScrollPane, string != null && string.equals(ByName));
        }
    }

    private class OurReceivedObjectHandler
    extends ReceivedObjectHandler {
        private OurReceivedObjectHandler() {
        }

        public void sendReceivedObjectIndication(String string, String string2, String string3) throws DicomNetworkException, DicomException, IOException {
            if (string != null) {
                System.err.println("Received: " + string + " from " + string3 + " in " + string2);
                try {
                    FileInputStream fileInputStream = new FileInputStream(string);
                    DicomInputStream dicomInputStream = new DicomInputStream(new BufferedInputStream(fileInputStream));
                    AttributeList attributeList = new AttributeList();
                    attributeList.read(dicomInputStream, TagFromName.PixelData);
                    dicomInputStream.close();
                    fileInputStream.close();
                    DicomImageViewer.this.databaseInformationModel.insertObject(attributeList, string);
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                }
            }
        }
    }

    private class ValidateCurrentlyDisplayedImageActionListener
    implements ActionListener {
        DicomImageViewer application;
        DicomInstanceValidator validator;

        public ValidateCurrentlyDisplayedImageActionListener(DicomImageViewer dicomImageViewer2) {
            this.application = dicomImageViewer2;
            this.validator = null;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Cursor cursor = this.application.getCursor();
            this.application.setCursor(Cursor.getPredefinedCursor(3));
            try {
                AttributeList attributeList = DicomImageViewer.this.getAttributeListForDatabaseImport();
                if (this.validator == null) {
                    this.validator = new DicomInstanceValidator();
                }
                String string = this.validator == null ? "Could not instantiate a validator\n" : this.validator.validate(attributeList);
                JTextArea jTextArea = new JTextArea(string);
                JScrollPane jScrollPane = new JScrollPane(jTextArea);
                JDialog jDialog = new JDialog();
                jDialog.setSize(512, 384);
                jDialog.setTitle("Validation of " + DicomImageViewer.this.getCurrentFilePathSelection());
                jDialog.getContentPane().add(jScrollPane);
                jDialog.setVisible(true);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Done.                                                   "));
            this.application.setCursor(cursor);
        }
    }

    private class SaveCurrentlyDisplayedImageToXMLActionListener
    implements ActionListener {
        DicomImageViewer application;
        String lastDirectoryPath;

        public SaveCurrentlyDisplayedImageToXMLActionListener(DicomImageViewer dicomImageViewer2) {
            this.application = dicomImageViewer2;
            this.lastDirectoryPath = null;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Cursor cursor = this.application.getCursor();
            this.application.setCursor(Cursor.getPredefinedCursor(3));
            try {
                JFileChooser jFileChooser = new JFileChooser(this.lastDirectoryPath);
                if (jFileChooser.showSaveDialog(null) == 0) {
                    String string = jFileChooser.getSelectedFile().getAbsolutePath();
                    this.lastDirectoryPath = jFileChooser.getCurrentDirectory().getAbsolutePath();
                    AttributeList attributeList = DicomImageViewer.this.getAttributeListForDatabaseImport();
                    new XMLRepresentationOfDicomObjectFactory();
                    XMLRepresentationOfDicomObjectFactory.createDocumentAndWriteIt(attributeList, new BufferedOutputStream(new FileOutputStream(string)));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Done.                                                   "));
            this.application.setCursor(cursor);
        }
    }

    private class NetworkSendCurrentSelectionActionListener
    implements ActionListener {
        DicomImageViewer application;

        public NetworkSendCurrentSelectionActionListener(DicomImageViewer dicomImageViewer2) {
            this.application = dicomImageViewer2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Vector vector = DicomImageViewer.this.getCurrentFilePathSelections();
            if (vector != null && vector.size() > 0) {
                Properties properties = this.application.getProperties();
                String string = properties.getProperty(DicomImageViewer.propertyName_DicomCurrentlySelectedStorageTargetAE);
                if ((string = DicomImageViewer.this.showInputDialogToSelectNetworkTargetByLocalApplicationEntityName("Select destination", "Send ...", string)) != null && DicomImageViewer.this.networkApplicationProperties != null) {
                    try {
                        String string2 = DicomImageViewer.this.networkApplicationProperties.getCallingAETitle();
                        String string3 = DicomImageViewer.this.networkApplicationInformation.getApplicationEntityTitleFromLocalName(string);
                        PresentationAddress presentationAddress = DicomImageViewer.this.networkApplicationInformation.getApplicationEntityMap().getPresentationAddress(string3);
                        String string4 = presentationAddress.getHostname();
                        int n = presentationAddress.getPort();
                        String string5 = null;
                        String string6 = null;
                        for (int i = 0; i < vector.size(); ++i) {
                            String string7 = (String)vector.get(i);
                            if (string7 == null) continue;
                            try {
                                System.err.println("Send: " + string7);
                                File file = FileUtilities.getFileFromNameInsensitiveToCaseIfNecessary(string7);
                                DicomImageViewer.this.sendDicomFileOverDicomNetwork(file.getAbsolutePath(), string, string4, n, string3, string2, string5, string6, this.application);
                                continue;
                            }
                            catch (Exception exception) {
                                exception.printStackTrace(System.err);
                            }
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(System.err);
                    }
                }
            }
        }
    }

    public class ImportFromSelectionToDatabaseActionListener
    implements ActionListener {
        DicomImageViewer application;
        DatabaseInformationModel databaseInformationModel;
        File savedImagesFolder;

        public ImportFromSelectionToDatabaseActionListener(DicomImageViewer dicomImageViewer2, DatabaseInformationModel databaseInformationModel, File file) {
            this.databaseInformationModel = databaseInformationModel;
            this.application = dicomImageViewer2;
            this.savedImagesFolder = file;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Cursor cursor = this.application.getCursor();
            this.application.setCursor(Cursor.getPredefinedCursor(3));
            Vector vector = DicomImageViewer.this.getCurrentFilePathSelections();
            if (vector != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    String string = (String)vector.get(i);
                    if (string == null) continue;
                    try {
                        File file = FileUtilities.getFileFromNameInsensitiveToCaseIfNecessary(string);
                        DicomInputStream dicomInputStream = new DicomInputStream(file);
                        AttributeList attributeList = new AttributeList();
                        attributeList.read(dicomInputStream);
                        dicomInputStream.close();
                        DicomImageViewer.this.copyFileAndImportToDatabase(this.databaseInformationModel, attributeList, file.getAbsolutePath(), this.savedImagesFolder);
                        continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(System.err);
                    }
                }
            }
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Done.                                                   "));
            this.application.setCursor(cursor);
        }
    }

    private class ImportCurrentlyDisplayedInstanceToDatabaseActionListener
    implements ActionListener {
        DicomImageViewer application;
        DatabaseInformationModel databaseInformationModel;
        File savedImagesFolder;

        public ImportCurrentlyDisplayedInstanceToDatabaseActionListener(DicomImageViewer dicomImageViewer2, DatabaseInformationModel databaseInformationModel, File file) {
            this.databaseInformationModel = databaseInformationModel;
            this.application = dicomImageViewer2;
            this.savedImagesFolder = file;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Cursor cursor = this.application.getCursor();
            this.application.setCursor(Cursor.getPredefinedCursor(3));
            try {
                DicomImageViewer.this.copyFileAndImportToDatabase(this.databaseInformationModel, DicomImageViewer.this.getAttributeListForDatabaseImport(), DicomImageViewer.this.getCurrentlyDisplayedInstanceFilePath(), this.savedImagesFolder);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Done.                                                   "));
            this.application.setCursor(cursor);
        }
    }

    private class DatabaseImportFromFilesActionListener
    implements ActionListener {
        DicomImageViewer application;
        JPanel imagePanel;
        JPanel referenceImagePanelForImages;
        JList displayListOfPossibleReferenceImagesForImages;
        JPanel referenceImagePanelForSpectra;
        JList displayListOfPossibleReferenceImagesForSpectra;
        JList displayListOfPossibleBackgroundImagesForSpectra;
        JScrollPane treeScrollPane;
        JScrollPane attributeScrollPane;
        JScrollPane attributeTreeScrollPane;
        JScrollPane attributeFrameTableScrollPane;
        DatabaseInformationModel databaseInformationModel;
        private DatabaseMediaImporter importer;

        public DatabaseImportFromFilesActionListener(DicomImageViewer dicomImageViewer2, File file, DatabaseInformationModel databaseInformationModel, JPanel jPanel, JPanel jPanel2, JList jList, JPanel jPanel3, JList jList2, JList jList3, JScrollPane jScrollPane, JScrollPane jScrollPane2, JScrollPane jScrollPane3, JScrollPane jScrollPane4) {
            this.importer = new DatabaseMediaImporter(null, file, DicomImageViewer.this.storedFilePathStrategy, databaseInformationModel, new OurMessageLogger());
            this.databaseInformationModel = databaseInformationModel;
            this.imagePanel = jPanel;
            this.referenceImagePanelForImages = jPanel2;
            this.displayListOfPossibleReferenceImagesForImages = jList;
            this.referenceImagePanelForSpectra = jPanel3;
            this.displayListOfPossibleReferenceImagesForSpectra = jList2;
            this.displayListOfPossibleBackgroundImagesForSpectra = jList3;
            this.treeScrollPane = jScrollPane;
            this.attributeScrollPane = jScrollPane2;
            this.attributeTreeScrollPane = jScrollPane3;
            this.attributeFrameTableScrollPane = jScrollPane4;
            this.application = dicomImageViewer2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Cursor cursor = this.application.getCursor();
            this.application.setCursor(Cursor.getPredefinedCursor(3));
            try {
                this.importer.choosePathAndImportDicomFiles();
                new OurDatabaseTreeBrowser(this.databaseInformationModel, this.application, this.imagePanel, this.referenceImagePanelForImages, this.displayListOfPossibleReferenceImagesForImages, this.referenceImagePanelForSpectra, this.displayListOfPossibleReferenceImagesForSpectra, this.displayListOfPossibleBackgroundImagesForSpectra, this.treeScrollPane, this.attributeScrollPane, this.attributeTreeScrollPane, this.attributeFrameTableScrollPane);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Done.                                                   "));
            this.application.setCursor(cursor);
        }
    }

    private class DatabaseRefreshActionListener
    implements ActionListener {
        DicomImageViewer application;
        JPanel imagePanel;
        JPanel referenceImagePanelForImages;
        JList displayListOfPossibleReferenceImagesForImages;
        JPanel referenceImagePanelForSpectra;
        JList displayListOfPossibleReferenceImagesForSpectra;
        JList displayListOfPossibleBackgroundImagesForSpectra;
        JScrollPane treeScrollPane;
        JScrollPane attributeScrollPane;
        JScrollPane attributeTreeScrollPane;
        JScrollPane attributeFrameTableScrollPane;
        DatabaseInformationModel databaseInformationModel;

        public DatabaseRefreshActionListener(DicomImageViewer dicomImageViewer2, DatabaseInformationModel databaseInformationModel, JPanel jPanel, JPanel jPanel2, JList jList, JPanel jPanel3, JList jList2, JList jList3, JScrollPane jScrollPane, JScrollPane jScrollPane2, JScrollPane jScrollPane3, JScrollPane jScrollPane4) {
            this.databaseInformationModel = databaseInformationModel;
            this.imagePanel = jPanel;
            this.referenceImagePanelForImages = jPanel2;
            this.displayListOfPossibleReferenceImagesForImages = jList;
            this.referenceImagePanelForSpectra = jPanel3;
            this.displayListOfPossibleReferenceImagesForSpectra = jList2;
            this.displayListOfPossibleBackgroundImagesForSpectra = jList3;
            this.treeScrollPane = jScrollPane;
            this.attributeScrollPane = jScrollPane2;
            this.attributeTreeScrollPane = jScrollPane3;
            this.attributeFrameTableScrollPane = jScrollPane4;
            this.application = dicomImageViewer2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                new OurDatabaseTreeBrowser(this.databaseInformationModel, this.application, this.imagePanel, this.referenceImagePanelForImages, this.displayListOfPossibleReferenceImagesForImages, this.referenceImagePanelForSpectra, this.displayListOfPossibleReferenceImagesForSpectra, this.displayListOfPossibleBackgroundImagesForSpectra, this.treeScrollPane, this.attributeScrollPane, this.attributeTreeScrollPane, this.attributeFrameTableScrollPane);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
    }

    private class QueryRefreshActionListener
    implements ActionListener {
        DicomImageViewer application;
        JScrollPane treeScrollPane;
        JScrollPane attributeScrollPane;

        public QueryRefreshActionListener(DicomImageViewer dicomImageViewer2, JScrollPane jScrollPane, JScrollPane jScrollPane2) {
            this.treeScrollPane = jScrollPane;
            this.attributeScrollPane = jScrollPane2;
            this.application = dicomImageViewer2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Cursor cursor = this.application.getCursor();
            this.application.setCursor(Cursor.getPredefinedCursor(3));
            try {
                this.treeScrollPane.setViewportView(null);
                this.attributeScrollPane.setViewportView(null);
                QueryInformationModel queryInformationModel = DicomImageViewer.this.getCurrentRemoteQueryInformationModel();
                if (queryInformationModel != null) {
                    QueryTreeModel queryTreeModel = queryInformationModel.performHierarchicalQuery(DicomImageViewer.this.getCurrentRemoteQueryFilter());
                    new OurQueryTreeBrowser(queryInformationModel, queryTreeModel, this.treeScrollPane, this.attributeScrollPane);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
            this.application.setCursor(cursor);
        }
    }

    private class QueryRetrieveActionListener
    implements ActionListener {
        DicomImageViewer application;

        public QueryRetrieveActionListener(DicomImageViewer dicomImageViewer2) {
            this.application = dicomImageViewer2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Cursor cursor = this.application.getCursor();
            this.application.setCursor(Cursor.getPredefinedCursor(3));
            if (DicomImageViewer.this.getCurrentRemoteQuerySelectionLevel() == null) {
                QueryTreeRecord queryTreeRecord = DicomImageViewer.this.getCurrentRemoteQuerySelectionQueryTreeRecord();
                if (queryTreeRecord != null) {
                    System.err.println("Retrieve: everything from " + DicomImageViewer.this.getCurrentRemoteQuerySelectionRetrieveAE());
                    Enumeration enumeration = queryTreeRecord.children();
                    if (enumeration != null) {
                        while (enumeration.hasMoreElements()) {
                            QueryTreeRecord queryTreeRecord2 = (QueryTreeRecord)enumeration.nextElement();
                            if (queryTreeRecord2 == null) continue;
                            DicomImageViewer.this.setCurrentRemoteQuerySelection(queryTreeRecord2.getUniqueKeys(), queryTreeRecord2.getUniqueKey(), queryTreeRecord2.getAllAttributesReturnedInIdentifier());
                            System.err.println("Retrieve: " + DicomImageViewer.this.getCurrentRemoteQuerySelectionLevel() + " " + DicomImageViewer.this.getCurrentRemoteQuerySelectionUniqueKey().getSingleStringValueOrEmptyString() + " from " + DicomImageViewer.this.getCurrentRemoteQuerySelectionRetrieveAE());
                            DicomImageViewer.this.performRetrieve(DicomImageViewer.this.getCurrentRemoteQuerySelectionUniqueKeys(), DicomImageViewer.this.getCurrentRemoteQuerySelectionLevel(), DicomImageViewer.this.getCurrentRemoteQuerySelectionRetrieveAE());
                        }
                    }
                    System.err.println("Retrieve done");
                    DicomImageViewer.this.setCurrentRemoteQuerySelection(null, null, null);
                }
            } else {
                System.err.println("Retrieve: " + DicomImageViewer.this.getCurrentRemoteQuerySelectionLevel() + " " + DicomImageViewer.this.getCurrentRemoteQuerySelectionUniqueKey().getSingleStringValueOrEmptyString() + " from " + DicomImageViewer.this.getCurrentRemoteQuerySelectionRetrieveAE());
                DicomImageViewer.this.performRetrieve(DicomImageViewer.this.getCurrentRemoteQuerySelectionUniqueKeys(), DicomImageViewer.this.getCurrentRemoteQuerySelectionLevel(), DicomImageViewer.this.getCurrentRemoteQuerySelectionRetrieveAE());
                System.err.println("Retrieve done");
            }
            this.application.setCursor(cursor);
        }
    }

    private class QueryFilterActionListener
    implements ActionListener {
        DicomImageViewer application;
        JScrollPane treeScrollPane;
        JScrollPane attributeScrollPane;
        JTabbedPane browserPane;
        int tabNumberOfRemoteInBrowserPane;

        public QueryFilterActionListener(DicomImageViewer dicomImageViewer2, JScrollPane jScrollPane, JScrollPane jScrollPane2, JTabbedPane jTabbedPane, int n) {
            this.application = dicomImageViewer2;
            this.treeScrollPane = jScrollPane;
            this.attributeScrollPane = jScrollPane2;
            this.browserPane = jTabbedPane;
            this.tabNumberOfRemoteInBrowserPane = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.treeScrollPane.setViewportView(new FilterPanel(DicomImageViewer.this.getCurrentRemoteQueryFilter()));
        }
    }

    private class QuerySelectActionListener
    implements ActionListener {
        DicomImageViewer application;
        JScrollPane treeScrollPane;
        JScrollPane attributeScrollPane;
        JTabbedPane browserPane;
        int tabNumberOfRemoteInBrowserPane;

        public QuerySelectActionListener(DicomImageViewer dicomImageViewer2, JScrollPane jScrollPane, JScrollPane jScrollPane2, JTabbedPane jTabbedPane, int n) {
            this.application = dicomImageViewer2;
            this.treeScrollPane = jScrollPane;
            this.attributeScrollPane = jScrollPane2;
            this.browserPane = jTabbedPane;
            this.tabNumberOfRemoteInBrowserPane = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Properties properties = this.application.getProperties();
            String string = properties.getProperty(DicomImageViewer.propertyName_DicomCurrentlySelectedQueryTargetAE);
            string = DicomImageViewer.this.showInputDialogToSelectNetworkTargetByLocalApplicationEntityName("Select remote system", "Query ...", string);
            this.treeScrollPane.setViewportView(null);
            this.attributeScrollPane.setViewportView(null);
            if (string != null) {
                this.application.setCurrentRemoteQueryInformationModel(string, this.browserPane, this.tabNumberOfRemoteInBrowserPane);
            }
        }
    }

    private final class OurBackgroundListSelectionListener
    implements ListSelectionListener {
        private String lastSelectedDicomFileName = null;

        OurBackgroundListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            JList jList = (JList)listSelectionEvent.getSource();
            if (jList.isSelectionEmpty()) {
                this.lastSelectedDicomFileName = null;
            } else {
                String string;
                String string2 = (String)jList.getSelectedValue();
                if (!(string2 == null || (string = (String)DicomImageViewer.this.backgroundImageListMappedToFilenames.get(string2)) == null || this.lastSelectedDicomFileName != null && string.equals(this.lastSelectedDicomFileName))) {
                    this.lastSelectedDicomFileName = string;
                    DicomImageViewer.this.loadBackgroundImageForSpectra(string);
                }
            }
        }
    }

    private final class OurReferenceListSelectionListener
    implements ListSelectionListener {
        private String lastSelectedDicomFileName = null;
        private JPanel referenceImagePanel;
        private boolean spectroscopy;

        OurReferenceListSelectionListener(JPanel jPanel, boolean bl) {
            this.referenceImagePanel = jPanel;
            this.spectroscopy = bl;
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            JList jList = (JList)listSelectionEvent.getSource();
            if (jList.isSelectionEmpty()) {
                this.lastSelectedDicomFileName = null;
            } else {
                String string;
                String string2 = (String)jList.getSelectedValue();
                if (!(string2 == null || (string = (String)DicomImageViewer.this.referenceImageListMappedToFilenames.get(string2)) == null || this.lastSelectedDicomFileName != null && string.equals(this.lastSelectedDicomFileName))) {
                    this.lastSelectedDicomFileName = string;
                    DicomImageViewer.this.loadReferenceImagePanel(string, this.referenceImagePanel, this.spectroscopy);
                }
            }
        }
    }

    private class DicomFileLoadFromSelectionActionListener
    implements ActionListener {
        DicomImageViewer application;
        JPanel imagePanel;
        JPanel referenceImagePanelForImages;
        JList displayListOfPossibleReferenceImagesForImages;
        JPanel referenceImagePanelForSpectra;
        JList displayListOfPossibleReferenceImagesForSpectra;
        JList displayListOfPossibleBackgroundImagesForSpectra;
        JScrollPane treeScrollPane;
        JScrollPane attributeScrollPane;
        JScrollPane attributeTreeScrollPane;
        JScrollPane attributeFrameTableScrollPane;

        public DicomFileLoadFromSelectionActionListener(DicomImageViewer dicomImageViewer2, JPanel jPanel, JPanel jPanel2, JList jList, JPanel jPanel3, JList jList2, JList jList3, JScrollPane jScrollPane, JScrollPane jScrollPane2, JScrollPane jScrollPane3, JScrollPane jScrollPane4) {
            this.imagePanel = jPanel;
            this.referenceImagePanelForImages = jPanel2;
            this.displayListOfPossibleReferenceImagesForImages = jList;
            this.referenceImagePanelForSpectra = jPanel3;
            this.displayListOfPossibleReferenceImagesForSpectra = jList2;
            this.displayListOfPossibleBackgroundImagesForSpectra = jList3;
            this.treeScrollPane = jScrollPane;
            this.attributeScrollPane = jScrollPane2;
            this.attributeTreeScrollPane = jScrollPane3;
            this.attributeFrameTableScrollPane = jScrollPane4;
            this.application = dicomImageViewer2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = DicomImageViewer.this.getCurrentFilePathSelection();
            if (string != null) {
                DicomImageViewer.this.loadDicomFileOrDirectory(string, this.application, this.imagePanel, this.referenceImagePanelForImages, this.displayListOfPossibleReferenceImagesForImages, this.referenceImagePanelForSpectra, this.displayListOfPossibleReferenceImagesForSpectra, this.displayListOfPossibleBackgroundImagesForSpectra, this.treeScrollPane, this.attributeScrollPane, this.attributeTreeScrollPane, this.attributeFrameTableScrollPane, null);
            }
        }
    }

    private class DicomFileOrDirectoryLoadActionListener
    implements ActionListener {
        DicomImageViewer application;
        JPanel imagePanel;
        JPanel referenceImagePanelForImages;
        JList displayListOfPossibleReferenceImagesForImages;
        JPanel referenceImagePanelForSpectra;
        JList displayListOfPossibleReferenceImagesForSpectra;
        JList displayListOfPossibleBackgroundImagesForSpectra;
        JScrollPane treeScrollPane;
        JScrollPane attributeScrollPane;
        JScrollPane attributeTreeScrollPane;
        JScrollPane attributeFrameTableScrollPane;
        String lastDirectoryPath;

        public DicomFileOrDirectoryLoadActionListener(DicomImageViewer dicomImageViewer2, JPanel jPanel, JPanel jPanel2, JList jList, JPanel jPanel3, JList jList2, JList jList3, JScrollPane jScrollPane, JScrollPane jScrollPane2, JScrollPane jScrollPane3, JScrollPane jScrollPane4, String string) {
            this.imagePanel = jPanel;
            this.referenceImagePanelForImages = jPanel2;
            this.displayListOfPossibleReferenceImagesForImages = jList;
            this.referenceImagePanelForSpectra = jPanel3;
            this.displayListOfPossibleReferenceImagesForSpectra = jList2;
            this.displayListOfPossibleBackgroundImagesForSpectra = jList3;
            this.treeScrollPane = jScrollPane;
            this.attributeScrollPane = jScrollPane2;
            this.attributeTreeScrollPane = jScrollPane3;
            this.attributeFrameTableScrollPane = jScrollPane4;
            this.application = dicomImageViewer2;
            this.lastDirectoryPath = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.lastDirectoryPath = DicomImageViewer.this.loadDicomFileOrDirectoryCallingChooserIfRequired(null, this.application, this.imagePanel, this.referenceImagePanelForImages, this.displayListOfPossibleReferenceImagesForImages, this.referenceImagePanelForSpectra, this.displayListOfPossibleReferenceImagesForSpectra, this.displayListOfPossibleBackgroundImagesForSpectra, this.treeScrollPane, this.attributeScrollPane, this.attributeTreeScrollPane, this.attributeFrameTableScrollPane, this.lastDirectoryPath);
        }
    }

    private class OurQueryTreeBrowser
    extends QueryTreeBrowser {
        OurQueryTreeBrowser(QueryInformationModel queryInformationModel, QueryTreeModel queryTreeModel, JScrollPane jScrollPane, JScrollPane jScrollPane2) throws DicomException {
            super(queryInformationModel, queryTreeModel, jScrollPane, jScrollPane2);
        }

        protected TreeSelectionListener buildTreeSelectionListenerToDoSomethingWithSelectedLevel() {
            return new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                    Object object;
                    TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
                    if (treePath != null && (object = treePath.getLastPathComponent()) instanceof QueryTreeRecord) {
                        QueryTreeRecord queryTreeRecord = (QueryTreeRecord)object;
                        DicomImageViewer.this.setCurrentRemoteQuerySelection(queryTreeRecord.getUniqueKeys(), queryTreeRecord.getUniqueKey(), queryTreeRecord.getAllAttributesReturnedInIdentifier());
                        DicomImageViewer.this.setCurrentRemoteQuerySelectionQueryTreeRecord(queryTreeRecord);
                    }
                }
            };
        }
    }

    private class OurDatabaseTreeBrowser
    extends DatabaseTreeBrowser {
        DicomImageViewer application;
        JPanel imagePanel;
        JPanel referenceImagePanelForImages;
        JList displayListOfPossibleReferenceImagesForImages;
        JPanel referenceImagePanelForSpectra;
        JList displayListOfPossibleReferenceImagesForSpectra;
        JList displayListOfPossibleBackgroundImagesForSpectra;
        JScrollPane treeScrollPane;
        JScrollPane attributeScrollPane;
        JScrollPane attributeTreeScrollPane;
        JScrollPane attributeFrameTableScrollPane;

        public OurDatabaseTreeBrowser(DatabaseInformationModel databaseInformationModel, DicomImageViewer dicomImageViewer2, JPanel jPanel, JPanel jPanel2, JList jList, JPanel jPanel3, JList jList2, JList jList3, JScrollPane jScrollPane, JScrollPane jScrollPane2, JScrollPane jScrollPane3, JScrollPane jScrollPane4) throws DicomException {
            super(databaseInformationModel, jScrollPane, jScrollPane2);
            this.imagePanel = jPanel;
            this.referenceImagePanelForImages = jPanel2;
            this.displayListOfPossibleReferenceImagesForImages = jList;
            this.referenceImagePanelForSpectra = jPanel3;
            this.displayListOfPossibleReferenceImagesForSpectra = jList2;
            this.displayListOfPossibleBackgroundImagesForSpectra = jList3;
            this.treeScrollPane = jScrollPane;
            this.attributeScrollPane = jScrollPane2;
            this.attributeTreeScrollPane = jScrollPane3;
            this.attributeFrameTableScrollPane = jScrollPane4;
            this.application = dicomImageViewer2;
        }

        protected void doSomethingWithSelectedFiles(Vector vector) {
            DicomImageViewer.this.setCurrentFilePathSelection(vector);
        }

        protected void doSomethingMoreWithWhateverWasSelected() {
            String string = DicomImageViewer.this.getCurrentFilePathSelection();
            if (string != null) {
                DicomImageViewer.this.loadDicomFileOrDirectory(string, this.application, this.imagePanel, this.referenceImagePanelForImages, this.displayListOfPossibleReferenceImagesForImages, this.referenceImagePanelForSpectra, this.displayListOfPossibleReferenceImagesForSpectra, this.displayListOfPossibleBackgroundImagesForSpectra, this.treeScrollPane, this.attributeScrollPane, this.attributeTreeScrollPane, this.attributeFrameTableScrollPane, null);
            }
        }
    }

    private class OurDicomDirectoryBrowser
    extends DicomDirectoryBrowser {
        DicomImageViewer application;
        JPanel imagePanel;
        JPanel referenceImagePanelForImages;
        JList displayListOfPossibleReferenceImagesForImages;
        JPanel referenceImagePanelForSpectra;
        JList displayListOfPossibleReferenceImagesForSpectra;
        JList displayListOfPossibleBackgroundImagesForSpectra;
        JScrollPane treeScrollPane;
        JScrollPane attributeScrollPane;
        JScrollPane attributeTreeScrollPane;
        JScrollPane attributeFrameTableScrollPane;

        public OurDicomDirectoryBrowser(AttributeList attributeList, String string, DicomImageViewer dicomImageViewer2, JPanel jPanel, JPanel jPanel2, JList jList, JPanel jPanel3, JList jList2, JList jList3, JScrollPane jScrollPane, JScrollPane jScrollPane2, JScrollPane jScrollPane3, JScrollPane jScrollPane4) throws DicomException {
            super(attributeList, string, jScrollPane, jScrollPane2);
            this.imagePanel = jPanel;
            this.referenceImagePanelForImages = jPanel2;
            this.displayListOfPossibleReferenceImagesForImages = jList;
            this.referenceImagePanelForSpectra = jPanel3;
            this.displayListOfPossibleReferenceImagesForSpectra = jList2;
            this.displayListOfPossibleBackgroundImagesForSpectra = jList3;
            this.treeScrollPane = jScrollPane;
            this.attributeScrollPane = jScrollPane2;
            this.attributeTreeScrollPane = jScrollPane3;
            this.attributeFrameTableScrollPane = jScrollPane4;
            this.application = dicomImageViewer2;
        }

        protected void doSomethingWithSelectedFiles(Vector vector) {
            DicomImageViewer.this.setCurrentFilePathSelection(vector);
        }

        protected void doSomethingMoreWithWhateverWasSelected() {
            String string = DicomImageViewer.this.getCurrentFilePathSelection();
            if (string != null) {
                DicomImageViewer.this.loadDicomFileOrDirectory(string, this.application, this.imagePanel, this.referenceImagePanelForImages, this.displayListOfPossibleReferenceImagesForImages, this.referenceImagePanelForSpectra, this.displayListOfPossibleReferenceImagesForSpectra, this.displayListOfPossibleBackgroundImagesForSpectra, this.treeScrollPane, this.attributeScrollPane, this.attributeTreeScrollPane, this.attributeFrameTableScrollPane, null);
            }
        }
    }

    class OurBrowserPaneChangeListener
    extends SelfRegisteringListener {
        public OurBrowserPaneChangeListener(EventContext eventContext) {
            super("com.pixelmed.display.event.BrowserPaneChangeEvent", eventContext);
        }

        public void changed(Event event) {
            BrowserPaneChangeEvent browserPaneChangeEvent = (BrowserPaneChangeEvent)event;
            if (browserPaneChangeEvent.getType() == 1) {
                DicomImageViewer.this.browserPane.setEnabledAt(DicomImageViewer.this.browserPane.indexOfComponent(DicomImageViewer.this.displayControlsPanel), true);
                DicomImageViewer.this.browserPane.setSelectedComponent(DicomImageViewer.this.displayControlsPanel);
                DicomImageViewer.this.browserPane.setEnabledAt(DicomImageViewer.this.browserPane.indexOfComponent(DicomImageViewer.this.spectroscopyControlsPanel), false);
            } else if (browserPaneChangeEvent.getType() == 2) {
                DicomImageViewer.this.browserPane.setSelectedComponent(DicomImageViewer.this.dicomdirControlsPanel);
            } else if (browserPaneChangeEvent.getType() == 3) {
                DicomImageViewer.this.browserPane.setSelectedComponent(DicomImageViewer.this.databaseControlsPanel);
            } else if (browserPaneChangeEvent.getType() == 4) {
                DicomImageViewer.this.browserPane.setEnabledAt(DicomImageViewer.this.browserPane.indexOfComponent(DicomImageViewer.this.spectroscopyControlsPanel), true);
                DicomImageViewer.this.browserPane.setSelectedComponent(DicomImageViewer.this.spectroscopyControlsPanel);
                DicomImageViewer.this.browserPane.setEnabledAt(DicomImageViewer.this.browserPane.indexOfComponent(DicomImageViewer.this.displayControlsPanel), false);
            }
        }
    }

    class OurFrameSortOrderChangeListener
    extends SelfRegisteringListener {
        public OurFrameSortOrderChangeListener(EventContext eventContext) {
            super("com.pixelmed.display.event.FrameSortOrderChangeEvent", eventContext);
        }

        public void changed(Event event) {
            FrameSortOrderChangeEvent frameSortOrderChangeEvent = (FrameSortOrderChangeEvent)event;
            DicomImageViewer.this.currentSourceIndex = frameSortOrderChangeEvent.getIndex();
            DicomImageViewer.access$202(DicomImageViewer.this, frameSortOrderChangeEvent.getSortOrder());
            DicomImageViewer.this.getModelOfCurrentAttributesForCurrentFrameBrowser().selectValuesForDifferentFrame(DicomImageViewer.this.currentSourceIndex);
            DicomImageViewer.this.getTableOfCurrentAttributesForCurrentFrameBrowser().setColumnWidths();
        }
    }

    class OurFrameSelectionChangeListener
    extends SelfRegisteringListener {
        public OurFrameSelectionChangeListener(EventContext eventContext) {
            super("com.pixelmed.display.event.FrameSelectionChangeEvent", eventContext);
        }

        public void changed(Event event) {
            FrameSelectionChangeEvent frameSelectionChangeEvent = (FrameSelectionChangeEvent)event;
            DicomImageViewer.this.currentSourceIndex = frameSelectionChangeEvent.getIndex();
            if (DicomImageViewer.this.currentSourceSortOrder != null) {
                DicomImageViewer.this.currentSourceIndex = DicomImageViewer.this.currentSourceSortOrder[DicomImageViewer.this.currentSourceIndex];
            }
            DicomImageViewer.this.getModelOfCurrentAttributesForCurrentFrameBrowser().selectValuesForDifferentFrame(DicomImageViewer.this.currentSourceIndex);
            DicomImageViewer.this.getTableOfCurrentAttributesForCurrentFrameBrowser().setColumnWidths();
        }
    }

    private class OurMessageLogger
    implements MessageLogger {
        private OurMessageLogger() {
        }

        public void send(String string) {
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent(string));
        }

        public void sendLn(String string) {
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent(string));
        }
    }
}

