/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.display;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.GeometryOfVolumeFromAttributeList;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.geometry.GeometryOfVolume;

class OrientationAnnotations {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/display/OrientationAnnotations.java,v 1.2 2005/12/17 22:52:24 dclunie Exp $";
    private GeometryOfVolume imageGeometry;
    private String rowOrientationFromPatientOrientation;
    private String columnOrientationFromPatientOrientation;

    public OrientationAnnotations(String string, String string2) {
        this.rowOrientationFromPatientOrientation = string;
        this.columnOrientationFromPatientOrientation = string2;
        this.imageGeometry = null;
    }

    public OrientationAnnotations(AttributeList attributeList, GeometryOfVolume geometryOfVolume) {
        this.doCommonConstructorStuff(attributeList, geometryOfVolume);
    }

    public OrientationAnnotations(AttributeList attributeList) {
        GeometryOfVolumeFromAttributeList geometryOfVolumeFromAttributeList = null;
        try {
            geometryOfVolumeFromAttributeList = new GeometryOfVolumeFromAttributeList(attributeList);
        }
        catch (DicomException dicomException) {
            // empty catch block
        }
        this.doCommonConstructorStuff(attributeList, geometryOfVolumeFromAttributeList);
    }

    private void doCommonConstructorStuff(AttributeList attributeList, GeometryOfVolume geometryOfVolume) {
        Attribute attribute;
        this.imageGeometry = geometryOfVolume;
        this.rowOrientationFromPatientOrientation = "";
        this.columnOrientationFromPatientOrientation = "";
        if (attributeList != null && (attribute = attributeList.get(TagFromName.PatientOrientation)) != null && attribute.getVM() == 2) {
            try {
                String[] stringArray = attribute.getStringValues();
                if (stringArray != null && stringArray.length == 2) {
                    this.rowOrientationFromPatientOrientation = stringArray[0];
                    this.columnOrientationFromPatientOrientation = stringArray[1];
                }
            }
            catch (DicomException dicomException) {
                // empty catch block
            }
        }
    }

    public final String getRowOrientation(int n) {
        String string = null;
        if (this.imageGeometry != null) {
            string = this.imageGeometry.getRowOrientation(n);
        }
        if (string == null || string.length() == 0) {
            string = this.rowOrientationFromPatientOrientation;
        }
        return string;
    }

    public final String getColumnOrientation(int n) {
        String string = null;
        if (this.imageGeometry != null) {
            string = this.imageGeometry.getColumnOrientation(n);
        }
        if (string == null || string.length() == 0) {
            string = this.columnOrientationFromPatientOrientation;
        }
        return string;
    }
}

