/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.network;

import com.pixelmed.dicom.DicomException;
import com.pixelmed.network.Association;
import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.PDataPDU;
import com.pixelmed.network.PresentationDataValue;
import java.io.IOException;
import java.util.LinkedList;
import java.util.ListIterator;

public abstract class ReceivedDataHandler {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/network/ReceivedDataHandler.java,v 1.15 2005/09/08 12:24:12 dclunie Exp $";
    protected int debugLevel;
    protected boolean done;
    protected boolean release;

    ReceivedDataHandler(int n) {
        this.debugLevel = n;
        this.done = false;
        this.release = false;
    }

    protected void dumpPDVList(LinkedList linkedList) {
        ListIterator listIterator = linkedList.listIterator();
        while (listIterator.hasNext()) {
            PresentationDataValue presentationDataValue = (PresentationDataValue)listIterator.next();
            System.err.println("Received PDV:");
            System.err.println(presentationDataValue);
        }
    }

    public abstract void sendPDataIndication(PDataPDU var1, Association var2) throws DicomNetworkException, DicomException, IOException;

    public boolean isDone() {
        return this.done;
    }

    public boolean isToBeReleased() {
        return this.release;
    }

    public void setDone(boolean bl) {
        this.done = bl;
    }

    public void setRelease(boolean bl) {
        this.release = bl;
    }
}

