/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.scpecg;

import com.pixelmed.dicom.BinaryInputStream;
import com.pixelmed.scpecg.SCPTreeRecord;
import com.pixelmed.scpecg.Section;
import com.pixelmed.scpecg.SectionHeader;
import java.io.IOException;

public class Section7
extends Section {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/scpecg/Section7.java,v 1.8 2004/01/25 03:47:20 dclunie Exp $";
    private int numberOfQRSMeasurements;
    private int numberOfPacemakerSpikes;
    private int averageRRInterval;
    private int averagePPInterval;
    private int[] onsetP;
    private int[] offsetP;
    private int[] onsetQRS;
    private int[] offsetQRS;
    private int[] offsetT;
    private int[] axisP;
    private int[] axisQRS;
    private int[] axisT;
    private int[] pacemakerSpikeLocation;
    private int[] pacemakerSpikeAmplitude;
    private int[] pacemakerSpikeType;
    private int[] pacemakerSpikeSource;
    private int[] pacemakerSpikeTriggerIndex;
    private int[] pacemakerSpikePulseWidth;
    private int numberOfQRSComplexes;
    private int[] qrsType;
    private int ventricularRate;
    private int atrialRate;
    private int correctedQTInterval;
    private int heartRateCorrectionFormula;
    private int numberOfBytesInTaggedFields;

    public String getSectionName() {
        return "Global Measurements";
    }

    public int getNumberOfQRSMeasurements() {
        return this.numberOfQRSMeasurements;
    }

    public int getNumberOfPacemakerSpikes() {
        return this.numberOfPacemakerSpikes;
    }

    public int getAverageRRInterval() {
        return this.averageRRInterval;
    }

    public int getAveragePPInterval() {
        return this.averagePPInterval;
    }

    public int[] getPOnset() {
        return this.onsetP;
    }

    public int[] getPOffset() {
        return this.offsetP;
    }

    public int[] getQRSOnset() {
        return this.onsetQRS;
    }

    public int[] getQRSOffset() {
        return this.offsetQRS;
    }

    public int[] getTOffset() {
        return this.offsetT;
    }

    public int[] getPAxis() {
        return this.axisP;
    }

    public int[] getQRSAxis() {
        return this.axisQRS;
    }

    public int[] getTAxis() {
        return this.axisT;
    }

    public int[] getPacemakerSpikeLocation() {
        return this.pacemakerSpikeLocation;
    }

    public int[] getPacemakerSpikeAmplitude() {
        return this.pacemakerSpikeAmplitude;
    }

    public int[] getPacemakerSpikeType() {
        return this.pacemakerSpikeType;
    }

    public int[] getPacemakerSpikeSource() {
        return this.pacemakerSpikeSource;
    }

    public int[] getPacemakerSpikeTriggerIndex() {
        return this.pacemakerSpikeTriggerIndex;
    }

    public int[] getPacemakerSpikePulseWidth() {
        return this.pacemakerSpikePulseWidth;
    }

    public int getNumberOfQRSComplexes() {
        return this.numberOfQRSComplexes;
    }

    public int[] getQRSType() {
        return this.qrsType;
    }

    public int getVentricularRate() {
        return this.ventricularRate;
    }

    public int getAtrialRate() {
        return this.atrialRate;
    }

    public int getCorrectedQTInterval() {
        return this.correctedQTInterval;
    }

    public int getHeartRateCorrectionFormula() {
        return this.heartRateCorrectionFormula;
    }

    public int getNumberOfBytesInTaggedFields() {
        return this.numberOfBytesInTaggedFields;
    }

    private int[] rightSizeArray(int[] nArray, int n) {
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        return nArray2;
    }

    public Section7(SectionHeader sectionHeader) {
        super(sectionHeader);
    }

    public long read(BinaryInputStream binaryInputStream) throws IOException {
        int n;
        int n2;
        int n3;
        this.numberOfQRSMeasurements = binaryInputStream.readUnsigned8();
        ++this.bytesRead;
        --this.sectionBytesRemaining;
        this.numberOfPacemakerSpikes = binaryInputStream.readUnsigned8();
        ++this.bytesRead;
        --this.sectionBytesRemaining;
        this.averageRRInterval = binaryInputStream.readUnsigned16();
        this.bytesRead += 2L;
        this.sectionBytesRemaining -= 2L;
        this.averagePPInterval = binaryInputStream.readUnsigned16();
        this.bytesRead += 2L;
        this.sectionBytesRemaining -= 2L;
        this.onsetP = new int[this.numberOfQRSMeasurements];
        this.offsetP = new int[this.numberOfQRSMeasurements];
        this.onsetQRS = new int[this.numberOfQRSMeasurements];
        this.offsetQRS = new int[this.numberOfQRSMeasurements];
        this.offsetT = new int[this.numberOfQRSMeasurements];
        this.axisP = new int[this.numberOfQRSMeasurements];
        this.axisQRS = new int[this.numberOfQRSMeasurements];
        this.axisT = new int[this.numberOfQRSMeasurements];
        for (n3 = 0; this.sectionBytesRemaining >= 16L && n3 < this.numberOfQRSMeasurements; ++n3) {
            this.onsetP[n3] = binaryInputStream.readUnsigned16();
            this.bytesRead += 2L;
            this.sectionBytesRemaining -= 2L;
            this.offsetP[n3] = binaryInputStream.readUnsigned16();
            this.bytesRead += 2L;
            this.sectionBytesRemaining -= 2L;
            this.onsetQRS[n3] = binaryInputStream.readUnsigned16();
            this.bytesRead += 2L;
            this.sectionBytesRemaining -= 2L;
            this.offsetQRS[n3] = binaryInputStream.readUnsigned16();
            this.bytesRead += 2L;
            this.sectionBytesRemaining -= 2L;
            this.offsetT[n3] = binaryInputStream.readUnsigned16();
            this.bytesRead += 2L;
            this.sectionBytesRemaining -= 2L;
            this.axisP[n3] = binaryInputStream.readUnsigned16();
            this.bytesRead += 2L;
            this.sectionBytesRemaining -= 2L;
            this.axisQRS[n3] = binaryInputStream.readUnsigned16();
            this.bytesRead += 2L;
            this.sectionBytesRemaining -= 2L;
            this.axisT[n3] = binaryInputStream.readUnsigned16();
            this.bytesRead += 2L;
            this.sectionBytesRemaining -= 2L;
        }
        if (n3 != this.numberOfQRSMeasurements) {
            this.onsetP = this.rightSizeArray(this.onsetP, n3);
            this.offsetP = this.rightSizeArray(this.offsetP, n3);
            this.onsetQRS = this.rightSizeArray(this.onsetQRS, n3);
            this.offsetQRS = this.rightSizeArray(this.offsetQRS, n3);
            this.offsetT = this.rightSizeArray(this.offsetT, n3);
            this.axisP = this.rightSizeArray(this.axisP, n3);
            this.axisQRS = this.rightSizeArray(this.axisQRS, n3);
            this.axisT = this.rightSizeArray(this.axisT, n3);
            System.err.println("Section 7 Number Of QRS Measurements specified as " + this.numberOfQRSMeasurements + " but encountered measurements for only " + n3 + ", giving up on rest of section");
            this.skipToEndOfSectionIfNotAlreadyThere(binaryInputStream);
        }
        this.pacemakerSpikeLocation = new int[this.numberOfPacemakerSpikes];
        this.pacemakerSpikeAmplitude = new int[this.numberOfPacemakerSpikes];
        for (n2 = 0; this.sectionBytesRemaining >= 4L && n2 < this.numberOfPacemakerSpikes; ++n2) {
            this.pacemakerSpikeLocation[n2] = binaryInputStream.readUnsigned16();
            this.bytesRead += 2L;
            this.sectionBytesRemaining -= 2L;
            this.pacemakerSpikeAmplitude[n2] = binaryInputStream.readSigned16();
            this.bytesRead += 2L;
            this.sectionBytesRemaining -= 2L;
        }
        if (n2 != this.numberOfPacemakerSpikes) {
            this.pacemakerSpikeLocation = this.rightSizeArray(this.pacemakerSpikeLocation, n2);
            this.pacemakerSpikeAmplitude = this.rightSizeArray(this.pacemakerSpikeAmplitude, n2);
            System.err.println("Section 7 Number Of Pacemaker Spikes specified as " + this.numberOfPacemakerSpikes + " but encountered measurements for only " + n2 + ", giving up on rest of section");
            this.skipToEndOfSectionIfNotAlreadyThere(binaryInputStream);
        }
        this.pacemakerSpikeType = new int[this.numberOfPacemakerSpikes];
        this.pacemakerSpikeSource = new int[this.numberOfPacemakerSpikes];
        this.pacemakerSpikeTriggerIndex = new int[this.numberOfPacemakerSpikes];
        this.pacemakerSpikePulseWidth = new int[this.numberOfPacemakerSpikes];
        for (n2 = 0; this.sectionBytesRemaining >= 6L && n2 < this.numberOfPacemakerSpikes; ++n2) {
            this.pacemakerSpikeType[n2] = binaryInputStream.readUnsigned8();
            ++this.bytesRead;
            --this.sectionBytesRemaining;
            this.pacemakerSpikeSource[n2] = binaryInputStream.readUnsigned8();
            ++this.bytesRead;
            --this.sectionBytesRemaining;
            this.pacemakerSpikeTriggerIndex[n2] = binaryInputStream.readUnsigned16();
            this.bytesRead += 2L;
            this.sectionBytesRemaining -= 2L;
            this.pacemakerSpikePulseWidth[n2] = binaryInputStream.readUnsigned16();
            this.bytesRead += 2L;
            this.sectionBytesRemaining -= 2L;
        }
        if (n2 != this.numberOfPacemakerSpikes) {
            this.pacemakerSpikeType = this.rightSizeArray(this.pacemakerSpikeType, n2);
            this.pacemakerSpikeSource = this.rightSizeArray(this.pacemakerSpikeSource, n2);
            this.pacemakerSpikeTriggerIndex = this.rightSizeArray(this.pacemakerSpikeTriggerIndex, n2);
            this.pacemakerSpikePulseWidth = this.rightSizeArray(this.pacemakerSpikePulseWidth, n2);
            System.err.println("Section 7 Number Of Pacemaker Spikes specified as " + this.numberOfPacemakerSpikes + " but encountered information for only " + n2 + ", giving up on rest of section");
            this.skipToEndOfSectionIfNotAlreadyThere(binaryInputStream);
        }
        if (this.sectionBytesRemaining >= 2L) {
            this.numberOfQRSComplexes = binaryInputStream.readUnsigned16();
            this.bytesRead += 2L;
            this.sectionBytesRemaining -= 2L;
        } else {
            this.numberOfQRSComplexes = 0;
            System.err.println("Section 7 Number Of QRS Complexes (and everything that follows) missing - end of section encountered first");
        }
        this.qrsType = new int[this.numberOfQRSComplexes];
        for (n = 0; this.sectionBytesRemaining >= 1L && n < this.numberOfQRSComplexes; ++n) {
            this.qrsType[n] = binaryInputStream.readUnsigned8();
            ++this.bytesRead;
            --this.sectionBytesRemaining;
        }
        if (n != this.numberOfQRSComplexes) {
            this.qrsType = this.rightSizeArray(this.qrsType, n);
            System.err.println("Section 7 Number Of QRS Complexes specified as " + this.numberOfQRSComplexes + " but encountered type for only " + n + ", giving up on rest of section");
            this.skipToEndOfSectionIfNotAlreadyThere(binaryInputStream);
        }
        if (this.sectionBytesRemaining >= 9L) {
            this.ventricularRate = binaryInputStream.readUnsigned16();
            this.bytesRead += 2L;
            this.sectionBytesRemaining -= 2L;
            this.atrialRate = binaryInputStream.readUnsigned16();
            this.bytesRead += 2L;
            this.sectionBytesRemaining -= 2L;
            this.correctedQTInterval = binaryInputStream.readUnsigned16();
            this.bytesRead += 2L;
            this.sectionBytesRemaining -= 2L;
            this.heartRateCorrectionFormula = binaryInputStream.readUnsigned8();
            ++this.bytesRead;
            --this.sectionBytesRemaining;
            this.numberOfBytesInTaggedFields = binaryInputStream.readUnsigned16();
            this.bytesRead += 2L;
            this.sectionBytesRemaining -= 2L;
        } else {
            System.err.println("Section 7 Missing extra measurements, giving up on rest of section");
            this.skipToEndOfSectionIfNotAlreadyThere(binaryInputStream);
        }
        if (this.sectionBytesRemaining > 0L) {
            this.skipToEndOfSectionIfNotAlreadyThere(binaryInputStream);
        }
        return this.bytesRead;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Number of QRS Measurements = " + this.numberOfQRSMeasurements + " dec (0x" + Integer.toHexString(this.numberOfQRSMeasurements) + ")\n");
        stringBuffer.append("Number of Pacemaker Spikes = " + this.numberOfPacemakerSpikes + " dec (0x" + Integer.toHexString(this.numberOfPacemakerSpikes) + ")\n");
        stringBuffer.append("Average RR Interval = " + this.averageRRInterval + " dec (0x" + Integer.toHexString(this.averageRRInterval) + ")\n");
        stringBuffer.append("Average PP Interval = " + this.averagePPInterval + " dec (0x" + Integer.toHexString(this.averagePPInterval) + ")\n");
        stringBuffer.append("QRS Measurements (number " + this.numberOfQRSMeasurements + "):\n");
        for (n = 0; n < this.onsetP.length; ++n) {
            stringBuffer.append("\tQRS " + n + ":\n");
            stringBuffer.append("\t\tP Onset = " + this.onsetP[n] + " dec (0x" + Integer.toHexString(this.onsetP[n]) + ")\n");
            stringBuffer.append("\t\tP Offset = " + this.offsetP[n] + " dec (0x" + Integer.toHexString(this.offsetP[n]) + ")\n");
            stringBuffer.append("\t\tQRS Onset = " + this.onsetQRS[n] + " dec (0x" + Integer.toHexString(this.onsetQRS[n]) + ")\n");
            stringBuffer.append("\t\tQRS Offset = " + this.offsetQRS[n] + " dec (0x" + Integer.toHexString(this.offsetQRS[n]) + ")\n");
            stringBuffer.append("\t\tT Offset = " + this.offsetT[n] + " dec (0x" + Integer.toHexString(this.offsetT[n]) + ")\n");
            stringBuffer.append("\t\tP Axis = " + this.axisP[n] + " dec (0x" + Integer.toHexString(this.axisP[n]) + ")" + (this.axisP[n] == 999 ? " undefined" : "") + "\n");
            stringBuffer.append("\t\tQRS Axis = " + this.axisQRS[n] + " dec (0x" + Integer.toHexString(this.axisQRS[n]) + ")" + (this.axisQRS[n] == 999 ? " undefined" : "") + "\n");
            stringBuffer.append("\t\tT Axis = " + this.axisT[n] + " dec (0x" + Integer.toHexString(this.axisT[n]) + ")" + (this.axisT[n] == 999 ? " undefined" : "") + "\n");
        }
        stringBuffer.append("Pacemaker Spike Measurements (number " + this.numberOfPacemakerSpikes + "):\n");
        for (n = 0; n < this.pacemakerSpikeLocation.length; ++n) {
            stringBuffer.append("\tSpike " + n + ":\n");
            stringBuffer.append("\t\tPacemaker Spike Location = " + this.pacemakerSpikeLocation[n] + " dec (0x" + Integer.toHexString(this.pacemakerSpikeLocation[n]) + ")\n");
            stringBuffer.append("\t\tPacemaker Spike Amplitude = " + this.pacemakerSpikeAmplitude[n] + " dec (0x" + Integer.toHexString(this.pacemakerSpikeAmplitude[n]) + ")\n");
        }
        stringBuffer.append("Pacemaker Spike Information (number " + this.numberOfPacemakerSpikes + "):\n");
        for (n = 0; n < this.pacemakerSpikeType.length; ++n) {
            stringBuffer.append("\tSpike " + n + ":\n");
            stringBuffer.append("\t\tPacemaker Spike Type = " + this.pacemakerSpikeType[n] + " dec (0x" + Integer.toHexString(this.pacemakerSpikeType[n]) + ")\n");
            stringBuffer.append("\t\tPacemaker Spike Source = " + this.pacemakerSpikeSource[n] + " dec (0x" + Integer.toHexString(this.pacemakerSpikeSource[n]) + ")\n");
            stringBuffer.append("\t\tPacemaker Spike Trigger Index = " + this.pacemakerSpikeTriggerIndex[n] + " dec (0x" + Integer.toHexString(this.pacemakerSpikeTriggerIndex[n]) + ")\n");
            stringBuffer.append("\t\tPacemaker Spike Pulse Width = " + this.pacemakerSpikePulseWidth[n] + " dec (0x" + Integer.toHexString(this.pacemakerSpikePulseWidth[n]) + ")\n");
        }
        stringBuffer.append("QRS Complexes (number " + this.numberOfQRSComplexes + "):\n");
        for (n = 0; n < this.qrsType.length; ++n) {
            stringBuffer.append("\tQRS " + n + ":\n");
            stringBuffer.append("\t\tQRS Type = " + this.qrsType[n] + " dec (0x" + Integer.toHexString(this.qrsType[n]) + ")\n");
        }
        stringBuffer.append("Ventricular Rate = " + this.ventricularRate + " dec (0x" + Integer.toHexString(this.ventricularRate) + ")\n");
        stringBuffer.append("Atrial Rate = " + this.atrialRate + " dec (0x" + Integer.toHexString(this.atrialRate) + ")\n");
        stringBuffer.append("Corrected QT Interval = " + this.correctedQTInterval + " dec (0x" + Integer.toHexString(this.correctedQTInterval) + ")\n");
        stringBuffer.append("Heart Rate Correction Formula = " + this.heartRateCorrectionFormula + " dec (0x" + Integer.toHexString(this.heartRateCorrectionFormula) + ")\n");
        stringBuffer.append("Number of Bytes in Tagged Fields = " + this.numberOfBytesInTaggedFields + " dec (0x" + Integer.toHexString(this.numberOfBytesInTaggedFields) + ")\n");
        return stringBuffer.toString();
    }

    public String validate() {
        return "";
    }

    public static String describeUndefinedOrMissingValues(int n) {
        String string = "";
        if (n == 999) {
            string = "Undefined";
        } else if (n == 29999) {
            string = "Measurement not computed by the program";
        } else if (n == 29998) {
            string = "Measurement result not found due to rejection of the lead by measurement program";
        } else if (n == 19999) {
            string = "Measurement not found because wave was not present in the corresponding lead";
        }
        return string;
    }

    protected static void addNodeOfDecimalWithUndefinedOrMissingValues(SCPTreeRecord sCPTreeRecord, String string, int n) {
        new SCPTreeRecord(sCPTreeRecord, string, Integer.toString(n) + " dec " + Section7.describeUndefinedOrMissingValues(n));
    }

    public SCPTreeRecord getTree(SCPTreeRecord sCPTreeRecord) {
        if (this.tree == null) {
            SCPTreeRecord sCPTreeRecord2;
            int n;
            SCPTreeRecord sCPTreeRecord3 = new SCPTreeRecord(sCPTreeRecord, "Section", this.getValueForSectionNodeInTree());
            this.addSectionHeaderToTree(sCPTreeRecord3);
            Section7.addNodeOfDecimalAndHex(sCPTreeRecord3, "Number of QRS Measurements", this.numberOfQRSMeasurements);
            Section7.addNodeOfDecimalAndHex(sCPTreeRecord3, "Number of Pacemaker Spikes", this.numberOfPacemakerSpikes);
            Section7.addNodeOfDecimalWithMissingValues(sCPTreeRecord3, "Average RR Interval", this.averageRRInterval);
            Section7.addNodeOfDecimalWithMissingValues(sCPTreeRecord3, "Average PP Interval", this.averagePPInterval);
            SCPTreeRecord sCPTreeRecord4 = new SCPTreeRecord(sCPTreeRecord3, "QRS Measurements", Integer.toString(this.numberOfQRSMeasurements));
            for (n = 0; n < this.onsetP.length; ++n) {
                sCPTreeRecord2 = new SCPTreeRecord(sCPTreeRecord4, "QRS", Integer.toString(n));
                Section7.addNodeOfDecimalWithMissingValues(sCPTreeRecord2, "P Onset", this.onsetP[n]);
                Section7.addNodeOfDecimalWithMissingValues(sCPTreeRecord2, "P Offset", this.offsetP[n]);
                Section7.addNodeOfDecimalWithMissingValues(sCPTreeRecord2, "QRS Onset", this.onsetQRS[n]);
                Section7.addNodeOfDecimalWithMissingValues(sCPTreeRecord2, "QRS Offset", this.offsetQRS[n]);
                Section7.addNodeOfDecimalWithMissingValues(sCPTreeRecord2, "T Offset", this.offsetT[n]);
                Section7.addNodeOfDecimalWithUndefinedOrMissingValues(sCPTreeRecord2, "P Axis", this.axisP[n]);
                Section7.addNodeOfDecimalWithUndefinedOrMissingValues(sCPTreeRecord2, "QRS Axis", this.axisQRS[n]);
                Section7.addNodeOfDecimalWithUndefinedOrMissingValues(sCPTreeRecord2, "T Axis", this.axisT[n]);
            }
            sCPTreeRecord4 = new SCPTreeRecord(sCPTreeRecord3, "Pacemaker Spike Measurements", Integer.toString(this.numberOfPacemakerSpikes));
            for (n = 0; n < this.pacemakerSpikeLocation.length; ++n) {
                sCPTreeRecord2 = new SCPTreeRecord(sCPTreeRecord4, "Spike", Integer.toString(n));
                Section7.addNodeOfDecimalAndHex(sCPTreeRecord2, "Pacemaker Spike Location", this.pacemakerSpikeLocation[n]);
                Section7.addNodeOfDecimalAndHex(sCPTreeRecord2, "Pacemaker Spike Amplitude", this.pacemakerSpikeAmplitude[n]);
            }
            sCPTreeRecord4 = new SCPTreeRecord(sCPTreeRecord3, "Pacemaker Spike Information", Integer.toString(this.numberOfPacemakerSpikes));
            for (n = 0; n < this.pacemakerSpikeType.length; ++n) {
                sCPTreeRecord2 = new SCPTreeRecord(sCPTreeRecord4, "Spike", Integer.toString(n));
                Section7.addNodeOfDecimalAndHex(sCPTreeRecord2, "Pacemaker Spike Type", this.pacemakerSpikeType[n]);
                Section7.addNodeOfDecimalAndHex(sCPTreeRecord2, "Pacemaker Spike Source", this.pacemakerSpikeSource[n]);
                Section7.addNodeOfDecimalAndHex(sCPTreeRecord2, "Pacemaker Trigger Index", this.pacemakerSpikeTriggerIndex[n]);
                Section7.addNodeOfDecimalAndHex(sCPTreeRecord2, "Pacemaker Pulse Width", this.pacemakerSpikePulseWidth[n]);
            }
            sCPTreeRecord4 = new SCPTreeRecord(sCPTreeRecord3, "QRS Complexes", Integer.toString(this.numberOfQRSComplexes));
            for (n = 0; n < this.qrsType.length; ++n) {
                sCPTreeRecord2 = new SCPTreeRecord(sCPTreeRecord4, "QRS", Integer.toString(n));
                Section7.addNodeOfDecimalAndHex(sCPTreeRecord2, "QRS Type", this.qrsType[n]);
            }
            Section7.addNodeOfDecimalWithMissingValues(sCPTreeRecord3, "Ventricular Rate", this.ventricularRate);
            Section7.addNodeOfDecimalWithMissingValues(sCPTreeRecord3, "Atrial Rate", this.atrialRate);
            Section7.addNodeOfDecimalWithMissingValues(sCPTreeRecord3, "Corrected QT Interval", this.correctedQTInterval);
            Section7.addNodeOfDecimalAndHex(sCPTreeRecord3, "Heart Rate Correction Formula", this.heartRateCorrectionFormula);
            Section7.addNodeOfDecimalAndHex(sCPTreeRecord3, "Number of Bytes in Tagged Fields", this.numberOfBytesInTaggedFields);
        }
        return this.tree;
    }
}

