/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.web;

import com.pixelmed.database.DatabaseInformationModel;
import com.pixelmed.database.PatientStudySeriesConcatenationInstanceModel;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.ReceivedObjectHandler;
import com.pixelmed.network.StorageSOPClassSCPDispatcher;
import com.pixelmed.web.HttpServer;
import com.pixelmed.web.RequestHandler;
import com.pixelmed.web.WadoRequestHandler;
import com.pixelmed.web.WebRequest;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;

public class WadoServer
extends HttpServer {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/web/WadoServer.java,v 1.19 2006/10/08 17:09:51 dclunie Exp $";
    private DatabaseInformationModel databaseInformationModel;

    protected HttpServer.Worker createWorker() {
        return new WADOWorker();
    }

    public WadoServer(String string, String string2, int n, String string3, int n2, int n3, int n4) {
        super(n4);
        try {
            this.databaseInformationModel = new PatientStudySeriesConcatenationInstanceModel(string);
            File file = new File(string2);
            if (!file.exists()) {
                file.mkdirs();
            }
            new Thread(new StorageSOPClassSCPDispatcher(n, string3, file, new OurReceivedObjectHandler(), null, null, null, false, n2)).start();
            super.initializeThreadPool(n3);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public static void main(String[] stringArray) {
        String string = "/tmp/testwadodb";
        String string2 = "/tmp/testwadoimages";
        int n = 4007;
        String string3 = "WADOTEST";
        int n2 = 0;
        int n3 = 0;
        int n4 = 7091;
        new Thread(new WadoServer(string, string2, n, string3, n2, n4, n3)).start();
    }

    private class OurReceivedObjectHandler
    extends ReceivedObjectHandler {
        private OurReceivedObjectHandler() {
        }

        public void sendReceivedObjectIndication(String string, String string2, String string3) throws DicomNetworkException, DicomException, IOException {
            if (string != null) {
                if (WadoServer.this.webServerDebugLevel > 0) {
                    System.err.println("Received: " + string + " from " + string3 + " in " + string2);
                }
                try {
                    FileInputStream fileInputStream = new FileInputStream(string);
                    DicomInputStream dicomInputStream = new DicomInputStream(new BufferedInputStream(fileInputStream));
                    AttributeList attributeList = new AttributeList();
                    attributeList.read(dicomInputStream, TagFromName.PixelData);
                    dicomInputStream.close();
                    fileInputStream.close();
                    WadoServer.this.databaseInformationModel.insertObject(attributeList, string);
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                }
            }
        }
    }

    protected class WADOWorker
    extends HttpServer.Worker {
        private WadoRequestHandler wadoRequestHandler = null;

        protected WADOWorker() {
        }

        protected void generateResponseToGetRequest(String string, OutputStream outputStream) throws IOException {
            try {
                WebRequest webRequest = new WebRequest(string);
                String string2 = webRequest.getRequestType();
                if (string2 != null && string2.equals("WADO")) {
                    if (this.wadoRequestHandler == null) {
                        this.wadoRequestHandler = new WadoRequestHandler(null, WadoServer.this.webServerDebugLevel);
                    }
                } else {
                    throw new Exception("Unrecognized requestType \"" + string2 + "\"");
                }
                this.wadoRequestHandler.generateResponseToGetRequest(WadoServer.this.databaseInformationModel, null, null, webRequest, null, outputStream);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
                if (WadoServer.this.webServerDebugLevel > 0) {
                    System.err.println("WadoServer.WADOWorker.generateResponseToGetRequest(): Sending 404 Not Found");
                }
                RequestHandler.send404NotFound(outputStream, exception.getMessage());
            }
        }
    }
}

