/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.text;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Map;
import org.jpedal.PdfDecoder;
import org.jpedal.exception.PdfException;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.objects.PdfPageData;
import org.jpedal.utils.LogWriter;

public class ExtractTextInRectangleAsTable {
    private String user_dir = System.getProperty("user.dir");
    String separator = System.getProperty("file.separator");
    PdfDecoder decodePdf = null;
    public static boolean showMessages = true;
    private String outputDir = "";
    private static int defX1 = -1;
    private static int defX2;
    private static int defY1;
    private static int defY2;
    private boolean isCSV = true;
    private static String testFile;

    public ExtractTextInRectangleAsTable() {
    }

    public ExtractTextInRectangleAsTable(String string) {
        File file;
        String string2 = System.getProperty("xml");
        if (string2 != null) {
            this.isCSV = false;
        }
        if (string == null) {
            string = testFile;
        }
        if (!this.user_dir.endsWith(this.separator)) {
            this.user_dir = this.user_dir + this.separator;
        }
        if (!(file = new File(this.outputDir)).exists()) {
            file.mkdirs();
        }
        if (string.toLowerCase().endsWith(".pdf")) {
            this.decodeFile(string);
        } else {
            String[] stringArray = null;
            File file2 = null;
            if (!string.endsWith(this.separator)) {
                string = string + this.separator;
            }
            try {
                file2 = new File(string);
                if (!file2.isDirectory()) {
                    System.err.println(string + " is not a directory. Exiting program");
                }
                stringArray = file2.list();
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception trying to access file " + exception.getMessage());
            }
            long l = stringArray.length;
            int n = 0;
            while ((long)n < l) {
                if (showMessages) {
                    System.out.println(n + "/ " + l + ' ' + stringArray[n]);
                }
                if (stringArray[n].toLowerCase().endsWith(".pdf")) {
                    if (showMessages) {
                        System.out.println(string + stringArray[n]);
                    }
                    this.decodeFile(string + stringArray[n]);
                }
                ++n;
            }
        }
    }

    private void decodeFile(String string) {
        String string2 = "demo";
        int n = string.lastIndexOf(this.separator);
        if (n != -1) {
            string2 = string.substring(n + 1, string.length() - 4);
        }
        this.outputDir = this.user_dir + "tables" + this.separator + string2 + this.separator;
        File file = new File(this.outputDir + this.separator);
        if (!file.exists()) {
            file.mkdirs();
        }
        try {
            this.decodePdf = new PdfDecoder(false);
            this.decodePdf.setExtractionMode(1);
            this.decodePdf.init(true);
            if (showMessages) {
                System.out.println("Opening file :" + string);
            }
            this.decodePdf.openPdfFile(string);
        }
        catch (Exception exception) {
            System.err.println("Exception " + exception + " in pdf code");
        }
        if (!this.decodePdf.isExtractionAllowed()) {
            System.out.println("Text extraction not allowed");
        } else if (this.decodePdf.isEncrypted() && !this.decodePdf.isPasswordSupplied()) {
            System.out.println("Encrypted settings");
            System.out.println("Please look at SimpleViewer for code sample to handle such files");
            System.out.println("Or get support/consultancy");
        } else {
            int n2 = 1;
            int n3 = this.decodePdf.getPageCount();
            try {
                for (int i = n2; i < n3 + 1; ++i) {
                    int n4;
                    int n5;
                    int n6;
                    int n7;
                    this.decodePdf.decodePage(i);
                    PdfGroupingAlgorithms pdfGroupingAlgorithms = this.decodePdf.getGroupingObject();
                    PdfPageData pdfPageData = this.decodePdf.getPdfPageData();
                    if (defX1 == -1) {
                        n7 = pdfPageData.getMediaBoxX(i);
                        n6 = pdfPageData.getMediaBoxWidth(i) + n7;
                        n5 = pdfPageData.getMediaBoxY(i);
                        n4 = pdfPageData.getMediaBoxHeight(i) + n5;
                    } else {
                        n7 = defX1;
                        n4 = defY1;
                        n6 = defX2;
                        n5 = defY2;
                    }
                    if (showMessages) {
                        System.out.println("Extracting text from rectangle as table(" + n7 + ',' + n4 + ' ' + n6 + ',' + n5 + ')');
                    }
                    String string3 = ".xml";
                    if (this.isCSV) {
                        if (showMessages) {
                            System.out.println("Table will be in CSV format");
                        }
                        string3 = ".csv";
                    } else if (showMessages) {
                        System.out.println("Table will be in xml format");
                    }
                    Map map = null;
                    String string4 = null;
                    try {
                        map = pdfGroupingAlgorithms.extractTextAsTable(n7, n4, n6, n5, i, this.isCSV, false, false, false, 0, false);
                        string4 = (String)map.get("content");
                    }
                    catch (PdfException pdfException) {
                        this.decodePdf.closePdfFile();
                        System.err.println("Exception " + pdfException.getMessage() + " with table extraction");
                    }
                    if (string4 == null) {
                        if (showMessages) {
                            System.out.println("No text found");
                        }
                    } else {
                        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(this.outputDir + i + string3), "UTF-8");
                        if (showMessages) {
                            System.out.println("Writing to " + this.outputDir + i + string3);
                        }
                        if (!this.isCSV) {
                            outputStreamWriter.write("<xml><BODY>\n\n");
                        }
                        outputStreamWriter.write(string4);
                        if (!this.isCSV) {
                            outputStreamWriter.write("\n</body></xml>");
                        }
                        outputStreamWriter.close();
                    }
                    this.decodePdf.flushObjectValues(false);
                }
            }
            catch (Exception exception) {
                this.decodePdf.closePdfFile();
                System.err.println("Exception " + exception.getMessage());
                exception.printStackTrace();
            }
            this.decodePdf.flushObjectValues(true);
            if (showMessages) {
                System.out.println("Text read as table");
            }
        }
        this.decodePdf.closePdfFile();
    }

    public static void main(String[] stringArray) {
        System.out.println("Simple demo to extract text objects as CSV or xml tables");
        String string = testFile;
        if (stringArray.length == 1) {
            string = stringArray[0];
            System.out.println("File :" + string);
        } else if (stringArray.length != 2) {
            if (stringArray.length == 5) {
                string = stringArray[0];
                System.out.println("File :" + string);
                System.out.println("User coordinates supplied");
                defX1 = Integer.parseInt(stringArray[1]);
                defY1 = Integer.parseInt(stringArray[2]);
                defX2 = Integer.parseInt(stringArray[3]);
                defY2 = Integer.parseInt(stringArray[4]);
            } else {
                System.out.println("Please call with either ");
                System.out.println("FileName");
                System.out.println("or");
                System.out.println("FileName x1 y1 x2 y2");
            }
        }
        File file = new File(string);
        if (!file.exists()) {
            System.out.println("File " + string + " not found");
        }
        new ExtractTextInRectangleAsTable(string);
    }

    static {
        testFile = "/mnt/shared/storypad/input/samples_table_grouping/sampleTable.pdf";
    }
}

