/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.bzip2;

import java.io.IOException;
import java.io.InputStream;
import org.apache.excalibur.bzip2.BZip2Constants;
import org.apache.excalibur.bzip2.CRC;

public class CBZip2InputStream
extends InputStream
implements BZip2Constants {
    private static final int START_BLOCK_STATE = 1;
    private static final int RAND_PART_A_STATE = 2;
    private static final int RAND_PART_B_STATE = 3;
    private static final int RAND_PART_C_STATE = 4;
    private static final int NO_RAND_PART_A_STATE = 5;
    private static final int NO_RAND_PART_B_STATE = 6;
    private static final int NO_RAND_PART_C_STATE = 7;
    private CRC m_crc = new CRC();
    private boolean[] m_inUse = new boolean[256];
    private char[] m_seqToUnseq = new char[256];
    private char[] m_unseqToSeq = new char[256];
    private char[] m_selector = new char[18002];
    private char[] m_selectorMtf = new char[18002];
    private int[] m_unzftab = new int[256];
    private int[][] m_limit = new int[6][258];
    private int[][] m_base = new int[6][258];
    private int[][] m_perm = new int[6][258];
    private int[] m_minLens = new int[6];
    private boolean m_streamEnd;
    private int m_currentChar = -1;
    private int m_currentState = 1;
    private int m_rNToGo;
    private int m_rTPos;
    private int m_tPos;
    private int i2;
    private int count;
    private int chPrev;
    private int ch2;
    private int j2;
    private char z;
    private boolean m_blockRandomised;
    private int m_blockSize100k;
    private int m_bsBuff;
    private int m_bsLive;
    private InputStream m_input;
    private int m_computedBlockCRC;
    private int m_computedCombinedCRC;
    private int m_last;
    private char[] m_ll8;
    private int m_nInUse;
    private int m_origPtr;
    private int m_storedBlockCRC;
    private int m_storedCombinedCRC;
    private int[] m_tt;

    public CBZip2InputStream(InputStream input) {
        this.bsSetStream(input);
        this.initialize();
        this.initBlock();
        this.setupBlock();
    }

    private static void badBlockHeader() {
        CBZip2InputStream.cadvise();
    }

    private static void blockOverrun() {
        CBZip2InputStream.cadvise();
    }

    private static void cadvise() {
        System.out.println("CRC Error");
    }

    private static void compressedStreamEOF() {
        CBZip2InputStream.cadvise();
    }

    private static void crcError() {
        CBZip2InputStream.cadvise();
    }

    public int read() {
        if (this.m_streamEnd) {
            return -1;
        }
        int retChar = this.m_currentChar;
        switch (this.m_currentState) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.setupRandPartB();
                break;
            }
            case 4: {
                this.setupRandPartC();
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                this.setupNoRandPartB();
                break;
            }
            case 7: {
                this.setupNoRandPartC();
                break;
            }
        }
        return retChar;
    }

    private void setDecompressStructureSizes(int newSize100k) {
        if (0 > newSize100k || newSize100k > 9 || 0 > this.m_blockSize100k || this.m_blockSize100k > 9) {
            // empty if block
        }
        this.m_blockSize100k = newSize100k;
        if (newSize100k == 0) {
            return;
        }
        int n = 100000 * newSize100k;
        this.m_ll8 = new char[n];
        this.m_tt = new int[n];
    }

    private void setupBlock() {
        int[] cftab = new int[257];
        cftab[0] = 0;
        int i = 1;
        while (i <= 256) {
            cftab[i] = this.m_unzftab[i - 1];
            ++i;
        }
        int i2 = 1;
        while (i2 <= 256) {
            int n = i2;
            cftab[n] = cftab[n] + cftab[i2 - 1];
            ++i2;
        }
        int i3 = 0;
        while (i3 <= this.m_last) {
            char ch = this.m_ll8[i3];
            this.m_tt[cftab[ch]] = i3++;
            char c = ch;
            cftab[c] = cftab[c] + 1;
        }
        cftab = null;
        this.m_tPos = this.m_tt[this.m_origPtr];
        this.count = 0;
        this.i2 = 0;
        this.ch2 = 256;
        if (this.m_blockRandomised) {
            this.m_rNToGo = 0;
            this.m_rTPos = 0;
            this.setupRandPartA();
        } else {
            this.setupNoRandPartA();
        }
    }

    private void setupNoRandPartA() {
        if (this.i2 <= this.m_last) {
            this.chPrev = this.ch2;
            this.ch2 = this.m_ll8[this.m_tPos];
            this.m_tPos = this.m_tt[this.m_tPos];
            ++this.i2;
            this.m_currentChar = this.ch2;
            this.m_currentState = 6;
            this.m_crc.updateCRC(this.ch2);
        } else {
            this.endBlock();
            this.initBlock();
            this.setupBlock();
        }
    }

    private void setupNoRandPartB() {
        if (this.ch2 != this.chPrev) {
            this.m_currentState = 5;
            this.count = 1;
            this.setupNoRandPartA();
        } else {
            ++this.count;
            if (this.count >= 4) {
                this.z = this.m_ll8[this.m_tPos];
                this.m_tPos = this.m_tt[this.m_tPos];
                this.m_currentState = 7;
                this.j2 = 0;
                this.setupNoRandPartC();
            } else {
                this.m_currentState = 5;
                this.setupNoRandPartA();
            }
        }
    }

    private void setupNoRandPartC() {
        if (this.j2 < this.z) {
            this.m_currentChar = this.ch2;
            this.m_crc.updateCRC(this.ch2);
            ++this.j2;
        } else {
            this.m_currentState = 5;
            ++this.i2;
            this.count = 0;
            this.setupNoRandPartA();
        }
    }

    private void setupRandPartA() {
        if (this.i2 <= this.m_last) {
            this.chPrev = this.ch2;
            this.ch2 = this.m_ll8[this.m_tPos];
            this.m_tPos = this.m_tt[this.m_tPos];
            if (this.m_rNToGo == 0) {
                this.m_rNToGo = BZip2Constants.RAND_NUMS[this.m_rTPos];
                ++this.m_rTPos;
                if (this.m_rTPos == 512) {
                    this.m_rTPos = 0;
                }
            }
            --this.m_rNToGo;
            this.ch2 ^= this.m_rNToGo == 1 ? 1 : 0;
            ++this.i2;
            this.m_currentChar = this.ch2;
            this.m_currentState = 3;
            this.m_crc.updateCRC(this.ch2);
        } else {
            this.endBlock();
            this.initBlock();
            this.setupBlock();
        }
    }

    private void setupRandPartB() {
        if (this.ch2 != this.chPrev) {
            this.m_currentState = 2;
            this.count = 1;
            this.setupRandPartA();
        } else {
            ++this.count;
            if (this.count >= 4) {
                this.z = this.m_ll8[this.m_tPos];
                this.m_tPos = this.m_tt[this.m_tPos];
                if (this.m_rNToGo == 0) {
                    this.m_rNToGo = BZip2Constants.RAND_NUMS[this.m_rTPos];
                    ++this.m_rTPos;
                    if (this.m_rTPos == 512) {
                        this.m_rTPos = 0;
                    }
                }
                --this.m_rNToGo;
                this.z = (char)(this.z ^ (this.m_rNToGo == 1 ? (char)'\u0001' : '\u0000'));
                this.j2 = 0;
                this.m_currentState = 4;
                this.setupRandPartC();
            } else {
                this.m_currentState = 2;
                this.setupRandPartA();
            }
        }
    }

    private void setupRandPartC() {
        if (this.j2 < this.z) {
            this.m_currentChar = this.ch2;
            this.m_crc.updateCRC(this.ch2);
            ++this.j2;
        } else {
            this.m_currentState = 2;
            ++this.i2;
            this.count = 0;
            this.setupRandPartA();
        }
    }

    private void getAndMoveToFrontDecode() {
        int zj;
        int limitLast = 100000 * this.m_blockSize100k;
        this.m_origPtr = this.readVariableSizedInt(24);
        this.recvDecodingTables();
        int EOB = this.m_nInUse + 1;
        int groupNo = -1;
        int groupPos = 0;
        int i = 0;
        while (i <= 255) {
            this.m_unzftab[i] = 0;
            ++i;
        }
        char[] yy = new char[256];
        int i2 = 0;
        while (i2 <= 255) {
            yy[i2] = (char)i2;
            ++i2;
        }
        this.m_last = -1;
        groupPos = 49;
        char zt = this.m_selector[++groupNo];
        int zn = this.m_minLens[zt];
        int zvec = this.bsR(zn);
        while (zvec > this.m_limit[zt][zn]) {
            ++zn;
            while (this.m_bsLive < 1) {
                char thech = '\u0000';
                try {
                    thech = (char)this.m_input.read();
                }
                catch (IOException e) {
                    CBZip2InputStream.compressedStreamEOF();
                }
                if (thech == '\uffffffff') {
                    CBZip2InputStream.compressedStreamEOF();
                }
                char zzi = thech;
                this.m_bsBuff = this.m_bsBuff << 8 | zzi & 0xFF;
                this.m_bsLive += 8;
            }
            zj = this.m_bsBuff >> this.m_bsLive - 1 & 1;
            --this.m_bsLive;
            zvec = zvec << 1 | zj;
        }
        int nextSym = this.m_perm[zt][zvec - this.m_base[zt][zn]];
        while (nextSym != EOB) {
            if (nextSym == 0 || nextSym == 1) {
                char ch;
                int s = -1;
                int N = 1;
                do {
                    s = nextSym == 0 ? (s += 1 * N) : (s += 2 * N);
                    N *= 2;
                    if (groupPos == 0) {
                        ++groupNo;
                        groupPos = 50;
                    }
                    --groupPos;
                    zt = this.m_selector[groupNo];
                    zn = this.m_minLens[zt];
                    zvec = this.bsR(zn);
                    while (zvec > this.m_limit[zt][zn]) {
                        ++zn;
                        while (this.m_bsLive < 1) {
                            char thech = '\u0000';
                            try {
                                thech = (char)this.m_input.read();
                            }
                            catch (IOException e) {
                                CBZip2InputStream.compressedStreamEOF();
                            }
                            if (thech == '\uffffffff') {
                                CBZip2InputStream.compressedStreamEOF();
                            }
                            char zzi = thech;
                            this.m_bsBuff = this.m_bsBuff << 8 | zzi & 0xFF;
                            this.m_bsLive += 8;
                        }
                        zj = this.m_bsBuff >> this.m_bsLive - 1 & 1;
                        --this.m_bsLive;
                        zvec = zvec << 1 | zj;
                    }
                } while ((nextSym = this.m_perm[zt][zvec - this.m_base[zt][zn]]) == 0 || nextSym == 1);
                char c = ch = this.m_seqToUnseq[yy[0]];
                this.m_unzftab[c] = this.m_unzftab[c] + ++s;
                while (s > 0) {
                    ++this.m_last;
                    this.m_ll8[this.m_last] = ch;
                    --s;
                }
                if (this.m_last < limitLast) continue;
                CBZip2InputStream.blockOverrun();
                continue;
            }
            ++this.m_last;
            if (this.m_last >= limitLast) {
                CBZip2InputStream.blockOverrun();
            }
            char tmp = yy[nextSym - 1];
            char c = this.m_seqToUnseq[tmp];
            this.m_unzftab[c] = this.m_unzftab[c] + 1;
            this.m_ll8[this.m_last] = this.m_seqToUnseq[tmp];
            int j = nextSym - 1;
            while (j > 3) {
                yy[j] = yy[j - 1];
                yy[j - 1] = yy[j - 2];
                yy[j - 2] = yy[j - 3];
                yy[j - 3] = yy[j - 4];
                j -= 4;
            }
            while (j > 0) {
                yy[j] = yy[j - 1];
                --j;
            }
            yy[0] = tmp;
            if (groupPos == 0) {
                ++groupNo;
                groupPos = 50;
            }
            --groupPos;
            zt = this.m_selector[groupNo];
            zn = this.m_minLens[zt];
            zvec = this.bsR(zn);
            while (zvec > this.m_limit[zt][zn]) {
                ++zn;
                while (this.m_bsLive < 1) {
                    char ch = '\u0000';
                    try {
                        ch = (char)this.m_input.read();
                    }
                    catch (IOException e) {
                        CBZip2InputStream.compressedStreamEOF();
                    }
                    this.m_bsBuff = this.m_bsBuff << 8 | ch & 0xFF;
                    this.m_bsLive += 8;
                }
                zj = this.m_bsBuff >> this.m_bsLive - 1 & 1;
                --this.m_bsLive;
                zvec = zvec << 1 | zj;
            }
            nextSym = this.m_perm[zt][zvec - this.m_base[zt][zn]];
        }
    }

    private void bsFinishedWithStream() {
        this.m_input = null;
    }

    private int readVariableSizedInt(int numBits) {
        return this.bsR(numBits);
    }

    private char readUnsignedChar() {
        return (char)this.bsR(8);
    }

    private int readInt() {
        int u = 0;
        u = u << 8 | this.bsR(8);
        u = u << 8 | this.bsR(8);
        u = u << 8 | this.bsR(8);
        u = u << 8 | this.bsR(8);
        return u;
    }

    private int bsR(int n) {
        while (this.m_bsLive < n) {
            char ch = '\u0000';
            try {
                ch = (char)this.m_input.read();
            }
            catch (IOException ioe) {
                CBZip2InputStream.compressedStreamEOF();
            }
            if (ch == '\uffffffff') {
                CBZip2InputStream.compressedStreamEOF();
            }
            this.m_bsBuff = this.m_bsBuff << 8 | ch & 0xFF;
            this.m_bsLive += 8;
        }
        int result = this.m_bsBuff >> this.m_bsLive - n & (1 << n) - 1;
        this.m_bsLive -= n;
        return result;
    }

    private void bsSetStream(InputStream input) {
        this.m_input = input;
        this.m_bsLive = 0;
        this.m_bsBuff = 0;
    }

    private void complete() {
        this.m_storedCombinedCRC = this.readInt();
        if (this.m_storedCombinedCRC != this.m_computedCombinedCRC) {
            CBZip2InputStream.crcError();
        }
        this.bsFinishedWithStream();
        this.m_streamEnd = true;
    }

    private void endBlock() {
        this.m_computedBlockCRC = this.m_crc.getFinalCRC();
        if (this.m_storedBlockCRC != this.m_computedBlockCRC) {
            CBZip2InputStream.crcError();
        }
        this.m_computedCombinedCRC = this.m_computedCombinedCRC << 1 | this.m_computedCombinedCRC >>> 31;
        this.m_computedCombinedCRC ^= this.m_computedBlockCRC;
    }

    private void hbCreateDecodeTables(int[] limit, int[] base, int[] perm, char[] length, int minLen, int maxLen, int alphaSize) {
        int pp = 0;
        int i = minLen;
        while (i <= maxLen) {
            int j = 0;
            while (j < alphaSize) {
                if (length[j] == i) {
                    perm[pp] = j;
                    ++pp;
                }
                ++j;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < 23) {
            base[i2] = 0;
            ++i2;
        }
        int i3 = 0;
        while (i3 < alphaSize) {
            int n = length[i3] + '\u0001';
            base[n] = base[n] + 1;
            ++i3;
        }
        int i4 = 1;
        while (i4 < 23) {
            int n = i4;
            base[n] = base[n] + base[i4 - 1];
            ++i4;
        }
        int i5 = 0;
        while (i5 < 23) {
            limit[i5] = 0;
            ++i5;
        }
        int vec = 0;
        int i6 = minLen;
        while (i6 <= maxLen) {
            limit[i6] = (vec += base[i6 + 1] - base[i6]) - 1;
            vec <<= 1;
            ++i6;
        }
        int i7 = minLen + 1;
        while (i7 <= maxLen) {
            base[i7] = (limit[i7 - 1] + 1 << 1) - base[i7];
            ++i7;
        }
    }

    private void initBlock() {
        char magic1 = this.readUnsignedChar();
        char magic2 = this.readUnsignedChar();
        char magic3 = this.readUnsignedChar();
        char magic4 = this.readUnsignedChar();
        char magic5 = this.readUnsignedChar();
        char magic6 = this.readUnsignedChar();
        if (magic1 == '\u0017' && magic2 == 'r' && magic3 == 'E' && magic4 == '8' && magic5 == 'P' && magic6 == '\u0090') {
            this.complete();
            return;
        }
        if (magic1 != '1' || magic2 != 'A' || magic3 != 'Y' || magic4 != '&' || magic5 != 'S' || magic6 != 'Y') {
            CBZip2InputStream.badBlockHeader();
            this.m_streamEnd = true;
            return;
        }
        this.m_storedBlockCRC = this.readInt();
        this.m_blockRandomised = this.bsR(1) == 1;
        this.getAndMoveToFrontDecode();
        this.m_crc.initialiseCRC();
        this.m_currentState = 1;
    }

    private void initialize() {
        char magic3 = this.readUnsignedChar();
        char magic4 = this.readUnsignedChar();
        if (magic3 != 'h' || magic4 < '1' || magic4 > '9') {
            this.bsFinishedWithStream();
            this.m_streamEnd = true;
            return;
        }
        this.setDecompressStructureSizes(magic4 - 48);
        this.m_computedCombinedCRC = 0;
    }

    private void makeMaps() {
        this.m_nInUse = 0;
        int i = 0;
        while (i < 256) {
            if (this.m_inUse[i]) {
                this.m_seqToUnseq[this.m_nInUse] = (char)i;
                this.m_unseqToSeq[i] = (char)this.m_nInUse;
                ++this.m_nInUse;
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void recvDecodingTables() {
        this.buildInUseTable();
        this.makeMaps();
        alphaSize = this.m_nInUse + 2;
        groupCount = this.bsR(3);
        selectorCount = this.bsR(15);
        i = 0;
        while (i < selectorCount) {
            run = 0;
            while (this.bsR(1) == 1) {
                ++run;
            }
            this.m_selectorMtf[i] = (char)run;
            ++i;
        }
        pos = new char[6];
        v = 0;
        while (v < groupCount) {
            pos[v] = v;
            v = (char)(v + 1);
        }
        i = 0;
        while (i < selectorCount) {
            v = this.m_selectorMtf[i];
            tmp = pos[v];
            while (v > 0) {
                pos[v] = pos[v - '\u0001'];
                --v;
            }
            pos[0] = tmp;
            this.m_selector[i] = tmp;
            ++i;
        }
        len = new char[6][258];
        i = 0;
        while (i < groupCount) {
            curr = this.bsR(5);
            j = 0;
            ** GOTO lbl44
            {
                curr = this.bsR(1) == 0 ? ++curr : --curr;
                do {
                    if (this.bsR(1) == 1) continue block6;
                    len[i][j] = (char)curr;
                    ++j;
lbl44:
                    // 2 sources

                } while (j < alphaSize);
            }
            ++i;
        }
        k = 0;
        while (k < groupCount) {
            minLen = 32;
            maxLen = '\u0000';
            i = 0;
            while (i < alphaSize) {
                if (len[k][i] > maxLen) {
                    maxLen = len[k][i];
                }
                if (len[k][i] < minLen) {
                    minLen = len[k][i];
                }
                ++i;
            }
            this.hbCreateDecodeTables(this.m_limit[k], this.m_base[k], this.m_perm[k], len[k], minLen, maxLen, alphaSize);
            this.m_minLens[k] = minLen;
            ++k;
        }
    }

    private void buildInUseTable() {
        boolean[] inUse16 = new boolean[16];
        int i = 0;
        while (i < 16) {
            inUse16[i] = this.bsR(1) == 1;
            ++i;
        }
        int i2 = 0;
        while (i2 < 256) {
            this.m_inUse[i2] = false;
            ++i2;
        }
        int i3 = 0;
        while (i3 < 16) {
            if (inUse16[i3]) {
                int j = 0;
                while (j < 16) {
                    if (this.bsR(1) == 1) {
                        this.m_inUse[i3 * 16 + j] = true;
                    }
                    ++j;
                }
            }
            ++i3;
        }
    }
}

