/* Copyright (c) 2001-2007, David A. Clunie DBA Pixelmed Publishing. All rights reserved. */

package com.pixelmed.display;

import com.pixelmed.utils.MessageLogger;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.JDialog; 
import javax.swing.JScrollPane; 
import javax.swing.JTextArea; 

/**
 * <p>A class to write log and status messages to a scrolling text area in a dialog box.</p>
 *
 * @author      dclunie
 */
public class DialogMessageLogger implements MessageLogger {

	protected JDialog outputDialog;
	protected JScrollPane outputScrollPane;
	protected JTextArea outputTextArea;

	/**
	 * <p>Construct a logger.</p>
	 *
	 * @param	titleMessage			for the title bar of the dialog box
	 * @param	width					initial width of the resizeable dialog box
	 * @param	height					initial height of the resizeable dialog box
	 * @param	exitApplicationOnClose	if true, when the dialog box is closed (X-d out), will exit the application with success status
	 */
	public DialogMessageLogger(String titleMessage,int width,int height,boolean exitApplicationOnClose) {
		outputTextArea = new JTextArea();
		outputScrollPane = new JScrollPane(outputTextArea);
		outputDialog = new JDialog();
		outputDialog.setSize(width,height);
		outputDialog.setTitle(titleMessage);
		outputDialog.getContentPane().add(outputScrollPane);
		outputDialog.setVisible(true);
		if (exitApplicationOnClose) {
			outputDialog.addWindowListener(new WindowAdapter() {
				public void windowClosing(WindowEvent e) {
//System.err.println("DialogMessageLogger.WindowAdapter.windowClosing()");
					//dispose();
					System.exit(0);
				}
			});
		}
	}
	
	public void send(String message) {
		outputTextArea.append(message);
	}
		
	public void sendLn(String message) {
		outputTextArea.append(message+"\n");
	}
}

