/*
 * ModifyRuleUI.java
 *
 * Created on February 6, 2008, 9:04 AM
 */

package interfaces;

import java.util.*;
import java.io.*;
import org.jdom.*;
import org.jdom.output.XMLOutputter;
import org.jdom.input.SAXBuilder;

/**
 *
 * @author  meme
 */
public class ModifyRuleUI extends javax.swing.JFrame {
    
    /** Creates new form ModifyRuleUI */
    public ModifyRuleUI(UploadUI _parent, String _rulegroup_name)
    {
        parent = _parent;
        rulegroup_name = _rulegroup_name;
        selected_rule = -1;
        selected_subrule = -1;
        initComponents();
    }
    
    private void initComponents()
    {
        jPanel0 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        RuleNew = new javax.swing.JButton();
        RuleDelete = new javax.swing.JButton();
        RuleMoveUp = new javax.swing.JButton();
        RuleMoveDown = new javax.swing.JButton();
        RuleDone = new javax.swing.JButton();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        jLabel4 = new javax.swing.JLabel();
        jLabel5 = new javax.swing.JLabel();
        jPanel2 = new ArrayList<javax.swing.JPanel>();
        jLabel7 = new ArrayList<javax.swing.JLabel>();
        RuleNewSubrule = new ArrayList<javax.swing.JButton>();
        RuleDeleteSubrule = new ArrayList<javax.swing.JButton>();
        RuleMoveSubruleUp = new ArrayList<javax.swing.JButton>();
        RuleMoveSubruleDown = new ArrayList<javax.swing.JButton>();
        RuleOnSuccess = new ArrayList<javax.swing.JTextField>();
        jPanelSubrule = new ArrayList<ArrayList<javax.swing.JPanel>>();
        jLabel6 = new ArrayList<ArrayList<javax.swing.JLabel>>();
        RuleUngroup = new ArrayList<ArrayList<javax.swing.JButton>>();
        RuleSource = new ArrayList<ArrayList<javax.swing.JComboBox>>();
        RuleField = new ArrayList<ArrayList<javax.swing.JTextField>>();
        RuleRegularExpression = new ArrayList<ArrayList<javax.swing.JTextField>>();
        RuleGrouping = new ArrayList<ArrayList<javax.swing.JComboBox>>();
        RuleGroup = new ArrayList<ArrayList<javax.swing.JButton>>();
        RuleDepth = new ArrayList<ArrayList<Integer>>();
        parentheses = new ArrayList<javax.swing.JLabel>();

        jPanel0.setBackground(new java.awt.Color(184, 169, 136));
        jPanel0.setBorder(new javax.swing.border.SoftBevelBorder(javax.swing.border.BevelBorder.RAISED));
        jScrollPane1.setHorizontalScrollBarPolicy(javax.swing.ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
        jScrollPane1.setVerticalScrollBarPolicy(javax.swing.ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
        jLabel1.setText("Ungroup");
        jLabel2.setText("Source");
        jLabel3.setText("Field, Regular Expression");
        jLabel4.setText("Grouping");
        jLabel5.setText("Group");
        RuleNew.setText("New");
        RuleDelete.setText("Delete");
        RuleMoveUp.setText("Move Up");
        RuleMoveDown.setText("Move Down");
        RuleDone.setText("Done");

        RuleNew.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                RuleNewMouseClicked();
            }
        });

        RuleDelete.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                RuleDeleteMouseClicked();
            }
        });

        RuleMoveUp.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                RuleMoveUpMouseClicked();
            }
        });

        RuleMoveDown.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                RuleMoveDownMouseClicked();
            }
        });

        RuleDone.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                RuleDoneMouseClicked();
            }
        });

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);

        redraw_dialog();
    }
    
    private void add_rule()
    {
        if (selected_rule >= 0)
        {
          jPanel2.get(selected_rule).setBackground(new java.awt.Color(232, 219, 191));
          if (selected_subrule >= 0)
              jPanelSubrule.get(selected_rule).get(selected_subrule).setBackground(new java.awt.Color(220, 200, 170));
        }
        
        selected_subrule = -1;
        selected_rule++;
        
        jPanel2.add(selected_rule, new javax.swing.JPanel());
        jPanel2.get(selected_rule).setBackground(new java.awt.Color(210, 190, 160));
        jPanel2.get(selected_rule).setBorder(new javax.swing.border.SoftBevelBorder(javax.swing.border.BevelBorder.RAISED));

        jLabel7.add(selected_rule, new javax.swing.JLabel());
        jLabel7.get(selected_rule).setText("On success:");

        RuleOnSuccess.add(selected_rule, new javax.swing.JTextField());
        RuleOnSuccess.get(selected_rule).setText("");

        RuleNewSubrule.add(selected_rule, new javax.swing.JButton());
        RuleNewSubrule.get(selected_rule).setText("New");

        RuleDeleteSubrule.add(selected_rule, new javax.swing.JButton());
        RuleDeleteSubrule.get(selected_rule).setText("Delete");

        RuleMoveSubruleUp.add(selected_rule, new javax.swing.JButton());
        RuleMoveSubruleUp.get(selected_rule).setText("Up");
        
        RuleMoveSubruleDown.add(selected_rule, new javax.swing.JButton());
        RuleMoveSubruleDown.get(selected_rule).setText("Down");

        jPanelSubrule.add(selected_rule, new ArrayList<javax.swing.JPanel>());
        jLabel6.add(selected_rule, new ArrayList<javax.swing.JLabel>());
        RuleUngroup.add(selected_rule, new ArrayList<javax.swing.JButton>());
        RuleSource.add(selected_rule, new ArrayList<javax.swing.JComboBox>());
        RuleField.add(selected_rule, new ArrayList<javax.swing.JTextField>());
        RuleRegularExpression.add(selected_rule, new ArrayList<javax.swing.JTextField>());
        RuleGrouping.add(selected_rule, new ArrayList<javax.swing.JComboBox>());
        RuleGroup.add(selected_rule, new ArrayList<javax.swing.JButton>());
        RuleDepth.add(selected_rule, new ArrayList<Integer>());

        reset_listeners();
    }
    
    private void add_subrule()
    {
        if ((selected_rule >= 0) && (selected_subrule >= 0))
          jPanelSubrule.get(selected_rule).get(selected_subrule).setBackground(new java.awt.Color(220, 200, 170));

        selected_subrule++;

        jPanelSubrule.get(selected_rule).add(selected_subrule, new javax.swing.JPanel());
        jPanelSubrule.get(selected_rule).get(selected_subrule).setBackground(new java.awt.Color(252, 239, 211));
        jPanelSubrule.get(selected_rule).get(selected_subrule).setBorder(new javax.swing.border.SoftBevelBorder(javax.swing.border.BevelBorder.RAISED));
        
        jLabel6.get(selected_rule).add(selected_subrule, new javax.swing.JLabel());
        jLabel6.get(selected_rule).get(selected_subrule).setText(",");

        RuleUngroup.get(selected_rule).add(selected_subrule, new javax.swing.JButton());
        RuleUngroup.get(selected_rule).get(selected_subrule).setText("<");
        
        RuleSource.get(selected_rule).add(selected_subrule, new javax.swing.JComboBox());
        RuleSource.get(selected_rule).get(selected_subrule).setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Path", "DicomHeaderField", "Calculated", "Strings", "TabID", "SubtabID" }));

        RuleField.get(selected_rule).add(selected_subrule, new javax.swing.JTextField());
        RuleField.get(selected_rule).get(selected_subrule).setText("");

        RuleRegularExpression.get(selected_rule).add(selected_subrule, new javax.swing.JTextField());
        RuleRegularExpression.get(selected_rule).get(selected_subrule).setText("");

        RuleGrouping.get(selected_rule).add(selected_subrule, new javax.swing.JComboBox());
        RuleGrouping.get(selected_rule).get(selected_subrule).setModel(new javax.swing.DefaultComboBoxModel(new String[] { "AND", "OR" }));
        
        RuleGroup.get(selected_rule).add(selected_subrule, new javax.swing.JButton());
        RuleGroup.get(selected_rule).get(selected_subrule).setText(">");
        
        if (selected_subrule >= 1)
          RuleDepth.get(selected_rule).add(selected_subrule, RuleDepth.get(selected_rule).get(selected_subrule - 1));
        else
          RuleDepth.get(selected_rule).add(selected_subrule, new Integer(0));
        
        reset_listeners();
    }
    
    private void redraw_dialog()
    {
        jPanel0.removeAll();
        for (int rule = 0; rule < jPanel2.size(); rule++)
        {
            jPanel2.get(rule).removeAll();
            javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2.get(rule));
            jPanel2.get(rule).setLayout(jPanel2Layout);
            javax.swing.GroupLayout.ParallelGroup parallelGroup1 = jPanel2Layout.createParallelGroup();

            parentheses.clear();
            int parentheses_index = 0;
            int last_depth = 0;
            for (int subrule = 0; subrule < jPanelSubrule.get(rule).size(); subrule++)
            {
                jPanelSubrule.get(rule).get(subrule).removeAll();
                javax.swing.GroupLayout jPanelSubruleLayout = new javax.swing.GroupLayout(jPanelSubrule.get(rule).get(subrule));
                jPanelSubrule.get(rule).get(subrule).setLayout(jPanelSubruleLayout);
                int depth = RuleDepth.get(rule).get(subrule);
                while (last_depth > depth)
                {
                    last_depth--;
                    parentheses.add(new javax.swing.JLabel(")"));
                    parallelGroup1.addGroup(jPanel2Layout.createSequentialGroup()
                                                         .addGap(last_depth * 20, last_depth * 20, last_depth * 20)
                                                         .addComponent(parentheses.get(parentheses_index)));
                    parentheses_index++;
                }
                while (last_depth < depth)
                {
                    parentheses.add(new javax.swing.JLabel("("));
                    parallelGroup1.addGroup(jPanel2Layout.createSequentialGroup()
                                                         .addGap(last_depth * 20, last_depth * 20, last_depth * 20)
                                                         .addComponent(parentheses.get(parentheses_index)));
                    last_depth++;
                    parentheses_index++;
                }

                jPanelSubruleLayout.setHorizontalGroup(
                    jPanelSubruleLayout.createSequentialGroup()
                    .addGap(depth * 20, depth * 20, depth * 20)
                    .addComponent(RuleUngroup.get(rule).get(subrule))
                    .addGap(14, 14, 14)
                    .addComponent(RuleSource.get(rule).get(subrule), javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGap(16, 16, 16)
                    .addComponent(RuleField.get(rule).get(subrule), javax.swing.GroupLayout.PREFERRED_SIZE, 77, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGap(3, 3, 3)
                    .addComponent(jLabel6.get(rule).get(subrule))
                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                    .addComponent(RuleRegularExpression.get(rule).get(subrule), javax.swing.GroupLayout.PREFERRED_SIZE, 246, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGap(16, 16, 16)
                    .addComponent(RuleGrouping.get(rule).get(subrule), javax.swing.GroupLayout.PREFERRED_SIZE, 58, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGap(14, 14, 14)
                    .addComponent(RuleGroup.get(rule).get(subrule))
                );

                jPanelSubruleLayout.setVerticalGroup(
                    jPanelSubruleLayout.createParallelGroup()
                    .addComponent(RuleUngroup.get(rule).get(subrule))
                    .addComponent(RuleSource.get(rule).get(subrule), javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(RuleField.get(rule).get(subrule), javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel6.get(rule).get(subrule))
                    .addComponent(RuleRegularExpression.get(rule).get(subrule), javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(RuleGrouping.get(rule).get(subrule), javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(RuleGroup.get(rule).get(subrule))
                );

                parallelGroup1.addGroup(jPanel2Layout.createSequentialGroup()
                    .addComponent(jPanelSubrule.get(rule).get(subrule))
                );
            }
            while (last_depth > 0)
            {
                last_depth--;
                parentheses.add(new javax.swing.JLabel(")"));
                parallelGroup1.addGroup(jPanel2Layout.createSequentialGroup()
                                                     .addGap(last_depth * 20, last_depth * 20, last_depth * 20)
                                                     .addComponent(parentheses.get(parentheses_index)));
                parentheses_index++;
            }

            jPanel2Layout.setHorizontalGroup(
                jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                .addGroup(jPanel2Layout.createSequentialGroup()
                    .addContainerGap()
                    .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                        .addGroup(parallelGroup1)
                        .addGroup(jPanel2Layout.createSequentialGroup()
                            .addComponent(jLabel7.get(rule))
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(RuleOnSuccess.get(rule), javax.swing.GroupLayout.PREFERRED_SIZE, 221, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(RuleNewSubrule.get(rule))
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(RuleDeleteSubrule.get(rule))
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(RuleMoveSubruleUp.get(rule))
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(RuleMoveSubruleDown.get(rule))))
                    .addContainerGap(22, Short.MAX_VALUE))
            );
            javax.swing.GroupLayout.SequentialGroup sequentialGroup1 = jPanel2Layout.createSequentialGroup();
            last_depth = 0;
            parentheses_index = 0;
            for (int subrule = 0; subrule < jPanelSubrule.get(rule).size(); subrule++)
            {
                int depth = RuleDepth.get(rule).get(subrule);
                while (last_depth > depth)
                {
                    last_depth--;
                    sequentialGroup1.addGroup(jPanel2Layout.createSequentialGroup()
                                                         .addGap(last_depth * 20, last_depth * 20, last_depth * 20)
                                                         .addComponent(parentheses.get(parentheses_index)));
                    parentheses_index++;
                }
                while (last_depth < depth)
                {
                    sequentialGroup1.addGroup(jPanel2Layout.createSequentialGroup()
                                                         .addGap(last_depth * 20, last_depth * 20, last_depth * 20)
                                                         .addComponent(parentheses.get(parentheses_index)));
                    last_depth++;
                    parentheses_index++;
                }
                sequentialGroup1.addComponent(jPanelSubrule.get(rule).get(subrule));
            }
            while (last_depth > 0)
            {
                last_depth--;
                sequentialGroup1.addGroup(jPanel2Layout.createSequentialGroup()
                                                     .addGap(last_depth * 20, last_depth * 20, last_depth * 20)
                                                     .addComponent(parentheses.get(parentheses_index)));
                parentheses_index++;
            }
            jPanel2Layout.setVerticalGroup(
                jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup()
                    .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(sequentialGroup1)
                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                    .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(jLabel7.get(rule))
                        .addComponent(RuleMoveSubruleDown.get(rule))
                        .addComponent(RuleMoveSubruleUp.get(rule))
                        .addComponent(RuleDeleteSubrule.get(rule))
                        .addComponent(RuleNewSubrule.get(rule))
                        .addComponent(RuleOnSuccess.get(rule), javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addContainerGap())
            );
        }

        javax.swing.GroupLayout jPanel0Layout = new javax.swing.GroupLayout(jPanel0);
        jPanel0.setLayout(jPanel0Layout);
        javax.swing.GroupLayout.ParallelGroup sequentialGroup1 = jPanel0Layout.createParallelGroup();
        for (int rule = 0; rule < jPanel2.size(); rule++)
        {
            sequentialGroup1.addComponent(jPanel2.get(rule), javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE);
//                            .addContainerGap(154, Short.MAX_VALUE);
        }
        jPanel0Layout.setHorizontalGroup(
            jPanel0Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(sequentialGroup1)
        );
        javax.swing.GroupLayout.SequentialGroup sequentialGroup2 = jPanel0Layout.createSequentialGroup();
        sequentialGroup2.addContainerGap();
        for (int rule = 0; rule < jPanel2.size(); rule++)
        {
            sequentialGroup2.addComponent(jPanel2.get(rule), javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addContainerGap(10, Short.MAX_VALUE);
        }
        sequentialGroup2.addContainerGap(355, Short.MAX_VALUE);
        jPanel0Layout.setVerticalGroup(
            jPanel0Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(sequentialGroup2)
        );
        jScrollPane1.setViewportView(jPanel0);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(27, 27, 27)
                .addComponent(jLabel1)
                .addGap(24, 24, 24)
                .addComponent(jLabel2)
                .addGap(109, 109, 109)
                .addComponent(jLabel3)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 120, Short.MAX_VALUE)
                .addComponent(jLabel4)
                .addGap(19, 19, 19)
                .addComponent(jLabel5)
                .addGap(32, 32, 32))
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 800, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(RuleNew)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(RuleDelete)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(RuleMoveUp)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(RuleMoveDown)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 238, Short.MAX_VALUE)
                        .addComponent(RuleDone)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(jLabel3)
                        .addComponent(jLabel2)
                        .addComponent(jLabel1))
                    .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(jLabel5)
                        .addComponent(jLabel4)))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 482, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(RuleDone)
                    .addComponent(RuleMoveDown)
                    .addComponent(RuleMoveUp)
                    .addComponent(RuleDelete)
                    .addComponent(RuleNew))
                .addContainerGap())
        );
        pack();
        repaint();
    }
    
    public void set_rulegroup(UploadUI.RuleGroup r)
    {
        for (Iterator rule_iterator = r.rules.iterator(); rule_iterator.hasNext(); )
        {
            if ((selected_rule >= 0) && (selected_subrule >= 0))
                jPanelSubrule.get(selected_rule).get(selected_subrule).setBackground(new java.awt.Color(220, 200, 170));
        
            selected_subrule = -1;
            UploadUI.Rule rule = (UploadUI.Rule)rule_iterator.next();
            set_rule(rule);
        }
        redraw_dialog();
    }
    
    public void set_rule(UploadUI.Rule r)
    {
        add_rule();
        RuleOnSuccess.get(selected_rule).setText(r.on_success);
        for (Iterator subrule_iterator = r.subrules.iterator(); subrule_iterator.hasNext(); )
        {
            UploadUI.SubRule subrule = (UploadUI.SubRule)subrule_iterator.next();
            set_subrule(subrule);
        }
    }
    
    public void set_subrule(UploadUI.SubRule r)
    {
        add_subrule();
        RuleSource.get(selected_rule).get(selected_subrule).setSelectedItem(r.source);
        RuleField.get(selected_rule).get(selected_subrule).setText(r.field);
        RuleRegularExpression.get(selected_rule).get(selected_subrule).setText(r.regexp);
        RuleGrouping.get(selected_rule).get(selected_subrule).setSelectedItem(r.grouping);
        RuleDepth.get(selected_rule).set(selected_subrule, new Integer(r.depth));
    }

    private void RuleNewMouseClicked()
    {
        add_rule();
        redraw_dialog();
    }
    
    private void RuleDeleteMouseClicked()
    {
        jPanel2.remove(selected_rule);
        jLabel7.remove(selected_rule);
        RuleOnSuccess.remove(selected_rule);
        RuleNewSubrule.remove(selected_rule);
        RuleDeleteSubrule.remove(selected_rule);
        RuleMoveSubruleUp.remove(selected_rule);
        RuleMoveSubruleDown.remove(selected_rule);
        jPanelSubrule.remove(selected_rule);
        jLabel6.remove(selected_rule);
        RuleUngroup.remove(selected_rule);
        RuleSource.remove(selected_rule);
        RuleField.remove(selected_rule);
        RuleRegularExpression.remove(selected_rule);
        RuleGrouping.remove(selected_rule);
        RuleGroup.remove(selected_rule);
        RuleDepth.remove(selected_rule);

        if (selected_rule >= jPanel2.size())
            selected_rule--;
        
        reset_listeners();
        redraw_dialog();
    }
    
    private void RuleMoveUpMouseClicked()
    {
        if (selected_rule <= 0)
            return;
        
        jPanel2.add(selected_rule - 1, jPanel2.get(selected_rule));
        jPanel2.remove(selected_rule + 1);

        jLabel7.add(selected_rule - 1, jLabel7.get(selected_rule));
        jLabel7.remove(selected_rule + 1);

        RuleOnSuccess.add(selected_rule - 1, RuleOnSuccess.get(selected_rule));
        RuleOnSuccess.remove(selected_rule + 1);
        
        RuleNewSubrule.add(selected_rule - 1, RuleNewSubrule.get(selected_rule));
        RuleNewSubrule.remove(selected_rule + 1);
        
        RuleDeleteSubrule.add(selected_rule - 1, RuleDeleteSubrule.get(selected_rule));
        RuleDeleteSubrule.remove(selected_rule + 1);
        
        RuleMoveSubruleUp.add(selected_rule - 1, RuleMoveSubruleUp.get(selected_rule));
        RuleMoveSubruleUp.remove(selected_rule + 1);
        
        RuleMoveSubruleDown.add(selected_rule - 1, RuleMoveSubruleDown.get(selected_rule));
        RuleMoveSubruleDown.remove(selected_rule + 1);
        
        jPanelSubrule.add(selected_rule - 1, jPanelSubrule.get(selected_rule));
        jPanelSubrule.remove(selected_rule + 1);
        
        jLabel6.add(selected_rule - 1, jLabel6.get(selected_rule));
        jLabel6.remove(selected_rule + 1);
        
        RuleUngroup.add(selected_rule - 1, RuleUngroup.get(selected_rule));
        RuleUngroup.remove(selected_rule + 1);
        
        RuleSource.add(selected_rule - 1, RuleSource.get(selected_rule));
        RuleSource.remove(selected_rule + 1);
        
        RuleField.add(selected_rule - 1, RuleField.get(selected_rule));
        RuleField.remove(selected_rule + 1);
        
        RuleRegularExpression.add(selected_rule - 1, RuleRegularExpression.get(selected_rule));
        RuleRegularExpression.remove(selected_rule + 1);
        
        RuleGrouping.add(selected_rule - 1, RuleGrouping.get(selected_rule));
        RuleGrouping.remove(selected_rule + 1);
        
        RuleGroup.add(selected_rule - 1, RuleGroup.get(selected_rule));
        RuleGroup.remove(selected_rule + 1);
        
        RuleDepth.add(selected_rule - 1, RuleDepth.get(selected_rule));
        RuleDepth.remove(selected_rule + 1);
        
        selected_rule--;
        
        reset_listeners();
        redraw_dialog();
    }
    
    private void RuleMoveDownMouseClicked()
    {
        if (selected_rule >= jPanel2.size() - 1)
            return;
        
        jPanel2.add(selected_rule + 2, jPanel2.get(selected_rule));
        jPanel2.remove(selected_rule);

        jLabel7.add(selected_rule + 2, jLabel7.get(selected_rule));
        jLabel7.remove(selected_rule);

        RuleOnSuccess.add(selected_rule + 2, RuleOnSuccess.get(selected_rule));
        RuleOnSuccess.remove(selected_rule);
        
        RuleNewSubrule.add(selected_rule + 2, RuleNewSubrule.get(selected_rule));
        RuleNewSubrule.remove(selected_rule);
        
        RuleDeleteSubrule.add(selected_rule + 2, RuleDeleteSubrule.get(selected_rule));
        RuleDeleteSubrule.remove(selected_rule);
        
        RuleMoveSubruleUp.add(selected_rule + 2, RuleMoveSubruleUp.get(selected_rule));
        RuleMoveSubruleUp.remove(selected_rule);
       
        RuleMoveSubruleDown.add(selected_rule + 2, RuleMoveSubruleDown.get(selected_rule));
        RuleMoveSubruleDown.remove(selected_rule);
        
        jPanelSubrule.add(selected_rule + 2, jPanelSubrule.get(selected_rule));
        jPanelSubrule.remove(selected_rule);
        
        jLabel6.add(selected_rule + 2, jLabel6.get(selected_rule));
        jLabel6.remove(selected_rule);
        
        RuleUngroup.add(selected_rule + 2, RuleUngroup.get(selected_rule));
        RuleUngroup.remove(selected_rule);
        
        RuleSource.add(selected_rule + 2, RuleSource.get(selected_rule));
        RuleSource.remove(selected_rule);
        
        RuleField.add(selected_rule + 2, RuleField.get(selected_rule));
        RuleField.remove(selected_rule);
        
        RuleRegularExpression.add(selected_rule + 2, RuleRegularExpression.get(selected_rule));
        RuleRegularExpression.remove(selected_rule);
        
        RuleGrouping.add(selected_rule + 2, RuleGrouping.get(selected_rule));
        RuleGrouping.remove(selected_rule);
        
        RuleGroup.add(selected_rule + 2, RuleGroup.get(selected_rule));
        RuleGroup.remove(selected_rule);
        
        RuleDepth.add(selected_rule + 2, RuleDepth.get(selected_rule));
        RuleDepth.remove(selected_rule);

        selected_rule++;
        
        reset_listeners();
        redraw_dialog();
    }

    private void RuleDoneMouseClicked()
    {
        UploadUI.RuleGroup rule_group = parent.new RuleGroup();
        for (int rule_id = 0; rule_id < jPanel2.size(); rule_id++)
        {
            UploadUI.Rule rule = parent.new Rule();
            rule.on_success = RuleOnSuccess.get(rule_id).getText();
            for (int subrule_id = 0; subrule_id < jLabel6.get(rule_id).size(); subrule_id++)
            {
                UploadUI.SubRule subrule = parent.new SubRule();
                subrule.source = RuleSource.get(rule_id).get(subrule_id).getSelectedItem().toString();
                subrule.field = RuleField.get(rule_id).get(subrule_id).getText();
                subrule.regexp = RuleRegularExpression.get(rule_id).get(subrule_id).getText();
                subrule.grouping = RuleGrouping.get(rule_id).get(subrule_id).getSelectedItem().toString();
                subrule.depth = RuleDepth.get(rule_id).get(subrule_id);
                rule.subrules.add(subrule);
            }
            rule_group.rules.add(rule);
        }

        parent.update_rulegroup(rulegroup_name, rule_group);
        parent.save_rules();
        dispose();
    }

    private void RuleNewSubruleMouseClicked(int rule)
    {
        SetRuleFocus(rule);
        add_subrule();
        redraw_dialog();
    }

    private void RuleDeleteSubruleMouseClicked(int rule)
    {
        System.out.println("Deleting subrule from " + rule + " at " + selected_rule + ", " + selected_subrule);

        SetRuleFocus(rule);

        jPanelSubrule.get(selected_rule).remove(selected_subrule);
        jLabel6.get(selected_rule).remove(selected_subrule);
        RuleUngroup.get(selected_rule).remove(selected_subrule);
        RuleSource.get(selected_rule).remove(selected_subrule);
        RuleField.get(selected_rule).remove(selected_subrule);
        RuleRegularExpression.get(selected_rule).remove(selected_subrule);
        RuleGrouping.get(selected_rule).remove(selected_subrule);
        RuleGroup.get(selected_rule).remove(selected_subrule);
        RuleDepth.get(selected_rule).remove(selected_subrule);

        if (selected_subrule >= jPanelSubrule.get(rule).size())
            SetFocus(rule, jPanelSubrule.get(rule).size() - 1);

        reset_listeners();
        redraw_dialog();
    }

    private void RuleMoveSubruleUpMouseClicked(int rule)
    {
        SetRuleFocus(rule);

        if (selected_subrule <= 0)
            return;
        
        jPanelSubrule.get(selected_rule).add(selected_subrule - 1, jPanelSubrule.get(selected_rule).get(selected_subrule));
        jPanelSubrule.get(selected_rule).remove(selected_subrule + 1);

        jLabel6.get(selected_rule).add(selected_subrule - 1, jLabel6.get(selected_rule).get(selected_subrule));
        jLabel6.get(selected_rule).remove(selected_subrule + 1);

        RuleUngroup.get(selected_rule).add(selected_subrule - 1, RuleUngroup.get(selected_rule).get(selected_subrule));
        RuleUngroup.get(selected_rule).remove(selected_subrule + 1);

        RuleSource.get(selected_rule).add(selected_subrule - 1, RuleSource.get(selected_rule).get(selected_subrule));
        RuleSource.get(selected_rule).remove(selected_subrule + 1);

        RuleField.get(selected_rule).add(selected_subrule - 1, RuleField.get(selected_rule).get(selected_subrule));
        RuleField.get(selected_rule).remove(selected_subrule + 1);
        
        RuleRegularExpression.get(selected_rule).add(selected_subrule - 1, RuleRegularExpression.get(selected_rule).get(selected_subrule));
        RuleRegularExpression.get(selected_rule).remove(selected_subrule + 1);
        
        RuleGrouping.get(selected_rule).add(selected_subrule - 1, RuleGrouping.get(selected_rule).get(selected_subrule));
        RuleGrouping.get(selected_rule).remove(selected_subrule + 1);
        
        RuleGroup.get(selected_rule).add(selected_subrule - 1, RuleGroup.get(selected_rule).get(selected_subrule));
        RuleGroup.get(selected_rule).remove(selected_subrule + 1);
        
        RuleDepth.get(selected_rule).add(selected_subrule - 1, RuleDepth.get(selected_rule).get(selected_subrule));
        RuleDepth.get(selected_rule).remove(selected_subrule + 1);


        selected_subrule--;

        reset_listeners();
        redraw_dialog();
    }

    private void RuleMoveSubruleDownMouseClicked(int rule)
    {
        SetRuleFocus(rule);

        if (selected_subrule >= jPanelSubrule.get(selected_rule).size() - 1)
            return;
        
        jPanelSubrule.get(selected_rule).add(selected_subrule + 2, jPanelSubrule.get(selected_rule).get(selected_subrule));
        jPanelSubrule.get(selected_rule).remove(selected_subrule);

        jLabel6.get(selected_rule).add(selected_subrule + 2, jLabel6.get(selected_rule).get(selected_subrule));
        jLabel6.get(selected_rule).remove(selected_subrule);

        RuleUngroup.get(selected_rule).add(selected_subrule + 2, RuleUngroup.get(selected_rule).get(selected_subrule));
        RuleUngroup.get(selected_rule).remove(selected_subrule);

        RuleSource.get(selected_rule).add(selected_subrule + 2, RuleSource.get(selected_rule).get(selected_subrule));
        RuleSource.get(selected_rule).remove(selected_subrule);

        RuleField.get(selected_rule).add(selected_subrule + 2, RuleField.get(selected_rule).get(selected_subrule));
        RuleField.get(selected_rule).remove(selected_subrule);
        
        RuleRegularExpression.get(selected_rule).add(selected_subrule + 2, RuleRegularExpression.get(selected_rule).get(selected_subrule));
        RuleRegularExpression.get(selected_rule).remove(selected_subrule);
        
        RuleGrouping.get(selected_rule).add(selected_subrule + 2, RuleGrouping.get(selected_rule).get(selected_subrule));
        RuleGrouping.get(selected_rule).remove(selected_subrule);
        
        RuleGroup.get(selected_rule).add(selected_subrule + 2, RuleGroup.get(selected_rule).get(selected_subrule));
        RuleGroup.get(selected_rule).remove(selected_subrule);
        
        RuleDepth.get(selected_rule).add(selected_subrule + 2, RuleDepth.get(selected_rule).get(selected_subrule));
        RuleDepth.get(selected_rule).remove(selected_subrule);

        selected_subrule++;
        
        reset_listeners();
        redraw_dialog();
    }

    private void RuleGroupMouseClicked(int rule, int subrule)
    {
        SetFocus(rule, subrule);
        
        RuleDepth.get(rule).set(subrule, RuleDepth.get(rule).get(subrule) + 1);
        
        redraw_dialog();
    }

    private void RuleUngroupMouseClicked(int rule, int subrule)
    {
        SetFocus(rule, subrule);

        if (RuleDepth.get(rule).get(subrule) > 0)
            RuleDepth.get(rule).set(subrule, RuleDepth.get(rule).get(subrule) - 1);
        
        redraw_dialog();
    }

    private void SetRuleFocus(int rule)
    {
        if (rule != selected_rule)
        {
            if ((selected_rule >= 0) && (selected_rule < jPanel2.size()))
            {
                jPanel2.get(selected_rule).setBackground(new java.awt.Color(232, 219, 191));
                if ((selected_subrule >= 0) && (selected_subrule < jPanelSubrule.get(selected_rule).size()))
                    jPanelSubrule.get(selected_rule).get(selected_subrule).setBackground(new java.awt.Color(220, 200, 170));
            }
            selected_rule = rule;
            jPanel2.get(selected_rule).setBackground(new java.awt.Color(210, 190, 160));
            selected_subrule = jPanelSubrule.get(rule).size() - 1;
            if (selected_subrule >= 0)
                jPanelSubrule.get(rule).get(selected_subrule).setBackground(new java.awt.Color(252, 239, 211));
            pack();
        }
    }

    private void SetFocus(int rule, int subrule)
    {
        System.out.println("Setting focus to " + rule + ", " + subrule + " from " + selected_rule + ", " + selected_subrule);
        if ((selected_rule >= 0) && (selected_rule < jPanel2.size()))
        {
            jPanel2.get(selected_rule).setBackground(new java.awt.Color(232, 219, 191));
            if ((selected_subrule >= 0) && (selected_subrule < jPanelSubrule.get(selected_rule).size()))
                jPanelSubrule.get(selected_rule).get(selected_subrule).setBackground(new java.awt.Color(220, 200, 170));
        }
        if (rule != selected_rule)
        {
            selected_rule = rule;
        }
        selected_subrule = subrule;
        jPanel2.get(rule).setBackground(new java.awt.Color(210, 190, 160));
        jPanelSubrule.get(rule).get(subrule).setBackground(new java.awt.Color(252, 239, 211));
        pack();
    }
    
    private void reset_listeners()
    {
        for (int rule = 0; rule < jPanel2.size(); rule++)
        {
            final int x = rule;
            remove_last_mouse_listener(jPanel2.get(rule));
            jPanel2.get(rule).addMouseListener(new java.awt.event.MouseAdapter() {
                public void mouseClicked(java.awt.event.MouseEvent evt) {
                    SetRuleFocus(x);
                    jPanel2.get(x).requestFocus();
                }
            });
            remove_last_mouse_listener(jLabel7.get(rule));
            jLabel7.get(rule).addMouseListener(new java.awt.event.MouseAdapter() {
                public void mouseClicked(java.awt.event.MouseEvent evt) {
                    SetRuleFocus(x);
                    jLabel7.get(x).requestFocus();
                }
            });
            remove_last_mouse_listener(RuleOnSuccess.get(rule));
            RuleOnSuccess.get(rule).addMouseListener(new java.awt.event.MouseAdapter() {
                public void mouseClicked(java.awt.event.MouseEvent evt) {
                    SetRuleFocus(x);
                    RuleOnSuccess.get(x).requestFocus();
                }
            });
            remove_last_mouse_listener(RuleNewSubrule.get(rule));
            RuleNewSubrule.get(rule).addMouseListener(new java.awt.event.MouseAdapter() {
                public void mouseClicked(java.awt.event.MouseEvent evt) {
                    RuleNewSubruleMouseClicked(x);
                    RuleNewSubrule.get(x).requestFocus();
                }
            });
            remove_last_mouse_listener(RuleDeleteSubrule.get(rule));
            RuleDeleteSubrule.get(rule).addMouseListener(new java.awt.event.MouseAdapter() {
                public void mouseClicked(java.awt.event.MouseEvent evt) {
                    RuleDeleteSubruleMouseClicked(x);
                    RuleDeleteSubrule.get(x).requestFocus();
                }
            });
            remove_last_mouse_listener(RuleMoveSubruleUp.get(rule));
            RuleMoveSubruleUp.get(rule).addMouseListener(new java.awt.event.MouseAdapter() {
                public void mouseClicked(java.awt.event.MouseEvent evt) {
                    RuleMoveSubruleUpMouseClicked(x);
                    RuleMoveSubruleUp.get(x).requestFocus();
                }
            });
            remove_last_mouse_listener(RuleMoveSubruleDown.get(rule));
            RuleMoveSubruleDown.get(rule).addMouseListener(new java.awt.event.MouseAdapter() {
                public void mouseClicked(java.awt.event.MouseEvent evt) {
                    RuleMoveSubruleDownMouseClicked(x);
                    RuleMoveSubruleDown.get(x).requestFocus();
                }
            });

            for (int subrule = 0; subrule < jPanelSubrule.get(rule).size(); subrule++)
            {
                final int y = subrule;
                remove_last_mouse_listener(jPanelSubrule.get(rule).get(subrule));
                jPanelSubrule.get(rule).get(subrule).addMouseListener(new java.awt.event.MouseAdapter() {
                    public void mouseClicked(java.awt.event.MouseEvent evt) {
                        SetFocus(x, y);
                        jPanelSubrule.get(x).get(y).requestFocus();
                    }
                });
                remove_last_mouse_listener(jLabel6.get(rule).get(subrule));
                jLabel6.get(rule).get(subrule).addMouseListener(new java.awt.event.MouseAdapter() {
                    public void mouseClicked(java.awt.event.MouseEvent evt) {
                        SetFocus(x, y);
                        jLabel6.get(x).get(y).requestFocus();
                    }
                });
                remove_last_mouse_listener(RuleUngroup.get(rule).get(subrule));
                RuleUngroup.get(rule).get(subrule).addMouseListener(new java.awt.event.MouseAdapter() {
                    public void mouseClicked(java.awt.event.MouseEvent evt) {
                        RuleUngroupMouseClicked(x, y);
                        RuleUngroup.get(x).get(y).requestFocus();
                    }
                });
                remove_last_focus_listener(RuleSource.get(rule).get(subrule));
                RuleSource.get(rule).get(subrule).addFocusListener(new java.awt.event.FocusAdapter() {
                    public void focusGained(java.awt.event.FocusEvent evt) {
                        SetFocus(x, y);
                        RuleSource.get(x).get(y).requestFocus();
                    }
                });
                remove_last_mouse_listener(RuleField.get(rule).get(subrule));
                RuleField.get(rule).get(subrule).addMouseListener(new java.awt.event.MouseAdapter() {
                    public void mouseClicked(java.awt.event.MouseEvent evt) {
                        SetFocus(x, y);
                        RuleField.get(x).get(y).requestFocus();
                    }
                });
                remove_last_mouse_listener(RuleRegularExpression.get(rule).get(subrule));
                RuleRegularExpression.get(rule).get(subrule).addMouseListener(new java.awt.event.MouseAdapter() {
                    public void mouseClicked(java.awt.event.MouseEvent evt) {
                        SetFocus(x, y);
                        RuleRegularExpression.get(x).get(y).requestFocus();
                    }
                });
                remove_last_mouse_listener(RuleGrouping.get(rule).get(subrule));
                RuleGrouping.get(rule).get(subrule).addMouseListener(new java.awt.event.MouseAdapter() {
                    public void mouseClicked(java.awt.event.MouseEvent evt) {
                        SetFocus(x, y);
                        RuleGrouping.get(x).get(y).requestFocus();
                    }
                });
                remove_last_mouse_listener(RuleGroup.get(rule).get(subrule));
                RuleGroup.get(rule).get(subrule).addMouseListener(new java.awt.event.MouseAdapter() {
                    public void mouseClicked(java.awt.event.MouseEvent evt) {
                        RuleGroupMouseClicked(x, y);
                        RuleGroup.get(x).get(y).requestFocus();
                    }
                });    
            }
        }
    }
    
    private void remove_last_mouse_listener(javax.swing.JComponent component)
    {
        java.awt.event.MouseListener[] listeners = component.getMouseListeners();
        if (listeners.length > 0)
            component.removeMouseListener(listeners[listeners.length - 1]);
    }
    
    private void remove_last_focus_listener(javax.swing.JComponent component)
    {
        java.awt.event.FocusListener[] listeners = component.getFocusListeners();
        if (listeners.length > 0)
            component.removeFocusListener(listeners[listeners.length - 1]);
    }
    
    /**
     * @param args the command line arguments
     */
/*
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new ModifyRuleUI().setVisible(true);
            }
        });
    }
*/
    
    private javax.swing.JPanel jPanel0;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JButton RuleNew;
    private javax.swing.JButton RuleDelete;
    private javax.swing.JButton RuleMoveUp;
    private javax.swing.JButton RuleMoveDown;
    private javax.swing.JButton RuleDone;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private ArrayList<javax.swing.JPanel> jPanel2;
    private ArrayList<javax.swing.JLabel> jLabel7;
    private ArrayList<javax.swing.JButton> RuleNewSubrule;
    private ArrayList<javax.swing.JButton> RuleDeleteSubrule;
    private ArrayList<javax.swing.JButton> RuleMoveSubruleUp;
    private ArrayList<javax.swing.JButton> RuleMoveSubruleDown;
    private ArrayList<javax.swing.JTextField> RuleOnSuccess;
    private ArrayList<ArrayList<javax.swing.JPanel>> jPanelSubrule;
    private ArrayList<ArrayList<javax.swing.JLabel>> jLabel6;
    private ArrayList<ArrayList<javax.swing.JButton>> RuleUngroup;
    private ArrayList<ArrayList<javax.swing.JComboBox>> RuleSource;
    private ArrayList<ArrayList<javax.swing.JTextField>> RuleField;
    private ArrayList<ArrayList<javax.swing.JTextField>> RuleRegularExpression;
    private ArrayList<ArrayList<javax.swing.JComboBox>> RuleGrouping;
    private ArrayList<ArrayList<javax.swing.JButton>> RuleGroup;
    private ArrayList<ArrayList<Integer>> RuleDepth;
    private ArrayList<javax.swing.JLabel> parentheses;
    
    UploadUI parent;
    String rulegroup_name;
    int selected_rule;
    int selected_subrule;
}
