/*
 * UploadUI.java
 *
 * Created on January 14, 2008, 9:25 AM
 */

// TODO: Thread the app for generate

package interfaces;

import com.pixelmed.dicom.*;
import com.pixelmed.utils.*;
import com.pixelmed.display.*;
import com.pixelmed.database.*;
import java.util.*;
import java.io.*;
import java.util.regex.Pattern;
import java.util.regex.Matcher;
import org.jdom.*;
import org.jdom.output.XMLOutputter;
import org.jdom.input.SAXBuilder;

/**
 *
 * @author  meme
 */
public class UploadUI extends javax.swing.JFrame {
    
    
    /**
     *
     * @author  meme
     */
    public class SubRuleResult
    {
        public SubRuleResult() { matching_groups = new ArrayList<String>(); }
        
        public ArrayList<String> matching_groups;
        public String regexp;
        public boolean success;
        public char logic_op;
        public int depth;
    }
    
    /**
     * @description A helper class for Rule
     * @author  meme
     */
    public class SubRule
    {
        public SubRule() {}
        
        public SubRuleResult apply_subrule_to_file(String path, AttributeList attribute_list, int tab, int subtab)
        {
            SubRuleResult ret = new SubRuleResult();
            ret.success = false;
            ret.depth = depth;
            ret.regexp = regexp;
            if (grouping.equals("AND"))
              ret.logic_op = '&';
            else if (grouping.equals("OR"))
              ret.logic_op = '|';
            else
              ret.logic_op = '?';
            
            boolean is_dicom = false;
            if (attribute_list != null)
                is_dicom = true;

            if (regexp == null)
            {
                System.out.println("ERROR: Regular expression is null.");
                return ret;
            }
            Pattern pattern = Pattern.compile(regexp);
            if (source.contentEquals("Path"))
            {
                if (path != null)
                {
//                    System.out.println("           ** Param = " + path + ", Regexp = " + regexp);
                    Matcher matcher = pattern.matcher(path);
                    ret.success = matcher.find();
                    if (ret.success)
                    {
//                        System.out.println(matcher.groupCount());
                        for (int i = 0; i < matcher.groupCount(); i++)
                        {
//                            System.out.println(" " + i);
                            if (matcher.group(i + 1) == null)
                                continue;
                            ret.matching_groups.add(matcher.group(i + 1));
//                            System.out.println("          ## Adding group " + ret.matching_groups.get(ret.matching_groups.size() - 1));
                        }
                    }
                }
            }
            else if (source.contentEquals("DicomHeaderField") && (is_dicom))
            {
                AttributeTag abc;
                String field_pt1, field_pt2;
                if (field.length() == 8)
                {
                    field_pt1 = field.substring(0, 4);
                    field_pt2 = field.substring(4, 8);
                }
                else
                {
                    String[] splits = field.split(", ");
                    if (splits.length < 2)
                    {
                        splits = field.split(",");
                    }
                    
                    if (splits.length < 2)
                    {
                        ret.success = false;
                        System.out.println("Improperly formatted dicom field: " + field);
                        return ret;
                    }
                    field_pt1 = splits[0];
                    field_pt2 = splits[1];
                }
                int group = Integer.parseInt(field_pt1, 16);
                int element = Integer.parseInt(field_pt2, 16);
                AttributeTag attr = new AttributeTag(group, element);
                String[] params = com.pixelmed.dicom.Attribute.getStringValues(attribute_list, attr);
                String param = "";
                if (params != null)
                {
                    for (int i = 0; i < params.length; i++)
                    {
                        param += params[i].replace("\\", "\\\\");
                        if (i < params.length - 1)
                            param += "\\";
                    }
                }
//                System.out.println("           ** Param = " + param + ", Regexp = " + regexp);
                Matcher matcher = pattern.matcher(param);
                ret.success = matcher.find();
//                System.out.println(matcher.groupCount());
                if (ret.success)
                {
                    for (int i = 0; i < matcher.groupCount(); i++)
                    {
//                        System.out.println(" " + i);
                        ret.matching_groups.add(matcher.group(i + 1));
//                        System.out.println("          ++ Adding group " + ret.matching_groups.get(ret.matching_groups.size() - 1));
                    }
                }
            }
            else if (source.contentEquals("Calculated"))
            {
                String val;
                if (field.contentEquals("BIRNID"))
                {
                    val = BIRNID_Value.get(tab).getSelectedItem().toString();
                }
                else if (field.contentEquals("scannerID"))
                {
                    val = scannerID_Value.get(tab).getSelectedItem().toString();
                }
                else if (field.contentEquals("scannerManufacturer"))
                {
                    val = scannerManufacturer_Value.get(tab).getSelectedItem().toString();
                }
                else if (field.contentEquals("FileSystem"))
                {
                    val = FileSystem_Value.get(tab).getSelectedItem().toString();
                }
                else if (field.contentEquals("acquisitionSiteID"))
                {
                    val = acquisitionSiteID_Value.get(tab).getSelectedItem().toString();
                }
                else if (field.contentEquals("project/name"))
                {
                    val = projectName_Value.get(tab).getSelectedItem().toString();
                }
                else if (field.contentEquals("project/ID"))
                {
                    val = projectID_Value.get(tab).getSelectedItem().toString();
                }
                else if (field.contentEquals("study/description"))
                {
                    val = studyDescription_Value.get(tab).getSelectedItem().toString();
                }
                else if (field.contentEquals("study/ID"))
                {
                    val = studyID_Value.get(tab).getSelectedItem().toString();
                }
                else if (field.contentEquals("study/name"))
                {
                    val = studyName_Value.get(tab).getSelectedItem().toString();
                }
                else if (field.contentEquals("study/studyTime"))
                {
                    val = studyStudyTime_Value.get(tab).getSelectedItem().toString();
                }
                else if (field.contentEquals("subject/group"))
                {
                    val = subjectGroup_Value.get(tab).getSelectedItem().toString();
                }
                else if (field.contentEquals("visit/name"))
                {
                    val = visitName_Value.get(tab).getSelectedItem().toString();
                }
                else if (field.contentEquals("visit/ID"))
                {
                    val = visitID_Value.get(tab).getSelectedItem().toString();
                }
                else if (field.contentEquals("visit/description"))
                {
                    val = visitDescription_Value.get(tab).getSelectedItem().toString();
                }
                else if (field.contentEquals("visit/visitDate"))
                {
                    val = visitVisitDate_Value.get(tab).getSelectedItem().toString();
                }
                else if (field.contentEquals("visit/visitType"))
                {
                    val = visitVisitType_Value.get(tab).getSelectedItem().toString();
                }
                else if (field.contentEquals("series/nameLocal"))
                {
                    val = seriesNameLocal_Value.get(tab).get(subtab).getSelectedItem().toString();
                }
                else if (field.contentEquals("series/nameStandard"))
                {
                    val = seriesNameStandard_Value.get(tab).get(subtab).getSelectedItem().toString();
                }
                else if (field.contentEquals("series/description"))
                {
                    val = seriesDescription_Value.get(tab).get(subtab).getSelectedItem().toString();
                }
                else if (field.contentEquals("series/discardAcq"))
                {
                    val = seriesDiscardAcq_Value.get(tab).get(subtab).getSelectedItem().toString();
                }
                else if (field.contentEquals("series/ID"))
                {
                    val = seriesID_Value.get(tab).get(subtab).getSelectedItem().toString();
                }
                else if (field.contentEquals("series/number"))
                {
                    val = seriesNumber_Value.get(tab).get(subtab).getSelectedItem().toString();
                }
                else if (field.contentEquals("series/paradigm"))
                {
                    val = seriesParadigm_Value.get(tab).get(subtab).getSelectedItem().toString();
                }
                else if (field.contentEquals("series/paradigmVersion"))
                {
                    val = seriesParadigmVersion_Value.get(tab).get(subtab).getSelectedItem().toString();
                }
                else if (field.contentEquals("series/seriesTime"))
                {
                    val = seriesSeriesTime_Value.get(tab).get(subtab).getSelectedItem().toString();
                }
                else if (field.contentEquals("series/sliceOrder"))
                {
                    val = seriesSliceOrder_Value.get(tab).get(subtab).getSelectedItem().toString();
                }
                else if (field.contentEquals("series/type"))
                {
                    val = seriesType_Value.get(tab).get(subtab).getSelectedItem().toString();
                }
                else
                {
                    System.out.println("WARNING: Invalid calculated field: " + field);
                    return ret;
                }
                Matcher matcher = pattern.matcher(val);
                ret.success = matcher.find();
                if (ret.success)
                {
                    for (int i = 0; i < matcher.groupCount(); i++)
                    {
                        ret.matching_groups.add(matcher.group(i + 1));
//                        System.out.println("          -- Adding group " + ret.matching_groups.get(ret.matching_groups.size() - 1));
                    }
                }
            }
            else if (source.contentEquals("Strings"))
            {
                if (path != null)
                {
                    File file = new File(path);
                    try
                    {
                        FileInputStream fis  = new FileInputStream(file);
                        byte[] buf = new byte[1024];
                        ArrayList<String> accumulated_strings = new ArrayList<String>();
                        String accumulation = "";
                        int i = 0;
                        while ((i = fis.read(buf)) != -1)
                        {
                            for (int j = 0; j < i; j++)
                            {
                                if (is_text_char((char)buf[j]))
                                {
                                    accumulation += (char)buf[j];
                                }
                                else
                                {
                                    if (accumulation.length() >= 4)
                                    {
                                        accumulated_strings.add(accumulation);
                                    }
                                    accumulation = "";
                                }
                            }
                        }
                        if (accumulation.length() >= 4)
                        {
                            accumulated_strings.add(accumulation);
                        }
                        fis.close();
                        
                        for (int j = 0; j < accumulated_strings.size(); j++)
                        {
                            Matcher matcher = pattern.matcher(accumulated_strings.get(j));
                            ret.success |= matcher.find();
                            if (ret.success)
                            {
                                for (int k = 0; k < matcher.groupCount(); k++)
                                {
                                    ret.matching_groups.add(matcher.group(k + 1));
//                                    System.out.println("          -- Adding group " + ret.matching_groups.get(ret.matching_groups.size() - 1));
                                }
                            }
                        }
                    }
                    catch (Exception e)
                    {
                        System.out.println("IO error reading file: " + file);
                    }
                }
            }
            else if (source.contentEquals("TabID"))
            {
                ret.success = true;
                ret.matching_groups.add("" + tab);
            }
            else if (source.contentEquals("SubtabID"))
            {
                ret.success = true;
                ret.matching_groups.add("" + subtab);
//                System.out.println("           ## Adding subtab " + subtab);
            }
            else if (source.contentEquals("DicomHeaderField") && (is_dicom))
            {
                System.out.println("WARNING: Invalid source selection method: " + source);
            }
            
            return ret;
        }
        
        boolean is_text_char(char c)
        {
            if ((c >= ' ') && (c <= '~'))
                return true;
            else
                return false;
        }
        
        public String source;
        public String field;
        public String regexp;
        public String grouping;
        public int depth;
    }

    /**
     * @description A helper class for UploadUI
     * @author  meme
     */
    public class Rule
    {
        public Rule()
        {
            subrules = new ArrayList<SubRule>();
        }
        
        public class QueryRet
        {
            public QueryRet()
            {
                results = new HashMap<String, Boolean>();
            }
            
            public boolean ret;
            public HashMap<String, Boolean> results;
            public char last_logic_op;
        }
        
        public QueryRet try_query_recursive(ArrayList<SubRuleResult> results)
        {
            QueryRet ret = new QueryRet();
            ret.ret = false;
            ret.last_logic_op = '|';
            if (results.size() == 0)
            {
                return ret;
            }
            int last_depth = results.get(0).depth;
            ArrayList<SubRuleResult> query_buffer = new ArrayList<SubRuleResult>();            
            for (Iterator result_iterator = results.iterator(); result_iterator.hasNext(); )
            {
                SubRuleResult result = (SubRuleResult)result_iterator.next();
//                System.out.println("  Considering subrule run for " + result.regexp + " (" + result.success + ")");
                if (result.depth > last_depth)
                {
//                    System.out.println("    Adding to query buffer.");
                    query_buffer.add(result);
                }
                else
                {
//                    System.out.println("    Not adding to query buffer.");
                    if (query_buffer.size() > 0)
                    {
//                        System.out.println("    Processing query buffer.");
                        QueryRet sub_ret = try_query_recursive(query_buffer);
//                        System.out.println("    Got " + ret.ret + "; last logic = " + ret.last_logic_op);
                        if (ret.last_logic_op == '|')
                            ret.ret |= sub_ret.ret;
                        else if (ret.last_logic_op == '&')
                            ret.ret &= sub_ret.ret;
                        ret.last_logic_op = sub_ret.last_logic_op;
                        query_buffer.clear();

                        for (Iterator sub_results_iterator = sub_ret.results.keySet().iterator(); sub_results_iterator.hasNext(); )
                        {
                            String key = (String)sub_results_iterator.next();
                            ret.results.put(key, true);
                        }
                    }

                    if (ret.last_logic_op == '|')
                        ret.ret |= result.success;
                    else if (ret.last_logic_op == '&')
                        ret.ret &= result.success;
                    ret.last_logic_op = result.logic_op;
                }
            }

            if (query_buffer.size() > 0)
            {
//                System.out.println("    Processing query buffer (2).");
                QueryRet sub_ret = try_query_recursive(query_buffer);
//                System.out.println("    Got " + sub_ret.ret + "; last logic = " + ret.last_logic_op + ", existing ret = " + ret.ret);
                if (ret.last_logic_op == '|')
                    ret.ret |= sub_ret.ret;
                else if (ret.last_logic_op == '&')
                    ret.ret &= sub_ret.ret;
                ret.last_logic_op = sub_ret.last_logic_op;
                query_buffer.clear();

                for (Iterator sub_results_iterator = sub_ret.results.keySet().iterator(); sub_results_iterator.hasNext(); )
                {
                    String key = (String)sub_results_iterator.next();
                    ret.results.put(key, true);
                }
            }

//            System.out.println("  Returning " + ret.ret);
            return ret;
        }
        
        public String apply_rule_to_file(String path, AttributeList attribute_list, int tab, int subtab)
        {
//            System.out.println("Processing " + path);
            ArrayList<SubRuleResult> results = new ArrayList<SubRuleResult>();
            for (Iterator subrule_iterator = subrules.iterator(); subrule_iterator.hasNext(); )
            {
                SubRule subrule = (SubRule)subrule_iterator.next();
                results.add(subrule.apply_subrule_to_file(path, attribute_list, tab, subtab));
            }
            
            QueryRet success = try_query_recursive(results);

//            System.out.println("Returning " + success.ret);
            
            if (!success.ret)
            {
                return "";
            }
            else
            {
                String ret = on_success;
//                System.out.println("*1* " + ret);
                for (int i = 0; i < results.size(); i++)
                {
                    for (int j = 0; j < results.get(i).matching_groups.size(); j++)
                    {
//                        System.out.println("\\{" + i + ":" + j + "} :: " + results.get(i).matching_groups.get(j));
                        String match = results.get(i).matching_groups.get(j);
                        if (match == null)
                            match = "";
                        ret = ret.replace("\\{" + i + ":" + j + "}", match);
                    }
                }
//                System.out.println("*2* " + ret);
                return ret;
            }
        }
       
        public ArrayList<SubRule> subrules;
        public String on_success;
    }

    /**
     * @description A helper class for UploadUI
     * @author  meme
     */
    public class RuleGroup
    {
        public RuleGroup()
        {
            rules = new ArrayList<Rule>();
        }

        public ArrayList<String> apply_rule_to_file(String path, AttributeList attribute_list, int tab, int subtab)
        {
            HashMap<String, Boolean> hash = new HashMap<String, Boolean>();
            boolean is_dicom = false;
            if (attribute_list != null)
                is_dicom = true;
            for (Iterator rule_iterator = rules.iterator(); rule_iterator.hasNext(); )
            {
                Rule rule = (Rule)rule_iterator.next();
                String rule_ret = rule.apply_rule_to_file(path, attribute_list, tab, subtab);
                if (!rule_ret.equals(""))
                    hash.put(rule_ret, true);
            }
            
            ArrayList<String> ret = new ArrayList<String>();
            for (Iterator hash_iterator = hash.keySet().iterator(); hash_iterator.hasNext(); )
            {
                String rule = (String)hash_iterator.next();
                ret.add(rule);
//                System.out.println("*4* " + rule);
            }

            if ((ret.size() == 0) || (ret.get(0) == null))
            {
                String param = "";
                if (is_dicom)
                {
                    int group = Integer.parseInt("0008", 16);
                    int element = Integer.parseInt("103e", 16);
                    AttributeTag attr = new AttributeTag(group, element);
                    String[] params = com.pixelmed.dicom.Attribute.getStringValues(attribute_list, attr);
                    if (params != null)
                    {
                        for (int i = 0; i < params.length; i++)
                        {
                            param += params[i].replace("\\", "\\\\");
                            if (i < params.length - 1)
                                param += "\\";
                        }
                    }
                    if (param.length() <= 1)
                    {
                        System.out.println("ERROR! No parameter for (" + path + "): " + param + "; " + is_dicom);
                    }
                }
                ret.add("?" + param);
            }

            return ret;
        }
       
        public ArrayList<Rule> rules;
    }

    /** Creates new form UploadUI */
    public UploadUI() {
        initComponents();
        load_rules();
    }
    
    public void load_rules()
    {
        rules.clear();
        rules.add(new HashMap<String,RuleGroup>());
        SAXBuilder builder = new SAXBuilder(false);
        Document doc;
        try
        {
            doc = builder.build(System.getProperty("user.home") + "/UploadGUI.xml");
        }
        catch (JDOMException e)
        {
          System.out.println("ERROR: Cannot load config file: " + e.toString());
          ConfigureMouseClicked();
          return;
        }
        catch (java.io.IOException e)
        {
          System.out.println("ERROR:  Cannot load config file: " + e.toString());
          ConfigureMouseClicked();
          return;
        }
        List doc_list = doc.getRootElement().getChildren();
        for (Iterator rule_group_iterator = doc_list.iterator(); rule_group_iterator.hasNext(); )
        {
            Element xmlrule_group = (Element)rule_group_iterator.next();
            List xmlrule_group_children = xmlrule_group.getChildren();
            RuleGroup rule_group = new RuleGroup();
            String name = "";
            for (Iterator rule_iterator = xmlrule_group_children.iterator(); rule_iterator.hasNext(); )
            {
                Element xmlrule = (Element)rule_iterator.next();
                List xmlrule_children = xmlrule.getChildren();
                if (xmlrule.getName().contentEquals("Rule"))
                {
                    Rule rule = new Rule();
                    for (Iterator rule_field_iterator = xmlrule_children.iterator(); rule_field_iterator.hasNext(); )
                    {
                        Element rule_field = (Element)rule_field_iterator.next();
                        List rule_field_children = rule_field.getChildren();
                        if (rule_field.getName().contentEquals("SubRule"))
                        {
                             SubRule subrule = new SubRule();
                             for (Iterator subrule_field_iterator = rule_field_children.iterator(); subrule_field_iterator.hasNext(); )
                             {
                                    Element child = (Element)subrule_field_iterator.next();
                                    if (child.getName().contentEquals("Source"))
                                        subrule.source = child.getText();
                                    else if (child.getName().contentEquals("Field"))
                                        subrule.field = child.getText();
                                    else if (child.getName().contentEquals("Regexp"))
                                        subrule.regexp = child.getText();
                                    else if (child.getName().contentEquals("Grouping"))
                                        subrule.grouping = child.getText();
                                    else if (child.getName().contentEquals("Depth"))
                                        subrule.depth = Integer.parseInt(child.getText());
                            }
                            rule.subrules.add(subrule);
                        }
                        else if (rule_field.getName().contentEquals("OnSuccess"))
                        {
                            rule.on_success = rule_field.getText();
                        }
                    }
                    rule_group.rules.add(rule);
                }
                else if (xmlrule.getName().contentEquals("Name"))
                {
                    name = xmlrule.getText();
                }
            }
          
            rules.get(0).put(name, rule_group);
        }
    }
    
    public void save_rules()
    {
        Element base = new Element("UploadGUI");
        Document doc = new Document(base);

        for (Iterator group_iterator = rules.get(0).keySet().iterator(); group_iterator.hasNext(); )
        {
            String rule_group_name = (String)group_iterator.next();
            Element group_elem = new Element("RuleGroup");
            try
            {
                group_elem.addContent(new Element("Name").setText(rule_group_name));
            }
            catch (java.lang.NullPointerException e)
            {
                group_elem.addContent(new Element("Name").setText(""));            
            }
            for (Iterator rule_iterator = rules.get(0).get(rule_group_name).rules.iterator(); rule_iterator.hasNext(); )
            {
                Rule rule = (Rule)rule_iterator.next();
                Element rule_elem = new Element("Rule");
                for (Iterator subrule_iterator = rule.subrules.iterator(); subrule_iterator.hasNext(); )
                {
                    SubRule subrule = (SubRule)subrule_iterator.next();
                    Element subrule_elem = new Element("SubRule");
                    try
                    {
                        subrule_elem.addContent(new Element("Source").setText(subrule.source));
                    }
                    catch (java.lang.NullPointerException e)
                    {
                        subrule_elem.addContent(new Element("Source").setText(""));
                    }
                    try
                    {
                        subrule_elem.addContent(new Element("Field").setText(subrule.field));
                    }
                    catch (java.lang.NullPointerException e)
                    {
                        subrule_elem.addContent(new Element("Field").setText(""));
                    }
                    try
                    {
                        subrule_elem.addContent(new Element("Regexp").setText(subrule.regexp));
                    }
                    catch (java.lang.NullPointerException e)
                    {
                        subrule_elem.addContent(new Element("Regexp").setText(""));
                    }
                    try
                    {
                        subrule_elem.addContent(new Element("Grouping").setText(subrule.grouping));
                    }
                    catch (java.lang.NullPointerException e)
                    {
                        subrule_elem.addContent(new Element("Grouping").setText(""));
                    }
                    try
                    {
                        subrule_elem.addContent(new Element("Depth").setText(new Integer(subrule.depth).toString()));
                    }
                    catch (java.lang.NullPointerException e)
                    {
                        subrule_elem.addContent(new Element("Depth").setText(""));
                    }
                    
                    rule_elem.addContent(subrule_elem);
                }
                try
                {
                    rule_elem.addContent(new Element("OnSuccess").setText(rule.on_success));
                }
                catch (java.lang.NullPointerException e)
                {
                    rule_elem.addContent(new Element("OnSuccess").setText(""));
                }
                group_elem.addContent(rule_elem);
            }
            base.addContent(group_elem);
        }
        XMLOutputter out = new XMLOutputter();

        java.io.FileWriter writer;
        try
        {
            writer = new java.io.FileWriter(System.getProperty("user.home") + "/UploadGUI.xml");
            out.setFormat(org.jdom.output.Format.getPrettyFormat());
            out.output(doc, writer);
            writer.flush();
            writer.close();            
        }
        catch (java.io.IOException e)
        {
            System.out.println("ERROR: Can't write configuration file: " + System.getProperty("user.home") + "/UploadGUI.xml");
            return;
        }
    }

    public void update_rulegroup(String rulegroup_name, RuleGroup rulegroup)
    {
        rules.get(0).put(rulegroup_name, rulegroup);
    }
    
    private void initComponents()
    {
        jPanel1 = new ArrayList<javax.swing.JPanel>();
        jPanel3 = new ArrayList<javax.swing.JPanel>();
        jPanel6 = new ArrayList<javax.swing.JPanel>();
        jSeparator2 = new ArrayList<javax.swing.JSeparator>();
        jSeparator6 = new ArrayList<javax.swing.JSeparator>();
        FileSystem_Select = new ArrayList<javax.swing.JCheckBox>();
        BIRNID_Select = new ArrayList<javax.swing.JCheckBox>();
        scannerID_Select = new ArrayList<javax.swing.JCheckBox>();
        scannerManufacturer_Select = new ArrayList<javax.swing.JCheckBox>();
        acquisitionSiteID_Select = new ArrayList<javax.swing.JCheckBox>();
        subjectGroup_Select = new ArrayList<javax.swing.JCheckBox>();
        projectName_Select = new ArrayList<javax.swing.JCheckBox>();
        projectID_Select = new ArrayList<javax.swing.JCheckBox>();
        visitName_Select = new ArrayList<javax.swing.JCheckBox>();
        visitID_Select = new ArrayList<javax.swing.JCheckBox>();
        visitVisitDate_Select = new ArrayList<javax.swing.JCheckBox>();
        visitVisitType_Select = new ArrayList<javax.swing.JCheckBox>();
        visitDescription_Select = new ArrayList<javax.swing.JCheckBox>();
        studyName_Select = new ArrayList<javax.swing.JCheckBox>();
        studyID_Select = new ArrayList<javax.swing.JCheckBox>();
        studyStudyTime_Select = new ArrayList<javax.swing.JCheckBox>();
        studyDescription_Select = new ArrayList<javax.swing.JCheckBox>();
        subjectGroup_ModifyRule = new ArrayList<javax.swing.JButton>();
        projectName_ModifyRule = new ArrayList<javax.swing.JButton>();
        visitVisitDate_ModifyRule = new ArrayList<javax.swing.JButton>();
        visitVisitType_ModifyRule = new ArrayList<javax.swing.JButton>();
        visitDescription_ModifyRule = new ArrayList<javax.swing.JButton>();
        studyName_ModifyRule = new ArrayList<javax.swing.JButton>();
        studyID_ModifyRule = new ArrayList<javax.swing.JButton>();
        studyStudyTime_ModifyRule = new ArrayList<javax.swing.JButton>();
        studyDescription_ModifyRule = new ArrayList<javax.swing.JButton>();
        acquisitionSiteID_ModifyRule = new ArrayList<javax.swing.JButton>();
        BIRNID_ModifyRule = new ArrayList<javax.swing.JButton>();
        scannerID_ModifyRule = new ArrayList<javax.swing.JButton>();
        scannerManufacturer_ModifyRule = new ArrayList<javax.swing.JButton>();
        FileSystem_ModifyRule = new ArrayList<javax.swing.JButton>();
        projectID_ModifyRule = new ArrayList<javax.swing.JButton>();
        visitName_ModifyRule = new ArrayList<javax.swing.JButton>();
        visitID_ModifyRule = new ArrayList<javax.swing.JButton>();
        jPanel7 = new ArrayList<javax.swing.JPanel>();
        GenerateAll_ModifyRule = new ArrayList<javax.swing.JButton>();
        GenerateAll_Button = new ArrayList<javax.swing.JButton>();
        SelectAllInSeries = new ArrayList<javax.swing.JButton>();
        SelectNoneInSeries = new ArrayList<javax.swing.JButton>();
        NewSeries = new ArrayList<javax.swing.JButton>();
        DuplicateSeries = new ArrayList<javax.swing.JButton>();
        DeleteSeries = new ArrayList<javax.swing.JButton>();
        jTabbedPane3 = new ArrayList<javax.swing.JTabbedPane>();
        jPanel8 = new ArrayList<ArrayList<javax.swing.JPanel> >();
        jSeparator8 = new ArrayList<ArrayList<javax.swing.JSeparator> >();
        seriesNameLocal_ModifyRule = new ArrayList<ArrayList<javax.swing.JButton> >();
        seriesNameLocal_Select = new ArrayList<ArrayList<javax.swing.JCheckBox> >();
        seriesNameStandard_Select = new ArrayList<ArrayList<javax.swing.JCheckBox> >();
        seriesID_Select = new ArrayList<ArrayList<javax.swing.JCheckBox> >();
        seriesSeriesTime_Select = new ArrayList<ArrayList<javax.swing.JCheckBox> >();
        seriesDescription_Select = new ArrayList<ArrayList<javax.swing.JCheckBox> >();
        seriesType_Select = new ArrayList<ArrayList<javax.swing.JCheckBox> >();
        seriesNameStandard_ModifyRule = new ArrayList<ArrayList<javax.swing.JButton> >();
        seriesID_ModifyRule = new ArrayList<ArrayList<javax.swing.JButton> >();
        seriesSeriesTime_ModifyRule = new ArrayList<ArrayList<javax.swing.JButton> >();
        seriesDescription_ModifyRule = new ArrayList<ArrayList<javax.swing.JButton> >();
        seriesType_ModifyRule = new ArrayList<ArrayList<javax.swing.JButton> >();
        seriesParadigm_ModifyRule = new ArrayList<ArrayList<javax.swing.JButton> >();
        seriesParadigmVersion_ModifyRule = new ArrayList<ArrayList<javax.swing.JButton> >();
        seriesNumber_ModifyRule = new ArrayList<ArrayList<javax.swing.JButton> >();
        seriesSliceOrder_ModifyRule = new ArrayList<ArrayList<javax.swing.JButton> >();
        seriesDiscardAcq_ModifyRule = new ArrayList<ArrayList<javax.swing.JButton> >();
        seriesParadigm_Select = new ArrayList<ArrayList<javax.swing.JCheckBox> >();
        seriesParadigmVersion_Select = new ArrayList<ArrayList<javax.swing.JCheckBox> >();
        seriesNumber_Select = new ArrayList<ArrayList<javax.swing.JCheckBox> >();
        seriesSliceOrder_Select = new ArrayList<ArrayList<javax.swing.JCheckBox> >();
        seriesDiscardAcq_Select = new ArrayList<ArrayList<javax.swing.JCheckBox> >();
        seriesParadigmVersion_Value = new ArrayList<ArrayList<javax.swing.JComboBox> >();
        seriesParadigm_Value = new ArrayList<ArrayList<javax.swing.JComboBox> >();
        seriesNumber_Value = new ArrayList<ArrayList<javax.swing.JComboBox> >();
        seriesSliceOrder_Value = new ArrayList<ArrayList<javax.swing.JComboBox> >();
        seriesDiscardAcq_Value = new ArrayList<ArrayList<javax.swing.JComboBox> >();
        seriesNameStandard_Value = new ArrayList<ArrayList<javax.swing.JComboBox> >();
        seriesNameLocal_Value = new ArrayList<ArrayList<javax.swing.JComboBox> >();
        seriesID_Value = new ArrayList<ArrayList<javax.swing.JComboBox> >();
        seriesSeriesTime_Value = new ArrayList<ArrayList<javax.swing.JComboBox> >();
        seriesDescription_Value = new ArrayList<ArrayList<javax.swing.JComboBox> >();
        seriesType_Value = new ArrayList<ArrayList<javax.swing.JComboBox> >();
        Configure = new ArrayList<javax.swing.JButton>();
        OpenDir = new ArrayList<javax.swing.JButton>();
        CloseDir = new ArrayList<javax.swing.JButton>();
        Save = new ArrayList<javax.swing.JButton>();
        SelectAll = new ArrayList<javax.swing.JButton>();
        SelectNone = new ArrayList<javax.swing.JButton>();
        MergeXML = new ArrayList<javax.swing.JButton>();
        ApplySelectedRules = new ArrayList<javax.swing.JButton>();
        acquisitionSiteID_Value = new ArrayList<javax.swing.JComboBox>();
        subjectGroup_Value = new ArrayList<javax.swing.JComboBox>();
        projectName_Value = new ArrayList<javax.swing.JComboBox>();
        BIRNID_Value = new ArrayList<javax.swing.JComboBox>();
        scannerID_Value = new ArrayList<javax.swing.JComboBox>();
        scannerManufacturer_Value = new ArrayList<javax.swing.JComboBox>();
        FileSystem_Value = new ArrayList<javax.swing.JComboBox>();
        projectID_Value = new ArrayList<javax.swing.JComboBox>();
        visitName_Value = new ArrayList<javax.swing.JComboBox>();
        visitID_Value = new ArrayList<javax.swing.JComboBox>();
        studyDescription_Value = new ArrayList<javax.swing.JComboBox>();
        studyStudyTime_Value = new ArrayList<javax.swing.JComboBox>();
        studyID_Value = new ArrayList<javax.swing.JComboBox>();
        studyName_Value = new ArrayList<javax.swing.JComboBox>();
        visitDescription_Value = new ArrayList<javax.swing.JComboBox>();
        visitVisitType_Value = new ArrayList<javax.swing.JComboBox>();
        visitVisitDate_Value = new ArrayList<javax.swing.JComboBox>();
        sliceCount_Value = new ArrayList<ArrayList<javax.swing.JTextField> >();
        displaySeries_Button = new ArrayList<ArrayList<javax.swing.JButton> >();
        Basepath = new ArrayList<javax.swing.JLabel>();
        jTabbedPane1 = new javax.swing.JTabbedPane();
        nondicomTabs_Select = new ArrayList<javax.swing.JComboBox>();
        nondicomFiles_List = new ArrayList<javax.swing.JList>();
        nondicomFiles_ListScroll = new ArrayList<javax.swing.JScrollPane>();
        nondicomMove_Button = new ArrayList<javax.swing.JButton>();
        last_seriesNameLocal_Value = "";

        all_files_databases = new ArrayList<DatabaseInformationModel>();
        all_files = new ArrayList<HashMap<String, ArrayList<String> > >();
        all_files_reloc = new HashMap<String, String>();
        all_tabs_instance_UIDs = new ArrayList<HashMap<String, String> >();
        orig_jpanel7_height = 0;
        jpanel3_target_height = 544;

        add_components("");
        add_internal_components(0);

        rules = new ArrayList<HashMap<String, RuleGroup>>();
        ConfigureChooser = new javax.swing.JFileChooser();
        ConfigureChooser.setFileSelectionMode(javax.swing.JFileChooser.FILES_ONLY);
        ConfigureChooser.setMultiSelectionEnabled(true);
        ConfigureChooser.setDialogTitle("Select Configuration File");
        OpenDirChooser = new javax.swing.JFileChooser();
        OpenDirChooser.setFileSelectionMode(javax.swing.JFileChooser.DIRECTORIES_ONLY);
        OpenDirChooser.setMultiSelectionEnabled(true);
        MergeFileChooser = new javax.swing.JFileChooser();
        SaveFileChooser = new javax.swing.JFileChooser() {
            @Override
            public void approveSelection() {
                File f = getSelectedFile();
                if(f.exists() && getDialogType() == SAVE_DIALOG) {
                    int result = javax.swing.JOptionPane.showConfirmDialog(getTopLevelAncestor(),
                            "The selected file already exists. " +
                            "Do you want to overwrite it?",
                            "The file already exists",
                            javax.swing.JOptionPane.YES_NO_CANCEL_OPTION,
                            javax.swing.JOptionPane.QUESTION_MESSAGE);
                    switch(result)  {
                    case javax.swing.JOptionPane.YES_OPTION:
                        super.approveSelection();
                        return;
                    case javax.swing.JOptionPane.NO_OPTION:
                        return;
                    case javax.swing.JOptionPane.CANCEL_OPTION:
                        cancelSelection();
                        return;
                    }
                }
                super.approveSelection();
            }
        };
    }
    
    private void add_components(String path)
    {
        orig_jpanel7_height = 0;
        
        int tab = ApplySelectedRules.size();
        jPanel1.add(tab, new javax.swing.JPanel());
        jPanel3.add(tab, new javax.swing.JPanel());
        jPanel6.add(tab, new javax.swing.JPanel());
        jSeparator2.add(tab, new javax.swing.JSeparator());
        jSeparator6.add(tab, new javax.swing.JSeparator());
        FileSystem_Select.add(tab, new javax.swing.JCheckBox());
        BIRNID_Select.add(tab, new javax.swing.JCheckBox());
        scannerID_Select.add(tab, new javax.swing.JCheckBox());
        scannerManufacturer_Select.add(tab, new javax.swing.JCheckBox());
        acquisitionSiteID_Select.add(tab, new javax.swing.JCheckBox());
        subjectGroup_Select.add(tab, new javax.swing.JCheckBox());
        projectName_Select.add(tab, new javax.swing.JCheckBox());
        projectID_Select.add(tab, new javax.swing.JCheckBox());
        visitName_Select.add(tab, new javax.swing.JCheckBox());
        visitID_Select.add(tab, new javax.swing.JCheckBox());
        visitVisitDate_Select.add(tab, new javax.swing.JCheckBox());
        visitVisitType_Select.add(tab, new javax.swing.JCheckBox());
        visitDescription_Select.add(tab, new javax.swing.JCheckBox());
        studyName_Select.add(tab, new javax.swing.JCheckBox());
        studyID_Select.add(tab, new javax.swing.JCheckBox());
        studyStudyTime_Select.add(tab, new javax.swing.JCheckBox());
        studyDescription_Select.add(tab, new javax.swing.JCheckBox());
        subjectGroup_ModifyRule.add(tab, new javax.swing.JButton());
        projectName_ModifyRule.add(tab, new javax.swing.JButton());
        visitVisitDate_ModifyRule.add(tab, new javax.swing.JButton());
        visitVisitType_ModifyRule.add(tab, new javax.swing.JButton());
        visitDescription_ModifyRule.add(tab, new javax.swing.JButton());
        studyName_ModifyRule.add(tab, new javax.swing.JButton());
        studyID_ModifyRule.add(tab, new javax.swing.JButton());
        studyStudyTime_ModifyRule.add(tab, new javax.swing.JButton());
        studyDescription_ModifyRule.add(tab, new javax.swing.JButton());
        acquisitionSiteID_ModifyRule.add(tab, new javax.swing.JButton());
        BIRNID_ModifyRule.add(tab, new javax.swing.JButton());
        scannerID_ModifyRule.add(tab, new javax.swing.JButton());
        scannerManufacturer_ModifyRule.add(tab, new javax.swing.JButton());
        FileSystem_ModifyRule.add(tab, new javax.swing.JButton());
        projectID_ModifyRule.add(tab, new javax.swing.JButton());
        visitName_ModifyRule.add(tab, new javax.swing.JButton());
        visitID_ModifyRule.add(tab, new javax.swing.JButton());
        jPanel7.add(tab, new javax.swing.JPanel());
        jTabbedPane3.add(tab, new javax.swing.JTabbedPane());
        Configure.add(tab, new javax.swing.JButton());
        OpenDir.add(tab, new javax.swing.JButton());
        CloseDir.add(tab, new javax.swing.JButton());
        Save.add(tab, new javax.swing.JButton());
        SelectAll.add(tab, new javax.swing.JButton());
        SelectNone.add(tab, new javax.swing.JButton());
        MergeXML.add(tab, new javax.swing.JButton());
        ApplySelectedRules.add(tab, new javax.swing.JButton());
        acquisitionSiteID_Value.add(tab, new javax.swing.JComboBox());
        subjectGroup_Value.add(tab, new javax.swing.JComboBox());
        projectName_Value.add(tab, new javax.swing.JComboBox());
        BIRNID_Value.add(tab, new javax.swing.JComboBox());
        scannerID_Value.add(tab, new javax.swing.JComboBox());
        scannerManufacturer_Value.add(tab, new javax.swing.JComboBox());
        FileSystem_Value.add(tab, new javax.swing.JComboBox());
        projectID_Value.add(tab, new javax.swing.JComboBox());
        visitName_Value.add(tab, new javax.swing.JComboBox());
        visitID_Value.add(tab, new javax.swing.JComboBox());
        studyDescription_Value.add(tab, new javax.swing.JComboBox());
        studyStudyTime_Value.add(tab, new javax.swing.JComboBox());
        studyID_Value.add(tab, new javax.swing.JComboBox());
        studyName_Value.add(tab, new javax.swing.JComboBox());
        visitDescription_Value.add(tab, new javax.swing.JComboBox());
        visitVisitType_Value.add(tab, new javax.swing.JComboBox());
        visitVisitDate_Value.add(tab, new javax.swing.JComboBox());
        GenerateAll_ModifyRule.add(tab, new javax.swing.JButton());
        GenerateAll_Button.add(tab, new javax.swing.JButton());
        SelectAllInSeries.add(tab, new javax.swing.JButton());
        SelectNoneInSeries.add(tab, new javax.swing.JButton());
        NewSeries.add(tab, new javax.swing.JButton());
        DuplicateSeries.add(tab, new javax.swing.JButton());
        DeleteSeries.add(tab, new javax.swing.JButton());
        Basepath.add(tab, new javax.swing.JLabel());
        
        Basepath.get(tab).setText(path);

        seriesNameLocal_ModifyRule.add(tab, new ArrayList<javax.swing.JButton>());
        seriesNameLocal_Select.add(tab, new ArrayList<javax.swing.JCheckBox>());
        seriesNameStandard_Select.add(tab, new ArrayList<javax.swing.JCheckBox>());
        seriesID_Select.add(tab, new ArrayList<javax.swing.JCheckBox>());
        seriesSeriesTime_Select.add(tab, new ArrayList<javax.swing.JCheckBox>());
        seriesDescription_Select.add(tab, new ArrayList<javax.swing.JCheckBox>());
        seriesType_Select.add(tab, new ArrayList<javax.swing.JCheckBox>());
        seriesNameStandard_ModifyRule.add(tab, new ArrayList<javax.swing.JButton>());
        seriesID_ModifyRule.add(tab, new ArrayList<javax.swing.JButton>());
        seriesSeriesTime_ModifyRule.add(tab, new ArrayList<javax.swing.JButton>());
        seriesDescription_ModifyRule.add(tab, new ArrayList<javax.swing.JButton>());
        seriesType_ModifyRule.add(tab, new ArrayList<javax.swing.JButton>());
        seriesParadigm_ModifyRule.add(tab, new ArrayList<javax.swing.JButton>());
        seriesParadigmVersion_ModifyRule.add(tab, new ArrayList<javax.swing.JButton>());
        seriesNumber_ModifyRule.add(tab, new ArrayList<javax.swing.JButton>());
        seriesSliceOrder_ModifyRule.add(tab, new ArrayList<javax.swing.JButton>());
        seriesDiscardAcq_ModifyRule.add(tab, new ArrayList<javax.swing.JButton>());
        seriesParadigm_Select.add(tab, new ArrayList<javax.swing.JCheckBox>());
        seriesParadigmVersion_Select.add(tab, new ArrayList<javax.swing.JCheckBox>());
        seriesNumber_Select.add(tab, new ArrayList<javax.swing.JCheckBox>());
        seriesSliceOrder_Select.add(tab, new ArrayList<javax.swing.JCheckBox>());
        seriesDiscardAcq_Select.add(tab, new ArrayList<javax.swing.JCheckBox>());
        seriesParadigmVersion_Value.add(tab, new ArrayList<javax.swing.JComboBox>());
        seriesParadigm_Value.add(tab, new ArrayList<javax.swing.JComboBox>());
        seriesNumber_Value.add(tab, new ArrayList<javax.swing.JComboBox>());
        seriesSliceOrder_Value.add(tab, new ArrayList<javax.swing.JComboBox>());
        seriesDiscardAcq_Value.add(tab, new ArrayList<javax.swing.JComboBox>());
        seriesNameStandard_Value.add(tab, new ArrayList<javax.swing.JComboBox>());
        seriesNameLocal_Value.add(tab, new ArrayList<javax.swing.JComboBox>());
        seriesID_Value.add(tab, new ArrayList<javax.swing.JComboBox>());
        seriesSeriesTime_Value.add(tab, new ArrayList<javax.swing.JComboBox>());
        seriesDescription_Value.add(tab, new ArrayList<javax.swing.JComboBox>());
        seriesType_Value.add(tab, new ArrayList<javax.swing.JComboBox>());
        jPanel8.add(tab, new ArrayList<javax.swing.JPanel>());
        jSeparator8.add(tab, new ArrayList<javax.swing.JSeparator>());
        sliceCount_Value.add(tab, new ArrayList<javax.swing.JTextField>());
        displaySeries_Button.add(tab, new ArrayList<javax.swing.JButton>());

        nondicomTabs_Select.add(tab, new javax.swing.JComboBox());
        nondicomFiles_List.add(tab, new javax.swing.JList());
        nondicomFiles_ListScroll.add(tab, new javax.swing.JScrollPane());
        nondicomMove_Button.add(tab, new javax.swing.JButton());
        nondicomMove_Button.get(tab).setText("Move");
        if (tab == 0)
            nondicomMove_Button.get(tab).setEnabled(false);
        nondicomMove_Button.get(tab).addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                nondicomMove_ButtonMouseClicked();
            }
        });
        
        nondicomFiles_ListScroll.get(tab).getViewport().add(nondicomFiles_List.get(tab));
        
        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        jPanel3.get(tab).setBackground(new java.awt.Color(184, 169, 136));
        jPanel3.get(tab).setBorder(javax.swing.BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.RAISED));
        javax.swing.GroupLayout jPanel6Layout = new javax.swing.GroupLayout(jPanel6.get(tab));
        jPanel6.get(tab).setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(
            jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 1288, Short.MAX_VALUE)
        );
        jPanel6Layout.setVerticalGroup(
            jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 0, Short.MAX_VALUE)
        );

        jSeparator2.get(tab).setOrientation(javax.swing.SwingConstants.VERTICAL);

        FileSystem_Select.get(tab).setBackground(new java.awt.Color(184, 169, 136));
        FileSystem_Select.get(tab).setText("FileSystem");
        FileSystem_Select.get(tab).setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        FileSystem_Select.get(tab).setMargin(new java.awt.Insets(0, 0, 0, 0));

        BIRNID_Select.get(tab).setBackground(new java.awt.Color(184, 169, 136));
        BIRNID_Select.get(tab).setText("BIRNID");
        BIRNID_Select.get(tab).setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        BIRNID_Select.get(tab).setMargin(new java.awt.Insets(0, 0, 0, 0));

        scannerID_Select.get(tab).setBackground(new java.awt.Color(184, 169, 136));
        scannerID_Select.get(tab).setText("scannerID");
        scannerID_Select.get(tab).setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        scannerID_Select.get(tab).setMargin(new java.awt.Insets(0, 0, 0, 0));

        scannerManufacturer_Select.get(tab).setBackground(new java.awt.Color(184, 169, 136));
        scannerManufacturer_Select.get(tab).setText("scannerManuf.");
        scannerManufacturer_Select.get(tab).setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        scannerManufacturer_Select.get(tab).setMargin(new java.awt.Insets(0, 0, 0, 0));

        acquisitionSiteID_Select.get(tab).setBackground(new java.awt.Color(184, 169, 136));
        acquisitionSiteID_Select.get(tab).setText("acquisitionSiteID");
        acquisitionSiteID_Select.get(tab).setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        acquisitionSiteID_Select.get(tab).setMargin(new java.awt.Insets(0, 0, 0, 0));

        subjectGroup_Select.get(tab).setBackground(new java.awt.Color(184, 169, 136));
        subjectGroup_Select.get(tab).setText("subjectGroup");
        subjectGroup_Select.get(tab).setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        subjectGroup_Select.get(tab).setMargin(new java.awt.Insets(0, 0, 0, 0));

        projectName_Select.get(tab).setBackground(new java.awt.Color(184, 169, 136));
        projectName_Select.get(tab).setText("project/name");
        projectName_Select.get(tab).setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        projectName_Select.get(tab).setMargin(new java.awt.Insets(0, 0, 0, 0));

        projectID_Select.get(tab).setBackground(new java.awt.Color(184, 169, 136));
        projectID_Select.get(tab).setText("project/ID");
        projectID_Select.get(tab).setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        projectID_Select.get(tab).setMargin(new java.awt.Insets(0, 0, 0, 0));

        visitName_Select.get(tab).setBackground(new java.awt.Color(184, 169, 136));
        visitName_Select.get(tab).setText("visit/name");
        visitName_Select.get(tab).setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        visitName_Select.get(tab).setMargin(new java.awt.Insets(0, 0, 0, 0));

        visitID_Select.get(tab).setBackground(new java.awt.Color(184, 169, 136));
        visitID_Select.get(tab).setText("visit/ID");
        visitID_Select.get(tab).setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        visitID_Select.get(tab).setMargin(new java.awt.Insets(0, 0, 0, 0));

        visitVisitDate_Select.get(tab).setBackground(new java.awt.Color(184, 169, 136));
        visitVisitDate_Select.get(tab).setText("visit/visitDate");
        visitVisitDate_Select.get(tab).setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        visitVisitDate_Select.get(tab).setMargin(new java.awt.Insets(0, 0, 0, 0));

        visitVisitType_Select.get(tab).setBackground(new java.awt.Color(184, 169, 136));
        visitVisitType_Select.get(tab).setText("visit/visitType");
        visitVisitType_Select.get(tab).setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        visitVisitType_Select.get(tab).setMargin(new java.awt.Insets(0, 0, 0, 0));

        visitDescription_Select.get(tab).setBackground(new java.awt.Color(184, 169, 136));
        visitDescription_Select.get(tab).setText("visit/description");
        visitDescription_Select.get(tab).setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        visitDescription_Select.get(tab).setMargin(new java.awt.Insets(0, 0, 0, 0));

        studyName_Select.get(tab).setBackground(new java.awt.Color(184, 169, 136));
        studyName_Select.get(tab).setText("study/name");
        studyName_Select.get(tab).setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        studyName_Select.get(tab).setMargin(new java.awt.Insets(0, 0, 0, 0));

        studyID_Select.get(tab).setBackground(new java.awt.Color(184, 169, 136));
        studyID_Select.get(tab).setText("study/ID");
        studyID_Select.get(tab).setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        studyID_Select.get(tab).setMargin(new java.awt.Insets(0, 0, 0, 0));

        studyStudyTime_Select.get(tab).setBackground(new java.awt.Color(184, 169, 136));
        studyStudyTime_Select.get(tab).setText("study/studyTime");
        studyStudyTime_Select.get(tab).setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        studyStudyTime_Select.get(tab).setMargin(new java.awt.Insets(0, 0, 0, 0));

        studyDescription_Select.get(tab).setBackground(new java.awt.Color(184, 169, 136));
        studyDescription_Select.get(tab).setText("study/description");
        studyDescription_Select.get(tab).setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        studyDescription_Select.get(tab).setMargin(new java.awt.Insets(0, 0, 0, 0));

        jTabbedPane1.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                shrink_window();
            }
        });
        
        GenerateAll_ModifyRule.get(tab).setText("Modify Rule");
        GenerateAll_ModifyRule.get(tab).addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                ModifyRuleMouseClicked("series/nameStandard");
            }
        });

        subjectGroup_ModifyRule.get(tab).setText("Modify Rule");
        subjectGroup_ModifyRule.get(tab).addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                ModifyRuleMouseClicked("subjectGroup");
            }
        });

        projectName_ModifyRule.get(tab).setText("Modify Rule");
        projectName_ModifyRule.get(tab).addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                ModifyRuleMouseClicked("project/name");
            }
        });

        visitVisitDate_ModifyRule.get(tab).setText("Modify Rule");
        visitVisitDate_ModifyRule.get(tab).addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                ModifyRuleMouseClicked("visit/visitDate");
            }
        });

        visitVisitType_ModifyRule.get(tab).setText("Modify Rule");
        visitVisitType_ModifyRule.get(tab).addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                ModifyRuleMouseClicked("visit/visitType");
            }
        });

        visitDescription_ModifyRule.get(tab).setText("Modify Rule");
        visitDescription_ModifyRule.get(tab).addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                ModifyRuleMouseClicked("visit/description");
            }
        });

        studyName_ModifyRule.get(tab).setText("Modify Rule");
        studyName_ModifyRule.get(tab).addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                ModifyRuleMouseClicked("study/name");
            }
        });

        studyID_ModifyRule.get(tab).setText("Modify Rule");
        studyID_ModifyRule.get(tab).addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                ModifyRuleMouseClicked("study/ID");
            }
        });

        studyStudyTime_ModifyRule.get(tab).setText("Modify Rule");
        studyStudyTime_ModifyRule.get(tab).addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                ModifyRuleMouseClicked("study/studyTime");
            }
        });

        studyDescription_ModifyRule.get(tab).setText("Modify Rule");
        studyDescription_ModifyRule.get(tab).addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                ModifyRuleMouseClicked("study/description");
            }
        });

        acquisitionSiteID_ModifyRule.get(tab).setText("Modify Rule");
        acquisitionSiteID_ModifyRule.get(tab).addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                ModifyRuleMouseClicked("acquisitionSiteID");
            }
        });

        BIRNID_ModifyRule.get(tab).setText("Modify Rule");
        BIRNID_ModifyRule.get(tab).addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                ModifyRuleMouseClicked("BIRNID");
            }
        });

        scannerID_ModifyRule.get(tab).setText("Modify Rule");
        scannerID_ModifyRule.get(tab).addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                ModifyRuleMouseClicked("scannerID");
            }
        });

        scannerManufacturer_ModifyRule.get(tab).setText("Modify Rule");
        scannerManufacturer_ModifyRule.get(tab).addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                ModifyRuleMouseClicked("scannerManufacturer");
            }
        });

        projectID_ModifyRule.get(tab).setText("Modify Rule");
        projectID_ModifyRule.get(tab).addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                ModifyRuleMouseClicked("project/ID");
            }
        });

        visitName_ModifyRule.get(tab).setText("Modify Rule");
        visitName_ModifyRule.get(tab).addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                ModifyRuleMouseClicked("visit/name");
            }
        });

        visitID_ModifyRule.get(tab).setText("Modify Rule");
        visitID_ModifyRule.get(tab).addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                ModifyRuleMouseClicked("visit/ID");
            }
        });
        
        GenerateAll_Button.get(tab).setText("Generate All");
//        if (tab == 0)
//            GenerateAll_Button.get(tab).setEnabled(false);
        GenerateAll_Button.get(tab).addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                GenerateAll_ButtonMouseClicked();
            }
        });

        SelectAllInSeries.get(tab).setText("Select All In Series");
        SelectAllInSeries.get(tab).addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                SelectAllInSeriesMouseClicked();
            }
        });

        SelectNoneInSeries.get(tab).setText("Select None In Series");
        SelectNoneInSeries.get(tab).addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                SelectNoneInSeriesMouseClicked();
            }
        });

        NewSeries.get(tab).setText("New Series");
        NewSeries.get(tab).addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                NewSeriesMouseClicked();
            }
        });

        DuplicateSeries.get(tab).setText("Duplicate Series");
        DuplicateSeries.get(tab).addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                DuplicateSeriesMouseClicked();
            }
        });

        DeleteSeries.get(tab).setText("Delete Series");
        DeleteSeries.get(tab).addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                DeleteSeriesMouseClicked();
            }
        });

        FileSystem_ModifyRule.get(tab).setText("Modify Rule");
        FileSystem_ModifyRule.get(tab).setEnabled(false);

        jPanel7.get(tab).setBackground(new java.awt.Color(215, 209, 185));
        jPanel7.get(tab).setBorder(javax.swing.BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.RAISED));
        
        Configure.get(tab).setText("Configure");
        Configure.get(tab).addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                ConfigureMouseClicked();
            }
        });

        OpenDir.get(tab).setText("Open Directory");
        OpenDir.get(tab).addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                OpenDirMouseClicked();
            }
        });

        CloseDir.get(tab).setText("Close Directory");
        CloseDir.get(tab).addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                CloseDirMouseClicked();
            }
        });

        Save.get(tab).setText("Save");
        Save.get(tab).addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                SaveMouseClicked();
            }
        });

        SelectAll.get(tab).setText("Select All");
        SelectAll.get(tab).addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                SelectAllMouseClicked();
            }
        });

        SelectNone.get(tab).setText("Select None");
        SelectNone.get(tab).addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                SelectNoneMouseClicked();
            }
        });

        MergeXML.get(tab).setText("Merge XML");
        MergeXML.get(tab).addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                MergeXMLMouseClicked();
            }
        });

        ApplySelectedRules.get(tab).setText("Apply Selected Rules");
        ApplySelectedRules.get(tab).addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                ApplySelectedRulesMouseClicked();
            }
        });
        
        final int final_tab = tab;

        acquisitionSiteID_Value.get(tab).setEditable(true);
        acquisitionSiteID_Value.get(tab).setModel(new javax.swing.DefaultComboBoxModel(new String[] { "" }));
        acquisitionSiteID_Value.get(tab).getEditor().getEditorComponent().addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                set_children_text_from_master(acquisitionSiteID_Value, final_tab);
            }
        });

        subjectGroup_Value.get(tab).setEditable(true);
        subjectGroup_Value.get(tab).setModel(new javax.swing.DefaultComboBoxModel(new String[] { "" }));
        subjectGroup_Value.get(tab).getEditor().getEditorComponent().addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                set_children_text_from_master(subjectGroup_Value, final_tab);
            }
        });

        projectName_Value.get(tab).setEditable(true);
        projectName_Value.get(tab).setModel(new javax.swing.DefaultComboBoxModel(new String[] { "" }));
        projectName_Value.get(tab).getEditor().getEditorComponent().addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                set_children_text_from_master(projectName_Value, final_tab);
            }
        });

        BIRNID_Value.get(tab).setEditable(true);
        BIRNID_Value.get(tab).setModel(new javax.swing.DefaultComboBoxModel(new String[] { "" }));
        BIRNID_Value.get(tab).getEditor().getEditorComponent().addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                BIRNID_ValueFocusLost();
                set_children_text_from_master(BIRNID_Value, final_tab);
            }
        });

        scannerID_Value.get(tab).setEditable(true);
        scannerID_Value.get(tab).setModel(new javax.swing.DefaultComboBoxModel(new String[] { "" }));
        scannerID_Value.get(tab).getEditor().getEditorComponent().addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                set_children_text_from_master(scannerID_Value, final_tab);
            }
        });

        scannerManufacturer_Value.get(tab).setEditable(true);
        scannerManufacturer_Value.get(tab).setModel(new javax.swing.DefaultComboBoxModel(new String[] { "" }));
        scannerManufacturer_Value.get(tab).getEditor().getEditorComponent().addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                set_children_text_from_master(scannerManufacturer_Value, final_tab);
            }
        });

        FileSystem_Value.get(tab).setEditable(true);
        FileSystem_Value.get(tab).setModel(new javax.swing.DefaultComboBoxModel(new String[] { "" }));
        FileSystem_Value.get(tab).addItem("Local");
        FileSystem_Value.get(tab).addItem("Local-Remote");
        FileSystem_Value.get(tab).addItem("Remote");
        FileSystem_Value.get(tab).addItem("Local-In-Place");
        FileSystem_Value.get(tab).setSelectedIndex(0);
        FileSystem_Value.get(tab).setSelectedItem("Local");
        FileSystem_Value.get(tab).getEditor().getEditorComponent().addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                if (final_tab == 0)
                {
                    int tab_start = 1;
                    int tab_end = jTabbedPane1.getTabCount();
    
                    for (int tab = tab_start; tab < tab_end; tab++)
                    {
                        FileSystem_Value.get(tab).setSelectedItem(projectID_Value.get(0).getSelectedItem().toString());
                    }
                }
            }
        });

        projectID_Value.get(tab).setEditable(true);
        projectID_Value.get(tab).setModel(new javax.swing.DefaultComboBoxModel(new String[] { "" }));
        projectID_Value.get(tab).getEditor().getEditorComponent().addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                set_children_text_from_master(projectID_Value, final_tab);
            }
        });

        visitName_Value.get(tab).setEditable(true);
        visitName_Value.get(tab).setModel(new javax.swing.DefaultComboBoxModel(new String[] { "" }));
        visitName_Value.get(tab).getEditor().getEditorComponent().addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                set_children_text_from_master(visitName_Value, final_tab);
            }
        });

        visitID_Value.get(tab).setEditable(true);
        visitID_Value.get(tab).setModel(new javax.swing.DefaultComboBoxModel(new String[] { "" }));
        visitID_Value.get(tab).getEditor().getEditorComponent().addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                visitID_ValueFocusLost();
                set_children_text_from_master(visitID_Value, final_tab);
            }
        });

        studyDescription_Value.get(tab).setEditable(true);
        studyDescription_Value.get(tab).setModel(new javax.swing.DefaultComboBoxModel(new String[] { "" }));
        studyDescription_Value.get(tab).getEditor().getEditorComponent().addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                set_children_text_from_master(studyDescription_Value, final_tab);
            }
        });

        studyStudyTime_Value.get(tab).setEditable(true);
        studyStudyTime_Value.get(tab).setModel(new javax.swing.DefaultComboBoxModel(new String[] { "" }));
        studyStudyTime_Value.get(tab).getEditor().getEditorComponent().addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                set_children_text_from_master(studyStudyTime_Value, final_tab);
            }
        });

        studyID_Value.get(tab).setEditable(true);
        studyID_Value.get(tab).setModel(new javax.swing.DefaultComboBoxModel(new String[] { "" }));
        studyID_Value.get(tab).getEditor().getEditorComponent().addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                studyID_ValueFocusLost();
                set_children_text_from_master(studyID_Value, final_tab);
            }
        });

        studyName_Value.get(tab).setEditable(true);
        studyName_Value.get(tab).setModel(new javax.swing.DefaultComboBoxModel(new String[] { "" }));
        studyName_Value.get(tab).getEditor().getEditorComponent().addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                set_children_text_from_master(studyName_Value, final_tab);
            }
        });

        visitDescription_Value.get(tab).setEditable(true);
        visitDescription_Value.get(tab).setModel(new javax.swing.DefaultComboBoxModel(new String[] { "" }));
        visitDescription_Value.get(tab).getEditor().getEditorComponent().addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                set_children_text_from_master(visitDescription_Value, final_tab);
            }
        });

        visitVisitType_Value.get(tab).setEditable(true);
        visitVisitType_Value.get(tab).setModel(new javax.swing.DefaultComboBoxModel(new String[] { "" }));
        visitVisitType_Value.get(tab).getEditor().getEditorComponent().addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                set_children_text_from_master(visitVisitType_Value, final_tab);
            }
        });

        visitVisitDate_Value.get(tab).setEditable(true);
        visitVisitDate_Value.get(tab).setModel(new javax.swing.DefaultComboBoxModel(new String[] { "" }));
        visitVisitDate_Value.get(tab).getEditor().getEditorComponent().addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                set_children_text_from_master(studyStudyTime_Value, final_tab);
            }
        });

        if (tab == 0)
          jTabbedPane1.addTab("Master", jPanel1.get(tab));
        else
          jTabbedPane1.addTab(BIRNID_Value.get(tab).getSelectedItem().toString() + "/" + projectName_Value.get(tab).getSelectedItem().toString() + "/" + visitName_Value.get(tab).getSelectedItem().toString(), jPanel1.get(tab));
        
        jTabbedPane1.setSelectedIndex(tab);

        jTabbedPane1.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                shrink_window();
            }
        });

        BIRNID_Value.get(tab).removeAllItems();
        scannerID_Value.get(tab).removeAllItems();
        scannerManufacturer_Value.get(tab).removeAllItems();
        acquisitionSiteID_Value.get(tab).removeAllItems();
        subjectGroup_Value.get(tab).removeAllItems();
        projectName_Value.get(tab).removeAllItems();
        projectID_Value.get(tab).removeAllItems();
        visitName_Value.get(tab).removeAllItems();
        visitID_Value.get(tab).removeAllItems();
        visitVisitDate_Value.get(tab).removeAllItems();
        visitVisitType_Value.get(tab).removeAllItems();
        visitDescription_Value.get(tab).removeAllItems();
        studyName_Value.get(tab).removeAllItems();
        studyID_Value.get(tab).removeAllItems();
        studyStudyTime_Value.get(tab).removeAllItems();
        studyDescription_Value.get(tab).removeAllItems();
        
        all_files.add(new HashMap<String, ArrayList<String> >());
        all_tabs_instance_UIDs.add(new HashMap<String, String>());
        
        redraw();
    }

    private void add_internal_components(int tab)
    {
        int subtab = seriesNameLocal_ModifyRule.get(tab).size();
        seriesNameLocal_ModifyRule.get(tab).add(subtab, new javax.swing.JButton()); 
        seriesNameLocal_Select.get(tab).add(subtab, new javax.swing.JCheckBox());
        seriesNameStandard_Select.get(tab).add(subtab, new javax.swing.JCheckBox());
        seriesID_Select.get(tab).add(subtab, new javax.swing.JCheckBox());
        seriesSeriesTime_Select.get(tab).add(subtab, new javax.swing.JCheckBox());
        seriesDescription_Select.get(tab).add(subtab, new javax.swing.JCheckBox());
        seriesType_Select.get(tab).add(subtab, new javax.swing.JCheckBox());
        seriesNameStandard_ModifyRule.get(tab).add(subtab, new javax.swing.JButton());
        seriesID_ModifyRule.get(tab).add(subtab, new javax.swing.JButton());
        seriesSeriesTime_ModifyRule.get(tab).add(subtab, new javax.swing.JButton());
        seriesDescription_ModifyRule.get(tab).add(subtab, new javax.swing.JButton());
        seriesType_ModifyRule.get(tab).add(subtab, new javax.swing.JButton());
        seriesParadigm_ModifyRule.get(tab).add(subtab, new javax.swing.JButton());
        seriesParadigmVersion_ModifyRule.get(tab).add(subtab, new javax.swing.JButton());
        seriesNumber_ModifyRule.get(tab).add(subtab, new javax.swing.JButton());
        seriesSliceOrder_ModifyRule.get(tab).add(subtab, new javax.swing.JButton());
        seriesDiscardAcq_ModifyRule.get(tab).add(subtab, new javax.swing.JButton());
        seriesParadigm_Select.get(tab).add(subtab, new javax.swing.JCheckBox());
        seriesParadigmVersion_Select.get(tab).add(subtab, new javax.swing.JCheckBox());
        seriesNumber_Select.get(tab).add(subtab, new javax.swing.JCheckBox());
        seriesSliceOrder_Select.get(tab).add(subtab, new javax.swing.JCheckBox());
        seriesDiscardAcq_Select.get(tab).add(subtab, new javax.swing.JCheckBox());
        seriesParadigmVersion_Value.get(tab).add(subtab, new javax.swing.JComboBox());
        seriesParadigm_Value.get(tab).add(subtab, new javax.swing.JComboBox());
        seriesNumber_Value.get(tab).add(subtab, new javax.swing.JComboBox());
        seriesSliceOrder_Value.get(tab).add(subtab, new javax.swing.JComboBox());
        seriesDiscardAcq_Value.get(tab).add(subtab, new javax.swing.JComboBox());
        seriesNameStandard_Value.get(tab).add(subtab, new javax.swing.JComboBox());
        seriesNameLocal_Value.get(tab).add(subtab, new javax.swing.JComboBox());
        seriesID_Value.get(tab).add(subtab, new javax.swing.JComboBox());
        seriesSeriesTime_Value.get(tab).add(subtab, new javax.swing.JComboBox());
        seriesDescription_Value.get(tab).add(subtab, new javax.swing.JComboBox());
        seriesType_Value.get(tab).add(subtab, new javax.swing.JComboBox());
        sliceCount_Value.get(tab).add(subtab, new javax.swing.JTextField());
        displaySeries_Button.get(tab).add(subtab, new javax.swing.JButton());
        jPanel8.get(tab).add(subtab, new javax.swing.JPanel());
        jSeparator8.get(tab).add(subtab, new javax.swing.JSeparator());

        jPanel8.get(tab).get(subtab).setBackground(new java.awt.Color(232, 219, 191));
        jSeparator8.get(tab).get(subtab).setOrientation(javax.swing.SwingConstants.VERTICAL);

        seriesNameLocal_ModifyRule.get(tab).get(subtab).setText("Modify Rule");
        seriesNameLocal_ModifyRule.get(tab).get(subtab).setEnabled(false);

        seriesNameLocal_Select.get(tab).get(subtab).setBackground(new java.awt.Color(232, 219, 191));
        seriesNameLocal_Select.get(tab).get(subtab).setText("nameLocal");
        seriesNameLocal_Select.get(tab).get(subtab).setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        seriesNameLocal_Select.get(tab).get(subtab).setMargin(new java.awt.Insets(0, 0, 0, 0));

        seriesNameStandard_ModifyRule.get(tab).get(subtab).setEnabled(false);

        seriesNameStandard_Select.get(tab).get(subtab).setBackground(new java.awt.Color(232, 219, 191));
        seriesNameStandard_Select.get(tab).get(subtab).setText("nameStandard");
        seriesNameStandard_Select.get(tab).get(subtab).setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        seriesNameStandard_Select.get(tab).get(subtab).setMargin(new java.awt.Insets(0, 0, 0, 0));

        seriesID_Select.get(tab).get(subtab).setBackground(new java.awt.Color(232, 219, 191));
        seriesID_Select.get(tab).get(subtab).setText("ID");
        seriesID_Select.get(tab).get(subtab).setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        seriesID_Select.get(tab).get(subtab).setMargin(new java.awt.Insets(0, 0, 0, 0));

        seriesSeriesTime_Select.get(tab).get(subtab).setBackground(new java.awt.Color(232, 219, 191));
        seriesSeriesTime_Select.get(tab).get(subtab).setText("seriesTime");
        seriesSeriesTime_Select.get(tab).get(subtab).setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        seriesSeriesTime_Select.get(tab).get(subtab).setMargin(new java.awt.Insets(0, 0, 0, 0));

        seriesDescription_Select.get(tab).get(subtab).setBackground(new java.awt.Color(232, 219, 191));
        seriesDescription_Select.get(tab).get(subtab).setText("description");
        seriesDescription_Select.get(tab).get(subtab).setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        seriesDescription_Select.get(tab).get(subtab).setMargin(new java.awt.Insets(0, 0, 0, 0));

        seriesType_Select.get(tab).get(subtab).setBackground(new java.awt.Color(232, 219, 191));
        seriesType_Select.get(tab).get(subtab).setText("type");
        seriesType_Select.get(tab).get(subtab).setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        seriesType_Select.get(tab).get(subtab).setMargin(new java.awt.Insets(0, 0, 0, 0));

        seriesNameStandard_ModifyRule.get(tab).get(subtab).setText("Modify Rule");

        seriesID_ModifyRule.get(tab).get(subtab).setText("Modify Rule");

        seriesSeriesTime_ModifyRule.get(tab).get(subtab).setText("Modify Rule");

        seriesDescription_ModifyRule.get(tab).get(subtab).setText("Modify Rule");

        seriesType_ModifyRule.get(tab).get(subtab).setText("Modify Rule");

        seriesParadigm_ModifyRule.get(tab).get(subtab).setText("Modify Rule");

        seriesParadigmVersion_ModifyRule.get(tab).get(subtab).setText("Modify Rule");

        seriesNumber_ModifyRule.get(tab).get(subtab).setText("Modify Rule");

        seriesSliceOrder_ModifyRule.get(tab).get(subtab).setText("Modify Rule");

        seriesDiscardAcq_ModifyRule.get(tab).get(subtab).setText("Modify Rule");

        displaySeries_Button.get(tab).get(subtab).setText("Display");
        if (tab == 0)
            displaySeries_Button.get(tab).get(subtab).setEnabled(false);
        displaySeries_Button.get(tab).get(subtab).addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                displaySeries_ButtonMouseClicked();
            }
        });

        
        sliceCount_Value.get(tab).get(subtab).setEditable(false);

        seriesParadigm_Select.get(tab).get(subtab).setBackground(new java.awt.Color(232, 219, 191));
        seriesParadigm_Select.get(tab).get(subtab).setText("paradigm");
        seriesParadigm_Select.get(tab).get(subtab).setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        seriesParadigm_Select.get(tab).get(subtab).setMargin(new java.awt.Insets(0, 0, 0, 0));

        seriesParadigmVersion_Select.get(tab).get(subtab).setBackground(new java.awt.Color(232, 219, 191));
        seriesParadigmVersion_Select.get(tab).get(subtab).setText("paradigmVersion");
        seriesParadigmVersion_Select.get(tab).get(subtab).setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        seriesParadigmVersion_Select.get(tab).get(subtab).setMargin(new java.awt.Insets(0, 0, 0, 0));

        seriesNumber_Select.get(tab).get(subtab).setBackground(new java.awt.Color(232, 219, 191));
        seriesNumber_Select.get(tab).get(subtab).setText("number");
        seriesNumber_Select.get(tab).get(subtab).setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        seriesNumber_Select.get(tab).get(subtab).setMargin(new java.awt.Insets(0, 0, 0, 0));

        seriesSliceOrder_Select.get(tab).get(subtab).setBackground(new java.awt.Color(232, 219, 191));
        seriesSliceOrder_Select.get(tab).get(subtab).setText("sliceorder");
        seriesSliceOrder_Select.get(tab).get(subtab).setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        seriesSliceOrder_Select.get(tab).get(subtab).setMargin(new java.awt.Insets(0, 0, 0, 0));

        seriesDiscardAcq_Select.get(tab).get(subtab).setBackground(new java.awt.Color(232, 219, 191));
        seriesDiscardAcq_Select.get(tab).get(subtab).setText("discardAcq");
        seriesDiscardAcq_Select.get(tab).get(subtab).setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        seriesDiscardAcq_Select.get(tab).get(subtab).setMargin(new java.awt.Insets(0, 0, 0, 0));
        
        final int final_tab = tab;
        final int final_subtab = subtab;

        seriesParadigmVersion_Value.get(tab).get(subtab).setEditable(true);
        seriesParadigmVersion_Value.get(tab).get(subtab).setModel(new javax.swing.DefaultComboBoxModel(new String[] { "" }));
        seriesParadigmVersion_Value.get(tab).get(subtab).getEditor().getEditorComponent().addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                set_children_text_from_master_subtab(seriesParadigmVersion_Value, final_tab, final_subtab);
            }
        });

        seriesParadigm_Value.get(tab).get(subtab).setEditable(true);
        seriesParadigm_Value.get(tab).get(subtab).setModel(new javax.swing.DefaultComboBoxModel(new String[] { "" }));
        seriesParadigm_Value.get(tab).get(subtab).getEditor().getEditorComponent().addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                set_children_text_from_master_subtab(seriesParadigm_Value, final_tab, final_subtab);
            }
        });

        seriesNumber_Value.get(tab).get(subtab).setEditable(true);
        seriesNumber_Value.get(tab).get(subtab).setModel(new javax.swing.DefaultComboBoxModel(new String[] { "" }));
        seriesNumber_Value.get(tab).get(subtab).getEditor().getEditorComponent().addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                set_children_text_from_master_subtab(seriesNumber_Value, final_tab, final_subtab);
            }
        });

        seriesSliceOrder_Value.get(tab).get(subtab).setEditable(true);
        seriesSliceOrder_Value.get(tab).get(subtab).setModel(new javax.swing.DefaultComboBoxModel(new String[] { "" }));
        seriesSliceOrder_Value.get(tab).get(subtab).getEditor().getEditorComponent().addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                set_children_text_from_master_subtab(seriesSliceOrder_Value, final_tab, final_subtab);
            }
        });

        seriesDiscardAcq_Value.get(tab).get(subtab).setEditable(true);
        seriesDiscardAcq_Value.get(tab).get(subtab).setModel(new javax.swing.DefaultComboBoxModel(new String[] { "" }));
        seriesDiscardAcq_Value.get(tab).get(subtab).getEditor().getEditorComponent().addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                set_children_text_from_master_subtab(seriesDiscardAcq_Value, final_tab, final_subtab);
            }
        });

        seriesNameStandard_Value.get(tab).get(subtab).setEditable(true);
        seriesNameStandard_Value.get(tab).get(subtab).setModel(new javax.swing.DefaultComboBoxModel(new String[] { "" }));
        seriesNameStandard_Value.get(tab).get(subtab).getEditor().getEditorComponent().addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                seriesNameStandard_ValueFocusLost();
            }
        });
        
        seriesNameLocal_Value.get(tab).get(subtab).setEditable(true);
        seriesNameLocal_Value.get(tab).get(subtab).setModel(new javax.swing.DefaultComboBoxModel(new String[] { "" }));
        seriesNameLocal_Value.get(tab).get(subtab).getEditor().getEditorComponent().addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                seriesNameLocal_ValueFocusLost();
            }
            public void focusGained(java.awt.event.FocusEvent evt) {
                seriesNameLocal_ValueFocusGained();
            }
        });

        seriesID_Value.get(tab).get(subtab).setEditable(true);
        seriesID_Value.get(tab).get(subtab).setModel(new javax.swing.DefaultComboBoxModel(new String[] { "" }));
        seriesID_Value.get(tab).get(subtab).getEditor().getEditorComponent().addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                set_children_text_from_master_subtab(seriesID_Value, final_tab, final_subtab);
            }
        });

        seriesSeriesTime_Value.get(tab).get(subtab).setEditable(true);
        seriesSeriesTime_Value.get(tab).get(subtab).setModel(new javax.swing.DefaultComboBoxModel(new String[] { "" }));
        seriesSeriesTime_Value.get(tab).get(subtab).getEditor().getEditorComponent().addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                set_children_text_from_master_subtab(seriesSeriesTime_Value, final_tab, final_subtab);
            }
        });

        seriesDescription_Value.get(tab).get(subtab).setEditable(true);
        seriesDescription_Value.get(tab).get(subtab).setModel(new javax.swing.DefaultComboBoxModel(new String[] { "" }));
        seriesDescription_Value.get(tab).get(subtab).getEditor().getEditorComponent().addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                set_children_text_from_master_subtab(seriesDescription_Value, final_tab, final_subtab);
            }
        });

        seriesType_Value.get(tab).get(subtab).setEditable(true);
        seriesType_Value.get(tab).get(subtab).setModel(new javax.swing.DefaultComboBoxModel(new String[] { "" }));
        seriesType_Value.get(tab).get(subtab).getEditor().getEditorComponent().addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                set_children_text_from_master_subtab(seriesType_Value, final_tab, final_subtab);
            }
        });

        seriesNameLocal_ModifyRule.get(tab).get(subtab).setText("Modify Rule");
        seriesNameLocal_ModifyRule.get(tab).get(subtab).addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                ModifyRuleMouseClicked("series/nameLocal");
            }
        });

        seriesNameStandard_ModifyRule.get(tab).get(subtab).setText("Modify Rule");
        seriesNameStandard_ModifyRule.get(tab).get(subtab).addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                ModifyRuleMouseClicked("series/nameStandard");
            }
        });

        seriesID_ModifyRule.get(tab).get(subtab).setText("Modify Rule");
        seriesID_ModifyRule.get(tab).get(subtab).addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                ModifyRuleMouseClicked("series/ID");
            }
        });

        seriesSeriesTime_ModifyRule.get(tab).get(subtab).setText("Modify Rule");
        seriesSeriesTime_ModifyRule.get(tab).get(subtab).addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                ModifyRuleMouseClicked("series/seriesTime");
            }
        });

        seriesDescription_ModifyRule.get(tab).get(subtab).setText("Modify Rule");
        seriesDescription_ModifyRule.get(tab).get(subtab).addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                ModifyRuleMouseClicked("series/description");
            }
        });

        seriesType_ModifyRule.get(tab).get(subtab).setText("Modify Rule");
        seriesType_ModifyRule.get(tab).get(subtab).addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                ModifyRuleMouseClicked("series/type");
            }
        });

        seriesParadigm_ModifyRule.get(tab).get(subtab).setText("Modify Rule");
        seriesParadigm_ModifyRule.get(tab).get(subtab).addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                ModifyRuleMouseClicked("series/paradigm");
            }
        });

        seriesParadigmVersion_ModifyRule.get(tab).get(subtab).setText("Modify Rule");
        seriesParadigmVersion_ModifyRule.get(tab).get(subtab).addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                ModifyRuleMouseClicked("series/paradigmVersion");
            }
        });

        seriesNumber_ModifyRule.get(tab).get(subtab).setText("Modify Rule");
        seriesNumber_ModifyRule.get(tab).get(subtab).addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                ModifyRuleMouseClicked("series/number");
            }
        });

        seriesSliceOrder_ModifyRule.get(tab).get(subtab).setText("Modify Rule");
        seriesSliceOrder_ModifyRule.get(tab).get(subtab).addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                ModifyRuleMouseClicked("series/sliceOrder");
            }
        });

        seriesDiscardAcq_ModifyRule.get(tab).get(subtab).setText("Modify Rule");
        seriesDiscardAcq_ModifyRule.get(tab).get(subtab).addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                ModifyRuleMouseClicked("series/discardAcq");
            }
        });

        if (subtab == 0)
          jTabbedPane3.get(tab).addTab("Master", jPanel8.get(tab).get(subtab));
        else
          jTabbedPane3.get(tab).addTab(seriesNameStandard_Value.get(tab).get(subtab).getSelectedItem().toString(), jPanel8.get(tab).get(subtab));

        jTabbedPane3.get(tab).setSelectedIndex(subtab);
        
        seriesNameLocal_Value.get(tab).get(subtab).removeAllItems();
        seriesNameStandard_Value.get(tab).get(subtab).removeAllItems();
        seriesSeriesTime_Value.get(tab).get(subtab).removeAllItems();
        seriesDescription_Value.get(tab).get(subtab).removeAllItems();
        seriesType_Value.get(tab).get(subtab).removeAllItems();
        seriesParadigm_Value.get(tab).get(subtab).removeAllItems();
        seriesParadigmVersion_Value.get(tab).get(subtab).removeAllItems();
        seriesID_Value.get(tab).get(subtab).removeAllItems();
        seriesNumber_Value.get(tab).get(subtab).removeAllItems();
        seriesSliceOrder_Value.get(tab).get(subtab).removeAllItems();
        seriesDiscardAcq_Value.get(tab).get(subtab).removeAllItems();
        
        redraw();
    }

    private void redraw()
    {
        shrink_window();

        for (int tab = 0; tab < jTabbedPane1.getTabCount(); tab++)
        {
            javax.swing.GroupLayout jPanel3Layout = new javax.swing.GroupLayout(jPanel3.get(tab));
            jPanel3.get(tab).setLayout(jPanel3Layout);
            jPanel3Layout.setHorizontalGroup(
                jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup()
                    .addContainerGap()
                    .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                        .addComponent(Basepath.get(tab))
                        .addComponent(jSeparator6.get(tab), javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 1039, Short.MAX_VALUE)
                        .addGroup(jPanel3Layout.createSequentialGroup()
                            .addGap(12, 12, 12)
                            .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                .addGroup(jPanel3Layout.createSequentialGroup()
                                    .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                                        .addComponent(BIRNID_ModifyRule.get(tab))
                                        .addComponent(FileSystem_ModifyRule.get(tab)))
                                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                    .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                        .addComponent(BIRNID_Select.get(tab))
                                        .addComponent(FileSystem_Select.get(tab))))
                                .addGroup(jPanel3Layout.createSequentialGroup()
                                    .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                                        .addComponent(subjectGroup_ModifyRule.get(tab))
                                        .addComponent(acquisitionSiteID_ModifyRule.get(tab))
                                        .addComponent(scannerID_ModifyRule.get(tab))
                                        .addComponent(scannerManufacturer_ModifyRule.get(tab))
                                        .addComponent(projectName_ModifyRule.get(tab))
                                        .addComponent(projectID_ModifyRule.get(tab))
                                        .addComponent(visitName_ModifyRule.get(tab)))
                                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                    .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                                        .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup()
                                            .addComponent(visitName_Select.get(tab))
                                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                            .addComponent(visitName_Value.get(tab), javax.swing.GroupLayout.PREFERRED_SIZE, 255, javax.swing.GroupLayout.PREFERRED_SIZE))
                                        .addGroup(jPanel3Layout.createSequentialGroup()
                                            .addComponent(projectID_Select.get(tab))
                                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                            .addComponent(projectID_Value.get(tab), javax.swing.GroupLayout.PREFERRED_SIZE, 255, javax.swing.GroupLayout.PREFERRED_SIZE))
                                        .addGroup(jPanel3Layout.createSequentialGroup()
                                            .addComponent(projectName_Select.get(tab))
                                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                            .addComponent(projectName_Value.get(tab), javax.swing.GroupLayout.PREFERRED_SIZE, 255, javax.swing.GroupLayout.PREFERRED_SIZE))
                                        .addGroup(jPanel3Layout.createSequentialGroup()
                                            .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                                .addComponent(acquisitionSiteID_Select.get(tab))
                                                .addComponent(scannerID_Select.get(tab))
                                                .addComponent(scannerManufacturer_Select.get(tab))
                                                .addComponent(subjectGroup_Select.get(tab)))
                                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                            .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                                                .addComponent(subjectGroup_Value.get(tab), 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                                .addComponent(acquisitionSiteID_Value.get(tab), 0, 255, Short.MAX_VALUE)
                                                .addComponent(scannerID_Value.get(tab), 0, 255, Short.MAX_VALUE)
                                                .addComponent(scannerManufacturer_Value.get(tab), 0, 255, Short.MAX_VALUE)
                                                .addComponent(BIRNID_Value.get(tab), javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.PREFERRED_SIZE, 255, javax.swing.GroupLayout.PREFERRED_SIZE)
                                                .addComponent(FileSystem_Value.get(tab), javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.PREFERRED_SIZE, 255, javax.swing.GroupLayout.PREFERRED_SIZE))))))
                            .addGap(8, 8, 8)
                            .addComponent(jSeparator2.get(tab), javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addGap(15, 15, 15)
                            .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                                    .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                        .addComponent(visitID_ModifyRule.get(tab))
                                        .addComponent(visitVisitDate_ModifyRule.get(tab))
                                        .addComponent(visitVisitType_ModifyRule.get(tab))
                                        .addComponent(visitDescription_ModifyRule.get(tab)))
                                    .addComponent(studyName_ModifyRule.get(tab)))
                                .addComponent(studyID_ModifyRule.get(tab))
                                .addComponent(studyStudyTime_ModifyRule.get(tab))
                                .addComponent(studyDescription_ModifyRule.get(tab)))
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                .addComponent(studyStudyTime_Select.get(tab))
                                .addComponent(studyID_Select.get(tab))
                                .addComponent(studyDescription_Select.get(tab))
                                .addComponent(studyName_Select.get(tab))
                                .addComponent(visitDescription_Select.get(tab))
                                .addComponent(visitVisitType_Select.get(tab))
                                .addComponent(visitVisitDate_Select.get(tab))
                                .addComponent(visitID_Select.get(tab)))
                            .addGap(6, 6, 6)
                            .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                                .addComponent(visitID_Value.get(tab), javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.PREFERRED_SIZE, 255, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addComponent(visitVisitDate_Value.get(tab), javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.PREFERRED_SIZE, 255, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addGroup(javax.swing.GroupLayout.Alignment.LEADING, jPanel3Layout.createSequentialGroup()
                                    .addComponent(visitVisitType_Value.get(tab), javax.swing.GroupLayout.PREFERRED_SIZE, 255, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED))
                                .addGroup(javax.swing.GroupLayout.Alignment.LEADING, jPanel3Layout.createSequentialGroup()
                                    .addComponent(visitDescription_Value.get(tab), javax.swing.GroupLayout.PREFERRED_SIZE, 255, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED))
                                .addComponent(studyDescription_Value.get(tab), javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.PREFERRED_SIZE, 255, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addComponent(studyStudyTime_Value.get(tab), javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.PREFERRED_SIZE, 255, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addComponent(studyID_Value.get(tab), javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.PREFERRED_SIZE, 255, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addGroup(javax.swing.GroupLayout.Alignment.LEADING, jPanel3Layout.createSequentialGroup()
                                    .addComponent(studyName_Value.get(tab), javax.swing.GroupLayout.PREFERRED_SIZE, 255, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))))
                        .addGroup(javax.swing.GroupLayout.Alignment.LEADING, jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                            .addGroup(javax.swing.GroupLayout.Alignment.LEADING, jPanel3Layout.createSequentialGroup()
                                .addComponent(Configure.get(tab))
                                .addGap(50, 50, 50)
                                .addComponent(OpenDir.get(tab))
                                .addGap(15, 15, 15)
                                .addComponent(CloseDir.get(tab))
                                .addGap(20, 20, 20)
                                .addComponent(Save.get(tab))
                                .addGap(21, 21, 21)
                                .addComponent(SelectAll.get(tab))
                                .addGap(16, 16, 16)
                                .addComponent(SelectNone.get(tab))
                                .addGap(15, 15, 15)
                                .addComponent(MergeXML.get(tab))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                .addComponent(ApplySelectedRules.get(tab)))
                            .addComponent(jPanel7.get(tab), javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                    .addComponent(jPanel6.get(tab), javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addContainerGap())
            );
            jPanel3Layout.setVerticalGroup(
                jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup()
                    .addGap(350, 350, 350)
                    .addComponent(jPanel6.get(tab), javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGap(286, 286, 286))
                .addGroup(jPanel3Layout.createSequentialGroup()
                    .addComponent(Basepath.get(tab), javax.swing.GroupLayout.PREFERRED_SIZE, 15, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addContainerGap()
                    .addComponent(jSeparator6.get(tab), javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGap(8, 8, 8)
                    .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(jPanel3Layout.createSequentialGroup()
                            .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                                .addGroup(javax.swing.GroupLayout.Alignment.LEADING, jPanel3Layout.createSequentialGroup()
                                    .addGap(1, 1, 1)
                                    .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                        .addGroup(jPanel3Layout.createSequentialGroup()
                                            .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                                .addComponent(FileSystem_Select.get(tab))
                                                .addComponent(FileSystem_Value.get(tab), javax.swing.GroupLayout.PREFERRED_SIZE, 16, javax.swing.GroupLayout.PREFERRED_SIZE))
                                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                            .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                                .addComponent(BIRNID_Select.get(tab))
                                                .addComponent(BIRNID_Value.get(tab), javax.swing.GroupLayout.PREFERRED_SIZE, 16, javax.swing.GroupLayout.PREFERRED_SIZE)))
                                        .addGroup(jPanel3Layout.createSequentialGroup()
                                            .addComponent(FileSystem_ModifyRule.get(tab), javax.swing.GroupLayout.PREFERRED_SIZE, 15, javax.swing.GroupLayout.PREFERRED_SIZE)
                                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                            .addComponent(BIRNID_ModifyRule.get(tab), javax.swing.GroupLayout.PREFERRED_SIZE, 15, javax.swing.GroupLayout.PREFERRED_SIZE)))
                                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                    .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                        .addComponent(scannerID_Select.get(tab))
                                        .addComponent(scannerID_ModifyRule.get(tab), javax.swing.GroupLayout.PREFERRED_SIZE, 15, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addComponent(scannerID_Value.get(tab), javax.swing.GroupLayout.PREFERRED_SIZE, 16, javax.swing.GroupLayout.PREFERRED_SIZE))
                                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                    .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                        .addComponent(scannerManufacturer_Select.get(tab))
                                        .addComponent(scannerManufacturer_ModifyRule.get(tab), javax.swing.GroupLayout.PREFERRED_SIZE, 15, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addComponent(scannerManufacturer_Value.get(tab), javax.swing.GroupLayout.PREFERRED_SIZE, 16, javax.swing.GroupLayout.PREFERRED_SIZE))
                                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                    .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                        .addComponent(acquisitionSiteID_Select.get(tab))
                                        .addComponent(acquisitionSiteID_ModifyRule.get(tab), javax.swing.GroupLayout.PREFERRED_SIZE, 15, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addComponent(acquisitionSiteID_Value.get(tab), javax.swing.GroupLayout.PREFERRED_SIZE, 16, javax.swing.GroupLayout.PREFERRED_SIZE))
                                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                    .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                        .addComponent(subjectGroup_Select.get(tab))
                                        .addComponent(subjectGroup_ModifyRule.get(tab), javax.swing.GroupLayout.PREFERRED_SIZE, 15, Short.MAX_VALUE)
                                        .addComponent(subjectGroup_Value.get(tab), javax.swing.GroupLayout.PREFERRED_SIZE, 16, javax.swing.GroupLayout.PREFERRED_SIZE))
                                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                    .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                        .addComponent(projectName_Select.get(tab))
                                        .addComponent(projectName_ModifyRule.get(tab), javax.swing.GroupLayout.PREFERRED_SIZE, 15, Short.MAX_VALUE)
                                        .addComponent(projectName_Value.get(tab), javax.swing.GroupLayout.PREFERRED_SIZE, 16, javax.swing.GroupLayout.PREFERRED_SIZE))
                                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                    .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                        .addComponent(projectID_Select.get(tab))
                                        .addComponent(projectID_ModifyRule.get(tab), javax.swing.GroupLayout.PREFERRED_SIZE, 15, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addComponent(projectID_Value.get(tab), javax.swing.GroupLayout.PREFERRED_SIZE, 16, javax.swing.GroupLayout.PREFERRED_SIZE))
                                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                    .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                        .addComponent(visitName_Select.get(tab))
                                        .addComponent(visitName_ModifyRule.get(tab), javax.swing.GroupLayout.PREFERRED_SIZE, 15, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addComponent(visitName_Value.get(tab), javax.swing.GroupLayout.PREFERRED_SIZE, 16, javax.swing.GroupLayout.PREFERRED_SIZE)))
                                .addGroup(javax.swing.GroupLayout.Alignment.LEADING, jPanel3Layout.createSequentialGroup()
                                    .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                        .addComponent(visitID_Select.get(tab))
                                        .addComponent(visitID_ModifyRule.get(tab), javax.swing.GroupLayout.PREFERRED_SIZE, 15, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addComponent(visitID_Value.get(tab), javax.swing.GroupLayout.PREFERRED_SIZE, 16, javax.swing.GroupLayout.PREFERRED_SIZE))
                                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                    .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                        .addComponent(visitVisitDate_Select.get(tab))
                                        .addComponent(visitVisitDate_ModifyRule.get(tab), javax.swing.GroupLayout.PREFERRED_SIZE, 15, Short.MAX_VALUE)
                                        .addComponent(visitVisitDate_Value.get(tab), javax.swing.GroupLayout.PREFERRED_SIZE, 16, javax.swing.GroupLayout.PREFERRED_SIZE))
                                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                    .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                        .addComponent(visitVisitType_Select.get(tab))
                                        .addComponent(visitVisitType_ModifyRule.get(tab), javax.swing.GroupLayout.PREFERRED_SIZE, 15, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addComponent(visitVisitType_Value.get(tab), javax.swing.GroupLayout.PREFERRED_SIZE, 16, javax.swing.GroupLayout.PREFERRED_SIZE))
                                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                    .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                        .addComponent(visitDescription_Select.get(tab))
                                        .addComponent(visitDescription_ModifyRule.get(tab), javax.swing.GroupLayout.PREFERRED_SIZE, 15, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addComponent(visitDescription_Value.get(tab), javax.swing.GroupLayout.PREFERRED_SIZE, 16, javax.swing.GroupLayout.PREFERRED_SIZE))
                                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                    .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                        .addComponent(studyName_Select.get(tab))
                                        .addComponent(studyName_ModifyRule.get(tab), javax.swing.GroupLayout.PREFERRED_SIZE, 15, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addComponent(studyName_Value.get(tab), javax.swing.GroupLayout.PREFERRED_SIZE, 16, javax.swing.GroupLayout.PREFERRED_SIZE))
                                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                    .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                        .addComponent(studyID_Select.get(tab))
                                        .addComponent(studyID_ModifyRule.get(tab), javax.swing.GroupLayout.PREFERRED_SIZE, 15, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addComponent(studyID_Value.get(tab), javax.swing.GroupLayout.PREFERRED_SIZE, 16, javax.swing.GroupLayout.PREFERRED_SIZE))
                                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                    .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                        .addComponent(studyStudyTime_Select.get(tab))
                                        .addComponent(studyStudyTime_ModifyRule.get(tab), javax.swing.GroupLayout.PREFERRED_SIZE, 15, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addComponent(studyStudyTime_Value.get(tab), javax.swing.GroupLayout.PREFERRED_SIZE, 16, javax.swing.GroupLayout.PREFERRED_SIZE))
                                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                    .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                        .addComponent(studyDescription_Select.get(tab))
                                        .addComponent(studyDescription_ModifyRule.get(tab), javax.swing.GroupLayout.PREFERRED_SIZE, 15, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addComponent(studyDescription_Value.get(tab), javax.swing.GroupLayout.PREFERRED_SIZE, 16, javax.swing.GroupLayout.PREFERRED_SIZE))))
                            .addGap(20, 20, 20))
                        .addGroup(jPanel3Layout.createSequentialGroup()
                            .addComponent(jSeparator2.get(tab), javax.swing.GroupLayout.PREFERRED_SIZE, 169, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)))
                     .addComponent(jPanel7.get(tab), javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                    .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(Configure.get(tab))
                        .addComponent(OpenDir.get(tab))
                        .addComponent(CloseDir.get(tab))
                        .addComponent(Save.get(tab))
                        .addComponent(SelectAll.get(tab))
                        .addComponent(SelectNone.get(tab))
                        .addComponent(MergeXML.get(tab))
                        .addComponent(ApplySelectedRules.get(tab)))
                    .addGap(131, 131, 131))
            );

            javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1.get(tab));
            jPanel1.get(tab).setLayout(jPanel1Layout);
            jPanel1Layout.setHorizontalGroup(
                jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                .addGroup(jPanel1Layout.createSequentialGroup()
                    .addComponent(jPanel3.get(tab), javax.swing.GroupLayout.PREFERRED_SIZE, 1066, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
            );
            jPanel1Layout.setVerticalGroup(
                jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                .addGroup(jPanel1Layout.createSequentialGroup()
                    .addComponent(jPanel3.get(tab), javax.swing.GroupLayout.PREFERRED_SIZE, jpanel3_target_height, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
            );
    
            javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
            getContentPane().setLayout(layout);
            layout.setHorizontalGroup(
                layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                .addComponent(jTabbedPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 1070, Short.MAX_VALUE)
            );
            layout.setVerticalGroup(
                layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                .addComponent(jTabbedPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 520, Short.MAX_VALUE)
            );
    
            javax.swing.GroupLayout jPanel7Layout = new javax.swing.GroupLayout(jPanel7.get(tab));
            jPanel7.get(tab).setLayout(jPanel7Layout);
            jPanel7Layout.setHorizontalGroup(
                jPanel7Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                .addGroup(jPanel7Layout.createSequentialGroup()
                    .addContainerGap()
                    .addGroup(jPanel7Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(jPanel7Layout.createSequentialGroup()
                            .addComponent(jTabbedPane3.get(tab), javax.swing.GroupLayout.PREFERRED_SIZE, 1005, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addContainerGap())
                        .addGroup(jPanel7Layout.createSequentialGroup()
                            .addComponent(GenerateAll_ModifyRule.get(tab))
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(GenerateAll_Button.get(tab))
                            .addGap(36, 36, 36)
                            .addComponent(SelectAllInSeries.get(tab))
                            .addGap(19, 19, 19)
                            .addComponent(SelectNoneInSeries.get(tab))
                            .addGap(21, 21, 21)
                            .addComponent(NewSeries.get(tab))
                            .addGap(20, 20, 20)
                            .addComponent(DuplicateSeries.get(tab))
                            .addGap(19, 19, 19)
                            .addComponent(DeleteSeries.get(tab), javax.swing.GroupLayout.DEFAULT_SIZE, 120, Short.MAX_VALUE)
                            .addGap(13, 13, 13))))
            );
            jPanel7Layout.setVerticalGroup(
                jPanel7Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                .addGroup(jPanel7Layout.createSequentialGroup()
                    .addContainerGap()
                    .addGroup(jPanel7Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(GenerateAll_ModifyRule.get(tab), javax.swing.GroupLayout.PREFERRED_SIZE, 15, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(GenerateAll_Button.get(tab))
                        .addComponent(DeleteSeries.get(tab))
                        .addComponent(DuplicateSeries.get(tab))
                        .addComponent(NewSeries.get(tab))
                        .addComponent(SelectNoneInSeries.get(tab))
                        .addComponent(SelectAllInSeries.get(tab)))
                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 9, Short.MAX_VALUE)
                    .addComponent(jTabbedPane3.get(tab), javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addContainerGap())
            );

            for (int subtab = 0; subtab < jTabbedPane3.get(tab).getTabCount(); subtab++)
            {
                java.awt.Dimension dim2;
                dim2 = new java.awt.Dimension(1024, 150);
                jPanel8.get(tab).get(subtab).setPreferredSize(dim2);
                jPanel8.get(tab).get(subtab).setMinimumSize(dim2);
                jPanel8.get(tab).get(subtab).setMaximumSize(dim2);

                jPanel8.get(tab).get(subtab).removeAll();
                String tabname = jTabbedPane3.get(tab).getTitleAt(subtab);
                javax.swing.GroupLayout jPanel8Layout = new javax.swing.GroupLayout(jPanel8.get(tab).get(subtab));
                jPanel8.get(tab).get(subtab).setLayout(jPanel8Layout);
                if (!tabname.equals("?"))
                {
                    jPanel8Layout.setHorizontalGroup(
                        jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(jPanel8Layout.createSequentialGroup()
                            .addGroup(jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                                .addGroup(javax.swing.GroupLayout.Alignment.LEADING, jPanel8Layout.createSequentialGroup()
                                    .addContainerGap()
                                    .addComponent(seriesID_ModifyRule.get(tab).get(subtab))
                                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                    .addComponent(seriesID_Select.get(tab).get(subtab)))
                                .addGroup(jPanel8Layout.createSequentialGroup()
                                    .addGroup(jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                        .addComponent(seriesType_ModifyRule.get(tab).get(subtab))
                                        .addComponent(seriesDescription_ModifyRule.get(tab).get(subtab))
                                        .addComponent(seriesSeriesTime_ModifyRule.get(tab).get(subtab)))
                                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                    .addGroup(jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                        .addComponent(seriesSeriesTime_Select.get(tab).get(subtab))
                                        .addComponent(seriesDescription_Select.get(tab).get(subtab))
                                        .addComponent(seriesType_Select.get(tab).get(subtab)))
                                    .addGap(19, 19, 19))
                                .addGroup(javax.swing.GroupLayout.Alignment.LEADING, jPanel8Layout.createSequentialGroup()
                                    .addContainerGap()
                                    .addComponent(seriesNameStandard_ModifyRule.get(tab).get(subtab))
                                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                    .addComponent(seriesNameStandard_Select.get(tab).get(subtab)))
                                .addGroup(javax.swing.GroupLayout.Alignment.LEADING, jPanel8Layout.createSequentialGroup()
                                    .addContainerGap()
                                    .addComponent(seriesNameLocal_ModifyRule.get(tab).get(subtab))
                                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                    .addComponent(seriesNameLocal_Select.get(tab).get(subtab))
                                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)))
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addGroup(jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                .addComponent(seriesNameStandard_Value.get(tab).get(subtab), javax.swing.GroupLayout.PREFERRED_SIZE, 249, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addComponent(seriesNameLocal_Value.get(tab).get(subtab), javax.swing.GroupLayout.PREFERRED_SIZE, 249, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addComponent(seriesID_Value.get(tab).get(subtab), javax.swing.GroupLayout.PREFERRED_SIZE, 249, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addComponent(seriesSeriesTime_Value.get(tab).get(subtab), javax.swing.GroupLayout.PREFERRED_SIZE, 249, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addComponent(seriesDescription_Value.get(tab).get(subtab), javax.swing.GroupLayout.PREFERRED_SIZE, 249, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addComponent(seriesType_Value.get(tab).get(subtab), javax.swing.GroupLayout.PREFERRED_SIZE, 249, javax.swing.GroupLayout.PREFERRED_SIZE))
                            .addGap(16, 16, 16)
                            .addComponent(jSeparator8.get(tab).get(subtab), javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addGap(17, 17, 17)
                            .addGroup(jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                                .addComponent(seriesParadigm_ModifyRule.get(tab).get(subtab))
                                .addComponent(seriesParadigmVersion_ModifyRule.get(tab).get(subtab))
                                .addComponent(seriesNumber_ModifyRule.get(tab).get(subtab))
                                .addComponent(seriesSliceOrder_ModifyRule.get(tab).get(subtab))
                                .addComponent(seriesDiscardAcq_ModifyRule.get(tab).get(subtab))
                                .addComponent(sliceCount_Value.get(tab).get(subtab)))
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addGroup(jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                .addGroup(jPanel8Layout.createSequentialGroup()
                                    .addComponent(seriesParadigm_Select.get(tab).get(subtab))
                                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 53, Short.MAX_VALUE)
                                    .addComponent(seriesParadigm_Value.get(tab).get(subtab), javax.swing.GroupLayout.PREFERRED_SIZE, 223, javax.swing.GroupLayout.PREFERRED_SIZE))
                                .addGroup(jPanel8Layout.createSequentialGroup()
                                    .addComponent(seriesParadigmVersion_Select.get(tab).get(subtab))
                                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                    .addComponent(seriesParadigmVersion_Value.get(tab).get(subtab), javax.swing.GroupLayout.PREFERRED_SIZE, 223, javax.swing.GroupLayout.PREFERRED_SIZE))
                                .addGroup(jPanel8Layout.createSequentialGroup()
                                    .addComponent(seriesNumber_Select.get(tab).get(subtab))
                                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 64, Short.MAX_VALUE)
                                    .addComponent(seriesNumber_Value.get(tab).get(subtab), javax.swing.GroupLayout.PREFERRED_SIZE, 223, javax.swing.GroupLayout.PREFERRED_SIZE))
                                .addGroup(jPanel8Layout.createSequentialGroup()
                                    .addComponent(seriesSliceOrder_Select.get(tab).get(subtab))
                                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 51, Short.MAX_VALUE)
                                    .addComponent(seriesSliceOrder_Value.get(tab).get(subtab), javax.swing.GroupLayout.PREFERRED_SIZE, 223, javax.swing.GroupLayout.PREFERRED_SIZE))
                                .addGroup(jPanel8Layout.createSequentialGroup()
                                    .addComponent(seriesDiscardAcq_Select.get(tab).get(subtab))
                                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 44, Short.MAX_VALUE)
                                    .addComponent(seriesDiscardAcq_Value.get(tab).get(subtab), javax.swing.GroupLayout.PREFERRED_SIZE, 223, javax.swing.GroupLayout.PREFERRED_SIZE))
                                .addGroup(jPanel8Layout.createSequentialGroup()
                                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 44, Short.MAX_VALUE)
                                    .addComponent(displaySeries_Button.get(tab).get(subtab), javax.swing.GroupLayout.PREFERRED_SIZE, 223, javax.swing.GroupLayout.PREFERRED_SIZE)))
                            .addContainerGap())
                    );
                    jPanel8Layout.setVerticalGroup(
                        jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(jPanel8Layout.createSequentialGroup()
                            .addContainerGap()
                            .addGroup(jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                                .addComponent(jSeparator8.get(tab).get(subtab), javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 124, Short.MAX_VALUE)
                                .addGroup(javax.swing.GroupLayout.Alignment.LEADING, jPanel8Layout.createSequentialGroup()
                                    .addGroup(jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                        .addComponent(seriesNameLocal_ModifyRule.get(tab).get(subtab), javax.swing.GroupLayout.PREFERRED_SIZE, 15, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addComponent(seriesNameLocal_Select.get(tab).get(subtab))
                                        .addComponent(seriesNameLocal_Value.get(tab).get(subtab), javax.swing.GroupLayout.PREFERRED_SIZE, 16, javax.swing.GroupLayout.PREFERRED_SIZE))
                                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                    .addGroup(jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                        .addComponent(seriesNameStandard_ModifyRule.get(tab).get(subtab), javax.swing.GroupLayout.PREFERRED_SIZE, 15, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addComponent(seriesNameStandard_Select.get(tab).get(subtab))
                                        .addComponent(seriesNameStandard_Value.get(tab).get(subtab), javax.swing.GroupLayout.PREFERRED_SIZE, 16, javax.swing.GroupLayout.PREFERRED_SIZE))
                                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                    .addGroup(jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                        .addGroup(jPanel8Layout.createSequentialGroup()
                                            .addGroup(jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                                .addComponent(seriesID_ModifyRule.get(tab).get(subtab), javax.swing.GroupLayout.PREFERRED_SIZE, 15, javax.swing.GroupLayout.PREFERRED_SIZE)
                                                .addComponent(seriesID_Select.get(tab).get(subtab)))
                                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                            .addGroup(jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                                .addGroup(jPanel8Layout.createSequentialGroup()
                                                    .addComponent(seriesSeriesTime_ModifyRule.get(tab).get(subtab), javax.swing.GroupLayout.PREFERRED_SIZE, 15, javax.swing.GroupLayout.PREFERRED_SIZE)
                                                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                                    .addComponent(seriesDescription_ModifyRule.get(tab).get(subtab), javax.swing.GroupLayout.PREFERRED_SIZE, 15, javax.swing.GroupLayout.PREFERRED_SIZE)
                                                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                                    .addComponent(seriesType_ModifyRule.get(tab).get(subtab), javax.swing.GroupLayout.PREFERRED_SIZE, 15, javax.swing.GroupLayout.PREFERRED_SIZE))
                                                .addGroup(jPanel8Layout.createSequentialGroup()
                                                    .addGroup(jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                                        .addGroup(jPanel8Layout.createSequentialGroup()
                                                            .addGap(21, 21, 21)
                                                            .addGroup(jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                                                .addComponent(seriesDescription_Select.get(tab).get(subtab))
                                                                .addComponent(seriesDescription_Value.get(tab).get(subtab), javax.swing.GroupLayout.PREFERRED_SIZE, 16, javax.swing.GroupLayout.PREFERRED_SIZE)))
                                                        .addGroup(jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                                            .addComponent(seriesSeriesTime_Select.get(tab).get(subtab))
                                                            .addComponent(seriesSeriesTime_Value.get(tab).get(subtab), javax.swing.GroupLayout.PREFERRED_SIZE, 16, javax.swing.GroupLayout.PREFERRED_SIZE)))
                                                    .addGroup(jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                                        .addGroup(jPanel8Layout.createSequentialGroup()
                                                            .addGap(7, 7, 7)
                                                            .addComponent(seriesType_Select.get(tab).get(subtab)))
                                                        .addGroup(jPanel8Layout.createSequentialGroup()
                                                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                                            .addComponent(seriesType_Value.get(tab).get(subtab), javax.swing.GroupLayout.PREFERRED_SIZE, 16, javax.swing.GroupLayout.PREFERRED_SIZE))))))
                                        .addComponent(seriesID_Value.get(tab).get(subtab), javax.swing.GroupLayout.PREFERRED_SIZE, 16, javax.swing.GroupLayout.PREFERRED_SIZE)))
                                .addGroup(javax.swing.GroupLayout.Alignment.LEADING, jPanel8Layout.createSequentialGroup()
                                    .addGroup(jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                        .addComponent(seriesParadigm_ModifyRule.get(tab).get(subtab), javax.swing.GroupLayout.PREFERRED_SIZE, 15, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addComponent(seriesParadigm_Select.get(tab).get(subtab))
                                        .addComponent(seriesParadigm_Value.get(tab).get(subtab), javax.swing.GroupLayout.PREFERRED_SIZE, 16, javax.swing.GroupLayout.PREFERRED_SIZE))
                                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                    .addGroup(jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                        .addComponent(seriesParadigmVersion_ModifyRule.get(tab).get(subtab), javax.swing.GroupLayout.PREFERRED_SIZE, 15, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addComponent(seriesParadigmVersion_Select.get(tab).get(subtab))
                                        .addComponent(seriesParadigmVersion_Value.get(tab).get(subtab), javax.swing.GroupLayout.PREFERRED_SIZE, 16, javax.swing.GroupLayout.PREFERRED_SIZE))
                                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                    .addGroup(jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                        .addComponent(seriesNumber_ModifyRule.get(tab).get(subtab), javax.swing.GroupLayout.PREFERRED_SIZE, 15, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addComponent(seriesNumber_Select.get(tab).get(subtab))
                                        .addComponent(seriesNumber_Value.get(tab).get(subtab), javax.swing.GroupLayout.PREFERRED_SIZE, 16, javax.swing.GroupLayout.PREFERRED_SIZE))
                                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                    .addGroup(jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                        .addComponent(seriesSliceOrder_ModifyRule.get(tab).get(subtab), javax.swing.GroupLayout.PREFERRED_SIZE, 15, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addComponent(seriesSliceOrder_Select.get(tab).get(subtab))
                                        .addComponent(seriesSliceOrder_Value.get(tab).get(subtab), javax.swing.GroupLayout.PREFERRED_SIZE, 16, javax.swing.GroupLayout.PREFERRED_SIZE))
                                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                    .addGroup(jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                        .addComponent(seriesDiscardAcq_ModifyRule.get(tab).get(subtab), javax.swing.GroupLayout.PREFERRED_SIZE, 15, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addComponent(seriesDiscardAcq_Select.get(tab).get(subtab))
                                        .addComponent(seriesDiscardAcq_Value.get(tab).get(subtab), javax.swing.GroupLayout.PREFERRED_SIZE, 16, javax.swing.GroupLayout.PREFERRED_SIZE))
                                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                    .addGroup(jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                        .addComponent(sliceCount_Value.get(tab).get(subtab), javax.swing.GroupLayout.PREFERRED_SIZE, 15, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addComponent(displaySeries_Button.get(tab).get(subtab), javax.swing.GroupLayout.PREFERRED_SIZE, 16, javax.swing.GroupLayout.PREFERRED_SIZE))))
                            .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                    );
                }
                else
                {
                    jPanel8Layout.setHorizontalGroup(
                        jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(jPanel8Layout.createSequentialGroup()
                            .addContainerGap()
                            .addComponent(nondicomTabs_Select.get(tab))
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(nondicomFiles_ListScroll.get(tab))    // TODO: Add in the list here and below
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(nondicomMove_Button.get(tab))
                        )
                    );
                    jPanel8Layout.setVerticalGroup(
                        jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addComponent(nondicomTabs_Select.get(tab), javax.swing.GroupLayout.PREFERRED_SIZE, 20, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(nondicomFiles_ListScroll.get(tab), javax.swing.GroupLayout.PREFERRED_SIZE, 150, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(nondicomMove_Button.get(tab), javax.swing.GroupLayout.PREFERRED_SIZE, 20, javax.swing.GroupLayout.PREFERRED_SIZE)
                    );    
                }
            }
        }

        pack();        
    }

    private void shrink_window()
    {
        pack();
        if (jPanel7.size() != 0)
        {
//            System.out.println("1: " + jTabbedPane1.getSelectedIndex());
            java.awt.Rectangle rec1 = jPanel7.get(jTabbedPane1.getSelectedIndex()).getBounds();
            if (orig_jpanel7_height > 200)
            {
//                System.out.println("2: " + rec1.height + ", " + orig_jpanel7_height);
                int height_difference = rec1.height - orig_jpanel7_height;
//                System.out.println("3: " + height_difference);
/*
                java.awt.Rectangle rec2;
                java.awt.Dimension dim;
                int x;
                int y;

                rec2 = jPanel6.get(0).getBounds();
                x = rec2.width + rec2.x;
                y = rec2.height + rec2.y + height_difference;
                jPanel6.get(0).setBounds(rec2);
                dim = new java.awt.Dimension(x, y);
                jPanel6.get(0).setPreferredSize(dim);
                
                pack();

                rec2 = jPanel3.get(0).getBounds();
                x = rec2.width + rec2.x;
                y = rec2.height + rec2.y + height_difference;
                jPanel3.get(0).setBounds(rec2);
                dim = new java.awt.Dimension(x, y);
                jPanel3.get(0).setPreferredSize(dim);

                pack();

                rec2 = jPanel1.get(0).getBounds();
                x = rec2.width + rec2.x;
                y = rec2.height + rec2.y + height_difference;
                jPanel1.get(0).setBounds(rec2);
                dim = new java.awt.Dimension(x, y);
                jPanel1.get(0).setPreferredSize(dim);

                pack();
                
                rec2 = jTabbedPane1.getBounds();
                x = rec2.width + rec2.x;
                y = rec2.height + rec2.y + height_difference;
                getContentPane().setBounds(rec2);
                dim = new java.awt.Dimension(x, y + height_difference);
                getContentPane().setPreferredSize(dim);
*/
/*
                jPanel6.get(0).setPreferredSize(null);
                jPanel6.get(0).setMinimumSize(null);
                jPanel6.get(0).setMaximumSize(null);

                jPanel3.get(0).setPreferredSize(null);
                jPanel3.get(0).setMinimumSize(null);
                jPanel3.get(0).setMaximumSize(null);

                jPanel1.get(0).setPreferredSize(null);
                jPanel1.get(0).setMinimumSize(null);
                jPanel1.get(0).setMaximumSize(null);

                jTabbedPane3.get(0).setPreferredSize(null);
                jTabbedPane3.get(0).setMinimumSize(null);
                jTabbedPane3.get(0).setMaximumSize(null);

                jTabbedPane1.setPreferredSize(null);
                jTabbedPane1.setMinimumSize(null);
                jTabbedPane1.setMaximumSize(null);

                getContentPane().setPreferredSize(null);
                getContentPane().setMinimumSize(null);
                getContentPane().setMaximumSize(null);
*/                
                jpanel3_target_height += height_difference;
            }
            orig_jpanel7_height = rec1.height;
        }
/*
      if (jPanel1.size() != 0)
      {
      System.out.println("jPanel1: " + jPanel1.get(0).getBounds());
      System.out.println("jPanel3: " + jPanel3.get(0).getBounds());
      System.out.println("jPanel6: " + jPanel6.get(0).getBounds());
      System.out.println("jSeparator2: " + jSeparator2.get(0).getBounds());
      System.out.println("jSeparator6: " + jSeparator6.get(0).getBounds());
      System.out.println("FileSystem_Select: " + FileSystem_Select.get(0).getBounds());
      System.out.println("BIRNID_Select: " + BIRNID_Select.get(0).getBounds());
      System.out.println("scannerID_Select: " + scannerID_Select.get(0).getBounds());
      System.out.println("scannerManufacturer_Select: " + scannerManufacturer_Select.get(0).getBounds());
      System.out.println("acquisitionSiteID_Select: " + acquisitionSiteID_Select.get(0).getBounds());
      System.out.println("subjectGroup_Select: " + subjectGroup_Select.get(0).getBounds());
      System.out.println("projectName_Select: " + projectName_Select.get(0).getBounds());
      System.out.println("projectID_Select: " + projectID_Select.get(0).getBounds());
      System.out.println("visitName_Select: " + visitName_Select.get(0).getBounds());
      System.out.println("visitID_Select: " + visitID_Select.get(0).getBounds());
      System.out.println("visitVisitDate_Select: " + visitVisitDate_Select.get(0).getBounds());
      System.out.println("visitVisitType_Select: " + visitVisitType_Select.get(0).getBounds());
      System.out.println("visitDescription_Select: " + visitDescription_Select.get(0).getBounds());
      System.out.println("studyName_Select: " + studyName_Select.get(0).getBounds());
      System.out.println("studyID_Select: " + studyID_Select.get(0).getBounds());
      System.out.println("studyStudyTime_Select: " + studyStudyTime_Select.get(0).getBounds());
      System.out.println("studyDescription_Select: " + studyDescription_Select.get(0).getBounds());
      System.out.println("subjectGroup_ModifyRule: " + subjectGroup_ModifyRule.get(0).getBounds());
      System.out.println("projectName_ModifyRule: " + projectName_ModifyRule.get(0).getBounds());
      System.out.println("visitVisitDate_ModifyRule: " + visitVisitDate_ModifyRule.get(0).getBounds());
      System.out.println("visitVisitType_ModifyRule: " + visitVisitType_ModifyRule.get(0).getBounds());
      System.out.println("visitDescription_ModifyRule: " + visitDescription_ModifyRule.get(0).getBounds());
      System.out.println("studyName_ModifyRule: " + studyName_ModifyRule.get(0).getBounds());
      System.out.println("studyID_ModifyRule: " + studyID_ModifyRule.get(0).getBounds());
      System.out.println("studyStudyTime_ModifyRule: " + studyStudyTime_ModifyRule.get(0).getBounds());
      System.out.println("studyDescription_ModifyRule: " + studyDescription_ModifyRule.get(0).getBounds());
      System.out.println("acquisitionSiteID_ModifyRule: " + acquisitionSiteID_ModifyRule.get(0).getBounds());
      System.out.println("BIRNID_ModifyRule: " + BIRNID_ModifyRule.get(0).getBounds());
      System.out.println("scannerID_ModifyRule: " + scannerID_ModifyRule.get(0).getBounds());
      System.out.println("scannerManufacturer_ModifyRule: " + scannerManufacturer_ModifyRule.get(0).getBounds());
      System.out.println("FileSystem_ModifyRule: " + FileSystem_ModifyRule.get(0).getBounds());
      System.out.println("projectID_ModifyRule: " + projectID_ModifyRule.get(0).getBounds());
      System.out.println("visitName_ModifyRule: " + visitName_ModifyRule.get(0).getBounds());
      System.out.println("visitID_ModifyRule: " + visitID_ModifyRule.get(0).getBounds());
      System.out.println("jPanel7: " + jPanel7.get(0).getBounds());
      System.out.println("GenerateAll_ModifyRule: " + GenerateAll_ModifyRule.get(0).getBounds());
      System.out.println("GenerateAll_Button: " + GenerateAll_Button.get(0).getBounds());
      System.out.println("SelectAllInSeries: " + SelectAllInSeries.get(0).getBounds());
      System.out.println("SelectNoneInSeries: " + SelectNoneInSeries.get(0).getBounds());
      System.out.println("NewSeries: " + NewSeries.get(0).getBounds());
      System.out.println("DuplicateSeries: " + DuplicateSeries.get(0).getBounds());
      System.out.println("DeleteSeries: " + DeleteSeries.get(0).getBounds());
      System.out.println("jTabbedPane3: " + jTabbedPane3.get(0).getBounds());
      System.out.println("Configure: " + Configure.get(0).getBounds());
      System.out.println("OpenDir: " + OpenDir.get(0).getBounds());
      System.out.println("CloseDir: " + CloseDir.get(0).getBounds());
      System.out.println("Save: " + Save.get(0).getBounds());
      System.out.println("SelectAll: " + SelectAll.get(0).getBounds());
      System.out.println("SelectNone: " + SelectNone.get(0).getBounds());
      System.out.println("MergeXML: " + MergeXML.get(0).getBounds());
      System.out.println("ApplySelectedRules: " + ApplySelectedRules.get(0).getBounds());
      System.out.println("acquisitionSiteID_Value: " + acquisitionSiteID_Value.get(0).getBounds());
      System.out.println("subjectGroup_Value: " + subjectGroup_Value.get(0).getBounds());
      System.out.println("projectName_Value: " + projectName_Value.get(0).getBounds());
      System.out.println("BIRNID_Value: " + BIRNID_Value.get(0).getBounds());
      System.out.println("scannerID_Value: " + scannerID_Value.get(0).getBounds());
      System.out.println("scannerManufacturer_Value: " + scannerManufacturer_Value.get(0).getBounds());
      System.out.println("FileSystem_Value: " + FileSystem_Value.get(0).getBounds());
      System.out.println("projectID_Value: " + projectID_Value.get(0).getBounds());
      System.out.println("visitName_Value: " + visitName_Value.get(0).getBounds());
      System.out.println("visitID_Value: " + visitID_Value.get(0).getBounds());
      System.out.println("studyDescription_Value: " + studyDescription_Value.get(0).getBounds());
      System.out.println("studyStudyTime_Value: " + studyStudyTime_Value.get(0).getBounds());
      System.out.println("studyID_Value: " + studyID_Value.get(0).getBounds());
      System.out.println("studyName_Value: " + studyName_Value.get(0).getBounds());
      System.out.println("visitDescription_Value: " + visitDescription_Value.get(0).getBounds());
      System.out.println("visitVisitType_Value: " + visitVisitType_Value.get(0).getBounds());
      System.out.println("visitVisitDate_Value: " + visitVisitDate_Value.get(0).getBounds());
      System.out.println("Basepath: " + Basepath.get(0).getBounds());
      System.out.println("jTabbedPane1: " + jTabbedPane1.getBounds());
      System.out.println("nondicomTabs_Select: " + nondicomTabs_Select.get(0).getBounds());
      System.out.println("nondicomFiles_List: " + nondicomFiles_List.get(0).getBounds());
      System.out.println("nondicomMove_Button: " + nondicomMove_Button.get(0).getBounds());
      if (jPanel8.get(0).size() != 0)
      {
      System.out.println("sliceCount_Value: " + sliceCount_Value.get(0).get(0).getBounds());
      System.out.println("displaySeries_Button: " + displaySeries_Button.get(0).get(0).getBounds());
      System.out.println("jPanel8: " + jPanel8.get(0).get(0).getBounds());
      System.out.println("jSeparator8: " + jSeparator8.get(0).get(0).getBounds());
      System.out.println("seriesNameLocal_ModifyRule: " + seriesNameLocal_ModifyRule.get(0).get(0).getBounds());
      System.out.println("seriesNameLocal_Select: " + seriesNameLocal_Select.get(0).get(0).getBounds());
      System.out.println("seriesNameStandard_Select: " + seriesNameStandard_Select.get(0).get(0).getBounds());
      System.out.println("seriesID_Select: " + seriesID_Select.get(0).get(0).getBounds());
      System.out.println("seriesSeriesTime_Select: " + seriesSeriesTime_Select.get(0).get(0).getBounds());
      System.out.println("seriesDescription_Select: " + seriesDescription_Select.get(0).get(0).getBounds());
      System.out.println("seriesType_Select: " + seriesType_Select.get(0).get(0).getBounds());
      System.out.println("seriesNameStandard_ModifyRule: " + seriesNameStandard_ModifyRule.get(0).get(0).getBounds());
      System.out.println("seriesID_ModifyRule: " + seriesID_ModifyRule.get(0).get(0).getBounds());
      System.out.println("seriesSeriesTime_ModifyRule: " + seriesSeriesTime_ModifyRule.get(0).get(0).getBounds());
      System.out.println("seriesDescription_ModifyRule: " + seriesDescription_ModifyRule.get(0).get(0).getBounds());
      System.out.println("seriesType_ModifyRule: " + seriesType_ModifyRule.get(0).get(0).getBounds());
      System.out.println("seriesParadigm_ModifyRule: " + seriesParadigm_ModifyRule.get(0).get(0).getBounds());
      System.out.println("seriesParadigmVersion_ModifyRule: " + seriesParadigmVersion_ModifyRule.get(0).get(0).getBounds());
      System.out.println("seriesNumber_ModifyRule: " + seriesNumber_ModifyRule.get(0).get(0).getBounds());
      System.out.println("seriesSliceOrder_ModifyRule: " + seriesSliceOrder_ModifyRule.get(0).get(0).getBounds());
      System.out.println("seriesDiscardAcq_ModifyRule: " + seriesDiscardAcq_ModifyRule.get(0).get(0).getBounds());
      System.out.println("seriesParadigm_Select: " + seriesParadigm_Select.get(0).get(0).getBounds());
      System.out.println("seriesParadigmVersion_Select: " + seriesParadigmVersion_Select.get(0).get(0).getBounds());
      System.out.println("seriesNumber_Select: " + seriesNumber_Select.get(0).get(0).getBounds());
      System.out.println("seriesSliceOrder_Select: " + seriesSliceOrder_Select.get(0).get(0).getBounds());
      System.out.println("seriesDiscardAcq_Select: " + seriesDiscardAcq_Select.get(0).get(0).getBounds());
      System.out.println("seriesParadigmVersion_Value: " + seriesParadigmVersion_Value.get(0).get(0).getBounds());
      System.out.println("seriesParadigm_Value: " + seriesParadigm_Value.get(0).get(0).getBounds());
      System.out.println("seriesNumber_Value: " + seriesNumber_Value.get(0).get(0).getBounds());
      System.out.println("seriesSliceOrder_Value: " + seriesSliceOrder_Value.get(0).get(0).getBounds());
      System.out.println("seriesDiscardAcq_Value: " + seriesDiscardAcq_Value.get(0).get(0).getBounds());
      System.out.println("seriesNameStandard_Value: " + seriesNameStandard_Value.get(0).get(0).getBounds());
      System.out.println("seriesNameLocal_Value: " + seriesNameLocal_Value.get(0).get(0).getBounds());
      System.out.println("seriesID_Value: " + seriesID_Value.get(0).get(0).getBounds());
      System.out.println("seriesSeriesTime_Value: " + seriesSeriesTime_Value.get(0).get(0).getBounds());
      System.out.println("seriesDescription_Value: " + seriesDescription_Value.get(0).get(0).getBounds());
      System.out.println("seriesType_Value: " + seriesType_Value.get(0).get(0).getBounds());
      }
      System.out.println("--------------------------------------------------------");
      }
*/
    }

    private void BIRNID_ValueFocusLost()
    {
        int selected_tab = jTabbedPane1.getSelectedIndex();
        if (selected_tab == 0)
            return;
        String BIRNID = "";
        if (BIRNID_Value.get(selected_tab).getSelectedItem() != null)
            BIRNID = BIRNID_Value.get(selected_tab).getSelectedItem().toString();
        String ProjectName = "";
        if (projectName_Value.get(selected_tab).getSelectedItem() != null)
            ProjectName = projectName_Value.get(selected_tab).getSelectedItem().toString();
        String VisitName = "";
        if (visitName_Value.get(selected_tab).getSelectedItem() != null)
            VisitName = visitName_Value.get(selected_tab).getSelectedItem().toString();
        jTabbedPane1.setTitleAt(selected_tab, BIRNID + "/" + ProjectName + "/" + VisitName);
    }

    private void visitID_ValueFocusLost()
    {
        int selected_tab = jTabbedPane1.getSelectedIndex();
        if (selected_tab == 0)
            return;
        String BIRNID = "";
        if (BIRNID_Value.get(selected_tab).getSelectedItem() != null)
            BIRNID = BIRNID_Value.get(selected_tab).getSelectedItem().toString();
        String ProjectName = "";
        if (projectName_Value.get(selected_tab).getSelectedItem() != null)
            ProjectName = projectName_Value.get(selected_tab).getSelectedItem().toString();
        String VisitName = "";
        if (visitName_Value.get(selected_tab).getSelectedItem() != null)
            VisitName = visitName_Value.get(selected_tab).getSelectedItem().toString();
        jTabbedPane1.setTitleAt(selected_tab, BIRNID + "/" + ProjectName + "/" + VisitName);
    }

    private void studyID_ValueFocusLost()
    {
        int selected_tab = jTabbedPane1.getSelectedIndex();
        if (selected_tab == 0)
            return;
        String BIRNID = "";
        if (BIRNID_Value.get(selected_tab).getSelectedItem() != null)
            BIRNID = BIRNID_Value.get(selected_tab).getSelectedItem().toString();
        String ProjectName = "";
        if (projectName_Value.get(selected_tab).getSelectedItem() != null)
            ProjectName = projectName_Value.get(selected_tab).getSelectedItem().toString();
        String VisitName = "";
        if (visitName_Value.get(selected_tab).getSelectedItem() != null)
            VisitName = visitName_Value.get(selected_tab).getSelectedItem().toString();
        jTabbedPane1.setTitleAt(selected_tab, BIRNID + "/" + ProjectName + "/" + VisitName);
    }

    private void seriesNameStandard_ValueFocusLost()
    {
        int selected_tab = jTabbedPane1.getSelectedIndex();
        int selected_subtab = jTabbedPane3.get(selected_tab).getSelectedIndex();
        if (selected_subtab == 0)
            return;
        jTabbedPane3.get(selected_tab).setTitleAt(selected_subtab, seriesNameStandard_Value.get(selected_tab).get(selected_subtab).getSelectedItem().toString());
    }

    private void seriesNameLocal_ValueFocusGained()
    {
        int selected_tab = jTabbedPane1.getSelectedIndex();
        int selected_subtab = jTabbedPane3.get(selected_tab).getSelectedIndex();
        if (seriesNameLocal_Value.get(selected_tab).get(selected_subtab).getSelectedItem() != null)
            last_seriesNameLocal_Value = seriesNameLocal_Value.get(selected_tab).get(selected_subtab).getSelectedItem().toString();
        else
            last_seriesNameLocal_Value = "";
    }

    private void seriesNameLocal_ValueFocusLost()
    {
        int selected_tab = jTabbedPane1.getSelectedIndex();
        int selected_subtab = jTabbedPane3.get(selected_tab).getSelectedIndex();
        if (selected_subtab == 0)
            return;
        if (jTabbedPane3.get(selected_tab).getTitleAt(selected_subtab).equals("?"))
            return;
        String oldpath = Basepath.get(selected_tab).getText() + "/" + last_seriesNameLocal_Value;
        new File(oldpath).renameTo(new File(oldpath, seriesNameLocal_Value.get(selected_tab).get(selected_subtab).getSelectedItem().toString()));
        nondicomTabs_Select.get(selected_tab).removeItem(last_seriesNameLocal_Value);
        nondicomTabs_Select.get(selected_tab).addItem(seriesNameLocal_Value.get(selected_tab).get(selected_subtab).getSelectedItem().toString());
    }

    private void displaySeries_ButtonMouseClicked()
    {
        int tab = jTabbedPane1.getSelectedIndex();
        int subtab = jTabbedPane3.get(tab).getSelectedIndex();
        String tabname = seriesNameLocal_Value.get(tab).get(subtab).getSelectedItem().toString();
        String path = all_files_reloc.get(all_files.get(tab).get(tabname).get(0));
        javax.swing.JFrame p = new javax.swing.JFrame();
        AttributeList list = new AttributeList();
        try
        {
            list.read(path);
            p.add(new SingleImagePanel(new SourceImage(list)));
            p.setSize(512,512);
            p.setVisible(true);
        }
        catch (java.io.IOException e)
        {
        }
        catch (com.pixelmed.dicom.DicomException e)
        {
        }
    }

    private void ConfigureMouseClicked()
    {        
        if (ConfigureChooser.showOpenDialog(this) == javax.swing.JFileChooser.APPROVE_OPTION)
        {
            java.io.File file = ConfigureChooser.getSelectedFile();
            String path = file.getAbsolutePath();
            try
            {
                FileInputStream fis  = new FileInputStream(file);
                FileOutputStream fos = new FileOutputStream(new File(System.getProperty("user.home") + "/UploadGUI.xml"));
                byte[] buf = new byte[1024];
                int i = 0;
                while ((i = fis.read(buf)) != -1)
                {
                    fos.write(buf, 0, i);
                }
                fis.close();
                fos.close();
            }
            catch (Exception e)
            {
                System.out.println("IO error copying file " + path + " to " + System.getProperty("user.home"));
            }
        }
        load_rules();
    }

    private void OpenDirMouseClicked()
    {        
        if (OpenDirChooser.showOpenDialog(this) == javax.swing.JFileChooser.APPROVE_OPTION)
        {
            java.io.File files[] = OpenDirChooser.getSelectedFiles();
            for (int i = 0; i < files.length; i++)
            {
                String path = files[i].getAbsolutePath();
                add_components(path);
                add_internal_components(jTabbedPane1.getSelectedIndex());
            }
        }
    }
    
    private void CloseDirMouseClicked()
    {
        int selected_tab = jTabbedPane1.getSelectedIndex();
        int tab_start, tab_end;
        tab_start = selected_tab;
        if (selected_tab == 0)
        {
            tab_start += 1;
            tab_end = jTabbedPane1.getTabCount();
        }
        else
            tab_end = selected_tab + 1;
        
        for (int tab = tab_start; tab < tab_end; tab++)
        {
//            System.out.println("Removing " + tab);
            
            ApplySelectedRules.remove(tab);
            BIRNID_ModifyRule.remove(tab);
            BIRNID_Select.remove(tab);
            BIRNID_Value.remove(tab);
            DeleteSeries.remove(tab);
            DuplicateSeries.remove(tab);
            FileSystem_ModifyRule.remove(tab);    
            FileSystem_Select.remove(tab);
            FileSystem_Value.remove(tab);
            GenerateAll_Button.remove(tab);
            GenerateAll_ModifyRule.remove(tab);
            MergeXML.remove(tab);
            NewSeries.remove(tab);
            Configure.remove(tab);
            OpenDir.remove(tab);
            CloseDir.remove(tab);
            Save.remove(tab);
            SelectAllInSeries.remove(tab);
            SelectAll.remove(tab);
            SelectNoneInSeries.remove(tab);
            SelectNone.remove(tab);
            acquisitionSiteID_ModifyRule.remove(tab);
            acquisitionSiteID_Select.remove(tab);
            acquisitionSiteID_Value.remove(tab);
            jPanel1.remove(tab);
            jPanel3.remove(tab);
            jPanel6.remove(tab);
            jPanel7.remove(tab);
            jPanel8.remove(tab);
            jSeparator2.remove(tab);
            jSeparator6.remove(tab);
            jSeparator8.remove(tab);
            jTabbedPane3.remove(tab);
            projectID_ModifyRule.remove(tab);
            projectID_Select.remove(tab);
            projectID_Value.remove(tab);
            projectName_ModifyRule.remove(tab);
            projectName_Select.remove(tab);
            projectName_Value.remove(tab);
            scannerID_ModifyRule.remove(tab);
            scannerID_Select.remove(tab);
            scannerID_Value.remove(tab);
            scannerManufacturer_ModifyRule.remove(tab);
            scannerManufacturer_Select.remove(tab);
            scannerManufacturer_Value.remove(tab);
            seriesDescription_ModifyRule.remove(tab);
            seriesDescription_Select.remove(tab);
            seriesDescription_Value.remove(tab);
            seriesDiscardAcq_ModifyRule.remove(tab);
            seriesDiscardAcq_Select.remove(tab);
            seriesDiscardAcq_Value.remove(tab);
            seriesID_ModifyRule.remove(tab);
            seriesID_Select.remove(tab);
            seriesID_Value.remove(tab);
            seriesNameLocal_ModifyRule.remove(tab);
            seriesNameLocal_Select.remove(tab);
            seriesNameLocal_Value.remove(tab);
            seriesNameStandard_ModifyRule.remove(tab);
            seriesNameStandard_Select.remove(tab);
            seriesNameStandard_Value.remove(tab);
            seriesNumber_ModifyRule.remove(tab);
            seriesNumber_Select.remove(tab);
            seriesNumber_Value.remove(tab);
            seriesParadigmVersion_ModifyRule.remove(tab);
            seriesParadigmVersion_Select.remove(tab);
            seriesParadigmVersion_Value.remove(tab);
            seriesParadigm_ModifyRule.remove(tab);
            seriesParadigm_Select.remove(tab);
            seriesParadigm_Value.remove(tab);
            seriesSeriesTime_ModifyRule.remove(tab);
            seriesSeriesTime_Select.remove(tab);
            seriesSeriesTime_Value.remove(tab);
            seriesSliceOrder_Select.remove(tab);
            seriesSliceOrder_Value.remove(tab);
            seriesSliceOrder_ModifyRule.remove(tab);
            seriesType_ModifyRule.remove(tab);
            seriesType_Select.remove(tab);
            seriesType_Value.remove(tab);
            studyDescription_ModifyRule.remove(tab);
            studyDescription_Select.remove(tab);
            studyDescription_Value.remove(tab);
            studyID_ModifyRule.remove(tab);
            studyID_Select.remove(tab);
            studyID_Value.remove(tab);
            studyName_ModifyRule.remove(tab);
            studyName_Select.remove(tab);
            studyName_Value.remove(tab);
            studyStudyTime_ModifyRule.remove(tab);
            studyStudyTime_Select.remove(tab);
            studyStudyTime_Value.remove(tab);
            subjectGroup_ModifyRule.remove(tab);
            subjectGroup_Select.remove(tab);
            subjectGroup_Value.remove(tab);
            visitDescription_ModifyRule.remove(tab);
            visitDescription_Select.remove(tab);
            visitDescription_Value.remove(tab);
            visitID_ModifyRule.remove(tab);
            visitID_Select.remove(tab);
            visitID_Value.remove(tab);
            visitName_ModifyRule.remove(tab);
            visitName_Select.remove(tab);
            visitName_Value.remove(tab);
            visitVisitDate_ModifyRule.remove(tab);
            visitVisitDate_Select.remove(tab);
            visitVisitDate_Value.remove(tab);
            visitVisitType_ModifyRule.remove(tab);
            visitVisitType_Select.remove(tab);
            visitVisitType_Value.remove(tab);
            sliceCount_Value.remove(tab);
            displaySeries_Button.remove(tab);
            Basepath.remove(tab);
/*
            for (Iterator subtab_namelocal_iter = all_files.get(tab).keySet().iterator(); subtab_namelocal_iter.hasNext(); )
            {
                String subtab_namelocal = (String)subtab_namelocal_iter.next();
                for (Iterator file_iter = all_files.get(tab).get(subtab_namelocal).iterator(); file_iter.hasNext(); )
                {
                    String file = (String)file_iter.next();
                    ArrayList records = all_files_databases.get(tab).findAllAttributeValuesForAllRecordsForThisInformationEntityWithSpecifiedUID(InformationEntity.INSTANCE, all_tabs_instance_UIDs.get(tab).get(subtab_namelocal));
                    for (Iterator record_iter = records.iterator(); record_iter.hasNext(); )
                    {
                        TreeMap tree_map = (TreeMap)record_iter.next();
                        tree_map.????
                        break;
                    }
                    all_files_databases.get(tab).deleteSelectedRecord(arg0, file);
                }
            }
*/

            all_files.remove(tab);
            all_tabs_instance_UIDs.remove(tab);
            //Should we clean out the associated all_files_reloc?  It should be harmless            
            jTabbedPane1.remove(tab);
        }
        
        jTabbedPane1.setSelectedIndex(jTabbedPane1.getTabCount() - 1);
        redraw();
    }
    
    private void SaveMouseClicked()
    {
        int selected_tab = jTabbedPane1.getSelectedIndex();
        int tab_start, tab_end;
        tab_start = selected_tab;
        if (selected_tab == 0)
        {
            tab_start += 1;
            tab_end = jTabbedPane1.getTabCount();
        }
        else
            tab_end = selected_tab + 1;
        
        for (int tab = tab_start; tab < tab_end; tab++)
        {
            String savefile = new String();
            if (SaveFileChooser.showSaveDialog(this) == javax.swing.JFileChooser.APPROVE_OPTION)
            {
                java.io.File file = SaveFileChooser.getSelectedFile();
                savefile = file.getAbsolutePath();
                try
                {
                    file.delete();
                }
                catch (Exception e)
                {
                    // Do nothing; we just want to make sure that there's no file there.
                }
            }
            else
            {
                continue;
            }

            Element fips = new Element("FIPS");
            Document doc = new Document(fips);
            if (true)   // Designed so we can have different formats of output files if needed; currently, we always use this one.
            {
                try
                {
                    fips.addContent(new Element("FileSystem").setText(FileSystem_Value.get(tab).getSelectedItem().toString()));
                }
                catch (java.lang.NullPointerException e)
                {
                    fips.addContent(new Element("FileSystem").setText(""));            
                }
                try
                {
                    fips.addContent(new Element("BIRNID").setText(BIRNID_Value.get(tab).getSelectedItem().toString()));
                }
                catch (java.lang.NullPointerException e)
                {
                    fips.addContent(new Element("BIRNID").setText(""));            
                }
                try
                {
                    fips.addContent(new Element("scannerID").setText(scannerID_Value.get(tab).getSelectedItem().toString()));
                }
                catch (java.lang.NullPointerException e)
                {
                    fips.addContent(new Element("scannerID").setText(""));            
                }
                try
                {
                    fips.addContent(new Element("scannerManufacturer").setText(scannerManufacturer_Value.get(tab).getSelectedItem().toString()));
                }
                catch (java.lang.NullPointerException e)
                {
                    fips.addContent(new Element("scannerManufacturer").setText(""));            
                }
                try
                {
                    fips.addContent(new Element("acquisitionSiteID").setText(acquisitionSiteID_Value.get(tab).getSelectedItem().toString()));
                }
                catch (java.lang.NullPointerException e)
                {
                    fips.addContent(new Element("acquisitionSiteID").setText(""));            
                }
                try
                {
                    fips.addContent(new Element("subjectGroup").setText(subjectGroup_Value.get(tab).getSelectedItem().toString()));
                }
                catch (java.lang.NullPointerException e)
                {
                    fips.addContent(new Element("subjectGroup").setText(""));            
                }
                Element project = new Element("project")            ;
                try
                {
                    project.addContent(new Element("name").setText(projectName_Value.get(tab).getSelectedItem().toString()));
                }
                catch (java.lang.NullPointerException e)
                {
                    project.addContent(new Element("project").setText(""));            
                }
                try
                {
                    project.addContent(new Element("ID").setText(projectID_Value.get(tab).getSelectedItem().toString()));
                }
                catch (java.lang.NullPointerException e)
                {
                    project.addContent(new Element("ID").setText(""));            
                }
                fips.addContent(project);
                Element visit = new Element("visit");
                try
                {
                    visit.addContent(new Element("name").setText(visitName_Value.get(tab).getSelectedItem().toString()));
                }
                catch (java.lang.NullPointerException e)
                {
                    visit.addContent(new Element("name").setText(""));            
                }
                try
                {
                    visit.addContent(new Element("ID").setText(visitID_Value.get(tab).getSelectedItem().toString()));
                }
                catch (java.lang.NullPointerException e)
                {
                    visit.addContent(new Element("ID").setText(""));            
                }
                try
                {
                    visit.addContent(new Element("visitDate").setText(visitVisitDate_Value.get(tab).getSelectedItem().toString()));
                }
                catch (java.lang.NullPointerException e)
                {
                    visit.addContent(new Element("visitDate").setText(""));            
                }
                try
                {
                    visit.addContent(new Element("visitType").setText(visitVisitType_Value.get(tab).getSelectedItem().toString()));
                }
                catch (java.lang.NullPointerException e)
                {
                    visit.addContent(new Element("visitType").setText(""));            
                }
                try
                {
                    visit.addContent(new Element("visitDescription").setText(visitDescription_Value.get(tab).getSelectedItem().toString()));
                }
                catch (java.lang.NullPointerException e)
                {
                    visit.addContent(new Element("visitDescription").setText(""));            
                }
                fips.addContent(visit);
                Element study = new Element("study");
                try
                {
                    study.addContent(new Element("name").setText(studyName_Value.get(tab).getSelectedItem().toString()));
                }
                catch (java.lang.NullPointerException e)
                {
                    study.addContent(new Element("name").setText(""));            
                }
                try
                {
                    study.addContent(new Element("ID").setText(studyID_Value.get(tab).getSelectedItem().toString()));
                }
                catch (java.lang.NullPointerException e)
                {
                    study.addContent(new Element("ID").setText(""));            
                }
                try
                {
                    study.addContent(new Element("studyTime").setText(studyStudyTime_Value.get(tab).getSelectedItem().toString()));
                }
                catch (java.lang.NullPointerException e)
                {
                    study.addContent(new Element("studyTime").setText(""));            
                }
                try
                {
                    study.addContent(new Element("description").setText(studyDescription_Value.get(tab).getSelectedItem().toString()));
                }
                catch (java.lang.NullPointerException e)
                {
                    study.addContent(new Element("description").setText(""));            
                }
                fips.addContent(study);
                for (int series_idx = 0; series_idx < jTabbedPane3.get(tab).getTabCount(); series_idx++)
                {
                    try
                    {
                        if (seriesNameStandard_Value.get(tab).get(series_idx).getSelectedItem().toString().equals(""))
                        {
                            continue;
                        }
                    }
                    catch (java.lang.NullPointerException e)
                    {
                        continue;
                    }
                
                    Element series = new Element("series");
                    try
                    {
                        series.addContent(new Element("nameLocal").setText(seriesNameLocal_Value.get(tab).get(series_idx).getSelectedItem().toString()));
                    }
                    catch (java.lang.NullPointerException e)
                    {
                        series.addContent(new Element("nameLocal").setText(""));            
                    }
                    try
                    {
                        series.addContent(new Element("nameStandard").setText(seriesNameStandard_Value.get(tab).get(series_idx).getSelectedItem().toString()));
                    }
                    catch (java.lang.NullPointerException e)
                    {
                        series.addContent(new Element("nameStandard").setText(""));            
                    }
                    try
                    {
                        series.addContent(new Element("ID").setText(seriesID_Value.get(tab).get(series_idx).getSelectedItem().toString()));
                    }
                    catch (java.lang.NullPointerException e)
                    {
                        series.addContent(new Element("ID").setText(""));            
                    }
                    try
                    {
                        series.addContent(new Element("seriesTime").setText(seriesSeriesTime_Value.get(tab).get(series_idx).getSelectedItem().toString()));
                    }
                    catch (java.lang.NullPointerException e)
                    {
                        series.addContent(new Element("seriesTime").setText(""));            
                    }
                    try
                    {
                        series.addContent(new Element("description").setText(seriesDescription_Value.get(tab).get(series_idx).getSelectedItem().toString()));
                    }
                    catch (java.lang.NullPointerException e)
                    {
                        series.addContent(new Element("description").setText(""));            
                    }
                    try
                    {
                        series.addContent(new Element("type").setText(seriesType_Value.get(tab).get(series_idx).getSelectedItem().toString()));
                    }
                    catch (java.lang.NullPointerException e)
                    {
                        series.addContent(new Element("type").setText(""));            
                    }
                    try
                    {
                        series.addContent(new Element("paradigm").setText(seriesParadigm_Value.get(tab).get(series_idx).getSelectedItem().toString()));
                    }
                    catch (java.lang.NullPointerException e)
                    {
                        series.addContent(new Element("paradigm").setText(""));            
                    }
                    try
                    {
                        series.addContent(new Element("paradigmVersion").setText(seriesParadigmVersion_Value.get(tab).get(series_idx).getSelectedItem().toString()));
                    }
                    catch (java.lang.NullPointerException e)
                    {
                        series.addContent(new Element("paradigmVersion").setText(""));            
                    }
                    try
                    {
                        series.addContent(new Element("number").setText(seriesNumber_Value.get(tab).get(series_idx).getSelectedItem().toString()));
                    }
                    catch (java.lang.NullPointerException e)
                    {
                        series.addContent(new Element("number").setText(""));            
                    }
                    try
                    {
                        series.addContent(new Element("sliceorder").setText(seriesSliceOrder_Value.get(tab).get(series_idx).getSelectedItem().toString()));
                    }
                    catch (java.lang.NullPointerException e)
                    {
                        series.addContent(new Element("sliceorder").setText(""));            
                    }
                    try
                    {
                        series.addContent(new Element("discardAcq").setText(seriesDiscardAcq_Value.get(tab).get(series_idx).getSelectedItem().toString()));
                    }
                    catch (java.lang.NullPointerException e)
                    {
                        series.addContent(new Element("discardAcq").setText(""));            
                    }
                    series.addContent(new Element("skipInitialVols").setText("0"));
                    Element analysislevel = new Element("analysislevel");
                    analysislevel.addContent(new Element("level").setText("none"));
                    analysislevel.addContent(new Element("name").setText("none"));
                    series.addContent(analysislevel);
                    fips.addContent(series);
                }
            }
            XMLOutputter out = new XMLOutputter();
        
            java.io.FileWriter writer;
            try
            {
//                System.out.println(BIRNID_Value.get(tab).getSelectedItem().toString() + "_" + projectName_Value.get(tab).getSelectedItem().toString() + "_" + visitName_Value.get(tab).getSelectedItem().toString() + ".xml");
//                writer = new java.io.FileWriter(BIRNID_Value.get(tab).getSelectedItem().toString() + "_" + projectName_Value.get(tab).getSelectedItem().toString() + "_" + visitName_Value.get(tab).getSelectedItem().toString() + ".xml");
                writer = new java.io.FileWriter(savefile);
                out.setFormat(org.jdom.output.Format.getPrettyFormat());
                out.output(doc, writer);
                writer.flush();
                writer.close();            
            }
            catch (java.io.IOException e)
            {
                System.out.println("ERROR: Can't write configuration file: " + BIRNID_Value.get(tab).getSelectedItem().toString() + "_" + projectName_Value.get(tab).getSelectedItem().toString() + "_" + visitName_Value.get(tab).getSelectedItem().toString() + ".xml");
                return;
            }
        }
        
    }
    
    private void SelectNoneMouseClicked()
    {
        int selected_tab = jTabbedPane1.getSelectedIndex();
        int selected_subtab = jTabbedPane3.get(selected_tab).getSelectedIndex();
        
        int tab_start, tab_end;
        tab_start = selected_tab;
        if (selected_tab == 0)
            tab_end = jTabbedPane1.getTabCount();
        else
            tab_end = selected_tab + 1;
        
        for (int tab = tab_start; tab < tab_end; tab++)
        {
            FileSystem_Select.get(tab).setSelected(false);
            BIRNID_Select.get(tab).setSelected(false);
            scannerID_Select.get(tab).setSelected(false);
            scannerManufacturer_Select.get(tab).setSelected(false);
            acquisitionSiteID_Select.get(tab).setSelected(false);
            subjectGroup_Select.get(tab).setSelected(false);
            projectName_Select.get(tab).setSelected(false);
            projectID_Select.get(tab).setSelected(false);
            visitName_Select.get(tab).setSelected(false);
            visitID_Select.get(tab).setSelected(false);
            visitVisitDate_Select.get(tab).setSelected(false);
            visitVisitType_Select.get(tab).setSelected(false);
            visitDescription_Select.get(tab).setSelected(false);
            studyName_Select.get(tab).setSelected(false);
            studyID_Select.get(tab).setSelected(false);
            studyStudyTime_Select.get(tab).setSelected(false);
            studyDescription_Select.get(tab).setSelected(false);

            int subtab_start, subtab_end;
            subtab_start = selected_subtab;
            if (selected_subtab == 0)
                subtab_end = jTabbedPane3.get(tab).getTabCount();
            else
                subtab_end = selected_subtab + 1;

            for (int subtab = subtab_start; subtab < subtab_end; subtab++)
            {
                seriesNameLocal_Select.get(tab).get(subtab).setSelected(false);
                seriesNameStandard_Select.get(tab).get(subtab).setSelected(false);
                seriesID_Select.get(tab).get(subtab).setSelected(false);
                seriesSeriesTime_Select.get(tab).get(subtab).setSelected(false);
                seriesDescription_Select.get(tab).get(subtab).setSelected(false);
                seriesType_Select.get(tab).get(subtab).setSelected(false);
                seriesParadigm_Select.get(tab).get(subtab).setSelected(false);
                seriesParadigmVersion_Select.get(tab).get(subtab).setSelected(false);
                seriesNumber_Select.get(tab).get(subtab).setSelected(false);
                seriesSliceOrder_Select.get(tab).get(subtab).setSelected(false);
                seriesDiscardAcq_Select.get(tab).get(subtab).setSelected(false);
            }
        }
    }

    
    private void SelectAllMouseClicked()
    {
        int selected_tab = jTabbedPane1.getSelectedIndex();
        int selected_subtab = jTabbedPane3.get(selected_tab).getSelectedIndex();
        
        int tab_start, tab_end;
        tab_start = selected_tab;
        if (selected_tab == 0)
            tab_end = jTabbedPane1.getTabCount();
        else
            tab_end = selected_tab + 1;
        
        for (int tab = tab_start; tab < tab_end; tab++)
        {
            FileSystem_Select.get(tab).setSelected(true);
            BIRNID_Select.get(tab).setSelected(true);
            scannerID_Select.get(tab).setSelected(true);
            scannerManufacturer_Select.get(tab).setSelected(true);
            acquisitionSiteID_Select.get(tab).setSelected(true);
            subjectGroup_Select.get(tab).setSelected(true);
            projectName_Select.get(tab).setSelected(true);
            projectID_Select.get(tab).setSelected(true);
            visitName_Select.get(tab).setSelected(true);
            visitID_Select.get(tab).setSelected(true);
            visitVisitDate_Select.get(tab).setSelected(true);
            visitVisitType_Select.get(tab).setSelected(true);
            visitDescription_Select.get(tab).setSelected(true);
            studyName_Select.get(tab).setSelected(true);
            studyID_Select.get(tab).setSelected(true);
            studyStudyTime_Select.get(tab).setSelected(true);
            studyDescription_Select.get(tab).setSelected(true);

            int subtab_start, subtab_end;
            subtab_start = selected_subtab;
            if (selected_subtab == 0)
                subtab_end = jTabbedPane3.get(tab).getTabCount();
            else
                subtab_end = selected_subtab + 1;

            for (int subtab = subtab_start; subtab < subtab_end; subtab++)
            {
                seriesNameLocal_Select.get(tab).get(subtab).setSelected(true);
                seriesNameStandard_Select.get(tab).get(subtab).setSelected(true);
                seriesID_Select.get(tab).get(subtab).setSelected(true);
                seriesSeriesTime_Select.get(tab).get(subtab).setSelected(true);
                seriesDescription_Select.get(tab).get(subtab).setSelected(true);
                seriesType_Select.get(tab).get(subtab).setSelected(true);
                seriesParadigm_Select.get(tab).get(subtab).setSelected(true);
                seriesParadigmVersion_Select.get(tab).get(subtab).setSelected(true);
                seriesNumber_Select.get(tab).get(subtab).setSelected(true);
                seriesSliceOrder_Select.get(tab).get(subtab).setSelected(true);
                seriesDiscardAcq_Select.get(tab).get(subtab).setSelected(true);
            }
        }
    }
    
    private void MergeXMLMouseClicked()
    {
        String filename = new String();
        if (MergeFileChooser.showOpenDialog(this) == javax.swing.JFileChooser.APPROVE_OPTION)
        {
            java.io.File file = MergeFileChooser.getSelectedFile();
            filename = file.getAbsolutePath();
        }
        else
        {
            return;
        }
            
        SAXBuilder builder = new SAXBuilder(false);
        Document doc;
        try
        {
            doc = builder.build(filename);
        }
        catch (JDOMException e)
        {
            System.out.println("ERROR: Cannot load xml file: " + e.toString());
            MergeXMLMouseClicked();
            return;
        }
        catch (java.io.IOException e)
        {
            System.out.println("ERROR:  Cannot load xml file: " + e.toString());
            MergeXMLMouseClicked();
            return;
        }

        String FileSystem = "";
        String BIRNID = "";
        String scannerID = "";
        String scannerManufacturer = "";
        String acquisitionSiteID = "";
        String subjectGroup = "";
        String projectName = "";
        String projectID = "";
        String visitName = "";
        String visitID = "";
        String visitVisitDate = "";
        String visitVisitType = "";
        String visitDescription = "";
        String studyName = "";
        String studyID = "";
        String studyStudyTime = "";
        String studyDescription = "";
        ArrayList<String> seriesNameLocal_arr = new ArrayList<String>();
        ArrayList<String> seriesNameStandard_arr = new ArrayList<String>();
        ArrayList<String> seriesID_arr = new ArrayList<String>();
        ArrayList<String> seriesDescription_arr = new ArrayList<String>();
        ArrayList<String> seriesType_arr = new ArrayList<String>();
        ArrayList<String> seriesSeriesTime_arr = new ArrayList<String>();
        ArrayList<String> seriesParadigm_arr = new ArrayList<String>();
        ArrayList<String> seriesParadigmVersion_arr = new ArrayList<String>();
        ArrayList<String> seriesNumber_arr = new ArrayList<String>();
        ArrayList<String> seriesSliceOrder_arr = new ArrayList<String>();
        ArrayList<String> seriesDiscardAcq_arr = new ArrayList<String>();
        
        List doc_list = doc.getRootElement().getChildren();
        for (Iterator element_iterator = doc_list.iterator(); element_iterator.hasNext(); )
        {
            Element cur_element = (Element)element_iterator.next();
            if (cur_element.getName().contentEquals("FileSystem"))
                FileSystem = cur_element.getText();
            else if (cur_element.getName().contentEquals("BIRNID"))
                BIRNID = cur_element.getText();
            else if (cur_element.getName().contentEquals("scannerID"))
                scannerID = cur_element.getText();
            else if (cur_element.getName().contentEquals("scannerManufacturer"))
                scannerManufacturer = cur_element.getText();
            else if (cur_element.getName().contentEquals("acquisitionSiteID"))
                acquisitionSiteID = cur_element.getText();
            else if (cur_element.getName().contentEquals("subjectGroup"))
                subjectGroup = cur_element.getText();
            else if (cur_element.getName().contentEquals("project"))
            {
                List cur_element_children = cur_element.getChildren();
                for (Iterator project_iterator = cur_element_children.iterator(); project_iterator.hasNext(); )
                {
                    Element project_element = (Element)project_iterator.next();
                    if (project_element.getName().contentEquals("name"))
                        projectName = project_element.getText();
                    else if (project_element.getName().contentEquals("ID"))
                        projectID = project_element.getText();            
                }
            }
            else if (cur_element.getName().contentEquals("visit"))
            {
                List cur_element_children = cur_element.getChildren();
                for (Iterator visit_iterator = cur_element_children.iterator(); visit_iterator.hasNext(); )
                {
                    Element visit_element = (Element)visit_iterator.next();
                    if (visit_element.getName().contentEquals("name"))
                        visitName = visit_element.getText();
                    else if (visit_element.getName().contentEquals("ID"))
                        visitID = visit_element.getText();            
                    else if (visit_element.getName().contentEquals("visitDate"))
                        visitVisitDate = visit_element.getText();            
                    else if (visit_element.getName().contentEquals("visitType"))
                        visitVisitType = visit_element.getText();            
                    else if (visit_element.getName().contentEquals("description"))
                        visitDescription = visit_element.getText();            
                }
            }
            else if (cur_element.getName().contentEquals("study"))
            {
                List cur_element_children = cur_element.getChildren();
                for (Iterator study_iterator = cur_element_children.iterator(); study_iterator.hasNext(); )
                {
                    Element study_element = (Element)study_iterator.next();
                    if (study_element.getName().contentEquals("name"))
                        studyName = study_element.getText();
                    else if (study_element.getName().contentEquals("ID"))
                        studyID = study_element.getText();            
                    else if (study_element.getName().contentEquals("studyTime"))
                        studyStudyTime = study_element.getText();            
                    else if (study_element.getName().contentEquals("description"))
                        studyDescription = study_element.getText();            
                }
            }
            else if (cur_element.getName().contentEquals("series"))
            {
                String seriesNameLocal = "";
                String seriesNameStandard = "";
                String seriesID = "";
                String seriesDescription = "";
                String seriesType = "";
                String seriesSeriesTime = "";
                String seriesParadigm = "";
                String seriesParadigmVersion = "";
                String seriesNumber = "";
                String seriesSliceOrder = "";
                String seriesDiscardAcq = "";
        
                List cur_element_children = cur_element.getChildren();
                for (Iterator series_iterator = cur_element_children.iterator(); series_iterator.hasNext(); )
                {
                    Element series_element = (Element)series_iterator.next();
                    if (series_element.getName().contentEquals("nameLocal"))
                        seriesNameLocal = series_element.getText();
                    else if (series_element.getName().contentEquals("nameStandard"))
                        seriesNameStandard = series_element.getText();
                    else if (series_element.getName().contentEquals("seriesID"))
                        seriesID = series_element.getText();            
                    else if (series_element.getName().contentEquals("seriesSeriesTime"))
                        seriesSeriesTime = series_element.getText();            
                    else if (series_element.getName().contentEquals("description"))
                        seriesDescription = series_element.getText();            
                    else if (series_element.getName().contentEquals("type"))
                        seriesType = series_element.getText();            
                    else if (series_element.getName().contentEquals("paradigm"))
                        seriesParadigm = series_element.getText();            
                    else if (series_element.getName().contentEquals("paradigmVersion"))
                        seriesParadigmVersion = series_element.getText();            
                    else if (series_element.getName().contentEquals("number"))
                        seriesNumber = series_element.getText();            
                    else if (series_element.getName().contentEquals("sliceorder"))
                        seriesSliceOrder = series_element.getText();            
                    else if (series_element.getName().contentEquals("discardAcq"))
                        seriesDiscardAcq = series_element.getText();            
                }
                seriesNameLocal_arr.add(seriesNameLocal);
                seriesNameStandard_arr.add(seriesNameStandard);
                seriesID_arr.add(seriesID);
                seriesDescription_arr.add(seriesDescription);
                seriesType_arr.add(seriesType);
                seriesSeriesTime_arr.add(seriesSeriesTime);
                seriesParadigm_arr.add(seriesParadigm);
                seriesParadigmVersion_arr.add(seriesParadigmVersion);
                seriesNumber_arr.add(seriesNumber);
                seriesSliceOrder_arr.add(seriesSliceOrder);
                seriesDiscardAcq_arr.add(seriesDiscardAcq);
            }
        }

        int selected_tab = jTabbedPane1.getSelectedIndex();
        int selected_subtab = jTabbedPane3.get(selected_tab).getSelectedIndex();
        
        int tab_start, tab_end;
        tab_start = selected_tab;
        if (selected_tab == 0)
            tab_end = jTabbedPane1.getTabCount();
        else
            tab_end = selected_tab + 1;
        
        for (int tab = tab_start; tab < tab_end; tab++)
        {
            if (FileSystem_Select.get(tab).isSelected())
            {
                FileSystem_Value.get(tab).setSelectedItem(FileSystem);
            }
            if (BIRNID_Select.get(tab).isSelected())
            {
                BIRNID_Value.get(tab).removeAllItems();
                BIRNID_Value.get(tab).addItem(BIRNID);
                BIRNID_Value.get(tab).setSelectedItem(BIRNID);
                BIRNID_Value.get(tab).setSelectedIndex(0);
            }
            if (scannerID_Select.get(tab).isSelected())
            {
                scannerID_Value.get(tab).removeAllItems();
                scannerID_Value.get(tab).addItem(scannerID);
                scannerID_Value.get(tab).setSelectedItem(scannerID);
                scannerID_Value.get(tab).setSelectedIndex(0);
            }
            if (scannerManufacturer_Select.get(tab).isSelected())
            {
                scannerManufacturer_Value.get(tab).removeAllItems();
                scannerManufacturer_Value.get(tab).addItem(scannerManufacturer);
                scannerManufacturer_Value.get(tab).setSelectedItem(scannerManufacturer);
                scannerManufacturer_Value.get(tab).setSelectedIndex(0);
            }
            if (acquisitionSiteID_Select.get(tab).isSelected())
            {
                acquisitionSiteID_Value.get(tab).removeAllItems();
                acquisitionSiteID_Value.get(tab).addItem(acquisitionSiteID);
                acquisitionSiteID_Value.get(tab).setSelectedItem(acquisitionSiteID);
                acquisitionSiteID_Value.get(tab).setSelectedIndex(0);
            }
            if (subjectGroup_Select.get(tab).isSelected())
            {
                subjectGroup_Value.get(tab).removeAllItems();
                subjectGroup_Value.get(tab).addItem(subjectGroup);
                subjectGroup_Value.get(tab).setSelectedIndex(0);
                subjectGroup_Value.get(tab).setSelectedItem(subjectGroup);
            }
            if (projectName_Select.get(tab).isSelected())
            {
                projectName_Value.get(tab).removeAllItems();
                projectName_Value.get(tab).addItem(projectName);
                projectName_Value.get(tab).setSelectedIndex(0);
                projectName_Value.get(tab).setSelectedItem(projectName);
            }
            if (projectID_Select.get(tab).isSelected())
            {
                projectID_Value.get(tab).removeAllItems();
                projectID_Value.get(tab).addItem(projectID);
                projectID_Value.get(tab).setSelectedIndex(0);
                projectID_Value.get(tab).setSelectedItem(projectID);
            }
            if (visitName_Select.get(tab).isSelected())
            {
                visitName_Value.get(tab).removeAllItems();
                visitName_Value.get(tab).addItem(visitName);
                visitName_Value.get(tab).setSelectedIndex(0);
                visitName_Value.get(tab).setSelectedItem(visitName);
            }
            if (visitID_Select.get(tab).isSelected())
            {
                visitID_Value.get(tab).removeAllItems();
                visitID_Value.get(tab).addItem(visitID);
                visitID_Value.get(tab).setSelectedIndex(0);
                visitID_Value.get(tab).setSelectedItem(visitID);
            }
            if (visitVisitDate_Select.get(tab).isSelected())
            {
                visitVisitDate_Value.get(tab).removeAllItems();
                visitVisitDate_Value.get(tab).addItem(visitVisitDate);
                visitVisitDate_Value.get(tab).setSelectedIndex(0);
                visitVisitDate_Value.get(tab).setSelectedItem(visitVisitDate);
            }
            if (visitVisitType_Select.get(tab).isSelected())
            {
                visitVisitType_Value.get(tab).removeAllItems();
                visitVisitType_Value.get(tab).addItem(visitVisitType);
                visitVisitType_Value.get(tab).setSelectedIndex(0);
                visitVisitType_Value.get(tab).setSelectedItem(visitVisitType);
            }
            if (visitDescription_Select.get(tab).isSelected())
            {
                visitDescription_Value.get(tab).removeAllItems();
                visitDescription_Value.get(tab).addItem(visitDescription);
                visitDescription_Value.get(tab).setSelectedIndex(0);
                visitDescription_Value.get(tab).setSelectedItem(visitDescription);
            }
            if (studyName_Select.get(tab).isSelected())
            {
                studyName_Value.get(tab).removeAllItems();
                studyName_Value.get(tab).addItem(studyName);
                studyName_Value.get(tab).setSelectedIndex(0);
                studyName_Value.get(tab).setSelectedItem(studyName);
            }
            if (studyID_Select.get(tab).isSelected())
            {
                studyID_Value.get(tab).removeAllItems();
                studyID_Value.get(tab).addItem(studyID);
                studyID_Value.get(tab).setSelectedIndex(0);
                studyID_Value.get(tab).setSelectedItem(studyID);
            }
            if (studyStudyTime_Select.get(tab).isSelected())
            {
                studyStudyTime_Value.get(tab).removeAllItems();
                studyStudyTime_Value.get(tab).addItem(studyStudyTime);
                studyStudyTime_Value.get(tab).setSelectedIndex(0);
                studyStudyTime_Value.get(tab).setSelectedItem(studyStudyTime);
            }
            if (studyDescription_Select.get(tab).isSelected())
            {
                studyDescription_Value.get(tab).removeAllItems();
                studyDescription_Value.get(tab).addItem(studyDescription);
                studyDescription_Value.get(tab).setSelectedIndex(0);
                studyDescription_Value.get(tab).setSelectedItem(studyDescription);
            }
            
            int subtab_start, subtab_end;
            subtab_start = selected_subtab;
            if (selected_subtab == 0)
                subtab_end = jTabbedPane3.get(tab).getTabCount();
            else
                subtab_end = selected_subtab + 1;

            for (int subtab = subtab_start; subtab < subtab_end; subtab++)
            {
                String nameStandard = seriesNameStandard_arr.get(subtab);
                for (int subtab_id = 0; subtab_id < seriesNameStandard_Value.get(tab).size(); subtab_id++)
                {
                    if (seriesNameStandard_Value.get(tab).get(subtab_id).toString().equals(nameStandard))
                    {
                        if (seriesNameLocal_Select.get(tab).get(subtab_id).isSelected())
                        {
                            seriesNameLocal_Value.get(tab).get(subtab_id).removeAll();
                            seriesNameLocal_Value.get(tab).get(subtab_id).addItem(seriesNameLocal_arr.get(subtab));
                            seriesNameLocal_Value.get(tab).get(subtab_id).setSelectedIndex(0);
                            seriesNameLocal_Value.get(tab).get(subtab_id).setSelectedItem(seriesNameLocal_arr.get(subtab));
                        }
                        if (seriesID_Select.get(tab).get(subtab_id).isSelected())
                        {
                            seriesID_Value.get(tab).get(subtab_id).removeAll();
                            seriesID_Value.get(tab).get(subtab_id).addItem(seriesID_arr.get(subtab));
                            seriesID_Value.get(tab).get(subtab_id).setSelectedIndex(0);
                            seriesID_Value.get(tab).get(subtab_id).setSelectedItem(seriesID_arr.get(subtab));
                        }
                        if (seriesSeriesTime_Select.get(tab).get(subtab_id).isSelected())
                        {
                            seriesSeriesTime_Value.get(tab).get(subtab_id).removeAll();
                            seriesSeriesTime_Value.get(tab).get(subtab_id).addItem(seriesSeriesTime_arr.get(subtab));
                            seriesSeriesTime_Value.get(tab).get(subtab_id).setSelectedIndex(0);
                            seriesSeriesTime_Value.get(tab).get(subtab_id).setSelectedItem(seriesSeriesTime_arr.get(subtab));
                        }
                        if (seriesDescription_Select.get(tab).get(subtab_id).isSelected())
                        {
                            seriesDescription_Value.get(tab).get(subtab_id).removeAll();
                            seriesDescription_Value.get(tab).get(subtab_id).addItem(seriesDescription_arr.get(subtab));
                            seriesDescription_Value.get(tab).get(subtab_id).setSelectedIndex(0);
                            seriesDescription_Value.get(tab).get(subtab_id).setSelectedItem(seriesDescription_arr.get(subtab));
                        }
                        if (seriesType_Select.get(tab).get(subtab_id).isSelected())
                        {
                            seriesType_Value.get(tab).get(subtab_id).removeAll();
                            seriesType_Value.get(tab).get(subtab_id).addItem(seriesType_arr.get(subtab));
                            seriesType_Value.get(tab).get(subtab_id).setSelectedIndex(0);
                            seriesType_Value.get(tab).get(subtab_id).setSelectedItem(seriesType_arr.get(subtab));
                        }
                        if (seriesParadigm_Select.get(tab).get(subtab_id).isSelected())
                        {
                            seriesParadigm_Value.get(tab).get(subtab_id).removeAll();
                            seriesParadigm_Value.get(tab).get(subtab_id).addItem(seriesParadigm_arr.get(subtab));
                            seriesParadigm_Value.get(tab).get(subtab_id).setSelectedIndex(0);
                            seriesParadigm_Value.get(tab).get(subtab_id).setSelectedItem(seriesParadigm_arr.get(subtab));
                        }
                        if (seriesParadigmVersion_Select.get(tab).get(subtab_id).isSelected())
                        {
                            seriesParadigmVersion_Value.get(tab).get(subtab_id).removeAll();
                            seriesParadigmVersion_Value.get(tab).get(subtab_id).addItem(seriesParadigmVersion_arr.get(subtab));
                            seriesParadigmVersion_Value.get(tab).get(subtab_id).setSelectedIndex(0);
                            seriesParadigmVersion_Value.get(tab).get(subtab_id).setSelectedItem(seriesParadigmVersion_arr.get(subtab));
                        }
                        if (seriesNumber_Select.get(tab).get(subtab_id).isSelected())
                        {
                            seriesNumber_Value.get(tab).get(subtab_id).removeAll();
                            seriesNumber_Value.get(tab).get(subtab_id).addItem(seriesNumber_arr.get(subtab));
                            seriesNumber_Value.get(tab).get(subtab_id).setSelectedIndex(0);
                            seriesNumber_Value.get(tab).get(subtab_id).setSelectedItem(seriesNumber_arr.get(subtab));
                        }
                        if (seriesSliceOrder_Select.get(tab).get(subtab_id).isSelected())
                        {
                            seriesSliceOrder_Value.get(tab).get(subtab_id).removeAll();
                            seriesSliceOrder_Value.get(tab).get(subtab_id).addItem(seriesSliceOrder_arr.get(subtab));
                            seriesSliceOrder_Value.get(tab).get(subtab_id).setSelectedIndex(0);
                            seriesSliceOrder_Value.get(tab).get(subtab_id).setSelectedItem(seriesSliceOrder_arr.get(subtab));
                        }
                        if (seriesDiscardAcq_Select.get(tab).get(subtab_id).isSelected())
                        {
                            seriesDiscardAcq_Value.get(tab).get(subtab_id).removeAll();
                            seriesDiscardAcq_Value.get(tab).get(subtab_id).addItem(seriesDiscardAcq_arr.get(subtab));
                            seriesDiscardAcq_Value.get(tab).get(subtab_id).setSelectedIndex(0);
                            seriesDiscardAcq_Value.get(tab).get(subtab_id).setSelectedItem(seriesDiscardAcq_arr.get(subtab));
                        }
                    }
                }
            }
        }
    }
    
    private HashMap<String, Boolean> get_tab_metadata(int tab, int subtab, String fieldname)
    {
        HashMap<String, Boolean> choices = new HashMap<String, Boolean>();

  //      for (int subtab = 0; subtab < jTabbedPane3.get(tab).getTabCount(); subtab++)
//        {   
            if (seriesNameLocal_Value.get(tab).get(subtab).getSelectedItem() == null)
            {
//                System.out.println("Ret 0");
                return choices;
            }

            String subtab_namelocal = seriesNameLocal_Value.get(tab).get(subtab).getSelectedItem().toString();
//            System.out.println("Tabcheck: " + tab + ", " + subtab + ": " + subtab_namelocal);
            if (subtab_namelocal.equals(""))
            { 
//                System.out.println("Ret 1");
                return choices;
            }
//            System.out.println(all_files.get(tab).keySet());
            for (Iterator file_iterator = all_files.get(tab).get(subtab_namelocal).iterator(); file_iterator.hasNext(); )
            {
                String file = (String)file_iterator.next();
//                System.out.println("Applying rule for " + fieldname + " to file " + file);
                rules.get(0);
                rules.get(0).get(fieldname);

                AttributeList attribute_list = null;
                try
                {
                    if (com.pixelmed.dicom.DicomFileUtilities.isDicomOrAcrNemaFile(file))
                   {
                        attribute_list = new AttributeList();
                        try
                        {
                            attribute_list.read(file);
                        }
                        catch (Exception e)
                        {
                            System.out.println("ERROR: Could not read file " + file);
                        }
                    }
                }
                catch (Exception e)
                {  
                }

                ArrayList<String> apply_rule_ret = rules.get(0).get(fieldname).apply_rule_to_file(file, attribute_list, tab, subtab);
//                if (apply_rule_ret.size() > 0)
//                    System.out.println("Returned: " + apply_rule_ret.get(0));
//                else
//                    System.out.println("Returned no results?");
                for (Iterator ret_iterator = apply_rule_ret.iterator(); ret_iterator.hasNext(); )
                {
                    String val = (String)ret_iterator.next();
//                    System.out.println("  Adding " + val);
                    choices.put(val, true);
                }
                break;
            }
 //       }

//        System.out.println("3");
        return choices;
    }
    
    private void ApplySelectedRulesMouseClicked()
    {
        int selected_tab = jTabbedPane1.getSelectedIndex();
        int selected_subtab = jTabbedPane3.get(selected_tab).getSelectedIndex();
        
        int tab_start, tab_end;
        tab_start = selected_tab;
        if (selected_tab == 0)
        {
            tab_start += 1;
            tab_end = jTabbedPane1.getTabCount();
        }
        else
            tab_end = selected_tab + 1;
        
        for (int tab = tab_start; tab < tab_end; tab++)
        {
            if (BIRNID_Select.get(tab).isSelected())
            {
//                System.out.println("BIRNID selected.");
                BIRNID_Value.get(tab).removeAllItems();
                HashMap<String, Boolean> choices = get_tab_metadata(tab, 1, "BIRNID");
//                System.out.println("Choice length: " + choices.size());
                
                for (Iterator choice_iterator = choices.keySet().iterator(); choice_iterator.hasNext(); )
                {
                    String val = (String)choice_iterator.next();
//                    System.out.println("Possible result: " + val);
                    BIRNID_Value.get(tab).addItem(val);
                    BIRNID_Value.get(tab).setSelectedItem(val);
                    BIRNID_Value.get(tab).setSelectedIndex(0);
                }
            }

            if (acquisitionSiteID_Select.get(tab).isSelected())
            {
                acquisitionSiteID_Value.get(tab).removeAllItems();
                HashMap<String, Boolean> choices = get_tab_metadata(tab, 1, "acquisitionSiteID");
                
                for (Iterator choice_iterator = choices.keySet().iterator(); choice_iterator.hasNext(); )
                {
                    String val = (String)choice_iterator.next();
                    acquisitionSiteID_Value.get(tab).addItem(val);
                    acquisitionSiteID_Value.get(tab).setSelectedItem(val);
                    acquisitionSiteID_Value.get(tab).setSelectedIndex(0);
                }
            }

            if (scannerID_Select.get(tab).isSelected())
            {
                scannerID_Value.get(tab).removeAllItems();
                HashMap<String, Boolean> choices = get_tab_metadata(tab, 1, "scannerID");
                
                for (Iterator choice_iterator = choices.keySet().iterator(); choice_iterator.hasNext(); )
                {
                    String val = (String)choice_iterator.next();
                    scannerID_Value.get(tab).addItem(val);
                    scannerID_Value.get(tab).setSelectedItem(val);
                    scannerID_Value.get(tab).setSelectedIndex(0);
                }
            }

            if (scannerManufacturer_Select.get(tab).isSelected())
            {
                scannerManufacturer_Value.get(tab).removeAllItems();
                HashMap<String, Boolean> choices = get_tab_metadata(tab, 1, "scannerManufacturer");
                
                for (Iterator choice_iterator = choices.keySet().iterator(); choice_iterator.hasNext(); )
                {
                    String val = (String)choice_iterator.next();
                    scannerManufacturer_Value.get(tab).addItem(val);
                    scannerManufacturer_Value.get(tab).setSelectedItem(val);
                    scannerManufacturer_Value.get(tab).setSelectedIndex(0);
                }
            }

            if (subjectGroup_Select.get(tab).isSelected())
            {
                subjectGroup_Value.get(tab).removeAllItems();
                HashMap<String, Boolean> choices = get_tab_metadata(tab, 1, "subjectGroup");
                
                for (Iterator choice_iterator = choices.keySet().iterator(); choice_iterator.hasNext(); )
                {
                    String val = (String)choice_iterator.next();
//                    System.out.println("Ultimately adding " + val);
                    subjectGroup_Value.get(tab).addItem(val);
                    subjectGroup_Value.get(tab).setSelectedItem(val);
                    subjectGroup_Value.get(tab).setSelectedIndex(0);
                }
            }

            if (projectName_Select.get(tab).isSelected())
            {
               projectName_Value.get(tab).removeAllItems();
               HashMap<String, Boolean> choices = get_tab_metadata(tab, 1, "project/name");
                
                for (Iterator choice_iterator = choices.keySet().iterator(); choice_iterator.hasNext(); )
                {
                    String val = (String)choice_iterator.next();
//                    System.out.println("Ultimately adding " + val);
                    projectName_Value.get(tab).addItem(val);
                    projectName_Value.get(tab).setSelectedItem(val);
                    projectName_Value.get(tab).setSelectedIndex(0);
                }
            }

            if (projectID_Select.get(tab).isSelected())
            {
                projectID_Value.get(tab).removeAllItems();
                HashMap<String, Boolean> choices = get_tab_metadata(tab, 1, "project/ID");
                
                for (Iterator choice_iterator = choices.keySet().iterator(); choice_iterator.hasNext(); )
                {
                    String val = (String)choice_iterator.next();
//                    System.out.println("Ultimately adding " + val);
                    projectID_Value.get(tab).addItem(val);
                    projectID_Value.get(tab).setSelectedItem(val);
                    projectID_Value.get(tab).setSelectedIndex(0);
                }
            }

            if (visitName_Select.get(tab).isSelected())
            {
                visitName_Value.get(tab).removeAllItems();
                HashMap<String, Boolean> choices = get_tab_metadata(tab, 1, "visit/name");
                
                for (Iterator choice_iterator = choices.keySet().iterator(); choice_iterator.hasNext(); )
                {
                    String val = (String)choice_iterator.next();
//                    System.out.println("Ultimately adding " + val);
                    visitName_Value.get(tab).addItem(val);
                    visitName_Value.get(tab).setSelectedItem(val);
                    visitName_Value.get(tab).setSelectedIndex(0);
                }
            }

            if (visitID_Select.get(tab).isSelected())
            {
                visitID_Value.get(tab).removeAllItems();
                HashMap<String, Boolean> choices = get_tab_metadata(tab, 1, "visit/ID");
                
                for (Iterator choice_iterator = choices.keySet().iterator(); choice_iterator.hasNext(); )
                {
                    String val = (String)choice_iterator.next();
//                    System.out.println("Ultimately adding " + val);
                    visitID_Value.get(tab).addItem(val);
                    visitID_Value.get(tab).setSelectedItem(val);
                    visitID_Value.get(tab).setSelectedIndex(0);
                }
            }

            if (visitVisitDate_Select.get(tab).isSelected())
            {
                visitVisitDate_Value.get(tab).removeAllItems();
                HashMap<String, Boolean> choices = get_tab_metadata(tab, 1, "visit/visitDate");
                
                for (Iterator choice_iterator = choices.keySet().iterator(); choice_iterator.hasNext(); )
                {
                    String val = (String)choice_iterator.next();
//                    System.out.println("Ultimately adding " + val);
                    visitVisitDate_Value.get(tab).addItem(val);
                    visitVisitDate_Value.get(tab).setSelectedItem(val);
                    visitVisitDate_Value.get(tab).setSelectedIndex(0);
                }
            }

            if (visitVisitType_Select.get(tab).isSelected())
            {
                visitVisitType_Value.get(tab).removeAllItems();
                HashMap<String, Boolean> choices = get_tab_metadata(tab, 1, "visit/visitType");
                
                for (Iterator choice_iterator = choices.keySet().iterator(); choice_iterator.hasNext(); )
                {
                    String val = (String)choice_iterator.next();
//                    System.out.println("Ultimately adding " + val);
                    visitVisitType_Value.get(tab).addItem(val);
                    visitVisitType_Value.get(tab).setSelectedItem(val);
                    visitVisitType_Value.get(tab).setSelectedIndex(0);
                }
            }

            if (visitDescription_Select.get(tab).isSelected())
            {
                visitDescription_Value.get(tab).removeAllItems();
                HashMap<String, Boolean> choices = get_tab_metadata(tab, 1, "visit/description");
                
                for (Iterator choice_iterator = choices.keySet().iterator(); choice_iterator.hasNext(); )
                {
                    String val = (String)choice_iterator.next();
//                    System.out.println("Ultimately adding " + val);
                    visitDescription_Value.get(tab).addItem(val);
                    visitDescription_Value.get(tab).setSelectedItem(val);
                    visitDescription_Value.get(tab).setSelectedIndex(0);
                }
            }

            if (studyName_Select.get(tab).isSelected())
            {
                studyName_Value.get(tab).removeAllItems();
                HashMap<String, Boolean> choices = get_tab_metadata(tab, 1, "study/name");
                
                for (Iterator choice_iterator = choices.keySet().iterator(); choice_iterator.hasNext(); )
                {
                    String val = (String)choice_iterator.next();
//                    System.out.println("Ultimately adding " + val);
                    studyName_Value.get(tab).addItem(val);
                    studyName_Value.get(tab).setSelectedItem(val);
                    studyName_Value.get(tab).setSelectedIndex(0);
                }
            }

            if (studyID_Select.get(tab).isSelected())
            {
                studyID_Value.get(tab).removeAllItems();
                HashMap<String, Boolean> choices = get_tab_metadata(tab, 1, "study/ID");
                
                for (Iterator choice_iterator = choices.keySet().iterator(); choice_iterator.hasNext(); )
                {
                    String val = (String)choice_iterator.next();
//                    System.out.println("Ultimately adding " + val);
                    studyID_Value.get(tab).addItem(val);
                    studyID_Value.get(tab).setSelectedItem(val);
                    studyID_Value.get(tab).setSelectedIndex(0);
                }
            }

//            System.out.println("studyTime: 0");
            if (studyStudyTime_Select.get(tab).isSelected())
            {
//                System.out.println("studyTime: 1");
                studyStudyTime_Value.get(tab).removeAllItems();
                HashMap<String, Boolean> choices = get_tab_metadata(tab, 1, "study/studyTime");
//                System.out.println("studyTime: 2: " + choices.size());
                
                for (Iterator choice_iterator = choices.keySet().iterator(); choice_iterator.hasNext(); )
                {
                    String val = (String)choice_iterator.next();
//                    System.out.println("studyTime: 3: " + val);
//                    System.out.println("Ultimately adding " + val);
                    studyStudyTime_Value.get(tab).addItem(val);
                    studyStudyTime_Value.get(tab).setSelectedItem(val);
                    studyStudyTime_Value.get(tab).setSelectedIndex(0);
                }
            }

            if (studyDescription_Select.get(tab).isSelected())
            {
                studyDescription_Value.get(tab).removeAllItems();
                HashMap<String, Boolean> choices = get_tab_metadata(tab, 1, "study/description");
                
                for (Iterator choice_iterator = choices.keySet().iterator(); choice_iterator.hasNext(); )
                {
                    String val = (String)choice_iterator.next();
//                    System.out.println("Ultimately adding " + val);
                    studyDescription_Value.get(tab).addItem(val);
                    studyDescription_Value.get(tab).setSelectedItem(val);
                    studyDescription_Value.get(tab).setSelectedIndex(0);
                }
            }

            int subtab_start, subtab_end;
            subtab_start = selected_subtab;
            if (selected_subtab == 0)
                subtab_end = jTabbedPane3.get(tab).getTabCount();
            else
                subtab_end = selected_subtab + 1;

            for (int subtab = subtab_start; subtab < subtab_end; subtab++)
            {
                if (seriesSeriesTime_Select.get(tab).get(subtab).isSelected())
                {
                    seriesSeriesTime_Value.get(tab).get(subtab).removeAllItems();
                    HashMap<String, Boolean> choices = get_tab_metadata(tab, subtab, "series/seriesTime");
                
                    for (Iterator choice_iterator = choices.keySet().iterator(); choice_iterator.hasNext(); )
                    {
                        String val = (String)choice_iterator.next();
//                        System.out.println("Ultimately adding " + val);
                        seriesSeriesTime_Value.get(tab).get(subtab).addItem(val);
                        seriesSeriesTime_Value.get(tab).get(subtab).setSelectedItem(val);
                        seriesSeriesTime_Value.get(tab).get(subtab).setSelectedIndex(0);
                    }
                }

                if (seriesDescription_Select.get(tab).get(subtab).isSelected())
                {
                    seriesDescription_Value.get(tab).get(subtab).removeAllItems();
                    HashMap<String, Boolean> choices = get_tab_metadata(tab, subtab, "series/description");
                
                    for (Iterator choice_iterator = choices.keySet().iterator(); choice_iterator.hasNext(); )
                    {
                        String val = (String)choice_iterator.next();
//                        System.out.println("Ultimately adding " + val);
                        seriesDescription_Value.get(tab).get(subtab).addItem(val);
                        seriesDescription_Value.get(tab).get(subtab).setSelectedItem(val);
                        seriesDescription_Value.get(tab).get(subtab).setSelectedIndex(0);
                    }
                }

                if (seriesType_Select.get(tab).get(subtab).isSelected())
                {
                    seriesType_Value.get(tab).get(subtab).removeAllItems();
                    HashMap<String, Boolean> choices = get_tab_metadata(tab, subtab, "series/type");
                
                    for (Iterator choice_iterator = choices.keySet().iterator(); choice_iterator.hasNext(); )
                    {
                        String val = (String)choice_iterator.next();
//                        System.out.println("Ultimately adding " + val);
                        seriesType_Value.get(tab).get(subtab).addItem(val);
                        seriesType_Value.get(tab).get(subtab).setSelectedItem(val);
                        seriesType_Value.get(tab).get(subtab).setSelectedIndex(0);
                    }
                }

                if (seriesParadigm_Select.get(tab).get(subtab).isSelected())
                {
                    seriesParadigm_Value.get(tab).get(subtab).removeAllItems();
                    HashMap<String, Boolean> choices = get_tab_metadata(tab, subtab, "series/paradigm");
                
                    for (Iterator choice_iterator = choices.keySet().iterator(); choice_iterator.hasNext(); )
                    {
                        String val = (String)choice_iterator.next();
//                        System.out.println("Ultimately adding " + val);
                        seriesParadigm_Value.get(tab).get(subtab).addItem(val);
                        seriesParadigm_Value.get(tab).get(subtab).setSelectedItem(val);
                        seriesParadigm_Value.get(tab).get(subtab).setSelectedIndex(0);
                    }
                }

                if (seriesParadigmVersion_Select.get(tab).get(subtab).isSelected())
                {
                    seriesParadigmVersion_Value.get(tab).get(subtab).removeAllItems();
                    HashMap<String, Boolean> choices = get_tab_metadata(tab, subtab, "series/paradigmVersion");
                
                    for (Iterator choice_iterator = choices.keySet().iterator(); choice_iterator.hasNext(); )
                    {
                        String val = (String)choice_iterator.next();
//                        System.out.println("Ultimately adding " + val);
                        seriesParadigmVersion_Value.get(tab).get(subtab).addItem(val);
                        seriesParadigmVersion_Value.get(tab).get(subtab).setSelectedItem(val);
                        seriesParadigmVersion_Value.get(tab).get(subtab).setSelectedIndex(0);
                    }
                }

                if (seriesID_Select.get(tab).get(subtab).isSelected())
                {
                    seriesID_Value.get(tab).get(subtab).removeAllItems();
                    HashMap<String, Boolean> choices = get_tab_metadata(tab, subtab, "series/ID");
                
                    for (Iterator choice_iterator = choices.keySet().iterator(); choice_iterator.hasNext(); )
                    {
                        String val = (String)choice_iterator.next();
//                        System.out.println("Ultimately adding " + val);
                        seriesID_Value.get(tab).get(subtab).addItem(val);
                        seriesID_Value.get(tab).get(subtab).setSelectedItem(val);
                        seriesID_Value.get(tab).get(subtab).setSelectedIndex(0);
                    }
                }

                if (seriesNumber_Select.get(tab).get(subtab).isSelected())
                {
                    seriesNumber_Value.get(tab).get(subtab).removeAllItems();
                    HashMap<String, Boolean> choices = get_tab_metadata(tab, subtab, "series/number");
                
                    for (Iterator choice_iterator = choices.keySet().iterator(); choice_iterator.hasNext(); )
                    {
                        String val = (String)choice_iterator.next();
//                        System.out.println("Ultimately adding " + val);
                        seriesNumber_Value.get(tab).get(subtab).addItem(val);
                        seriesNumber_Value.get(tab).get(subtab).setSelectedItem(val);
                        seriesNumber_Value.get(tab).get(subtab).setSelectedIndex(0);
                    }
                }

                if (seriesSliceOrder_Select.get(tab).get(subtab).isSelected())
                {
                    seriesSliceOrder_Value.get(tab).get(subtab).removeAllItems();
                    HashMap<String, Boolean> choices = get_tab_metadata(tab, subtab, "series/sliceOrder");
                
                    for (Iterator choice_iterator = choices.keySet().iterator(); choice_iterator.hasNext(); )
                    {
                        String val = (String)choice_iterator.next();
//                        System.out.println("Ultimately adding " + val);
                        seriesSliceOrder_Value.get(tab).get(subtab).addItem(val);
                        seriesSliceOrder_Value.get(tab).get(subtab).setSelectedItem(val);
                        seriesSliceOrder_Value.get(tab).get(subtab).setSelectedIndex(0);
                    }
                }

                if (seriesDiscardAcq_Select.get(tab).get(subtab).isSelected())
                {
                    seriesDiscardAcq_Value.get(tab).get(subtab).removeAllItems();
                    HashMap<String, Boolean> choices = get_tab_metadata(tab, subtab, "series/discardAcq");
                
                    for (Iterator choice_iterator = choices.keySet().iterator(); choice_iterator.hasNext(); )
                    {
                        String val = (String)choice_iterator.next();
//                        System.out.println("Ultimately adding " + val);
                        seriesDiscardAcq_Value.get(tab).get(subtab).addItem(val);
                        seriesDiscardAcq_Value.get(tab).get(subtab).setSelectedItem(val);
                        seriesDiscardAcq_Value.get(tab).get(subtab).setSelectedIndex(0);
                    }
                }
            }
            String BIRNID = "";
            if (BIRNID_Value.get(tab).getSelectedItem() != null)
                BIRNID = BIRNID_Value.get(tab).getSelectedItem().toString();
            String ProjectName = "";
            if (projectName_Value.get(tab).getSelectedItem() != null)
                ProjectName = projectName_Value.get(tab).getSelectedItem().toString();
            String VisitName = "";
            if (visitName_Value.get(tab).getSelectedItem() != null)
                VisitName = visitName_Value.get(tab).getSelectedItem().toString();
            jTabbedPane1.setTitleAt(tab, BIRNID + "/" + ProjectName + "/" + VisitName);
        }
    }
    
    private void ModifyRuleMouseClicked(String rule)
    {
        ModifyRuleUI obj = new ModifyRuleUI(this, rule);
        obj.setVisible(true);
        obj.set_rulegroup(rules.get(0).get(rule));
    }

    private void GenerateAll_ButtonMouseClicked()
    {
        int selected_tab = jTabbedPane1.getSelectedIndex();
        int tab_start, tab_end;
        tab_start = selected_tab;
        if (selected_tab == 0)
        {
            tab_start += 1;
            tab_end = jTabbedPane1.getTabCount();
        }
        else
            tab_end = selected_tab + 1;
        
        for (int tab = tab_start; tab < tab_end; tab++)
        {
            for (Iterator subtab_namelocal_iter = all_files.get(tab).keySet().iterator(); subtab_namelocal_iter.hasNext(); )
            {
                String subtab_namelocal = (String)subtab_namelocal_iter.next();
                for (Iterator file_iter = all_files.get(tab).get(subtab_namelocal).iterator(); file_iter.hasNext(); )
                {
                    String file = (String)file_iter.next();
//                    all_files_databases.get(tab).deleteSelectedRecord(arg0, file);
                }
            }
            all_files.get(tab).clear();
            all_tabs_instance_UIDs.get(tab).clear();
            //No need to clear all_files_reloc, right?
            GenerateAll_Button.get(tab).setEnabled(false);
        
            File directory;
//            System.out.println(tab + "; " + Basepath.get(tab).getText());
            ArrayList<String> files = build_file_list(Basepath.get(tab).getText());

            Map<String, ArrayList<String>> hash = new HashMap<String, ArrayList<String>>();
            for (Iterator files_iterator = files.iterator(); files_iterator.hasNext(); )
            {
                AttributeList attribute_list = new AttributeList();
                String file = (String)files_iterator.next();
                try
                {
                    if (com.pixelmed.dicom.DicomFileUtilities.isDicomOrAcrNemaFile(file))
                    {
                        try
                        {
//                            System.out.println(file);
                            attribute_list.read(file);
                        }
                        catch (Exception e)
                        {
                            continue;   
                        }
 
//                        System.out.println("Dicom: " + fname);
                        String study_UID = com.pixelmed.dicom.Attribute.getDelimitedStringValuesOrEmptyString(attribute_list, TagFromName.StudyInstanceUID);
                        String series_UID = com.pixelmed.dicom.Attribute.getDelimitedStringValuesOrEmptyString(attribute_list, TagFromName.SeriesInstanceUID);

                        String combined = study_UID + "::" + series_UID;
                        if (!hash.containsKey(combined))
                            hash.put(combined, new ArrayList<String>());  
                        hash.get(combined).add(file);
                     }
                    else
                    {
//                      System.out.println("Not a dicom: " + fname);
                        String combined = "NonDicom";
                        if (!hash.containsKey(combined))
                            hash.put(combined, new ArrayList<String>());  
                        hash.get(combined).add(file);                        
                    }
                }
                catch (Exception e)
                {
//                    System.out.println("Not dicom, plus an exception: " + fname);
                    String combined = "NonDicom";
                    if (!hash.containsKey(combined))
                        hash.put(combined, new ArrayList<String>());  
                    hash.get(combined).add(file);                        
                }
            }

            HashMap<String, HashMap<String, Boolean> > tabs_to_add = new HashMap<String, HashMap<String, Boolean> >();
            for (Iterator hash_iterator = hash.keySet().iterator(); hash_iterator.hasNext(); )
            {
                String grouping = (String)hash_iterator.next();
                ArrayList<String> file_array = hash.get(grouping);
                for (Iterator file_iterator = file_array.iterator(); file_iterator.hasNext(); )
                {
                    String file = (String)file_iterator.next();
                    int subtab = jTabbedPane3.get(tab).getTabCount();

                    AttributeList attribute_list = null;
                    try
                    {
                        if (com.pixelmed.dicom.DicomFileUtilities.isDicomOrAcrNemaFile(file))
                        {
                            attribute_list = new AttributeList();
                            try
                            {
                                attribute_list.read(file);
                            }
                            catch (Exception e)
                            {
                                System.out.println("ERROR: Could not read file " + file);
                            }
                        }
                    }
                    catch (Exception e)
                    {  
                    }

                    ArrayList<String> apply_rule_ret = rules.get(0).get("series/nameStandard").apply_rule_to_file(file, attribute_list, tab, subtab);
                    String chosen;
                    chosen = apply_rule_ret.get(0);
                    String series_UID = "?";
  //                  System.out.println("Chosen = |" + chosen + "|; File = " + file);

                    try
                    {
                        if (com.pixelmed.dicom.DicomFileUtilities.isDicomOrAcrNemaFile(file))
                        {
                            int group = Integer.parseInt("0020", 16);
                            int element = Integer.parseInt("000e", 16);
                            AttributeTag attr = new AttributeTag(group, element);
                            AttributeList attr_list = new AttributeList();
                            try
                            {
                                attr_list.read(file);
                                series_UID = com.pixelmed.dicom.Attribute.getSingleStringValueOrEmptyString(attr_list, attr);
//                                System.out.println("series_UID: " + attr_list.keySet()  + ", " + attr + ": " + series_UID);
                                if (series_UID.length() < 1)
                                {
                                   System.out.println("ERROR ON " + file + ": " + series_UID + " / " + chosen);
                                   series_UID = "?";
                                }
                            }
                            catch (Exception e)
                            {  
                                  //Non-dicom
 //                               System.out.println("ERROR: Could not read file " + file);
                                  series_UID = "?";
                            }
                        }
                    }
                    catch (Exception e)
                    {  
                          //Non-dicom plus error
//                        System.out.println("ERROR: Could not read file " + file);
                          series_UID = "?";
                    }
                    chosen = series_UID + "__" + chosen;
                    HashMap<String, Boolean> choices = new HashMap<String, Boolean>();
                    for (Iterator ret_iterator = apply_rule_ret.iterator(); ret_iterator.hasNext(); )
                    {
                        String val = series_UID + "__" + (String)ret_iterator.next();
                        choices.put(val, true);
                    }

//                    System.out.println("0) " + file + "; " + chosen + "; " + choices.size());
                    tabs_to_add.put(chosen, choices);
                    if (all_files.get(tab).get(chosen) == null)
                    {
                        all_files.get(tab).put(chosen, new ArrayList<String>());
                    }
/*
                    DicomInputStream dfi = new DicomInputStream(new BufferedInputStream(new FileInputStream(file)));
                    AttributeList list = new AttributeList();
                    list.read(dfi);
                    dfi.close();
                    if (all_tabs_instance_UIDs.get(tab).get(chosen) == null)
                    {
                        int group = Integer.parseInt("0020", 16);
                        int element = Integer.parseInt("000e", 16);
                        AttributeTag attr = new AttributeTag(group, element);
                        String[] params = com.pixelmed.dicom.Attribute.getStringValues(attribute_list, attr);
                        String param = "";
                        if (params != null)
                        {
                            for (int i = 0; i < params.length; i++)
                            {
                                param += params[i].replace("\\", "\\\\");
                                if (i < params.length - 1)
                                    param += "\\";
                            }
                        }
                        all_tabs_instance_UIDs.get(tab).put(chosen, param);
                    }
                    all_files_databases.get(tab).insertObject(list, file);
*/
                    all_files.get(tab).get(chosen).add(file);
//                    System.out.println("Adding file: " + chosen + ": " + file);
                    String newdir = Basepath.get(tab).getText() + "/" + chosen;
                    String newfile = newdir + "/" + basename(file.replaceAll(Basepath.get(tab).getText(), newdir));
                    all_files_reloc.put(file, newfile);
//                    System.out.println(file + "; " + newdir + "; " + newfile);
                    new File(newdir).mkdirs();
                    try
                    {
                        FileInputStream fis  = new FileInputStream(new File(file));
                        FileOutputStream fos = new FileOutputStream(new File(newfile));
                        byte[] buf = new byte[1024];
                        int i = 0;
                        while ((i = fis.read(buf)) != -1)
                        {
                            fos.write(buf, 0, i);
                        }
                        fis.close();
                        fos.close();
                    }
                    catch (Exception e)
                    {
                        System.out.println("IO error copying file " + file + " to " + newdir);
                    }
//                    all_files_databases.get(tab).SOMEHOW_WRITE_THE_ENTRY_FOR_FILE_TO_NEWFILE();
                }
            }
            
            for (Iterator tabs_iterator = tabs_to_add.keySet().iterator(); tabs_iterator.hasNext(); )
            {
                String chosen = (String)tabs_iterator.next();
                String tabname = new String();
                Pattern chosen_pattern = Pattern.compile("^(.*?)__(.*)$");
                Matcher chosen_matcher = chosen_pattern.matcher(chosen);
                if (chosen_matcher.find())
                {
                    tabname = chosen_matcher.group(2);
                }
//                System.out.println("1) " + chosen + "; " + tabname);
                int subtab = jTabbedPane3.get(tab).getTabCount();
                if (tabname.equals("?"))
                {
                    add_internal_components(tab);

                    Vector<String> list_data = new Vector<String>();
                    for (int i = 0; i < all_files.get(tab).get("?__?").size(); i++)
                    {
                        String s = all_files.get(tab).get("?__?").get(i);
                        int start = s.length() - 5000;
                        if (start < 0)
                            start = 0;
                        list_data.addElement(s.substring(start, s.length()));
                    }
                    nondicomFiles_List.get(tab).setListData(list_data);
                    jTabbedPane3.get(tab).setTitleAt(subtab, tabname);
                }
                else
                {
                    add_internal_components(tab);
                    jTabbedPane3.get(tab).setTitleAt(subtab, tabname);
                    nondicomTabs_Select.get(tab).addItem(chosen);
                }

                for (Iterator choice_iterator = tabs_to_add.get(chosen).keySet().iterator(); choice_iterator.hasNext(); )
                {
                    String val = (String)choice_iterator.next();
//                    System.out.println("2) " + val + "; " + all_files.get(tab).get(val));
                    sliceCount_Value.get(tab).get(subtab).setText(String.valueOf(all_files.get(tab).get(val).size()));
                    seriesNameLocal_Value.get(tab).get(subtab).addItem(val);
                    seriesNameLocal_Value.get(tab).get(subtab).setSelectedIndex(0);
                    seriesNameLocal_Value.get(tab).get(subtab).setSelectedItem(val);
                    Pattern val_pattern = Pattern.compile("^(.*?)__(.*)$");
                    Matcher val_matcher = val_pattern.matcher(val);                
                    if (val_matcher.find())
                    {
                        val = val_matcher.group(2);
                    }
                    seriesNameStandard_Value.get(tab).get(subtab).addItem(val);
                    seriesNameStandard_Value.get(tab).get(subtab).setSelectedIndex(0);
                    seriesNameStandard_Value.get(tab).get(subtab).setSelectedItem(val);
                }
            }
            jTabbedPane3.get(tab).setSelectedIndex(0);
            //Simple bubble sort for the tabs
            for (int i = 1; i < jTabbedPane3.get(tab).getTabCount() - 1; i++)
            {
                for (int j = i + 1; j < jTabbedPane3.get(tab).getTabCount(); j++)
                {
                    if (jTabbedPane3.get(tab).getTitleAt(i).compareToIgnoreCase(jTabbedPane3.get(tab).getTitleAt(j)) > 0)
                    {
                        //Swap the two tabs
                        javax.swing.JButton button_temp;
                        javax.swing.JCheckBox checkbox_temp;
                        javax.swing.JComboBox combobox_temp;
                        
                        button_temp = seriesDescription_ModifyRule.get(tab).get(i);
                        seriesDescription_ModifyRule.get(tab).set(i, seriesDescription_ModifyRule.get(tab).get(j));
                        seriesDescription_ModifyRule.get(tab).set(j, button_temp);
                        checkbox_temp = seriesDescription_Select.get(tab).get(i);
                        seriesDescription_Select.get(tab).set(i, seriesDescription_Select.get(tab).get(j));
                        seriesDescription_Select.get(tab).set(j, checkbox_temp);
                        combobox_temp = seriesDescription_Value.get(tab).get(i);
                        seriesDescription_Value.get(tab).set(i, seriesDescription_Value.get(tab).get(j));
                        seriesDescription_Value.get(tab).set(j, combobox_temp);
                        
                        button_temp = seriesDiscardAcq_ModifyRule.get(tab).get(i);
                        seriesDiscardAcq_ModifyRule.get(tab).set(i, seriesDiscardAcq_ModifyRule.get(tab).get(j));
                        seriesDiscardAcq_ModifyRule.get(tab).set(j, button_temp);
                        checkbox_temp = seriesDiscardAcq_Select.get(tab).get(i);
                        seriesDiscardAcq_Select.get(tab).set(i, seriesDiscardAcq_Select.get(tab).get(j));
                        seriesDiscardAcq_Select.get(tab).set(j, checkbox_temp);
                        combobox_temp = seriesDiscardAcq_Value.get(tab).get(i);
                        seriesDiscardAcq_Value.get(tab).set(i, seriesDiscardAcq_Value.get(tab).get(j));
                        seriesDiscardAcq_Value.get(tab).set(j, combobox_temp);
                        
                        button_temp = seriesID_ModifyRule.get(tab).get(i);
                        seriesID_ModifyRule.get(tab).set(i, seriesID_ModifyRule.get(tab).get(j));
                        seriesID_ModifyRule.get(tab).set(j, button_temp);
                        checkbox_temp = seriesID_Select.get(tab).get(i);
                        seriesID_Select.get(tab).set(i, seriesID_Select.get(tab).get(j));
                        seriesID_Select.get(tab).set(j, checkbox_temp);
                        combobox_temp = seriesID_Value.get(tab).get(i);
                        seriesID_Value.get(tab).set(i, seriesID_Value.get(tab).get(j));
                        seriesID_Value.get(tab).set(j, combobox_temp);

                        button_temp = seriesNameLocal_ModifyRule.get(tab).get(i);
                        seriesNameLocal_ModifyRule.get(tab).set(i, seriesNameLocal_ModifyRule.get(tab).get(j));
                        seriesNameLocal_ModifyRule.get(tab).set(j, button_temp);
                        checkbox_temp = seriesNameLocal_Select.get(tab).get(i);
                        seriesNameLocal_Select.get(tab).set(i, seriesNameLocal_Select.get(tab).get(j));
                        seriesNameLocal_Select.get(tab).set(j, checkbox_temp);
                        combobox_temp = seriesNameLocal_Value.get(tab).get(i);
                        seriesNameLocal_Value.get(tab).set(i, seriesNameLocal_Value.get(tab).get(j));
                        seriesNameLocal_Value.get(tab).set(j, combobox_temp);
                        
                        button_temp = seriesNameStandard_ModifyRule.get(tab).get(i);
                        seriesNameStandard_ModifyRule.get(tab).set(i, seriesNameStandard_ModifyRule.get(tab).get(j));
                        seriesNameStandard_ModifyRule.get(tab).set(j, button_temp);
                        checkbox_temp = seriesNameStandard_Select.get(tab).get(i);
                        seriesNameStandard_Select.get(tab).set(i, seriesNameStandard_Select.get(tab).get(j));
                        seriesNameStandard_Select.get(tab).set(j, checkbox_temp);
                        combobox_temp = seriesNameStandard_Value.get(tab).get(i);
                        seriesNameStandard_Value.get(tab).set(i, seriesNameStandard_Value.get(tab).get(j));
                        seriesNameStandard_Value.get(tab).set(j, combobox_temp);
                        
                        button_temp = seriesNumber_ModifyRule.get(tab).get(i);
                        seriesNumber_ModifyRule.get(tab).set(i, seriesNumber_ModifyRule.get(tab).get(j));
                        seriesNumber_ModifyRule.get(tab).set(j, button_temp);
                        checkbox_temp = seriesNumber_Select.get(tab).get(i);
                        seriesNumber_Select.get(tab).set(i, seriesNumber_Select.get(tab).get(j));
                        seriesNumber_Select.get(tab).set(j, checkbox_temp);
                        combobox_temp = seriesNumber_Value.get(tab).get(i);
                        seriesNumber_Value.get(tab).set(i, seriesNumber_Value.get(tab).get(j));
                        seriesNumber_Value.get(tab).set(j, combobox_temp);
                        
                        button_temp = seriesParadigmVersion_ModifyRule.get(tab).get(i);
                        seriesParadigmVersion_ModifyRule.get(tab).set(i, seriesParadigmVersion_ModifyRule.get(tab).get(j));
                        seriesParadigmVersion_ModifyRule.get(tab).set(j, button_temp);
                        checkbox_temp = seriesParadigmVersion_Select.get(tab).get(i);
                        seriesParadigmVersion_Select.get(tab).set(i, seriesParadigmVersion_Select.get(tab).get(j));
                        seriesParadigmVersion_Select.get(tab).set(j, checkbox_temp);
                        combobox_temp = seriesParadigmVersion_Value.get(tab).get(i);
                        seriesParadigmVersion_Value.get(tab).set(i, seriesParadigmVersion_Value.get(tab).get(j));
                        seriesParadigmVersion_Value.get(tab).set(j, combobox_temp);
                        
                        button_temp = seriesParadigm_ModifyRule.get(tab).get(i);
                        seriesParadigm_ModifyRule.get(tab).set(i, seriesParadigm_ModifyRule.get(tab).get(j));
                        seriesParadigm_ModifyRule.get(tab).set(j, button_temp);
                        checkbox_temp = seriesParadigm_Select.get(tab).get(i);
                        seriesParadigm_Select.get(tab).set(i, seriesParadigm_Select.get(tab).get(j));
                        seriesParadigm_Select.get(tab).set(j, checkbox_temp);
                        combobox_temp = seriesParadigm_Value.get(tab).get(i);
                        seriesParadigm_Value.get(tab).set(i, seriesParadigm_Value.get(tab).get(j));
                        seriesParadigm_Value.get(tab).set(j, combobox_temp);
                        
                        button_temp = seriesDiscardAcq_ModifyRule.get(tab).get(i);
                        seriesDiscardAcq_ModifyRule.get(tab).set(i, seriesDiscardAcq_ModifyRule.get(tab).get(j));
                        seriesDiscardAcq_ModifyRule.get(tab).set(j, button_temp);
                        checkbox_temp = seriesDiscardAcq_Select.get(tab).get(i);
                        seriesDiscardAcq_Select.get(tab).set(i, seriesDiscardAcq_Select.get(tab).get(j));
                        seriesDiscardAcq_Select.get(tab).set(j, checkbox_temp);
                        combobox_temp = seriesDiscardAcq_Value.get(tab).get(i);
                        seriesDiscardAcq_Value.get(tab).set(i, seriesDiscardAcq_Value.get(tab).get(j));
                        seriesDiscardAcq_Value.get(tab).set(j, combobox_temp);
                        
                        button_temp = seriesSeriesTime_ModifyRule.get(tab).get(i);
                        seriesSeriesTime_ModifyRule.get(tab).set(i, seriesSeriesTime_ModifyRule.get(tab).get(j));
                        seriesSeriesTime_ModifyRule.get(tab).set(j, button_temp);
                        checkbox_temp = seriesSeriesTime_Select.get(tab).get(i);
                        seriesSeriesTime_Select.get(tab).set(i, seriesSeriesTime_Select.get(tab).get(j));
                        seriesSeriesTime_Select.get(tab).set(j, checkbox_temp);
                        combobox_temp = seriesSeriesTime_Value.get(tab).get(i);
                        seriesSeriesTime_Value.get(tab).set(i, seriesSeriesTime_Value.get(tab).get(j));
                        seriesSeriesTime_Value.get(tab).set(j, combobox_temp);
                        
                        button_temp = seriesSliceOrder_ModifyRule.get(tab).get(i);
                        seriesSliceOrder_ModifyRule.get(tab).set(i, seriesSliceOrder_ModifyRule.get(tab).get(j));
                        seriesSliceOrder_ModifyRule.get(tab).set(j, button_temp);
                        checkbox_temp = seriesSliceOrder_Select.get(tab).get(i);
                        seriesSliceOrder_Select.get(tab).set(i, seriesSliceOrder_Select.get(tab).get(j));
                        seriesSliceOrder_Select.get(tab).set(j, checkbox_temp);
                        combobox_temp = seriesSliceOrder_Value.get(tab).get(i);
                        seriesSliceOrder_Value.get(tab).set(i, seriesSliceOrder_Value.get(tab).get(j));
                        seriesSliceOrder_Value.get(tab).set(j, combobox_temp);
                        
                        button_temp = seriesType_ModifyRule.get(tab).get(i);
                        seriesType_ModifyRule.get(tab).set(i, seriesType_ModifyRule.get(tab).get(j));
                        seriesType_ModifyRule.get(tab).set(j, button_temp);
                        checkbox_temp = seriesType_Select.get(tab).get(i);
                        seriesType_Select.get(tab).set(i, seriesType_Select.get(tab).get(j));
                        seriesType_Select.get(tab).set(j, checkbox_temp);
                        combobox_temp = seriesType_Value.get(tab).get(i);
                        seriesType_Value.get(tab).set(i, seriesType_Value.get(tab).get(j));
                        seriesType_Value.get(tab).set(j, combobox_temp);
                        
                        //Swap names.
                        String temp_str = jTabbedPane3.get(tab).getTitleAt(i);
                        jTabbedPane3.get(tab).setTitleAt(i, jTabbedPane3.get(tab).getTitleAt(j));
                        jTabbedPane3.get(tab).setTitleAt(j, temp_str);
                        
                        //Swap tabcounts
                        temp_str = sliceCount_Value.get(tab).get(i).getText();
                        sliceCount_Value.get(tab).get(i).setText(sliceCount_Value.get(tab).get(j).getText());
                        sliceCount_Value.get(tab).get(j).setText(temp_str);
                    }
                }
            }
        }
        redraw();
    }

    

    private ArrayList<String> build_file_list(String path)
    {
        File directory;
        ArrayList<String> ret = new ArrayList<String>();        
        try
        {
            directory = new File(path);
        }
        catch(Exception e)
        {
            System.out.println("ERROR: Could not parse directory.");
            return ret;
        }

        String[] content_list = directory.list();
        for(int i = 0; i < content_list.length; i++)
        {
            String fname = path + "/" + content_list[i];
            File sub_file = new File(fname);
            if(sub_file.exists())
            {
                if(sub_file.isDirectory())
                {
                    ArrayList<String> sub_ret = build_file_list(fname);
                    for (Iterator sub_ret_iterator = sub_ret.iterator(); sub_ret_iterator.hasNext(); )
                    {
                        String sub_ret_str = (String)sub_ret_iterator.next();
                        ret.add(sub_ret_str);                        
                    }
                }
                else if(sub_file.isFile())
                {
                    ret.add(fname);
                }
            }            
            else
            {
//                System.out.println(i + " *" + path + "//" + sub_file.getName() + "::::Neither a file nor a directory");
            }
        }
        return ret;
    }

    
    private void SelectNoneInSeriesMouseClicked() {
        int tab = jTabbedPane1.getSelectedIndex();
        int selected_subtab = jTabbedPane3.get(tab).getSelectedIndex();

        int subtab_start, subtab_end;
        subtab_start = selected_subtab;
        if (selected_subtab == 0)
            subtab_end = jTabbedPane3.get(tab).getTabCount();
        else
            subtab_end = selected_subtab + 1;

        for (int subtab = subtab_start; subtab < subtab_end; subtab++)
        {
            seriesNameLocal_Select.get(tab).get(subtab).setSelected(false);
            seriesNameStandard_Select.get(tab).get(subtab).setSelected(false);
            seriesID_Select.get(tab).get(subtab).setSelected(false);
            seriesSeriesTime_Select.get(tab).get(subtab).setSelected(false);
            seriesDescription_Select.get(tab).get(subtab).setSelected(false);
            seriesType_Select.get(tab).get(subtab).setSelected(false);
            seriesParadigm_Select.get(tab).get(subtab).setSelected(false);
            seriesParadigmVersion_Select.get(tab).get(subtab).setSelected(false);
            seriesNumber_Select.get(tab).get(subtab).setSelected(false);
            seriesSliceOrder_Select.get(tab).get(subtab).setSelected(false);
            seriesDiscardAcq_Select.get(tab).get(subtab).setSelected(false);
        }
    }

    private void SelectAllInSeriesMouseClicked() {
        int tab = jTabbedPane1.getSelectedIndex();
        int selected_subtab = jTabbedPane3.get(tab).getSelectedIndex();

        int subtab_start, subtab_end;
        subtab_start = selected_subtab;
        if (selected_subtab == 0)
            subtab_end = jTabbedPane3.get(tab).getTabCount();
        else
            subtab_end = selected_subtab + 1;

        for (int subtab = subtab_start; subtab < subtab_end; subtab++)
        {
            seriesNameLocal_Select.get(tab).get(subtab).setSelected(true);
            seriesNameStandard_Select.get(tab).get(subtab).setSelected(true);
            seriesID_Select.get(tab).get(subtab).setSelected(true);
            seriesSeriesTime_Select.get(tab).get(subtab).setSelected(true);
            seriesDescription_Select.get(tab).get(subtab).setSelected(true);
            seriesType_Select.get(tab).get(subtab).setSelected(true);
            seriesParadigm_Select.get(tab).get(subtab).setSelected(true);
            seriesParadigmVersion_Select.get(tab).get(subtab).setSelected(true);
            seriesNumber_Select.get(tab).get(subtab).setSelected(true);
            seriesSliceOrder_Select.get(tab).get(subtab).setSelected(true);
            seriesDiscardAcq_Select.get(tab).get(subtab).setSelected(true);
        }
    }

    private void NewSeriesMouseClicked()
    {
        int tab = jTabbedPane1.getSelectedIndex();
        int subtab = jTabbedPane3.get(tab).getTabCount();
        add_internal_components(tab);
        jTabbedPane3.get(tab).setSelectedIndex(subtab);
        shrink_window();
    }                                        
    
    private void DuplicateSeriesMouseClicked()
    {
        int tab = jTabbedPane1.getSelectedIndex();
        int subtab = jTabbedPane3.get(tab).getTabCount();
        int orig_subtab = jTabbedPane3.get(tab).getSelectedIndex();
        add_internal_components(tab);
        jTabbedPane3.get(tab).setSelectedIndex(subtab);

        seriesNameLocal_Select.get(tab).get(subtab).setSelected(seriesNameLocal_Select.get(tab).get(orig_subtab).isSelected());
        seriesNameStandard_Select.get(tab).get(subtab).setSelected(seriesNameStandard_Select.get(tab).get(orig_subtab).isSelected());
        seriesID_Select.get(tab).get(subtab).setSelected(seriesID_Select.get(tab).get(orig_subtab).isSelected());
        seriesSeriesTime_Select.get(tab).get(subtab).setSelected(seriesSeriesTime_Select.get(tab).get(orig_subtab).isSelected());
        seriesDescription_Select.get(tab).get(subtab).setSelected(seriesDescription_Select.get(tab).get(orig_subtab).isSelected());
        seriesType_Select.get(tab).get(subtab).setSelected(seriesType_Select.get(tab).get(orig_subtab).isSelected());
        seriesParadigm_Select.get(tab).get(subtab).setSelected(seriesParadigm_Select.get(tab).get(orig_subtab).isSelected());
        seriesParadigmVersion_Select.get(tab).get(subtab).setSelected(seriesParadigmVersion_Select.get(tab).get(orig_subtab).isSelected());
        seriesNumber_Select.get(tab).get(subtab).setSelected(seriesNumber_Select.get(tab).get(orig_subtab).isSelected());
        seriesSliceOrder_Select.get(tab).get(subtab).setSelected(seriesSliceOrder_Select.get(tab).get(orig_subtab).isSelected());
        seriesDiscardAcq_Select.get(tab).get(subtab).setSelected(seriesDiscardAcq_Select.get(tab).get(orig_subtab).isSelected());

        for (int i = 0; i < seriesNameLocal_Value.get(tab).get(subtab).getComponentCount(); i++)
            seriesNameLocal_Value.get(tab).get(subtab).add(seriesNameLocal_Value.get(tab).get(subtab).getComponent(i));
        seriesNameLocal_Value.get(tab).get(subtab).setSelectedIndex(seriesNameLocal_Value.get(tab).get(orig_subtab).getSelectedIndex());
        seriesNameLocal_Value.get(tab).get(subtab).setSelectedItem(seriesNameLocal_Value.get(tab).get(orig_subtab).getSelectedItem());
        for (int i = 0; i < seriesNameStandard_Value.get(tab).get(subtab).getComponentCount(); i++)
            seriesNameStandard_Value.get(tab).get(subtab).add(seriesNameStandard_Value.get(tab).get(subtab).getComponent(i));
        seriesNameStandard_Value.get(tab).get(subtab).setSelectedIndex(seriesNameStandard_Value.get(tab).get(orig_subtab).getSelectedIndex());
        seriesNameStandard_Value.get(tab).get(subtab).setSelectedItem(seriesNameStandard_Value.get(tab).get(orig_subtab).getSelectedItem());
        for (int i = 0; i < seriesID_Value.get(tab).get(subtab).getComponentCount(); i++)
            seriesID_Value.get(tab).get(subtab).add(seriesID_Value.get(tab).get(subtab).getComponent(i));
        seriesID_Value.get(tab).get(subtab).setSelectedIndex(seriesID_Value.get(tab).get(orig_subtab).getSelectedIndex());
        seriesID_Value.get(tab).get(subtab).setSelectedItem(seriesID_Value.get(tab).get(orig_subtab).getSelectedItem());
        for (int i = 0; i < seriesSeriesTime_Value.get(tab).get(subtab).getComponentCount(); i++)
            seriesSeriesTime_Value.get(tab).get(subtab).add(seriesSeriesTime_Value.get(tab).get(subtab).getComponent(i));
        seriesSeriesTime_Value.get(tab).get(subtab).setSelectedIndex(seriesSeriesTime_Value.get(tab).get(orig_subtab).getSelectedIndex());
        seriesSeriesTime_Value.get(tab).get(subtab).setSelectedItem(seriesSeriesTime_Value.get(tab).get(orig_subtab).getSelectedItem());
        for (int i = 0; i < seriesDescription_Value.get(tab).get(subtab).getComponentCount(); i++)
            seriesDescription_Value.get(tab).get(subtab).add(seriesDescription_Value.get(tab).get(subtab).getComponent(i));
        seriesDescription_Value.get(tab).get(subtab).setSelectedIndex(seriesDescription_Value.get(tab).get(orig_subtab).getSelectedIndex());
        seriesDescription_Value.get(tab).get(subtab).setSelectedItem(seriesDescription_Value.get(tab).get(orig_subtab).getSelectedItem());
        for (int i = 0; i < seriesType_Value.get(tab).get(subtab).getComponentCount(); i++)
            seriesType_Value.get(tab).get(subtab).add(seriesType_Value.get(tab).get(subtab).getComponent(i));
        seriesType_Value.get(tab).get(subtab).setSelectedIndex(seriesType_Value.get(tab).get(orig_subtab).getSelectedIndex());
        seriesType_Value.get(tab).get(subtab).setSelectedItem(seriesType_Value.get(tab).get(orig_subtab).getSelectedItem());
        for (int i = 0; i < seriesParadigm_Value.get(tab).get(subtab).getComponentCount(); i++)
            seriesParadigm_Value.get(tab).get(subtab).add(seriesParadigm_Value.get(tab).get(subtab).getComponent(i));
        seriesParadigm_Value.get(tab).get(subtab).setSelectedIndex(seriesParadigm_Value.get(tab).get(orig_subtab).getSelectedIndex());
        seriesParadigm_Value.get(tab).get(subtab).setSelectedItem(seriesParadigm_Value.get(tab).get(orig_subtab).getSelectedItem());
        for (int i = 0; i < seriesParadigmVersion_Value.get(tab).get(subtab).getComponentCount(); i++)
            seriesParadigmVersion_Value.get(tab).get(subtab).add(seriesParadigmVersion_Value.get(tab).get(subtab).getComponent(i));
        seriesParadigmVersion_Value.get(tab).get(subtab).setSelectedIndex(seriesParadigmVersion_Value.get(tab).get(orig_subtab).getSelectedIndex());
        seriesParadigmVersion_Value.get(tab).get(subtab).setSelectedItem(seriesParadigmVersion_Value.get(tab).get(orig_subtab).getSelectedItem());
        for (int i = 0; i < seriesNumber_Value.get(tab).get(subtab).getComponentCount(); i++)
            seriesNumber_Value.get(tab).get(subtab).add(seriesNumber_Value.get(tab).get(subtab).getComponent(i));
        seriesNumber_Value.get(tab).get(subtab).setSelectedIndex(seriesNumber_Value.get(tab).get(orig_subtab).getSelectedIndex());
        seriesNumber_Value.get(tab).get(subtab).setSelectedItem(seriesNumber_Value.get(tab).get(orig_subtab).getSelectedItem());
        for (int i = 0; i < seriesSliceOrder_Value.get(tab).get(subtab).getComponentCount(); i++)
            seriesSliceOrder_Value.get(tab).get(subtab).add(seriesSliceOrder_Value.get(tab).get(subtab).getComponent(i));
        seriesSliceOrder_Value.get(tab).get(subtab).setSelectedIndex(seriesSliceOrder_Value.get(tab).get(orig_subtab).getSelectedIndex());
        seriesSliceOrder_Value.get(tab).get(subtab).setSelectedItem(seriesSliceOrder_Value.get(tab).get(orig_subtab).getSelectedItem());
        for (int i = 0; i < seriesDiscardAcq_Value.get(tab).get(subtab).getComponentCount(); i++)
            seriesDiscardAcq_Value.get(tab).get(subtab).add(seriesDiscardAcq_Value.get(tab).get(subtab).getComponent(i));
        seriesDiscardAcq_Value.get(tab).get(subtab).setSelectedIndex(seriesDiscardAcq_Value.get(tab).get(orig_subtab).getSelectedIndex());
        seriesDiscardAcq_Value.get(tab).get(subtab).setSelectedItem(seriesDiscardAcq_Value.get(tab).get(orig_subtab).getSelectedItem());

        if (seriesNameStandard_Value.get(tab).get(subtab).getSelectedItem() != null)
            jTabbedPane3.get(tab).setTitleAt(subtab, seriesNameStandard_Value.get(tab).get(subtab).getSelectedItem().toString());

        shrink_window();
    }
    
    private void DeleteSeriesMouseClicked()
    {
        int tab = jTabbedPane1.getSelectedIndex();
        int subtab = jTabbedPane3.get(tab).getSelectedIndex();
        
        if (subtab == 0)
            return;

        seriesNameLocal_ModifyRule.get(tab).remove(subtab);
        seriesNameLocal_Select.get(tab).remove(subtab);
        seriesNameStandard_Select.get(tab).remove(subtab);
        seriesID_Select.get(tab).remove(subtab);
        seriesSeriesTime_Select.get(tab).remove(subtab);
        seriesDescription_Select.get(tab).remove(subtab);
        seriesType_Select.get(tab).remove(subtab);
        seriesNameStandard_ModifyRule.get(tab).remove(subtab);
        seriesID_ModifyRule.get(tab).remove(subtab);
        seriesSeriesTime_ModifyRule.get(tab).remove(subtab);
        seriesDescription_ModifyRule.get(tab).remove(subtab);
        seriesType_ModifyRule.get(tab).remove(subtab);
        seriesParadigm_ModifyRule.get(tab).remove(subtab);
        seriesParadigmVersion_ModifyRule.get(tab).remove(subtab);
        seriesNumber_ModifyRule.get(tab).remove(subtab);
        seriesSliceOrder_ModifyRule.get(tab).remove(subtab);
        seriesDiscardAcq_ModifyRule.get(tab).remove(subtab);
        seriesParadigm_Select.get(tab).remove(subtab);
        seriesParadigmVersion_Select.get(tab).remove(subtab);
        seriesNumber_Select.get(tab).remove(subtab);
        seriesSliceOrder_Select.get(tab).remove(subtab);
        seriesDiscardAcq_Select.get(tab).remove(subtab);
        seriesParadigmVersion_Value.get(tab).remove(subtab);
        seriesParadigm_Value.get(tab).remove(subtab);
        seriesNumber_Value.get(tab).remove(subtab);
        seriesSliceOrder_Value.get(tab).remove(subtab);
        seriesDiscardAcq_Value.get(tab).remove(subtab);
        seriesNameStandard_Value.get(tab).remove(subtab);
        seriesNameLocal_Value.get(tab).remove(subtab);
        seriesID_Value.get(tab).remove(subtab);
        seriesSeriesTime_Value.get(tab).remove(subtab);
        seriesDescription_Value.get(tab).remove(subtab);
        seriesType_Value.get(tab).remove(subtab);
        jPanel8.get(tab).remove(subtab);
        jSeparator8.get(tab).remove(subtab);
        
        jTabbedPane3.get(tab).remove(subtab);
                
        int count = jTabbedPane3.get(tab).getTabCount();
        if (count > subtab)
            jTabbedPane3.get(tab).setSelectedIndex(subtab);
        else
            jTabbedPane3.get(tab).setSelectedIndex(count - 1);
        shrink_window();
    }
    
    public void nondicomMove_ButtonMouseClicked()
    {
        int tab = jTabbedPane1.getSelectedIndex();
//        int subtab_id = jTabbedPane3.get(tab).getTabCount();
        String subtab = "?__?";
        String new_subtab = nondicomTabs_Select.get(tab).getSelectedItem().toString();
        int new_subtab_id = -1;
        for (int i = 0; i < jTabbedPane3.get(tab).getTabCount(); i++)
        {
//            System.out.println(i + ": " + jTabbedPane3.get(tab).getTitleAt(i));
            if (jTabbedPane3.get(tab).getTitleAt(i).equals("?") || jTabbedPane3.get(tab).getTitleAt(i).equals("Master"))
                continue;
            if (seriesNameLocal_Value.get(tab).get(i).getSelectedItem().toString().equals(new_subtab))
                new_subtab_id = i;
        }
              
        String file = nondicomFiles_List.get(tab).getSelectedValue().toString();

        all_files.get(tab).get(new_subtab).add(file);
        all_files.get(tab).get(subtab).remove(file);
        sliceCount_Value.get(tab).get(new_subtab_id).setText(String.valueOf(all_files.get(tab).get(new_subtab).size()));
//                    all_files.get(tab).get(chosen).add(file);
        String newdir = Basepath.get(tab).getText() + "/" + new_subtab;
        String newfile = newdir + "/" + basename(file.replaceAll(Basepath.get(tab).getText(), newdir));
        String old_reloc = all_files_reloc.get(file);
        all_files_reloc.put(file, newfile);
//        System.out.println(file + "; " + newdir + "; " + newfile);
        new File(newdir).mkdirs();
        try
        {
            FileInputStream fis  = new FileInputStream(new File(file));
            FileOutputStream fos = new FileOutputStream(new File(newfile));
            byte[] buf = new byte[1024];
            int i = 0;
            while ((i = fis.read(buf)) != -1)
            {
               fos.write(buf, 0, i);
            }
            fis.close();
            fos.close();
            
            new File(old_reloc).delete();
            Vector<String> list_data = new Vector<String>();
            for (int j = 0; j < all_files.get(tab).get("?__?").size(); j++)
            {
                list_data.addElement(all_files.get(tab).get("?__?").get(j));
            }
            nondicomFiles_List.get(tab).setListData(list_data);
        }
        catch (Exception e)
        {
            System.out.println("IO error copying file " + file + " to " + newdir);
        }
//        all_files_databases.get(tab).SOMEHOW_WRITE_THE_ENTRY_FOR_FILE_TO_NEWFILE();
    }
    
    
    public void set_children_text_from_master(ArrayList<javax.swing.JComboBox> box_list, int cur_tab)
    {
        if (box_list.get(cur_tab).getSelectedItem() == null)
            return;

        String value = box_list.get(cur_tab).getSelectedItem().toString();
        if (cur_tab == 0)
        {
            int tab_start = 1;
            int tab_end = jTabbedPane1.getTabCount();
    
            for (int tab = tab_start; tab < tab_end; tab++)
            {
                box_list.get(tab).removeAllItems();
                box_list.get(tab).addItem(value);
                box_list.get(tab).setSelectedIndex(0);
                box_list.get(tab).setSelectedItem(value);
            }
        }
    }
                    
    public void set_children_text_from_master_subtab(ArrayList< ArrayList<javax.swing.JComboBox> > box_list, int cur_tab, int cur_subtab)
    {
        if (box_list.get(cur_tab).get(cur_subtab).getSelectedItem() == null)
            return;

        String value = box_list.get(cur_tab).get(cur_subtab).getSelectedItem().toString();
        if (cur_tab == 0)
        {
            int tab_start = 0;
            int tab_end = jTabbedPane1.getTabCount();
    
            for (int tab = tab_start; tab < tab_end; tab++)
            {
                if (cur_subtab == 0)
                {
                    int subtab_start = 1;
                    int subtab_end = jTabbedPane3.get(tab).getTabCount();
            
                    for (int subtab = subtab_start; subtab < subtab_end; subtab++)
                    {
                        box_list.get(tab).get(subtab).removeAllItems();
                        box_list.get(tab).get(subtab).addItem(value);
                        box_list.get(tab).get(subtab).setSelectedIndex(0);
                        box_list.get(tab).get(subtab).setSelectedItem(value);
                    }
                }
                else
                {
                    box_list.get(tab).get(cur_subtab).removeAllItems();
                    box_list.get(tab).get(cur_subtab).addItem(value);
                    box_list.get(tab).get(cur_subtab).setSelectedIndex(0);
                    box_list.get(tab).get(cur_subtab).setSelectedItem(value);
                }
            }
        }
        else if (cur_subtab == 0)
        {
            int subtab_start = 1;
            int subtab_end = jTabbedPane3.get(cur_tab).getTabCount();
    
            for (int subtab = subtab_start; subtab < subtab_end; subtab++)
            {
                box_list.get(cur_tab).get(subtab).removeAllItems();
                box_list.get(cur_tab).get(subtab).addItem(value);
                box_list.get(cur_tab).get(subtab).setSelectedIndex(0);
                box_list.get(cur_tab).get(subtab).setSelectedItem(value);
            }
        }
    }
                    
    public String dirname(String path)
    {
        return path.substring(0, path.lastIndexOf('/'));
    }

    public String basename(String path)
    {
        return path.substring(path.lastIndexOf('/'));
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new UploadUI().setVisible(true);
            }
        });
    }
    
    private ArrayList<javax.swing.JButton> ApplySelectedRules;
    private ArrayList<javax.swing.JButton> BIRNID_ModifyRule;
    private ArrayList<javax.swing.JCheckBox> BIRNID_Select;
    private ArrayList<javax.swing.JComboBox> BIRNID_Value;
    private ArrayList<javax.swing.JButton> DeleteSeries;
    private ArrayList<javax.swing.JButton> DuplicateSeries;
    private ArrayList<javax.swing.JButton> FileSystem_ModifyRule;
    private ArrayList<javax.swing.JCheckBox> FileSystem_Select;
    private ArrayList<javax.swing.JComboBox> FileSystem_Value;
    private ArrayList<javax.swing.JButton> GenerateAll_Button;
    private ArrayList<javax.swing.JButton> GenerateAll_ModifyRule;
    private ArrayList<javax.swing.JButton> MergeXML;
    private ArrayList<javax.swing.JButton> NewSeries;
    private ArrayList<javax.swing.JButton> Configure;
    private ArrayList<javax.swing.JButton> OpenDir;
    private ArrayList<javax.swing.JButton> CloseDir;
    private ArrayList<javax.swing.JButton> Save;
    private ArrayList<javax.swing.JButton> SelectAllInSeries;
    private ArrayList<javax.swing.JButton> SelectAll;
    private ArrayList<javax.swing.JButton> SelectNoneInSeries;
    private ArrayList<javax.swing.JButton> SelectNone;
    private ArrayList<javax.swing.JButton> acquisitionSiteID_ModifyRule;
    private ArrayList<javax.swing.JCheckBox> acquisitionSiteID_Select;
    private ArrayList<javax.swing.JComboBox> acquisitionSiteID_Value;
    private ArrayList<javax.swing.JPanel> jPanel1;
    private ArrayList<javax.swing.JPanel> jPanel3;
    private ArrayList<javax.swing.JPanel> jPanel6;
    private ArrayList<javax.swing.JPanel> jPanel7;
    private ArrayList<ArrayList<javax.swing.JPanel> > jPanel8;
    private ArrayList<javax.swing.JSeparator> jSeparator2;
    private ArrayList<javax.swing.JSeparator> jSeparator6;
    private ArrayList<ArrayList<javax.swing.JSeparator> > jSeparator8;
    private javax.swing.JTabbedPane jTabbedPane1;
    private ArrayList<javax.swing.JTabbedPane> jTabbedPane3;
    private ArrayList<javax.swing.JButton> projectID_ModifyRule;
    private ArrayList<javax.swing.JCheckBox> projectID_Select;
    private ArrayList<javax.swing.JComboBox> projectID_Value;
    private ArrayList<javax.swing.JButton> projectName_ModifyRule;
    private ArrayList<javax.swing.JCheckBox> projectName_Select;
    private ArrayList<javax.swing.JComboBox> projectName_Value;
    private ArrayList<javax.swing.JButton> scannerID_ModifyRule;
    private ArrayList<javax.swing.JCheckBox> scannerID_Select;
    private ArrayList<javax.swing.JComboBox> scannerID_Value;
    private ArrayList<javax.swing.JButton> scannerManufacturer_ModifyRule;
    private ArrayList<javax.swing.JCheckBox> scannerManufacturer_Select;
    private ArrayList<javax.swing.JComboBox> scannerManufacturer_Value;
    private ArrayList<ArrayList<javax.swing.JButton> > seriesDescription_ModifyRule;
    private ArrayList<ArrayList<javax.swing.JCheckBox> > seriesDescription_Select;
    private ArrayList<ArrayList<javax.swing.JComboBox> > seriesDescription_Value;
    private ArrayList<ArrayList<javax.swing.JButton> > seriesDiscardAcq_ModifyRule;
    private ArrayList<ArrayList<javax.swing.JCheckBox> > seriesDiscardAcq_Select;
    private ArrayList<ArrayList<javax.swing.JComboBox> > seriesDiscardAcq_Value;
    private ArrayList<ArrayList<javax.swing.JButton> > seriesID_ModifyRule;
    private ArrayList<ArrayList<javax.swing.JCheckBox> > seriesID_Select;
    private ArrayList<ArrayList<javax.swing.JComboBox> > seriesID_Value;
    private ArrayList<ArrayList<javax.swing.JButton> > seriesNameLocal_ModifyRule;
    private ArrayList<ArrayList<javax.swing.JCheckBox> > seriesNameLocal_Select;
    private ArrayList<ArrayList<javax.swing.JComboBox> > seriesNameLocal_Value;
    private ArrayList<ArrayList<javax.swing.JButton> > seriesNameStandard_ModifyRule;
    private ArrayList<ArrayList<javax.swing.JCheckBox> > seriesNameStandard_Select;
    private ArrayList<ArrayList<javax.swing.JComboBox> > seriesNameStandard_Value;
    private ArrayList<ArrayList<javax.swing.JButton> > seriesNumber_ModifyRule;
    private ArrayList<ArrayList<javax.swing.JCheckBox> > seriesNumber_Select;
    private ArrayList<ArrayList<javax.swing.JComboBox> > seriesNumber_Value;
    private ArrayList<ArrayList<javax.swing.JButton> > seriesParadigmVersion_ModifyRule;
    private ArrayList<ArrayList<javax.swing.JCheckBox> > seriesParadigmVersion_Select;
    private ArrayList<ArrayList<javax.swing.JComboBox> > seriesParadigmVersion_Value;
    private ArrayList<ArrayList<javax.swing.JButton> > seriesParadigm_ModifyRule;
    private ArrayList<ArrayList<javax.swing.JCheckBox> > seriesParadigm_Select;
    private ArrayList<ArrayList<javax.swing.JComboBox> > seriesParadigm_Value;
    private ArrayList<ArrayList<javax.swing.JButton> > seriesSeriesTime_ModifyRule;
    private ArrayList<ArrayList<javax.swing.JCheckBox> > seriesSeriesTime_Select;
    private ArrayList<ArrayList<javax.swing.JComboBox> > seriesSeriesTime_Value;
    private ArrayList<ArrayList<javax.swing.JCheckBox> > seriesSliceOrder_Select;
    private ArrayList<ArrayList<javax.swing.JComboBox> > seriesSliceOrder_Value;
    private ArrayList<ArrayList<javax.swing.JButton> > seriesSliceOrder_ModifyRule;
    private ArrayList<ArrayList<javax.swing.JButton> > seriesType_ModifyRule;
    private ArrayList<ArrayList<javax.swing.JCheckBox> > seriesType_Select;
    private ArrayList<ArrayList<javax.swing.JComboBox> > seriesType_Value;
    private ArrayList<javax.swing.JButton> studyDescription_ModifyRule;
    private ArrayList<javax.swing.JCheckBox> studyDescription_Select;
    private ArrayList<javax.swing.JComboBox> studyDescription_Value;
    private ArrayList<javax.swing.JButton> studyID_ModifyRule;
    private ArrayList<javax.swing.JCheckBox> studyID_Select;
    private ArrayList<javax.swing.JComboBox> studyID_Value;
    private ArrayList<javax.swing.JButton> studyName_ModifyRule;
    private ArrayList<javax.swing.JCheckBox> studyName_Select;
    private ArrayList<javax.swing.JComboBox> studyName_Value;
    private ArrayList<javax.swing.JButton> studyStudyTime_ModifyRule;
    private ArrayList<javax.swing.JCheckBox> studyStudyTime_Select;
    private ArrayList<javax.swing.JComboBox> studyStudyTime_Value;
    private ArrayList<javax.swing.JButton> subjectGroup_ModifyRule;
    private ArrayList<javax.swing.JCheckBox> subjectGroup_Select;
    private ArrayList<javax.swing.JComboBox> subjectGroup_Value;
    private ArrayList<javax.swing.JButton> visitDescription_ModifyRule;
    private ArrayList<javax.swing.JCheckBox> visitDescription_Select;
    private ArrayList<javax.swing.JComboBox> visitDescription_Value;
    private ArrayList<javax.swing.JButton> visitID_ModifyRule;
    private ArrayList<javax.swing.JCheckBox> visitID_Select;
    private ArrayList<javax.swing.JComboBox> visitID_Value;
    private ArrayList<javax.swing.JButton> visitName_ModifyRule;
    private ArrayList<javax.swing.JCheckBox> visitName_Select;
    private ArrayList<javax.swing.JComboBox> visitName_Value;
    private ArrayList<javax.swing.JButton> visitVisitDate_ModifyRule;
    private ArrayList<javax.swing.JCheckBox> visitVisitDate_Select;
    private ArrayList<javax.swing.JComboBox> visitVisitDate_Value;
    private ArrayList<javax.swing.JButton> visitVisitType_ModifyRule;
    private ArrayList<javax.swing.JCheckBox> visitVisitType_Select;
    private ArrayList<javax.swing.JComboBox> visitVisitType_Value;
    private ArrayList<ArrayList<javax.swing.JTextField> > sliceCount_Value;
    private ArrayList<ArrayList<javax.swing.JButton> > displaySeries_Button;
    private ArrayList<javax.swing.JComboBox> nondicomTabs_Select;
    private ArrayList<javax.swing.JList> nondicomFiles_List;
    private ArrayList<javax.swing.JScrollPane> nondicomFiles_ListScroll;
    private ArrayList<javax.swing.JButton> nondicomMove_Button;

    private ArrayList<javax.swing.JLabel> Basepath;
    private ArrayList<HashMap<String, RuleGroup>> rules;
    private javax.swing.JFileChooser ConfigureChooser;
    private javax.swing.JFileChooser OpenDirChooser;
    private javax.swing.JFileChooser MergeFileChooser;
    private javax.swing.JFileChooser SaveFileChooser;
    private String last_seriesNameLocal_Value;
    private ArrayList<HashMap<String, ArrayList<String> > > all_files;
    private ArrayList<DatabaseInformationModel> all_files_databases;
    private HashMap<String, String> all_files_reloc;
    private ArrayList<HashMap<String, String> > all_tabs_instance_UIDs;
    
    private int orig_jpanel7_height;
    private int jpanel3_target_height;
}
